<?php
/*
* $Id: init.form400.func.php,v 1.2 2011-05-17 14:08:33 light Exp $
*
* $Log: init.form400.func.php,v $
* Revision 1.2  2011-05-17 14:08:33  light
* Bug #7585 - PHP5 fixes
*
* Revision 1.1  2010-01-11 17:39:27  light
* Bug #6622 - User Prefences (Default page & Email templates)
*
*
*/

require_once(__DIR__ . '/db.pf_field.php');
require_once(__DIR__ . '/db.pf_option.php');
require_once(__DIR__ . '/functions.templates.php');

function UserPrefsUpdateAccess() {
	if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5) {
		return true;
	} else {
		return false;
	}
}

function UserPrefsManagementAccess() {
	
	if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 10 && $GLOBALS['userStatusId'] > 1) {
		return true;
	} else {
		return false;
	}
}


function BuildHomePageControl($level, $job_desc, $job_id){
	
	
	$showControls = false;

	switch ($level){
	case 'user':
		if (UserPrefsUpdateAccess()) $showControls = true;
		break;
	case 'environment':
		if (UserPrefsManagementAccess()) $showControls = true;
		break;		
	case 'global':
		if (UserPrefsManagementAccess() && $GLOBALS['lDB']->isMaster = "1" && $GLOBALS['isPropServer'] != "1") $showControls = true;
		break;				
	default:
		if (UserPrefsManagementAccess()) $showControls = true;
		break;
	
	}

	$controlHTML = "
				<tr>
					<td></td>
					<td>!SearchButton!</td>
					<td>
						<input type=\"hidden\" name=\"!txtId!\" id=\"!txtId!\" value=\"!txtIdValue!\">
						<input type=\"text\" name=\"!txtDesc!\" id=\"!txtDesc!\" style=\"width:230px; height: 20px;\" value=\"!txtDescValue!\" !textDisabled!>&nbsp;
					</td>
					<td>
						!ClearButton!
					</td>
					<td>
						!UseCurrentButton!
					</td>					
				  <td>            
	
				  </td>
				</tr>
	";


	$control['levelName'] = ucfirst($level);
	$control['txtDesc'] = $level."_job_desc";
	$control['txtDescValue'] = $job_desc;
	$control['txtId'] = $level."_job_id";
	$control['txtIdValue'] = $job_id;
	
	if ($showControls){
		if ($GLOBALS['temp']['canUseCurrent']){
			$control['UseCurrentButton'] = "
						<button id=\"btnUseCurrent\" type=\"button\" class=\"button\" style=\"width: 80px; text-align='center'; margin-top: -14px;\" onClick=\"setHomepage(".$GLOBALS['temp']['referringJob'].",'".$level."');\">
							Use Current
						</button>
						";
		} else {
			$control['UseCurrentButton'] = "";			
		}
		$control['SearchButton'] = "
						<button id=\"btn".ucfirst($level)."Homepage\" class=\"button\" type=\"button\" style=\" width: 50px; text-align:center; margin-top: -14px;\" onClick=\"popupSearch(this,'".$level."');\">
							".ucfirst($level)."
						</button>";	

		$control['ClearButton'] = "
						<button id=\"btnClr".ucfirst($level)."\" type=\"button\" class=\"button\" style=\"margin-top: -14px;\" onClick=\"clearConfirm('".$level."_job_id');\" >
							<img src=\"/resource/Resrequest/Application/public/img/button_close_16.gif\" width=\"16\" height=\"16\"/>
						</button>";									
		$control['textDisabled'] = "";						
	} else {
		$control['UseCurrentButton'] = "";
		$control['SearchButton'] = "";
		$control['ClearButton'] = "";
		$control['textDisabled'] = "disabled";	
	}
	
	return showpage($control,$controlHTML);

}


function homepageAction($linklevel, $link_id = false, $job_id) {

	$pf_object_id = db_pf_object_by_name("user_preferences");

	switch ($linklevel){
	case DB_PF_LEVEL_USER:
		$varName = "userHomepage";
		$prefix = "User";
		break;	
	case DB_PF_LEVEL_ENV:
		$varName = "envHomepage";
		$prefix = "Environment";
		break;	
	case DB_PF_LEVEL_GLOBAL:		
		$varName = "globalHomepage";
		$prefix = "Global";
		break;	
	
	}

	if ($job_id != ""){

		if ($pf_option_id = db_pf_option_get_default($pf_object_id, $linklevel, $link_id)){

			db_pf_option_update($pf_option_id, $varName, $prefix." Homepage Settings",$linklevel, $link_id, $pf_option_default_yn=true,$pf_option_favourite_yn=false,$pf_option_title=$prefix." Homepage");

		} else {

			$pf_option_id = db_pf_option_insert($pf_object_id, $varName, $prefix." Homepage Settings", $linklevel, $link_id, $pf_option_default_yn=true,$pf_option_favourite_yn=false,$pf_option_title=$prefix." Homepage");

		}

		db_pf_field_update($pf_option_id,"sc_job_id", $job_id);
	} else {  // Are we deleting?
		if ($pf_option_id = db_pf_option_get_default($pf_object_id, $linklevel ,$link_id)){
			db_pf_option_delete($pf_option_id);
		}
	}
}
