<?php
/*
 * $Id: init.form400.php,v 1.2 2011-05-17 14:08:33 light Exp $
 *
 * $Log: init.form400.php,v $
 * Revision 1.2  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.1  2010-01-11 17:39:27  light
 * Bug #6622 - User Prefences (Default page & Email templates)
 *
 */

/**
 * init.form400.php - My Preferences Form
 * Job: 780
 * Function: 117 (My preferences Form)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/user_preferences.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");

$GLOBALS['temp']['referringJob'] = $_SERVER['argv'][1];
$GLOBALS['temp']['canUseCurrent'] = false;

$GLOBALS[$form]->Arguments = "781+".$GLOBALS['temp']['referringJob'];

// Check that you set to master database!
$setbacktozero = 0;
if ($GLOBALS['lDB']->isMaster == "0") {
	$GLOBALS['lDB']->isMaster = "1";
	$setbacktozero = 1;
}
// end check

$pf_object_id = db_pf_object_by_name("user_preferences");

$defaults = db_pf_option_get_defaults($pf_object_id);
$default_env = false;
$user_job_id = false;
$env_job_id = false;
$global_job_id = false;
foreach ($defaults as $option){
	switch (db_pf_option_level($option)){
	case DB_PF_LEVEL_USER:
		db_pf_field_load_by_name($option,'sc_job_id',$user_job_id);
		break;
	case DB_PF_LEVEL_ENV:
		$default_env = db_pf_option_level_link_id($option);
		db_pf_field_load_by_name($option,'sc_job_id',$env_job_id);		
		break;
	case DB_PF_LEVEL_GLOBAL:
		db_pf_field_load_by_name($option,'sc_job_id',$global_job_id);	
		break;
	}
}

if ($pmode == 1){

	homepageAction(DB_PF_LEVEL_USER, $GLOBALS['userid'], $_POST['user_job_id']);
	if ($default_env){
		homepageAction(DB_PF_LEVEL_ENV, $default_env, $_POST['env_job_id']);
	} else {
		homepageAction(DB_PF_LEVEL_ENV, $GLOBALS['dbcode'], $_POST['env_job_id']);
	}
	homepageAction(DB_PF_LEVEL_GLOBAL, false, $_POST['global_job_id']);		
}


$global_job_desc = !empty($global_job_id) ? $GLOBALS['lDB']->get("SELECT sc_job_desc FROM sc_job WHERE sc_job_id = $global_job_id",4) : "";
$env_job_desc = !empty($env_job_id) ? $GLOBALS['lDB']->get("SELECT sc_job_desc FROM sc_job WHERE sc_job_id = $env_job_id",4) : "";
$user_job_desc = !empty($user_job_id) ? $GLOBALS['lDB']->get("SELECT sc_job_desc FROM sc_job WHERE sc_job_id = $user_job_id",4) : "";



$homePageList = $GLOBALS['lDB']->get("SELECT sc_job_id, sc_job_desc FROM sc_job WHERE sc_job_homepage_yn = 1 ORDER BY sc_job_desc ASC",2);

$homepageHTML = "
	<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#cfc';\" onmouseout=\"this.style.backgroundColor='#fff';\" style=\"background-color: #fff;\" onclick=\"setHomepage('!sc_job_id!');\">
		<td class=\"\" valign=\"top\">!name_fmt!</td>
	</tr>
";

$homepageRows = "";
if(sizeof($homePageList) > 0) {
	foreach($homePageList as $page) {
		$row['name_fmt'] = $page["sc_job_desc"];
		$row['sc_job_id'] = $page["sc_job_id"];
		$homepageRows .= showpage($row,$homepageHTML);

		if ($page["sc_job_id"] == $GLOBALS['temp']['referringJob']){
			$GLOBALS['temp']['canUseCurrent'] = true;
		}
	}
}

$GLOBALS['temp']['homepageRows'] = $homepageRows;


$GLOBALS['temp']['userControls'] = BuildHomePageControl('user', $user_job_desc, $user_job_id);
$GLOBALS['temp']['envControls'] = BuildHomePageControl('env', $env_job_desc, $env_job_id);
$GLOBALS['temp']['globalControls'] = BuildHomePageControl('global', $global_job_desc, $global_job_id);

if(TemplatesReadAccess()) {
	$GLOBALS['temp']['templateAccess'] = "block";
} else {
	$GLOBALS['temp']['templateAccess'] = "none";
}

// set db back to slave on the web, if it was slave when started
if ($setbacktozero == 1) {
	$GLOBALS['lDB']->isMaster = "0";
}
// end set
