<?php

/**
 * init.form4000.php - Unauthorised Access screen (white screen of unauthorised death)
 */

require_once(__DIR__ . '/db.sc_env_group.php');

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/unauthorised_access.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");
global $principal_id, $principal_name, $client, $server, $dbcode, $domain, $master, $system, $version, $temp;

$GLOBALS['temp'] = array();

$GLOBALS['temp']['mainMessage'] = "It seems as though you do not have the necessary permissions to access the " . $dbcode . " environment.";
if ($_SERVER['argv'][2] == "inactive") {
	$GLOBALS['temp']['mainMessage'] = "The " . $dbcode . " environment is set as inactive, and can not be accessed.";
}
$GLOBALS['temp']['customCSS'] = "";
$GLOBALS['temp']['dbcode'] = $dbcode;
$GLOBALS['temp']['canAccess'] = "";
$GLOBALS['temp']['protocol'] = "'" . $GLOBALS['http'] . "'";
$GLOBALS['temp']['resURL'] = "'$client.resrequest.com'";
$sc_group_id = $_SERVER['argv'][1];
$env_item_list = "<h3>No authorised environment could be found.</h3>";

if ($sc_group_id > 0 || $sc_group_id != "") {
	$canAccess = [];
	$resOffice = true;
	$canAccess = db_sc_env_group_can_access($sc_group_id);
	$env_item_list = (empty($canAccess)) ? ("<h3>No environment could be found.</h3>") : ("");

	foreach ($canAccess as $key => $propertyInfo) {
		$description   = "";
		$message       = "";
		$clickClass    = "";
		$enviro        = "";
		$display       = false;
		if ($propertyInfo[2] == ENVIRONMENT_TYPE_RESERVATION && $resOffice) { // Res
			$description = "Reservation Office";
			$enviro      = "Res";
			$display     = true;
			$resOffice   = false;
		}
		elseif ($propertyInfo[2] == ENVIRONMENT_TYPE_PROPERTY) { // Prop
			$description = "$propertyInfo[1] ($propertyInfo[0])";
			$enviro  = "$propertyInfo[0]";
			if ($propertyInfo[3] == 1) { // db_env_type_web_yn
				$display = true;
			}
			else {
				$message   = "<p class='text-italic margin-top-remove'>This environment<br>is only accessible on<br>the property network.</p>";
				$clickClass  = " disabled";
				$display   = true;
			}
		}
		if ($display) {
			$env_item_list .= "
				<div id='$enviro' class='environment-item uk-card uk-card-default uk-card-body uk-margin-left uk-margin-right $clickClass'>
					<div>
						<i class='rr-environment'>
							<span class='path1'></span>
							<span class='path2'></span>
							<span class='path3'></span>
						</i>
					</div>
				<p class='uk-text-small'>$description</p>
				$message
			</div>";
		}
	}
}
$GLOBALS['temp']['canAccess'] = $env_item_list;

$meta = db_sc_env_group_get_meta();
if (trim($meta['rf_site_title']) == "") {
	$GLOBALS['temp']['title'] = $principal_name . " reservations";
} else {
	$GLOBALS['temp']['title'] = $meta['rf_site_title'];
}

$imagePrincipal = "demo";
if ($system != "demo") {
	$imagePrincipal = $principal_id;
	if (file_exists("$GLOBALS[images_dir_on_disk]/$imagePrincipal/top_clientlogo.gif")) {
		$temp['logoURL'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $principal_id."/top_clientlogo.gif";
	} else {
		$temp['logoURL'] = "/resource/Resrequest/Application/public/img/1x1.gif";
	}
} else {
	$temp['logoURL'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/demo/top_clientlogo.gif";
}

$images = array(
	'logoSrc'=>'top_clientlogo.gif',
	'nav1Src'=>'main_nav1.jpg',
	'nav2Src'=>'main_nav2.jpg',
	'nav3Src'=>'main_nav3.jpg'
);

foreach($images as $tag=>$image) {
	if (file_exists("$GLOBALS[images_dir_on_disk]/$imagePrincipal/$image")) {
		$GLOBALS['temp'][$tag] = $GLOBALS['http'].$GLOBALS['images_dir']."/$imagePrincipal/$image";
	} else {
		$GLOBALS['temp'][$tag] = "/resource/Resrequest/Application/public/img/1x1.gif";
	}
}

$testImg = "class=\"printCollapse collapse\"";
$trainingImg = "class=\"printCollapse Collapse\"";
switch ($system) {
case "test":
	$testImg = "";
	break;
case "training":
	$trainingImg = "";
	break;
}

$GLOBALS['temp']['testImageClass'] = $testImg;
$GLOBALS['temp']['trainingImageClass'] = $trainingImg;
$GLOBALS['temp']['system'] = $system;

$imagePrincipal = "demo";
if ($system != "demo") {
	$imagePrincipal = $principal_id;
	if (file_exists("$GLOBALS[images_dir_on_disk]/$imagePrincipal/top_clientlogo.gif")) {
		$temp['logoURL'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $principal_id."/top_clientlogo.gif";
	} else {
		$temp['logoURL'] = "/resource/Resrequest/Application/public/img/1x1.gif";
	}
} else {
	$temp['logoURL'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/demo/top_clientlogo.gif";
}

if (
	file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/global.css")
	|| file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/enable_new_system")
	|| !file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/index.css")
) {
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/index.css")) {
		$indexCSS = "
			<link rel=\"stylesheet\" href=\"" . $GLOBALS['http'] . $GLOBALS['images_dir'] . "/$principal_id/styles/index.css\" type=\"text/css\">
			<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/imageset/login-old.js\"></script>
		";
	} elseif (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-index.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"" . $GLOBALS['http'] . $GLOBALS['images_dir'] . "/$principal_id/styles/template-index.css\" type=\"text/css\">";
	} else {
		$indexCSS = "
			<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/index.css\" type=\"text/css\">
			<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/imageset/login-old.js\"></script>
		";
	}

	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/uikit.min.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/uikit.min.css\" type=\"text/css\" />";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit.min.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit-icons.min.js"));
		$indexHTML .= "</script>";
	} elseif (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-index.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/ui-kit/uikit.min.css\" />";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js\"></script>\n";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js\"></script>\n";
	} else{
		$uikitCSS = "";
	}

	$custom = "";
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/custom.css")) {
		$custom = "<link rel=\"stylesheet\" href=\"" . $GLOBALS['http'] . $GLOBALS['images_dir'] . "/$principal_id/styles/custom.css\" type=\"text/css\">";
	}

	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/sys.css\" type=\"text/css\">
		<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/enterprise.css\" type=\"text/css\">
	";
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/global.css")) {
		$GLOBALS['temp']['customCSS'] .= "<link rel=\"stylesheet\" href=\"" . $GLOBALS['http'] . $GLOBALS['images_dir'] . "/$principal_id/styles/global.css\" type=\"text/css\">";
	}
	elseif (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-index.css")) {
		$GLOBALS['temp']['customCSS'] .= "<link rel=\"stylesheet\" href=\"" . $GLOBALS['http'] . $GLOBALS['images_dir'] . "/shared/global.css\" type=\"text/css\">";
	}

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Do not include imageset CSS if it's a V3+ imageset
		$indexCSS = "
			<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/index.css\" type=\"text/css\">
			<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/imageset/login-old.js\"></script>
		";
		$uikitCSS = "";
		$GLOBALS['temp']['customCSS'] = "
			<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/sys.css\" type=\"text/css\">
			<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/enterprise.css\" type=\"text/css\">
		";
	}
} 
