
<?php

/**
* init.form4001.php - POS Inventory Location mapping code table
* Job: 4001
* Function: 86 (Code Tables: POS)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"4001",__DIR__ . "/../../../public/html/code_pos_stock_location.htm");
}

$jobLevel = checkJob(4001,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "true" : "false";
$GLOBALS['temp']['readOnlyDisabled'] = ($jobLevel < 10) ? "disabled" : "";

$action = $_POST['action'] ?? "";
$pr_business_id = isset($_POST['pr_business_id']) ? $_POST['pr_business_id'] : "";
$ac_stock_ix = isset($_POST['ac_stock_ix']) ? $_POST['ac_stock_ix'] : "";
$Inventory = new Inventory();
if(!empty($action)) {
	$response = false;
	switch($action) {
		case "save_locations":
			$location = json_decode($_POST['location'] ?? "", true);
			$response = $Inventory->saveLocation($location);
			break;
		case "select_location":
			$ac_stock_ix = $_POST['ac_stock_ix'];
			$response = $Inventory->selectLocation($ac_stock_ix);
			break;
		case "delete_location":
			$ac_stock_ix = $_POST['ac_stock_ix'];
			$response = $Inventory->deleteLocation($ac_stock_ix);
			break;
	}
	echo json_encode($response);
	die();
}
$propertyList = $Inventory->propertyList;

$propertyOptions = "";
foreach($propertyList as $key => $propertyOption) {
	$propertyOptions .= "
		<option value='$key'>$propertyOption</option>
	";
}
$GLOBALS['temp']['propertyOptions'] = $propertyOptions;
$GLOBALS['temp']['rows'] = $Inventory->listLocations();
