<?php

/**
 * init.form4002.php - General Ledger account detail popup - Stock Locations Tab
 * Job: 4002
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_stock.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";
$stockLocationData = array();

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

$Inventory = new Inventory();

$canPostInventory = isset($Inventory->InventoryInvoiceUnits[$iUnitID]) ? $Inventory->InventoryInvoiceUnits[$iUnitID]['pr_bus_post_inventory_yn'] : '0';

if ( $_SERVER['argc'] > 2 && $canPostInventory) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);

			foreach ( $editedFields as $data ) {
				$fieldData = explode(":",$data);
				$ac_stock_ix = $Inventory->db_ac_stock_exists($fieldData[0]);

				$fieldData[1] = str_replace("cell2","fn_cost_centre_1_id",$fieldData[1]);
				$fieldData[1] = str_replace("cell3","fn_cost_centre_2_id",$fieldData[1]);
				$fieldData[1] = explode("|",trim($fieldData[1]));
				$fieldData[2] = explode("|",trim($fieldData[2]));

				if($ac_stock_ix) {
					// If the user has only entered one of the Cost Centres, we need
					// to send the correct data to the db insert
					$fields = array("fn_cost_centre_1_id","fn_cost_centre_2_id");

					foreach( $fields as $f ) {
						$input_arr[$f] = "";
						for( $i = 0; $i < count($fieldData[1]); $i++ ) {
							if ( $f == $fieldData[1][$i]) {
								$input_arr[$f] = $fieldData[2][$i];
							}
						}
					};
					$updateArr = array_filter($input_arr, function($v) {
						return !empty($v);
					});
					$Inventory->db_ac_stock_update_cc($fieldData[0], $updateArr);
				}
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_cost_centre/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];
			break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre_1.fn_cost_centre_ix,
		fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_1_code,
		fn_cost_centre_1.fn_cost_centre_desc AS fn_cost_centre_1_desc
	FROM
		fn_cost_centre AS fn_cost_centre_1
	WHERE
		fn_cost_centre_1.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre_1.fn_cost_centre_ind <> '2' 
",2);

$costCentres2 = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre_2.fn_cost_centre_ix,
		fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_2_code,
		fn_cost_centre_2.fn_cost_centre_desc AS fn_cost_centre_2_desc
	FROM
		fn_cost_centre AS fn_cost_centre_2
	WHERE
		fn_cost_centre_2.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre_2.fn_cost_centre_ind = '2' 
",2);

if ($canPostInventory) {

	$stockLocationData = $GLOBALS['lDB']->get("
		SELECT 
			ac_stock.ac_stock_ix, 
			ac_stock.ac_stock_name_rr, 
			ac_stock.fn_cost_centre_1_id, 
			ac_stock.fn_cost_centre_2_id, 
			fn_cost_centre_1.fn_cost_centre_ix AS fn_cost_centre_1_ix,
			fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_1_code,
			fn_cost_centre_1.fn_cost_centre_desc AS fn_cost_centre_1_desc,
			fn_cost_centre_2.fn_cost_centre_ix AS fn_cost_centre_2_ix,
			fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_2_code,
			fn_cost_centre_2.fn_cost_centre_desc AS fn_cost_centre_2_desc,
			ac_stock.ac_stock_inactive_yn
		FROM
			ac_stock
			LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = ac_stock.fn_cost_centre_1_id
			LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = ac_stock.fn_cost_centre_2_id
		WHERE
			ac_stock.pr_business_id in ('" . implode('\', \'', $Inventory->invoiceUnitChildProperties[$iUnitID]) . "')
		" . $filterSQL . " " . $sortSQL . "
	",2);
}


// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "ac_stock_name_rr";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $stockLocationData as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$locationHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	// Build the Cost Centre 1 selection box ---------------------------------------
	$options = "<select id=\"cell2" . $stockLocationData[$k]['ac_stock_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"None\">None</option>	
	";
	foreach ( $costCentres as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $stockLocationData[$k]['fn_cost_centre_1_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_1_code'].": ".$c['fn_cost_centre_1_desc'])."</option>\n";
	}
	$options .= "</select>\n";

	// Build the Cost Centre 2 selection box ---------------------------------------
	$options2 = "<select id=\"cell3" . $stockLocationData[$k]['ac_stock_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"None\">None</option>	
	";
	foreach ( $costCentres2 as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $stockLocationData[$k]['fn_cost_centre_2_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$options2 .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_2_code'].": ".$c['fn_cost_centre_2_desc'])."</option>\n";
	}
	$options2 .= "</select>\n";
	
	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $stockLocationData[$k]['ac_stock_ix'] . "',1);\" onmouseout=\"hover('" . $stockLocationData[$k]['ac_stock_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $stockLocationData[$k]['ac_stock_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$costCentreLabel = t_encodeHTMLField($stockLocationData[$k]['fn_cost_centre_1_code'] . ": " .$stockLocationData[$k]['fn_cost_centre_1_desc']);
	if ( $stockLocationData[$k]['fn_cost_centre_1_code'] == "" && $stockLocationData[$k]['fn_cost_centre_1_desc'] == "" ) {
		$costCentreLabel = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$costCentreLabel2 = t_encodeHTMLField($stockLocationData[$k]['fn_cost_centre_2_code'] . ": " .$stockLocationData[$k]['fn_cost_centre_2_desc']);
	if ( $stockLocationData[$k]['fn_cost_centre_2_code'] == "" && $stockLocationData[$k]['fn_cost_centre_2_desc'] == "" ) {
		$costCentreLabel2 = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$locationHTML .= "
		<tr id=\"" . $stockLocationData[$k]['ac_stock_ix'] . "\" " . $mouseOver . ">
			<td id=\"cell1" . $stockLocationData[$k]['ac_stock_ix'] . "\" class=\"bl br\" " . $onClick . ">" . t_encodeHTMLField($stockLocationData[$k]['ac_stock_name_rr']) . "</td>
			<td id=\"cell2" . $stockLocationData[$k]['ac_stock_ix'] . "\" class=\"br\" " . $onClick . ">" . $costCentreLabel . "</td>
			<td id=\"cell3" . $stockLocationData[$k]['ac_stock_ix'] . "\" class=\"br\" " . $onClick . ">" . $costCentreLabel2 . "</td>
		</tr>
	";
		
	$hiddenDiv .= "
		<span id=\"cell2" . $stockLocationData[$k]['ac_stock_ix'] . "Hidden\">" . $options . "</span>
		<span id=\"cell3" . $stockLocationData[$k]['ac_stock_ix'] . "Hidden\">" . $options2 . "</span>
	";
}

$GLOBALS['temp']['stockLocationHTML'] = $locationHTML;
$GLOBALS['temp']['hiddenDiv']	 = $hiddenDiv;
$GLOBALS['temp']['unitName']	 = $unitName;
$GLOBALS['temp']['fun_job_id']	 = $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']		 = $iUnitID;
