<?php

/**
 * init.form4003.php - General Ledger account detail popup - Sales Locations Tab
 * Job: 4003
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_sales.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";

$GLOBALS['temp']['filterArg'] = "";
$GLOBALS['temp']['sortArg'] = "";

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			$ac_pos_ix = 0;
			foreach ( $editedFields as $data ) {
				$d = explode(":",$data);
				$ac_pos_ix = db_ac_pos_exists($d[0]);
				$d[1] = str_replace("cell2","fn_cost_centre_1_id",$d[1]);
				$d[1] = str_replace("cell3","fn_cost_centre_2_id",$d[1]);
				$d[1] = explode("|",$d[1]);
				$d[2] = explode("|",$d[2]);

				if($ac_pos_ix) {
					// If the user has only entered one of the Cost Centres, we need
					// to send the correct data to the db insert
					$fields = array("fn_cost_centre_1_id","fn_cost_centre_2_id");

					foreach( $fields as $f ) {
						$input_arr[$f] = "";
						for( $i = 0; $i < count($d[1]); $i++ ) {
							if ( $f == $d[1][$i]) {
								$input_arr[$f] = $d[2][$i];
							}
						}
					};
					$updateArr = array_filter($input_arr, function($v) {
						return !empty($v);
					});
					db_ac_pos_update_cc($d[0],$updateArr);
				}
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$GLOBALS['temp']['filterArg'] = $_SERVER['argv'][3];
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" ) {
				$filterSQL = "";
			} elseif(preg_match("/fn_cost_centre/",$filterField)) {
				if(empty($filterText)) {
					$filterSQL .= "
						AND ".$filterField."_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(".$filterField."_code LIKE '" . $lDB->like($filterText) . "')
							OR (".$filterField."_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(".$filterField."_code, ': ', ".$filterField."_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			$GLOBALS['temp']['sortArg'] = $_SERVER['argv'][3];
			break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre_1.fn_cost_centre_ix,
		fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_1_code,
		fn_cost_centre_1.fn_cost_centre_desc AS fn_cost_centre_1_desc
	FROM
		fn_cost_centre AS fn_cost_centre_1
	WHERE
		fn_cost_centre_1.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre_1.fn_cost_centre_ind <> '2' 
",2);

$costCentres2 = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre_2.fn_cost_centre_ix,
		fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_2_code,
		fn_cost_centre_2.fn_cost_centre_desc AS fn_cost_centre_2_desc
	FROM
		fn_cost_centre AS fn_cost_centre_2
	WHERE
		fn_cost_centre_2.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre_2.fn_cost_centre_ind = '2' 
",2);

$salesLocationList =  $iUnitID;
if (db_pr_business_is_inventory($iUnitID) == '1') {
	$Inventory = new Inventory();
	$childPropertyList = $Inventory->invoiceUnitChildProperties[$iUnitID];
	$salesLocationList = !empty($childPropertyList) ? implode('\', \'', $childPropertyList) : $iUnitID;
}
$salesLocations = $GLOBALS['lDB']->get("
	SELECT
		ac_pos.ac_pos_ix, 
		ac_pos.ac_pos_db, 
		ac_pos.ac_pos_name_rr, 
		ac_pos.fn_cost_centre_1_id, 
		ac_pos.fn_cost_centre_2_id, 
		fn_cost_centre_1.fn_cost_centre_ix AS fn_cost_centre_1_ix,
		fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_1_code,
		fn_cost_centre_1.fn_cost_centre_desc AS fn_cost_centre_1_desc,
		fn_cost_centre_2.fn_cost_centre_ix AS fn_cost_centre_2_ix,
		fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_2_code,
		fn_cost_centre_2.fn_cost_centre_desc AS fn_cost_centre_2_desc,
		ac_pos.ac_inactive_yn
	FROM
		ac_pos
		LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = ac_pos.fn_cost_centre_1_id
		LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = ac_pos.fn_cost_centre_2_id
	WHERE
		ac_pos.pr_business_id IN ('" . $salesLocationList . "') 
		" . $filterSQL . " " . $sortSQL . "

",2);

$showInactive = $_SERVER['argv'][5];
if($showInactive == "1") {
	$GLOBALS['temp']['showInactiveChecked'] = "checked";
} else {
	$GLOBALS['temp']['showInactiveChecked'] = "";
	$filterSQL .= "
		AND ac_pos.ac_inactive_yn = '0'
	";
}


// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "ac_pos_name_rr";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $salesLocations as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$salesLocationsHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	// Build the Cost Centre 1 selection box --------------------------------------
	$ccOptions = "<select id=\"cell2" . $salesLocations[$k]['ac_pos_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"None\">None</option>	
	";
	foreach ( $costCentres as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $salesLocations[$k]['fn_cost_centre_1_ix'] ) {
			$selected = ' selected="selected"';
		}
		$ccOptions .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_1_code'].": ".$c['fn_cost_centre_1_desc'])."</option>\n";
	}
	$ccOptions .= "</select>\n";

	// Build the Cost Centres 2 selection box --------------------------------------
	$ccOptions2 = "<select id=\"cell3" . $salesLocations[$k]['ac_pos_ix'] . "Select\" style=\"width:120px;\">
			<option value=\"None\">None</option>	
	";
	foreach ( $costCentres2 as $c ) {
		$selected = "";
		if ( $c['fn_cost_centre_ix'] == $salesLocations[$k]['fn_cost_centre_2_ix'] ) {
			$selected = ' selected="selected"';
		}
		$ccOptions2 .= "<option value=\"$c[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($c['fn_cost_centre_2_code'].": ".$c['fn_cost_centre_2_desc'])."</option>\n";
	}
	$ccOptions2 .= "</select>\n";
	
	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $salesLocations[$k]['ac_pos_ix'] . "',1);\" onmouseout=\"hover('" . $salesLocations[$k]['ac_pos_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $salesLocations[$k]['ac_pos_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	$costCentreLabel = t_encodeHTMLField($salesLocations[$k]['fn_cost_centre_1_code'] . ": " . $salesLocations[$k]['fn_cost_centre_1_desc']);
	if ( $salesLocations[$k]['fn_cost_centre_1_code'] == "") {
		$costCentreLabel = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$costCentreLabel2 = t_encodeHTMLField($salesLocations[$k]['fn_cost_centre_2_code'] . ": " . $salesLocations[$k]['fn_cost_centre_2_desc']);
	if ( $salesLocations[$k]['fn_cost_centre_2_code'] == "" ) {
		$costCentreLabel2 = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	}

	$inactiveLabel = "";
	$ac_pos_desc = t_encodeHTMLField($salesLocations[$k]['ac_pos_name_rr']);
	if($salesLocations[$k]['ac_inactive_yn'] == "1") {
		$inactiveLabel = "X";
	}

	$salesLocationsHTML .= "
		<tr id=\"" . $salesLocations[$k]['ac_pos_ix'] . "\" " . $mouseOver . ">\n
			<td id=\"cell1" . $salesLocations[$k]['ac_pos_ix'] . "\" class=\"bl br\" style=\"width:140px;\"  " . $onClick . ">" . t_encodeHTMLField($salesLocations[$k]['ac_pos_name_rr']) . "</td>
			<td id=\"cell2" . $salesLocations[$k]['ac_pos_ix'] . "\" class=\"br\" style=\"width:160px;\"  " . $onClick . ">" . $costCentreLabel . "</td>
			<td id=\"cell3" . $salesLocations[$k]['ac_pos_ix'] . "\" class=\"br\" style=\"width:160px;\"  " . $onClick . ">" . $costCentreLabel2 . "</td>
			<td id=\"cell4" . $salesLocations[$k]['ac_pos_ix'] . "\" class=\"br uk-text-center\" style=\"width:25px;\"  " . $onClick . ">" . $inactiveLabel . "</td>
		</tr>\n";

	$hiddenDiv .= "<span id=\"cell2" . $salesLocations[$k]['ac_pos_ix'] . "Hidden\">" . $ccOptions . "</span>\n";
	$hiddenDiv .= "<span id=\"cell3" . $salesLocations[$k]['ac_pos_ix'] . "Hidden\">" . $ccOptions2 . "</span>\n";
}

$GLOBALS['temp']['salesLocationsHTML']	= $salesLocationsHTML;
$GLOBALS['temp']['hiddenDiv']			= $hiddenDiv;
$GLOBALS['temp']['unitName']			= $unitName;
$GLOBALS['temp']['fun_job_id']			= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']				= $iUnitID;

