<?php

/**
 * init.form4004.php - Inventory transaction maintenance
 * Job: 4004
 * Function: 101 (Financial: GL Batch)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$GLOBALS['temp']['title'] = "Inventory processing";
$jobLevel = checkJob(4004,2);
$readOnly = ($jobLevel < 10) ? "true" : "false";
$GLOBALS['temp']['readOnly'] = $readOnly;
$GLOBALS['temp']['pullButtonClass'] = $readOnly == "true" ? 'hidden' : '';

// Form setup
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS['form4004'] = new Form("form4004","",__DIR__ . "/../../../public/html/fin_ledger_inventory.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],28,"");

$billingUnitId = $_SERVER['argv'][1];

$Inventory = new Inventory();

$apiData   = $Inventory->getTranSettings($billingUnitId)[0];
$action    = !empty($_POST['action']) ? $_POST['action'] : "";
$propName  = $Inventory->getPropertyName($billingUnitId);

$GLOBALS['temp']['invoice_unit_name'] = $propName[0];
$GLOBALS['temp']['billingUnitId'] = $billingUnitId;
$GLOBALS['temp']['check_pr_bus_post_in_po_yn'] = $apiData['pr_bus_post_in_po_yn'] ? "checked" : "disabled";
$GLOBALS['temp']['check_pr_bus_post_in_returns_yn'] = $apiData['pr_bus_post_in_returns_yn'] ? "checked" : "disabled";
$GLOBALS['temp']['check_pr_bus_post_in_cos_yn'] = $apiData['pr_bus_post_in_cos_yn'] ? "checked" : "disabled";
$GLOBALS['temp']['check_pr_bus_post_in_issues_yn'] = $apiData['pr_bus_post_in_issues_yn'] ? "checked" : "disabled";
$GLOBALS['temp']['check_pr_bus_post_in_trfs_yn'] = $apiData['pr_bus_post_in_trfs_yn'] ?	"checked" : "disabled";
$GLOBALS['temp']['1_last_date'] = $apiData['1_last_date'];
$GLOBALS['temp']['2_last_date'] = $apiData['2_last_date'];
$GLOBALS['temp']['3_last_date'] = $apiData['3_last_date'];
$GLOBALS['temp']['4_last_date'] = $apiData['4_last_date'];
$GLOBALS['temp']['5_last_date'] = $apiData['5_last_date'];
$GLOBALS['temp']['show_check_pr_bus_post_in_po_yn'] = $apiData['pr_bus_post_in_po_yn'] ? "" : "collapse";
$GLOBALS['temp']['show_check_pr_bus_post_in_returns_yn'] = $apiData['pr_bus_post_in_returns_yn'] ? "" : "collapse";
$GLOBALS['temp']['show_check_pr_bus_post_in_cos_yn'] = $apiData['pr_bus_post_in_cos_yn'] ? "" : "collapse";
$GLOBALS['temp']['show_check_pr_bus_post_in_issues_yn'] = $apiData['pr_bus_post_in_issues_yn'] ? "" : "collapse";
$GLOBALS['temp']['show_check_pr_bus_post_in_trfs_yn'] = $apiData['pr_bus_post_in_trfs_yn'] ?	"" : "collapse";

if(!empty($action)) {
	$response = false;
	switch($action) {
		case "pull_transactions":
			$processTranList = $_POST['processTran'];
			$response = $Inventory->pullTransactions($billingUnitId, $processTranList, date("Y-m-d H:i:s"));
			break;
	}
	echo json_encode($response);
	die();
}



