<?php
/**
 * init.form401.php - Period dates
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_period_dates.htm");
	$fields = array(
		"rt_period_dates_ix",
		"rt_period_from",
		"rt_period_to",
		"rt_period_id"		
	);
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"rt_period_dates",$fields,"rt_period_dates_ix = '$record2'","","");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$display_only = $_SERVER['argv'][5] == "" ? false : true;
$GLOBALS['temp']['display_only'] = ($display_only) ? '1' : '0';

if (isset($_POST['action']) && $_POST['action'] == 'checkOverlap'){
	$rt_period_from = date('Y-m-d',strtotime($_POST['rt_period_from']));
	$rt_period_to = date('Y-m-d',strtotime($_POST['rt_period_to']));
	$rt_period_id = $_POST['rt_period_id'];
	$rt_period_dates_id = $_POST['rt_period_dates_ix'];
	
	$refPairs = $GLOBALS['lDB']->get("
	
		SELECT
			rt_rate.rt_rate_type_id,
			rt_rate.ac_accomm_type_id
		FROM
			rt_rate
		WHERE
			rt_rate.rt_period_id = '$rt_period_id'
	
	",2);

	if ($rt_period_dates_id){
		$excludeCurrent = " AND rt_period_dates.rt_period_dates_ix != '$rt_period_dates_id'";
	} else {
		$excludeCurrent = "";
	}
	
	if (count($refPairs) > 0){

		foreach ($refPairs as $refPair){
			$where[] = "(rt_rate.rt_rate_type_id = '".$refPair['rt_rate_type_id']."' AND rt_rate.ac_accomm_type_id = '".$refPair['ac_accomm_type_id']."'$excludeCurrent)";
		}
		
		$sqlWhere = "AND ".join(" OR ", $where);
	} else {	// No rates use this period, so no need to proceed further; allow it.
		echo "1";
		die();
	}
	
	$affectedRates = $GLOBALS['lDB']->get("
	
		SELECT
			rt_rate.rt_rate_ix,
			rt_period.rt_period_desc,
			rt_period.rt_period_ix,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			rt_rate_type.rt_rate_type_desc,
			rt_period_dates.rt_period_dates_ix,
			rt_period_dates.rt_period_from,
			rt_period_dates.rt_period_to
		FROM
			rt_rate
			INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
			INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE 1
			$sqlWhere
		ORDER BY 
			pr_persona.pr_name_last, ac_accomm_type.ac_accomm_desc, rt_rate_type.rt_rate_type_desc, rt_period_dates.rt_period_from
	
	",2);

	$conflicts = array();
	
	foreach ($affectedRates as $affectedRate){
		if (
			($affectedRate['rt_period_from'] >= $rt_period_from	&& $affectedRate['rt_period_from'] <= $rt_period_to) || 
			($affectedRate['rt_period_to'] >= $rt_period_from && $affectedRate['rt_period_to'] <= $rt_period_to) || 
			($affectedRate['rt_period_from'] <= $rt_period_from	&& $affectedRate['rt_period_to'] >= $rt_period_to)
		) {
			$conflicts[] = $affectedRate;
		}
		
	}
	if (count($conflicts) > 0){
		$conflictHTML = join("",file(__DIR__ . "/../../../public/html/code_period_dates_overlap.htm"));
		$rt_period = $GLOBALS['lDB']->get("
			SELECT 
				rt_period_desc,
				rt_period_date_from,
				rt_period_date_to
			FROM
				rt_period
			WHERE
				rt_period_ix = '$rt_period_id'
		",1);

		if ($rt_period_dates_id){
			$rt_period_dates = $GLOBALS['lDB']->get("
				SELECT 
					rt_period_from,
					rt_period_to
				FROM
					rt_period_dates
				WHERE
					rt_period_dates_ix = '$rt_period_dates_id'
			",1);			
		}

		if ($rt_period['rt_period_date_from'] == "0000-00-00" || ( isset($rt_period_dates) && !$rt_period_dates['rt_period_from'] ) ) {
			$originalDates = "<span class=\"txti\">new date</span>";		
			$header = "Rate Period Overlap: ".$rt_period['rt_period_desc'];		
		} else {
			if (isset($rt_period_dates) && isset($rt_period_dates['rt_period_from']) && isset($rt_period_dates['rt_period_to'])) {
				$originalDates = $rt_period_dates['rt_period_from']." to ".$rt_period_dates['rt_period_to'];
			} else {
				$originalDates = "";
			}
			$header = "Rate Period Overlap: ".$rt_period['rt_period_desc']." (".$rt_period['rt_period_date_from']." to ".$rt_period['rt_period_date_to'].")";		
		}

		$newDates = $rt_period_from." to ".$rt_period_to;
		$rowHTML = "";

		foreach ($conflicts as $conflict){
			if ($display_only) {
				$rowHTML .= "<tr class='' bgcolor=\"white\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">";
			} else {
				$rowHTML .= "<tr class='linkrow' bgcolor=\"white\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"window.location = '/reservation.php?787+".$conflict['rt_period_ix']."+".$conflict['rt_period_dates_ix']."';\">";
			}
			$rowHTML .= "
					<td class=\"br\" style=\"width: 85px\">".$conflict['pr_name_last']."</td>
					<td class=\"br\" style=\"width: 110px\">".$conflict['ac_accomm_desc']."</td>
					<td class=\"br\" style=\"width: 126px\">".$conflict['rt_rate_type_desc']."</td>
					<td class=\"br\" style=\"width: 110px\">".$conflict['rt_period_desc']."</td>
					<td class=\"br\" style=\"width: 60px\">".$conflict['rt_period_from']."</td>
					<td class=\"br\" style=\"width: 60px\">".$conflict['rt_period_to']."</td>
					<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
				</tr>
			";
		}
		
		

		$conflictHTML = str_replace("!header!", $header, $conflictHTML);
		$conflictHTML = str_replace("!originalDates!", $originalDates, $conflictHTML);
		$conflictHTML = str_replace("!newDates!", $newDates, $conflictHTML);
		$conflictHTML = str_replace("!rows!", $rowHTML, $conflictHTML);
		
		
		echo $conflictHTML;
	} else {
		echo "1";
	}
	
	die();
}


$GLOBALS['temp']['loadClose'] = "0";
if (isset($_POST['saveclose']) && $_POST['saveclose'] == "1") {
   $GLOBALS['temp']['loadClose'] = "1";
}

$record = $_SERVER['argv'][1];
$record2 = $_SERVER['argv'][2];

$GLOBALS['temp']['record'] = $record;
$GLOBALS['temp']['record2'] = $record2;

$GLOBALS[$form]->Get($action); 
update_rt_period_rt_period_desc($record);

$GLOBALS['temp']['periodDesc'] = $GLOBALS['lDB']->get("
	SELECT 
		rt_period_desc
	FROM
		rt_period
	WHERE
		rt_period_ix = '$record'
",4);

$table = $GLOBALS[$form]->TableList[0];

if ($record != "" || $action == "3" && $action != "1") {
   $GLOBALS[$table]->Refresh($record2,$action);
}

$GLOBALS[$form.'_rt_period_dates_rt_period_id']->SetValue($record);
if ($action == "2") {
	$GLOBALS[$form.'_rt_period_dates_rt_period_dates_db']->SetValue($dbcode);
}

$todaysDate = date("Y-m-d");
$todaysDateArray = explode("-",$todaysDate);

if ($GLOBALS[$form.'_rt_period_dates_rt_period_from']->Value != ""){
	$date_from = explode("-", $GLOBALS[$form.'_rt_period_dates_rt_period_from']->Value);
	$GLOBALS['temp']['fromD'] = $date_from[2];
	$GLOBALS['temp']['fromM'] = $date_from[1];
	$GLOBALS['temp']['fromY'] = $date_from[0];
} else {
	$GLOBALS['temp']['fromD'] = "1";
	$GLOBALS['temp']['fromM'] = "1";
	$GLOBALS['temp']['fromY'] = $todaysDateArray[0];
}

if ($GLOBALS[$form.'_rt_period_dates_rt_period_to']->Value != ""){
	$date_to = explode("-", $GLOBALS[$form.'_rt_period_dates_rt_period_to']->Value);
	$GLOBALS['temp']['toD'] = $date_to[2];
	$GLOBALS['temp']['toM'] = $date_to[1];
	$GLOBALS['temp']['toY'] = $date_to[0];
} else {
	$GLOBALS['temp']['toD'] = "1";
	$GLOBALS['temp']['toM'] = "1";
	$GLOBALS['temp']['toY'] = $todaysDateArray[0];
}



$GLOBALS[$form.'_rt_period_dates_rt_period_from']->TabIndex = 1;
$GLOBALS[$form.'_rt_period_dates_rt_period_from']->Size = 10;
$GLOBALS[$form.'_rt_period_dates_rt_period_from']->StyleType = "txtR";
$GLOBALS[$form.'_rt_period_dates_rt_period_from']->IsHidden = true;

$GLOBALS[$form.'_rt_period_dates_rt_period_to']->TabIndex = 2;
$GLOBALS[$form.'_rt_period_dates_rt_period_to']->Size = 10;
$GLOBALS[$form.'_rt_period_dates_rt_period_to']->StyleType = "txtR";
$GLOBALS[$form.'_rt_period_dates_rt_period_to']->IsHidden = true;

$newr = 785;
$edit = 787;
$view = 784;
$dele = 789;
$sedit = 788;
$snewr = 786;

// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
   $pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
   $pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
   $pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
   $pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4" || $record2 == null) {
   $pgJOBS['edit'] = "0";
}
if ($action == "3") {
   $pgJOBS['edit'] = $pgJOBS['view'];
   if (checkJob($dele)) {
      $pgJOBS['del'] = "1";
   }
}

if ($display_only) {
	$pgJOBS['add'] 	= "0";
	$pgJOBS['edit'] = "0";
	$pgJOBS['save'] = "0";
	$pgJOBS['del'] 	= "0";
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"".$pgJOBS['save']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"1\">\n";
// End Access Control Toolbar Setup

$GLOBALS['temp']['new_record'] = "reservation.php?".$newr."+".$record;

switch ($action) {
   case (0) : // List Records
      break;
   case (1) : // Display Record
      $GLOBALS['mode'] = "display";
      $GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+".$record2;
      $GLOBALS['temp']['save_record'] = "#";
      $GLOBALS['temp']['del_record'] = "#";
      break;
   case (2) : // Add Record
      $GLOBALS[$form]->Arguments = (string) $snewr."+".$record;
      $GLOBALS['temp']['edit_view'] = "#";
      $GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
      $GLOBALS['temp']['del_record'] = "#";
      $GLOBALS['mode'] = "new";
      break;
   case (3) : // Edit Record
	  if (!$GLOBALS['lDB']->isMaster) {
		  redirectTo('reservation.php?' . $view . '+' . $record . '+' . $record2);
	  }
      $GLOBALS[$form]->Arguments = (string) $sedit."+".$record."+".$record2;
      $GLOBALS['mode'] = "edit";
      $GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record."+".$record2;
      $GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
      $GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record."+".$record2;
      break;
   case (4) : // Delete Record
		 if (!$GLOBALS['lDB']->isMaster) {
		 	redirectTo('reservation.php?' . $view . '+' . $record . '+' . $record2);
		 }
         $sql = " DELETE
               FROM
                  rt_period_dates
               WHERE
                  rt_period_dates_ix = '$record2'";
         $GLOBALS['lDB']->put($sql);
      break;
}

$GLOBALS['temp']['new_record'] .= "++".$_SERVER['argv'][3]."+".$_SERVER['argv'][4];

