<?php
/*
 * $Id: init.form405.php,v 1.2 2011-05-17 14:08:33 light Exp $
 *
 * $Log: init.form405.php,v $
 * Revision 1.2  2011-05-17 14:08:33  light
 * Bug #7585 - PHP5 fixes
 *
 *
 */

/**
 * init.form405.php - Rate groups
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}


$GLOBALS['temp']['imgMode1'] = "std";
$GLOBALS['temp']['imgMode2'] = "std";

$counti=0;

switch ($_SERVER['argv'][2]) {
	case 0:
		$orderbyfield = "rt_rate_group_desc";
		break;
	case 1:
		$orderbyfield = "rt_rate_group_abbrv";
		break;
	case 2:
		$orderbyfield = "rt_rate_group_class";
		break;	  
}
$GLOBALS['temp']['sortBy'] = $_SERVER['argv'][2];

$order = " asc";
if ($_SERVER['argv'][3] == "1") {
   $order = " desc";
}
$GLOBALS['temp']['sortOrder'] = $_SERVER['argv'][3];

if ($order == " asc") {
   $GLOBALS['temp']['imgMode1'] = "down"; #(name, asc)
} else {
   $GLOBALS['temp']['imgMode2'] = "down"; #(name, desc)
}

$showInactiveRateGroups = false;
if ($_SERVER['argv'][4] == "1") {
   $showInactiveRateGroups = true;
}
$GLOBALS['temp']['showInactive'] = $showInactiveRateGroups == '1' ? '1' : '0';

$recordList = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_group_ix, rt_rate_group_abbrv, rt_rate_group_desc, rt_rate_group_class, rt_rate_group_inactive_yn
	FROM
		rt_rate_group
	ORDER BY ".$orderbyfield.$order	
,2);	

if(checkjob("398") == true) {
  $selectjob = "398";
} else {
  $selectjob = "395";
}

$GLOBALS['temp']['selectjob'] = $selectjob;
$GLOBALS['temp']['rows'] = "";

foreach($recordList as $rateGroup){

	$items['group_id'] = $rateGroup['rt_rate_group_ix'];
	$rate_group_inactive = $rateGroup['rt_rate_group_inactive_yn'];

	if (!$showInactiveRateGroups && $rate_group_inactive) {
		continue; // Skip inactive rate groups if the option is enabled
	}

	if ($record == $items['group_id'] && $action == "3") {
		$items['group_abbrv'] = $rateGroup['rt_rate_group_abbrv'];
		$items['group_desc'] = "<div id='rate_group_desc_".(string) $counti."' style='display:inline'></div>".$rateGroup['rt_rate_group_desc'];
	} else {
		$items['group_abbrv'] = "<input type=\"hidden\" name=\"rate_group_abbrv\" value=\"".$rateGroup['rt_rate_group_abbrv']."\" id=\"".$rateGroup['rt_rate_group_abbrv']."\">".$rateGroup['rt_rate_group_abbrv'];
		$items['group_desc'] = "<div id='rate_group_desc_".(string) $counti."' style='display:inline'>".$rateGroup['rt_rate_group_desc']."</div>";
	}
	$counti++;
	
	switch ($rateGroup['rt_rate_group_class']){
		case "1":
			$items['group_class'] = "Adult";
			break;
		case "2":
			$items['group_class'] = "Child";
			break;
		default:
			$items['group_class'] = "N/A";
	}

	$items['group_inactive'] = "";
	if ($rate_group_inactive != "0") {
		$items['group_inactive'] = "x";
	}	

	$HTML = __DIR__ . "/../../../public/html/code_rate_group_rows.htm";
	$rowHtml = Join("",File($HTML));
	$GLOBALS['temp']['rows'] .= showpage($items,$rowHtml);	
	
}

$GLOBALS['temp']['numrows'] = $counti;


if ($GLOBALS['temp']['rows'] == "") {
	$it ="<tr class='txt' height='18' bgcolor=white>
		<td height='18' class='txt' align=center>&nbsp;&nbsp;There are no existing rate groups.</td>
		</tr>";
	$GLOBALS['temp']['rows'] = $it;
}

