<?php
/*
 * $Id: init.form411.php,v 1.2 2010-10-04 15:36:20 light Exp $
 *
 * $Log: init.form411.php,v $
 * Revision 1.2  2010-10-04 15:36:20  light
 * Bug #7282 - Various ARM bugs
 *
 * Revision 1.1  2010-05-25 15:46:28  light
 * Bug #1560 - Sales management tool (Agent Relationship Management / CRM)
 *
 *
 */

/**
 * init.form411.php - CRM Event code table : list
 * Job: 367, 368, 369, 370, 371, 372
 * Function: 119 (Code Tables: CRM events)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

$orderby = (isset($_SERVER['argv'][5]) ? $_SERVER['argv'][5] : 0);

if (isset($_SERVER['argv'][6])) {
	$order = ($_SERVER['argv'][6] == "1" ? " desc" : " asc");
} else {
	$order = " asc";
}

$GLOBALS['temp']['imgMode1'] = "std";
$GLOBALS['temp']['imgMode2'] = "std";
$GLOBALS['temp']['imgMode3'] = "std";
$GLOBALS['temp']['imgMode4'] = "std";
$GLOBALS['temp']['imgMode5'] = "std";
$GLOBALS['temp']['imgMode6'] = "std";
$GLOBALS['temp']['imgMode7'] = "std";
$GLOBALS['temp']['imgMode8'] = "std";

switch ($orderby) {
case 0:
	$orderbyfield = "rc_event_desc";
	if ($order == " asc") {
		$GLOBALS['temp']['imgMode1'] = "down";
		#(name, asc)
	} else {
		$GLOBALS['temp']['imgMode2'] = "down";
		#(name, desc)
	}
	break;
case 1:
	$orderbyfield = "rc_event_abbrv";
	if ($order == " asc") {
		$GLOBALS['temp']['imgMode3'] = "down";
		#(name, asc)
	} else {
		$GLOBALS['temp']['imgMode4'] = "down";
		#(name, desc)
	}
	break;
case 2:
	$orderbyfield = "rc_event_inactive_yn";
	if ($order == " asc") {
		$GLOBALS['temp']['imgMode5'] = "down";
		#(name, asc)
	} else {
		$GLOBALS['temp']['imgMode6'] = "down";
		#(name, desc)
	}
	break;
}      

if (sizeof($GLOBALS[$form]->RecordList) < "1") {
	$RecordStart = "0";
	$tempcount = $lDB->get("SELECT COUNT(*) FROM rc_event", "1");
	$GLOBALS['temp']['numrows'] = $tempcount[0];
	$RecordCount = $tempcount[0];
	$Limit = $RecordCount;
	$RecordLimit = $RecordStart-- + $Limit++;
	
	if(checkjob("370") == true) {  
		$selectjob = "370";
		if($record == "") {    
			$selectjob = "370";
		}
	} else {
		$selectjob = "367";
	}
	$GLOBALS['temp']['selectjob'] = $selectjob;
	$GLOBALS['temp']['rows'] = "";
	$counti = "0";
	$counta = "0";
	
	if ($RecordCount != "0") { 
		$recordid = $lDB->get("
			SELECT DISTINCT
				rc_event.rc_event_ix,
				rc_event.rc_event_desc,
				rc_event_sys_code,
				rc_event.rc_event_abbrv,
				rc_event.rc_event_note,
				rc_event.rc_event_inactive_yn,
				rc_event.rc_event_db,
				rc_event.rc_event_colour
			FROM
				rc_event 
			ORDER BY
				".$orderbyfield.$order
		, "2");     
		
		# Add this line to each code table
		$rowHtml = Join("",File(__DIR__ . "/../../../public/html/code_events_rows.htm"));

		foreach ($recordid as $event) {
			if($event['rc_event_sys_code'] == "1") {
				$event['rc_event_desc'] = "<span style='color:#FF0033'>".$event['rc_event_desc']."</span>";
			}
			if ($event['rc_event_ix'] != $record) {
				if(canEditDB($event['rc_event_db'])) {
					$event['rc_event_desc'] = "<div id='name".(string) $counti++."' style='display:inline'>".$event['rc_event_desc']."</div>";
					$event['rc_event_abbrv'] = "<div id='abbrv".(string) $counta++."' style='display:inline'>".$event['rc_event_abbrv']."</div>";              
				} else {
					$event['rc_event_desc'] = "<div class='txtg' id='name".(string) $counti++."' style='display:inline'>".$event['rc_event_desc']."</div>";
					$event['rc_event_abbrv'] = "<div class='txtg' id='abbrv".(string) $counta++."' style='display:inline'>".$event['rc_event_abbrv']."</div>";              
				}
			}

			$event['rc_event_note'] = t_encodeOverlib($event['rc_event_note']);
			
			if ($record == $event['rc_event_ix'] && $action == "3") {        
				$counti--;
				$counta--;
			}
						
			if ($event['rc_event_inactive_yn'] != "0") {
				$event['rc_event_inactive_yn'] = "x";
			} else {
				$event['rc_event_inactive_yn'] = "";
			}
				
			$event['selectjob'] = $selectjob;
			if(canEditDB($event['rc_event_db'])) {
				$event['canEdit'] = "";	
				$event['rowClass'] = "linkrow";
				$event['itemClass'] = "";
			} else {
				$event['canEdit'] = "return; ";
				$event['rowClass'] = "";
				$event['itemClass'] = "txtg";
			}

			$tagNames = $lDB->get("
				SELECT 
					rc_tag.rc_tag_desc 
				FROM 
					rc_tag INNER JOIN rc_event_tag ON rc_tag.rc_tag_ix = rc_event_tag.rc_tag_id 
				WHERE 
					rc_event_tag.rc_event_id = '".$event['rc_event_ix']."'
			", "3");
			$event['event_tags'] = implode(", ", $tagNames);
			
			$GLOBALS['temp']['rows'] .= showpage($event,$rowHtml);
			
		}
	}
	$GLOBALS['temp']['rowCount'] = (string) $counti;
	if ($GLOBALS['temp']['rows'] == "") {
		$it = "
			<tr class='txt' height='18'>
				<td height='18' class='txt' align='center' colspan='4'>There are no existing events.</td>
			</tr>
		";
		$GLOBALS['temp']['rows'] = $it;
	}
}
