<?php
/*
 * $Id: init.form412.php,v 1.3 2010-10-04 15:36:20 light Exp $
 *
 * $Log: init.form412.php,v $
 * Revision 1.3  2010-10-04 15:36:20  light
 * Bug #7282 - Various ARM bugs
 *
 * Revision 1.2  2010-07-19 12:43:28  light
 * Bug #7243 - Add Active/Inactive status change (flag) drop-down on the Sales Profile Objects Code table
 *
 * Revision 1.1  2010-05-25 15:46:28  light
 * Bug #1560 - Sales management tool (Agent Relationship Management / CRM)
 *
 *
 */

/**
 * init.form412.php - Sales Profile code table : add/edit
 * Job: 373, 374, 375, 376, 377, 378
 * Function: 120 (Code Tables: CRM sales profile)
 */
   
if(isset($_POST['url']) && $_POST['url'] != "") {
	$linkurl = explode("#",$_POST['url']);
}

if(isset($linkurl[0]) && $linkurl[0] != "") {
	$_SERVER['argv'] = explode("+",substr($linkurl[0],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_sales_profile.htm");
	$GLOBALS['temp']['colData'] = "''";
}

$record = (isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "");
$GLOBALS['passthrurecord'] = (isset($GLOBALS['passthrurecord']) ? $GLOBALS['passthrurecord'] : "");
$_SERVER['argv'][1] = (isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "");

$options = (isset($_SERVER['argv'][2]) ? $_SERVER['argv'][2] : "");
switch ( $options & 7 ) {
case ADD_OBJECT:
	$renderMode = "sales";
	$renderType = "addObject";
	break;

case DEFINE_OBJECT:
	$renderMode = "sales";
	$renderType = "defineObject";
	$objHTML = Join("",file(__DIR__ . "/../../../public/html/code_sales_object_details.htm"));
	break;

case EDIT_OBJECT:
	$renderMode = "sales";
	$renderType = "editObject";
	$objHTML = Join("",file(__DIR__ . "/../../../public/html/code_sales_object_details.htm"));
	break;

default:
	$renderMode = "sales";
	$renderType = "addObject";
	$objHTML = Join("",file(__DIR__ . "/../../../public/html/code_sales_object_new.htm"));
	break;
}

if ($renderMode == "sales" && $renderType == "addObject") {
	if($GLOBALS['jobLevelArray']['373'] > 5) {
		$noAccess = "";
	} else {
		$noAccess = " disabled";
	}
	
	$objHTML = str_replace("!noAccess!", $noAccess, $objHTML);
	$GLOBALS['temp']['objectCol'] = $objHTML;
}

if ($renderMode == "sales" && $renderType == "defineObject" || $renderType == "editObject") {
	$colData = array();
	$delClass = 0;
	$compChecked = '';
	$GLOBALS['temp']['colData'] = "''";

	if (!isset($GLOBALS['temp']['objectCol'])) {
		$GLOBALS['temp']['objectCol'] = "";
	}
	if ($renderType == "defineObject") {
		$objVal = $_SERVER['argv'][3];
		$objLabel = '';
		$objId = '';
		if($objVal == DB_RC_OBJ_SALES_RADIO || $objVal == DB_RC_OBJ_SALES_CHECKBOX || $objVal == DB_RC_OBJ_SALES_SELECTBOX) {
			for($i=0; $i<3; $i++) {
				$j = $i+1;
				$colDataItem = array(
					'"id":"'.$j.'"',
					'"data_id":""',
					'"content":""',
					'"status":"0"',
					'"active":"1"',
					'"delClass":"'.$delClass.'"',
					'"order":"'.$j.'"'
				); 
				array_push($colData,'{'.join(",",$colDataItem)."}\n");
			}
			$colData = '['.join(",",$colData).']';
			$GLOBALS['temp']['colData'] = $colData;
		}
	}
	if ($renderType == "editObject") {
		$objId = $record;
		if($objId != '') {
			$objDetails = db_rc_obj_sales_select($objId);
			$objVal = $objDetails['rc_obj_sales_type_ind'];
			$objLabel = t_encodeHTMLField($objDetails['rc_obj_sales_label']);
			
			if($objDetails['rc_obj_sales_mandatory_yn'] == '1') {
				$compChecked = 'checked = "checked"';
			}
			
			$cnt = count($objDetails['obj_data']);
			
			if(($objVal == DB_RC_OBJ_SALES_RADIO || $objVal == DB_RC_OBJ_SALES_CHECKBOX || $objVal == DB_RC_OBJ_SALES_SELECTBOX) && $cnt>0) {
				for($i=0; $i<$cnt; $i++) {
					if($objDetails['obj_data'][$i]['rc_obj_sales_data_inactive_yn'] == 1) {
						$inactivechecked = 1;
						$delClass = 0;
					} else {
						$inactivechecked = 0;
						$delClass = 1;
					}
					$j = $i+1;
					$colDataItem = array(
						'"id":"'.$j.'"',
						'"data_id":"'.$objDetails['obj_data'][$i]['rc_obj_sales_data_ix'].'"',
						'"content":"'.t_encodeHTMLField($objDetails['obj_data'][$i]['rc_obj_sales_data_content']).'"',
						'"status":"'.$inactivechecked.'"',
						'"active":"1"',
						'"delClass":"'.$delClass.'"',
						'"order":"'.$objDetails['obj_data'][$i]['rc_obj_sales_data_sort_seq'].'"'
					); 
					array_push($colData,'{'.join(",",$colDataItem)."}\n");
				}
				$colData = '['.join(",",$colData).']';
				$GLOBALS['temp']['colData'] = $colData;
			}
		}
	}

	switch ( $objVal) {
	case DB_RC_OBJ_SALES_TEXTBOX:
		$objType = "Text field";
		$compClass = '';
		$optionClass = 'style="display:none";';
		break;

	case DB_RC_OBJ_SALES_TEXTAREA:
		$objType = "Text area";
		$compClass = 'style="display:none";';
		$optionClass = 'style="display:none";';
		break;

	case DB_RC_OBJ_SALES_RADIO:
		$objType = "Radio button";
		$compClass = 'style="display:none";';
		$optionClass = '';
		break;
	
	case DB_RC_OBJ_SALES_CHECKBOX:
		$objType = "Checkbox";
		$compClass = 'style="display:none";';
		$optionClass = '';
		break;
	
	case DB_RC_OBJ_SALES_SELECTBOX:
		$objType = "Drop down";
		$compClass = '';
		$optionClass = '';
		break;
	case DB_RC_OBJ_SALES_NUMERIC:
		$objType = "Numeric field";
		$compClass = '';
		$optionClass = 'style="display:none";';
		break;
	}
	
	$item['objId'] = $objId;
	$item['objType'] = $objType;
	$item['objLabel'] =  t_encodeHTMLField($objLabel);
	$item['objTypeVal'] = $objVal;
	$item['compChecked'] = $compChecked;
	$item['compClass'] = $compClass;
	$item['optionClass'] = $optionClass;
	$item['tripClass'] = "style='display:none;'";
	
	$GLOBALS['temp']['objectCol'] .= showpage($item, $objHTML);
}

$GLOBALS['autovar'] = "1";
if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = $GLOBALS['passthrurecord'];
		if ($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}

$GLOBALS['temp']['record'] = $record;
$GLOBALS[$form]->Get($action);

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);


$actVal = "0";
$inActVal = "1";
if (isset($objDetails['rc_obj_sales_inactive_yn']) && $objDetails['rc_obj_sales_inactive_yn'] == $actVal || $action == "2") {
	$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
} else {
	if ($record == "" && $action == "1") {
		$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	} else {
		$GLOBALS['temp']['actInd'] = "";
	}
}


$newr = 374;
$edit = $newr + 2;
$view = $newr - 1;
$dele = $newr + 4;
$sedit = $edit + 1;
$snewr = $newr + 1;

// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
// End Access Control Toolbar Setup
	
$GLOBALS['temp']['new_record'] = "reservation.php?".$newr;

switch ($action) {
case (0) : // List Records
	break;

case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+3";
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	break;

case (2) : // Add Record
	$GLOBALS[$form]->Arguments = (string) $snewr;
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['temp']['record'] = "";
	$GLOBALS['mode'] = "new";

	if($pmode == 1) {
		$rc_obj_sales_mandatory_yn = 0;
		if(isset($_POST['rc_obj_sales_mandatory_yn']) && $_POST['rc_obj_sales_mandatory_yn'] == '1'){
			$rc_obj_sales_mandatory_yn = 1;
		}
		
		if (isset($_POST['rc_obj_sales_type_ind']) && isset($_POST['rc_obj_sales_label'])) {
			$obj_sales_id = db_rc_obj_sales_insert($_POST['rc_obj_sales_type_ind'], $_POST['rc_obj_sales_label'], $rc_obj_sales_mandatory_yn);
		}
		
		if(isset($obj_sales_id) && isset($_POST['att_label']) && count($_POST['att_label'])>0) {
			for($i=0; $i<count($_POST['att_label']); $i++) {
				if($_POST['att_label'][$i] !='') {
					$obj_sales_data_id = db_rc_obj_sales_data_insert($obj_sales_id, $_POST['att_label'][$i], $_POST['rc_obj_sales_data_sort_seq'][$i], 0,$_POST['att_status'][$i], $dbcode);
				}
			}
		}
	}
	break;

case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = (string) $sedit."+".$record;
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record."+3";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record;

	if($pmode == 1) {
		$rc_obj_sales_id = $_POST['rf_obj_ix'];
		$rc_obj_sales_mandatory_yn = 0;
		if(isset($_POST['rc_obj_sales_mandatory_yn']) && $_POST['rc_obj_sales_mandatory_yn'] == '1'){
			$rc_obj_sales_mandatory_yn = 1;
		}
		
		db_rc_obj_sales_update($rc_obj_sales_id, $_POST['rc_obj_sales_label'], $rc_obj_sales_mandatory_yn);
		$objDetails = db_rc_obj_sales_select($rc_obj_sales_id);

		if ($objDetails['rc_obj_sales_inactive_yn'] == "1" && $_POST['rc_obj_sales_inactive_yn'] != $objDetails['rc_obj_sales_inactive_yn']){
			db_rc_obj_sales_set_inactive($record, $_POST['rc_obj_sales_inactive_yn']);
		}
		
		$obj_sales_dataIds = $lDB->get("SELECT rc_obj_sales_data_ix FROM rc_obj_sales_data WHERE rc_obj_sales_id = '$rc_obj_sales_id'", 3);
		
		if(is_array($obj_sales_dataIds)) {
			foreach($obj_sales_dataIds as $obj_sales_dataId) {
				if(!in_array($obj_sales_dataId, $_POST['rc_obj_sales_data_id'])) {
					db_rc_obj_sales_data_delete($obj_sales_dataId);
				}
			}
		}

		$counter = count(isset($_POST['rc_obj_sales_data_id'])?$_POST['rc_obj_sales_data_id']:array());
		if($counter>0) {
			for($i=0; $i<$counter; $i++) {
				if($_POST['att_label'][$i] !='') {
					if($_POST['rc_obj_sales_data_id'][$i] != '') {
						db_rc_obj_sales_data_update($_POST['rc_obj_sales_data_id'][$i], $_POST['att_label'][$i], $_POST['rc_obj_sales_data_sort_seq'][$i], $_POST['att_status'][$i]);
					} else {
						$obj_sales_data_id = db_rc_obj_sales_data_insert($rc_obj_sales_id, $_POST['att_label'][$i], $_POST['rc_obj_sales_data_sort_seq'][$i], 0, $_POST['att_status'][$i], $dbcode);
					}
				}
			}
		}
	}
	break;

case (4) : // Delete Record
	if(db_pr_sales_obj_data_exists($record, "rc_obj_sales_id")) {
		db_rc_obj_sales_set_inactive($record, 1);
	} else {
		$res = db_rc_obj_sales_delete($record);
	}
	break;
}

$objectVal = (isset($_SERVER['argv'][3]) ? $_SERVER['argv'][3] : "");
if($options!="" && $objectVal != ""){
	$GLOBALS['temp']['new_record'] .= "++".$options."+".$objectVal;
}
