<?php
/*
 * $Id: init.form413.php,v 1.1 2010-05-25 15:46:28 light Exp $
 *
 * $Log: init.form413.php,v $
 * Revision 1.1  2010-05-25 15:46:28  light
 * Bug #1560 - Sales management tool (Agent Relationship Management / CRM)
 *
 *
 */

/**
 * init.form413.php - Sales Profile code table : list
 * Job: 373, 374, 375, 376, 377, 378
 * Function: 120 (Code Tables: CRM sales profile)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_sales_profile_list.htm");
}

$orderby = isset($_SERVER['argv'][4]) ? $_SERVER['argv'][4] : 0;

if (isset($_SERVER['argv'][5])) {
	$order = ($_SERVER['argv'][5] == "1") ? " desc" : " asc";
} else {
	$order = " asc";
}

// Counter for preventing duplicate entries
$counti = 0;

$selectjob = $_SERVER['argv'][1];
$GLOBALS['temp']['imgSort1'] = "";
$GLOBALS['temp']['imgSort2'] = "";
$GLOBALS['temp']['imgSort3'] = "";
$GLOBALS['temp']['imgSort4'] = "";
$GLOBALS['temp']['imgSort5'] = "";
$GLOBALS['temp']['imgSort6'] = "";

$GLOBALS['temp']['imgSort1Mode'] = "std"; #(name, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(name, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(abbrev, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(abbrev, desc)
$GLOBALS['temp']['imgSort5Mode'] = "std"; #(inactive, asc)
$GLOBALS['temp']['imgSort6Mode'] = "std"; #(inactive, desc)

switch ($orderby) {
    case 0:
    case 1:
        $orderbyfield = "rc_obj_sales_label";
        if ($order == " asc") {
            $GLOBALS['temp']['imgSort1Mode'] = "down"; #(name, asc)
        }else {
            $GLOBALS['temp']['imgSort2Mode'] = "down"; #(name, desc)
        }
        break;
    case 2:
        $orderbyfield = "rc_obj_sales_inactive_yn";
        if ($order == " asc") {
            $GLOBALS['temp']['imgSort6Mode'] = "down"; #(name, asc)
        }else {
            $GLOBALS['temp']['imgSort5Mode'] = "down"; #(name, desc)
        }
        break;
    default:	// default is not to sort
        $orderbyfield = "rc_obj_sales_sort_seq";
        break;
}

if (sizeof($GLOBALS[$form]->RecordList) < "1") {
	$RecordStart = "0";
	$where = " WHERE rc_obj_sales_sys_code=0";
	$tempcount = db_rc_obj_sales_select_by_condition($where, "rc_obj_sales_sort_seq", $order);
	
	$GLOBALS['temp']['numrows'] = sizeof($tempcount);
	$RecordCount = sizeof($tempcount);
	$Limit = $RecordCount;
	$RecordLimit = $RecordStart-- + $Limit++;

	$GLOBALS['temp']['selectjob'] = "";
	
	$sortclick = "0";
	if(checkjob("376") == true){
		$selectjob = "376";
		if($record == ""){
			$sortclick = "374";
		}
	}else {
		$selectjob = "373";
	}
	if ($sortclick == "0") {
		$sortclick = $selectjob;
	}

	$GLOBALS['temp']['selectjob'] = $selectjob;
	$GLOBALS['temp']['sortclick'] = $sortclick;
	$GLOBALS['temp']['rows'] = "";
	if ($RecordCount != "0") {
		$list = db_rc_obj_sales_select_by_condition($where, $orderbyfield, $order);
		$rowHtml = Join("",File(__DIR__ . "/../../../public/html/code_sales_profile_rows.htm"));
		
		$list = isset($list) ? $list : array();

		foreach($list as $item) {
			if ($item['rc_obj_sales_ix'] != "" && $item['rc_obj_sales_label'] != "") {
				if($item['rc_obj_sales_ix'] != $record){
					if(canEditDB($item['rc_obj_sales_db'])) {
						$item['rc_obj_sales_label'] = "<span id='obj_sales".(string) $counti++."'>". $item['rc_obj_sales_label']. "</span>";
					} else {
						$item['rc_obj_sales_label'] = "<span class='txtg' id='obj_sales".(string) $counti++."'>" .$item['rc_obj_sales_label']."</span>";
					}
				}
				
				if ($item['rc_obj_sales_inactive_yn'] == '1') {
					$item['rc_obj_sales_inactive_yn'] = "x";
				} else {
					$item['rc_obj_sales_inactive_yn'] = "";
				}
				$item['selectjob'] = $selectjob;
				if(canEditDB($item['rc_obj_sales_db'])) {
					$item['rowClass'] = "linkrow";
					$item['itemClass'] = "";
					$item['canEdit'] = "";
				} else {
					$item['rowClass'] = "";
					$item['itemClass'] = "txtg";
					$item['canEdit'] = "return;";
				}

				$item['rc_obj_sales_type'] = db_rc_obj_sales_type_ind_desc($item['rc_obj_sales_type_ind']);
				$GLOBALS['temp']['rows'] .= showpage($item, $rowHtml);
			}
		}
	} else {
		$noDataRow = "
			<tr class='txt' height='20'>
				<td height='20' class='txt' colspan=3 align=center>&nbsp;&nbsp;
					There are no sales objects.</td>
			   </tr>";
		$GLOBALS['temp']['rows'] = $noDataRow;
	}
}

$GLOBALS['temp']['rowCount'] = (string) $counti;
$GLOBALS['temp']['orderButtonText'] = 'Set display order on Sales profile screen';
if($GLOBALS['jobLevelArray']['373'] > 5) {
	$GLOBALS['temp']['noAccess'] = "";
} else {
	$GLOBALS['temp']['noAccess'] = " disabled";
}
