<?php

require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . "/db.pr_sales_obj_data.php");
require_once(__DIR__ . "/db.pr_guest.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rc_obj_sales.php");

function createfield($obj, $record, $action=1, $skip=0) {
	global $lDB;
	if($obj['rc_obj_sales_type_ind'] == '') {
		$obj['rc_obj_sales_type_ind'] = 1;
	}

	if($obj['rc_obj_sales_inactive_yn'] ==1) {
		$class = "txtg";
	} else {
		$class = "txt";
	}

	$val = '';
	$objHTML = '';
	$tabIndex = 22+$obj['rc_obj_sales_sort_seq'];
	switch($obj['rc_obj_sales_type_ind']) {
	case DB_RC_OBJ_SALES_TEXTBOX:
		if($action == 3 || $action == 1) {
			$res = $lDB->get("
				SELECT 
					pr_sales_obj_data.pr_sales_obj_data_text 
				FROM 
					pr_sales_obj_data 
				WHERE 
					pr_persona_id = '$record' 
					AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
			",2);
			$val = isset($res[0]['pr_sales_obj_data_text']) ? $res[0]['pr_sales_obj_data_text'] : "";
		} else {
			$val = '';
		}
		$objHTML .= "<input type='text' tabindex='".$tabIndex."' class='$class' maxlength='50' name='rc_obj_sales_".$obj['rc_obj_sales_ix']."' id='rc_obj_sales_".$obj['rc_obj_sales_ix']."' value='$val' style='width: 270px; height: 20px;' />";
		$obj['rc_obj_sales_button'] = "&nbsp;";
		break;
	
	case DB_RC_OBJ_SALES_TEXTAREA:
		$val = '';
		if($action == 3 || $action == 1) {
			$res = $lDB->get("
				SELECT 
					pr_sales_obj_data.pr_sales_obj_data_memo 
				FROM 
					pr_sales_obj_data 
				WHERE 
					pr_persona_id = '$record' 
					AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
			", 2);
				
		}
		$val = isset($res[0]['pr_sales_obj_data_memo']) ? $res[0]['pr_sales_obj_data_memo'] : "";
		
		$objHTML .= "<textarea class='$class' name='rc_obj_sales_".$obj['rc_obj_sales_ix']."' id='rc_obj_sales_". $obj['rc_obj_sales_ix']."' style='width: 270px; overflow-y:scroll;' tabindex='".$tabIndex."' >". $val ."</textarea>";
		$obj['rc_obj_sales_button'] = "&nbsp;";
		break;
		
	case DB_RC_OBJ_SALES_RADIO:
		$val = '';
		if($action == 3 || $action == 1) {
			$val = $lDB->get("
				SELECT 
					pr_sales_obj_data.rc_obj_sales_data_id 
				FROM 
					pr_sales_obj_data 
				WHERE 
					pr_persona_id = '$record' 
					AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
			", 4);
		} 
		$obj_data = db_rc_obj_sales_data_select($obj['rc_obj_sales_ix']);
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rc_obj_sales_data_inactive_yn'] != 0 && $val != $data['rc_obj_sales_data_ix']) {
					continue;
				}
				if($data['rc_obj_sales_data_inactive_yn'] == 1 || $obj['rc_obj_sales_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "<input type='radio' value='".$data['rc_obj_sales_data_ix']."' name='rc_obj_sales_".$obj['rc_obj_sales_ix']."'";
				if($val == $data['rc_obj_sales_data_ix']) {
					$objHTML .= " checked='checked'";
				}
				$objHTML .= " tabindex='".$tabIndex."' style='margin-left:0px; padding:0px; *margin-left:-2px'><span class='$inactClass'>". $data['rc_obj_sales_data_content']."</span><br>";
			}
		}
		$obj['rc_obj_sales_button'] = "&nbsp;";
		break;

	case DB_RC_OBJ_SALES_CHECKBOX:
		$val = array();
		if($action == 3 || $action == 1) {
			$val = $lDB->get("
				SELECT 
					pr_sales_obj_data.rc_obj_sales_data_id 
				FROM 
					pr_sales_obj_data 
				WHERE 
					pr_persona_id = '$record' 
					AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
			", 3);
		}
				
		$obj_data = db_rc_obj_sales_data_select($obj['rc_obj_sales_ix']);
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rc_obj_sales_data_inactive_yn'] != 0 && !in_array($data['rc_obj_sales_data_ix'], $val)) {
					continue;
				}
				if($data['rc_obj_sales_data_inactive_yn'] == 1 || $obj['rc_obj_sales_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "<input type='checkbox' value='".$data['rc_obj_sales_data_ix']."' name='rc_obj_sales_".$obj['rc_obj_sales_ix']."[]'";
				if(in_array($data['rc_obj_sales_data_ix'], $val)) {
					$objHTML .= " checked='checked'";
				}
				$objHTML .= " tabindex='".$tabIndex."' style='margin-left:0px; padding:0px; *margin-left:-2px'><span class='$inactClass'>". $data['rc_obj_sales_data_content'] ."<span><br>";
			}
		}
		$obj['rc_obj_sales_button'] = "&nbsp;";
		break;
		
	case DB_RC_OBJ_SALES_SELECTBOX:
		$val = '';
		if($action == 3 || $action == 1) {
			$val = $lDB->get("
				SELECT 
					pr_sales_obj_data.rc_obj_sales_data_id 
				FROM 
					pr_sales_obj_data 
				WHERE 
					pr_persona_id = '$record' 
					AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
			", 4);
		}
		$obj_data = db_rc_obj_sales_data_select($obj['rc_obj_sales_ix']);
			
		$objHTML .= "
			<select name='rc_obj_sales_".$obj['rc_obj_sales_ix']."' style='width: 170px;' tabindex='".$tabIndex."'>
				<option value=''>&nbsp;</option>	
		";
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rc_obj_sales_data_inactive_yn'] != 0 && $val != $data['rc_obj_sales_data_ix']) {
					continue;
				}
				if($data['rc_obj_sales_data_inactive_yn'] == 1 || $obj['rc_obj_sales_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "<option value='".$data['rc_obj_sales_data_ix']."'";
				if($val == $data['rc_obj_sales_data_ix']) {
					$objHTML .= " selected='selected'";
				}
				$objHTML .= " class='$inactClass'>". $data['rc_obj_sales_data_content']."</option>";
			}
		}
		$objHTML .= "</select>";
		break;
		
	case DB_RC_OBJ_SALES_NUMERIC:
		$val = '';
		if($action == 3 || $action == 1) {
			$res = $lDB->get("
				SELECT 
					pr_sales_obj_data.pr_sales_obj_data_text 
				FROM 
					pr_sales_obj_data 
				WHERE 
					pr_persona_id = '$record' 
					AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
			", 2);
			
			$val = isset($res[0]['pr_sales_obj_data_text']) ? $res[0]['pr_sales_obj_data_text'] : "";
		}
		$objHTML .= "<input type='text' tabindex='".$tabIndex."' class='$class' maxlength='50' style='width: 270px; height: 20px;' value='$val' name='rc_obj_sales_".$obj['rc_obj_sales_ix']."' id='rc_obj_sales_".$obj['rc_obj_sales_ix']."' onkeypress='ensureNumeric()' />";
		break;
		
	case DB_RC_OBJ_SALES_DATE:
		$val = '0000-00-00';
		if($obj['rc_obj_sales_sys_code'] == 4 && $skip == 0) {
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_persona.pr_birthdate 
					FROM 
						pr_persona 
					WHERE 
						pr_persona_ix = '$record'
				",4);
			} 
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_birth_row.htm"));
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);
			$objHTML = str_replace("!guest_birthdate_val!", $val, $objHTML);
			$objHTML = str_replace("!guest_birthdate!", 'rc_obj_sales_'.$obj['rc_obj_sales_ix'], $objHTML);
			$GLOBALS['temp']['guest_birthdate'] = 'rc_obj_sales_'.$obj['rc_obj_sales_ix'];
			
		} elseif($obj['rc_obj_sales_sys_code'] == 5 && $skip == 0) {
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_persona.pr_anniversary 
					FROM 
						pr_persona 
					WHERE 
						pr_persona_ix = '$record'
				",4);
			}
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_anniversary_row.htm"));
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);
			$objHTML = str_replace("!guest_anniversary_val!", $val, $objHTML);
			$objHTML = str_replace("!guest_anniversary!", 'rc_obj_sales_'.$obj['rc_obj_sales_ix'], $objHTML);
			$GLOBALS['temp']['guest_anniversary'] = 'rc_obj_sales_'.$obj['rc_obj_sales_ix'];
		}
		$obj['rc_obj_sales_button'] = "&nbsp;";
		break;
		
	case DB_RC_OBJ_SALES_NATION_LOOKUP:
		if($obj['rc_obj_sales_sys_code'] == 1) {
			$name = "";
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_sales_obj_data.rc_obj_sales_data_id 
					FROM 
						pr_sales_obj_data 
					WHERE 
						pr_persona_id = '$record' 
						AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
				", 4);
				if($val != "") {
					if($val == "0") {
						$name = "No Event";
					} else {
						$name = $lDB->get("SELECT rc_event_desc FROM rc_event WHERE rc_event_ix = '$val'",4);
					}
				}
			} 
						
			$objHTML .= '<textarea id="rc_event_desc" name="rc_event_desc" class="txt" readonly="readonly" rows="1" cols="30" tabindex="4" style="width: 270px; height: 20px;">!rc_event_desc!</textarea>
				<input id="rc_event_id" name="rc_obj_sales_'.$obj['rc_obj_sales_ix'].'" value="!rc_event_id!" type="hidden">';
			
			$obj['rc_obj_sales_button'] = '<button onclick="event_popup()" id="event_button" class="button printCollapse" style="width: 18px; height: 20px; background-position:left; padding: 0px;" type="button"><i class="material-icons">search</i></button>';
				
			$objHTML = str_replace("!rc_event_desc!", $name, $objHTML);
			$objHTML = str_replace("!rc_event_id!", $val, $objHTML);
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);

		} elseif ($obj['rc_obj_sales_sys_code'] == 2) {
			$name = "";
			$internalRepIds = "0";
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_sales_obj_data.rc_obj_sales_data_id 
					FROM 
						pr_sales_obj_data 
					WHERE 
						pr_persona_id = '$record' 
						AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
				", 3);
				if($val) {
					$nameArr = $lDB->get("SELECT pr_name_first, pr_name_last FROM pr_persona WHERE pr_persona_ix IN ('".join("','",$val)."')",2);
					
					$newNameArr = array();
					foreach ($nameArr as $name) {
						if($name['pr_name_first'] != "") {
							$fullName = $name['pr_name_first']." ".$name['pr_name_last'];
						} else {
							$fullName = $name['pr_name_last'];
						}
						$newNameArr[] = $fullName;
					}
					$name =  join(",",$newNameArr);
					$internalRepIds = join(":",$val);
				}
			}
			$objHTML .='<textarea id="internalRepFilter" rows="1" style="width: 270px; height: 20px;" class="txtg scrollY" readonly="readonly" tabindex="-1">!internalRepNames!</textarea>
			<input type="hidden" name="internalRepIds" id="internalRepIds" value="!internalRepIds!">';
			//$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_sales_internal_rep_row.htm"));
			$objHTML = str_replace("!internalRepNames!", $name, $objHTML);
			$objHTML = str_replace("!internalRepIds!", $internalRepIds, $objHTML);
			
			$obj['rc_obj_sales_button'] = '<button type="button" onclick="openFilter(\'internalRep\')" style="width:18; height:20; background-position: left; padding: 0px;" class="button " tabIndex="12" valign="top"><i class="material-icons">search</i></button>';
					
		} elseif($obj['rc_obj_sales_sys_code'] == 3) {
			$name = "";
			$propertiesIds = "0";
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_sales_obj_data.rc_obj_sales_data_id 
					FROM 
						pr_sales_obj_data 
					WHERE 
						pr_persona_id = '$record' 
						AND rc_obj_sales_id = '$obj[rc_obj_sales_ix]'
				", 3);
				if($val) {
					$name = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix IN ('".join("','",$val)."')",3);
					if(!empty($name)) {
						$name =  join(",",$name);
					} else {
						$name = "";
					}
					$propertiesIds = join(":",$val);
				} else {
					$name = "";
				}
			}
			
			$objHTML .= '<textarea id="propertiesFilter" rows="1" style="width: 270px; height: 20px;" class="txtg scrollY" readonly="readonly" tabindex="-1">!propertiesNames!</textarea>
			<input type="hidden" name="propertiesIds" id="propertiesIds" value="!propertiesIds!">';

			//$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_sales_property_row.htm"));
			$objHTML = str_replace("!propertiesNames!", $name, $objHTML);
			$objHTML = str_replace("!propertiesIds!", $propertiesIds, $objHTML);

			
			$obj['rc_obj_sales_button'] = '<button type="button" onclick="openFilter(\'properties\')" style="width:18; height:20; background-position: left; padding: 0px;" class="button" tabIndex="12" valign="top"><i class="material-icons">search</i></button>';
					
		}
		break;
	}

	if(empty($val) && $obj['rc_obj_sales_inactive_yn'] !=0 && $obj['rc_obj_sales_sys_code']<1) {
		$rowHTML = "";	
	} else {
		$style = "txt";
		if($obj['rc_obj_sales_inactive_yn'] ==1) {
			$style = "txtg";
		}
		
		if(($obj['rc_obj_sales_sys_code'] == 4 || $obj['rc_obj_sales_sys_code'] == 5)  && $skip == 1) {
			$rowHTML = "";	
		} else {
			if($obj['rc_obj_sales_label'] != "") {
				$rowHTML = "
					<tr>
						<td valign='top'>&nbsp;</td>
						<td class='$style' valign='top'>" .$obj['rc_obj_sales_label']. ":</td>
						<td><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
						<td>".(isset($obj['rc_obj_sales_button']) ? $obj['rc_obj_sales_button'] : "")."</td>
						<td valign='top' class='$style'>". $objHTML ."</td>
					</tr>
				";
			} else {
				$rowHTML = "";	
			}
		}
	}
	
	return $rowHTML;
}

function saveChanges($record,$obj_sales) {
	global $lDB;
	
	foreach($obj_sales as $obj) {
		if(array_key_exists('propertiesIds', $_POST) && $obj['rc_obj_sales_sys_code'] == 3) {
			if($_POST['propertiesIds'] == "") {
				
				$listArray = $lDB->get("
					SELECT DISTINCT
						ac_accomm_type.pr_business_id as id
					FROM 
						sc_accomm,
						ac_accomm_type,
						pr_business,
						pr_persona
					WHERE
						sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
					AND 
						sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
					AND 
						ac_accomm_type.ac_accomm_type_inactive_yn = 0
					AND 
						ac_accomm_type.pr_business_id = pr_business.pr_business_id
					AND 
						pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
				", 3);
				$_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']] = $listArray;
			} else {
				$_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']] = explode(":", $_POST['propertiesIds']);
			}
		}
		if(array_key_exists('internalRepIds', $_POST) && $obj['rc_obj_sales_sys_code'] == 2) {
			$_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']] = explode(":", $_POST['internalRepIds']);
		}

		if(isset($_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']]) && is_array($_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']])) {
			$pr_sales_obj_data_ids = $lDB->get("SELECT pr_sales_obj_data_ix FROM pr_sales_obj_data WHERE rc_obj_sales_id = '".$obj['rc_obj_sales_ix']."' AND pr_persona_id = '".$record."'", 3);
			if(is_array($pr_sales_obj_data_ids) && !empty($pr_sales_obj_data_ids)) {
				foreach ($pr_sales_obj_data_ids as $pr_sales_obj_data_id) {
					if(!in_array($pr_sales_obj_data_id, $_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']])) {
						db_pr_sales_obj_data_delete($pr_sales_obj_data_id);
					}
				}
			}
			foreach($_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']] as $chk) {
				if(!is_array($pr_sales_obj_data_ids) || !in_array($chk, $pr_sales_obj_data_ids)){
					$pr_sales_obj_data_id = db_pr_sales_obj_data_insert($record, $obj['rc_obj_sales_ix'], $chk);
				}
			}
			
		} else {
			if(array_key_exists('rc_obj_sales_'. $obj['rc_obj_sales_ix'], $_POST)) {
				if($obj['rc_obj_sales_sys_code'] == 4) {
					db_pr_persona_update_birthdate($record, $_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']]);
					
				} elseif($obj['rc_obj_sales_sys_code'] == 5) {
					db_pr_persona_update_anniversary($record, $_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']]);
				
				} else {
					if(db_pr_sales_obj_data_exists_by_persona($record, $obj['rc_obj_sales_ix'])) {
						$pr_sales_obj_data_id = db_pr_sales_obj_data_select_by_persona($record, $obj['rc_obj_sales_ix']);
						
						if(array_key_exists('rc_obj_sales_'. $obj['rc_obj_sales_ix'],$_POST)) {
							db_pr_sales_obj_data_update($pr_sales_obj_data_id, $obj['rc_obj_sales_ix'], $_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']]);
						}
					} else {
						$pr_sales_obj_data_id = db_pr_sales_obj_data_insert($record, $obj['rc_obj_sales_ix'], $_POST['rc_obj_sales_'.$obj['rc_obj_sales_ix']]);
					}
				}
			} else {
				// No ID's were passed through the POST (all options deselected), so we clear whatever is already saved.
				$pr_sales_obj_data_ids = $lDB->get("SELECT pr_sales_obj_data_ix FROM pr_sales_obj_data WHERE rc_obj_sales_id = '".$obj['rc_obj_sales_ix']."' AND pr_persona_id = '".$record."'", 3);
				if(is_array($pr_sales_obj_data_ids)) {
					foreach ($pr_sales_obj_data_ids as $pr_sales_obj_data_id) {
						db_pr_sales_obj_data_delete($pr_sales_obj_data_id);
					}
				}
			}
		}
	}
	
	return $record;
}
