<?php

/**
 * init.form419.func.php - CRM Custom Report
 * Job: 394
 * Function: 122 (Reports: CRM)
 */

require_once(__DIR__ . "/functions.report.php");
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');   
require_once(__DIR__ . '/functions.profile.php');   
require_once ('class.xls.php');

define("REP_EMAIL_CONTACT",12); //To identify email to agent event.
define("REP_EMAIL_CONTACT_SEND",13); //To send email to agent.

$profileFields = array(
	/*  1 */ "contactRoleIds",
	/*  2 */ "contact_name_opt",
	/*  3 */ "contactType",
	/*  4 */ "contactNameIds",
	/*  5 */ "cont_name",
	/*  6 */ "email",
	/*  7 */ "postSub",
	/*  8 */ "physSub",
	/*  9 */ "guestPostCountryIds",
	/* 10 */ "guestPhysCountryIds",
	/* 11 */ "postZip",
	/* 12 */ "physZip",
	/* 13 */ "inactive_contact",
	/* 14 */ "birthQuick",
	/* 15 */ "birthFromDate",
	/* 16 */ "birthToDate",
	/* 17 */ "annQuick",
	/* 18 */ "annFromDate",
	/* 19 */ "annToDate",
	/* 20 */ "custemProfile",
	/* 21 */ "eventType",
	/* 22 */ "eventQuick",
	/* 23 */ "fromDate",
	/* 24 */ "toDate",
	/* 25 */ "eventActionIds",
	/* 26 */ "eventTagIds",
	/* 27 */ "eventIds",
	/* 28 */ "internalRepIds",
	/* 29 */ "clientRepIds",
	/* 30 */ "event_completed",
	/* 31 */ "contactDetailsCols",
	/* 32 */ "salesProfileCols",
	/* 33 */ "eventCols",
	/* 34 */ "pageNum",
	/* 35 */ "renderOption",
	/* 36 */ "randomId",
	/* 37 */ "agentCols",
	/* 38 */ "agentNameRadio",
	/* 39 */ "agentIds",
	/* 40 */ "agentCountryIds",
	/* 41 */ "agentLinked",
	/* 42 */ "travelQuick",
	/* 43 */ "travelFromDate",
	/* 44 */ "travelToDate",
	/* 45 */ "accommIds",
	/* 46 */ "addressSearchType"	
);

function outputHTML($cols,$salesCols,$agentCols,$eventCols,$guestData) {
	global $lDB;
	$GLOBALS['temp']['displayChart']  = '';
	$GLOBALS['temp']['showResults']   = '';
	$conScrollSet = array();
	$colsDisplay = 0;
	$eventDisplay = 0;
	$rows = '<col width="40" />';
	$rows .= '<col width="20" />';
	$tableWidth = 60;
	$colspan=2;
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$colsDisplay = 1;
			if($col['split'] != 1) {
				$rows .= '<col width="'.$col['width'].'" />';
				$tableWidth += $col['width'];
				$colspan++;
			} else {
				if($col['objType'] == "10") {
					$rows .= '<col width="'.$col['width'].'" />';
					$rows .= '<col width="'.$col['width'].'" />';
					$rows .= '<col width="'.$col['width'].'" />';
					$tableWidth += $col['width'];
					$tableWidth += $col['width'];
					$tableWidth += $col['width'];
					$colspan++;
					$colspan++;
					$colspan++;
				} else if($col['objType'] == "11") {
					$rows .= '<col width="'.$col['width'].'" />';
					$rows .= '<col width="'.$col['width'].'" />';
					$tableWidth += $col['width'];
					$tableWidth += $col['width'];
					$colspan++;
					$colspan++;
				}
			} 
		}
	}

	$salesColspan=0;
	foreach($salesCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$salesDisplay = 1;
			if($col['split'] != 1) {
				$rows .= '<col width="'.$col['width'].'" />';
				$tableWidth += $col['width'];
				$salesColspan++;
			} else{
				
				$objArr =  $lDB->get("
					SELECT 
						rc_obj_sales_data_ix
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				", 3);

				foreach($objArr as $obj) {
					$rows .= '<col width="'.$col['width'].'" />';
					$tableWidth += $col['width'];
					$salesColspan++;
				}
			} 
		}
	}
	
	$agentColspan=0;
	foreach($agentCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$agentDisplay = 1;
			if($col['split'] != 1) {
				$rows .= '<col width="'.$col['width'].'" />';
				$tableWidth += $col['width'];
				$agentColspan++;
			} 
		}
	}	
	
	$eventColspan=0;
	foreach($eventCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$eventDisplay = 1;
			if($col['split'] != 1) {
				$rows .= '<col width="'.$col['width'].'" />';
				$tableWidth += $col['width'];
				$eventColspan++;
			} 
		}
	}
	
	$GLOBALS['temp']['tableWidth']   = $tableWidth;

	$rows .= '
		<tr>
			<td colspan="'.$colspan.'" style="text-align:left" scope="col">Contact Details</td>
		';
	if(isset($salesDisplay) && $salesDisplay == 1) {
		$rows .= '<td colspan="'.$salesColspan.'" style="text-align:left" scope="col">Sales Profile</td>';
	}
	if(isset($agentDisplay) && $agentDisplay == 1) {
		$rows .= '<td colspan="'.$agentColspan.'" style="text-align:left" scope="col">Agent Profile</td>';
	}	
	if(isset($eventDisplay) && $eventDisplay == 1) {
		$rows .= '<td colspan="'.$eventColspan.'" style="text-align:left" scope="col">Event CRM</td>';
	}	
	$rows .= '</tr><tr>';

	$rows .= '
		<tr>
			<td class="colLt" rowspan="3" scope="col">
				<button type="button" class="button" style="padding: 0; margin: 1px 0px 0px 0px; width: 14px; height: 14px;" onclick="chartSelectAll(\'persona\',1);" onmouseover="overlib(\'Select All\',WIDTH,55);" onmouseout="nd();">
					<img src="/resource/Resrequest/Application/public/img/selectall.gif" alt="" />											
				</button>&nbsp;
				<button type="button" class="button" style="padding: 0; margin: 1px 0px 0px 0px; width: 14px; height: 14px;" onclick="chartSelectAll(\'persona\',0);" onmouseover="overlib(\'Deselect All\',WIDTH,65);" onmouseout="nd();">
					<img src="/resource/Resrequest/Application/public/img/clearall.gif" alt="" />
				</button>
			</td>
			<td class="colLt" rowspan="3" scope="col">&nbsp;</td>		
	';
	$secondRow = '<tr>';
	$thirdRow = '<tr>';
	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	$splitFlag = 0;
	foreach($cols as $col) {
		
		if($col['align'] == "r") {
			$align = "right";
		} else if($col['align'] == "c") {
			$align = "center";
		} else {
			$align = "left";
		}
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					if($splitFlag == 1) {
						$rowspn = 1;
					} else {
						$rowspn = 2;
						$colspan = $lastHeaderCount;
					}
					
					$rows .= "<td class=\"colLt\" colspan=\"$colspan\" rowspan=\"$rowspn\" align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					if($splitFlag == 1) {
						$secondRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					} else {
						$thirdRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					}
					
					$lastHeader = $col['header'];
					$lastHeaderCount++;
				} else {
					$rows .= "<td class=\"colLt\" rowspan=\"3\" align='$align'>".$col['label']."</td>";
				}
				
				//$rows .= '<td class="colLt" rowspan="2" scope="col" align="'.$align.'">'.$col['label'].'</td>';
			} else {
				$objCount = 1;
				if($col['objType'] == "10") {
					$objCount = 3;
				} else if($col['objType'] == "11") {
					$objCount = 2;
				}
				
				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*$objCount."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".$objCount."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*$objCount;
				} else {
					$rows .= "<td class=\colLt\" colspan='".$objCount."' align='$align'>".$col['label']."</td>";
				}

				if($col['objType'] == "10") {
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">Agent</td>';
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">User</td>';
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">Guest</td>';
				} else if($col['objType'] == "11") {
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">Individual</td>';
					$thirdRow .= '<td class="colLt" scope="col" align="'.$align.'">Organisation</td>';
				}
			} 
		}
	}
	if($lastHeader != "") {
			if($splitFlag == 1) {
			$rowspn = 1;
		} else {
			$rowspn = 2;
			$colspan = $lastHeaderCount;
		}
		$rows .= "<td class=\"colLt\" colspan=\"$colspan\" align=\"center\">".$lastHeader. "</td>";
	}

	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	$splitFlag = 0;
	foreach($salesCols as $col) {
		if($col['align'] == "r") {
			$align = "right";
		} else if($col['align'] == "c") {
			$align = "center";
		} else {
			$align = "left";
		}

		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					if($splitFlag == 1) {
						$rowspn = 1;
					} else {
						$rowspn = 2;
						$colspan = $lastHeaderCount;
					}
					
					$rows .= "<td class=\"colLt\" colspan=\"$colspan\" rowspan=\"$rowspn\" align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					if($splitFlag == 1) {
						$secondRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					} else {
						$thirdRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					}
					
					$lastHeader = $col['header'];
					$lastHeaderCount++;
				} else {
					$rows .= "<td class=\"colLt\" rowspan=\"3\" align='$align'>".$col['label']."</td>";
				}
				//$rows .= '<td class="colLt" rowspan="3" scope="col" align="'.$align.'">'.$col['label'].'</td>';
			} else {
				$objArr =  $lDB->get("
					SELECT 
						rc_obj_sales_data_ix,rc_obj_sales_data_content
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				",2);
								
				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*count($objArr)."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".count($objArr)."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*count($objArr);
				} else {
					$rows .= "<td class=\colLt\" colspan='".count($objArr)."' align='$align'>".$col['label']."</td>";
				}

				foreach($objArr as $obj) {
					$thirdRow .= '<td scope="col" class="colLt" align="'.$align.'">'. $obj['rc_obj_sales_data_content'].'</td>';
				}
			} 
		}
	}

	if($lastHeader != "") {
			if($splitFlag == 1) {
			$rowspn = 1;
		} else {
			$rowspn = 2;
			$colspan = $lastHeaderCount;
		}
		$rows .= "<td class=\"colLt\" colspan=\"$colspan\" align=\"center\">".$lastHeader. "</td>";
	}
	
	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	$splitFlag = 0;
	foreach($agentCols as $col) {
		if($col['align'] == "r") {
			$align = "right";
		} else if($col['align'] == "c") {
			$align = "center";
		} else {
			$align = "left";
		}

		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					if($splitFlag == 1) {
						$rowspn = 1;
					} else {
						$rowspn = 2;
						$colspan = $lastHeaderCount;
					}
					
					$rows .= "<td class=\"colLt\" colspan=\"$colspan\" rowspan=\"$rowspn\" align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					if($splitFlag == 1) {
						$secondRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					} else {
						$thirdRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					}
					
					$lastHeader = $col['header'];
					$lastHeaderCount++;
				} else {
					$rows .= "<td class=\"colLt\" rowspan=\"3\" align='$align'>".$col['label']."</td>";
				}
				//$rows .= '<td class="colLt" rowspan="3" scope="col" align="'.$align.'">'.$col['label'].'</td>';
			} else{
				$objArr =  $lDB->get("
					SELECT 
						rc_obj_sales_data_ix,rc_obj_sales_data_content
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				",2);
				
				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*count($objArr)."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".count($objArr)."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*count($objArr);
				} else {
					$rows .= "<td class=\colLt\" colspan='".count($objArr)."' align='$align'>".$col['label']."</td>";
				}

				//$rows .= '<td class="colLt" colspan="'.count($objArr).'" scope="col" align="'.$align.'">'. $col['label'].'</td>';

				foreach($objArr as $obj) {
					$thirdRow .= '<td scope="col" class="colLt" align="'.$align.'">'. $obj['rc_obj_sales_data_content'].'</td>';
				}
			} 
		}
	}

	if($lastHeader != "") {
			if($splitFlag == 1) {
			$rowspn = 1;
		} else {
			$rowspn = 2;
			$colspan = $lastHeaderCount;
		}
		$rows .= "<td class=\"colLt\" colspan=\"$colspan\" align=\"center\">".$lastHeader. "</td>";
	}	
	
	$dataHeader1 = "";
	$dataHeader2 = "";
	$lastHeader = "";
	$lastHeaderCount = 0;
	$splitFlag = 0;
	foreach($eventCols as $col) {
		if($col['align'] == "r") {
			$align = "right";
		} else if($col['align'] == "c") {
			$align = "center";
		} else {
			$align = "left";
		}

		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				if($lastHeader != "" && $lastHeader != $col['header']) {
					if($splitFlag == 1) {
						$rowspn = 1;
					} else {
						$rowspn = 2;
						$colspan = $lastHeaderCount;
					}
					
					$rows .= "<td class=\"colLt\" colspan=\"$colspan\" rowspan=\"$rowspn\" align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					if($splitFlag == 1) {
						$secondRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					} else {
						$thirdRow .= "<td class=\"colLt\" align = '$align'>".$col['label']."</td>";
					}
					
					$lastHeader = $col['header'];
					$lastHeaderCount++;
				} else {
					$rows .= "<td class=\"colLt\" rowspan=\"3\" align='$align'>".$col['label']."</td>";
				}
				//$rows .= '<td class="colLt" rowspan="3" scope="col" align="'.$align.'">'.$col['label'].'</td>';
			} else{
				$objArr =  $lDB->get("
					SELECT 
						rc_obj_sales_data_ix,rc_obj_sales_data_content
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				",2);
				
				if($lastHeader != "" && $lastHeader != $col['header']) {
					$rows .= "<td class=\"colLt\" colspan='".$lastHeaderCount*count($objArr)."' align=\"center\">". $lastHeader."</td>";
					$lastHeader = "";
					$lastHeaderCount = 0;
				}
				if($col['header'] != "") {
					$secondRow .= "<td class=\"colLt\" align = '$align' colspan='".count($objArr)."'>". $col['label']."</td>";
					$lastHeader = $col['header'];
					$lastHeaderCount++;
					$splitFlag = 1;
					$colspan = $lastHeaderCount*count($objArr);
				} else {
					$rows .= "<td class=\colLt\" colspan='".count($objArr)."' align='$align'>".$col['label']."</td>";
				}

				//$rows .= '<td class="colLt" colspan="'.count($objArr).'" scope="col" align="'.$align.'">'. $col['label'].'</td>';

				foreach($objArr as $obj) {
					$thirdRow .= '<td scope="col" class="colLt" align="'.$align.'">'. $obj['rc_obj_sales_data_content'].'</td>';
				}
			} 
		}
	}

	if($lastHeader != "") {
			if($splitFlag == 1) {
			$rowspn = 1;
		} else {
			$rowspn = 2;
			$colspan = $lastHeaderCount;
		}
		$rows .= "<td class=\"colLt\" colspan=\"$colspan\" align=\"center\">".$lastHeader. "</td>";
	}

	$rows .= '</tr>';
	$secondRow .= '</tr>';
	$thirdRow .= '</tr>';
	
	$rows .= $secondRow;
	$rows .= $thirdRow;
	if(empty($guestData)) {
		$newColspan = $colspan+$eventColspan;
		$rows .= '
			<tr>
				<td colspan="'.$newColspan.'" style="text-align:left">No results found</td>
			</tr>
		';
		return $rows;
	}

	foreach($guestData as $guest) {
		array_push($conScrollSet, $guest['pr_persona_ix']);
		$rowspan = count($guest['eventData']);
		if($rowspan<1 || $eventDisplay == 0) {
			$rowspan = 1;
		}
		$inactive = "";
		if($guest['pr_persona_inactive_yn'] == '1') {
			$inactive = " class='txtg txti'";
		}
		$firsrRec = 1;
		$lastResId = "";
		for($i=0; $i<$rowspan; $i++) {
			if ( $guest['pr_persona_ix'] != "" ) {
				$clickThrough = "onclick=\"window.location = '/reservation.php?45+" . $guest['pr_persona_ix'] . "'\"";
				$pointer = 'cursor: pointer;';

				

			}
						
			if($firsrRec == 1) {
				$rows .= "
					<tr valign='top' onmouseover='this.style.backgroundColor = \"#cfc\";' onmouseout='this.style.backgroundColor = \"\"';' ".$inactive.">
						<td style='".$pointer."' rowspan='$rowspan'>
						
						<input type=\"checkbox\" name=personaCheck value=".$guest['pr_persona_ix'].">
						<td rowspan='$rowspan'><input class='button bAddCrm' style='width: 16px; height: 20px;' onclick='addEvent(\"".$guest['pr_persona_ix']."\");' type='button'></td>
				";
				foreach($cols as $col) {
					if($col['align'] == "r") {
						$align = "right";
					} else if($col['align'] == "c") {
						$align = "center";
					} else {
						$align = "left";
					}

					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							//$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' ".$inactive.">". $guest[$col['fields'][0]]. "&nbsp;</td>";
							$values = array();
							foreach($col['fields'] as $field) {
								array_push($values,$guest[getFieldName($field)]);
							}
							switch($col['type']) {
							default:
							case "string":
								$value = trim(str_replace("\r","",join(" ",$values)));
								break;
							case "complex":
								if(function_exists($col['function'])) {
									$value = call_user_func_array($col['function'],$values);
								} else {
									$value = "NOT IMPLEMENTED";
								}
								break;
							}
							$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' ".$inactive.">". $value. "&nbsp;</td>";			
						} else {
							if($col['split'] ==1) {
								if($col['objType'] == 10) {
									$val = "&nbsp;";
									if(in_array("Agent", $guest[getFieldName($col['fields'][0])])) {
										$val = "x";
									}
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align' ".$inactive.">".$val."</td>";
									
									$val = "&nbsp;";
									if(in_array("User", $guest[getFieldName($col['fields'][0])])) {
										$val = "x";
									}
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align' ".$inactive.">".$val."</td>";

									$val = "&nbsp;";
									if(in_array("Guest", $guest[getFieldName($col['fields'][0])])) {
										$val = "x";
									}
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align' ".$inactive.">".$val."</td>";
								} else if($col['objType'] == 11) {
									$ind = "";
									$org = "";
									if($guest[getFieldName($col['fields'][0])] == "Individual") {
										$ind = "x";
									} else {
										$org = "x";
									}
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align' ".$inactive.">".$ind."</td>";
									$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align' ".$inactive.">".$org."</td>";
								}
								
							} else {
								$rows .= "<td style='".$pointer."' ".$clickThrough." rowspan='$rowspan' align='$align' ".$inactive.">";
								if($col['objType'] == 10) {
									$counter = 1;
									foreach($guest[getFieldName($col['fields'][0])] as $obj) {
										if($counter>1) {
											$rows .= "<br>";
										}
										$rows .= $obj;
										$counter++;
									}
								} else {
									$rows .= $guest[getFieldName($col['fields'][0])];
								}
								$rows .= "&nbsp;</td>";
							}
						}
					}
				}

				$class = isset($class) ? $class : "";

				foreach($salesCols as $col) {
					if($col['align'] == "r") {
						$align = "right";
					} else if($col['align'] == "c") {
						$align = "center";
					} else {
						$align = "left";
					}

					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$rows .= "<td style='".$pointer."' rowspan='$rowspan' align='$align' $class ".$clickThrough." ".$inactive.">". $guest['salesData'][$i][getFieldName($col['fields'][0])]."&nbsp;</td>";
						} else{
							switch($col['objType']) {
								case '1':
									$field = "pr_sales_obj_data_text";
									break;
								case '2':
									$field = "pr_sales_obj_data_memo";
									break;
								case '6':
									$field = "pr_sales_obj_data_text";
									break;
								case '3':
								case '4':
								case '5':
								case '8':
									$field = "rc_obj_sales_data_id";
									break;
							}
							
							$objVal = $lDB->get("
								SELECT 
									$field 
								FROM 
									pr_sales_obj_data 
								WHERE 
									rc_obj_sales_id = '".$col['rc_obj_sales_ix']."' 
									AND pr_persona_id = '".$guest['pr_persona_ix']."'
							", 3);

							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								$rows .= "<td style='".$pointer."' rowspan='$rowspan' align='$align' $class ".$inactive.">".(isset($objVal[0])?$objVal[0]:"")."&nbsp;</td>";

							} else if($col['objType'] == 8) {
								if($col['rc_obj_sales_ix'] == "RS1") {
									$newVal =  "";
									if(isset($objVal[0])) {
										$newVal =  $lDB->get("
											SELECT 
												rc_event_desc
											FROM 
												rc_event
											WHERE 
												rc_event_ix = '".$objVal[0]."'
										",4);
									}
									$rows .= "<td style='".$pointer."' rowspan='$rowspan' align='$align' $class ".$inactive.">".$newVal."&nbsp;</td>";
								}
								if($col['rc_obj_sales_ix'] == "RS2" || $col['rc_obj_sales_ix'] == "RS3") {
									$newName = "";
									if(isset($objVal[0])) {
										$newVal =  $lDB->get("
											SELECT 
												pr_name_first, pr_name_last
											FROM 
												pr_persona
											WHERE 
												pr_persona_ix IN  ('".join("','", $objVal)."')
										",2);
										
										foreach($newVal as $val) {
											if($newName != "") {
												$newName .= ", ";
											}
											$newName .= $val['pr_name_first']."&nbsp;".$val['pr_name_last'];
										}
									}
									
									$rows .= "<td style='".$pointer."' rowspan='$rowspan' align='$align' $class ".$inactive.">".$newName."</td>";
								}
							
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rc_obj_sales_data_ix, rc_obj_sales_data_content
									FROM 
										rc_obj_sales_data
									WHERE 
										rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
								",2);
								
								if($col['split'] ==1) {
									foreach($objArr as $obj) {
										if(in_array($obj['rc_obj_sales_data_ix'],$objVal)) {
											$val = "1";
										} else {
											$val = "&nbsp;";
										}
										$rows .= "<td rowspan='$rowspan' $class>".$val."</td>";
									}
									
								} else {
									$rows .= "<td style='".$pointer."' rowspan='$rowspan' align='$align' $class ".$inactive.">";
									$counter = 1;
									foreach($objArr as $obj) {
										if(in_array($obj['rc_obj_sales_data_ix'], $objVal)) {
											if($counter>1) {
												$rows .= "<br>";
											}
											$rows .= $obj['rc_obj_sales_data_content'];
											$counter++;
										}
									}
									$rows .= "&nbsp;</td>";
								}
							}
						}
					}
				}
			} else {
				$spn = 2;
				foreach($cols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$spn++;
						} else {
							if($col['split'] ==1) {
								$spn++;
								$spn++;
								if($col['objType'] == 10) {
									$spn++;
								} 
							} else {
								$spn++;
							}
						}
					}
				}

				foreach($salesCols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$spn++;
						} else{
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								$spn++;
							} else if($col['objType'] == 8) {
								$spn++;							
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rc_obj_sales_data_ix, rc_obj_sales_data_content
									FROM 
										rc_obj_sales_data
									WHERE 
										rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
								",2);
								
								if($col['split'] ==1) {
									foreach($objArr as $obj) {
										$spn++;
									}
								} else {
									$spn++;
								}
							}
						}
					}
				}
				$rows .= "
					<tr valign='top'  onmouseover='this.style.backgroundColor = \"#cfc\"
			;' onmouseout='this.style.backgroundColor = \"\"';'>";
						//<td colspan='".$spn."' style='border:0px;'>&nbsp;</td>
				//";
			}
			
			$class = "";
			$style = "";
			
			if($firsrRec==1) {
				$style = "style='border-bottom:0px; ".$pointer."'";
			} else if($firsrRec==$rowspan) {
				$style = "style='border-top:0px; ".$pointer."'";
			} else {
				if( !isset($guest['salesData'][$i]['rv_reservation_ix']) || $lastResId != $guest['salesData'][$i]['rv_reservation_ix']) {
					$style = "style='border-top:1px solid #663300;  border-bottom:0px; ".$pointer."'";
				} else {
					$style = "style='border-top:0px; border-bottom:0px; ".$pointer."'";
				}
			}

			foreach($agentCols as $col) {
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if(isset($col['active']) && $col['active'] == 1) {
					// if($col['objType'] =="") {
						// $rows .= "<td $style align='$align' $class ".$clickThrough.">". $guest['agentData'][$i][$col['fields'][0]]."&nbsp;</td>";
					// } 
					$values = array();
					foreach($col['fields'] as $field) {
						array_push($values,(isset($guest['agentData'][$i][getFieldName($field)]) ? $guest['agentData'][$i][getFieldName($field)] : "") );
					}
					switch($col['type']) {
					default:
					case "string":
						$value = trim(str_replace("\r","",join(" ",$values)));
						break;
					case "complex":
						if(function_exists($col['function'])) {
							$value = call_user_func_array($col['function'],$values);
						} else {
							$value = "NOT IMPLEMENTED";
						}
						break;
					}
					$rows .= "<td $style align='$align' $class ".$clickThrough.">". $value."&nbsp;</td>";
				}
			}			
			
			foreach($eventCols as $col) {
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if(isset($col['active']) && $col['active'] == 1) {
					if($col['objType'] =="") {
						$rows .= "<td $style align='$align' $class ".$clickThrough.">". (isset($guest['eventData'][$i][getFieldName($col['fields'][0])]) ? $guest['eventData'][$i][getFieldName($col['fields'][0])] : "") ."&nbsp;</td>";
					} 
				}
			}

			$rows .= '</tr>';
			$firsrRec++;
			$lastResId = isset($guest['salesData'][$i]['rv_reservation_ix']) ? $guest['salesData'][$i]['rv_reservation_ix'] : "";
		}
	}
	setContactScroll($conScrollSet);
	return $rows;
}

function outputCSV($cols, $salesCols, $agentCols, $eventCols, $guestData, $renderType="view", $repName="", $repType="xls") {
	define("COLWIDTH",150);
	global $lDB;
	$rows = array();
	$cells = array();
	$tables = array();
	$multiCell = array();
	$tempCell = array();
	$tempCell_nxt = array();
	$rowCount = 1;
	$multiCell[$rowCount] = array();
	$eventDisplay = 0;

	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$defaultStyle = array( 
		'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
		'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
		'font' => array('Size' => '8')
	);
	
	$xls = new XLS($defaultStyle);

	$header_style = array( 
		'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
		'font' =>array('Bold' => '1'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
					
	$header_styleId = $xls->addStyle($header_style);

	$cell_style = array( 
		'interior' => array('Pattern'=>'Solid'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);

	$cell_styleLR = array( 
		'interior' => array('Pattern'=>'Solid'),
		'border' => array($borderL, $borderR)
	);

	$cell_styleLRT = array( 
		'interior' => array('Pattern'=>'Solid'),
		'border' => array($borderL, $borderR, $borderT)
	);

	$cell_styleLRB = array( 
		'interior' => array('Pattern'=>'Solid'),
		'border' => array($borderL, $borderR, $borderB)
	);
					
	$cell_styleId = $xls->addStyle($cell_style);
	$cell_styleIdLR = $xls->addStyle($cell_styleLR);
	$cell_styleIdLRT = $xls->addStyle($cell_styleLRT);
	$cell_styleIdLRB = $xls->addStyle($cell_styleLRB);
	
	$xls->Column(COLWIDTH,1,0);
	$xls->Column(COLWIDTH,1,0);
		
	$colspan=-1;
	$contactDisplay = 0;
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				$xls->Column($col['width'],1,0);
				$colspan++;
			} else {
				$xls->Column($col['width'],1,0);
				$colspan++;
				$xls->Column($col['width'],1,0);
				$colspan++;
				if($col['objType'] == "10") {
					$xls->Column($col['width'],1,0);
					$colspan++;
				}
			} 
			$contactDisplay = 1;
		}
	}

	$salesColspan=-1;
	foreach($salesCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$salesDisplay = 1;
			if($col['split'] != 1) {
				$xls->Column($col['width'],1,0);
				$salesColspan++;
			} else {
				$objArr =  $lDB->get("
					SELECT 
						rc_obj_sales_data_ix
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				", 3);
			
				foreach($objArr as $obj) {
					$xls->Column($col['width'],1,0);
					$salesColspan++;
				}
			} 
		}
	}
	
	$agentColspan=-1;
	foreach($agentCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$agentDisplay = 1;
			if($col['split'] != 1) {
				$xls->Column($col['width'],1,0);
				$agentColspan++;
			} else {
			} 
		}
	}	
	
	$eventColspan=-1;
	foreach($eventCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			$eventDisplay = 1;
			if($col['split'] != 1) {
				$xls->Column($col['width'],1,0);
				$eventColspan++;
			} else {
				/*$objArr =  $GLOBALS['lDB']->get("
					SELECT 
						rc_obj_sales_data_ix
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				", 3);
			
				foreach($objArr as $obj) {
					$xls->Column($col['width'],1,0);
					$eventColspan++;
				} */
			} 
		}
	}

	if(isset($contactDisplay) && $contactDisplay == 1) {
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Contact Details"), $header_styleId, '', '', '', '', $colspan);
		array_push($tempCell, $cell);	
	}
	if(isset($salesDisplay) && $salesDisplay == 1) {
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Sales Profile"), $header_styleId, '', '', '', '', $salesColspan);
		array_push($tempCell, $cell);
	}
	if(isset($agentDisplay) && $agentDisplay == 1) {
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Agent Profile"), $header_styleId, '', '', '', '', $agentColspan);
		array_push($tempCell, $cell);
	}	
	if(isset($eventDisplay) && $eventDisplay == 1) {
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Event CRM"), $header_styleId, '', '', '', '', $eventColspan);
		array_push($tempCell, $cell);
	}

	array_push($multiCell[$rowCount], $tempCell);
	$tempCell = array();
	$rowCount += 1;
	$multiCell[$rowCount] = array();

	/*$cell = $xls->Cell(array('type'=>'String', 'data'=>'Last name'), $header_styleId, "", "", "", "", 0, 1);
	array_push($tempCell, $cell);
	$cell = $xls->Cell(array('type'=>'String', 'data'=>'First name'), $header_styleId, "", "", "", "", 0, 1);
	array_push($tempCell, $cell); */
	$index = 0;
		
	foreach($cols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", 0, 1);
				array_push($tempCell, $cell);
			} else {
				if($col['objType'] == "10") {
					$objCount = 3;
				}
				if($col['objType'] == "11") {
					$objCount = 2;
				}
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", $objCount-1);
				array_push($tempCell, $cell);
				
				/*foreach($objArr as $obj) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$obj['rc_obj_sales_data_content']), $header_styleId, $index);
					
					array_push($tempCell_nxt, $cell);
					$index++;
				}*/
				
				if($col['objType'] == "10") {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Agent'), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'User'), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Guest'), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
				} else if($col['objType'] == "11") {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Individual'), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
					$cell = $xls->Cell(array('type'=>'String', 'data'=>'Organisation'), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
				}

				$index--;
			} 
		}
	}

	foreach($salesCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", 0, 1);
				array_push($tempCell, $cell);
							
			} else {
				$objArr =  $lDB->get("
					SELECT 
						rc_obj_sales_data_ix,rc_obj_sales_data_content
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				",2);
				
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", count($objArr)-1);
				array_push($tempCell, $cell);
				
				foreach($objArr as $obj) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$obj['rc_obj_sales_data_content']), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
				}
				$index--;
			} 
		}
	}
	
	foreach($agentCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", 0, 1);
				array_push($tempCell, $cell);
			} else {
			} 
		}
	}	

	foreach($eventCols as $col) {
		if(isset($col['active']) && $col['active'] == 1) {
			if($col['split'] != 1) {
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", 0, 1);
				array_push($tempCell, $cell);
							
			} else {
				/*$objArr =  $GLOBALS['lDB']->get("
					SELECT 
						rc_obj_sales_data_ix,rc_obj_sales_data_content
					FROM 
						rc_obj_sales_data
					WHERE 
						rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
				",2);
				
				$index++;
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$col['label']), $header_styleId, "", "", "", "", count($objArr)-1);
				array_push($tempCell, $cell);
				
				foreach($objArr as $obj) {
					$cell = $xls->Cell(array('type'=>'String', 'data'=>$obj['rc_obj_sales_data_content']), $header_styleId, $index);
					array_push($tempCell_nxt, $cell);
					$index++;
				}
				$index--; */
			} 
		}
	}
	
	array_push($multiCell[$rowCount], $tempCell);
	$tempCell = array();
	$rowCount += 1;
	$multiCell[$rowCount] = array();

	array_push($multiCell[$rowCount], $tempCell_nxt);
	$tempCell_nxt = array();
	$rowCount += 1;
	$multiCell[$rowCount] = array();

	
	if(empty($guestData)) {
		$newColspan = $colspan+$salesColspan+$eventColspan;
		$cell = $xls->Cell(array('type'=>'String', 'data' => "No results found"), $cell_styleId, '', '', '', '', $newColspan);
		array_push($tempCell, $cell);
		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		return 0; 
	}

	foreach($guestData as $guest) {
		$eventRec = count($guest['eventData']);

		if($eventRec<1 || $eventDisplay == 0) {
			$eventRec = 1;
		}
		$firsrRec = 1;
		for($i=0; $i<$eventRec; $i++) {
					
			if($firsrRec == 1) {
				/*$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['pr_name_last']), $cell_styleId);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['pr_name_first']), $cell_styleId);
				array_push($tempCell, $cell); */
				
				foreach($cols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$values = array();
							foreach($col['fields'] as $field) {
								array_push($values,$guest[getFieldName($field)]);
							}
							switch($col['type']) {
							default:
							case "string":
								$value = trim(str_replace("\r","",join(" ",$values)));
								break;
							case "complex":
								if(function_exists($col['function'])) {
									$value = call_user_func_array($col['function'],$values);
								} else {
									$value = "NOT IMPLEMENTED";
								}
								break;
							}
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $cell_styleId);
							array_push($tempCell, $cell);
						} else {
							if($col['split'] ==1) {
								if($col['objType'] == 10) {
									$val = "";
									if(in_array("Agent", $guest[getFieldName($col['fields'][0])])) {
										$val = "x";
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $cell_styleId);
									array_push($tempCell, $cell);
																		
									$val = "";
									if(in_array("User", $guest[getFieldName($col['fields'][0])])) {
										$val = "x";
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $cell_styleId);
									array_push($tempCell, $cell);

									$val = "";
									if(in_array("Guest", $guest[getFieldName($col['fields'][0])])) {
										$val = "x";
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $cell_styleId);
									array_push($tempCell, $cell);
								} else if($col['objType'] == 11) {
									$ind = "";
									$org = "";
									if($guest[getFieldName($col['fields'][0])] == "Individual") {
										$ind = "x";
									} else {
										$org = "x";
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$ind), $cell_styleId);
									array_push($tempCell, $cell);
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$org), $cell_styleId);
									array_push($tempCell, $cell);
								}
								
							} else {
								$val = "";
								if($col['objType'] == 10) {
									$counter = 1;
									foreach($guest[getFieldName($col['fields'][0])] as $obj) {
										if($counter>1) {
											$val .= "&#10;";
										}
										$val .= $obj;
										$counter++;
									}
								} else {
									$val .= $guest[getFieldName($col['fields'][0])];
								}
								
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $cell_styleId);
								array_push($tempCell, $cell);
							}	
						}
					}
				}

				foreach($salesCols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$cell = $xls->Cell(array('type'=>'String', 'data'=>$guest['salesData'][$i][getFieldName($col['fields'][0])]), $cell_styleId);
							array_push($tempCell, $cell);
						} else{
							switch($col['objType']) {
								case '1':
									$field = "pr_sales_obj_data_text";
									break;
								case '2':
									$field = "pr_sales_obj_data_memo";
									break;
								case '6':
									$field = "pr_sales_obj_data_text";
									break;
								case '3':
								case '4':
								case '5':
								case '8':
									$field = "rc_obj_sales_data_id";
									break;
							}
							
							$objVal = $lDB->get("
								SELECT 
									$field 
								FROM 
									pr_sales_obj_data 
								WHERE 
									rc_obj_sales_id = '".$col['rc_obj_sales_ix']."' 
									AND pr_persona_id = '".$guest['pr_persona_ix']."'
							", 3);
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6){
								$value = isset($objVal[0]) ? $objVal[0] : "";
								$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $cell_styleId);
								array_push($tempCell, $cell);
							} else if($col['objType'] == 8) {
								if($col['rc_obj_sales_ix'] == "RS1") {
									if(isset($objVal[0])) {
										$newVal =  $lDB->get("
											SELECT 
												rc_event_desc
											FROM 
												rc_event
											WHERE 
												rc_event_ix = '".$objVal[0]."'
										",4);
									} else {
										$newVal = "";
									}

									$cell = $xls->Cell(array('type'=>'String', 'data'=>$newVal), $cell_styleId);
									array_push($tempCell, $cell);
								}
								if($col['rc_obj_sales_ix'] == "RS2" || $col['rc_obj_sales_ix'] == "RS3") {
									if(isset($objVal[0])) {
										$newVal =  $lDB->get("
											SELECT 
												pr_name_first, pr_name_last
											FROM 
												pr_persona
											WHERE 
												pr_persona_ix = '".$objVal[0]."'
										",1);
									} else {
										$newVal =  array();
									}
									$cell = $xls->Cell(array('type'=>'String', 'data'=>trim( (isset($newVal[0]) ? $newVal[0] : "") ." ". (isset($newVal[1]) ? $newVal[1] : "") )), $cell_styleId);
									array_push($tempCell, $cell);
								}
							
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rc_obj_sales_data_ix,rc_obj_sales_data_content
									FROM 
										rc_obj_sales_data
									WHERE 
										rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
								",2);
								if($col['split'] == 1) {
									foreach($objArr as $obj) {
										if(in_array($obj['rc_obj_sales_data_ix'],$objVal)) {
											$val = "1";
										} else {
											$val = "";
										}
										$cell = $xls->Cell(array('type'=>'String', 'data'=>$val), $cell_styleId);
										array_push($tempCell, $cell);
									}
								} else {
									$data = "";
									foreach($objArr as $obj) {
										if(in_array($obj['rc_obj_sales_data_ix'], $objVal)) {
											if($data != "") {
												$data .= "&#10;";
											}
											$data .= $obj['rc_obj_sales_data_content'];
										}
									}
									
									$cell = $xls->Cell(array('type'=>'String', 'data'=>$data), $cell_styleId);
									array_push($tempCell, $cell);
								}
								
							}
							
						}
					}
				}
			} else {
				$spn = -1;
				foreach($cols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$spn++;
						} else {
							if($col['split'] ==1) {
								$spn++;
								$spn++;
								if($col['objType'] == 10) {
									$spn++;
								} 
							} else {
								$spn++;
							}
						}
					}
				}
				if ($spn >= 0){
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), '', '', '', '', '', $spn);
					array_push($tempCell, $cell);
				}
				
				$salesSpn = -1;
				foreach($salesCols as $col) {
					if(isset($col['active']) && $col['active'] == 1) {
						if($col['objType'] =="") {
							$salesSpn++;
						} else{
							if($col['objType'] == 1 || $col['objType'] == 2 || $col['objType'] == 6 || $col['objType'] == 8){
								$salesSpn++;
							} else  {
								$objArr =  $lDB->get("
									SELECT 
										rc_obj_sales_data_ix,rc_obj_sales_data_content
									FROM 
										rc_obj_sales_data
									WHERE 
										rc_obj_sales_data.rc_obj_sales_id = '".$col['rc_obj_sales_ix']."'
								",2);
								if($col['split'] == 1) {
									foreach($objArr as $obj) {
										$salesSpn++;
									}
								} else {
									$salesSpn++;
								}
							}
						}
					}
				}
				if ($salesSpn > -1){
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), '', '', '', '', '', $salesSpn);
					array_push($tempCell, $cell);
				}
			}
			
			foreach($agentCols as $col) {
				if(isset($col['active']) && $col['active'] == 1) {
					if($col['objType'] =="") {
						$values = array();
						foreach($col['fields'] as $field) {
							array_push($values,(isset($guest['agentData'][$i][getFieldName($field)]) ? $guest['agentData'][$i][getFieldName($field)] : "") );
						}
						switch($col['type']) {
						default:
						case "string":
							$value = trim(str_replace("\r","",join(" ",$values)));
							break;
						case "complex":
							if(function_exists($col['function'])) {
								$value = call_user_func_array($col['function'],$values);
							} else {
								$value = "NOT IMPLEMENTED";
							}
							break;
						}					
					
						$cell = $xls->Cell(array('type'=>'String', 'data'=>$value), $cell_styleId);
						array_push($tempCell, $cell);
					} 
				}
			}			
			
			foreach($eventCols as $col) {
				if(isset($col['active']) && $col['active'] == 1) {
					if($col['objType'] =="") {
						$cell = $xls->Cell(array('type'=>'String', 'data'=>(isset($guest['eventData'][$i][getFieldName($col['fields'][0])]) ? $guest['eventData'][$i][getFieldName($col['fields'][0])] : "") ), $cell_styleId);
						array_push($tempCell, $cell);
					} 
				}
			}
			
			if ((count($tempCell) != 0 && !empty($tempCell[0]))){
				array_push($multiCell[$rowCount], $tempCell);	
			}
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();
			$firsrRec++;
		}
	}
	$cells = array();
	$rows = array();
	$temparr=array();
	$headerFlag = 1;

	foreach($multiCell as $rowId=>$temparr) {
		foreach($temparr as $cellArr) {
			foreach($cellArr as $tmp) {
				array_push($cells,$tmp);
			}
			
			if($headerFlag<=3) {
				$row = $xls->Row($cells, 20, 1);
			} else {
				$row = $xls->Row($cells);
			}
			$cells = array();
			array_push($rows,$row);
		}
		$headerFlag++;
	}	

    if ($repType == "csvFromXml") {
        $xml = "<report>".join("", $rows)."</report>";
        $csv = xmlToCSV($xml);

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=".$repName);
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $csv;
        die;
    }

	$table = $xls->Table($rows);
	array_push($tables, $table);
	$xls->Worksheet($tables);
	if ( $renderType == 'view' ) {
		$xls->genrateWorkbook($repName, $repType);
	}
	if ( $renderType == 'send' ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = $_POST['mail_subj'];
		$message = $_POST['mail_body'];
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
		$xlsSheet = $xls->genrateWorkbook($repName, $repType, 1);
		
		// and now mail it
		if ( $attachmentName != '!attachmentName!' ) {
			$pdfName = $attachmentName;
		} else {
			$pdfName = $repName;
		}

		// (from, to, subject, headers, message, action, emailID, resID)
		$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$xlsSheet,$pdfName);
		if ( !$error ) {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								a = opener.openMessage("Your email has been sent.");
								a.focus();
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		} else {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								a = opener.openMessage("Error sending email!");
								a.focus();
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		}
	}
}

function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;
	$fromDate = date("d-m-Y");
	$csvName = "CRM_custom_$fromDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $csvName . ".xlsx</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 2;
	
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,35))."+$newOptions+".join("+",array_slice($_SERVER['argv'],36,1))."+".join("+",array_slice($_SERVER['argv'],37,1));
	
	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$csvName.".xlsx",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!","CRM Custom Report: ".chng_date(date("Y-m-d"),"-"),
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

// Auxiliary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPhoneType($personaId) {
	$phoneType = $GLOBALS['lDB']->get("
		SELECT
			rf_phone_type.rf_phone_type_desc
		FROM
			rf_phone_type
			INNER JOIN pr_phone ON pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($phoneType) == "" || $phoneType == "0") {
		$phoneType = "";
	}
	return $phoneType;
}

function getPhoneNumber($personaId) {
	global $renderMode;
	$phoneNumberList = $GLOBALS['lDB']->get("
		SELECT
			CONCAT(rf_phone_type.rf_phone_type_desc, ': ', pr_phone.pr_phone_number) AS phone_number
		FROM
			rf_phone_type
			INNER JOIN pr_phone ON pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
		WHERE
			pr_phone.pr_persona_id = '$personaId'
	",3);

	$phoneNumbers = "";
	if (count($phoneNumberList) > 0) {
		$joinCharacter = $renderMode == "html" ? "<br/>" : "\n";
		$phoneNumbers = implode($joinCharacter, $phoneNumberList);
	}
	return $phoneNumbers;
}

// [START] - Section functions
function findSectionId($sections,$name) {
	foreach($sections as $item) {
		if($item['name'] == $name) {
			return $item['id'];
		}
	}
}

function buildCheck($name,$id,$isChecked,$onClick="") {
	$checked = "";
	if($isChecked) {
		$checked = "checked";
	}
	return "<input type=\"checkbox\" name=\"".$name."Check\" id=\"$name$id\" $checked onclick=\"$onClick\">";
}

function getWeekDates() {
	$w = date("w");
	switch($w) {
	case 0:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-6, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d"), date("Y")));
		break;
	case 1:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d"), date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+6, date("Y")));
		break;
	case 2:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-1, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+5, date("Y")));
		break;
	case 3:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-2, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+4, date("Y")));
		break;
	case 4:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-3, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+3, date("Y")));
		break;
	case 5:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-4, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+2, date("Y")));
		break;
	case 6:
		$fromDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")-5, date("Y")));
		$toDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1, date("Y")));
		break;
	}

	$dateArray = array($fromDate, $toDate);
	return $dateArray;
}

function getDefaultAgentRateType($pr_agent_id){

	$rateType = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rt_rate_type_desc
		FROM
			pr_agent_rate
		INNER JOIN 
			rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		WHERE
			pr_agent_rate.pr_agent_id = '$pr_agent_id'
			AND pr_agent_rate.pr_agent_rate_default_yn = '1'
	",4);
	if (trim($rateType) == "" || $rateType == "0") {
		$rateType = "";
	}
	return $rateType;

}

function getAgentRateTypes($pr_agent_id){
	global $renderMode;
	$rateTypes = $GLOBALS['lDB']->get("
		SELECT
			CONCAT(rt_rate_type.rt_rate_type_desc, ' (', rf_currency.rf_currency_symbol, ')') AS rt_rate_type_desc
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			pr_agent_rate.pr_agent_id = '$pr_agent_id'
	",3);

	$joinCharacter = $renderMode == "html" ? "<br/>" : ",\n";
	$rateTypesString = join($joinCharacter,$rateTypes);
	
	return $rateTypesString;
}

function getFieldYesNo($boolean){
	switch ($boolean){
		case 0:
			return "No";
			break;
		case 1:
			return "Yes";
			break;
	}	
}

function getAgentCharge($pr_agent_comm_deduct_yn){
	switch ($pr_agent_comm_deduct_yn){
		case 0:
			return "Gross Amount";
			break;
		case 1:
			return "Nett Amount";
			break;
	}	
}

function getDefaultAgentPayPlan($pr_agent_id){

	$payPlan = $GLOBALS['lDB']->get("
		SELECT
			ac_pay_plan.ac_pay_plan_desc
		FROM
			pr_agent
		INNER JOIN 
			ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = pr_agent.ac_pay_plan_id
		WHERE
			pr_agent.pr_agent_id = '$pr_agent_id'
	",4);
	if (trim($payPlan) == "" || $payPlan == "0") {
		$payPlan = "";
	}
	return $payPlan;
}

function getAgentDay($ac_pay_final_days){

	if (trim($ac_pay_final_days) == "" || $ac_pay_final_days == "0") {
		$ac_pay_final_days = "";
	}
	return $ac_pay_final_days;
}

function getAgentDayOverride($ac_pay_final_base){
	switch ($ac_pay_final_base){
		case 0:
			return "No (Use Default)";
			break;
		case 2:
			return "Day of Month";
			break;
	}	
}

function getContactLink($pr_persona_ix){
	$linkTypes = $GLOBALS['lDB']->get("
		SELECT
			rf_link_type.rf_link_type_desc
		FROM
			pr_link
		INNER JOIN 
			rf_link_type ON pr_link.rf_link_type_id = CONCAT(rf_link_type.rf_link_type_db,rf_link_type.rf_link_type_id)
		WHERE
			pr_link.pr_link_from = '$pr_persona_ix'
	",3);
	
	return join(",",$linkTypes);
}

function getFieldName($field) {
	$fieldArray = getFieldArray($field);
	if($fieldArray['alias'] != "") {
		return $fieldArray['alias'];
	} else {
		return $fieldArray['field'];
	}
}

function getFieldArray($field) {
	$fieldList = preg_split("/ as /i",$field);
	$alias = isset($fieldList[1]) ? trim($fieldList[1]) : "";
	$fieldList = explode(".",$fieldList[0]);
	$table = trim($fieldList[0]);
	$field = trim($fieldList[1]);
	return array('table'=>$table, 'field'=>$field, 'alias'=>$alias);
}

function getCol($complexId) {
	global $cols;
	global $agentCols;
	global $salesCols;

	$splitId = explode("_", $complexId);
	switch($splitId[0]){
	case "c":
		foreach($cols as $item) {
			if($item['id'] == $splitId[1]) {
				return $item;
			}
		}		
		break;
	case "a":
		foreach($agentCols as $item) {
			if($item['id'] == $splitId[1]) {
				return $item;
			}
		}	
		break;
    case "s":
		foreach($salesCols as $item) {
            if($item['id'] == $splitId[1]) {
                return $item;
            }
        }
		break;
	}

	return false;
}

function buildSQLSort($colArray,$colSort){
	$sort = array();
	foreach($colSort as $key=>$item) {
		if($colArray[$key]['active'] == "1" && $item != "") {
			$colItem = getCol($key);
			if ($colItem['sortable'] == 1){
				if(is_array($colItem['fields'])) {
					$fields = $colItem['fields'];
				}
				if(isset($colItem['sortAlias']) && is_array($colItem['sortAlias'])) {
					$sortAlias = $colItem['sortAlias'];
				}

				if($colArray[$key]['direction'] == "a") {
					$direction = "asc";
				} else {
					$direction = "desc";
				}
				foreach($fields as $fieldKey=>$field) {

					$aliasField = preg_split("/ as /i", $field);
					if (isset($sortAlias)) {
						if (count($sortAlias) > 1){
							$realField = $sortAlias[1];
						} else {
							$realField = $sortAlias[0];
						}
					} else {
						if (count($aliasField) > 1){
							$realField = $aliasField[1];
						} else {
							$realField = $aliasField[0];
						}
					}

					$fields[$fieldKey] = $realField . " " . $direction;
				}
				$sort = array_merge($sort,$fields);
			}
	
		}
	}

	return $sort;
}
