<?php

/**
 * init.form419.php - CRM Custom Report
 * Job: 394
 * Function: 122 (Reports: CRM)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("crm_custem_report");
processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_crm_custom.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],53,"");

$GLOBALS['temp']['username'] = $_SESSION['firstname']." ".$_SESSION['lastname'];
$GLOBALS['temp']['gen_date'] = chng_date(date("Y-m-d"),"-");

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$contactRoleGeneral = $contactRoleGuest = $contactRoleUser = $contactRoleAgent = false;

if($_SERVER['argv'][1] == "") {
	$GLOBALS['temp']['contactRoleNames'] = "All";
	$GLOBALS['temp']['contactRoleIds'] = '<input type="hidden" id="contactRoleIds" name="contactRoleIds" value="">';
} else {
	$contactRoleIds = explode(":",$_SERVER['argv'][1]);
	$nameArr = array();
	if(in_array("RS1",$contactRoleIds) ) {
		$nameArr[] = "General (no role)";
		$contactRoleGeneral = true;
	}
	if(in_array("RS2",$contactRoleIds) ) {
		$nameArr[] = "Guest";
		$contactRoleGuest = true;
	}
	if(in_array("RS3",$contactRoleIds) ) {
		$nameArr[] = "User";
		$contactRoleUser = true;
	}
	if(in_array("RS4",$contactRoleIds) ) {
		$nameArr[] = "Agent";
		$contactRoleAgent = true;
	}
	$GLOBALS['temp']['contactRoleNames'] = implode(", ", $nameArr);
	$GLOBALS['temp']['contactRoleIds'] = '<input type="hidden" id="contactRoleIds" name="contactRoleIds" value="'.$_SERVER['argv'][1].'">';
}

$contact_name_opt = $_SERVER['argv'][2];
$contact_type = $_SERVER['argv'][3];
$GLOBALS['temp']['contactInd'] = "";
$GLOBALS['temp']['contactOrg'] = "";
if($contact_type == "1") {
	$GLOBALS['temp']['contactInd'] = " selected";
} 
if($contact_type == "2") {
	$GLOBALS['temp']['contactOrg'] = " selected";
} 

$contactNameFilter = useFilter("contactName", $_SERVER['argv'][4],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona_ix =", "pr_persona.pr_persona", false,false,false);

$addressSearchType = $_SERVER['argv'][46];
$GLOBALS['temp']['inclusiveSearchChecked'] = " selected";
$GLOBALS['temp']['exclusiveSearchChecked'] = "";
if($addressSearchType == '1') {
	$GLOBALS['temp']['inclusiveSearchChecked'] = "";
	$GLOBALS['temp']['exclusiveSearchChecked'] = " selected";
}

$cont_name = $_SERVER['argv'][5];
$email = $_SERVER['argv'][6];
$postSub = $_SERVER['argv'][7];
$physSub = $_SERVER['argv'][8];

$GLOBALS['temp']['cont_name'] = $cont_name;
$GLOBALS['temp']['email'] = $email;
$GLOBALS['temp']['postSub'] = $postSub;
$GLOBALS['temp']['physSub'] = $physSub;

$cont_name 	= str_replace("*", "%", $cont_name);
$email 	= str_replace("*", "%", $email);
$postSub 	= str_replace("*", "%", $postSub);
$physSub 	= str_replace("*", "%", $physSub);


if ( $_SERVER['argv'][9] == "none" ) {
	$guestPostCountryFilter['names'] = 'None';
	$guestPostCountryFilter['where'] = "
		AND (
			pr_persona.pr_corr_country_id IS NULL
			OR pr_persona.pr_corr_country_id = ''
			OR pr_persona.pr_corr_country_id = '0'
		)
	";
	$GLOBALS['temp']['postCountryIds'] = "<input type=\"hidden\" id='postCountryIds' value='none'>";
	$GLOBALS['temp']['postCountryNames'] = "None";
} else {
	$guestPostCountryFilter = useFilter("postCountry",$_SERVER['argv'][9],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_corr_country_id",false,false,false);
}

if ( $_SERVER['argv'][10] == "none" ) {
	$guestPhysCountryFilter['names'] = 'None';
	$guestPhysCountryFilter['where'] = "
		AND (
			pr_persona.pr_phys_country_id IS NULL
			OR pr_persona.pr_phys_country_id = ''
			OR pr_persona.pr_phys_country_id = '0'
		)
	";
	$GLOBALS['temp']['physCountryIds'] = "<input type=\"hidden\" id='physCountryIds' value='none'>";
	$GLOBALS['temp']['physCountryNames'] = "None";
} else {
	$guestPhysCountryFilter = useFilter("physCountry",$_SERVER['argv'][10],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_phys_country_id",false,false,false);
}

$postZip = $_SERVER['argv'][11];
$physZip = $_SERVER['argv'][12];
$GLOBALS['temp']['postZip'] = $postZip;
$GLOBALS['temp']['physZip'] = $physZip;
$postZip 	= str_replace("*", "%", $postZip);
$physZip 	= str_replace("*", "%", $physZip);

$inactiveContact = $_SERVER['argv'][13];
$GLOBALS['temp']['inactiveExcludeChecked'] = " selected";
$GLOBALS['temp']['inactiveIncludeChecked'] = "";
if($inactiveContact == '1') {
	$GLOBALS['temp']['inactiveExcludeChecked'] = "";
	$GLOBALS['temp']['inactiveIncludeChecked'] = " selected";
}

// -- START Travel Date

$travelDateType = $_SERVER['argv'][42];
$GLOBALS['temp']['travelDefaultChecked'] = "";
$GLOBALS['temp']['travelTodayChecked'] = "";
$GLOBALS['temp']['travelWeekChecked'] = "";
$GLOBALS['temp']['travelMonthChecked'] = "";
$GLOBALS['temp']['travelYearChecked'] = "";
$GLOBALS['temp']['travelCustomChecked'] = "";
$GLOBALS['temp']['travelArrChecked'] = "";
$GLOBALS['temp']['travelSoChecked'] = "";
$GLOBALS['temp']['travelDepChecked'] = "";

switch($travelDateType) {
case "1":
	$GLOBALS['temp']['travelTodayChecked'] = "selected";
	$travelFromDate = useDate("travelFrom",date("Y-m-d"));
	$travelToDate = useDate("travelTo",date("Y-m-d"));

	$travelWhere = "
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart > '$travelToDate[jsDate]'
			)
		)
	";

	break;
case "2":
	$GLOBALS['temp']['travelWeekChecked'] = "selected";
	$travelDateArr = getWeekDates();
	$travelFromDate = useDate("travelFrom", $travelDateArr[0]);
	$travelToDate = useDate("travelTo", $travelDateArr[1]);
	$travelWhere = "
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart > '$travelToDate[jsDate]'
			)
		)
	";
	break;
case "3":
	$GLOBALS['temp']['travelMonthChecked'] = "selected";
	$travelFromDate = useDate("travelFrom", date("Y-m") . "-01");
	$travelToDate = useDate("travelTo", date("Y-m-d", mktime(0,0,0,date("m")+1,0,date("Y"))));
	$travelWhere = "
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart > '$travelToDate[jsDate]'
			)
		)
	";
	break;
case "4":
	$GLOBALS['temp']['travelYearChecked'] = "selected";
	$travelFromDate = useDate("travelFrom", date("Y") . "-01-01");
	$travelToDate = useDate("travelTo", date("Y") . "-12-31");
	$travelWhere = "
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart > '$travelToDate[jsDate]'
			)
		)
	";
	break;
case "5":
	$GLOBALS['temp']['travelCustomChecked'] = "selected";
	$travelFromDate = useDate("travelFrom", $_SERVER['argv'][43]);
	$travelToDate = useDate("travelTo", $_SERVER['argv'][44]);
	$travelWhere = "
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart > '$travelToDate[jsDate]'
			)
		)
	";
	
	break;
case "6":
	$GLOBALS['temp']['travelArrChecked'] = "selected";
	$travelFromDate = useDate("travelFrom", $_SERVER['argv'][43]);
	$travelToDate = useDate("travelTo", $_SERVER['argv'][44]);
	$travelWhere = "
		AND rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
		AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
	";
	break;
case "7":
	$GLOBALS['temp']['travelSoChecked'] = "selected";
	$travelFromDate = useDate("travelFrom", $_SERVER['argv'][43]);
	$travelToDate = useDate("travelTo", $_SERVER['argv'][44]);
	$travelWhere = "
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_arrive <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$travelFromDate[jsDate]' 
				AND rv_reservation_item.rv_item_date_depart > '$travelToDate[jsDate]'
			)
		)
	";
	break;
case "8":
	$GLOBALS['temp']['travelDepChecked'] = "selected";
	$travelFromDate = useDate("travelFrom", $_SERVER['argv'][43]);
	$travelToDate = useDate("travelTo", $_SERVER['argv'][44]);
	$travelWhere = "
		AND rv_reservation_item.rv_item_date_depart >= '$travelFromDate[jsDate]' 
		AND rv_reservation_item.rv_item_date_depart <= '$travelToDate[jsDate]'
	";
	break;
default:
	$GLOBALS['temp']['travelDefaultChecked'] = "selected";
	$GLOBALS['temp']["travelFromY"] = "";
	$GLOBALS['temp']["travelFromM"] = 0;
	$GLOBALS['temp']["travelFromD"] = 0;
	$GLOBALS['temp']["travelToY"] = "";
	$GLOBALS['temp']["travelToM"] = 0;
	$GLOBALS['temp']["travelToD"] = 0;
	$travelFromDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
	$travelToDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
	$travelWhere = "";
	break;
}

$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = concat(ac_accomm_type.ac_accomm_type_db,ac_accomm_type.ac_accomm_type_id)
	ORDER BY
		ac_accomm_type.ac_accomm_type_ix DESC
", 3);

$accommFilter = useFilter("accomm",$_SERVER['argv'][45],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

if ($travelDateType != "" || !$accommFilter['all']){
	$GLOBALS['temp']['guestDisplay'] = "";	
} else {
	$GLOBALS['temp']['guestDisplay'] = "collapse";	
}

// --- END Travel Date



$agentACL = false;
if ( $userStatusId < 2 ) {
	$agentACL = array($calAgentId);
}

$birthDateType = $_SERVER['argv'][14];
$GLOBALS['temp']['birthTodayChecked'] = "";
$GLOBALS['temp']['birthWeekChecked'] = "";
$GLOBALS['temp']['birthMonthChecked'] = "";
$GLOBALS['temp']['birthRangeChecked'] = "";

switch($birthDateType) {
case "1":
	$GLOBALS['temp']['birthTodayChecked'] = "selected";
	$birthFromDate = useDate("birthFrom",date("Y-m-d"));
	$birthToDate = useDate("birthTo",date("Y-m-d"));
	break;
case "2":
	$GLOBALS['temp']['birthWeekChecked'] = "selected";
	$birthDateArr = getWeekDates();
	$birthFromDate = useDate("birthFrom", $birthDateArr[0]);
	$birthToDate = useDate("birthTo", $birthDateArr[1]);
	break;
case "3":
	$GLOBALS['temp']['birthMonthChecked'] = "selected";
	$birthFromDate = useDate("birthFrom", date("Y-m") . "-01");
	$birthToDate = useDate("birthTo", date("Y-m-d", mktime(0,0,0,date("m")+1,0,date("Y"))));
	break;
case "5":
	$GLOBALS['temp']['birthRangeChecked'] = "selected";
	$birthFromDate = useDate("birthFrom", $_SERVER['argv'][15]);
	$birthToDate = useDate("birthTo", $_SERVER['argv'][16]);
	break;
default:
	$GLOBALS['temp']['birthDefaultChecked'] = "selected";
	$GLOBALS['temp']["birthFromY"] = "";
	$GLOBALS['temp']["birthFromM"] = 0;
	$GLOBALS['temp']["birthFromD"] = 0;
	$GLOBALS['temp']["birthToY"] = "";
	$GLOBALS['temp']["birthToM"] = 0;
	$GLOBALS['temp']["birthToD"] = 0;
	$fromDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
	$toDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
	break;
}

$contactCreatedDateType = $_SERVER['argv'][47];
$GLOBALS['temp']['contactCreatedTodayChecked'] = "";
$GLOBALS['temp']['contactCreatedWeekChecked'] = "";
$GLOBALS['temp']['contactCreatedMonthChecked'] = "";
$GLOBALS['temp']['contactCreatedYearChecked'] = "";
$GLOBALS['temp']['contactCreatedRangeChecked'] = "";

$emailEditedDateType = $_SERVER['argv'][50];
$GLOBALS['temp']['emailEditedTodayChecked'] = "";
$GLOBALS['temp']['emailEditedWeekChecked'] = "";
$GLOBALS['temp']['emailEditedMonthChecked'] = "";
$GLOBALS['temp']['emailEditedYearChecked'] = "";
$GLOBALS['temp']['emailEditedRangeChecked'] = "";

switch($contactCreatedDateType) {
case "1":
    $GLOBALS['temp']['contactCreatedTodayChecked'] = "selected";
    $contactCreatedFromDate = useDate("contactCreatedFrom",date("Y-m-d"));
    $contactCreatedToDate = useDate("contactCreatedTo",date("Y-m-d"));
    break;
case "2":
    $GLOBALS['temp']['contactCreatedWeekChecked'] = "selected";
    $contactCreatedDateArr = getWeekDates();
    $contactCreatedFromDate = useDate("contactCreatedFrom", $contactCreatedDateArr[0]);
    $contactCreatedToDate = useDate("contactCreatedTo", $contactCreatedDateArr[1]);
    break;
case "3":
    $GLOBALS['temp']['contactCreatedMonthChecked'] = "selected";
    $contactCreatedFromDate = useDate("contactCreatedFrom", date("Y-m") . "-01");
    $contactCreatedToDate = useDate("contactCreatedTo", date("Y-m-d", mktime(0,0,0,date("m")+1,0,date("Y"))));
    break;
case "4":
    $GLOBALS['temp']['contactCreatedYearChecked'] = "selected";
    $contactCreatedFromDate = useDate("contactCreatedFrom", date("Y") . "-01-01");
    $contactCreatedToDate = useDate("contactCreatedTo", date("Y") . "-12-31");
    break;
case "5":
    $GLOBALS['temp']['contactCreatedRangeChecked'] = "selected";
    $contactCreatedFromDate = useDate("contactCreatedFrom", $_SERVER['argv'][48]);
    $contactCreatedToDate = useDate("contactCreatedTo", $_SERVER['argv'][49]);
    break;
default:
    $GLOBALS['temp']['contactCreatedDefaultChecked'] = "selected";
    $GLOBALS['temp']["contactCreatedFromY"] = "";
    $GLOBALS['temp']["contactCreatedFromM"] = 0;
    $GLOBALS['temp']["contactCreatedFromD"] = 0;
    $GLOBALS['temp']["contactCreatedToY"] = "";
    $GLOBALS['temp']["contactCreatedToM"] = 0;
    $GLOBALS['temp']["contactCreatedToD"] = 0;
    $fromDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
    $toDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
    break;
}

switch($emailEditedDateType) {
case "1":
    $GLOBALS['temp']['emailEditedTodayChecked'] = "selected";
    $emailEditedFromDate = useDate("emailEditedFrom",date("Y-m-d"));
    $emailEditedToDate = useDate("emailEditedTo",date("Y-m-d"));
    break;
case "2":
    $GLOBALS['temp']['emailEditedWeekChecked'] = "selected";
    $emailEditedDateArr = getWeekDates();
    $emailEditedFromDate = useDate("emailEditedFrom", $emailEditedDateArr[0]);
    $emailEditedToDate = useDate("emailEditedTo", $emailEditedDateArr[1]);
    break;
case "3":
    $GLOBALS['temp']['emailEditedMonthChecked'] = "selected";
    $emailEditedFromDate = useDate("emailEditedFrom", date("Y-m") . "-01");
    $emailEditedToDate = useDate("emailEditedTo", date("Y-m-d", mktime(0,0,0,date("m")+1,0,date("Y"))));
    break;
case "4":
    $GLOBALS['temp']['emailEditedYearChecked'] = "selected";
    $emailEditedFromDate = useDate("emailEditedFrom", date("Y") . "-01-01");
    $emailEditedToDate = useDate("emailEditedTo", date("Y") . "-12-31");
    break;
case "5":
    $GLOBALS['temp']['emailEditedRangeChecked'] = "selected";
    $emailEditedFromDate = useDate("emailEditedFrom", $_SERVER['argv'][51]);
    $emailEditedToDate = useDate("emailEditedTo", $_SERVER['argv'][52]);
    break;
default:
    $GLOBALS['temp']['emailEditedDefaultChecked'] = "selected";
    $GLOBALS['temp']["emailEditedFromY"] = "";
    $GLOBALS['temp']["emailEditedFromM"] = 0;
    $GLOBALS['temp']["emailEditedFromD"] = 0;
    $GLOBALS['temp']["emailEditedToY"] = "";
    $GLOBALS['temp']["emailEditedToM"] = 0;
    $GLOBALS['temp']["emailEditedToD"] = 0;
    $fromDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
    $toDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
    break;
}

$annDateType = $_SERVER['argv'][17];
$GLOBALS['temp']['annTodayChecked'] = "";
$GLOBALS['temp']['annWeekChecked'] = "";
$GLOBALS['temp']['annMonthChecked'] = "";
$GLOBALS['temp']['annRangeChecked'] = "";

switch($annDateType) {
case "1":
	$GLOBALS['temp']['annTodayChecked'] = "selected";
	$annFromDate = useDate("annFrom",date("Y-m-d"));
	$annToDate = useDate("annTo",date("Y-m-d"));
	break;
case "2":
	$GLOBALS['temp']['annWeekChecked'] = "selected";
	$annDateArr = getWeekDates();
	$annFromDate = useDate("annFrom", $annDateArr[0]);
	$annToDate = useDate("annTo", $annDateArr[1]);
	break;
case "3":
	$GLOBALS['temp']['annMonthChecked'] = "selected";
	$annFromDate = useDate("annFrom", date("Y-m") . "-01");
	$annToDate = useDate("annTo", date("Y-m-d", mktime(0,0,0,date("m")+1,0,date("Y"))));
	break;
case "5":
	$GLOBALS['temp']['annRangeChecked'] = "selected";
	$annFromDate = useDate("annFrom", $_SERVER['argv'][18]);
	$annToDate = useDate("annTo", $_SERVER['argv'][19]);
	break;
default:
	$GLOBALS['temp']['annDefaultChecked'] = "selected";
	$GLOBALS['temp']['annFromY'] = "";
	$GLOBALS['temp']['annFromM'] = 0;
	$GLOBALS['temp']['annFromD'] = 0;
	$GLOBALS['temp']['annToY'] = "";
	$GLOBALS['temp']['annToM'] = 0;
	$GLOBALS['temp']['annToD'] = 0;
	$annToDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
	$annToDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
	break;
}

$profile_custom= $lDB->get("
	SELECT DISTINCT
		rc_obj_sales_ix, rc_obj_sales_label, rc_obj_sales_sys_code, rc_obj_sales_type_ind, rc_obj_sales_inactive_yn
	FROM
		rc_obj_sales
	WHERE 
		rc_obj_sales_type_ind <> 7
", 2);

if(is_array($profile_custom)) {
	$profile_cust_row = "<tr>";
	$i=1;
	foreach($profile_custom as $cust) {
		if($cust['rc_obj_sales_sys_code'] == 0) {
			$profile_cust_row .= "
				<td><img src='/resource/Resrequest/Application/public/img/1x1.gif' alt='' /></td>
				<td>".$cust['rc_obj_sales_label'].":</td>
			";
		 }
		if($cust['rc_obj_sales_type_ind'] == 3 || $cust['rc_obj_sales_type_ind'] == 4 || $cust['rc_obj_sales_type_ind'] == 5) {
			$profile_cust_row .= "
				<td><button id='btnOpenProfile' type='button' class='button' style='width: 22px; height: 20px; padding: 0px;' onclick='openObjectFilter(\"sales\", \"$cust[rc_obj_sales_ix]\");'>
				<img src='/resource/Resrequest/Application/public/img/icon_search_16.gif' alt='' /></button></td>
				<td><textarea id='sales_".$cust['rc_obj_sales_ix']."Filter' style='width: 170px; height: 20px;' class='txtg' readonly='readonly' tabIndex='-1' name='sales_".$cust['rc_obj_sales_ix']."Filter'>!sales_".$cust['rc_obj_sales_ix']."Names!</textarea></td>
				!sales_".$cust['rc_obj_sales_ix']."Ids!
			";

			if($_SERVER['argv'][20] == "") {
				$profile_cust_row = str_replace("!sales_".$cust['rc_obj_sales_ix']."Names!", "All", $profile_cust_row);
				$hidGuestIds = "<input type=\"hidden\" name='sales_profile[]' id='sales_".$cust['rc_obj_sales_ix']."Ids' value=''>";
				$profile_cust_row = str_replace("!sales_".$cust['rc_obj_sales_ix']."Ids!", $hidGuestIds, $profile_cust_row);
				$GLOBALS['temp']['sales_'.$cust['rc_obj_sales_ix'].'Names'] = "All";
				$GLOBALS['temp']['sales_'.$cust['rc_obj_sales_ix'].'Ids'] = "<input type=\"hidden\" name='sales_profile[]' id='sales_'".$cust['rc_obj_sales_ix']."Ids' value=''>";
				
			}
			
		} else if($cust['rc_obj_sales_type_ind'] == 8) {
			if($cust['rc_obj_sales_ix'] == "RS1") {
				if($_SERVER['argv'][20] == "") {
					$GLOBALS['temp']['eventOriginNames'] = "All";
					$GLOBALS['temp']['eventOriginIds'] = "<input type=\"hidden\" name='eventOriginIds' id='eventOriginIds' value=''>";
				}
			}
			if($cust['rc_obj_sales_ix'] == "RS2") {
				if($_SERVER['argv'][20] == "") {
					$GLOBALS['temp']['internalRepSalesNames'] = "All";
					$GLOBALS['temp']['internalRepSalesIds'] = "<input type=\"hidden\" name='internalRepSalesIds' id='internalRepSalesIds' value=''>";
				}
			}
			if($cust['rc_obj_sales_ix'] == "RS3") {
				if($_SERVER['argv'][20] == "") {
					$GLOBALS['temp']['propertiesExtraNames'] = "All";
					$GLOBALS['temp']['propertiesExtraIds'] = "<input type=\"hidden\" name='propertiesExtraIds' id='propertiesExtraIds' value=''>";
				}
			}
		} else {
			if($_SERVER['argv'][20] == "") {
				$fieldVal = "";
			} else {
				$fieldVal = "!sales_".$cust['rc_obj_sales_ix']."Names!";
			}
			$profile_cust_row .= "
				<td>&nbsp;</td><td><input type='text' id='sales_".$cust['rc_obj_sales_ix']."' name='sales_profile[]' style='width: 170px;' maxlength='50' class='txt' tabindex='-1' value='$fieldVal'></td>
			";
		}
		
		if($cust['rc_obj_sales_sys_code'] == 0) {
			if($i%2==0) {
				$profile_cust_row .= "<td>&nbsp;</td></tr><tr>";
			}
			$i++;
		}
	}
	$profile_cust_row .= "</tr>";
}
$GLOBALS['temp']['sales_profile_rows'] = $profile_cust_row;


if($_SERVER['argv'][14]=="" && $_SERVER['argv'][15]=="" && $_SERVER['argv'][16]=="" && $_SERVER['argv'][17]=="" && $_SERVER['argv'][18]=="" && $_SERVER['argv'][19]=="" && $_SERVER['argv'][20]=="") {
	$GLOBALS['temp']['profileDispaly'] = "collapse";
} else{
	$GLOBALS['temp']['profileDispaly'] = "";
}

$GLOBALS['temp']['showAllChecked'] = "";
$GLOBALS['temp']['showAgentsChecked'] = "";
$GLOBALS['temp']['showAgentContactsChecked'] = "";

$agentFilterTable = "pr_persona";
switch($_SERVER['argv'][41]) {
default: // Show all contacts
	$GLOBALS['temp']['showAllChecked'] = "checked";
	$show = "all";
	break;
case "agents": // Show agents filtered by agent/agent country filters
case "2": 
	$GLOBALS['temp']['showAgentsChecked'] = "checked";
	$show = "agents";
	break;
case "agentContacts": // Show agent contacts filtered by agent/agent country filtersc
case "1": // Backwards compatibility for old profiles
	$GLOBALS['temp']['showAgentContactsChecked'] = "checked";
	$show = "agentContacts";
	$agentFilterTable = "agentpersonas";
	break;
}

$agentFilter = useFilter("agent",$_SERVER['argv'][39],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",$agentFilterTable.".pr_persona_ix",$agentACL,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][40],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",$agentFilterTable.".pr_corr_country_id",false,false,false);
$agentSelect = $_SERVER['argv'][38];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentSelect == "country") {
   $GLOBALS['temp']['agentNameRadioChecked'] = "";
   $GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
   $agentWhere = $agentCountryFilter['where'];
} else {
   $agentWhere = $agentFilter['where'];
}


$eventType = $_SERVER['argv'][21];
$GLOBALS['temp']['eventType_noEventChecked'] = "";
$GLOBALS['temp']['eventType_noDateChecked'] = "";
$GLOBALS['temp']['eventType_optChecked'] = "";
$GLOBALS['temp']['eventType_uptoChecked'] = "";
$GLOBALS['temp']['eventType_customChecked'] = "";
$salesWhere = "";
$GLOBALS['temp']["fromY"] = "";
$GLOBALS['temp']["fromM"] = 0;
$GLOBALS['temp']["fromD"] = 0;
$GLOBALS['temp']["toY"] = "";
$GLOBALS['temp']["toM"] = 0;
$GLOBALS['temp']["toD"] = 0;
$fromDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
$toDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
$salesWhere = "";
if($eventType == "1" ) {
	$GLOBALS['temp']['eventType_noEventChecked'] = " checked='checked'";
}
if($eventType == "2" ) {
	$GLOBALS['temp']['eventType_noDateChecked'] = " checked='checked'";
	$salesWhere = " AND pr_event.pr_event_date='0000-00-00'";
}

if($eventType == "3" ) {
	$GLOBALS['temp']['eventType_optChecked'] = " checked='checked'";
	$dateType = $_SERVER['argv'][22];
	$GLOBALS['temp']['defaultChecked'] = "";
	$GLOBALS['temp']['todayChecked'] = "";
	$GLOBALS['temp']['weekChecked'] = "";
	$GLOBALS['temp']['monthChecked'] = "";
	$GLOBALS['temp']['yearChecked'] = "";
	switch($dateType) {
	case "1":
		$GLOBALS['temp']['todayChecked'] = "selected";
		$fromDate = useDate("from",date("Y-m-d"));
		$toDate = useDate("to",date("Y-m-d"));
		$salesWhere = " AND pr_event.pr_event_date='$toDate[jsDate]'";
		break;
	case "2":
		$GLOBALS['temp']['weekChecked'] = "selected";
		$salesDateArr = getWeekDates();
		$fromDate = useDate("from", $salesDateArr[0]);
		$toDate = useDate("to", $salesDateArr[1]);
		$salesWhere = " AND pr_event.pr_event_date<='$toDate[jsDate]' AND pr_event.pr_event_date >= '$fromDate[jsDate]'";
		break;
	case "3":
		$GLOBALS['temp']['monthChecked'] = "selected";
		$fromDate = useDate("from", date("Y-m") . "-01");
		$toDate = useDate("to", date("Y-m-d", mktime(0,0,0,date("m")+1,0,date("Y"))));
		$salesWhere = " AND pr_event.pr_event_date<='$toDate[jsDate]' AND pr_event.pr_event_date >= '$fromDate[jsDate]'";
		break;
	case "4":
		$GLOBALS['temp']['yearChecked'] = "selected";
		$fromDate = useDate("from", date("Y") . "-01-01");
		$toDate = useDate("to", date("Y") . "-12-31");
		$salesWhere = " AND pr_event.pr_event_date<='$toDate[jsDate]' AND pr_event.pr_event_date >= '$fromDate[jsDate]'";
		break;
	default:
		$GLOBALS['temp']['defaultChecked'] = "selected";
		$GLOBALS['temp']["fromY"] = "";
		$GLOBALS['temp']["fromM"] = 0;
		$GLOBALS['temp']["fromD"] = 0;
		$GLOBALS['temp']["toY"] = "";
		$GLOBALS['temp']["toM"] = 0;
		$GLOBALS['temp']["toD"] = 0;
		$fromDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
		$toDate = array('jsDate'=>"", 'htmlDate'=>"", 'dateArray'=>array());
		$salesWhere = "";
		break;
	}
}

if($eventType == "4" ) {
	$GLOBALS['temp']['eventType_uptoChecked'] = " checked='checked'";
	$fromDate = useDate("from",date("Y-m-d"));
	$toDate = useDate("to",date("Y-m-d"));
	$salesWhere = " AND pr_event.pr_event_date<='$toDate[jsDate]'";
}

if($eventType == "5" ) {
	$GLOBALS['temp']['eventType_customChecked'] = " checked='checked'";
	$fromDate = useDate("from", $_SERVER['argv'][23]);
	$toDate = useDate("to", $_SERVER['argv'][24]);
	$salesWhere = " AND pr_event.pr_event_date<='$toDate[jsDate]' AND pr_event.pr_event_date >= '$fromDate[jsDate]'";
}


$eventActionFilter = useFilter("eventAction", $_SERVER['argv'][25],"SELECT rc_action.rc_action_desc FROM rc_action WHERE rc_action_ix =", "pr_event.rc_action_id", false,"No Event type","0");
if($eventActionFilter['ids'] == '0') {
	$GLOBALS['temp']['eventActionNames'] = "No Event type";
	$eventActionFilter['names'] = "No Event type";
	$eventActionFilter['where'] = "";
}

$eventTagFilter = useFilter("event_tag", $_SERVER['argv'][26],"SELECT rc_tag.rc_tag_desc FROM rc_tag WHERE rc_tag_ix =", "rc_event_tag.rc_tag_id", false,"No Event Tag","0");

if($eventTagFilter['ids'] == '0') {
	$GLOBALS['temp']['event_tagNames'] = "No Event Tag";
	$eventTagFilter['names'] = "No Event Tag";
	$eventTagFilter['where'] = "";
}

$eventFilter = useFilter("event", $_SERVER['argv'][27],"SELECT rc_event.rc_event_desc FROM rc_event WHERE rc_event_ix =", "pr_event.rc_event_id", false,"No Event","0");
if($eventFilter['ids'] == '0') {
	$GLOBALS['temp']['eventNames'] = "No Event";
	$eventFilter['names'] = "No Event";
	$eventFilter['where'] = "";
}

$internalRepFilter = useFilter("internalRep", $_SERVER['argv'][28],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona_ix =", "pr_event_persona.pr_persona_id", false,"No Contact","0");
if($internalRepFilter['ids'] == '0') {
	$GLOBALS['temp']['internalRepNames'] = "No Contact";
	$internalRepFilter['names'] = "No Contact";
	$internalRepFilter['where'] = "";
}

$clientRepFilter = useFilter("clientRep", $_SERVER['argv'][29],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona_ix =", "pr_persona.pr_persona_ix", false,"No Contact","0");
if($clientRepFilter['ids'] == '0') {
	$GLOBALS['temp']['clientRepNames'] = "No Contact";
	$clientRepFilter['names'] = "No Contact";
	$clientRepFilter['where'] = "";
}
$eventCompleted = ($_SERVER['argv'][30] != "") ? $_SERVER['argv'][30] : "all";
$eventCompletedSQL = "";
$GLOBALS['temp']['event_completedChecked'] = "";
$GLOBALS['temp']['event_openChecked'] = "";
if($eventCompleted == "0") {
	$GLOBALS['temp']['event_openChecked'] = " selected";
	$eventCompletedSQL = " AND pr_event.pr_event_completed_yn = '0'";
}
if($eventCompleted == "1") {
	$GLOBALS['temp']['event_completedChecked'] = " selected";
	$eventCompletedSQL = " AND pr_event.pr_event_completed_yn = '1'";
}


if($_SERVER['argv'][27]=="" && $_SERVER['argv'][28]=="" && $_SERVER['argv'][31]=="" && $_SERVER['argv'][32]=="" && $_SERVER['argv'][39]!="2" && $_SERVER['argv'][40]!="2") {
	$GLOBALS['temp']['HistoryDispaly'] = "collapse";
} else{
	$GLOBALS['temp']['HistoryDispaly'] = "";
}

$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);
$lastID = 30;

global $cols;
$cols = array(
	array('id'=>'1' , 'label'=>'Lastname / Organisation', 'type'=>"string", 'fields'=>array("pr_persona.pr_name_last"), 'style'=>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'2' , 'label'=>'Firstname', 'type'=>"string", 'fields'=>array("pr_persona.pr_name_first"), 'style'=>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'3' , 'label'=>'Role', 'type'=>"string", 'fields'=>array("pr_persona.pr_persona_role"), 'style'=>array('bold'=>"1"), 'width'=>"65", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'10', 'sortable'=>true),
	array('id'=>'4' , 'label'=>'Type', 'type'=>"string", 'fields'=>array("pr_persona.pr_persona_type"), 'style'=>array('bold'=>"1"), 'width'=>"65", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'11', 'sortable'=>true),
	array('id'=>'5' , 'label'=>'Title', 'type'=>"string", 'fields'=>array("rf_title.rf_title_desc"), 'style' =>array('bold'=>"1"), 'width'=>"70", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'6' , 'label'=>'Telephone', 'type'=>"complex", 'fields'=>array("pr_persona.pr_persona_ix"), 'function'=>"getPhoneNumber", 'style' =>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'7' , 'label'=>'Fax', 'type'=>"string", 'fields'=>array("pr_persona.pr_fax_number"), 'style' =>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'8' , 'label'=>'Email', 'type'=>"string", 'fields'=>array("pr_persona.pr_email"), 'style' =>array('bold'=>"1"), 'width'=>"150", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'9' , 'label'=>'Birthdate', 'type'=>"string", 'fields'=>array("pr_persona.pr_birthdate"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'10' , 'label'=>'Anniversary', 'type'=>"string", 'fields'=>array("pr_persona.pr_anniversary"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'11' , 'label'=>'Comms pref', 'type'=>"string", 'fields'=>array("rf_comms_preference.rf_comms_desc"), 'style'=>array('bold'=>"1"), 'width'=>"65", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'12' , 'label'=>'Agent relationship', 'type'=>"string", 'fields'=>array("pr_persona.pr_persona_agent_rel"), 'sortAlias'=>array("agent_relationship_last"), 'style'=>array('bold'=>"1"), 'width'=>"140", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'13' , 'label'=>'Internal staff relationship', 'type'=>"string", 'fields'=>array("pr_persona.pr_persona_int_rel"), 'style'=>array('bold'=>"1"), 'width'=>"140", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'14' , 'label'=>$default_statutory_labels['rf_statutory_label_1'], 'type'=>"string", 'fields'=>array("pr_persona.pr_statutory_1"), 'style'=>array('bold'=>"1"), 'width'=>"120", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'15' , 'label'=>'Forwarding contact', 'type'=>"string", 'fields'=>array(".fwd_persona_name"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'16' , 'label'=>'Postal Address line 1', 'type'=>"string", 'fields'=>array("pr_persona.pr_corr_addr_line1"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'17' , 'label'=>'Postal Address line 2', 'type'=>"string", 'fields'=>array("pr_persona.pr_corr_addr_line2"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'18' , 'label'=>'Postal Address line 3', 'type'=>"string", 'fields'=>array("pr_persona.pr_corr_addr_line3"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'19' , 'label'=>'Postal country', 'type'=>"string", 'fields'=>array("pr_persona.pr_corr_country_name"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'20' , 'label'=>'Postal suburb/city', 'type'=>"string", 'fields'=>array("pr_persona.pr_corr_city"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'21' , 'label'=>'Postal zip', 'type'=>"string", 'fields'=>array("pr_persona.pr_corr_post_code"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'22' , 'label'=>'Physical Address line 1', 'type'=>"string", 'fields'=>array("pr_persona.pr_phys_addr_line1"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'23' , 'label'=>'Physical Address line 2', 'type'=>"string", 'fields'=>array("pr_persona.pr_phys_addr_line2"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'24' , 'label'=>'Physical Address line 3', 'type'=>"string", 'fields'=>array("pr_persona.pr_phys_addr_line3"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'25' , 'label'=>'Physical country', 'type'=>"string", 'fields'=>array("pr_persona.pr_phys_country_name"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'26' , 'label'=>'Physical suburb/city', 'type'=>"string", 'fields'=>array("pr_persona.pr_phys_city"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'27' , 'label'=>'Physical zip', 'type'=>"string", 'fields'=>array("pr_persona.pr_phys_post_code"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>false),
	array('id'=>'28' , 'label'=>'Link Type', 'type'=>"complex", 'fields'=>array("pr_persona.pr_persona_ix"), 'function'=>"getContactLink", 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'29' , 'label'=>'Web Address', 'type'=>"string", 'fields'=>array("pr_persona.pr_web_addr"), 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true),
	array('id'=>'30' , 'label'=>'Phone Type', 'type'=>"complex", 'fields'=>array("pr_persona.pr_persona_ix"), 'function'=>"getPhoneType", 'style'=>array('bold'=>"1"), 'width'=>"200", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true)
);

if ($default_statutory_labels['rf_statutory_label_2'] != "") {
	$lastID++;
	array_push($cols, array('id'=>$lastID , 'label'=>$default_statutory_labels['rf_statutory_label_2'], 'type'=>"string", 'fields'=>array("pr_persona.pr_statutory_2"), 'style'=>array('bold'=>"1"), 'width'=>"120", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true));
}

if ($default_statutory_labels['rf_statutory_label_3'] != "") {
	$lastID++;
	array_push($cols, array('id'=>$lastID , 'label'=>$default_statutory_labels['rf_statutory_label_3'], 'type'=>"string", 'fields'=>array("pr_persona.pr_statutory_3"), 'style'=>array('bold'=>"1"), 'width'=>"120", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>'', 'sortable'=>true));
}
 
 
$colArg = $_SERVER['argv'][31];
$colArray = array();
$colOrder = array();
$colSort = array();
$colHeader = false;

if(trim($colArg) != "") {
	$count = 0;
	foreach(explode(":",$colArg) as $item) {
		$col = explode(",",$item);
		if(isset($col[11]) && $col[11] != "") {
			$id = $col[11];
		} else {
			$id = $count+1;
		}

		$colActive[$id] = $col[0];
		$colOrder[$id] = $col[1];
		$colSort[$id] = $col[2];
		$width = $col[3];
		if(!is_numeric($width)) {
			$width = $cols[$count]['width'];
		}
		$label = trim(urldecode($col[4]));
		if($label == "") {
			$label = $cols[$count]['label'];
		}
		$header = trim($col[5]);
		if($header != "") {
			$colHeader = true;
		}
		$align = trim($col[6]);
		if($align == "") {
			$align = $cols[$count]['align'];
		}
		$objType = trim($col[7]);
		if($objType == "") {
			$objType = $cols[$count]['objType'];
		}
		$rc_obj_sales_ix = trim($col[8]);
		if($rc_obj_sales_ix == "") {
			$rc_obj_sales_ix = $cols[$count]['rc_obj_sales_ix'];
		}
		$split = trim($col[9]);
		$sortable = $cols[$count]['sortable'];
		
		$colArray[$id] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			"direction"=>isset($col[10]) ? $col[10] : "",
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"rc_obj_sales_ix"=>$rc_obj_sales_ix,
			"sortable"=>$sortable
		);

		$cols[$count]['active'] = $col[0];
		$cols[$count]['order'] = $col[1];
		$cols[$count]['sort'] = $col[2];
		$cols[$count]['direction'] = isset($col[10]) ? $col[10] : "";
		$cols[$count]['width'] = $width;
		$cols[$count]['label'] = $label;
		$cols[$count]['header'] = $header;
		$cols[$count]['split'] = $split;
		$cols[$count]['align'] = $align;
		$cols[$count]['objType'] = $objType;
		$cols[$count]['rc_obj_sales_ix'] = $rc_obj_sales_ix;
		$cols[$count]['sortable'] = $sortable;
		$count++;
	}
}


asort($colOrder);
asort($colSort);
$colData = array();


foreach($cols as $colKey=>$colItem) {
	$width = $colItem['width'];
	$sort = "";
	$col_direction = "";
	$label = $colItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = $colItem['align'];
	$objType = $colItem['objType'];
	$rc_obj_sales_ix = $colItem['rc_obj_sales_ix'];
	$sortable = $colItem['sortable'];
	$id = $colItem['id'];

	if(isset($colArray[$id]['active']) && $colArray[$id]['active'] == "1") {
		$width = $colArray[$id]['width'];
		$sort = $colArray[$id]['sort'];
		$col_direction = $colArray[$id]['direction'];		
		$label = $colArray[$id]['label'];
		$active = "1";
		$order = $colArray[$id]['order'];
		$split = $colArray[$id]['split'];
		$header = $colArray[$id]['header'];
		$align = $colArray[$id]['align'];
		$objType = $colArray[$id]['objType'];
		$rc_obj_sales_ix = $colArray[$id]['rc_obj_sales_ix'];
		$sortable = $colArray[$id]['sortable'];
	}
	
	$colDataItem = array(
		'"id":"'.$colItem['id'].'"',
		'"name":"'.$colItem['label'].'"',
		'"width":"'.$width.'"',
		'"sort":"'.$sort.'"',
		'"direction":"'.$col_direction.'"',
		'"label":"'.$label.'"',
		'"active":"'.$active.'"',
		'"order":"'.$order.'"',
		'"header":"'.$header.'"',
		'"split":"'.$split.'"',
		'"align":"'.$align.'"',
		'"objType":"'.$objType.'"',
		'"rc_obj_sales_ix":"'.$rc_obj_sales_ix.'"',
		'"sortable":"'.$sortable.'"'
	);
	
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}

$colData = '['.join(",",$colData).']';
$GLOBALS['temp']['colData'] = $colData;

$sort_array = array();
$orderArr = array();
 foreach ($cols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $cols);

// ------------  START SALES ------------

$salesColArg = $_SERVER['argv'][32];
$salesColActiveArray = [];

if(trim($salesColArg) != "") {
    foreach(explode(":",$salesColArg) as $item) {
        $salesCol = explode(",",$item);

        $rc_obj_sales_ix = trim($salesCol[8]);
        if($rc_obj_sales_ix == "" || !isset($salesCol[0]) || $salesCol[0] == "") {
            continue; // skip invalid columns
        }

        $salesColActiveArray[$rc_obj_sales_ix] = array(
            "active"    =>  $salesCol[0],
            "order"     =>  $salesCol[1],
            "sort"      =>  $salesCol[2],
            "width"     =>  $salesCol[3],
            "label"     =>  trim(urldecode($salesCol[4])),
            "header"    =>  trim($salesCol[5]),
            "align"     =>  trim($salesCol[6]),
            "objType"   =>  trim($salesCol[7]),
            "split"     =>  trim($salesCol[9]),
            "disable"   =>  isset($salesCol[10]) ? $salesCol[10] : "",
            "direction" =>  "",
            "sortable"  =>  "",
            "rc_obj_sales_ix" => $rc_obj_sales_ix
        );
    }
}

$salesCols = array();
$salesColData = array();
$salesColArray = array();
$salesColOrder = array();
$salesColSort = array();
$salesColHeader = false;

$sales_details= $lDB->get("
	SELECT DISTINCT
		rc_obj_sales_ix, 
		rc_obj_sales_label, 
		rc_obj_sales_type_ind, 
		rc_obj_sales_sort_seq, 
		rc_obj_sales_sys_code, 
		rc_obj_sales_inactive_yn
	FROM
		rc_obj_sales
	WHERE
		rc_obj_sales_type_ind <> '7'
", 2);

$counter = 1;
foreach($sales_details as $sales_report) {
    $inactive = 0;
    if($sales_report['rc_obj_sales_inactive_yn'] != 0) {
        $inactive = 1;
    }
    $rc_obj_sales_ix = $sales_report['rc_obj_sales_ix'];
    $sales_report['rc_obj_sales_label'] = str_replace([":", ","], ["", ""], $sales_report['rc_obj_sales_label']);

    //If field is active
    $active = $order = $sort = $header = $direction = "";
    $width = "120";
    $align = "l";
    $name = $sales_report['rc_obj_sales_label'];
    $label = $sales_report['rc_obj_sales_label'];
    $label = $sales_report['rc_obj_sales_label'];
    if(isset($salesColActiveArray[$sales_report['rc_obj_sales_ix']])){
        $label = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['label'];
        $active = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['active'];
        $order = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['order'];
        $sort = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['sort'];
        $width = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['width'];
        $align = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['align'];
        $sort = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['sort'];
        $header = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['header'];
        $direction = $salesColActiveArray[$sales_report['rc_obj_sales_ix']]['direction'];
    }

    if($header != "") {
        $salesColHeader = true;
    }
    $salesColActive[$counter] = $active;
    $salesColOrder[$counter] = $order;
    $salesColSort[$counter] = $sort;

    $salesCols[$counter] = array(
        'id'        =>  $counter,
        'active'    =>  $active,
        'label'     =>  $label,
        'name'      =>  $sales_report['rc_obj_sales_label'],
        'type'      =>  "string",
        'fields'    =>  array($sales_report['rc_obj_sales_ix']),
        'style'     =>  array('bold'=>"1"),
        'width'     =>  $width,
        'align'     =>  $align,
        'rc_obj_sales_ix'   =>  $sales_report['rc_obj_sales_ix'],
        'objType'   =>  $sales_report['rc_obj_sales_type_ind'],
        'disable'   =>  $inactive,
        'sortable'  =>  "",
        'direction' =>  "",
        'split'     =>  "",
        'header'    =>  "",
    );

    $salesColDataItem = array (
        '"id":"'.$counter.'"',
        '"name":"'.$name.'"',
        '"width":"'.$width.'"',
        '"sort":"'.$sort.'"',
        '"direction":"'.$direction.'"',
        '"label":"'.$label.'"',
        '"active":"'.$active.'"',
        '"order":"'.$order.'"',
        '"header":"'.$header.'"',
        '"split":"'.$split.'"',
        '"align":"'.$align.'"',
        '"objType":"'.$objType.'"',
        '"disable":"'.$inactive.'"',
        '"sortable":""',
        '"rc_obj_sales_ix":"'.$rc_obj_sales_ix.'"'
    );
    array_push($salesColData,'{'.join(",",$salesColDataItem)."}\n");
    $counter++;
}
$salesColArray = $salesCols;
$salesColData = '['.join(",",$salesColData).']';
$GLOBALS['temp']['salesColData'] = $salesColData;

asort($salesColOrder);
asort($salesColSort);

$sort_array = array();
$orderArr = array();
foreach ($salesCols as $key => $row) {
    $sort_array[$key]  = $row['id'];
    if(empty($row['order']))
        $orderArr[$key]  = 9999;
    else
        $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $salesCols);

// ------------  END SALES ------------

// ------------  Start Agents
global $agentCols;
$agentCols = array(
	array('id'=>'1' , 'label'=>'Firstname', 'type'=>"string", 'fields'=>array("pr_persona.pr_name_first AS agent_name_first"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'2' , 'label'=>'Lastname / Organisation', 'type'=>"string", 'fields'=>array("pr_persona.pr_name_last AS agent_name_last"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'3' , 'label'=>'Account Number', 'type'=>"string", 'fields'=>array("pr_agent.pr_agent_account"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'4' , 'label'=>'Internal Alloc', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_alloc_auto_yn"), 'function'=>"getFieldYesNo", 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'5' , 'label'=>'External Alloc', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_alloc_ext_yn"), 'function'=>"getFieldYesNo", 'style'=>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'6' , 'label'=>'Commission', 'type'=>"string", 'fields'=>array("pr_agent.pr_agent_commission_perc"), 'style'=>array('bold'=>"1"), 'width'=>"150", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'7' , 'label'=>'Commission Charged', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_comm_deduct_yn"), 'function'=>"getAgentCharge", 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'8' , 'label'=>'Note', 'type'=>"string", 'fields'=>array("pr_agent.pr_agent_note_open"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>true),
	array('id'=>'9' , 'label'=>'Show Shading', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_show_allocs_ind"), 'function'=>"getFieldYesNo", 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>false),
	array('id'=>'10' , 'label'=>'Default Pay Plan', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_id"), 'style'=>array('bold'=>"1"), 'function'=>"getDefaultAgentPayPlan", 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>false),
	array('id'=>'11' , 'label'=>'Date Override', 'type'=>"complex", 'fields'=>array("pr_agent.ac_pay_final_base"), 'function'=>"getAgentDayOverride", 'style'=>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'objType'=>'', 'sortable'=>false),
	array('id'=>'12' , 'label'=>'Day', 'type'=>"complex", 'fields'=>array("pr_agent.ac_pay_final_days"), 'function'=>"getAgentDay", 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>false),
	array('id'=>'13' , 'label'=>'Default Rate Type', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_id"), 'function'=>"getDefaultAgentRateType", 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'objType'=>'', 'sortable'=>false),
	array('id'=>'14' , 'label'=>'Rate Types', 'type'=>"complex", 'fields'=>array("pr_agent.pr_agent_id"), 'function'=>"getAgentRateTypes", 'style'=>array('bold'=>"1"), 'width'=>"140", 'align'=>"l", 'objType'=>'', 'sortable'=>false)
);

$agentColArg = $_SERVER['argv'][37];
$agentColArray = array();
$agentColOrder = array();
$agentColSort = array();
$agentColHeader = false;

if(trim($agentColArg) != "") {
	$count = 0;
	foreach(explode(":",$agentColArg) as $item) {
		$agentCol = explode(",",$item);
		if(isset($agentCol[11]) && $agentCol[11] != "") {
			$id = $agentCol[11];
		} else {
			$id = $count+1;
		}			
		$agentColActive[$id] = $agentCol[0];
		$agentColOrder[$id] = $agentCol[1];
		$agentColSort[$id] = $agentCol[2];
		$width = $agentCol[3];
		if(!is_numeric($width)) {
			$width = $agentCols[$id]['width'];
		}
		$label = trim(urldecode($agentCol[4]));
		if($label == "") {
			$label = $agentCols[$id]['label'];
		}
		$header = trim($agentCol[5]);
		if($header != "") {
			$agentColHeader = true;
		}
		$align = trim($agentCol[6]);
		if($align == "") {
			$align = $agentCols[$id]['align'];
		}
		$objType = trim($agentCol[7]);
		if($objType == "") {
			$objType = isset($agentCols[$id]['objType']) ? $agentCols[$id]['objType'] : "";
		}
		$pr_agent_id = trim($agentCol[8]);
		if($pr_agent_id == "") {
			$pr_agent_id = isset($agentCols[$id]['pr_agent_id']) ? $agentCols[$id]['pr_agent_id'] : "";
		}
		$split = trim($agentCol[9]);

		$sortable = isset($agentCols[$id]['sortable']) ? $agentCols[$id]['sortable'] : "";
		
		$agentColArray[$id] = array(
			"active"=>$agentCol[0],
			"order"=>$agentCol[1],
			"sort"=>$agentCol[2],
			"direction"=>isset($agentCol[10]) ? $agentCol[10] : "",
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"pr_agent_id"=>$pr_agent_id,
			"sortable"=>$sortable
		);

		$agentCols[$count]['active'] = $agentCol[0];
		$agentCols[$count]['order'] = $agentCol[1];
		$agentCols[$count]['sort'] = $agentCol[2];
		$agentCols[$count]['direction'] = isset($agentCol[10]) ? $agentCol[10] : "";
		$agentCols[$count]['width'] = $width;
		$agentCols[$count]['label'] = $label;
		$agentCols[$count]['header'] = $header;
		$agentCols[$count]['split'] = $split;
		$agentCols[$count]['align'] = $align;
		$agentCols[$count]['objType'] = $objType;
		$agentCols[$count]['pr_agent_id'] = $pr_agent_id;
		$agentCols[$count]['sortable'] = $sortable;
		$count++;
	}
}

asort($agentColOrder);
asort($agentColSort);
$agentColData = array();

foreach($agentCols as $colKey=>$agentColItem) {
	$width = $agentColItem['width'];
	$sort = "";
	$agentCol_direction = "";
	$label = $agentColItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = $agentColItem['align'];
	$objType = $agentColItem['objType'];
	$pr_agent_id = isset($agentColItem['pr_agent_id']) ? $agentColItem['pr_agent_id'] : "";
	$sortable = $agentColItem['sortable'];
	$id = $agentColItem['id'];

	if(isset($agentColArray[$id]['active']) && $agentColArray[$id]['active'] == "1") {
		$width = $agentColArray[$id]['width'];
		$sort = $agentColArray[$id]['sort'];
		$agentCol_direction = $agentColArray[$id]['direction'];		
		$label = $agentColArray[$id]['label'];
		$active = "1";
		$order = $agentColArray[$id]['order'];
		$split = $agentColArray[$id]['split'];
		$header = $agentColArray[$id]['header'];
		$align = $agentColArray[$id]['align'];
		$objType = $agentColArray[$id]['objType'];
		$pr_agent_id = $agentColArray[$id]['pr_agent_id'];
		$sortable = $agentColArray[$id]['sortable'];
	}
	
	$agentColDataItem = array(
		'"id":"'.$agentColItem['id'].'"',
		'"name":"'.$agentColItem['label'].'"',
		'"width":"'.$width.'"',
		'"sort":"'.$sort.'"',
		'"direction":"'.$agentCol_direction.'"',
		'"label":"'.$label.'"',
		'"active":"'.$active.'"',
		'"order":"'.$order.'"',
		'"header":"'.$header.'"',
		'"split":"'.$split.'"',
		'"align":"'.$align.'"',
		'"objType":"'.$objType.'"',
		'"pr_agent_id":"'.$pr_agent_id.'"',
		'"sortable":"'.$sortable.'"'
	);
	
	array_push($agentColData,'{'.join(",",$agentColDataItem)."}\n");
}

$agentColData = '['.join(",",$agentColData).']';
$GLOBALS['temp']['agentColData'] = $agentColData;

$sort_array = array();
$orderArr = array();
 foreach ($agentCols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $agentCols);

// ------------  End Agents

// ------------  Start Events

$eventCols = array();
$eventCols = array(
	array('id'=>'1' , 'label'=>'Event action', 'type'=>"string", 'fields'=>array("rc_action.rc_action_desc"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'2' , 'label'=>'Event tag', 'type'=>"string", 'fields'=>array("rc_tag.rc_tag_desc"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'3' , 'label'=>'Event', 'type'=>"string", 'fields'=>array("rc_event.rc_event_desc"), 'style'=>array('bold'=>"1"), 'width'=>"100", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'4' , 'label'=>'Internal rep', 'type'=>"string", 'fields'=>array(".int_rep_name_full"), 'style'=>array('bold'=>"1"), 'width'=>"150", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'5' , 'label'=>'Event date', 'type'=>"string", 'fields'=>array("pr_event.pr_event_date"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'6' , 'label'=>'Completed', 'type'=>"string", 'fields'=>array("pr_event.pr_event_completed_yn"), 'style'=>array('bold'=>"1"), 'width'=>"55", 'align'=>"c", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'7' , 'label'=>'Client rep', 'type'=>"string", 'fields'=>array(".client_rep_name_full"), 'style'=>array('bold'=>"1"), 'width'=>"150", 'align'=>"l", 'rc_obj_sales_ix'=>'', 'objType'=>''),
	array('id'=>'8', 'label'=>"Event note", 'type'=>"string", 'fields'=>array("pr_event.pr_event_note"), 'style'=>array('bold'=>"1"), 'width'=>"150", 'align'=>"l", 'rc_obj_sales_ix'=>"", 'objType'=>''),
	array('id'=>'9', 'label'=>"Duration", 'type'=>"string", 'fields'=>array("pr_event.pr_event_duration"), 'style'=>array('bold'=>"1"), 'width'=>"150", 'align'=>"l", 'rc_obj_sales_ix'=>"", 'objType'=>'')	
);
 
$eventColArg = $_SERVER['argv'][33];
$eventColArray = array();
$eventColOrder = array();
$eventColSort = array();
$eventColHeader = false;


if(trim($eventColArg) != "") {
	$count = 0;
	foreach(explode(":",$eventColArg) as $item) {
		$eventCol = explode(",",$item);
		$eventColActive[$count] = $eventCol[0];
		$eventColOrder[$count] = $eventCol[1];
		$eventColSort[$count] = $eventCol[2];
		$width = $eventCol[3];
		if(!is_numeric($width)) {
			$width = $eventCols[$count]['width'];
		}
		$label = trim(urldecode($eventCol[4]));
		if($label == "") {
			$label = $eventCols[$count]['label'];
		}
		$header = trim($eventCol[5]);
		if($header != "") {
			$eventColHeader = true;
		}
		$align = trim($eventCol[6]);
		if($align == "") {
			$align = $eventCols[$count]['align'];
		}
		$objType = trim($eventCol[7]);
		if($objType == "") {
			$objType = $eventCols[$count]['objType'];
		}
		$rc_obj_sales_ix = trim($eventCol[8]);
		if($rc_obj_sales_ix == "") {
			$rc_obj_sales_ix = $eventCols[$count]['rc_obj_sales_ix'];
		}
		$split = trim($eventCol[9]);
		$disable = isset($eventCol[10]) ? trim($eventCol[10]) : "";
		if($disable == "") {
			$disable = isset($eventCols[$count]['disable']) ? $eventCols[$count]['disable'] : "";
		}
		
		$eventColArray[$count] = array(
			"active"=>$eventCol[0],
			"order"=>$eventCol[1],
			"sort"=>$eventCol[2],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"disable"=>$disable,
			"rc_obj_sales_ix"=>$rc_obj_sales_ix
		);
		$eventCols[$count]['active'] = $eventCol[0];
		$eventCols[$count]['order'] = $eventCol[1];
		$eventCols[$count]['sort'] = $eventCol[2];
		$eventCols[$count]['width'] = $width;
		$eventCols[$count]['label'] = $label;
		$eventCols[$count]['header'] = $header;
		$eventCols[$count]['split'] = $split;
		$eventCols[$count]['align'] = $align;
		$eventCols[$count]['objType'] = $objType;
		$eventCols[$count]['disable'] = $disable;
		$eventCols[$count]['rc_obj_sales_ix'] = $rc_obj_sales_ix;
		$count++;
	}
}

asort($eventColOrder);
asort($eventColSort);
$eventColData = array();

foreach($eventCols as $colKey=>$eventColItem) {
	$width = $eventColItem['width'];
	$sort = "";
	$eventCol_direction = "";
	$label = $eventColItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = $eventColItem['align'];
	$objType = $eventColItem['objType'];
	$disable = isset($eventColItem['disable']) ? $eventColItem['disable'] : "";
	$rc_obj_sales_ix = $eventColItem['rc_obj_sales_ix'];

	if(isset($eventColArray[$colKey]['active']) && $eventColArray[$colKey]['active'] == "1") {
		$width = $eventColArray[$colKey]['width'];
		$sort = $eventColArray[$colKey]['sort'];
		$label = $eventColArray[$colKey]['label'];
		$active = "1";
		$order = $eventColArray[$colKey]['order'];
		$split = $eventColArray[$colKey]['split'];
		$header = $eventColArray[$colKey]['header'];
		$align = $eventColArray[$colKey]['align'];
		$objType = $eventColArray[$colKey]['objType'];
		$disable = $eventColArray[$colKey]['disable'];
		$rc_obj_sales_ix = $eventColArray[$colKey]['rc_obj_sales_ix'];
	}
	
	$eventColDataItem = array(
		'"id":"'.$eventColItem['id'].'"',
		'"name":"'.$eventColItem['label'].'"',
		'"width":"'.$width.'"',
		'"sort":"'.$sort.'"',
		'"label":"'.$label.'"',
		'"active":"'.$active.'"',
		'"order":"'.$order.'"',
		'"header":"'.$header.'"',
		'"split":"'.$split.'"',
		'"align":"'.$align.'"',
		'"objType":"'.$objType.'"',
		'"disable":"'.$disable.'"',
		'"rc_obj_sales_ix":"'.$rc_obj_sales_ix.'"'
	);
	
	array_push($eventColData,'{'.join(",",$eventColDataItem)."}\n");
}

$eventColData = '['.join(",",$eventColData).']';
$GLOBALS['temp']['eventColData'] = $eventColData;

$sort_array = array();
$orderArr = array();
 foreach ($eventCols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $eventCols);

$recentTrips = $_SERVER['argv'][36];
$GLOBALS['temp']['recentTrips'] = $recentTrips;

$page = "1";
if ($_SERVER['argv'][34] > "1") {
	$page = $_SERVER['argv'][34];
}

$GLOBALS['temp']['pgNum'] = (string) $page;

$options = $_SERVER['argv'][35];

global $renderMode;
switch ( $options) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_CSV:
	$renderMode = "csv";
	$renderType = "email";
	break;
case REP_SEND_CSV:
	$renderMode = "csv";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "view";
	break;
case REP_VIEW_OO:
	$renderMode = "oofice";
	$renderType = "view";
	break;
case REP_EMAIL_CONTACT:
	$renderMode = "email";
	$renderType = "emailToContact";
	break;
case REP_EMAIL_CONTACT_SEND:
    $renderMode = "email";
    $renderType = "emailToContactSend";
    break;
case REP_VIEW_CSV_FROM_XML:
    $renderMode = "csvFromXml";
    $renderType = "view";
    break;
}

if ( $renderMode == "email" && $renderType == "emailToContact" ) {
	$contactList = $_SERVER['argv'][37];
	$contactList = explode("-", $contactList);
	$recipients = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
	";
	$i = 0;
	foreach($contactList as $agent) {
		if($agent != '') {
			$i+= 1;
			$agentDetails = $lDB->get("
				SELECT
					pr_persona.pr_persona_ix,
					pr_persona.pr_name_last,
					pr_persona.pr_email
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$agent'
			",1);
			$recipients .= "
				<tr valign=\"top\">
					<td width=\"46%\">".$agentDetails['pr_name_last']."</td>
					<td width=\"8%\" align=\"center\"><input onclick=\"contact_popup(1, 'mail_to$i')\" type=\"button\" class=\"button bSearch\" id=\"toSearchButton\" value=\"\"/></td>
					<td \"46%%\">
			";
			if($agentDetails['pr_email'] != '') {
				$recipients .= "
					<input type=\"text\" name=\"mail_to\" id=\"mail_to$i\" class=\"txts\" size=\"40\" value=\"$agentDetails[pr_email]\" style=\"width: 180px;\"/>
				";
			} else {
				$recipients .= "
					<input type=\"text\" name=\"mail_to\" id=\"mail_to$i\" class=\"txts\" size=\"40\" value=\"!emailTo!\" style=\"width: 180px;\" />
				";
			}
			$recipients .= "
						<input type=\"hidden\" id=\"agentId$i\" value=\"$agentDetails[pr_persona_ix]\">
					</td>
				</tr>
			";
		}
	}

	$recipients .= "
		</table>
		<input type=\"hidden\" id=\"noOfAgents\" value='".$i."'>
	";

	$pdfName = "email";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = 7;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,35))."+$newOptions+".join("+",array_slice($_SERVER['argv'],36,1));
	
	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","collapse",
								str_replace("!emailBody!","",
								str_replace("!recipients!",$recipients,
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_agents_popup.htm")))))))));
	
	// Get principal -------------------------------------------------------------
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
  
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);

	$GLOBALS['temp']['emailTo'] = "";
}

if($renderMode == "email" && $renderType == "emailToContactSend") {
	//getHeader data   add on 30 jan 08
	$principal_id = $_SESSION['principal_id'];
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$resOfficeInfo = getPersonaDetail($resOfficeId);
	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$logoFilename = "top_clientlogo.jpg";

	if(isset($resOfficeInfo['telephone']) && ($resOfficeInfo['telephone'] != '')) {
		$addressee.= "Telephone: " . $resOfficeInfo['telephone'] . "\n";
	}

	if(isset($resOfficeInfo['fax']) && ($resOfficeInfo['fax']!='')) {
		$addressee.= "Fax: " . $resOfficeInfo['fax'] . "\n";
	}
	if(isset($resOfficeInfo['email']) && ($resOfficeInfo['email'] != '')) {
		$addressee.= "Email: " . $resOfficeInfo['email'] . "\n";
	}
	if($addresseeURL != "") {
		$addressee.= "URL:".getContactURL($resOfficeId)."\n";;
	}
	
	$addressee.= "Res-URL: " . $_SESSION['principal_name_short'] . ".resrequest.com\n";
	$agent = false;
	$confirmList = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
	";
	$tempAgent = $_POST['agentIds'];
	
	$tempAgentId = explode(":", $tempAgent);
	
	foreach($tempAgentId as $tmpAgent2) {
		$tmpList = explode("~", $tmpAgent2);
		
		if($tmpList[0]!='') {
			$agentList2[$tmpList[0]] = $tmpList[1];
		}
	}
	$counter = 1;
	$oldnames=array();
	
	foreach($agentList2 as $agentOne=>$agentEmail) {
		if($agentOne!='') {
			$agentDetails = $lDB->get("
				SELECT
					pr_persona.pr_persona_ix,
					pr_persona.pr_email,
					pr_persona.pr_name_last,pr_web_addr 
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$agentOne'
			",1);
		}

		$agentPersonalDetails = getPersonaDetail($agentOne);
		$agentPersonalContDetails = getContactCorrAddress($agentOne);

		$regInfo = "";

		$oldprnames = array();
		if(!in_array($item['pr_name_last'],$oldnames)) {
			array_push($oldnames,$item['pr_name_last']);
			$confirmList .= "
				<tr valign=\"top\">
					<td width=\"42%\">".$item['pr_name_last']."</td>
					<td \"42%%\"><input type=\"text\" name=\"mail_to\" id=\"mail_to\" class=\"txts\" size=\"40\" value=".$agentEmail." style=\"width: 150px;\" readonly />
					<td width=\"16%\" align=\"center\">
			";
		}
		

		$userId = $_SESSION['userid'];

		$GLOBALS['temp']['emailFrom'] = $lDB->get("
			SELECT
				pr_persona.pr_email
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$userId'
		",4);
		
		$to = $agentEmail;
		$from = $GLOBALS['temp']['emailFrom'];
		$subject = $_POST['mail_subj'];
		$message = $_POST['mail_body'];
		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
		
		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName']);     // (from, to, subject, headers, message, action, emailID, resID)
			
		if(!$error) {
			$confirmList.= "Sent";
		} else {
			$confirmList.= "<a href='#' onclick=\"openMessage('Message send to  ".$to." failed due to error.')\">Failed</a>";
		}
		$confirmList.= "</td></tr>";
	}

	$confirmList.= "</table>";
	
	$GLOBALS[$form]->FormHTML =
		str_replace("!recipients!",$confirmList, Join("", file(__DIR__ . "/../../../public/html/rep_crm_email_confirm_popup.htm")));
}	

$customProfileIds = explode('_', $_SERVER['argv'][20]);
$personaIdsCustom = array();
$salesCustomflag = 0;
$profileObjIds = array();
if(is_array($customProfileIds)) {
	foreach($customProfileIds as $proIds) {
		$prodata = explode("-", $proIds);
		$obj_ind =  $lDB->get("SELECT rc_obj_sales_type_ind FROM rc_obj_sales WHERE rc_obj_sales_ix='$prodata[0]'", "4");
		$profileObjIds[] = $prodata[0];
		
		switch($obj_ind) {
		case '1':
		case '6':
			$GLOBALS['temp']['sales_'.$prodata[0].'Names'] = str_replace(":", ",", $prodata[1]);
			$prodata[1] = str_replace("*", "%", $prodata[1]);
			$field = "pr_sales_obj_data_text LIKE '$prodata[1]'";
			break;
		case '2':
			$GLOBALS['temp']['sales_'.$prodata[0].'Names'] = str_replace(":", ",", $prodata[1]);
			$prodata[1] = str_replace("*", "%", $prodata[1]);
			$field = "pr_sales_obj_data_memo LIKE '$prodata[1]'";
			break;
		case '3':
		case '4':
		case '5':
			if($prodata[1] == '') {
				$GLOBALS['temp']['sales_'.$prodata[0].'Names'] = "All";
				$GLOBALS['temp']['sales_'.$prodata[0].'Ids'] = "<input type=\"hidden\" name='sales_profile[]' id='sales_'".$prodata[0]."Ids' value=''>";
			} else {
				$dataIdArr = explode(":", $prodata[1]);
				$field = "rc_obj_sales_data_id IN ('".join("','",$dataIdArr)."')";
				
				$names = $lDB->get("
					SELECT 
						rc_obj_sales_data_content
					FROM
						rc_obj_sales_data
					WHERE
						rc_obj_sales_data_ix IN ('".join("','",$dataIdArr)."')
				", 3);

				if(in_array(0, $dataIdArr)) {
					array_push($names, "None");
				}
				
				if(is_array($names) && !empty($names)) {
					$namesList = implode(",", $names);
				} else {
					$namesList = "All";
				}
				
				$GLOBALS['temp']['sales_'.$prodata[0].'Names'] = $namesList;
				$GLOBALS['temp']['sales_'.$prodata[0].'Ids'] = "<input type=\"hidden\" name='sales_profile[]' id='sales_".$prodata[0]."Ids' value='".$prodata[1]."'>";
			}
			break;
		
		case '8': 
			if($prodata[0] == "RS1") {
				if($prodata[1] == "") {
					$GLOBALS['temp']['eventOriginNames'] = "All";
					$GLOBALS['temp']['eventOriginIds'] = "<input type=\"hidden\" name='eventOriginIds' id='eventOriginIds' value=''>";
				} else {
					$dataIdArr = explode(":", $prodata[1]);
					$field = "rc_obj_sales_data_id IN ('".join("','",$dataIdArr)."')";
					$names = $lDB->get(" SELECT rc_event_desc FROM rc_event WHERE
							rc_event_ix IN ('".join("','",$dataIdArr)."') ", 3);
					
					if(in_array(0, $dataIdArr)) {
						array_push($names, "No Event");
					}
					$namesList = "All";
					if(is_array($names) && !empty($names)) {
						$namesList = implode(",", $names);
					} 
					
					$GLOBALS['temp']['eventOriginNames'] = $namesList;
					$GLOBALS['temp']['eventOriginIds'] = "<input type=\"hidden\" name='eventOriginIds' id='eventOriginIds' value='".$prodata[1]."'>";
				}
			}
			if($prodata[0] == "RS2") {
				if($prodata[1] == "") {
					$GLOBALS['temp']['internalRepSalesNames'] = "All";
					$GLOBALS['temp']['internalRepSalesIds'] = "<input type=\"hidden\" name='internalRepSalesIds' id='internalRepSalesIds' value=''>";
				} else {
					$dataIdArr = explode(":", $prodata[1]);
					$field = "rc_obj_sales_data_id IN ('".join("','",$dataIdArr)."')";
					$names = $lDB->get(" SELECT pr_name_last FROM pr_persona WHERE
							pr_persona_ix IN ('".join("','",$dataIdArr)."') ", 3);

					if(in_array(0, $dataIdArr)) {
						array_push($names, "No Contact");
					}
					
					$namesList = "All";
					if(is_array($names) && !empty($names)) {
						$namesList = implode(",", $names);
					} 
					
					$GLOBALS['temp']['internalRepSalesNames'] = $namesList;
					$GLOBALS['temp']['internalRepSalesIds'] = "<input type=\"hidden\" name='internalRepSalesIds' id='internalRepSalesIds' value='".$prodata[1]."'>";
				}
			}
			if($prodata[0] == "RS3") {
				if($prodata[1] == "") {
					$GLOBALS['temp']['propertiesExtraNames'] = "All";
					$GLOBALS['temp']['propertiesExtraIds'] = "<input type=\"hidden\" name='propertiesExtraIds' id='propertiesExtraIds' value=''>";
				} else {
					$dataIdArr = explode(":", $prodata[1]);
					$field = "rc_obj_sales_data_id IN ('".join("','",$dataIdArr)."')";
					$names = $lDB->get(" SELECT pr_name_last FROM pr_persona WHERE
							pr_persona_ix IN ('".join("','",$dataIdArr)."') ", 3);
					
					if(in_array(0, $dataIdArr)) {
						array_push($names, "Not property specific");
					}
					
					$namesList = "All";
					if(is_array($names) && !empty($names)) {
						$namesList = implode(",", $names);
					} 
					
					$GLOBALS['temp']['propertiesExtraNames'] = $namesList;
					$GLOBALS['temp']['propertiesExtraIds'] = "<input type=\"hidden\" name='propertiesExtraIds' id='propertiesExtraIds' value='".$prodata[1]."'>";
				}
			}
			
		}


		if(is_array($prodata) && isset($prodata[1]) && $prodata[1]!='') {
			$salesCustomflag=1;
			$personaIds = $lDB->get("SELECT pr_persona_id FROM pr_sales_obj_data WHERE rc_obj_sales_id='$prodata[0]' AND $field", 3);
			$personaIds = isset($personaIds) ? $personaIds : array();
			if(is_array($personaIds) && !empty($personaIds)) {
				if(!empty($personaIdsCustom)) {
					$personaIdsCustom = array_intersect($personaIdsCustom, $personaIds);
				} else {
					foreach($personaIds as $id) {
						$personaIdsCustom[] = $id;
					}
				}
			}
		}
	}
			
	if(is_array($profile_custom)) {
		foreach ($profile_custom as $proCust) {
			if(!in_array($proCust['rc_obj_sales_ix'], $profileObjIds)) {
				if($proCust['rc_obj_sales_type_ind'] == 8) {
					if($proCust['rc_obj_sales_ix'] == "RS1") {
						$GLOBALS['temp']['eventOriginNames'] = "All";
						$GLOBALS['temp']['eventOriginIds'] = "<input type=\"hidden\" name='eventOriginIds' id='eventOriginIds' value=''>";
					}
					if($proCust['rc_obj_sales_ix'] == "RS2") {
						$GLOBALS['temp']['internalRepSalesNames'] = "All";
						$GLOBALS['temp']['internalRepSalesIds'] = "<input type=\"hidden\" name='internalRepSalesIds' id='internalRepSalesIds' value=''>";
					}
					if($proCust['rc_obj_sales_ix'] == "RS3") {
						$GLOBALS['temp']['propertiesExtraNames'] = "All";
						$GLOBALS['temp']['propertiesExtraIds'] = "<input type=\"hidden\" name='propertiesExtraIds' id='propertiesExtraIds' value=''>";
					}

				} else {
					$GLOBALS['temp']['sales_'.$proCust['rc_obj_sales_ix'].'Names'] = "";
					$GLOBALS['temp']['sales_'.$proCust['rc_obj_sales_ix'].'Ids'] = "<input type=\"hidden\" name='sales_profile[]' id='sales_".$proCust['rc_obj_sales_ix']."Ids' value=''>";
				}
			}
		}
	}
}


if ( $renderMode == "csv" && $renderType == "email" ) {
	outputMail($form,$options,$fromDate['htmlDate'],$toDate['htmlDate']);
}

if($renderMode == "html") {
	$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");
	$GLOBALS['temp']['showResults'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "";
}

if($_SERVER['argc'] > 1) {
	$sql = "SELECT pr_persona.pr_persona_ix FROM pr_persona";
	if(isset($telephone) && $telephone != '') {
		$sql .=" INNER JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix";
	}
	if($guestPostCountryFilter['where'] || $guestPhysCountryFilter['where']) {
		$sql .=" INNER JOIN pr_persona as agent_persona ON agent_persona.pr_persona_ix = pr_persona.pr_persona_ix";
	}

	if($show == "agents") {
		$sql .= "
			INNER JOIN pr_agent AS agent_filter ON agent_filter.pr_agent_id = pr_persona.pr_persona_ix
		";
	}

	if($show == "agentContacts") {
		$sql .= "
				INNER JOIN pr_link ON pr_link.pr_link_from = pr_persona.pr_persona_ix
				INNER JOIN pr_persona As agentpersonas ON agentpersonas.pr_persona_ix = pr_link.pr_link_to		
		";
	}

	if ($inactiveContact == '0' && $contactRoleGuest) {
		$sql .=" LEFT JOIN pr_guest roleguest ON roleguest.pr_guest_id = pr_persona.pr_persona_ix";
	}

	if ($inactiveContact == '0' && $contactRoleUser) {
		$sql .=" LEFT JOIN pr_user roleuser ON roleuser.pr_user_id = pr_persona.pr_persona_ix";
	}

	if ($inactiveContact == '0' && $contactRoleAgent) {
		$sql .=" LEFT JOIN pr_agent roleagent ON roleagent.pr_agent_id = pr_persona.pr_persona_ix";
	}

	$sql .=" WHERE 1=1";

	if ($show == "agentContacts"){
		$sql .= "
			AND pr_link.rf_link_type_id = 'RS2' 
		";
	}

	if($show == "agents" || $show == "agentContacts") {
		
		if($agentSelect == "country") {
			$sql .= $agentCountryFilter['where'];
		} else {
			$sql .= $agentFilter['where'];
		}
	}	
	
	
	if($contact_type != "") {
		if($contact_type == "1") {
			$sql .=" AND pr_persona.pr_org_yn = '0'";
		} else {
			$sql .=" AND pr_persona.pr_org_yn = '1'";
		}
	}
	$sql .= $contactNameFilter['where'];

	if(isset($cont_name) && $cont_name != "") {
		$sql .=" AND (pr_persona.pr_name_first LIKE '$cont_name' OR pr_persona.pr_name_last LIKE '$cont_name')";
	}
				
	if(isset($email) && $email != '') {
		$sql .=" AND pr_persona.pr_email LIKE '$email'";
	}
	if(isset($telephone) && $telephone != '') {
		$sql .=" AND pr_phone.pr_phone_number LIKE '$telephone'";
	}

	// If Address Search type is set to ONLY, use the standard where clauses, otherwise build up our own
	if ($addressSearchType == 0) {

		if($postSub != '') {
			$sql .=" AND pr_persona.pr_corr_city LIKE '$postSub'";
		}
		if($physSub != '') {
			$sql .=" AND pr_persona.pr_phys_city LIKE '$physSub'";
		}

		$sql .= $guestPostCountryFilter['where'];
		$sql .= $guestPhysCountryFilter['where'];		

		if($postZip != '') {
			$sql .=" AND pr_persona.pr_corr_post_code LIKE '$postZip'";
		}
		if($physZip != '') {
			$sql .=" AND pr_persona.pr_phys_post_code LIKE '$physZip'";
		}

	} else {

		$address_criteria = array();

		if($postSub != '') {
			$address_criteria[] = "pr_persona.pr_corr_city LIKE '$postSub'";
		}
		if($physSub != '') {
			$address_criteria[] = "pr_persona.pr_phys_city LIKE '$physSub'";
		}

		if ($guestPostCountryFilter['ids'] != ""){
			$postCountryIds = explode(":", $guestPostCountryFilter['ids']);
			$address_criteria[] = "agent_persona.pr_corr_country_id IN ('".join("','", $postCountryIds)."')";
		}
		if ($guestPhysCountryFilter['ids'] != ""){
			$physCountryIds = explode(":", $guestPhysCountryFilter['ids']);
			$address_criteria[] = "agent_persona.pr_phys_country_id IN ('".join("','", $physCountryIds)."')";
		}		

		if($postZip != '') {
			$address_criteria[] = "pr_persona.pr_corr_post_code LIKE '$postZip'";
		}
		if($physZip != '') {
			$address_criteria[] = "pr_persona.pr_phys_post_code LIKE '$physZip'";
		}


		if (!empty($address_criteria)){
			$sql .= "
				AND
					(
			";

			$sql .= join(" OR ", $address_criteria);

			$sql .= "

					)
			";			
		}



	}


	if($inactiveContact == '0') {
		if ($contactRoleGuest) {
			$sql .=" AND (roleguest.pr_guest_inactive_yn = 0 OR roleguest.pr_guest_inactive_yn IS NULL)";
		}
		if ($contactRoleUser) {
			$sql .=" AND (roleuser.pr_user_inactive_yn = 0 OR roleuser.pr_user_inactive_yn IS NULL)";
		}
		if ($contactRoleAgent) {
			$sql .=" AND (roleagent.pr_agent_inactive_yn = 0 OR roleagent.pr_agent_inactive_yn IS NULL)";
		}
		if ($contactRoleGeneral) {
			$sql .=" AND pr_persona.pr_persona_inactive_yn = '$inactiveContact'";
		}		
	}

	if($birthDateType !='') {
		$dateArrFrom = explode("-",$birthFromDate['jsDate']);
		if($dateArrFrom[0] == "") {
			$dateArrFrom[0] = date("Y");
		}
		$birthFromDate['jsDate'] = $dateArrFrom[0]."-".$dateArrFrom[1]."-".$dateArrFrom[2];
		
		$dateArr = explode("-",$birthToDate['jsDate']);
		if($dateArr[0] == "") {
			$dateArr[0] = date("Y");
		}
		$birthToDate['jsDate'] = $dateArr[0]."-".$dateArr[1]."-".$dateArr[2];

		if($dateArrFrom[0] == date("Y") || $dateArr[0] == date("Y")) {
			$sql .= " AND date_format( pr_persona.pr_birthdate, '%m-%d' ) BETWEEN date_format( '".$birthFromDate['jsDate']."', '%m-%d' ) AND date_format( '".$birthToDate['jsDate']."', '%m-%d' )";
		} else {
			$sql .= " AND date_format( pr_persona.pr_birthdate, '%m-%d' ) BETWEEN date_format( '".$birthFromDate['jsDate']."', '%m-%d' ) AND date_format( '".$birthToDate['jsDate']."', '%m-%d' ) AND date_format( pr_persona.pr_birthdate, '%Y' ) BETWEEN '".$dateArrFrom[0]."' AND '".$dateArr[0]."'";
		}
	}
	
	if($annDateType !='') {
		$dateArrFrom = explode("-",$annFromDate['jsDate']);
		if($dateArrFrom[0] == "") {
			$dateArrFrom[0] = date("Y");
		}
		$annFromDate['jsDate'] = $dateArrFrom[0]."-".$dateArrFrom[1]."-".$dateArrFrom[2];

		$dateArr = explode("-",$annToDate['jsDate']);
		if($dateArr[0] == "") {
			$dateArr[0] = date("Y");
		}
		$annToDate['jsDate'] = $dateArr[0]."-".$dateArr[1]."-".$dateArr[2];

		if($dateArrFrom[0] == date("Y") || $dateArr[0] == date("Y")) {
			$sql .= " AND date_format( pr_persona.pr_anniversary, '%m-%d' ) BETWEEN date_format(' ".$annFromDate['jsDate']."', '%m-%d' ) AND date_format( '".$annToDate['jsDate']."', '%m-%d' )";
		} else {
			$sql .= " AND pr_persona.pr_anniversary BETWEEN ' ".$annFromDate['jsDate']."' AND '".$annToDate['jsDate']."' AND date_format( pr_persona.pr_anniversary, '%Y' ) BETWEEN '".$dateArrFrom[0]."' AND '".$dateArr[0]."'";
		}
	}

	$persona_contactIds_all = $lDB->get($sql, "3");
	if($_SERVER['argv'][1] != "") {
		$roleIds = explode(":", $_SERVER['argv'][1]);
		$agentIds = array();
		$userIds = array();
		$guestIds = array();
		$generalIds = array();
		if(in_array("RS2", $roleIds)) {
			$guestIds = $lDB->get("SELECT pr_guest_id FROM pr_guest WHERE pr_guest_id IN ('".join("','",$persona_contactIds_all)."') ", "3");
		}
		if(in_array("RS3", $roleIds)) {
			$userIds = $lDB->get("SELECT pr_user_id FROM pr_user WHERE pr_user_id IN ('".join("','",$persona_contactIds_all)."') ", "3");
		}
		if(in_array("RS4", $roleIds)) {
			$agentIds = $lDB->get("SELECT pr_agent_id FROM pr_agent WHERE pr_agent_id IN ('".join("','",$persona_contactIds_all)."') ", "3");
		}

		if(in_array("RS1", $roleIds)) {
			$generalIds = $lDB->get("
				SELECT DISTINCT
					pr_persona.pr_persona_ix
				FROM
					pr_persona
					LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix 
					LEFT JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix 
					LEFT JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix 
				WHERE
					pr_persona.pr_persona_inactive_yn = '0'
					AND pr_guest.pr_guest_id IS NULL
					AND pr_user.pr_user_id IS NULL
					AND pr_agent.pr_agent_id IS NULL
					AND pr_persona.pr_persona_ix IN ('".join("','",$persona_contactIds_all)."')
			","3");
		}
		$persona_contactIds = array_unique(array_merge($agentIds, $userIds, $guestIds, $generalIds));
	} else {
		$persona_contactIds = $persona_contactIds_all;
	}
	
	if($salesCustomflag == 1) {
		$filterPersonaIdsArr =  array_intersect($persona_contactIds, $personaIdsCustom);
	} else {
		$filterPersonaIdsArr = $persona_contactIds;
	}

	$profileSQL = isset($profileSQL) ? $profileSQL : "";
	if($_SERVER['argv'][21]!="" || $_SERVER['argv'][22]!="" || $_SERVER['argv'][23]!="" || $_SERVER['argv'][24]!="" || $_SERVER['argv'][25]!="" || $_SERVER['argv'][26]!="" || $_SERVER['argv'][27]!="" || $_SERVER['argv'][28]!="" || $_SERVER['argv'][29]!="" || $_SERVER['argv'][30]!="") {
		if($_SERVER['argv'][21] == '1') {
			$profileSQL = "
				SELECT 
					pr_event_persona.pr_persona_id 
				FROM 
					pr_event_persona 
					INNER JOIN pr_event ON pr_event.pr_event_ix = pr_event_persona.pr_event_id
				WHERE 
					pr_event_persona.pr_event_rep_ind = '0' 
					AND pr_event_persona.pr_persona_id IN ('".join("','",$filterPersonaIdsArr)."') 
					AND pr_event.pr_event_inactive_yn = 0
			";
			$personaEventIds = $lDB->get($profileSQL, "3");
			$filterPersonaIdsArr =  array_diff($filterPersonaIdsArr, $personaEventIds);
		} else {
			$profileSQL .= "
				SELECT 
					a.pr_persona_id
			";
			$profileFromSQL = " 
				FROM 
					pr_persona
					INNER JOIN pr_event_persona a ON pr_persona.pr_persona_ix = a.pr_persona_id
					INNER JOIN pr_event ON a.pr_event_id = pr_event.pr_event_ix
					LEFT JOIN rc_event_tag ON rc_event_tag.rc_event_id = pr_event.rc_event_id
			";
			$profileWhereSQL = "
				WHERE 
					a.pr_event_rep_ind = '0'
			";
			if(isset($cont_name) && $cont_name != "") {
				$profileWhereSQL .=" AND (pr_persona.pr_name_first LIKE '$cont_name' OR pr_persona.pr_name_last LIKE '$cont_name')";
			}
			if(isset($email) && $email != '') {
				$profileWhereSQL .=" AND pr_persona.pr_email LIKE '$email'";
			}
			if(isset($telephone) && $telephone != '') {
				$profileWhereSQL .=" AND pr_phone.pr_phone_number LIKE '$telephone'";
			}
			if(isset($postSub) && $postSub != '') {
				$profileWhereSQL .=" AND pr_persona.pr_corr_city LIKE '$postSub'";
			}
			if(isset($physSub) && $physSub != '') {
				$profileWhereSQL .=" AND pr_persona.pr_phys_city LIKE '$physSub'";
			}
			if(isset($postZip) && $postZip != '') {
				$profileWhereSQL .=" AND pr_persona.pr_corr_post_code LIKE '$postZip'";
			}
			if(isset($physZip) && $physZip != '') {
				$profileWhereSQL .=" AND pr_persona.pr_phys_post_code LIKE '$physZip'";
			}
			if(!isset($inactiveContact) || $inactiveContact == '0') {
				$profileWhereSQL .=" AND pr_persona.pr_persona_inactive_yn = '$inactiveContact'";
			}			
			$profileWhereSQL .= $salesWhere;
			$profileWhereSQL .= $eventActionFilter['where'];
			$profileWhereSQL .= $eventTagFilter['where'];
			$profileWhereSQL .= $eventFilter['where'];
			if ($internalRepFilter['ids'] == "0"){
				$profileFromSQL .= " 
					LEFT JOIN pr_event_persona intRep ON a.pr_event_id = intRep.pr_event_id AND intRep.pr_event_rep_ind = '1' 
				";				
				$profileWhereSQL .= " 
					AND intRep.pr_persona_id IS NULL
				";
			} elseif ($internalRepFilter['ids'] != "") {
				$profileFromSQL .= " 
					LEFT JOIN pr_event_persona intRep ON a.pr_event_id = intRep.pr_event_id AND intRep.pr_event_rep_ind = '1' 
				";			
				$profileWhereSQL .= "
					AND intRep.pr_persona_id IN ('".join("','", explode(":", $internalRepFilter['ids']))."')
				";
			}
			if ($clientRepFilter['ids'] == "0"){
				$profileFromSQL .= " 
					LEFT JOIN pr_event_persona clientRep ON a.pr_event_id = clientRep.pr_event_id AND clientRep.pr_event_rep_ind = '2' 
				";				
				$profileWhereSQL .= " 
					AND clientRep.pr_persona_id IS NULL
				";
			} elseif ($clientRepFilter['ids'] != "") {
				$profileFromSQL .= " 
					LEFT JOIN pr_event_persona clientRep ON a.pr_event_id = clientRep.pr_event_id AND clientRep.pr_event_rep_ind = '2' 
				";			
				$profileWhereSQL .= "
					AND clientRep.pr_persona_id IN ('".join("','", explode(":", $clientRepFilter['ids']))."')
				";
			}			
			$profileWhereSQL .= $eventCompletedSQL;

			$personaEventIds = $lDB->get($profileSQL.$profileFromSQL.$profileWhereSQL, "3");
			$personaEventIds = isset($personaEventIds) && is_array($personaEventIds) ? $personaEventIds : array();
			$filterPersonaIdsArr =  array_intersect($filterPersonaIdsArr, $personaEventIds);
		}
		
	}

	// Further filter based on travel date
	if ($travelDateType != "" || !$accommFilter['all']){
		$travelSQL = "
			SELECT 
				pr_guest_id
			FROM
				rv_res_item_guest
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_guest.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id 
			WHERE 1 
			$travelWhere
			$accommFilter[where]
		";

		$travelGuestIds = $lDB->get($travelSQL, "3");
		$travelGuestIds = isset($travelGuestIds) ? $travelGuestIds : array();
		$filterPersonaIdsArr =  array_intersect($filterPersonaIdsArr, $travelGuestIds);
	}	

    if($contactCreatedDateType !='') {
        $contactCreatedSQL = "
            SELECT
                ad_persona.pr_persona_id,
                ad_persona.ad_persona_time
            FROM
                ad_persona
            WHERE
                ad_persona.pr_persona_id IN ('".join("','",$filterPersonaIdsArr)."')
                AND ad_persona.ad_persona_time BETWEEN '".$contactCreatedFromDate['jsDate']." 00:00:01' AND '".$contactCreatedToDate['jsDate']." 23:59:59'
                AND ad_persona.ad_persona_form LIKE ('%Contact details (Add)%')
            GROUP BY
                ad_persona.pr_persona_id
        ";
        $contactCreatedSQLArr = $lDB->get($contactCreatedSQL, "2");

		$contactCreatedSQLArrFinal = array();

		foreach ($contactCreatedSQLArr as $persona) {
			$earliestAuditEntrySql = "
				SELECT
					ad_persona.ad_persona_time
				FROM
					ad_persona
				WHERE
					ad_persona.pr_persona_id = '" . $persona['pr_persona_id'] . "'
				ORDER BY
					ad_persona.ad_persona_time ASC
				LIMIT 1
			";
			$earliestAuditEntry = $lDB->get($earliestAuditEntrySql, "4");
			if ($persona['ad_persona_time'] == $earliestAuditEntry) {
				$contactCreatedSQLArrFinal[] = $persona['pr_persona_id'];
			}
		}
        $filterPersonaIdsArr = array_intersect($filterPersonaIdsArr, $contactCreatedSQLArrFinal);
    }

    if($emailEditedDateType !='') {
        $emailEditedSQL = "
            SELECT
                ad_persona.pr_persona_id,
                ad_persona.ad_persona_time
            FROM
                ad_persona
                LEFT JOIN ad_persona_detail ON ad_persona_detail.ad_persona_id = ad_persona.ad_persona_ix
            WHERE
                ad_persona.pr_persona_id IN ('".join("','",$filterPersonaIdsArr)."')
                AND ad_persona.ad_persona_time BETWEEN '".$emailEditedFromDate['jsDate']." 00:00:01' AND '".$emailEditedToDate['jsDate']." 23:59:59'
                AND ad_persona_detail.ad_module_field_id = '85'     /* email */
            GROUP BY
                ad_persona.pr_persona_id
        ";
        $emailEditedSQLArr = $lDB->get($emailEditedSQL, "3");
        $filterPersonaIdsArr =  array_intersect($filterPersonaIdsArr, $emailEditedSQLArr);
    }
		
	$contactData = array();
	$salesData = array();
	if(!empty($filterPersonaIdsArr)) {
		
		$guestSQL = "
			SELECT
				pr_persona.pr_persona_ix,
				pr_persona.pr_org_yn,
				pr_persona.pr_name_first, 
				pr_persona.pr_name_last, 
				pr_persona.pr_birthdate, 
				pr_persona.pr_anniversary,
				pr_persona.pr_email,
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3,
				fwd_persona.pr_name_first as fwd_name_first, 
				fwd_persona.pr_name_last as fwd_name_last, 
				pr_persona.pr_persona_link_id,
				pr_persona.pr_corr_addr_line1,
				pr_persona.pr_corr_addr_line2,
				pr_persona.pr_corr_addr_line3,
				pr_persona.pr_corr_country_id,
				pr_persona.pr_corr_post_code,
				pr_persona.pr_corr_city,
				pr_persona.pr_phys_addr_line1,
				pr_persona.pr_phys_addr_line2,
				pr_persona.pr_phys_addr_line3,
				pr_persona.pr_phys_post_code,
				pr_persona.pr_phys_city,
				pr_persona.pr_identity_no,
				pr_persona.pr_persona_inactive_yn,
				pr_persona.pr_web_addr,
				pr_corr_country.rf_country_name as pr_corr_country_name,
				pr_phys_country.rf_country_name as pr_phys_country_name,
				rf_title.rf_title_desc,
				rf_comms_preference.rf_comms_desc,
				pr_agent.pr_agent_id, 
				pr_agent.pr_agent_account, 
				pr_agent.pr_agent_alloc_auto_yn, 
				pr_agent.pr_agent_alloc_ext_yn, 
				pr_agent.pr_agent_commission_perc, 
				pr_agent.pr_agent_comm_deduct_yn, 
				pr_agent.pr_agent_note_conf, 
				pr_agent.pr_agent_note_open, 
				pr_agent.pr_agent_show_allocs_ind, 
				pr_agent.ac_pay_plan_id, 
				pr_agent.ac_pay_final_base, 
				pr_agent.ac_pay_final_days, 
				pr_agent.rt_rate_type_id,
				agent_persona.pr_name_first AS agent_relationship_first, 
				agent_persona.pr_name_last AS agent_relationship_last,
				pr_link.pr_link_to,
				pr_persona.pr_name_first AS agent_name_first, 
				pr_persona.pr_name_last AS agent_name_last
		";

		if ($show == "agentContacts") {
			$guestSQL .= "
			";
		} else {
			$guestSQL .= "
			";	
		}

		$guestSQL .= "
			FROM
				pr_persona
				LEFT JOIN rf_country as pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
				LEFT JOIN rf_country as pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
				LEFT JOIN pr_persona as fwd_persona ON pr_persona.pr_persona_fwd_id = fwd_persona.pr_persona_ix
				LEFT JOIN rf_title ON pr_persona.pr_title_id = rf_title.rf_title_ix
				LEFT JOIN rf_comms_preference ON pr_persona.rf_comms_preference_id = rf_comms_preference.rf_comms_preference_ix
		";
		if ($show == "agentContacts") {
			$guestSQL .= "
				INNER JOIN pr_link ON pr_link.pr_link_from = pr_persona.pr_persona_ix AND pr_link.rf_link_type_id = 'RS2'
				INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_link.pr_link_to
				INNER JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = pr_agent.pr_agent_id
			";
		} else {
			$guestSQL .= "
				LEFT JOIN pr_link ON pr_link.pr_link_from = pr_persona.pr_persona_ix AND pr_link.rf_link_type_id = 'RS2'
				LEFT JOIN pr_agent agent_relationshipt ON agent_relationshipt.pr_agent_id = pr_link.pr_link_to
				LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = agent_relationshipt.pr_agent_id
				LEFT JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
			";			
		}
		$guestSQL .= "
			WHERE
				 pr_persona.pr_persona_ix IN ('".join("','",$filterPersonaIdsArr)."')
		";
		
		// Combine the col, agenCol and sales arrays for sorting
		foreach ($colSort as $key => $item){
			$allSort['c_'.$key] = $item;
		}
		foreach ($agentColSort as $key => $item){
			$allSort['a_'.$key] = $item;
		}
        foreach ($salesColSort as $key => $item){
            $allSort['s_'.$key] = $item;
        }

		asort($allSort);

		foreach ($colArray as $key => $item){
			$allColArray['c_'.$key] = $item;
		}
		foreach ($agentColArray as $key => $item){
			$allColArray['a_'.$key] = $item;
		}
        foreach ($salesColArray as $key => $item){
            $allColArray['s_'.$key] = $item;
        }

		asort($allSort);

		$sqlSort = buildSQLSort($allColArray,$allSort);


		$order = trim(join(",",$sqlSort));
		if($order != "") {
			$guestSQL .= " 
				ORDER BY $order 
			";
		}

		if($renderMode == "html") {
			$pLimit = "10";
			$limit = "35";
			$pString = "";
			# Continue setting limits
			$countGuest = $lDB->get("SELECT pr_persona_ix FROM pr_persona WHERE
				 pr_persona_ix IN ('".join("','",$filterPersonaIdsArr)."')", 3);
			
			$total = count($countGuest);
			$realCount = (string) $total / $limit;
			$erg = explode(".",$realCount);
			$pCount = (int) $realCount;
			
			if (isset($erg[1]) && $erg[1] != "") {
				$pCount += "1";
			}
			
			if ($pLimit > $pCount) {
				$pLimit = $pCount;
			}
			
			$pStart = $page - (int) ($pLimit/2);
			
			--$page;
			if ($pStart < "1") {
				$pStart = "1";
			}
			
			if ($pStart > $pCount) {
				$pStart = $pCount;
			}
			$pEnd = $pStart+$pLimit;
			
			if ($pEnd > $pCount) {
				$pEnd = $pCount+1;
			}
			
			if ($page > $pEnd) {
				$page = $pEnd-1;
			}
			$start = $page * $limit;
			if($start<0) {
				$start = 0;
			}
			if($start >= $total) {
				$start = 0;
				$page = 0;
				$GLOBALS['temp']['pgNum'] = 1;
			}
			$dbLimit = "LIMIT ".$start.", ".$limit;
			
			# Generate the page breaks
			$printString = isset($printString) ? $printString : "";
			$printString .= "<a class=txt> of ".$pCount." page(s)</a>";
			$pString .= "<a class=txtbr>Pages:</a> ";
			if ($pStart > "1") {
				$pString .= "<a href=\"javascript:ShowFrom(1);\" class=txtbr>First</a>, ";
			}

			for($i=$pStart;$i<$pEnd;$i++) {
				if ($i != $pStart) {
					$pString .= ", ";
				}
				$pString .= "<a class=txtbr";
				if ($i != $page+1) {
					$pString .= " href=\"javascript:ShowFrom($i);\"";
				}
				$pString .= ">".$i."</a>";
			}
			if ($pEnd < $pCount) {
				$pString .= "<a class=txtbr>...</a> <a href=\"javascript:ShowFrom(".$pCount.");\" class=txtbr>Last</a>";
			}
			$pString .= "<a class=txtbr> of ".$pCount." page(s)</a>";

			$GLOBALS['temp']['hideNext'] = "";
			$GLOBALS['temp']['hidePrev'] = "";
			$pNext = $page+2;
			$pPrev = $page;
			$GLOBALS['temp']['pNext'] = (string) $pNext;
			$GLOBALS['temp']['pPrev'] = (string) $pPrev;
			if ($page+2 > $pCount) {
				$GLOBALS['temp']['hideNext'] = " style=\"visibility:hidden\"";
			}
			if ($page < "1") {
				$GLOBALS['temp']['hidePrev'] = " style=\"visibility:hidden\"";
			}

			$GLOBALS['temp']['ofnum'] = $printString;
			$GLOBALS['temp']['nextprev'] = $pString;
			$GLOBALS['temp']['limited'] = (string) $total;
			$GLOBALS['temp']['displayRec'] = (string) $total." of ";
			if($GLOBALS['temp']['displayRec'] > 35) {
				$GLOBALS['temp']['displayRec'] = "35 of ";
			}

			$guestSQL = $guestSQL." ".$dbLimit;
		}

		$contactData = $lDB->get($guestSQL, 2);

		$salesData = $lDB->get ("
			SELECT DISTINCT
				pr_sales_obj_data.pr_persona_id,
				pr_sales_obj_data.pr_sales_obj_data_text,
				pr_sales_obj_data.pr_sales_obj_data_memo,
				pr_sales_obj_data.rc_obj_sales_data_id,
				pr_sales_obj_data.rc_obj_sales_id
			FROM
				pr_sales_obj_data
			WHERE
				pr_sales_obj_data.pr_persona_id IN ('".join("','", $filterPersonaIdsArr)."')
							
			ORDER BY
				pr_sales_obj_data.pr_persona_id 
		", 2);

		$inact = "";
		if ($inactive == "1") {
			$inact = " AND pr_event.pr_event_inactive_yn = 0";
		}
		$eventSQL = "
			SELECT DISTINCT
				pr_event_persona.pr_persona_id,
				pr_event.pr_event_ix, 
				pr_event.pr_event_date, 
				pr_event.pr_event_note,
				pr_event.rc_event_id,
				pr_event.pr_event_duration,
				pr_event.pr_event_completed_yn,
				pr_event.pr_event_completed_date,
				pr_event.pr_event_inactive_yn,
				rc_action.rc_action_desc, 
				rc_action.rc_action_icon,
				rc_event.rc_event_desc,
				rc_tag.rc_tag_desc,
				int_persona.pr_name_first as int_rep_name_first, 
				int_persona.pr_name_last as int_rep_name_last,
				CONCAT(rtrim(int_persona.pr_name_first), ' ', rtrim(int_persona.pr_name_last)) AS int_rep_name_full,
				client_persona.pr_name_first as client_rep_name_first, 
				client_persona.pr_name_last as client_rep_name_last,
				CONCAT(rtrim(client_persona.pr_name_first), ' ', rtrim(client_persona.pr_name_last)) AS client_rep_name_full
			FROM
				pr_event
				INNER JOIN pr_event_persona ON pr_event.pr_event_ix = pr_event_persona.pr_event_id
				INNER JOIN rc_action ON pr_event.rc_action_id = rc_action.rc_action_ix
				INNER JOIN rc_event ON pr_event.rc_event_id = rc_event.rc_event_ix 
				LEFT JOIN  rc_event_tag ON rc_event.rc_event_ix = rc_event_tag.rc_event_id
				LEFT JOIN  rc_tag ON rc_tag.rc_tag_ix = rc_event_tag.rc_tag_id
				LEFT JOIN pr_event_persona as int_rep ON pr_event.pr_event_ix = int_rep.pr_event_id AND int_rep.pr_event_rep_ind=1
				LEFT JOIN pr_event_persona as client_rep ON pr_event.pr_event_ix = client_rep.pr_event_id AND client_rep.pr_event_rep_ind=2
				LEFT JOIN pr_persona as int_persona ON int_rep.pr_persona_id = int_persona.pr_persona_ix
				LEFT JOIN pr_persona as client_persona ON client_rep.pr_persona_id = client_persona.pr_persona_ix
			WHERE 
				pr_event_persona.pr_persona_id IN ('".join("','", $filterPersonaIdsArr)."')
				AND pr_event_persona.pr_event_rep_ind = '0'
				AND pr_event.pr_event_inactive_yn = 0
				$inact
				$salesWhere".
				$eventActionFilter['where'].
				$eventTagFilter['where'].
				$eventFilter['where'].
				$eventCompletedSQL." 
		";
		
		if ($internalRepFilter['ids'] == "0"){
			$eventSQL .= "
				AND int_rep.pr_persona_id IS NULL
			";
		} elseif ($internalRepFilter['ids'] != "") {
			$eventSQL .= "
				AND int_rep.pr_persona_id IN ('".join("','", explode(":", $internalRepFilter['ids']))."') 
			";
		}	
		if ($clientRepFilter['ids'] == "0"){
			$eventSQL .= "
				AND client_rep.pr_persona_id IS NULL
			";
		} elseif ($clientRepFilter['ids'] != "") {
			$eventSQL .= "
				AND client_rep.pr_persona_id IN ('".join("','", explode(":", $clientRepFilter['ids']))."')  
			";
		}			
		$eventSQL .= "
			ORDER BY 
				pr_event.pr_event_date		
		";

		$eventData = $lDB->get ($eventSQL, 2);
		
		$newSalesArr = array();
		$newAgentArr = array();
		$newEventArr = array();
		foreach ($salesData as $salesArr) {
			if(!isset($newSalesArr[$salesArr['pr_persona_id']]) || !is_array($newSalesArr[$salesArr['pr_persona_id']])) {
				$newSalesArr[$salesArr['pr_persona_id']] = array();
			}
			array_push($newSalesArr[$salesArr['pr_persona_id']], $salesArr);
		}

		if (is_array($contactData)) {
			foreach ($contactData as $agentArr) {
				if(!isset($newAgentArr[$agentArr['pr_agent_id']]) || !is_array($newAgentArr[$agentArr['pr_agent_id']])) {
					$newAgentArr[$agentArr['pr_agent_id']] = array();
				}
				array_push($newAgentArr[$agentArr['pr_agent_id']], $agentArr);
			}
		}

		foreach ($eventData as $key=>$eventArr) {
			$tags = $lDB->get ("SELECT rc_tag_desc FROM rc_tag INNER JOIN rc_event_tag ON rc_tag.rc_tag_ix = rc_event_tag.rc_tag_id WHERE rc_event_tag.rc_event_id = '".$eventArr['rc_event_id']."'", 3);
			$eventData[$key]['rc_event_tag'] = implode(", ", $tags);
			$eventArr['rc_event_tag'] = implode(", ", $tags);

			if($eventArr['pr_event_completed_yn'] == '1') {
				$eventData[$key]['pr_event_completed_yn'] = "x";
				$eventArr['pr_event_completed_yn'] = "x";
			} else {
				$eventData[$key]['pr_event_completed_yn'] = "";
				$eventArr['pr_event_completed_yn'] = "";
			}
			if($eventArr['pr_event_date'] == '0000-00-00') {
				$eventData[$key]['pr_event_date'] = "";
				$eventArr['pr_event_date'] = "";
			} else {
				$eventArr['pr_event_date'] = chng_date($eventArr['pr_event_date'],"-");
			}

			if(!isset($newEventArr[$eventArr['pr_persona_id']]) || !is_array($newEventArr[$eventArr['pr_persona_id']])) {
				$newEventArr[$eventArr['pr_persona_id']] = array();
			}
			array_push($newEventArr[$eventArr['pr_persona_id']], $eventArr);
		}

		if (is_array($contactData)) {
			foreach ($contactData as $key=>$item) {
				$pr_persona_int_rel = $lDB->get("
					SELECT
						pr_persona.pr_name_last
					FROM
						pr_persona
						INNER JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_to
					WHERE         
						pr_link_from = '".$item['pr_persona_ix']."'
						AND rf_link_type_id = 'RS1'
				", 4);

                $agntname = isset($item['agent_relationship_last']) ? trim($item['agent_relationship_last']) : "";
                if (isset($item['agent_relationship_first']) && $item['agent_relationship_first'] != "") {
                    $agntname .= ($agntname != "" ) ? ", ".$item['agent_relationship_first'] : $item['agent_relationship_first'];
                }

				if ($item['pr_persona_link_id'] != "0"){
					// Get linked address details
					$personaLink = $lDB->get ("
						SELECT
							pr_persona.pr_persona_ix,
							pr_persona.pr_name_last,
							pr_persona.pr_name_first,
							pr_persona.pr_corr_addr_line1,
							pr_persona.pr_corr_addr_line2,
							pr_persona.pr_corr_addr_line3,
							pr_persona.pr_corr_country_id,
							pr_persona.pr_corr_post_code,
							pr_persona.pr_corr_city,
							pr_persona.pr_phys_addr_line1,
							pr_persona.pr_phys_addr_line2,
							pr_persona.pr_phys_addr_line3,
							pr_persona.pr_phys_post_code,
							pr_persona.pr_phys_city,
							pr_corr_country.rf_country_name as pr_corr_country_name,
							pr_phys_country.rf_country_name as pr_phys_country_name
						FROM
							pr_persona
							LEFT JOIN rf_country as pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
						LEFT JOIN rf_country as pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
						WHERE		
							pr_persona_ix = '".$item['pr_persona_link_id']."'
					",1);				

					$contactData[$key]['pr_corr_addr_line1'] = $personaLink['pr_corr_addr_line1'];
					$contactData[$key]['pr_corr_addr_line2'] = $personaLink['pr_corr_addr_line2'];
					$contactData[$key]['pr_corr_addr_line3'] = $personaLink['pr_corr_addr_line3'];
					$contactData[$key]['pr_corr_post_code'] = $personaLink['pr_corr_post_code'];
					$contactData[$key]['pr_corr_city'] = $personaLink['pr_corr_city'];
					$contactData[$key]['pr_phys_addr_line1'] = $personaLink['pr_phys_addr_line1'];
					$contactData[$key]['pr_phys_addr_line2'] = $personaLink['pr_phys_addr_line2'];
					$contactData[$key]['pr_phys_addr_line3'] = $personaLink['pr_phys_addr_line3'];
					$contactData[$key]['pr_phys_post_code'] = $personaLink['pr_phys_post_code'];
					$contactData[$key]['pr_phys_city'] = $personaLink['pr_phys_city'];
					$contactData[$key]['pr_corr_country_name'] = $personaLink['pr_corr_country_name'];
					$contactData[$key]['pr_phys_country_name'] = $personaLink['pr_phys_country_name'];

				}
		
				$role = array();
				if(!$lDB->count("pr_agent","pr_agent_id",$item['pr_persona_ix'],0)) {
					$role[] = "Agent";
				}
				if(!$lDB->count("pr_user","pr_user_id",$item['pr_persona_ix'],0)) {
					$role[] = "User";
				}
				if(!$lDB->count("pr_guest","pr_guest_id",$item['pr_persona_ix'],0)) {
					$role[] = "Guest";
				}
				
				$contactData[$key]['pr_persona_type'] = "Individual";
				if($item['pr_org_yn'] == '1') {
					$contactData[$key]['pr_persona_type'] = "Organisation";
				}
				$contactData[$key]['fwd_persona_name'] = $item['fwd_name_first']." ".$item['fwd_name_last'];
				$contactData[$key]['pr_persona_role'] = $role;
				if($pr_persona_int_rel) {
					$contactData[$key]['pr_persona_int_rel'] = $pr_persona_int_rel;
				} else {
					$contactData[$key]['pr_persona_int_rel'] = "";
				}
				
				$pr_phone = "";
				$pr_fax = "";
				
				$pr_phones = $lDB->get ("SELECT pr_phone_number, rf_phone_type_id, pr_default_yn FROM pr_phone WHERE pr_phone.pr_persona_id = '".$item['pr_persona_ix']."' ",2);
				foreach($pr_phones as $phone) {
					if($phone['pr_default_yn'] == 1) {
						$phone['pr_phone_number'] = "<b>".$phone['pr_phone_number']."</b>";
					}
					if($phone['rf_phone_type_id'] == "RS1") {
						if($pr_fax == "") {
							$pr_fax .= $phone['pr_phone_number'];
						} else {
							$pr_fax .= ", ".$phone['pr_phone_number'];
						}
					} else {
						if($pr_phone == "") {
							$pr_phone .= $phone['pr_phone_number'];
						} else {
							$pr_phone .= ", ".$phone['pr_phone_number'];
						}
					}
				}
				
				$contactData[$key]['pr_phone_number'] = $pr_phone;
				$contactData[$key]['pr_fax_number'] = $pr_fax;

				$contactData[$key]['pr_persona_agent_rel'] = $agntname;
				$contactData[$key]['pr_anniversary'] = chng_date($contactData[$key]['pr_anniversary'],"-");
				$contactData[$key]['pr_birthdate'] = chng_date($contactData[$key]['pr_birthdate'],"-");
				$contactData[$key]['salesData'] = isset($newSalesArr[$item['pr_persona_ix']]) ? $newSalesArr[$item['pr_persona_ix']] : "";
				if ($show == "agentContacts"){
					$contactData[$key]['agentData'] = $newAgentArr[$item['pr_link_to']];				
				} else {
					$contactData[$key]['agentData'] = isset($newAgentArr[$item['pr_persona_ix']]) ? $newAgentArr[$item['pr_persona_ix']] : "";
				}
				$contactData[$key]['eventData'] = isset($newEventArr[$item['pr_persona_ix']]) ? $newEventArr[$item['pr_persona_ix']] : "";
			}
		}
			
	} else {
		$GLOBALS['temp']['hideNext'] = " style=\"visibility:hidden\"";
		$GLOBALS['temp']['hidePrev'] = " style=\"visibility:hidden\"";
		$GLOBALS['temp']['ofnum'] = "";
		$GLOBALS['temp']['nextprev'] = "";
		$GLOBALS['temp']['limited'] = 0;
		$GLOBALS['temp']['displayRec'] = "";
	}

	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));		
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['rows']   = outputHTML($cols,$salesCols,$agentCols,$eventCols,$contactData);
	}

	if ( $renderMode == "csv" || $renderMode == "oofice" || $renderMode == "csvFromXml" && ($renderType == "view" || $renderType == "send") ) {
		$fromDate = date("d-m-Y");
		$csvName = "CRM(Custom)_report_$fromDate";
		if ( $renderMode == "oofice" ) {
			$repName = $csvName.".xml";
			$repType = "xml";
        } elseif ( $renderMode == "csvFromXml" ) {
        	// Convert XML data into CSV output
            $repName = $csvName.".csv";
            $repType = "csvFromXml";
		} else {
			$repName = $csvName.".xlsx";
			$repType = "xls";
		}
		outputCSV($cols,$salesCols,$agentCols,$eventCols,$contactData,$renderType,$repName,$repType);
	}
}
