<?php

/**
 * init.form421.php - Rates Edit Popup Header (Job #404)
 */
  
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_edit_popup_header.htm");
}

$GLOBALS['temp']['errorContents'] = "";
$GLOBALS['temp']['compHTML'] = "";
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];

if($GLOBALS['jobLevelArray'][404] < 10 || $GLOBALS['lDB']->isMaster != "1" || $GLOBALS['isPropServer']) {
	$GLOBALS['temp']['canEditRates'] = "disabled";
} else {
	$GLOBALS['temp']['canEditRates'] = "";
}

if ($action == "2"){
	$lock = new Lock("rate_add");
	if($lock->Acquire()) { 
		$rateID = rt_rate_insert($_SERVER['argv'][1], $_SERVER['argv'][2], $_SERVER['argv'][3]);
		checkTBA($rateID);
	} else {
		// Wait until the lock is released, or 30 seconds pass so that the information output
		// is up to date
		$counter = 0;
		while($lock->IsHeld() && $counter < 30) {
			sleep(1);
		}
	}
} else {
	$rateID = $_SERVER['argv'][1];
	
	if ($_SERVER['argc'] > 2) {
		$lock = new Lock("rate_edit_$rateID");
		if($lock->Acquire()) { 
			// Process the data to be saved ----------------------------------------------
			$d = explode(":",$_SERVER['argv'][3]);
			if(sizeof($d) > 0) {
				rt_rate_update($rateID, $d[0], $d[1], $d[2], $d[3], $d[4], $d[5], $d[6], $d[7], $d[8], $d[9]);

				// Get Pax Rate Group
				$paxRateGroup = $lDB->get("
					SELECT
						rt_rate_group_ix 
					FROM
						rt_rate_group
					WHERE
						rt_rate_group.rt_rate_group_sys_code = 99
				",4);

				// Add / remove Pax rate group
				if ($d[9] == 1){
					$existingPaxRateGroup = $lDB->get("
						SELECT 
							rt_rate_comp_grp.rt_rate_comp_grp_ix
						FROM
							rt_rate_comp_grp
							INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
							INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
							INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
						WHERE
							rt_rate.rt_rate_ix = '".$rateID."'
							AND rt_rate_group.rt_rate_group_sys_code = 99
					",4);			

					if(!$existingPaxRateGroup){
						// Create Pax rate group
						addRateCompGroups($rateID,$paxRateGroup);
					}

				} else {
					// Delete pax group

					// Get existing amounts and their groups as these are not stored and we're about to change them 
					$rateGroupAmts = getRateGroupAmts($rateID);	

					// Now delete ALL amounts; they will be recalculated once the new rate comp groups are finalised
					rt_rate_grp_amt_delete_by_rate($rateID);	
					deleteRateCompGroups($rateID, $paxRateGroup);
					// Recalculate all amounts that we stored earlier, for those that still apply
					restoreAmounts($rateID, $rateGroupAmts);
					setFixedAmounts($rateID);
					validateAmounts($rateID);
					checkTBA($rateID);				
				}

				checkTBA($rateID);
			}
		} else {
			// Wait until the lock is released, or 30 seconds pass so that the information output
			// is up to date
			$counter = 0;
			while($lock->IsHeld() && $counter < 30) {
				sleep(1);
			}
		}
	}	
	
}
if (!checkCanOverride($rateID)){
	$GLOBALS['temp']['orideDisabled'] = "disabled"; 
	$GLOBALS['temp']['orideDisabledMouseOver'] = "onMouseOver=\"overlib('<div class=\'small\'>One or more of the Rate Groups do not have a percentage-based component split. This is required for a rate override to be calculated correctly.</div>',WIDTH,190)\" onMouseOut=\"nd()\"";
} else {
	$GLOBALS['temp']['orideDisabled'] = ""; 
	$GLOBALS['temp']['orideDisabledMouseOver'] = "";
}
tabStates($rateID);

$rateHeader = getRateHeader($rateID);

switch ($rateHeader['rt_rate_comm_yn']) {
	case 0:
		$GLOBALS['temp']['rtCommNoChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtCommYesChecked'] = "";
		break;
	case 1:
		$GLOBALS['temp']['rtCommNoChecked'] = "";
		$GLOBALS['temp']['rtCommYesChecked'] = "checked=\"checked\"";
		break;
}

switch ($rateHeader['rt_rate_overide_level_ind']) {
	case 0:
		$GLOBALS['temp']['rtOrideLevelNoneChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtOrideLevelPPChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelUnitChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelItemChecked'] = "";
		break;
	case 1:
		$GLOBALS['temp']['rtOrideLevelNoneChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelPPChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtOrideLevelUnitChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelItemChecked'] = "";
		break;
	case 2:
		$GLOBALS['temp']['rtOrideLevelNoneChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelPPChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelUnitChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtOrideLevelItemChecked'] = "";
		break;
	case 3:
		$GLOBALS['temp']['rtOrideLevelNoneChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelPPChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelUnitChecked'] = "";
		$GLOBALS['temp']['rtOrideLevelItemChecked'] = "checked=\"checked\"";
		break;		
}

switch ($rateHeader['rt_rate_oride_comm_yn']) {
	case 0:
		$GLOBALS['temp']['rtOrideCommNoChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtOrideCommYesChecked'] = "";
		break;
	case 1:
		$GLOBALS['temp']['rtOrideCommNoChecked'] = "";
		$GLOBALS['temp']['rtOrideCommYesChecked'] = "checked=\"checked\"";
		break;
}

switch ($rateHeader['rt_rate_ssupp_comm_yn']) {
	case 0:
		$GLOBALS['temp']['rtSSuppCommNoChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtSSuppCommYesChecked'] = "";
		break;
	case 1:
		$GLOBALS['temp']['rtSSuppCommNoChecked'] = "";
		$GLOBALS['temp']['rtSSuppCommYesChecked'] = "checked=\"checked\"";
		break;
}

switch ($rateHeader['rt_rate_round_ind']) {
	case 0:
		$GLOBALS['temp']['rtRoundingIndNoneSelected'] = "selected";
		$GLOBALS['temp']['rtRoundingIndPerItinerarySelected'] = "";
		$GLOBALS['temp']['rtRoundingIndPerPersonSelected'] = "";
		break;
	case 1:
		$GLOBALS['temp']['rtRoundingIndNoneSelected'] = "";
		$GLOBALS['temp']['rtRoundingIndPerItinerarySelected'] = "selected";
		$GLOBALS['temp']['rtRoundingIndPerPersonSelected'] = "";
		break;
	case 2:
		$GLOBALS['temp']['rtRoundingIndNoneSelected'] = "";
		$GLOBALS['temp']['rtRoundingIndPerItinerarySelected'] = "";
		$GLOBALS['temp']['rtRoundingIndPerPersonSelected'] = "selected";
		break;
}

switch ($rateHeader['rt_rate_round_dir']) {
	case 0:
		$GLOBALS['temp']['rtRoundingDirNoneChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtRoundingDirUpChecked'] = "";
		$GLOBALS['temp']['rtRoundingDirDownChecked'] = "";
		break;
	case 1:
		$GLOBALS['temp']['rtRoundingDirNoneChecked'] = "";
		$GLOBALS['temp']['rtRoundingDirUpChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtRoundingDirDownChecked'] = "";
		break;
	case 2:
		$GLOBALS['temp']['rtRoundingDirNoneChecked'] = "";
		$GLOBALS['temp']['rtRoundingDirUpChecked'] = "";
		$GLOBALS['temp']['rtRoundingDirDownChecked'] = "checked=\"checked\"";
		break;
}

switch ($rateHeader['rt_rate_round_scale']) {
	case 0:
		$GLOBALS['temp']['rtRoundingScaleNoneSelected'] = "selected";
		$GLOBALS['temp']['rtRoundingScaleUnitSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleTenSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleHundredSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleThousandSelected'] = "";		
		break;
	case 1:
		$GLOBALS['temp']['rtRoundingScaleNoneSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleUnitSelected'] = "selected";
		$GLOBALS['temp']['rtRoundingScaleTenSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleHundredSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleThousandSelected'] = "";	
		break;
	case 2:
		$GLOBALS['temp']['rtRoundingScaleNoneSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleUnitSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleTenSelected'] = "selected";
		$GLOBALS['temp']['rtRoundingScaleHundredSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleThousandSelected'] = "";	
		break;
	case 3:
		$GLOBALS['temp']['rtRoundingScaleNoneSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleUnitSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleTenSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleHundredSelected'] = "selected";
		$GLOBALS['temp']['rtRoundingScaleThousandSelected'] = "";	
		break;
	case 4:
		$GLOBALS['temp']['rtRoundingScaleNoneSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleUnitSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleTenSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleHundredSelected'] = "";
		$GLOBALS['temp']['rtRoundingScaleThousandSelected'] = "selected";	
		break;		
}

switch ($rateHeader['rt_rate_waive_checks_yn']) {
	case 1:
		$GLOBALS['temp']['rtWaiveChecksChecked'] = "checked=\"checked\"";
		break;
	case 0:
		$GLOBALS['temp']['rtWaiveChecksChecked'] = "";
		break;
}

switch ($rateHeader['rt_pax_rate_group_yn']) {
	case 1:
		$GLOBALS['temp']['rtPaxRateGroupChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['paxToggled'] = "1";
		break;
	case 0:
		$GLOBALS['temp']['rtPaxRateGroupChecked'] = "";
		$GLOBALS['temp']['paxToggled'] = "0";
		break;
}

switch ($rateHeader['rt_rate_status_ind']) {
	case 1:
		$GLOBALS['temp']['rtStatusActiveChecked'] = "checked=\"checked\"";
		$GLOBALS['temp']['rtStatusInactiveChecked'] = "";
		break;
	case 0:
		$GLOBALS['temp']['rtStatusActiveChecked'] = "";
		$GLOBALS['temp']['rtStatusInactiveChecked'] = "checked=\"checked\"";
		break;
}

$GLOBALS['temp']['rateHeader'] = headerHTML($rateID);

$GLOBALS['temp']['rateID'] = $rateID;
