<?php

/**
 * init.form421.php - Rates Edit Popup Components (Job #405)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_edit_popup_comp.htm");
}

$GLOBALS['temp']['errorContents'] = "";
$GLOBALS['temp']['compHTML'] = "";
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];

if($GLOBALS['jobLevelArray'][405] < 10 || $GLOBALS['lDB']->isMaster != "1" || $GLOBALS['isPropServer']) {
	$GLOBALS['temp']['canEditRates'] = "disabled";
} else {
	$GLOBALS['temp']['canEditRates'] = "";
}

$rateID = $_SERVER['argv'][1];

$savedRateEditComponentsIds = array();
$tax_ind = "";
$tax_id = "";

tabStates($rateID);

if ($_SERVER['argc'] > 2) {
	$lock = new Lock("rate_edit_$rateID");
	if($lock->Acquire()) { 
		// Get existing amounts and their groups as these are not stored and we're about to change them 
		$rateGroupAmts = getRateGroupAmts($rateID);	
		// Now delete ALL amounts; they will be recalculated once the new rate comp groups are finalised
		rt_rate_grp_amt_delete_by_rate($rateID);	

		switch ( $_SERVER['argv'][2] ) {
			case ("add") :
				$addedFields = explode("_",$_SERVER['argv'][3]);
				while ("" === end($addedFields)){
					array_pop($addedFields);
				}

				if(sizeof($addedFields) > 0) {
				
					// START Commission Check  
					$commCalcDeductAllCount = 0;

					$existingComponents = getRateComponents($rateID);

					foreach ($existingComponents as $component){
						if ($component['rt_comp_comm_yn'] == "3"){
							$commCalcDeductAllCount++;
						}
					}

					foreach ($addedFields as $component){
						$values = explode(":",$component);
						if ($values[3] == "3"){
							$commCalcDeductAllCount++;
						}
					}

					if ($commCalcDeductAllCount > 1){
						break;
					}
				
					// END Commission Check

					foreach ($addedFields as $component){
						$values = explode(":",$component);
						if ($values[7] == "0" && $values[8] != "0"){
							$tax_ind = DB_RT_RATE_COMPONENT_TAX_GROUP;
							$tax_id = $values[8];						
						} elseif ($values[8] == "0" && $values[7] != "0") {
							$tax_ind = DB_RT_RATE_COMPONENT_TAX_RATE;
							$tax_id = $values[7];						
						}
						if(sizeof($values) == 9) {
							$rt_rate_component_id = rt_rate_component_insert($rateID, $values[0],$values[1],$values[2],$values[3],$values[4],$values[5],$values[6],$tax_ind,$tax_id);	
							
							// Also add a rate component group for every rate group that is already used on this rate
							$existingRateGroups = $lDB->get("
								SELECT DISTINCT
										rt_rate_group.rt_rate_group_ix,
										rt_rate_comp_grp.rt_rate_comp_grp_seq
									FROM
										rt_rate_comp_grp
										INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
										INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
										INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
									WHERE
										rt_rate.rt_rate_ix = '".$rateID."'
							",2);
							
							if (count($existingRateGroups) > 0){
								foreach($existingRateGroups as $existingRateGroup){
									rt_rate_comp_grp_insert($rt_rate_component_id, $existingRateGroup['rt_rate_group_ix'],0,0,false,$existingRateGroup['rt_rate_comp_grp_seq']);
								}
							} else {
								// If there are no rate groups (eg. a new rate) add the syscode ones.
								$sysCodeRateGroups = $lDB->get("
									SELECT
										rt_rate_group.rt_rate_group_ix,
										rt_rate_group.rt_rate_group_sys_code
									FROM
										rt_rate_group
									WHERE
										rt_rate_group.rt_rate_group_sys_code IN (1,2,3)
								",2);
								
								foreach($sysCodeRateGroups as $sysCodeRateGroup){
									rt_rate_comp_grp_insert($rt_rate_component_id, $sysCodeRateGroup['rt_rate_group_ix'],0,0,false,$sysCodeRateGroup['rt_rate_group_sys_code']);
								}							
							}
							
						}
					}
				}
				break;			

			case ("edit"):
				// Process the data to be saved ----------------------------------------------
				$components = explode("_",$_SERVER['argv'][3]);
				while ("" === end($components)){
					array_pop($components);
				}
				if(sizeof($components) > 0) {
				
					// START Commission Check
					$commCalcDeductAllCount = 0;
					foreach ($components as $component){
						$values = explode(":",$component);
						if ($values[5] == "3"){
							$commCalcDeductAllCount++;
						}
			
					}
					if ($commCalcDeductAllCount > 1){
						break;
					}
			
					// END Commission Check
				
				
					foreach ($components as $component){
						$values = explode(":",$component);
						if ($values[8] == "0" && $values[9] != "0"){
							$tax_ind = DB_RT_RATE_COMPONENT_TAX_GROUP;
							$tax_id = $values[9];						
						} elseif ($values[9] == "0" && $values[8] != "0") {
							$tax_ind = DB_RT_RATE_COMPONENT_TAX_RATE;
							$tax_id = $values[8];						
						}
						rt_rate_component_update($values[0],$values[1],$values[2],$values[3],$values[4],$values[5],$values[6],$values[7],$tax_ind,$tax_id);					
					}
				}
				break;
			case ("delete"):
				$components = explode(":",$_SERVER['argv'][3]);
				foreach ($components as $component){
					deleteRateCompGroups($rateID,NULL,$component);
					rt_rate_component_delete($component);					
				}
				break;			
		}
		
		// Restore all amounts that we stored earlier, for those that still apply
		restoreAmounts($rateID, $rateGroupAmts);	
		checkTBA($rateID);
		tabStates($rateID);
	} else {
		// Wait until the lock is released, or 30 seconds pass so that the information output
		// is up to date
		$counter = 0;
		while($lock->IsHeld() && $counter < 30) {
			sleep(1);
		}
	}
}

$rateComponents = getRateComponents($rateID);

$allComponents = $lDB->get("
	SELECT
		rt_component.rt_component_ix,
		rt_component.rt_component_desc,
		rt_component.rt_component_separate_yn,
		rt_component_opt_yn,
		rt_component_def_yn,
		rt_component_comm,
		rt_component_freq,
		rt_component_freqfact,
		rt_component_taxrate,
		rt_component_taxgroup
	FROM
		rt_component
	WHERE
		rt_component.rt_component_inactive_yn = '0'
	ORDER BY
		rt_component.rt_component_desc
",2);

$allTaxGroups[] = array(	"rt_tax_group_ix" => 0,
							"rt_tax_group_desc" => "N/A"
						);
$tempAllTaxGroups = $lDB->get("
	SELECT
		rt_tax_group.rt_tax_group_ix,
		rt_tax_group.rt_tax_group_desc 
	FROM
		rt_tax_group
	WHERE
		rt_tax_group.rt_tax_group_inactive_yn = '0'
",2);
$allTaxGroups = array_merge($allTaxGroups, $tempAllTaxGroups);

$allTaxRates[] = array(	"rf_tax_rate_ix" => 0,
							"rf_tax_rate_desc" => "N/A"
						);
$tempAllTaxRates = $lDB->get("
	SELECT
		rf_tax_rate.rf_tax_rate_ix,
		rf_tax_rate.rf_tax_rate_desc 
	FROM
		rf_tax_rate
	WHERE
		rf_tax_rate.rf_tax_rate_inactive_yn = '0'		
",2);
$allTaxRates = array_merge($allTaxRates, $tempAllTaxRates);

$compHTML = "";
$hiddenCompHTML = "";
$hiddenTaxRateHTML = "";
$hiddenTaxGroupHTML = "";
$hiddenCommHTML = "";
foreach ($rateComponents as $rc) {
	$savedRateEditComponentsIds[] = $rc['rt_component_id'];

	$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $rc['rt_rate_component_ix'] . "',1);\" onmouseout=\"hover('" . $rc['rt_rate_component_ix'] . "',0);\"";
	$onClick = "onclick=\"editComp('" . $rc['rt_rate_component_ix'] . "',event);\"";
	$checkbox = "<input type=\"checkbox\" id=\"check" . $rc['rt_rate_component_ix'] . "\" ".$GLOBALS['temp']['canEditRates']." />";

	if ($rc['rt_comp_opt_yn'] == 1){
		$optyn = "Yes";
	} else {
		$optyn = "No";
	}
	
	if ($rc['rt_comp_opt_def_yn'] == 1){
		$optdefyn = "Yes";
	} else {
		$optdefyn = "No";
	}

	switch ($rc['rt_comp_comm_yn']){
	case 0:
		$commyn = "Not Commissionable";
		break;
	case 1:
		$commyn = "Calculate";
		break;
	case 2:
		$commyn = "Calc & deduct";
		break;
	case 3:
		$commyn = "Calc & deduct all";	
		break;	
	}
	
	if ($rc['rt_comp_freq_ind'] == 1){
		$freqInd = "Per Night";
		$freqFactor = $rc['rt_comp_freq_factor'];
	} else {
		$freqInd = "Per Stay";
		$freqFactor = "N/A";
	}
	
	if ($rc['rt_comp_separate_yn'] == 1){
		$sepyn = "Yes";
	} else {
		$sepyn = "No";
	}
	
	
	
	$taxRate = $taxGroup = "N/A";
	
	switch ($rc['rt_tax_ind']){
		case DB_RT_RATE_COMPONENT_TAX_RATE:
			$taxRate = $lDB->get("
				SELECT
					IF(rf_tax_rate.rf_tax_rate_inactive_yn<>0,CONCAT('* ',rf_tax_rate.rf_tax_rate_desc),rf_tax_rate.rf_tax_rate_desc) AS rf_tax_rate_desc
				FROM
					rf_tax_rate
				WHERE
					rf_tax_rate.rf_tax_rate_ix = '".$rc['rt_tax_id']."'
			",4);		
			break;
		case DB_RT_RATE_COMPONENT_TAX_GROUP:
			$taxGroup = $lDB->get("
				SELECT
					 IF(rt_tax_group.rt_tax_group_inactive_yn<>0,CONCAT('* ',rt_tax_group.rt_tax_group_desc),rt_tax_group.rt_tax_group_desc) AS rt_tax_group_desc
				FROM
					 rt_tax_group
				WHERE
					 rt_tax_group.rt_tax_group_ix = '".$rc['rt_tax_id']."'
			",4);
			break;
	}	
	
	$compHTML .= "
		<tr id=\"" . $rc['rt_rate_component_ix'] . "\" " . $mouseOver . ">\n
			<td class=\"br\">$checkbox</td>\n
			<td id=\"cell1" . $rc['rt_rate_component_ix'] . "\" class=\"br\"" . $onClick . ">&nbsp;" . urldecode($rc['rt_component_desc']) . "</td>\n
			<td id=\"cell2" . $rc['rt_rate_component_ix'] . "\" class=\"br\"" . $onClick . ">&nbsp;" . $optyn . "</td>\n
			<td id=\"cell9" . $rc['rt_rate_component_ix'] . "\" class=\"br\"" . $onClick . ">&nbsp;" . $optdefyn . "</td>\n
			<td id=\"cell3" . $rc['rt_rate_component_ix'] . "\" class=\"br\" " . $onClick . ">&nbsp;" . $commyn . "</td>\n
			<td id=\"cell4" . $rc['rt_rate_component_ix'] . "\" class=\"br\" " . $onClick . ">&nbsp;" . $freqInd . "</td>\n			
			<td id=\"cell5" . $rc['rt_rate_component_ix'] . "\" class=\"br\" " . $onClick . ">&nbsp;" . $freqFactor . "</td>\n			
			<td id=\"cell6" . $rc['rt_rate_component_ix'] . "\" class=\"br\" " . $onClick . ">&nbsp;" . $sepyn . "</td>\n
			<td id=\"cell7" . $rc['rt_rate_component_ix'] . "\" class=\"br\"" . $onClick . ">&nbsp;" . $taxRate . "</td>\n						
			<td id=\"cell8" . $rc['rt_rate_component_ix'] . "\" class=\"b\"" . $onClick . ">&nbsp;" . $taxGroup . "</td>\n			
	";

	
	$compHTML .= "</tr>";
	
	// [START] ----- Build the components dropdown for editing of this rate component
	$options = "<select id=\"cell1CompTemp" . $rc['rt_rate_component_ix'] . "\" style=\"width: 100%;\">
	";
	foreach ($allComponents as $component) {
		$selected = "";
		$used = false;
		if ( $component['rt_component_ix'] == $rc['rt_component_id'] ) {
			$selected = " selected=\"selected\"";
		}
		foreach ($rateComponents as $rateComponent){
			if ($component['rt_component_ix'] == $rateComponent['rt_component_id']){
				$used = true;
			}
		}
		if (!$used || $selected != ""){
			$options .= "<option value=\"$component[rt_component_ix]\" $selected>$component[rt_component_desc]</option>\n";	
		}
	}
	$options .= "</select>\n";
	$hiddenCompHTML .= "<span id=\"hiddenComp" . $rc['rt_rate_component_ix'] . "\">" . $options . "</span>\n";	
	// [END] ----- Build the components dropdown for editing of this rate component

	// [START] ----- Build the tax rate dropdown for editing of this rate component
	$options = "<select id=\"cell7TaxRateTemp" . $rc['rt_rate_component_ix'] . "\" style=\"width: 100%;\" onchange=\"selectTaxType(this);\">
	";
	foreach ($allTaxRates as $taxRate) {
		$selected = "";
		if ( $taxRate['rf_tax_rate_ix'] == $rc['rt_tax_id'] && $rc['rt_tax_ind'] == DB_RT_RATE_COMPONENT_TAX_RATE) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"$taxRate[rf_tax_rate_ix]\" $selected>$taxRate[rf_tax_rate_desc]</option>\n";
	}
	$options .= "</select>\n";
	$hiddenTaxRateHTML .= "<span id=\"hiddenTaxRate" . $rc['rt_rate_component_ix'] . "\">" . $options . "</span>\n";	
	// [END] ----- Build the tax rate dropdown for editing of this rate component		
	
	// [START] ----- Build the tax group dropdown for editing of this rate component
	$options = "<select id=\"cell8TaxGroupTemp" . $rc['rt_rate_component_ix'] . "\" style=\"width: 100%;\" onchange=\"selectTaxType(this);\">
	";
	foreach ($allTaxGroups as $taxGroup) {
		$selected = "";
		if ( $taxGroup['rt_tax_group_ix'] == $rc['rt_tax_id']  && $rc['rt_tax_ind'] == DB_RT_RATE_COMPONENT_TAX_GROUP) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"$taxGroup[rt_tax_group_ix]\" $selected>$taxGroup[rt_tax_group_desc]</option>\n";
	}
	$options .= "</select>\n";
	$hiddenTaxGroupHTML .= "<span id=\"hiddenTaxGroup" . $rc['rt_rate_component_ix'] . "\">" . $options . "</span>\n";	
	// [END] ----- Build the tax group dropdown for editing of this rate component

	// [START] ----- Build the commission dropdown for editing of this rate component
	$commTypes = array(
		0 => "Not commissionable",
		1 => "Calculate",
		2 => "Calc & deduct",
		3 => "Calc & deduct All"
	);
	
	$options = "<select id=\"cell3CommTemp" . $rc['rt_rate_component_ix'] . "\" style=\"width: 100%;\" onchange=\"selectCommType(this);\">
	";
	foreach ($commTypes as $key => $commType) {
		$selected = "";
		$used = false;
		if ( $key == $rc['rt_comp_comm_yn']) {
			$selected = " selected=\"selected\"";
		}
		
		$options .= "<option value=\"$key\" $selected>$commType</option>\n";
		
	}
	$options .= "</select>\n";
	$hiddenCommHTML .= "<span id=\"hiddenComm" . $rc['rt_rate_component_ix'] . "\">" . $options . "</span>\n";	
	// [END] ----- Build the commission dropdown for editing of this rate component	
	
}

// [START] ----- Build the NEW components dropdown
$options = "<select id=\"newCompTemp\" style=\"width: 100%;\">
";


$compSepDefaults = "";
$compOptDefaults = "";
$compDefDefaults = "";
$compCommDefaults = "";
$compFreqDefaults = "";
$compFreqFactDefaults = "";
$compTaxRateDefaults = "";
$compTaxGroupDefaults = "";

foreach ($allComponents as $component) {
	$used = false;
	foreach ($rateComponents as $rateComponent){
		if ($component['rt_component_ix'] == $rateComponent['rt_component_id']){
			$used = true;
		}
	}
	if (!$used){
		$options .= "<option value=\"$component[rt_component_ix]\">$component[rt_component_desc]</option>\n";
		$compSepDefaults 		.= $component['rt_component_separate_yn'].":";
		$compOptDefaults 		.= $component['rt_component_opt_yn'].":";
		$compDefDefaults 		.= $component['rt_component_def_yn'].":";
		$compCommDefaults 		.= $component['rt_component_comm'].":";
		$compFreqDefaults 		.= $component['rt_component_freq'].":";
		$compFreqFactDefaults 	.= $component['rt_component_freqfact'].":";
		$compTaxRateDefaults 	.= $component['rt_component_taxrate'].":";
		$compTaxGroupDefaults 	.= $component['rt_component_taxgroup'].":";
	}

}
$options .= "</select>\n";
$hiddenCompHTML .= "<span id=\"hiddenNewComp\">" . $options . "</span>\n";	
// [END] ----- Build the NEW components dropdown

// [START] ----- Build the NEW tax rate dropdown
$options = "<select id=\"newTaxRateTemp\" style=\"width: 100%;\" onchange=\"selectTaxType(this);\">
";

foreach ($allTaxRates as $taxRate) {

	$options .= "<option value=\"$taxRate[rf_tax_rate_ix]\">$taxRate[rf_tax_rate_desc]</option>\n";
}
$options .= "</select>\n";
$hiddenCompHTML .= "<span id=\"hiddenNewTaxRate\">" . $options . "</span>\n";	
// [END] ----- Build the NEW tax rate dropdown

// [START] ----- Build the NEW tax group dropdown
$options = "<select id=\"newTaxGroupTemp\" style=\"width: 100%;\" onchange=\"selectTaxType(this);\">
";

foreach ($allTaxGroups as $taxGroup) {

	$options .= "<option value=\"$taxGroup[rt_tax_group_ix]\">$taxGroup[rt_tax_group_desc]</option>\n";
}
$options .= "</select>\n";
$hiddenCompHTML .= "<span id=\"hiddenNewTaxGroup\">" . $options . "</span>\n";	
// [END] ----- Build the NEW tax group dropdown

// [START] ----- Build the NEW commission dropdown
$commTypes = array(
	0 => "Not commissionable",
	1 => "Calculate",
	2 => "Calc & deduct",
	3 => "Calc & deduct All"
);
$options = "<select id=\"newCommTemp\" style=\"width: 100%;\" onchange=\"selectCommType(this);\">
";

foreach ($commTypes as $key => $commType) {

	$options .= "<option value=\"$key\">$commType</option>\n";
}
$options .= "</select>\n";
$hiddenCompHTML .= "<span id=\"hiddenNewComm\">" . $options . "</span>\n";	
// [END] ----- Build the NEW commission dropdown


$GLOBALS['temp']['rateHeader'] 				= headerHTML($rateID);

$GLOBALS['temp']['rateID'] 					= $rateID;
$GLOBALS['temp']['savedCompCount'] 			= count($rateComponents);
$GLOBALS['temp']['maxCompCount'] 			= count($allComponents);

$GLOBALS['temp']['compSepDefaults'] 		= $compSepDefaults;
$GLOBALS['temp']['compOptDefaults'] 		= $compOptDefaults;
$GLOBALS['temp']['compDefDefaults'] 		= $compDefDefaults;
$GLOBALS['temp']['compCommDefaults'] 		= $compCommDefaults;
$GLOBALS['temp']['compFreqDefaults'] 		= $compFreqDefaults;
$GLOBALS['temp']['compFreqFactDefaults'] 	= $compFreqFactDefaults;
$GLOBALS['temp']['compTaxRateDefaults'] 	= $compTaxRateDefaults;
$GLOBALS['temp']['compTaxGroupDefaults'] 	= $compTaxGroupDefaults;

$GLOBALS['temp']['compHTML'] 				= $compHTML;
$GLOBALS['temp']['hiddenCompHTML'] 			= $hiddenCompHTML;
$GLOBALS['temp']['hiddenTaxRateHTML'] 		= $hiddenTaxRateHTML;
$GLOBALS['temp']['hiddenTaxGroupHTML'] 		= $hiddenTaxGroupHTML;
$GLOBALS['temp']['hiddenCommHTML'] 			= $hiddenCommHTML;

$GLOBALS['temp']['savedRateEditComponentsIds']	= implode($savedRateEditComponentsIds, ":");