<?php

/**
 * init.form421.php - Rates Edit Popup Component Split (Job #406)
 */
 
 
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_edit_popup_compsplit.htm");
}

$GLOBALS['temp']['errorContents'] = "";
$GLOBALS['temp']['compHTML'] = "";
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];

if($GLOBALS['jobLevelArray'][406] < 10 || $GLOBALS['lDB']->isMaster != "1" || $GLOBALS['isPropServer']) {
	$GLOBALS['temp']['canEditRates'] = "disabled";
} else {
	$GLOBALS['temp']['canEditRates'] = "";
}

$rateID = $_SERVER['argv'][1];
$rateHeader = getRateHeader($rateID);

tabStates($rateID);

$rateComponents = getRateComponents($rateID);

if (count($rateComponents) == 0){
	redirectTo("reservation.php?405+$rateID+++1");
	die();	
}

if ($_SERVER['argc'] > 2) {
	$lock = new Lock("rate_edit_$rateID");
	if($lock->Acquire()) { 
		// Get existing amounts and their groups as these are not stored and we're about to change them 
		$rateGroupAmts = getRateGroupAmts($rateID);	
		// Now delete ALL amounts; they will be recalculated once the new rate comp groups are finalised
		rt_rate_grp_amt_delete_by_rate($rateID);	
		

		switch ( $_SERVER['argv'][2] ) {
			case ("add") :		// Adding a rate group

				// Get highest sequence number
				$highestSeq = $GLOBALS['lDB']->get("
					SELECT 
						MAX(rt_rate_comp_grp.rt_rate_comp_grp_seq)
					FROM 
						rt_rate_comp_grp 
						INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
					WHERE 
						rt_rate_component.rt_rate_id = '$rateID'
				",4);

				$sequence = $highestSeq + 1;

				addRateCompGroups($rateID, $_SERVER['argv'][3], $sequence);
				
				break;			

			case ("edit"):
			
				$inputs = explode("_",$_SERVER['argv'][3]);
				while ("" === end($inputs)){
					array_pop($inputs);
				}
				if (sizeof($inputs) > 0){
				
					foreach ($inputs as $input){
						$compSplits = explode(":", $input);
						array_pop($compSplits);
						$rateCompID = $compSplits[0];
						// delete all rate_comp_group records for this rate component
						$oldRateCompGroups = $GLOBALS['lDB']->get("
							SELECT rt_rate_comp_grp_ix FROM rt_rate_comp_grp WHERE rt_rate_component_id = '$rateCompID'
						",2);
						foreach($oldRateCompGroups as $oldRateCompGroup){
							rt_rate_comp_grp_delete($oldRateCompGroup['rt_rate_comp_grp_ix']);
						}
						
						// add rate_comp_group records in this set
						array_shift($compSplits);
						foreach ($compSplits as $compSplit){
							$values = explode("|", $compSplit);
							rt_rate_comp_grp_insert($rateCompID, $values[0], $values[1], $values[2], $values[3], $values[4]);

							// Create Pax rate group if necessary
							if ($rateHeader['rt_pax_rate_group_yn'] == 1){
								$paxRateGroup = $lDB->get("
									SELECT
										rt_rate_group_ix 
									FROM
										rt_rate_group
									WHERE
										rt_rate_group.rt_rate_group_sys_code = 99
								",4);							
								addRateCompGroups($rateID,$paxRateGroup);
							}
						}
					}
				}
			

				
				break;
			case ("delete") :
			
				deleteRateCompGroups($rateID, $_SERVER['argv'][3]);
				break;		
			case ("updateComm") :
			
				updateRateCompGroupComm($rateID, $_SERVER['argv'][3], $_SERVER['argv'][4]);
				break;
			case ("updateCommBatch") :
				$commsData = json_decode(str_replace('%22', '"',$_SERVER['argv'][3]), true);
				foreach ($commsData as $comm) {
					updateRateCompGroupComm($rateID, $comm['rateGroupID'], $comm['commYN']);
				}
 				break;

		}
		
		// Recalculate all amounts that we stored earlier, for those that still apply
		restoreAmounts($rateID, $rateGroupAmts);
		setFixedAmounts($rateID);
		validateAmounts($rateID);
		checkTBA($rateID);
		$lock->Release();
	} else {
		// Wait until the lock is released, or 30 seconds pass so that the information output
		// is up to date
		$counter = 0;
		while($lock->IsHeld() && $counter < 30) {
			sleep(1);
		}
	}
}

$rateHeader = getRateHeader($rateID);

if ($rateHeader['rt_rate_overide_level_ind'] > 0){
	$GLOBALS['temp']['orideEnabled'] = 1;
} else {
	$GLOBALS['temp']['orideEnabled'] = 0;
}

// We need to fetch all the rate groups that are used by one or more of the components in this rate
$rateCompGroupHeaders = getRateComponentGroupHeaders($rateID);

// Build HTML for dropdown containing all UNUSED Rate Groups
$unusedRateGroups = getUnusedRateComponentGroups($rateID);
$rateGroupHTML = "<select id=\"unusedRateGroups\" style=\"width: 150px;\" ".$GLOBALS['temp']['canEditRates'].">";

$totals = array();
foreach ($unusedRateGroups as $unusedRateGroup) {
	$rateGroupHTML .= "<option value=\"".$unusedRateGroup['rt_rate_group_ix']."\">".$unusedRateGroup['rt_rate_group_desc']."</option>\n";
}
$rateGroupHTML .= "</select>\n";

$compGroupHeaders = "";
$compGroupSequenceHeaders = "";
$compGroupCommissionableHeaders = "";
$compGroupSubHeaders = "";
foreach ($rateCompGroupHeaders as $rateCompGroupHeader){
	$commCheck = "";
	// Add to the temp variable which the javascript will use later
	$rateGroupIDs[] = $rateCompGroupHeader['rt_rate_group_ix'];

	$compGroupHeaders .= "<td align=\"center\" class=\"colDk br bb\" colspan=\"2\">".$rateCompGroupHeader['rt_rate_group_desc'];
	if ($rateCompGroupHeader['rt_rate_group_sys_code'] == 0){
		if ($GLOBALS['temp']['canEditRates'] != "disabled"){
			$compGroupHeaders .= "<img onclick=\"delGroup('".$rateCompGroupHeader['rt_rate_group_ix']."')\" src=\"/resource/Resrequest/Application/public/img/button_cancel.gif\" alt=\"Delete Group\" title=\"Delete Group\" style=\"cursor:pointer;\">";	
		}
	}
	$compGroupHeaders .= "</td>\n";
	
	$commYN = getRateComponentGroupCommissionable($rateID, $rateCompGroupHeader['rt_rate_group_ix']);
	
	if ($commYN == 1){
		$commCheck = " checked";
	}
	
	$compGroupSequenceHeaders .= "<td align=\"center\" class=\"colDk br bb\" colspan=\"2\"><input type=\"textbox\" id=\"seq_".$rateCompGroupHeader['rt_rate_group_ix']."\" size=\"1\" style=\"text-align:center;\" onkeyup=\"editSequence()\" value=\"".$rateCompGroupHeader['rt_rate_comp_grp_seq']."\"></td>\n";

	$compGroupCommissionableHeaders .= "<td align=\"center\" class=\"colDk br bb\" colspan=\"2\"><input type=\"checkbox\" id=\"comm_".$rateCompGroupHeader['rt_rate_group_ix']."\" $commCheck onclick=\"markForSaving();\" ".$GLOBALS['temp']['canEditRates'].">";
	$compGroupCommissionableHeaders .= "</td>\n";	
	
	$compGroupSubHeaders.= "<td class=\"colDk br bb\" align=\"center\">Fixed</td>\n<td class=\"colDk br bb\" align=\"center\">%</td>";
}

$colCount = (count($rateCompGroupHeaders)*2)+1;

$compHTML = "";
$compOptHTML = "";
$rateOptCompIDs = array();
foreach ($rateComponents as $rc) {
	$compRowHTML = "";
	// Add to the temp variable which the javascript will use later
	if ($rc['rt_comp_opt_yn'] == 1){
		$rateOptCompIDs[] = $rc['rt_rate_component_ix'];
	} else {
		$rateCompIDs[] = $rc['rt_rate_component_ix'];
	}
	
	$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $rc['rt_rate_component_ix'] . "',1);\" onmouseout=\"hover('" . $rc['rt_rate_component_ix'] . "',0);\"";
	$onClick = "onclick=\"editCompsplit('" . $rc['rt_rate_component_ix'] . "',event);\"";
	$checkbox = "<input type=\"checkbox\" id=\"check" . $rc['rt_rate_component_ix'] . "\" />";

	$compRowHTML .= "
		<tr id=\"" . $rc['rt_rate_component_ix'] . "\" " . $mouseOver . ">\n
			<td id=\"desc_" . $rc['rt_rate_component_ix'] . "\" class=\"br\"" . " width=\"150\">&nbsp;" . urldecode($rc['rt_component_desc']) . "</td>\n
	";

	foreach ($rateCompGroupHeaders as $key => $rateCompGroupHeader){
	
		$rateCompSplit = getRateComponentSplit($rc['rt_rate_component_ix'], $rateCompGroupHeader['rt_rate_group_ix']);
		
		$amtID = "iamt_".$rateCompGroupHeader['rt_rate_group_ix']."_".$rc['rt_rate_component_ix'];
		$percID ="iperc_".$rateCompGroupHeader['rt_rate_group_ix']."_".$rc['rt_rate_component_ix']; 
		
		$amt = (is_numeric($rateCompSplit['rt_rate_comp_amt'])) ? $rateCompSplit['rt_rate_comp_amt'] : "0.00";
		$perc = ($rateCompSplit['rt_rate_comp_perc'] > 0 ) ? $rateCompSplit['rt_rate_comp_perc'] : "0.00";
		
			
		
		if ($rc['rt_comp_opt_yn'] == 1){
			$compRowHTML .= "
				<td class=\"br\" align=\"center\"><input class=\"inputDefault\" onkeyup=\"editCompsplit('opt_".$amtID."')\" value=\"".$amt."\" id=\"opt_".$amtID."\" width=\"65\" ".$GLOBALS['temp']['canEditRates']."></td>\n			
				<td class=\"br\" align=\"center\"><input class=\"inputDefault\" onkeyup=\"editCompsplit('opt_".$percID."')\" value=\"".$perc."\" id=\"opt_".$percID."\" width=\"65\" disabled></td>\n
			";	
		} else {
			$compRowHTML .= "
				<td class=\"br\" align=\"center\"><input class=\"inputDefault\" onkeyup=\"editCompsplit('".$amtID."')\" value=\"".$amt."\" id=\"".$amtID."\" width=\"65\" ".$GLOBALS['temp']['canEditRates']."></td>\n
				<td class=\"br\" align=\"center\"><input class=\"inputDefault\" onkeyup=\"editCompsplit('".$percID."')\" value=\"".$perc."\" id=\"".$percID."\" width=\"65\" ".$GLOBALS['temp']['canEditRates']."></td>\n
			";						
		}
		
		
		//<input onkeypress="calcRowTotal('iperc_RS3_RS1')" style="width: 35px;" value="12.00" id="iperc_RS3_RS1" type="text">
		if($rc['rt_comp_opt_yn'] != 1){
			if (!array_key_exists($rateCompGroupHeader['rt_rate_group_ix'], $totals)){
				$totals[$rateCompGroupHeader['rt_rate_group_ix']] = array(
					"amt" => 0,
					"perc" => 0
				);
			}
			$totals[$rateCompGroupHeader['rt_rate_group_ix']]['amt'] += $rateCompSplit['rt_rate_comp_amt'];
			$totals[$rateCompGroupHeader['rt_rate_group_ix']]['perc'] += $rateCompSplit['rt_rate_comp_perc'];
		}
		
	}

	$compRowHTML .= "</tr>\n";
	
	if ($rc['rt_comp_opt_yn'] == 1){
		$compOptHTML .= $compRowHTML;
	} else {
		$compHTML .= $compRowHTML;
	}
	
}

$compHTML .= "<tr><td class=\"br bt\" style=\"font-weight: bold;\">&nbsp;Total</td>";
foreach ($totals as $groupID => $total){
		$compHTML .= "<td class=\"br bt\" align=\"center\" width=\"65\"><input id=\"totalAmt_".$groupID."\" value=\"".number_format($total['amt'],2)."\" class=\"inputDisabled\" disabled></input></td>";
		$compHTML .= "<td class=\"br bt\" align=\"center\" width=\"65\"><input id=\"totalPerc_".$groupID."\" value=\"".number_format($total['perc'],2)."\" class=\"inputDisabled\" disabled></input></td>";		
}
$compHTML .= "</tr>";


$compHTML .= "<tr><td class=\"bt\" height=\"1\" colspan=\"$colCount\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";

$compHTML .= "
				<tr>
					<td class=\"colLtt bt bb br\" colspan=\"$colCount\" style=\"font-weight: bold;\">&nbsp;Optional</td>
				</tr>	
";

$compHTML .= $compOptHTML;

$compHTML .= "<tr><td class=\"bt\" height=\"1\" colspan=\"$colCount\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";

$tableWidth = 150;
for ($i=1; $i<$colCount; $i++){
	$tableWidth += 65;
}

$GLOBALS['temp']['rateHeader'] = headerHTML($rateID);

$GLOBALS['temp']['rateID'] = $rateID;
$GLOBALS['temp']['compHTML'] = $compHTML;
$GLOBALS['temp']['compGroupHeaders'] = $compGroupHeaders;
$GLOBALS['temp']['compGroupSequenceHeaders'] = $compGroupSequenceHeaders;
$GLOBALS['temp']['compGroupCommissionableHeaders'] = $compGroupCommissionableHeaders;
$GLOBALS['temp']['compGroupSubHeaders'] = $compGroupSubHeaders;
//$GLOBALS['temp']['colWidths'] = $colWidths;
$GLOBALS['temp']['tableWidth']= $tableWidth;
$GLOBALS['temp']['rateGroupIDs'] = is_array($rateGroupIDs) ? implode($rateGroupIDs,",") : "";
$GLOBALS['temp']['rateCompIDs'] = is_array($rateCompIDs) ? implode($rateCompIDs,",") : "";
$GLOBALS['temp']['rateOptCompIDs'] = is_array($rateOptCompIDs) ? implode($rateOptCompIDs,",") : "";
$GLOBALS['temp']['rateGroupHTML'] = $rateGroupHTML;
