<?php

/**
 * init.form421.php - Rates Edit Popup Amounts (Job #407)
 */
 
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_edit_popup_amt.htm");
}

$GLOBALS['temp']['errorContents'] = "";
$GLOBALS['temp']['compHTML'] = "";
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];

if($GLOBALS['jobLevelArray'][407] < 10 || $GLOBALS['lDB']->isMaster != "1" || $GLOBALS['isPropServer']) {
	$GLOBALS['temp']['canEditRates'] = "disabled";
} else {
	$GLOBALS['temp']['canEditRates'] = "";
}

$rateID = $_SERVER['argv'][1];
$rateHeader = getRateHeader($rateID);

if ($rateHeader['rt_pax_rate_group_yn'] == 1){
	$rateCompGroupHeaders = getRateComponentGroupHeaders($rateID,1);
} else {
	$rateCompGroupHeaders = getRateComponentGroupHeaders($rateID);
}

tabStates($rateID);

if (count($rateCompGroupHeaders) == 0){
	redirectTo("reservation.php?406+$rateID+++1");
	die();	
}

if ($_SERVER['argc'] > 2) {
	$lock = new Lock("rate_edit_$rateID");
	if($lock->Acquire()) { 
		switch ( $_SERVER['argv'][2] ) {
			case ("edit") :	
					$inputs = explode("_",$_POST['data']);
					array_pop($inputs);
					if (sizeof($inputs) > 0){
						foreach ($inputs as $input){  // set of records per pax
							$compGrpAmts = explode("|", $input);
							$rt_rate_grp_amt_qty = $compGrpAmts[0];
							array_shift($compGrpAmts);	// Knock off qty
							array_pop($compGrpAmts); // Knock off empty record
							rt_rate_grp_amt_delete_by_rate($rateID, $rt_rate_grp_amt_qty);
							foreach ($compGrpAmts as $compGrpAmt){
								$values = explode(":", $compGrpAmt);
								if (is_numeric($values[1])){
									rt_rate_grp_amt_insert($rateID, $values[0], $rt_rate_grp_amt_qty, $values[1]);
								}
							}						
						}
					}
				break;
		}
		checkTBA($rateID);
	} else {
		// Wait until the lock is released, or 30 seconds pass so that the information output
		// is up to date
		$counter = 0;
		while($lock->IsHeld() && $counter < 30) {
			sleep(1);
		}
	}
}

$compGroupHeaders = "";
foreach ($rateCompGroupHeaders as $rateCompGroupHeader){
	$compGroupHeaders .= "<td class=\"colDk bb\" align=\"left\"><input class=\"forminput\" onclick=\"checkAmtAll(this)\" type=\"checkbox\" id=\"checkAll".$rateCompGroupHeader['rt_rate_group_ix']."\" ".$GLOBALS['temp']['canEditRates']."></td>
				<td class=\"colDk bb br\" align=\"center\">".$rateCompGroupHeader['rt_rate_group_desc']."</td>\n";
}

$colCount = count($rateCompGroupHeaders);
$colWidths = "<col style=\"width:90px\"/>\n";
for ($i=0; $i<$colCount; $i++){
	$colWidths .= "<col style=\"width:21px\"/><col style=\"width:69px\"/>\n";	
}
$colCount = $colCount * 2;

$rateHeader = getRateHeader($rateID);

$maxCapacity = getAccommTypeMaxCapacity($rateHeader['ac_accomm_type_ix']);

$rateGroupAmts = getRateGroupAmts($rateID);

// Build Totals (same as those seen in component split screen)
$rateComponents = getRateComponents($rateID);
$totals = array();
$amtHTML = "";
foreach ($rateComponents as $rc) {
	if ($rc['rt_comp_opt_yn'] != 1){
		foreach ($rateCompGroupHeaders as $key => $rateCompGroupHeader){
			if (!array_key_exists($rateCompGroupHeader['rt_rate_group_ix'], $totals)){
				$totals[$rateCompGroupHeader['rt_rate_group_ix']] = array(
					"amt" => 0,
					"perc" => 0
				);
			}			
			$rateCompSplit = getRateComponentSplit($rc['rt_rate_component_ix'], $rateCompGroupHeader['rt_rate_group_ix']);
			$totals[$rateCompGroupHeader['rt_rate_group_ix']]['amt'] += $rateCompSplit['rt_rate_comp_amt'];
			$totals[$rateCompGroupHeader['rt_rate_group_ix']]['perc'] += $rateCompSplit['rt_rate_comp_perc'];
		}
	}
}

for ($i=0;$i<=$maxCapacity; $i++){
	$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $i . "',1);\" onmouseout=\"hover('" . $i . "',0);\"";
	$onClick = "onFocus=\"editAmt(this);\"";
	$checkbox = "<input type=\"checkbox\" id=\"check" . $i . "\"  ".$GLOBALS['temp']['canEditRates']."/>";
	switch($i){
	case 0:
		$amtHTML .= "
			<tr id=\"" . $i . "\" " . $mouseOver . ">\n
				<td id=\"row_" . $i . "\" class=\"br\" align=\"left\"" . ">1 Sharing</td>\n
		";	
		foreach ($rateCompGroupHeaders as $rateCompGroupHeader){
			$amount = "<none>";			
			// Add to the temp variable which the javascript will use later
			$compGroupIDs[] = $rateCompGroupHeader['rt_rate_group_ix'];		
		
			foreach($rateGroupAmts as $rateGroupAmt){
				if ($rateGroupAmt['rt_rate_group_ix'] == $rateCompGroupHeader['rt_rate_group_ix'] && $rateGroupAmt['rt_rate_grp_amt_qty'] == $i){
					$amount = $rateGroupAmt['rateGroupTotal'];
				}
			}
			if ($totals[$rateCompGroupHeader['rt_rate_group_ix']]['perc'] == 0){
				$apportionedTotal = ($totals[$rateCompGroupHeader['rt_rate_group_ix']]['amt']*1);
			} else {
				$apportionedTotal = 0;
			}	
			
			$amtHTML .= "
				<td align=\"left\"" . ">
					<input class=\"forminput\" onclick=\"event.cancelBubble = true;\" type=\"checkbox\" name=\"checkAmt\" id=\"".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" ".$GLOBALS['temp']['canEditRates'].">
				</td>
				<td class=\"br\" align=\"right\"" . ">					
					<input class=\"inputDefault\" value=\"".$amount."\" id=\"amt".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" style=\"width: 95%\"" . $onClick ." ".$GLOBALS['temp']['canEditRates'].">
					<input type=\"hidden\" id=\"fixed".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" value=\"".$apportionedTotal."\">
				</td>\n
			";				
		}
		$amtHTML .= "</tr>\n";		
		break;
	case 1:
		$amtHTML .= "
			<tr id=\"" . $i . "\" " . $mouseOver . ">\n
				<td id=\"row_" . $i . "\" class=\"br\" align=\"left\"" . ">1 Single</td>\n
		";	
		foreach ($rateCompGroupHeaders as $rateCompGroupHeader){
			$amount = "<none>";
			foreach($rateGroupAmts as $rateGroupAmt){
				if ($rateGroupAmt['rt_rate_group_ix'] == $rateCompGroupHeader['rt_rate_group_ix'] && $rateGroupAmt['rt_rate_grp_amt_qty'] == $i){
					$amount = $rateGroupAmt['rateGroupTotal'];
				}
			}		

			if ($totals[$rateCompGroupHeader['rt_rate_group_ix']]['perc'] == 0){
				$apportionedTotal = ($totals[$rateCompGroupHeader['rt_rate_group_ix']]['amt']*1);
			} else {
				$apportionedTotal = 0;
			}		
			
			$amtHTML .= "
				<td align=\"left\"" . ">
					<input class=\"forminput\" onclick=\"event.cancelBubble = true;\" type=\"checkbox\" name=\"checkAmt\" id=\"".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" ".$GLOBALS['temp']['canEditRates'].">
				</td>
				<td class=\"br\" align=\"right\"" . ">			
					<input class=\"inputDefault\" value=\"".$amount."\" id=\"amt".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" style=\"width: 95%\"". $onClick . " ".$GLOBALS['temp']['canEditRates'].">
					<input type=\"hidden\" id=\"fixed".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" value=\"".$apportionedTotal."\">
				</td>\n
			";			
		}
		$amtHTML .= "</tr>\n";		
		break;
	default:
		$amtHTML .= "
			<tr id=\"" . $i . "\" " . $mouseOver . ">\n
				<td id=\"row_" . $i . "\" class=\"br\" align=\"left\"" . ">".$i."</td>\n
		";	
		foreach ($rateCompGroupHeaders as $rateCompGroupHeader){
			$amount = "<none>";
			foreach($rateGroupAmts as $rateGroupAmt){
				if ($rateGroupAmt['rt_rate_group_ix'] == $rateCompGroupHeader['rt_rate_group_ix'] && $rateGroupAmt['rt_rate_grp_amt_qty'] == $i){
					$amount = $rateGroupAmt['rateGroupTotal'];
				}
			}		

			if ($totals[$rateCompGroupHeader['rt_rate_group_ix']]['perc'] == 0){
				
				$apportionedTotal = ($totals[$rateCompGroupHeader['rt_rate_group_ix']]['amt']*$i);
			} else {
				$apportionedTotal = 0;
			}			
			
			$amtHTML .= "
				<td align=\"left\"" . ">
					<input class=\"forminput\" onclick=\"event.cancelBubble = true;\" type=\"checkbox\" name=\"checkAmt\" id=\"".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" ".$GLOBALS['temp']['canEditRates'].">
				</td>
				<td class=\"br\" align=\"right\"" . ">	
					<input class=\"inputDefault\" value=\"".$amount."\" id=\"amt".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" style=\"width: 95%\"". $onClick . " ".$GLOBALS['temp']['canEditRates'].">
					<input type=\"hidden\" id=\"fixed".$rateCompGroupHeader['rt_rate_group_ix']."_" . $i . "\" value=\"".$apportionedTotal."\">
				</td>\n
			";			
		}
		$amtHTML .= "</tr>\n";		
		break;
	}
}

$tableWidth = 90;
for ($i=1; $i<$colCount/2; $i++){
    $tableWidth += 90;
}
$GLOBALS['temp']['rateHeader'] = headerHTML($rateID);
$GLOBALS['temp']['rateID'] = $rateID;
$GLOBALS['temp']['compGroupHeaders'] = $compGroupHeaders;
$GLOBALS['temp']['colWidths'] = $colWidths;
$GLOBALS['temp']['tableWidth']= $tableWidth;
$GLOBALS['temp']['colCount'] = $colCount;
$GLOBALS['temp']['compGroupIDs'] = is_array($compGroupIDs) ? implode($compGroupIDs,",") : "";
$GLOBALS['temp']['maxCapacity'] = $maxCapacity;
$GLOBALS['temp']['amtHTML'] = $amtHTML;
