<?php
/*
 * $Id: init.form428.php,v 1.5 2011-03-31 17:14:43 light Exp $
 *
 * $Log: init.form428.php,v $
 * Revision 1.5  2011-03-31 17:14:43  light
 * Bug #7471 - Multiple Rates Issues
 *
 * Revision 1.4  2011-03-03 11:22:23  light
 * Bug #7457 - EDIT RATE : F9 Function not working
 *
 * Revision 1.3  2010-11-22 10:51:05  light
 * Bug #7386 - Consolidate multi-line Rates into one
 *
 * Revision 1.2  2010-10-06 16:24:35  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.1  2010-10-04 15:39:08  light
 * Bug #6956 - Rates pre-integration
 *
 */

/**
 * init.form428.php - Edit Rates
 */

require_once(__DIR__ . '/functions.report.php');

if($_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
} 

if (!is_object($GLOBALS[$form])) {
	$GLOBALS[form428] = new Form("form428","",__DIR__ . "/../../../public/html/rate_select.htm");
	$GLOBALS[$form]->Arguments = "401";
}
$GLOBALS['temp']['userPopup'] = "";

$pf_object_id = db_pf_object_by_name("edit_rates");
processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$_SERVER['argc'] = sizeof($_SERVER['argv']);
$title = db_pf_option_get_title($pf_option_id);

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);

$accommFilter = useFilter("accomm",$_SERVER['argv'][1],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","",false,false,false);	
$ratePeriodFilter = useFilter("ratePeriod",$_SERVER['argv'][2],"SELECT rt_period.rt_period_desc FROM rt_period WHERE rt_period.rt_period_ix=","",false,false,false);
$rateTypeFilter = useFilter("rate",$_SERVER['argv'][3],"SELECT rt_rate_type.rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =","",false,false,false);

$fromDate = useDate("from",$_SERVER['argv'][6]);
$toDate = useDate("to",$_SERVER['argv'][7]);

$page = $_SERVER['argv'][4];
if (trim($page) == "") {
	$page = "1";
}

$GLOBALS['temp']['dateAllChecked'] = "checked";
$GLOBALS['temp']['dateRangeOpt'] = "1";
$GLOBALS['temp']['page'] = "<input type=\"hidden\" id=\"currentPage\" value=\"" . $page . "\">";
$GLOBALS['temp']['results'] = "collapse printCollapse";

if($_SERVER['argc'] > 1){
	switch ($_SERVER['argv'][5]){
		case 1:					// All
			$GLOBALS['temp']['dateAllChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "1";
			$dateRangeSQL = "";
			break;
		case 2:					// Future
			$GLOBALS['temp']['dateFutureChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "2";
			
			$maxDate = $GLOBALS['lDB']->get("SELECT MAX(rt_period_to) FROM rt_period_dates",4);
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_from <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_to >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_from <= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to >= '".$maxDate."'
					)
				)
			";
			break;
		case 3:					// Date Range
			$GLOBALS['temp']['dateRangeChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "3";
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_from <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_to >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_from <= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to >= '".$toDate['jsDate']."'
					)
				)
			";			
			break;
			
	}
	
	$GLOBALS['temp']['results'] = "";
	$GLOBALS['temp']['resultsGenerated'] = "";

	if($accommFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.ac_accomm_type_id IN ('".join("','",split(":",$accommFilter['ids']))."')";
	}
	
	if($ratePeriodFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_period_id IN ('".join("','",split(":",$ratePeriodFilter['ids']))."')";
	}

	if($rateTypeFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_rate_type_id  IN ('".join("','",split(":",$rateTypeFilter['ids']))."')";
	}

	$selectsql = "
		SELECT DISTINCT
			rt_rate.rt_rate_ix,
			pr_business.pr_bus_name_short,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc,
			rt_rate_type.rt_rate_type_ix,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_name,
			rt_period.rt_period_ix,
			rt_period.rt_period_desc,
			rt_rate.rt_rate_overide_access_ind,
			rt_rate.rt_rate_overide_level_ind,
			rt_rate.rt_rate_round_dir,
			rt_rate.rt_rate_round_scale,
			rt_rate.rt_rate_tba_yn,
			rt_rate.rt_rate_status_ind
	";
	
	$fromsql = "
		FROM
			rt_rate
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
		INNER JOIN rf_currency ON rt_rate_type.rf_currency_id  = rf_currency.rf_currency_ix 
		INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
		INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
		WHERE
			1
		$wheresql
		$dateRangeSQL
	";

	// START PAGE HANDLING
	$totalRows = $lDB->get("SELECT COUNT(*) $fromsql",4);
	$pageLength = 35;
	$GLOBALS['temp']['pageCount'] = ceil($totalRows/$pageLength);
	$GLOBALS['temp']['pageNum'] = $page;
	$GLOBALS['temp']['nextPageNum'] = $page+1;
	$GLOBALS['temp']['prevPageNum'] = $page-1;	
	if ($page == 1) {
		$GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
	} else {
		$GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
	}
	if ($page >= $GLOBALS['temp']['pageCount']) {
		$GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
	} else {
		$GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
	}
	$totalPages = ceil($totalRows/$pageLength);
	if (($totalPages - $page) < 2 ) {
		$startPage = $totalPages - 2;
	} elseif($page < 4) {
		$startPage = 4;
	} else {
		$startPage = $page;
	}
	if ($page != 1) {
		$pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
	} else {
		$pageList = "<B>1</B>";
	}
	for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
		if ($count == $page) {
			$pageList .= ", <B>$count</B>";
		} else {
			$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
		}
	}
	if (($totalPages - $page) > 3 ) {
		$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
	}
	$GLOBALS['temp']['pageList'] = $pageList;

	$limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
	$GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);

	// END PAGE HANDLING

	
	$rates = $GLOBALS['lDB']->get($selectsql.$fromsql.$limit,2);

	foreach($rates as $key=>$item) {
		$rateId = $item[0];

		$rows .= "<tr class='linkrow' onclick=\"rateEditPage('404', '$rateId');\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">";
		$rows .= "<td class=\"br bb\" $align><input id=\"tick".$key."\" name=\"tick\" class=\"forminput\"  type=\"checkbox\" onclick=\"event.cancelBubble = true;\"></td>";
		$rows .= "<td class=\"br bb\" $align>&nbsp;$item[pr_bus_name_short]</td>";
		$rows .= "<td class=\"br bb\" $align>&nbsp;$item[ac_accomm_desc]</td>";
		$rows .= "<td class=\"br bb\" $align>&nbsp;$item[rt_rate_type_desc]</td>";
		$rows .= "<td class=\"br bb\" $align>&nbsp;$item[rf_currency_name]</td>";
		$rows .= "<td class=\"br bb\" $align>&nbsp;$item[rt_period_desc]</td>";

		switch ($item[rt_rate_overide_access_ind]){
			case 0:
				$rows .= "<td class=\"br bb\" $align>&nbsp;None</td>";
				break;
			case 1:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Update</td>";
				break;
			case 2:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Management</td>";
				break;
		}
		
		switch ($item[rt_rate_overide_level_ind]){
			case 0:
				$rows .= "<td class=\"br bb\" $align>&nbsp;None</td>";
				break;
			case 1:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Person</td>";
				break;
			case 2:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Unit</td>";
				break;
			case 3:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Stay</td>";
				break;				
		}
		
		switch ($item[rt_rate_round_dir]){
			case 0:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Default</td>";
				break;
			case 1:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Up</td>";
				break;
			case 2:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Down</td>";
				break;			
		}		
		
		switch ($item[rt_rate_round_scale]){
			case 0:
				$rows .= "<td class=\"br bb\" $align>&nbsp;None</td>";
				break;
			case 1:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Unit</td>";
				break;
			case 2:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Ten</td>";
				break;
			case 3:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Hundred</td>";
				break;		
			case 4:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Thousand</td>";
				break;						
		}		
		
		switch ($item[rt_rate_tba_yn]){
			case 0:
				$rows .= "<td class=\"br bb\" $align>&nbsp;No</td>";
				break;
			case 1:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Yes</td>";
				break;
		}
		
		switch ($item[rt_rate_status_ind]){
			case 0:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Inactive</td>";
				break;
			case 1:
				$rows .= "<td class=\"br bb\" $align>&nbsp;Active</td>";
				break;
		}		

		$rows .= "	<input id=\"detail".$key."\" type=\"hidden\" value=\"".$item[ac_accomm_type_ix].":".$item[rt_period_ix].":".$item[rt_rate_type_ix]."\"></input>";
		$rows .= "	<input id=\"rateId".$key."\" type=\"hidden\" value=\"$rateId\"></input>";
		
		$rows .= "</tr>";
	}
	$GLOBALS['temp']['rows'] = $rows;	
	$GLOBALS['temp']['recordCount'] = count($rates);
	
} else {
	$GLOBALS['temp']['resultsGenerated'] = " class=\"collapse\" ";
}
