<?php

/**
 * init.form429.php - Rates Add
 */

require_once(__DIR__ . '/functions.report.php');

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
} 

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_add.htm");
	$GLOBALS[$form]->Arguments = "409";
}

$newRelic = new NewRelic();
$newRelic->record_transaction("Add Rates");

$pf_object_id = db_pf_object_by_name("add_rates");

processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$_SERVER['argc'] = sizeof($_SERVER['argv']);

$_SERVER['argv'] = array_pad($_SERVER['argv'],10,"");

$title = db_pf_option_get_title($pf_option_id);

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);

$accommFilter = useFilter("accomm",$_SERVER['argv'][1],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","",false,false,false);	
$ratePeriodFilter = useFilter("ratePeriod",$_SERVER['argv'][2],"SELECT rt_period.rt_period_desc FROM rt_period WHERE rt_period.rt_period_ix=","rt_period_ix",false,false,false);
$rateTypeFilter = useFilter("rate",$_SERVER['argv'][3],"SELECT rt_rate_type.rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =","",false,false,false);

$fromDate = useDate("from",$_SERVER['argv'][6]);
$toDate = useDate("to",$_SERVER['argv'][7]);

$page = $_SERVER['argv'][8];

$perPage = $_SERVER['argv'][9] > 0 ? $_SERVER['argv'][9] : 35;

$pageList = "";
$GLOBALS['temp']['accommChecked'] = "checked";
$GLOBALS['temp']['ratePeriodChecked'] = "";
$GLOBALS['temp']['rateTypeChecked'] = "";
$GLOBALS['temp']['selectOpt'] = "1";
$GLOBALS['temp']['dateFutureChecked'] = "checked";
$GLOBALS['temp']['dateRangeOpt'] = "2";
$GLOBALS['temp']['results'] = "collapse printCollapse";

$GLOBALS['temp']['perPage35'] = "";
$GLOBALS['temp']['perPage100'] = "";
$GLOBALS['temp']['perPage200'] = "";

switch($perPage) {

	case 100:
		$GLOBALS['temp']['perPage100'] = "selected";
		break;

	case 200:
		$GLOBALS['temp']['perPage200'] = "selected";
		break;

	case 35:
	default:
		$GLOBALS['temp']['perPage35'] = "selected";
		break;
}

if($_SERVER['argc'] > 1){

	$GLOBALS['temp']['results'] = "";
	$GLOBALS['temp']['resultsGenerated'] = "";
	$GLOBALS['temp']['accommChecked'] = "";
	$GLOBALS['temp']['ratePeriodChecked'] = "";
	$GLOBALS['temp']['rateTypeChecked'] = "";
	$GLOBALS['temp']['dateAllChecked'] = "";
	$GLOBALS['temp']['dateFutureChecked'] = "";
	$GLOBALS['temp']['dateRangeChecked'] = "";
	
	switch ($_SERVER['argv'][5]){
		case 1:					// All
			$GLOBALS['temp']['dateAllChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "1";
			$dateRangeSQL = "";
			break;
		case 2:					// Future
			$GLOBALS['temp']['dateFutureChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "2";
			
			$maxDate = $GLOBALS['lDB']->get("SELECT MAX(rt_period_to) FROM rt_period_dates",4);
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_from <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_to >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_from <= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to >= '".$maxDate."'
					)
				)
			";
			break;
		case 3:					// Date Range
			$GLOBALS['temp']['dateRangeChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "3";
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_from <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_to >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_from <= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to >= '".$toDate['jsDate']."'
					)
				)
			";			
			break;
			
	}
	
	// Filter periods on relevant date range first
	$sql = "
		SELECT
			rt_period_ix
		FROM
			rt_period
			INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
		WHERE 1
			$dateRangeSQL
			".$ratePeriodFilter['where']."
	";
	
	$dateFilterPeriodIds = $GLOBALS['lDB']->get($sql,3);
	$periodIdWhere = "AND rt_period_ix IN ('".join("','",$dateFilterPeriodIds)."')";
	
	$allResults = array();
	switch ($_SERVER['argv'][4]){
		case 1:					// accomm
			$GLOBALS['temp']['accommChecked'] = "checked";
			$GLOBALS['temp']['selectOpt'] = "1";

			if (!$ratePeriodFilter['ids']){
				$ratePeriodIds = $GLOBALS['lDB']->get("SELECT rt_period.rt_period_ix FROM rt_period",3);
				$ratePeriodFilter['ids'] = join(":", $ratePeriodIds);
			} else {
				$ratePeriodIds = explode(":",$ratePeriodFilter['ids']);
			}

			$newPeriodIds = array_intersect($dateFilterPeriodIds,$ratePeriodIds);
			
			if (!$rateTypeFilter['ids']){
				$rateTypeIds = $GLOBALS['lDB']->get("SELECT rt_rate_type.rt_rate_type_ix FROM rt_rate_type",3);
				$rateTypeFilter['ids'] = join(":", $rateTypeIds);
			}			

			foreach (explode(":",$rateTypeFilter['ids']) as $rate_type_id){
				foreach ($newPeriodIds as $rate_period_id){
					$selectsql = "
						SELECT
							ac_accomm_type.ac_accomm_type_ix,
							ac_accomm_type.ac_accomm_desc,
							rt_period.rt_period_ix,
							rt_period.rt_period_desc,
							rt_rate_type.rt_rate_type_ix,
							rt_rate_type.rt_rate_type_desc,
							pr_business.pr_bus_name_short,
							rt_period_dates.rt_period_from,
							rt_period_dates.rt_period_to
					";			
					$fromsql = "
						FROM
							ac_accomm_type
							LEFT JOIN rt_rate ON rt_rate.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
								AND	rt_rate.rt_period_id = '$rate_period_id'
								AND rt_rate.rt_rate_type_id = '$rate_type_id'
							INNER JOIN rt_period ON rt_period.rt_period_ix = '$rate_period_id'
							INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = '$rate_period_id'
							INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = '$rate_type_id'
							INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
						WHERE rt_rate.rt_rate_ix IS NULL AND rt_rate_type.rt_rate_type_inactive_yn = '0' 
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '0' 
							AND rt_period.rt_period_inactive_yn = '0' 
					";								
					$tempRecords = $GLOBALS['lDB']->get($selectsql.$fromsql,2);
					$allResults = array_merge($allResults, $tempRecords);
				}
			}

			// Build master array of Rates that do exist
			$existingRateSQL = "
				SELECT
					rt_rate.ac_accomm_type_id,
					rt_rate.rt_period_id,
					rt_rate.rt_rate_type_id,
					rt_period_dates.rt_period_from,
					rt_period_dates.rt_period_to
				FROM
					rt_rate
				INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_rate.rt_period_id
				WHERE rt_rate.rt_rate_type_id IN ('".join("','",explode(":",$rateTypeFilter['ids']))."')
			";
			$allExisting = $GLOBALS['lDB']->get($existingRateSQL,2);				
			break;
		case 2:					// rate period
			$GLOBALS['temp']['ratePeriodChecked'] = "checked";
			$GLOBALS['temp']['selectOpt'] = "2";
			if (!$accommFilter['ids']){
				$accommIds = $GLOBALS['lDB']->get("SELECT ac_accomm_type.ac_accomm_type_ix FROM ac_accomm_type",3);
				$accommFilter['ids'] = join(":", $accommIds);
			}
			
			if (!$rateTypeFilter['ids']){
				$rateTypeIds = $GLOBALS['lDB']->get("SELECT rt_rate_type.rt_rate_type_ix FROM rt_rate_type",3);
				$rateTypeFilter['ids'] = join(":", $rateTypeIds);
			}			
	
			$activeAccommTypes = $GLOBALS['lDB']->get(
				"
					SELECT
						ac_accomm_type_ix
					FROM
						ac_accomm_type
					WHERE
						ac_accomm_type_inactive_yn = '0'
						AND pr_business_id != ''
				",
				3
			);

			$activeRateTypes = $GLOBALS['lDB']->get(
				"
					SELECT
						rt_rate_type_ix
					FROM
						rt_rate_type
					WHERE
						rt_rate_type_inactive_yn = '0'
				",
				3
			);

			foreach (explode(":",$accommFilter['ids']) as $ac_accomm_id) {
				if (!in_array($ac_accomm_id, $activeAccommTypes)) {
					continue;
				}
				foreach (explode(":",$rateTypeFilter['ids']) as $rate_type_id) {
					if (!in_array($rate_type_id, $activeRateTypes)) {
						continue;
					}
					$tempRecords = $GLOBALS['lDB']->get("
						SELECT
							'$ac_accomm_id' as ac_accomm_type_ix,
							1 as ac_accomm_desc,
							rt_period.rt_period_ix,
							1 as rt_period_desc,
							'$rate_type_id' as rt_rate_type_ix,
							1 as rt_rate_type_desc,
							1 as pr_bus_name_short,
							rt_period_dates.rt_period_from,
							rt_period_dates.rt_period_to
						FROM
							rt_period
							INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
						WHERE
							rt_period.rt_period_inactive_yn = '0' 
							$periodIdWhere
					", 2);

					$allResults = array_merge($allResults, $tempRecords);
				}
			}

			// Build master array of Rates that do exist
			$existingRateSQL = "
				SELECT
					rt_rate.ac_accomm_type_id,
					rt_rate.rt_period_id,
					rt_rate.rt_rate_type_id,
					rt_period_dates.rt_period_from,
					rt_period_dates.rt_period_to
				FROM
					rt_rate
					INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_rate.rt_period_id
				WHERE
					rt_rate.rt_rate_type_id IN ('".join("','",explode(":",$rateTypeFilter['ids']))."')
					AND rt_rate.ac_accomm_type_id IN ('".join("','",explode(":",$accommFilter['ids']))."')
			";
			$allExisting = $GLOBALS['lDB']->get($existingRateSQL,2);	
			
			break;
		case 3:					// rate type
			$GLOBALS['temp']['rateTypeChecked'] = "checked";
			$GLOBALS['temp']['selectOpt'] = "3";
			if (!$accommFilter['ids']){
				$accommIds = $GLOBALS['lDB']->get("SELECT ac_accomm_type.ac_accomm_type_ix FROM ac_accomm_type",3);
				$accommFilter['ids'] = join(":", $accommIds);
			}
			
			if (!$ratePeriodFilter['ids']){
				$ratePeriodIds = $GLOBALS['lDB']->get("SELECT rt_period.rt_period_ix FROM rt_period",3);
				$ratePeriodFilter['ids'] = join(":", $ratePeriodIds);
			} else {
				$ratePeriodIds = explode(":",$ratePeriodFilter['ids']);
			}			
			
			$newPeriodIds = array_intersect($dateFilterPeriodIds,$ratePeriodIds);
			
			foreach (explode(":",$accommFilter['ids']) as $ac_accomm_id){
				foreach ($newPeriodIds as $rate_period_id){
					$selectsql = "
						SELECT
							ac_accomm_type.ac_accomm_type_ix,
							ac_accomm_type.ac_accomm_desc,
							rt_period.rt_period_ix,
							rt_period.rt_period_desc,
							rt_rate_type.rt_rate_type_ix,
							rt_rate_type.rt_rate_type_desc,
							pr_business.pr_bus_name_short,
							rt_period_dates.rt_period_from,
							rt_period_dates.rt_period_to
					";			
					$fromsql = "
						FROM
							rt_rate_type
							LEFT JOIN rt_rate ON rt_rate.rt_rate_type_id = rt_rate_type.rt_rate_type_ix
								AND	rt_rate.ac_accomm_type_id = '$ac_accomm_id'
								AND rt_rate.rt_period_id = '$rate_period_id'
							INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = '$ac_accomm_id'
							INNER JOIN rt_period ON rt_period.rt_period_ix = '$rate_period_id'
							INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = '$rate_period_id'
							INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
						WHERE rt_rate.rt_rate_ix IS NULL AND rt_rate_type.rt_rate_type_inactive_yn = '0' 
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '0' 
							AND rt_period.rt_period_inactive_yn = '0' 
					";				
					$tempRecords = $GLOBALS['lDB']->get($selectsql.$fromsql,2);
					$allResults = array_merge($allResults, $tempRecords);
				}
			}		
			
			// Build master array of Rates that do exist
			$existingRateSQL = "
				SELECT
					rt_rate.ac_accomm_type_id,
					rt_rate.rt_period_id,
					rt_rate.rt_rate_type_id,
					rt_period_dates.rt_period_from,
					rt_period_dates.rt_period_to
				FROM
					rt_rate
				INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_rate.rt_period_id
				WHERE rt_rate.ac_accomm_type_id IN ('".join("','",explode(":",$accommFilter['ids']))."')
			";
			$allExisting = $GLOBALS['lDB']->get($existingRateSQL,2);				
			
			break;		
	}

	// Build master array of Rates that do not exist
	$masterDoesntExist = array();
	$masterExist = array();
	foreach ($allResults as $tempRecord){
		$keystring = $tempRecord['ac_accomm_type_ix']."_".$tempRecord['rt_period_ix']."_".$tempRecord['rt_rate_type_ix'];
		if (!array_key_exists($keystring, $masterDoesntExist)){
			$masterDoesntExist[$keystring] = 
				array(
					"ac_accomm_type_ix" => $tempRecord['ac_accomm_type_ix'],
					"ac_accomm_desc" => $tempRecord['ac_accomm_desc'],
					"rt_period_ix" => $tempRecord['rt_period_ix'],
					"rt_period_desc" => $tempRecord['rt_period_desc'],
					"rt_rate_type_ix" => $tempRecord['rt_rate_type_ix'],
					"rt_rate_type_desc" => $tempRecord['rt_rate_type_desc'],
					"pr_bus_name_short" => $tempRecord['pr_bus_name_short'],
					"date_periods" => array(
						array (
							"rt_period_from" => $tempRecord['rt_period_from'],
							"rt_period_to" => $tempRecord['rt_period_to']
						))
				);
		} else {
			$masterDoesntExist[$keystring]['date_periods'][] = 
				array (
					"rt_period_from" => $tempRecord['rt_period_from'],
					"rt_period_to" => $tempRecord['rt_period_to']
				);
		}
	}
	
	foreach ($allExisting as $tempRecord){
		$keystring = $tempRecord['ac_accomm_type_id']."_".$tempRecord['rt_period_id']."_".$tempRecord['rt_rate_type_id'];
		if (!array_key_exists($keystring, $masterExist)){
			$masterExist[$keystring] = 
				array(
					"ac_accomm_type_id" => $tempRecord['ac_accomm_type_id'],
					"rt_period_id" => $tempRecord['rt_period_id'],
					"rt_rate_type_id" => $tempRecord['rt_rate_type_id'],
					"date_periods" => array(
						array (
							"rt_period_from" => $tempRecord['rt_period_from'],
							"rt_period_to" => $tempRecord['rt_period_to']
						))
				);
		} else {
			$masterExist[$keystring]['date_periods'][] = 
				array (
					"rt_period_from" => $tempRecord['rt_period_from'],
					"rt_period_to" => $tempRecord['rt_period_to']
				);
		}
	}

	$finalResult = array();
	$conflict = false;
	$withinDateRange = true;

	foreach ($masterDoesntExist as $a){
		$conflict = false;
		if (count($masterExist) > 0){
			foreach ($masterExist as $b){
				if (($a['ac_accomm_type_ix'] == $b['ac_accomm_type_id']) && ($a['rt_rate_type_ix'] == $b['rt_rate_type_id'])){
					if (checkPeriodOverlaps($a['date_periods'], $b['date_periods'])){
						$conflict = true;
					}
				}
			}

		} 
		
		if ($conflict == false){
			array_push($finalResult, $a);
		}				
	}

	// START PAGE HANDLING
	$totalRows = count($finalResult);
	$pageLength = $perPage;
	$pageCount = ceil($totalRows/$pageLength);

	if (trim($page) == "" || $page > $pageCount) {
		$page = "1";
	}
	
	$GLOBALS['temp']['pageCount'] = $pageCount;
	$GLOBALS['temp']['pageNum'] = $page;
	$GLOBALS['temp']['nextPageNum'] = $page+1;
	$GLOBALS['temp']['prevPageNum'] = $page-1;	



	if ($page == 1) {
		$GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
	} else {
		$GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
	}
	if ($page >= $GLOBALS['temp']['pageCount']) {
		$GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
	} else {
		$GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
	}
	$totalPages = ceil($totalRows/$pageLength);
	if (($totalPages - $page) < 2 ) {
		$startPage = $totalPages - 2;
	} elseif($page < 4) {
		$startPage = 4;
	} else {
		$startPage = $page;
	}
	if ($page != 1) {
		$pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
	} else {
		$pageList = "<B>1</B>";
	}
	for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
		if ($count == $page) {
			$pageList .= ", <B>$count</B>";
		} else {
			$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
		}
	}
	if (($totalPages - $page) > 3 ) {
		$pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
	}
	$GLOBALS['temp']['pageList'] = $pageList;

	//$limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
	$GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);

	$pageResults = array_slice($finalResult, (($page-1) * $pageLength ), $pageLength);

	if ($_SERVER['argv'][4] == "2") {		// Rate Period search option
		foreach ($pageResults as $key => $pageResult) {
			// Change: we cut down on the data fetched in the main SQL, in order to speed things up,
			// and here we fetch the missing data for the few records that make it to the paginated result.
			// This results in around 400% speed gains
			$descriptions = $GLOBALS['lDB']->get("
				SELECT
					ac_accomm_type.ac_accomm_desc,
					(
						SELECT
							rt_period_desc
						FROM
							rt_period
						WHERE
							rt_period_ix = '" . $pageResult['rt_period_ix'] . "'
					) as rt_period_desc,
					(
						SELECT
							rt_rate_type_desc
						FROM
							rt_rate_type
						WHERE
							rt_rate_type_ix = '" . $pageResult['rt_rate_type_ix'] . "'
					) as rt_rate_type_desc,
					pr_business.pr_bus_name_short
				FROM
					ac_accomm_type
					INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
				WHERE
					ac_accomm_type.ac_accomm_type_ix = '" . $pageResult['ac_accomm_type_ix'] . "'
			",1);
			$pageResults[$key]['ac_accomm_desc'] = $descriptions['ac_accomm_desc'];
			$pageResults[$key]['rt_period_desc'] = $descriptions['rt_period_desc'];
			$pageResults[$key]['rt_rate_type_desc'] = $descriptions['rt_rate_type_desc'];
			$pageResults[$key]['pr_bus_name_short'] = $descriptions['pr_bus_name_short'];
		}
	}

	// END PAGE HANDLING
	
	//$allResults = $GLOBALS['lDB']->get($selectsql.$fromsql.$limit,2);
	$rows = "";
	foreach($pageResults as $key=>$item) {
		$rows .= "<tr class=\"linkrow\" onclick=\"newRateConfirm('".$item['ac_accomm_type_ix']."', '".$item['rt_period_ix']."', '".$item['rt_rate_type_ix']."');\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">";
		$rows .= "<td class=\"br bb\"><input id=\"tick".$key."\" name=\"tick\" class=\"forminput\"  type=\"checkbox\" onclick=\"event.cancelBubble = true;\"></td>";
		$rows .= "	<td class=\"br bb\">&nbsp;".$item['pr_bus_name_short']."</td>";
		$rows .= "	<td class=\"br bb\">&nbsp;".$item['ac_accomm_desc']."</td>";
		$rows .= "	<td class=\"br bb\">&nbsp;".$item['rt_rate_type_desc']."</td>";
		$rows .= "	<td class=\"br bb\">&nbsp;".$item['rt_period_desc']."</td>";
		$rows .= "	<input id=\"detail".$key."\" type=\"hidden\" value=\"".$item['ac_accomm_type_ix'].":".$item['rt_period_ix'].":".$item['rt_rate_type_ix']."\"></input>";			
		$rows .= "</tr>";
	}
	$GLOBALS['temp']['rows'] = $rows;		
	$GLOBALS['temp']['recordCount'] = count($pageResults);
} else {
	$GLOBALS['temp']['resultsGenerated'] = " class=\"collapse\" ";
}

$GLOBALS['temp']['page'] = "<input type=\"hidden\" id=\"currentPage\" value=\"" . $page . "\">";

$newRelic->stop_transaction();