<?php
/**
 * init.form434.php - Rates Find Popup
 * Job: 423
 * Function: 58
 */

require_once(__DIR__ . '/functions.report.php');

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
} 

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_find_pop.htm");
}

$accommFilter = useFilter("accomm",$_SERVER['argv'][1],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","",false,false,false);	

$ratePeriodFilter = useFilter("ratePeriod",$_SERVER['argv'][2],"SELECT rt_period.rt_period_desc FROM rt_period WHERE rt_period.rt_period_ix=","",false,false,false);

$rateTypeFilter = useFilter("rate",$_SERVER['argv'][3],"SELECT rt_rate_type.rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =","",false,false,false);

$pageNum = $_SERVER['argv'][4];
if ($pageNum < 1) {
	$pageNum = "1";
}

//$GLOBALS['temp']['page'] = $page;
$GLOBALS['temp']['results'] = "collapse printCollapse";

if($_SERVER['argc'] > 1){
	$wheresql = "";

	$GLOBALS['temp']['results'] = "";
	$GLOBALS['temp']['resultsGenerated'] = "";

	if($accommFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.ac_accomm_type_id IN ('".join("','",preg_split("/:/",$accommFilter['ids']))."')";
	}
	
	if($ratePeriodFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_period_id IN ('".join("','",preg_split("/:/",$ratePeriodFilter['ids']))."')";
	}

	if($rateTypeFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_rate_type_id  IN ('".join("','",preg_split("/:/",$rateTypeFilter['ids']))."')";
	}

	$selectsql = "
		SELECT
			rt_rate.rt_rate_ix,
			pr_business.pr_bus_name_short,
			ac_accomm_type.ac_accomm_desc,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_name,
			rt_period.rt_period_desc,
			rt_rate.rt_rate_overide_level_ind,
			rt_rate.rt_rate_round_dir,
			rt_rate.rt_rate_round_scale,
			rt_rate.rt_rate_tba_yn,
			rt_rate.rt_rate_status_ind
	";
	
	$fromsql = "
		FROM
			rt_rate
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
		INNER JOIN rf_currency ON rt_rate_type.rf_currency_id  = rf_currency.rf_currency_ix 
		INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
		WHERE
			1
		$wheresql
	";

	// START PAGE HANDLING
	$totalRows = $lDB->get("SELECT COUNT(*) $fromsql",4);	
	$recordsPerPage = "35";
	$pages = $totalRows / $recordsPerPage;
	$intPages = ceil($pages);

	$recordStart = ($pageNum - 1) * $recordsPerPage;

	$GLOBALS['temp']['pageTotal'] = $intPages;
	$GLOBALS['temp']['pageCurrent'] = $pageNum;

	$nextStart = $recordStart + $recordsPerPage;
	$GLOBALS['temp']['next'] = "&nbsp;";
	$GLOBALS['temp']['prev'] = "&nbsp;";
	$GLOBALS['temp']['hidenextbutton'] = "display: none;";	

	if ($totalRows > $nextStart) {
		$GLOBALS['temp']['hidenextbutton'] = "";		
		$GLOBALS['temp']['next'] = "<input type=\"button\" style=\"width: 50px; height: 20px; font-size: 1em;\" class=\"button txtb\" onclick=\"findRates('".($pageNum+1)."')\" value=\"Next >>\" />";
	}

	if ($pageNum > "1") {
		$GLOBALS['temp']['hidenextbutton'] = "";

		$GLOBALS['temp']['prev'] = "<input type=\"button\" style=\"width: 50px; height: 20px; font-size: 1em;\" class=\"button txtb\" onclick=\"findRates('".($pageNum-1)."')\" value=\"<< Prev\" />";
	}	

	$limit = " LIMIT ".$recordStart.", ".$recordsPerPage;			
	
	// END PAGE HANDLING
	
	$rates = $GLOBALS['lDB']->get($selectsql.$fromsql.$limit,2);

	$rows = "";
	foreach($rates as $key=>$item) {
		$rateId = $item[0];

		$rows .= "<tr class='linkrow' onclick=\"select_rate('$item[rt_rate_ix]')\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">";
		$rows .= "<td class=\"br bb\">&nbsp;$item[pr_bus_name_short]</td>";
		$rows .= "<td class=\"br bb\">&nbsp;$item[ac_accomm_desc]</td>";
		$rows .= "<td class=\"br bb\">&nbsp;$item[rt_rate_type_desc]</td>";
		$rows .= "<td class=\"br bb\">&nbsp;$item[rt_period_desc]</td>";
		$rows .= "</tr>";
	}
	
	if ( $rows == "" ){
		$GLOBALS['temp']['rows'] = "
				<tr>\n
					<td align=\"center\">Your search did not match any results.</td>\n
				</tr>\n
		";
	} else {
		$GLOBALS['temp']['rows'] = "
			<tr class=\"outDk\">
				<td class=\"outLt\" width=\"60\">&nbsp;Property</td>
				<td class=\"outLt\" width=\"78\">&nbsp;Accomm</td>
				<td class=\"outLt\" width=\"78\">&nbsp;Rate Type</td>
				<td class=\"outLt\" width=\"78\">&nbsp;Period</td>
			</tr>  
		";
	
		$GLOBALS['temp']['rows'] .= $rows;	
	}
	
	
} else {
	$GLOBALS['temp']['rows'] = "
			<tr>\n
				<td align=\"center\">Enter your search parameters using the filters above, then click \"Search\"</td>\n
			</tr>\n
	";
	$GLOBALS['temp']['next'] = "&nbsp;";
	$GLOBALS['temp']['prev'] = "&nbsp;";
	$GLOBALS['temp']['hidenextbutton'] = "display: none;";		
}
