<?php

/*
 * $Id: init.form435.func.php,v 1.1 2012-11-29 15:26:05 light Exp $
 *
 * $Log: init.form435.func.php,v $
 * Revision 1.1  2012-11-29 15:26:05  light
 * Bug #7981 - RATES: Setup (Gym Light blue)
 *
 */

/**
 * init.form435.func.php - Copy rates
 */

function checkPeriodOverlaps($ranges1, $ranges2){
	foreach ($ranges1 as $range1){
		foreach ($ranges2 as $range2){
			if (checkPeriodOverlap($range1, $range2)){
				return true;
			}
		}
	}
	return false;
}

function checkPeriodOverlap($range1, $range2){
	if ((($range1['rt_period_from'] >= $range2['rt_period_from']) && ($range1['rt_period_from'] <= $range2['rt_period_to']))
		|| (($range1['rt_period_to'] >= $range2['rt_period_from']) && ($range1['rt_period_to'] <= $range2['rt_period_to']))
		|| (($range1['rt_period_from'] <= $range2['rt_period_from']) && ($range1['rt_period_to'] >= $range2['rt_period_to']))){
		return true;
	} else {
		return false;
	}
}

// This function assumes that this rate can be duplicated without conflict
function duplicateSingleRate($rateID,$ac_accomm_type_id, $rt_period_id, $rt_rate_type_id, $fromRateID){

	$fromRateComponents = getRateComponents($rateID);
	$fromRateHeader = getRateHeader($rateID);
	$fromRateCompGroupHeaders = getRateComponentGroupHeaders($rateID, 0);
	$fromRateGroupAmounts = getRateGroupAmts($rateID);

	$toRateID = rt_rate_insert(
		$ac_accomm_type_id, 
		$rt_period_id, 
		$rt_rate_type_id,
		$fromRateHeader['rt_rate_dist_yn'],
		$fromRateHeader['rt_rate_comm_yn'],
		$fromRateHeader['rt_rate_overide_level_ind'],
		$fromRateHeader['rt_rate_oride_comm_yn'],
		$fromRateHeader['rt_rate_ssupp_comm_yn'],
		$fromRateHeader['rt_rate_round_ind'],
		$fromRateHeader['rt_rate_round_dir'],
		$fromRateHeader['rt_rate_round_scale'],
		$fromRateHeader['rt_rate_waive_checks_yn'],
		$fromRateHeader['rt_rate_status_ind'],
		$fromRateHeader['rt_rate_tba_yn'],
		$fromRateHeader['rt_pax_rate_group_yn']
	);

	// Insert rate components

	foreach ($fromRateComponents as $fromRateComponent){
		$toRateComponentID = rt_rate_component_insert(
			$toRateID, 
			$fromRateComponent['rt_component_id'],
			$fromRateComponent['rt_comp_opt_yn'],
			$fromRateComponent['rt_comp_opt_def_yn'],
			$fromRateComponent['rt_comp_comm_yn'],
			$fromRateComponent['rt_comp_freq_ind'],
			$fromRateComponent['rt_comp_freq_factor'],
			$fromRateComponent['rt_comp_separate_yn'],
			$fromRateComponent['rt_tax_ind'],			
			$fromRateComponent['rt_tax_id'],
			$fromRateComponent['rt_comp_itin_yn'],
			$fromRateComponent['rt_comp_los_yn'],
			$fromRateComponent['rt_comp_round_ind']
		);	
		
		foreach($fromRateCompGroupHeaders as $fromRateCompGroupHeader){
		
			$fromRateComponentSplit = getRateComponentSplit($fromRateComponent['rt_rate_component_ix'], $fromRateCompGroupHeader['rt_rate_group_ix']);
		
			$toRateGroupID = rt_rate_comp_grp_insert(
				$toRateComponentID, 
				$fromRateCompGroupHeader['rt_rate_group_ix'], 
				$fromRateComponentSplit['rt_rate_comp_amt'], 
				$fromRateComponentSplit['rt_rate_comp_perc'],
				$fromRateComponentSplit['rt_rate_comp_grp_comm_yn'],
				$fromRateComponentSplit['rt_rate_comp_grp_seq']
			);				

		}

	}

	// For amounts, we only want to add the PAX group if pax only is selected
	if ($fromRateHeader['rt_pax_rate_group_yn'] == 1){
		$fromRateCompGroupHeaders = getRateComponentGroupHeaders($fromRateID,1);	
	}

	$toRateHeader = getRateHeader($toRateID);
	$maxCapacity = getAccommTypeMaxCapacity($toRateHeader['ac_accomm_type_ix']);

	foreach($fromRateGroupAmounts as $fromRateGroupAmount){
		foreach($fromRateCompGroupHeaders as $fromRateCompGroupHeader){		
			if ($fromRateGroupAmount['rt_rate_group_ix'] == $fromRateCompGroupHeader['rt_rate_group_ix'] && $fromRateGroupAmount['rt_rate_grp_amt_qty'] <= $maxCapacity){
				rt_rate_grp_amt_insert($toRateID, $fromRateGroupAmount['rt_rate_group_ix'], $fromRateGroupAmount['rt_rate_grp_amt_qty'], $fromRateGroupAmount['rateGroupTotal']);
			}
		}			
	}
}
