<?php

/**
 * init.form435.php - Copy and/or Duplicate Rates
 */

require_once(__DIR__ . '/functions.rates.php');

$action = isset($_POST['action']) ? $_POST['action'] : 1;

switch ($action) {
case 1:		// Copy 1 to many

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", "");
}

$fromRateID = $_SERVER['argv'][1];
$toRates = explode("_", $_SERVER['argv'][2]);

	// $fromRateComponents = getRateComponents($fromRateID);
	// $fromRateHeader = getRateHeader($fromRateID);
	// $fromRateCompGroupHeaders = getRateComponentGroupHeaders($fromRateID, 0);
	// $fromRateGroupAmounts = getRateGroupAmts($fromRateID);

$date_periods = array();
$conflict = false;
// The first thing we are going to want to do is check that any of the TO RATES do not overlap, as this is a possibility
// Build date_periods array
foreach ($toRates as $toRate){
	$detail = explode(":", $toRate);
	if (count($detail) == 3){
		$rt_period_id = $detail[1];

		$date_periods[$rt_period_id] = $GLOBALS['lDB']->get("
			SELECT
				rt_period_dates.rt_period_from,
				rt_period_dates.rt_period_to
			FROM
				rt_period_dates
			WHERE
				rt_period_dates.rt_period_id = '$rt_period_id';
		",2);
	}	
}

foreach ($toRates as $leftToRate){
	$leftDetail = explode(":", $leftToRate);
	if (count($leftDetail) == 3){
		$left_ac_accomm_type_id = $leftDetail[0];
		$left_rt_period_id = $leftDetail[1];
		$left_rt_rate_type_id = $leftDetail[2];

		foreach ($toRates as $rightToRate){
			$rightDetail = explode(":", $rightToRate);
			if (count($rightDetail) == 3){
				$right_ac_accomm_type_id = $rightDetail[0];
				$right_rt_period_id = $rightDetail[1];
				$right_rt_rate_type_id = $rightDetail[2];

				if ($left_ac_accomm_type_id == $right_ac_accomm_type_id && $left_rt_rate_type_id == $right_rt_rate_type_id){

					//eliminate same rate
					if ($left_rt_period_id != $right_rt_period_id){
						if (checkPeriodOverlaps($date_periods[$left_rt_period_id], $date_periods[$right_rt_period_id])){
							$conflict = true;
						}						
					}
				}
	
			}	

		}

	}	

}

if($conflict){
	echo "One or more of the rates you are trying to copy would cause a rate conflict. Please re-select your rates and try again.";
	exit;
}



foreach ($toRates as $toRate){
	$detail = explode(":", $toRate);
	if (count($detail) == 3){
		$ac_accomm_type_id = $detail[0];
		$rt_period_id = $detail[1];
		$rt_rate_type_id = $detail[2];
		$existingRateID = rt_rate_exists($ac_accomm_type_id, $rt_period_id, $rt_rate_type_id);
		if ($existingRateID){
			// delete rate
			rt_rate_grp_amt_delete($existingRateID);
			rt_rate_comp_grp_delete_by_rate($existingRateID);
			rt_rate_component_delete_by_rate($existingRateID);
			rt_rate_delete($existingRateID);
		}	

	} else {
		// If we were passed only one record per rate, we guess this is a Rate ID of an existing rate
		if (rt_rate_exists_by_id($detail[0])){
			// Get rate details to recreate later
			$toRateHeader = getRateHeader($detail[0]);
			$ac_accomm_type_id = $toRateHeader['ac_accomm_type_ix'];
			$rt_period_id = $toRateHeader['rt_period_ix'];
			$rt_rate_type_id = $toRateHeader['rt_rate_type_ix'];
			// delete rate
			rt_rate_grp_amt_delete($detail[0]);
			rt_rate_comp_grp_delete_by_rate($detail[0]);
			rt_rate_component_delete_by_rate($detail[0]);
			rt_rate_delete($detail[0]);		
		}
		
		
	}
	
		duplicateSingleRate($fromRateID,$ac_accomm_type_id, $rt_period_id, $rt_rate_type_id, $fromRateID);

		
	}

	echo "Rates successfully copied!";
	exit;
case 2:		// Duplicate rates (popup)
	
	
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rate_duplicate_popup.htm");
		}

	$fromRatesStrings = preg_split("/,/",$_POST['fromRates']);
	foreach($fromRatesStrings as $fromRatesString){
		$fromRatesAll[] = preg_split("/:/",$fromRatesString);
	}
	
	// Look for unique attributes that we can alter
	foreach ($fromRatesAll as $fromRate){
		// Rate Id
		// Accomm
		// Period
		// Rate Type
		$fromAccommTypeIds[] = $fromRate[1];
		$fromPeriodIds[] = $fromRate[2];
		$fromRateTypeIds[] = $fromRate[3];
	}

	$accommTypeEnabled = count(array_unique($fromAccommTypeIds)) == 1 ? true : false;
	$periodEnabled = count(array_unique($fromPeriodIds)) == 1 ? true : false;
	$rateTypeEnabled = count(array_unique($fromRateTypeIds)) == 1 ? true : false;

	$content_html = "";
	$accomm_types_html = "";
	$period_html = "";
	$rate_types_html = "";

	if ($accommTypeEnabled){

		$accomm_types_html = "
			<label for=\"accommTypeSelect\" style=\"display: inline-block; width: 110px;\">Accommodation Type </label>
			<select id=\"accommTypeSelect\">
		";

		$accomm_types = $lDB->get("
			SELECT
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_type.ac_accomm_desc,
				ac_accomm_type.ac_accomm_type_inactive_yn,
				pr_persona.pr_name_last
			FROM
				ac_accomm_type
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			ORDER BY
				pr_persona.pr_name_last ASC,
				ac_accomm_type.ac_accomm_desc ASC
		",2);

		foreach ($accomm_types as $accomm_type){
			if ($accomm_type['ac_accomm_type_inactive_yn'] != 0){
				$active = " *";
				$style = " style='font-style: italic; color: silver;'";
			} else {
				$active = "";
				$style = "";
			}

			if ($accomm_type['ac_accomm_type_ix'] == $fromAccommTypeIds[0]){
				$selected = "selected";
			} else {
				$selected = "";
	}
			$accomm_types_html .= "<option $selected $style value=\"".$accomm_type['ac_accomm_type_ix']."\">".$accomm_type['pr_name_last']." - ".$accomm_type['ac_accomm_desc'].$active."</option>";
		}
		$accomm_types_html .= "
			</select><br />
		";

	}

	if ($periodEnabled){

		$period_html = "
			<label for=\"periodSelect\" style=\"display: inline-block; width: 110px;\">Period </label>
			<select id=\"periodSelect\">
		";

		$periods = $lDB->get("
			SELECT
				rt_period.rt_period_ix,
				rt_period.rt_period_desc,
				rt_period.rt_period_inactive_yn
			FROM
				rt_period
			ORDER BY
				rt_period.rt_period_desc ASC
		",2);

		foreach ($periods as $period){
			if ($period['rt_period_inactive_yn'] != 0){
				$active = " *";
				$style = " style='font-style: italic; color: silver;'";
			} else {
				$active = "";
				$style = "";
			}

			if ($period['rt_period_ix'] == $fromPeriodIds[0]){
				$selected = "selected";
			} else {
				$selected = "";
		}			
			$period_html .= "<option $selected $style value=\"".$period['rt_period_ix']."\">".$period['rt_period_desc'].$active."</option>";
	}	
		$period_html .= "
			</select><br />
		";
	
}

	if ($rateTypeEnabled){

		$rate_types_html = "
			<label for=\"rateTypeSelect\" style=\"display: inline-block; width: 110px;\">Rate Type </label>
			<select id=\"rateTypeSelect\">
		";

		$rate_types = $lDB->get("
			SELECT
				rt_rate_type.rt_rate_type_ix,
				rt_rate_type.rt_rate_type_desc,
				rt_rate_type.rt_rate_type_inactive_yn
			FROM
				rt_rate_type
			ORDER BY
				rt_rate_type.rt_rate_type_desc ASC
		",2);

		foreach ($rate_types as $rate_type){
			if ($rate_type['rt_rate_type_inactive_yn'] != 0){
				$active = " *";
				$style = " style='font-style: italic; color: silver;'";
			} else {
				$active = "";
				$style = "";
			}
			if ($rate_type['rt_rate_type_ix'] == $fromRateTypeIds[0]){
				$selected = "selected";
			} else {
				$selected = "";
			}
			$rate_types_html .= "<option $selected $style value=\"".$rate_type['rt_rate_type_ix']."\">".$rate_type['rt_rate_type_desc'].$active."</option>";
		}	
		$rate_types_html .= "
			</select><br />
		";

	}

	if ($accommTypeEnabled || $periodEnabled || $rateTypeEnabled){
		$content_html .= "<p>You are attempting to duplicate ".count($fromRatesStrings)." rates.</p>";
		$content_html .= "<p>The following parameters can be changed:</p>";
		$content_html .= $accomm_types_html.$period_html.$rate_types_html;
		$content_html .= "<p>If you choose to continue, the system will first perform an overlap-check to ensure that there will be no period conflicts.  If a conflict is detected, the entire process will fail and you will need to start over.</p>";
		$content_html .= "<p>Please note that this process could take a while, depending on the number of rates that you are creating.</p>";


		$GLOBALS['temp']['fromRates'] = $_POST['fromRates'];

		
		$GLOBALS['temp']['button_continue_visibility'] = "";
	} else {
		$content_html .= "<p>You are attempting to duplicate ".count($fromRatesStrings)." rates.</p>";
		$content_html .= "<p>However, since there are no unique parameters across the selected rates, you cannot create duplicates.  Please refine your filters or select a different set of rates that includes at least one common Rate Type, Period or Accommodation Type.</p>";
		$GLOBALS['temp']['button_continue_visibility'] = "visibility: hidden;";
	}


	$GLOBALS['temp']['content'] = $content_html;

	break;
case 3:		// Duplicate rates (main function)

	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rate_duplicate_result.htm");
	}

	$fromRatesStrings = preg_split("/,/",$_POST['fromRates']);

	foreach($fromRatesStrings as $fromRatesString){
		$fromRatesAll[] = preg_split("/:/",$fromRatesString);
	}

	$newAccommTypeId = (isset($_POST['accommTypeSelect']) && $_POST['accommTypeSelect'] != "") ? $_POST['accommTypeSelect'] : false;
	$newPeriodId = (isset($_POST['periodSelect']) && $_POST['periodSelect'] != "") ? $_POST['periodSelect'] : false;
	$newRateTypeId = (isset($_POST['rateTypeSelect']) && $_POST['rateTypeSelect'] != "") ? $_POST['rateTypeSelect'] : false;

	$content_html = "";

	// Check for duplicates
	$conflict = false;
	$conflictRateIds = array();
	$sourceRates = array();
	foreach ($fromRatesAll as $fromRate){
		// Rate ID
		// Accomm
		// Period
		// Rate Type
		$testRate = array();
		$fromRateID = $fromRate[0];
		$testRate['ac_accomm_type_id'] = $newAccommTypeId ? $newAccommTypeId : $fromRate[1];
		$testRate['rt_period_id'] = $newPeriodId ? $newPeriodId : $fromRate[2];
		$testRate['rt_rate_type_id'] = $newRateTypeId ? $newRateTypeId : $fromRate[3];

		$testRateDateRanges = $GLOBALS['lDB']->get("
			SELECT
				rt_period_dates.rt_period_from,
				rt_period_dates.rt_period_to
			FROM
				rt_period_dates
			WHERE
				rt_period_dates.rt_period_id = '".$testRate['rt_period_id']."';
		",2);

		$possibleConflictDateRanges = $lDB->get("
			SELECT
				rt_period_dates.rt_period_from,
				rt_period_dates.rt_period_to
			FROM
				rt_rate
				INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_rate.rt_period_id
			WHERE
				rt_rate.ac_accomm_type_id = '".$testRate['ac_accomm_type_id']."'
				AND rt_rate.rt_rate_type_id = '".$testRate['rt_rate_type_id']."'
		",2);

		if (checkPeriodOverlaps($testRateDateRanges, $possibleConflictDateRanges)){
			$conflict = true;
			$conflictRateIds[$fromRateID] = $testRate;
		} else {
			$sourceRates[$fromRateID] = $testRate;
		}
	}

	if ($conflict){
		// Get all period names, rate type descriptions and accommodation names
		$accommNamesRaw = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_type.ac_accomm_type_ix,
				pr_persona.pr_name_last,
				ac_accomm_type.ac_accomm_desc
			FROM
				ac_accomm_type
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		",2);
		
		foreach ($accommNamesRaw as $accommName){
			$accommNames[$accommName['ac_accomm_type_ix']] = $accommName['pr_name_last']." - ".$accommName['ac_accomm_desc'];
		}

		$periodNamesRaw = $GLOBALS['lDB']->get("
			SELECT
				rt_period.rt_period_ix,
				rt_period.rt_period_desc
			FROM
				rt_period
		",2);
		
		foreach ($periodNamesRaw as $periodName){
			$periodNames[$periodName['rt_period_ix']] = $periodName['rt_period_desc'];
		}		

		$rateTypeNamesRaw = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_type.rt_rate_type_ix,
				rt_rate_type.rt_rate_type_desc
			FROM
				rt_rate_type
		",2);
		
		foreach ($rateTypeNamesRaw as $rateTypeName){
			$rateTypeNames[$rateTypeName['rt_rate_type_ix']] = $rateTypeName['rt_rate_type_desc'];
		}

		

		$content_html .= "<p>There was a problem!</p>";
		$content_html .= "<p>The following rates would be in conflict with other rates in the system.</p>";

		foreach ($conflictRateIds as $conflictRate){
			$content_html .= "<p>&nbsp;&nbsp;&nbsp;&nbsp;".$accommNames[$conflictRate['ac_accomm_type_id']]." / ".$rateTypeNames[$conflictRate['rt_rate_type_id']]." / ".$periodNames[$conflictRate['rt_period_id']]."</p>";	
		}

		$content_html .= "<p>No rates have been created!</p>";

		$GLOBALS['temp']['content'] = $content_html;
	} else {
		// Duplicate the rates
		foreach ($sourceRates as $rateID => $sourceRate){
			duplicateSingleRate($rateID,$sourceRate['ac_accomm_type_id'], $sourceRate['rt_period_id'], $sourceRate['rt_rate_type_id'], $fromRateID);
		}

		$content_html .= "<p>".count($sourceRates)." rates have been created.</p>";

		$GLOBALS['temp']['content'] = $content_html;
	}

	break;

}

	

