<?php

/**
 * init.form46.php - The Login statistics Report
 * Job: 123
 * Function: 60 (Report: Login Statistics)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/report_audit.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],10,"");

$randomId = $_SERVER['argv'][8];
$time 			= isset($_POST['time']) ? $_POST['time'] : "";
$serverFilter 	= isset($_POST['serverFilter']) ? $_POST['serverFilter'] : "";
$serverDrop 	= isset($_POST['serverDrop']) ? $_POST['serverDrop'] : "";
$external 		= isset($_POST['type_ext']) ? $_POST['type_ext'] : "";
$internal 		= isset($_POST['type_int']) ? $_POST['type_int'] : "";
$admin 			= isset($_POST['type_adm']) ? $_POST['type_adm'] : "";
$butRow 		= isset($_POST['butRow']) ? $_POST['butRow'] : "";
$timezone 		= isset($_POST['timezoneFilter']) ? $_POST['timezoneFilter'] : date("e");

// variables from buildURL
$dateRange = $_SERVER['argv'][1];
$server = $_SERVER['argv'][2];
$serverFilterPdf = $_SERVER['argv'][3];
$intPdf = $_SERVER['argv'][4];
$extPdf = $_SERVER['argv'][5];
$admPdf = $_SERVER['argv'][6];
$options = $_SERVER['argv'][7];

// Reports to hide filters by default
$filterStatus = isset($_POST['filterStatus']) ? $_POST['filterStatus'] : "";
$filterButtonText = isset($_POST['showHideButtonText']) ? $_POST['showHideButtonText'] : "";
$showHideButtonText = isset($_POST['showHideButtonText']) ? $_POST['showHideButtonText'] : "";
	 
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

$printString = "";
$pString = "";

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($butRow == "hideAll") {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
$timezonePDF = (!empty($_SERVER['argv'][9])) ? $_SERVER['argv'][9] : date("e");

$GLOBALS['temp']['timezoneName'] = $timezone;
$GLOBALS['temp']['timezoneFilterContainer'] = timezoneFilterContainerHTML();

define("REP_VIEW_HTML", 0);
define("REP_VIEW_PDF", 1);
define("REP_EMAIL_PDF", 2);
define("REP_SEND_PDF", 3);
define("REP_VIEW_CSV", 4);

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
	break;
}

// renaming of post variables for pdf
if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$time = $dateRange;
	$serverDrop = $server;
	$serverFilter = $serverFilterPdf;
	$external = $extPdf;
	$internal = $intPdf;
	$admin = $admPdf;
	$userList = "";
	if($intPdf == "1"){
		$userList .= "Internal ";
	}
	if($extPdf == "1"){
		$userList .= "External ";
	}
	if($admPdf == "1"){
		$userList .= "Public ";
	}
}
if ($renderMode == "pdf" && $renderType == "email") {
	$pdfName = "Login Statistics report";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+", array_slice($_SERVER['argv'],0,7))."+$newOptions";
	$GLOBALS[$form]->FormHTML = str_replace("!formAction!", $formAction,
		str_replace("!attachmentInfo!", $attachmentTable,
		str_replace("!attachmentName!", $pdfName.".pdf",
		str_replace("!hasAttachment!", "expand",
		str_replace("!emailBody!", "",
		str_replace("!emailSubject!", $pdfName,
		join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
	// get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);
	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("SELECT pr_persona.pr_email FROM pr_persona WHERE pr_persona.pr_persona_ix = '$userId'", 4);
	$GLOBALS['temp']['emailTo'] = "";
}
if ($renderMode == "html") {
	$page = "1";
	if (isset($_POST['pageid']) && $_POST['pageid'] > "1") {
		$page = $_POST['pageid'];
	}
	$GLOBALS['temp']['pageid'] = (string) $page;
	$sortBy = isset($_POST['orderby']) ? (string) $_POST['orderby'] : "";
	$range = range(0,7);
	if (!in_array($sortBy,$range) || $sortBy == "") {
		$sortBy = (string) 0;
	}
	$GLOBALS['temp']['orderby'] = (string) $sortBy;

	$GLOBALS['temp']['style'] = "";
	if ($time == "" && $external == "" && $internal == ""&& $admin == "") {
		$GLOBALS['temp']['style'] = "style=\"display: none\" ";
	}
}

$year = date("Y");
$month = date("m");
$day = date("d");
$hour = date("H");
$minute = date("i");
$second = date("s");
if ($renderMode == "html") {
	$GLOBALS['temp']['chk_month'] = "";
	$GLOBALS['temp']['chk_week'] = "";
	$GLOBALS['temp']['chk_day'] = "";
	$GLOBALS['temp']['chk_int'] = "";
	$GLOBALS['temp']['chk_ext'] = "";
	$GLOBALS['temp']['chk_adm'] = "";
}
if ($time == "month") {
	$month--;
	$GLOBALS['temp']['chk_month'] = " checked";
} elseif ($time == "week") {
	$day = $day - 7;
	$GLOBALS['temp']['chk_week'] = " checked";
} elseif ($time == "day") {
	$day--;
	$GLOBALS['temp']['chk_day'] = " checked";
} else {
	$GLOBALS['temp']['chk_all'] = " checked";
}

$fromdate = date("d M Y",mktime($hour,$minute,$second,$month,$day,$year));
$todate = date("d M Y");

$GLOBALS['temp']['daterange'] = $fromdate." to ".$todate;

if ($time != "all") {
	$start = date("Y-m-d H:i:s",mktime($hour,$minute,$second,$month,$day,$year));
} else {
	$GLOBALS['temp']['daterange'] = "Full Report";
}
if ($renderMode == "html") {
	$GLOBALS['temp']['datetime_sort_asc'] = "/resource/Resrequest/Application/public/img/arrow_ascend_std.gif";
	$GLOBALS['temp']['datetime_sort_desc'] = "/resource/Resrequest/Application/public/img/arrow_descend_std.gif";
	$GLOBALS['temp']['server_sort_asc'] = "/resource/Resrequest/Application/public/img/arrow_ascend_std.gif";
	$GLOBALS['temp']['server_sort_desc'] = "/resource/Resrequest/Application/public/img/arrow_descend_std.gif";
	$GLOBALS['temp']['addrlink_sort_asc'] = "/resource/Resrequest/Application/public/img/arrow_ascend_std.gif";
	$GLOBALS['temp']['addrlink_sort_desc'] = "/resource/Resrequest/Application/public/img/arrow_descend_std.gif";
	$GLOBALS['temp']['namelast_sort_asc'] = "/resource/Resrequest/Application/public/img/arrow_ascend_std.gif";
	$GLOBALS['temp']['namelast_sort_desc'] = "/resource/Resrequest/Application/public/img/arrow_descend_std.gif";
	$GLOBALS['temp']['usertype_sort_asc'] = "/resource/Resrequest/Application/public/img/arrow_ascend_std.gif";
	$GLOBALS['temp']['usertype_sort_desc'] = "/resource/Resrequest/Application/public/img/arrow_descend_std.gif";
	$order = "
		ORDER BY
	";


	switch ($sortBy) {
	case 0:
		$GLOBALS['temp']['datetime_sort_asc'] = str_replace("std","down",$GLOBALS['temp']['datetime_sort_asc']);
		$order .= "ad_user_log.ad_date_time desc";
		break;
	case 1:
		$GLOBALS['temp']['datetime_sort_desc'] = str_replace("std","down",$GLOBALS['temp']['datetime_sort_desc']);
		$order .= "ad_user_log.ad_date_time asc";
		break;
	case 2:
		$GLOBALS['temp']['server_sort_asc'] = str_replace("std","down",$GLOBALS['temp']['server_sort_asc']);
		$order .= "ad_user_log.ad_user_log_db asc";
		break;
	case 3:
		$GLOBALS['temp']['server_sort_desc'] = str_replace("std","down",$GLOBALS['temp']['server_sort_desc']);
		$order .= "ad_user_log.ad_user_log_db desc";
		break;
	case 4:
		$GLOBALS['temp']['namelast_sort_asc'] = str_replace("std","down",$GLOBALS['temp']['namelast_sort_asc']);
		$order .= "ad_user_log.pr_name_last asc";
		break;
	case 5:
		$GLOBALS['temp']['namelast_sort_desc'] = str_replace("std","down",$GLOBALS['temp']['namelast_sort_desc']);
		$order .= "ad_user_log.pr_name_last desc";
		break;
	case 6:
		$GLOBALS['temp']['usertype_sort_asc'] = str_replace("std","down",$GLOBALS['temp']['usertype_sort_asc']);
		$order .= "ad_user_log.sc_grp_desc asc";
		break;
	case 7:
		$GLOBALS['temp']['usertype_sort_desc'] = str_replace("std","down",$GLOBALS['temp']['usertype_sort_desc']);
		$order .= "ad_user_log.sc_grp_desc desc";
		break;
	}
}

$order = isset($order) ? $order : "";

if ($external == 0 && $internal == 0 && $admin == 0) {
	$external = 1;
	$internal = 1;
	$admin = 1;
}

$sqlflags['x'] = $external;
$sqlflags['i'] = $internal;
$sqlflags['a'] = $admin;

// Server drop down
$GLOBALS[$form]->AddField("serverDrop","serverDrop",$serverDrop,3);

$serverArray = combolist($lDB,"
	SELECT
		rf_db_code as code,
		'' as x,
		rf_db_description
	FROM
		rf_database
	ORDER BY
		rf_db_description
");
if ($renderMode == "html") {
	$GLOBALS['serverDrop']->Select($serverArray);
	$GLOBALS['serverDrop']->AlwaysOn = 1;
	$GLOBALS['serverDrop']->StyleType = "txt";
	$GLOBALS['serverDrop']->Width = 150;
	$GLOBALS['serverDrop']->Size = 50;

	$GLOBALS['temp']['selAll'] = "checked";
	$GLOBALS['temp']['selOne'] = "";
}

switch ($serverFilter) {
case "all":
	# All servers
	$serverName = "";
	$GLOBALS['temp']['selAll'] = "checked";
	break;
case "select":
	# Choose server
	$serverName = "AND ad_user_log.ad_user_log_db = '$serverDrop'";
	$GLOBALS['temp']['selOne'] = "checked";
	break;
default:
	# All servers
	$serverName = "";
	$GLOBALS['temp']['selAll'] = "checked";
	break;
}

$ccount = 0;
$pcount = 0;
foreach ($sqlflags as $item) {
	if ($item == "1") $ccount++;
}

$usertype = " AND (";

if ($sqlflags['x'] == "1") {
	$usertype .= " ad_user_log.ad_user_status = '1'";
	$GLOBALS['temp']['chk_ext'] = " checked";
	$pcount++;
}

if ($sqlflags['i'] == "1") {
	if ($ccount > 0 && $pcount > 0) {
		$usertype .= " OR";
	}
	$usertype .= " ad_user_log.ad_user_status = '2'";
	$GLOBALS['temp']['chk_int'] = " checked";
	$pcount++;
}

if ($sqlflags['a'] == "1") {
	if ($ccount > 0 && $pcount > 0) {
		$usertype .= " OR";
	}
	$usertype .= " ad_user_log.ad_user_status = '0'";
	$GLOBALS['temp']['chk_adm'] = " checked";
	$pcount++;
}
$usertype .= ") ";

$start = isset($start) ? $start : date("Y-m-d H:i:s",mktime($hour,$minute,$second,$month,$day,$year));
$startpoint = isset($startpoint) ? $startpoint : "";
$startcount = "";
if ($time != "all") {
	$startpoint = " AND ad_user_log.ad_date_time > '$start' ";
	$startcount = " AND ad_user_log.ad_date_time > '$start'";
}
$listsql = "
	SELECT
		COUNT(*)
	FROM
		ad_user_log
		INNER JOIN pr_user ON pr_user.pr_user_id = ad_user_log.pr_user_id
	WHERE
		1
		$startcount
		$usertype
";
$count = $lDB->get($listsql,1);
if ($renderMode == "html") {
	$pLimit = "10";
	$limit = "35";

	$total = $count[0];
	$realCount = (string) $total / $limit;
	$erg = explode(".",$realCount);
	$pCount = (int) $realCount;
	if (isset($erg[1]) && $erg[1] != "") {
		$pCount += "1";
	}
	if ($pLimit > $pCount) {
		$pLimit = $pCount;
	}

	$pStart = $page - (int) ($pLimit/2);
	$page--;
	if ($pStart < "1") {
		$pStart = "1";
	}
	if ($pStart > $pCount) {
		$pStart = $pCount;
	}
	$pEnd = $pStart+$pLimit;
	if ($pEnd > $pCount) {
		$pEnd = $pCount+1;
	}
	if ($page > $pEnd) {
		$page = $pEnd-1;
	}
	$start = $page * $limit;
	$dbLimit = " LIMIT ".$start.", ".$limit;

	# Generate the page breaks
	$printString .= "<a class=txt> of ".$pCount." page(s)</a>";
	$pString .= "<a class=txtbr>Pages:</a> ";
	if ($pStart > "1") {
		$pString .= "<a href=\"javascript:ShowFrom(1);\" class=txtbr>First</a>, ";
	}
	for($i=$pStart;$i<$pEnd;$i++) {
		if ($i != $pStart) {
			$pString .= ", ";
		}
		$pString .= "<a class=txtbr";
		if ($i != $page+1) {
			$pString .= " href=\"javascript:ShowFrom($i);\"";
		}
		$pString .= ">".$i."</a>";
	}
	if ($pEnd < $pCount) {
		$pString .= "<a class=txtbr>...</a> <a href=\"javascript:ShowFrom(".$pCount.");\" class=txtbr>Last</a>";
	}
	$pString .= "<a class=txtbr> of ".$pCount." page(s)</a>";

	$GLOBALS['temp']['hideNext'] = "";
	$GLOBALS['temp']['hidePrev'] = "";
	$pNext = $page+2;
	$pPrev = $page;
	$GLOBALS['temp']['pNext'] = (string) $pNext;
	$GLOBALS['temp']['pPrev'] = (string) $pPrev;
	if ($page+2 > $pCount) {
		$GLOBALS['temp']['hideNext'] = " style=\"visibility:hidden;\"";
	}
	if ($page < "1") {
		$GLOBALS['temp']['hidePrev'] = " style=\"visibility:hidden;\"";
	}
} else {
	$dbLimit = "";
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$serverSelect = $lDB->get("SELECT rf_db_description FROM rf_database WHERE rf_database.rf_db_code = '$server'",4);
		if($serverSelect == "0"){
			$serverSelect = "All";
		}
		$pdf = new PDF("Login Statistics Report");
		// Main PDF header
		$reportLabel = "Login Statistics";
		$headerArray = array(
			array('name'=>"User Type", 'value'=>$userList),
			array('name'=>"Date Range", 'value'=>$dateRange),
			array('name'=>"Server", 'value'=>$serverSelect),
			array('name'=>"Timezone display", 'value'=>$timezonePDF)
		);
		$pdf->ReportHeader($reportLabel, $headerArray);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
	}
}

$RecordListSQL = "
	SELECT DISTINCT
		ad_user_log.ad_date_time,
		ad_user_log.ad_date_time_tz,
		ad_user_log.ad_ip_address,
		ad_user_log.pr_user_id,
		ad_user_log.pr_name_last,
		ad_user_log.pr_name_first,
		pr_user.pr_user_name,
		ad_user_log.pr_user_id,
		ad_user_log.ad_user_status,
		ad_user_log.sc_grp_desc,
		ad_user_log.ad_user_log_db,
		rf_database.rf_db_description,
		pr_link.pr_link_to,
		pr_persona.pr_name_last as relation
	FROM
		ad_user_log
		INNER JOIN pr_user ON ad_user_log.pr_user_id = pr_user.pr_user_id
		LEFT JOIN rf_database ON rf_database.rf_db_code = ad_user_log.ad_user_log_db
		LEFT JOIN pr_link ON pr_link.pr_link_from = ad_user_log.pr_user_id                     
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
	WHERE		
		1
		$startpoint
		$usertype
		$serverName
		$order
		$dbLimit
";
	 
/*
	External users should only see entries that are linked to their agent
	This code should replace the pr_link LEFT JOIN for external users
	Except it doesn't work:
		INNER JOIN pr_link ON pr_link.pr_link_from = '$calAgentId'
*/
$tempcount[0] = isset($tempcount[0]) ? $tempcount[0] : 0;
$GLOBALS['temp']['numrows'] = $tempcount[0];
$RecordCount = $tempcount[0];
$Limit = $RecordCount;

$linkednames = array();
if ($count != "0") {
	$recordid = $lDB->get($RecordListSQL,2);
	for ($i = 0; $i < sizeof($recordid); $i++) {
		$relationship_id = "";
		$relationship = "";
		$persona_id = "";
		$timebit = explode(" ",$recordid[$i]['ad_date_time']);
		$ip_address = $recordid[$i]['ad_ip_address'];
		$persona_id = $recordid[$i]['pr_user_id'];
		$last = $recordid[$i]['pr_name_last'];
		$first = $recordid[$i]['pr_name_first'];
		$user = $recordid[$i]['pr_user_name'];
		$access = $recordid[$i]['ad_user_status'];
		$role = $recordid[$i]['sc_grp_desc'];
		$original_timezone = $recordid[$i]['ad_date_time_tz'];

		$server = $recordid[$i]['rf_db_description'];
		if ($persona_id != "") {
			$date = $timebit[0];
			$t8x = explode("-",$date);
			$dyear = (integer) $t8x[0];
			$dmonth = (integer) $t8x[1];
			$dday = (integer) $t8x[2];
			if ($dyear <= "1980") { $dyear = "1980"; }
			if ($dmonth == "00") { $dmonth = "01"; }
			if ($dday == "00") { $adday = "01"; }
			$date = date("d M Y",mktime (0,0,0,$dmonth,$dday,$dyear));
			$time = $timebit[1];

			$name = $last;
			if ($first != "") {
				$name .= ", ".$first;
			}

			$rel = $recordid[$i]['relation'];
			$GLOBALS['temp']['rows'] = isset($GLOBALS['temp']['rows']) ? $GLOBALS['temp']['rows'] : "";

			if ($renderMode == "html") {
				if (strlen($rel) < 15){
					$relationship = substr($rel,0,15);
				} else {
					$relationship = substr($rel,0,15)."...";
				}

				if (strlen($user) < 12){
					$user = substr($user,0,12);
				} else {
					$user = substr($user,0,12)."...";
				}

				if (strlen($role) < 12){
					$role = substr($role,0,12);
				} else {
					$role = substr($role,0,12)."...";
				}

				if (strlen($name) < 23){
					$name = substr($name,0,23);
				} else {
					$name = substr($name,0,23)."...";
				}
				if($server == "Reservations Office"){
					$server = "Res Office";
				}

				$date = convertDateTimeZone($recordid[$i]['ad_date_time'], $original_timezone, $timezone);
				
				$GLOBALS['temp']['rows'] .= "
					<tr>
						<td valign=\"top\" height=\"20\" class=\"bl br\">".$date['date']."&nbsp;</td>
						<td valign=\"top\" class=\"br\"><span title=\"Original time zone: ".$original_timezone.", displaying ".$timezone."\">".$date['time']."&nbsp;</span></td>
						<td valign=\"top\" class=\"br\">$server&nbsp;</td>
						<td valign=\"top\" class=\"br\">$relationship&nbsp;</td>
						<td valign=\"top\" class=\"br\">$name&nbsp;</td>
						<td valign=\"top\" class=\"br\">$user&nbsp;</td>
						<td valign=\"top\" class=\"br\">$role&nbsp;</td>
					</tr>
				";
			}
		}
	}
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		auditPDF($pdf, $recordid, $_SERVER['argv'][1], $timezonePDF);
		$dbLimit = "";
	}
} else {
	if ($renderMode == "html") {
		$it = "<tr class='txt' height='20'><td height='20' class='bl br' colspan=6 align=center>&nbsp;&nbsp;No data matched your filter criteria</td></tr>";
		$GLOBALS['temp']['rows'] = $it;
	}
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		noPdfResults();
	}
}

function noPdfResults() {
	$noResults = array();
	array_push($noResults,
		array('data'=>"This is the function for displaying pdf note for no results")
	);
	$pdf->Row($noResults);
}

function auditPDF(&$pdf, &$recordid, &$dateRange, $timezonePDF) {
	$pdf->Ln(2);
	$dateRangeRow = array();
	array_push($dateRangeRow,
		array('data'=>"Date Range: ".urldecode($dateRange), 'border'=>"LTRB", 'fill'=>1, 'style'=>"B")
	);
	$pdf->Row($dateRangeRow);

	$headRow = array();
	array_push($headRow,
		array('width'=>"10%", 'data'=>"Date", 'border'=>"LBT", 'fill'=>1),
		array('width'=>"8%", 'data'=>"Time In", 'border'=>"LBT", 'fill'=>1),
		array('width'=>"14%", 'data'=>"Server", 'border'=>"LBT", 'fill'=>1),
		array('width'=>"20%", 'data'=>"Relationship", 'border'=>"LBT", 'fill'=>1),
		array('width'=>"22%", 'data'=>"Name", 'border'=>"LBT", 'fill'=>1),
		array('width'=>"14%", 'data'=>"User Name", 'border'=>"LBT", 'fill'=>1),
		array('width'=>"12%", 'data'=>"Role", 'border'=>"LBTR", 'fill'=>1)
	);
	$pdf->Row($headRow);

	foreach($recordid as $item) {
		$pdfFontSize = 7;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$dateTime = explode(" ",$item['ad_date_time']);
		$rows = array();
		$original_timezone = $item['ad_date_time_tz'];

		$date = convertDateTimeZone($item['ad_date_time'], $original_timezone, $timezonePDF);

		array_push($rows,
			array('width'=>"10%", 'data'=>$date['date'], 'border'=>"LB"),
			array('width'=>"8%", 'data'=>$date['time'], 'border'=>"LB"),
			array('width'=>"14%", 'data'=>$item['rf_db_description'], 'border'=>"LB"),
			array('width'=>"20%", 'data'=>$item['relation'], 'border'=>"LB"),
			array('width'=>"22%", 'data'=>$item['pr_name_last'], 'border'=>"LB"),
			array('width'=>"14%", 'data'=>$item['pr_user_name'], 'border'=>"LB"),
			array('width'=>"12%", 'data'=>$item['sc_grp_desc'], 'border'=>"LBR")
		);
		$pdf->Row($rows);
	}
}

if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
	if ($renderType == "view") {
		if (isset($GLOBALS['showTime']) && $GLOBALS['showTime'] == true) {
			$GLOBALS['timeEnd'] = getmicrotime();
			$timeTaken = $GLOBALS['timeEnd'] - $GLOBALS['timeStart'];
			$pdf->Ln(10);
			$resSize = sizeof($resArray);
			if ($resSize == 0) {
				$resSize = 1;
			}
			$pdf->Row(array(
				array('data' => "Time taken: ".$timeTaken." seconds, ".($timeTaken/$resSize. " per record, total records ".sizeof($resArray)))
			));
		}
		$pdf->OutPut();
		die();
	}
	if ($renderType == "send") {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];
		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
		// close the pdf
		if ($pdf->state < 3)
			$pdf->Close();
			/* and now mail it */
			if ($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Login Statistics report_$dateRange.pdf";
			}
			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'], $pdf->buffer, $pdfName);
			// (from, to, subject, headers, message, action, emailID, resID)
			if (!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
	}
}
$GLOBALS['temp']['hideAll'] = "0";
if ($renderMode == "html") {
	if (!isset($GLOBALS['temp']['rows']) || $GLOBALS['temp']['rows'] == "") {
		$it ="
			<tr class='txt' height='20'>
				<td height='20' class='bl br' colspan=7 align=center>&nbsp;&nbsp;No data matched your filter criteria</td>
			</tr></a>
		";
		$GLOBALS['temp']['rows'] = $it;
	} else {
		$GLOBALS['temp']['hideAll'] = "1";
	}
}

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

$GLOBALS[$form]->Arguments = "123";

$GLOBALS['temp']['ofnum'] = $printString;
$GLOBALS['temp']['nextprev'] = $pString;
$GLOBALS['temp']['limited'] = isset($total) ? (string) $total : "";

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone, rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	",4);
	if(trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if(trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if(trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
