<?php

/**
 * init.form49.php - This dataset is for the small item listing we generate at the bottom of the reservation screens
 * Job: 0, 1, 2, 3, 4, 30
 * Function: 52 (Reservation: Maintenance)
 */
   
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"","");
	$GLOBALS[$form]->FormHTML = " ";
}

$record = $_SERVER['argv'][1];

$reservationId	= $record;

// Get total for extras for this reservation ----------------------------------
$resAmt				= getDisplayResTotals($reservationId);
$paymentPlan	= getPayItems($reservationId);

$currencyCheck = $GLOBALS['lDB']->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '$record'",4);

if ( $currencyCheck > 1 ) {
	$GLOBALS['tagList']['total_gross']				= setNewValue("Multi-currency");
	$GLOBALS['tagList']['payedTotal']					= setNewValue("Multi-currency");
	$GLOBALS['tagList']['payOutstanding']			= setNewValue("Multi-currency");
	$GLOBALS['tagList']['totalResCost']				= setNewValue("Multi-currency");
	$GLOBALS['tagList']['extra_travel_total']	= setNewValue("Multi-currency");
	$GLOBALS['tagList']['invCurrSym']					= setNewValue("");
} else {
	$resDB		= $GLOBALS['lDB']->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '" . $reservationId . "'",4);
	$resEnv		= $GLOBALS['lDB']->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '" . $resDB . "'",4);
	$invCurr	= $GLOBALS['lDB']->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '" . $reservationId . "'",4);
	$resAmt		= $GLOBALS['lDB']->get("SELECT rv_amt_paid FROM rv_reservation WHERE rv_reservation_ix = '" . $reservationId . "'",4);
	
	fixAmtDisplay($resAmt,2);	

	$resTotals = $GLOBALS['lDB']->get("
		SELECT
			rv_amt_accomm_gross,
			rv_amt_extra_gross,
			rv_amt_travel_gross,
			rv_amt_accomm_payable,
			rv_amt_extra_payable,
			rv_amt_travel_payable
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '" . $reservationId . "'
	",1);
	
	if ( $resTotals['rv_amt_accomm_gross'] == null || $resTotals['rv_amt_extra_gross'] == null || $resTotals['rv_amt_travel_gross'] == null ) {
		$resTotal = "TBA";
	} else {
		$resTotal = $resTotals['rv_amt_accomm_payable'] + $resTotals['rv_amt_extra_payable'] + $resTotals['rv_amt_travel_payable'];
		fixAmtDisplay($resTotal,2);
	}
	
	if ( $resTotals['rv_amt_accomm_gross'] == null ) {
		$resAccommTotal = "TBA";
	} else {
		$resAccommTotal = $resTotals['rv_amt_accomm_payable'];
		fixAmtDisplay($resAccommTotal,2);
	}
	
	if ( $resTotals['rv_amt_extra_gross'] == null || $resTotals['rv_amt_travel_gross'] == null ) {
		$resExtraTotal = "TBA";
	} else {
		$resExtraTotal = $resTotals['rv_amt_extra_payable'] + $resTotals['rv_amt_travel_payable'];
		fixAmtDisplay($resExtraTotal,2);
	}

	if ( $resTotal == "TBA" ) {
		$resOutstanding = "TBA";
	} else {
		$resOutstanding = $resTotal - $resAmt;
		fixAmtDisplay($resOutstanding,2);
	}
	
	$GLOBALS['tagList']['total_gross']				= setNewValue($resTotal);
	$GLOBALS['tagList']['payedTotal']					= setNewValue($resAmt);
	$GLOBALS['tagList']['payOutstanding']			= setNewValue($resOutstanding);
	$GLOBALS['tagList']['totalResCost']				= setNewValue($resAccommTotal);
	$GLOBALS['tagList']['extra_travel_total'] = setNewValue($resExtraTotal);
}

$list = $lDB->get(
	"SELECT 
		rv_reservation_item_ix 
	FROM 
		rv_reservation_item 
	WHERE 
		rv_reservation_id = '" . $record . "' 
	ORDER BY 
		rv_item_date_arrive,
		rv_item_date_depart,
		pr_business_id,
		ac_accomm_type_id
	",3);

$rowHTMLA			= join("",file(__DIR__ . "/../../../public/html/reservation_item_row.htm"));
$rowHTMLB			= join("",file(__DIR__ . "/../../../public/html/reservation_item_row_view.htm"));
$summrowHTML	= join("",file(__DIR__ . "/../../../public/html/reservation_item_summ_row.htm"));  
$rowHTML			= $rowHTMLA;

$GLOBALS['temp']['rv_split_items'] = "";
$rf_currency_symbol = getInvCurrSymbol($record);
$rv_split_items = array();
$editItem = array();
$imax = sizeof($list);
$lastArrive = "";
$lastDepart = "";
$lastProperty = "";
$out = "";
$summout = "";

$isPublicOrExternal = $userStatusId < 2;		// 0 - Public, 1 - External
$internalOnly = $isPublicOrExternal ? 'collapse' : '';

$resRate = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
for ( $i = 0; $i < $imax; $i++ ) {
	$itemId = $list[$i];
	$resItem = getItemDetails($itemId);

	$resItem['rt_rate_type_desc_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($resItem['rt_rate_type_desc'])));
	$special = itemSpecialItinLineIndicator($itemId);

	$resItem['rateLabel'] = "Rte".$special;
	$resItem['rate_text_colour'] = "";
	if($resRate != $resItem['rt_rate_type_id']) {
		$resItem['rateLabel'] = "Ovr".$special;
	}
	if($resItem['commPerc'] != $resItem['itemCommPerc']) {
		$resItem['rateLabel'] .= " %";
	}
	
	if ( $resItem['rv_item_split_yn'] == "1" ) {
		array_push($rv_split_items,$itemId);
	}
	
	$resItem['amount']		= getDisplayItemTotal($itemId);
	$resItem['itemCurr']	= $rf_currency_symbol;
	
	if ( $resItem['amount'] == "TBA" ) {
		$resItem['itemCurr'] = "";
	}
	
	$resItem['arrive']	= chng_date($resItem['rv_item_date_arrive'],"-");
	$resItem['depart']	= chng_date($resItem['rv_item_date_depart'],"-");
	$resItem['id']			= $itemId;
	
	$guestCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		WHERE
			rv_res_item_group.rv_reservation_item_id = '" . $itemId . "'
	",4);
	
	$maxGroupStatus = $GLOBALS['lDB']->get("
		SELECT
			MAX(rv_grp_status_ind)
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_reservation_item_id = '" . $itemId . "'
	",4);
	
	$resItem['hideRoomButton'] = "";
	$resItem['allowRoomButton'] = "true";
	
	if ( $userStatusId < 2 || $guestCount > 0 || $maxGroupStatus > 2 ) {
		$resItem['hideRoomButton'] = " style=\"visibility: hidden;\"";
		$resItem['allowRoomButton'] = "false";
	}

	
	if ( $lastArrive == $resItem['arrive'] && $lastDepart == $resItem['depart'] && $lastProperty == $resItem['pr_name_last'] ) {
		$resItem['arrive']				= "";
		$resItem['depart']				= "";
		$resItem['pr_name_last']	= "";
	} else {
		$lastArrive		= $resItem['arrive'];
		$lastDepart		= $resItem['depart'];
		$lastProperty	= $resItem['pr_name_last'];
	}
	
	
	$textColour = "txt";
	$bgColour = "#fff";
	
	$invoiced = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rv_reservation_item_ix)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item_ix = '$resItem[id]'
			AND fn_invoice_id IS NOT NULL
			AND fn_invoice_id <> '0'
			AND trim(fn_invoice_id) <> ''
	",4);

	if ( $invoiced > "0" ) {
		$textColour = "txtred";
	}
	
	// Test to see whether this item's component(s) have been modified ----------
	$hasBeenModified = $GLOBALS['lDB']->get("SELECT count(rv_item_comp_edit_yn) FROM rv_res_item_comp WHERE rv_item_comp_edit_yn = 1 AND rv_reservation_item_id = '" . $resItem['id'] . "'",4);	
	// --------------------------------------------------------------------------
	// NB! Once we implement server access control use class txtg for the server
	// controlled items
	// --------------------------------------------------------------------------
	if ( $hasBeenModified >= "1" ) {
		$bgColour = "#f1c55d";
	}

	// Test to see whether this item has been overridden
	$rateGroupOverrides = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_rate_grp_overide_amt
		FROM
			rv_res_item_rate_grp
		WHERE
			rv_res_item_rate_grp.rv_reservation_item_id = '".$resItem['id']."'
			AND rv_res_item_rate_grp_overide_amt IS NOT NULL
	",3);

	if ($resItem['rv_item_overide_amt'] != "" || (!empty($rateGroupOverrides))) {
		$bgColour = "#bad3ea";
	}

	$resItem['rowClass'] = "$textColour br";
	$resItem['bgColour'] = "$bgColour";

	if ( !in_array($itemId,$editItem) ) {
		array_push($editItem,$itemId);
	}	
	
	// Rooming info --------------------------------------------------------------
	$roomList = join(":",$GLOBALS['lDB']->get("SELECT ac_accomm_room_id FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'",3));
	$roomRequest = $GLOBALS['lDB']->get("
		SELECT 
			rv_room_requested_yn,
			rv_room_request_reason
		FROM
			rv_res_item_group
		WHERE
			rv_reservation_item_id = '$itemId'
	",1);
	
	$resItem['roomList']								= $roomList;
	$resItem['requestYN']								= $roomRequest['rv_room_requested_yn'];
	$resItem['requestReason']						= str_replace("<br />","\\n",t_encodeOverlib($roomRequest['rv_room_request_reason']));
	$resItem['rv_reservation_item_id']	= $itemId;
	  

	$trfFlag = $GLOBALS['lDB']->get("SELECT rv_reservation_item_trf_yn FROM rv_reservation_item WHERE rv_reservation_item_ix = '$itemId'",4);

	$canEdit = (
			canEditDB($resItem['rv_reservation_item_db'])
			|| ($trfFlag == "0" && $resItem['rv_reservation_item_db'] == $GLOBALS['dbcode'])
		) && (
			isMasterDB() || $GLOBALS['dbcode'][0] != "W"
		) && $GLOBALS['userStatusId'] > 0 
		&& $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5
		&& canEditReservation($record,true,"2",$itemId)
		&& canEditItineraries();

	$resItem['hideCompButton'] = "";
	$resItem['allowCompButton'] = "true";
    $resItem['hideSpecialButton'] = "";
    $resItem['allowSpecialButton']=  "true";
	
	if ($userStatusId < 2) {
		$resItem['hideCompButton'] = " style=\"visibility: hidden;\"";
		$resItem['allowCompButton'] = "false";
        $resItem['hideSpecialButton'] = " style=\"visibility: hidden;\"";
        $resItem['allowSpecialButton']=  "false";
	}
	
	$resItem['hideDelButton'] = "";
	$resItem['allowDelButton'] = "true";
	
	if ($imax == "1" || !$canEdit || $invoiced > 0) {
		$resItem['hideDelButton'] = " style=\"visibility: hidden;\"";
		$resItem['allowDelButton'] = "false";
	}

	$resItem['pr_name_last'] = t_encodeHTMLField($resItem['pr_name_last']);
	$resItem['ac_accomm_desc'] = t_encodeHTMLField($resItem['ac_accomm_desc']);
	$resItem['invoice_currency'] = t_encodeHTMLField($resItem['invoice_currency']);
	$resItem['internalOnly'] = $internalOnly;
	
	if ( !$canEdit && $invoiced == "0" ) {
		$resItem['rowClass'] = "txtg br";
	}
	  
	if ( !$canEdit || $invoiced > "0" ) {	
		$out .= showpage($resItem,$rowHTMLB);
	} else {
		$out .= showpage($resItem,$rowHTML);
	}
	$summout .= showpage($resItem,$summrowHTML);
}

if ( checkJob($GLOBALS['job'],2) == 15 ) {
	$editItem = $list;
}

$GLOBALS['temp']['editItem'] = join("','",$editItem);

if ( is_array($rv_split_items) && sizeof($rv_split_items) > 0 ) {
	$GLOBALS['temp']['rv_split_items'] = join(":",$rv_split_items);
}

$GLOBALS['temp']['isItinerary'] = "0";
$GLOBALS['temp']['summrows'] = $summout;

if ( $out != "" ) {
	$GLOBALS['temp']['isItinerary']	= "1";
	$GLOBALS['tagList']['rows']			= $out;      
	$GLOBALS['tagList']['noItems']	= blankObject();
} else {
	$GLOBALS['tagList']['rows']			= blankObject();
}

// Get correct job for delete -------------------------------------------------
if ( $GLOBALS['autovar'] == "1" ) {
	$GLOBALS['temp']['delitemjob'] = "18";
} else {
	$GLOBALS['temp']['delitemjob'] = "10";
}

$paxSummary = getPaxSummary($reservationId);
$GLOBALS['temp']['paxSummary'] = $paxSummary['paxsummary'];
$GLOBALS['temp']['reservationBedNights'] = $paxSummary['reservationBedNights'];

$sp_special = $lDB->get("
	SELECT
		sp_special.sp_special_ix,
		sp_special.sp_special_desc
	FROM
		sp_special
		LEFT JOIN rv_special ON rv_special.sp_special_id = sp_special.sp_special_ix
	WHERE
		rv_special.rv_reservation_id = '".$reservationId."'
",1);

$sp_special['sp_special_id'] = isset($sp_special['sp_special_ix']) ? $sp_special['sp_special_ix'] : "";
$sp_special['sp_special_desc'] = isset($sp_special['sp_special_desc']) ? $sp_special['sp_special_desc'] : "";

$GLOBALS['temp']['reservation_id'] = $reservationId;
// Hide Specials desc and button by default
$GLOBALS['temp']['hideApplySpecialsButton'] = " display: none;";
$GLOBALS['temp']['appliedSpecialDesc'] = "";
$GLOBALS['temp']['defaultSpecialSuggestionDesc'] = "";
getSpecialIndicationText($reservationId,0);
