<?php

/**
 * init.form5.php - Find Reservation Page
 * Job: 19
 * Function: 52
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_find_list.htm");
}

$resScrollSet = array();

// Define system variables ----------------------------------------------------
$dbFields = array();
$dbTables = array();
$dbClause = "";
$dbOrder = "";

// Customise the system for this page -----------------------------------------
$resNum = mb_strtoupper($GLOBALS['lDB']->like(urldecode($_SERVER['argv'][1])));
$resName = $GLOBALS['lDB']->like(urldecode($_SERVER['argv'][2]));
$voucherRef = $GLOBALS['lDB']->like(urldecode($_SERVER['argv'][3]));
$invoiceNum = $GLOBALS['lDB']->like(urldecode($_SERVER['argv'][4]));
$sortBy = "8";

if(trim($_SERVER['argv'][5]) != "") {
	$sortBy = $_SERVER['argv'][5];
}

$page = "1";
if($_SERVER['argv'][6] > "1") {
	$page = $_SERVER['argv'][6];
}

$GLOBALS['temp']['pgNum'] = (string) $page;

$GLOBALS['temp']['hideAll'] = "0";
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "") {
	$GLOBALS['temp']['hideAll'] = "1";
}

$pLimit = "10";
$limit = "35";

// [START] Filters ------------------------------------------------------------
$statusACL = $GLOBALS['lDB']->get("
         SELECT
            rf_reservation_status_id
         FROM
            rf_reservation_status
         WHERE
		 	rf_reservation_status_id <> 25
			AND rf_reservation_status_id <> 97
",3);
$statusFilter = useFilter("status",$_SERVER['argv'][8],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$agentACL = false;
if($userStatusId < 2) {
   $agentACL = array($calAgentId);
}
$agentFilter = useFilter("agent",$_SERVER['argv'][9],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");

$initialAccomm = join(":",$GLOBALS['lDB']->get("
	SELECT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		ac_accomm_type
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
	WHERE
		ac_accomm_type.ac_accomm_type_inactive_yn = '0'
		AND pr_business.pr_bus_inactive_yn = '0'
",3));
if($_SERVER['argc'] < 2) {
	$_SERVER['argv'][10] = $initialAccomm;
}


$accommACL= $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][10],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);


$arriveDate = $_SERVER['argv'][11];
$departDate = $_SERVER['argv'][12];
$dateClass = $_SERVER['argv'][13];

$consultantFilter = useFilter("consultant",$_SERVER['argv'][15],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

$blockTemplateFilter = useFilter("blockTemplate",$_SERVER['argv'][16],"SELECT CONCAT(bl_block.bl_block_name, ' (', bl_block.bl_block_abbrev, ')') AS namelast FROM bl_block WHERE bl_block.bl_block_ix =","bl_block.bl_block_ix",false,"No block template","0");


// Set date drop downs --------------------------------------------------------
if($dateClass) {
	$GLOBALS['temp']['dateType'] = $dateClass;
} else {
	$GLOBALS['temp']['dateType'] = "";
}

$splitArr = useDate("arrive", $arriveDate);
$splitDep = useDate("depart", $departDate);

$GLOBALS['temp']['splitArr'] = $splitArr['jsDate'];

if(trim($departDate) != "") {
	$GLOBALS['temp']['splitDep'] = $splitDep['jsDate'];
} else {
	$GLOBALS['temp']['splitDep'] = date("Y-m-d",time()+(86400*7));
}

// Dates for display ----------------------------------------------------------
$GLOBALS['temp']['printArr'] = $splitArr['htmlDate'];
$GLOBALS['temp']['printDep'] = $splitDep['htmlDate'];

$dateExtra = "";
if($arriveDate && $departDate) {
	$dateExtra = "
		AND rv_reservation.rv_date_arrive <= '$departDate'
		AND rv_reservation.rv_date_depart >= '$arriveDate'
	";
} elseif(!$departDate && $arriveDate) {
	$dateExtra = "AND rv_reservation.rv_date_arrive = '$arriveDate'";
} elseif(!$arriveDate && $departDate) {
	$dateExtra = "AND rv_reservation.rv_date_depart = '$departDate'";
}

if ( $_SESSION['userStatusId'] < 2 ) {
	$GLOBALS['temp']['agentHide'] = "collapse";
	$agentLink = $GLOBALS['lDB']->get("SELECT pr_persona.pr_name_first, pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '".$GLOBALS['pr_agent_link']."'",1);

	if ( $agentLink['pr_name_first'] ) {
		$agentLinkName = $agentLink['pr_name_first']." ".$agentLink['pr_name_last'];
	} else {
		$agentLinkName = $agentLink['pr_name_last'];
	}
	$GLOBALS['temp']['agentNames'] = $agentLinkName;
} else {
	$GLOBALS['temp']['agentHide'] = "expand";
}

if ( trim($_SERVER['argv'][8]) != "" || trim($_SERVER['argv'][9]) != "" || $_SERVER['argv'][10] != $initialAccomm || trim($_SERVER['argv'][15]) != "" || $arriveDate || $departDate ) {
	$GLOBALS['temp']['showAdvanced'] = "block";
} else {
	$GLOBALS['temp']['showAdvanced'] = "none";
}

$GLOBALS['temp']['arriveClass']		= "visibility: hidden;";
$GLOBALS['temp']['departClass']		= "visibility: hidden;";
$GLOBALS['temp']['betweenClass']	= "visibility: hidden;";
$GLOBALS['temp']['arrCheck']			= "";
$GLOBALS['temp']['depCheck'] 			= "";
$GLOBALS['temp']['betCheck'] 			= "";

switch($dateClass){
	case 'arrive':
		$GLOBALS['temp']['arriveClass']	= "visibility: visible;";
		$GLOBALS['temp']['arrCheck']		= "checked=\"checked\"";
		break;
	case 'depart':
		$GLOBALS['temp']['departClass'] = "visibility: visible;";
		$GLOBALS['temp']['depCheck']		= "checked=\"checked\"";
		break;
	case 'between':
		$GLOBALS['temp']['betweenClass']	= "visibility: visible;";
		$GLOBALS['temp']['betCheck']			= "checked=\"checked\"";
		break;
}
// [ END ] Filters ------------------------------------------------------------

array_push($dbFields,"rv_reservation.rv_reservation_ix as reservation_id");
array_push($dbFields,"rv_reservation.rv_res_name");
array_push($dbFields,"rv_reservation.rv_agent_id");
array_push($dbFields,"rv_reservation.rf_reservation_status_id");
array_push($dbFields,"rv_reservation.rf_reservation_status_id");
array_push($dbFields,"rv_reservation.rv_provision_expiry_date");
array_push($dbFields,"rv_reservation.rv_consultant_id");
array_push($dbFields,"rv_reservation.rv_date_arrive");
array_push($dbFields,"rv_reservation.rv_date_depart");
array_push($dbFields,"rv_reservation.rv_agent_ref");

$dbClause = "
	WHERE
		rv_reservation.rf_reservation_status_id != '25'
		AND rv_reservation.rf_reservation_status_id != '15'
		AND rv_reservation.rf_reservation_status_id != '97'
		AND rv_reservation.rv_res_name LIKE '" . $resName . "'
		AND rv_reservation.rv_reservation_ix LIKE '" . $resNum . "'
		AND rv_reservation.rv_agent_ref LIKE '" . $voucherRef . "'
		$statusFilter[where]
		$agentFilter[where]
		$accommFilter[where]
		$consultantFilter[where]
		$dateExtra

";

$dbFrom = "
	rv_reservation
	INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
	LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
	LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix

";

if ($blockTemplateFilter['names'] != "All") {
	$dbClause .= $blockTemplateFilter['where'];
	$dbFrom .= "
	LEFT JOIN rv_reservation_item AS allocated_item ON allocated_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
	LEFT JOIN rv_reservation allocation ON allocation.rv_reservation_ix = allocated_item.rv_reservation_id
	LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = allocation.bl_block_period_id
	LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
	";
}

if(!empty($invoiceNum) && $invoiceNum != "%") {
	$getFiscalInvoiceList = $GLOBALS['lDB']->get("SELECT fn_invoice_id FROM fs_invoice WHERE fn_invoice_doc LIKE '%$invoiceNum%'",3);
	$fiscalInvoiceList = count($getFiscalInvoiceList) > 0 ? " OR fn_invoice.fn_invoice_ix IN ('" . implode("','", $getFiscalInvoiceList) . "')" : "";
	$dbFrom .= "
		LEFT JOIN fn_invoice ON fn_invoice.rv_reservation_id = rv_reservation.rv_reservation_ix 
		LEFT JOIN fs_invoice ON fs_invoice.fn_invoice_id = fn_invoice.fn_invoice_ix 
	";
	$dbClause .= "
		AND (
			fn_invoice.fn_invoice_ix LIKE '$invoiceNum' 
			$fiscalInvoiceList
			)
	";
}

$dbFromCount = " rv_reservation ";
$agentId = "0";
if ( isAgent($GLOBALS['userid']) ) {
	$agentId = $GLOBALS['userid'];
}

if ( $GLOBALS['pr_agent_link'] != "0" ) {
	$agentId = $GLOBALS['pr_agent_link'];
}

if ( $agentId != "0" && $GLOBALS['pr_business_link'] == "0" ) {
	$dbClause .= "AND rv_reservation.rv_agent_id = '$agentId'";
}

// Continue setting limits
$listsql = "SELECT COUNT(DISTINCT rv_reservation.rv_reservation_ix) FROM " . $dbFrom . " " . $dbClause;

$total			= $GLOBALS['lDB']->get($listsql,4);
$realCount	= (string) $total / $limit;
$modCount = (string) $total % $limit;
$pCount			= (int) $realCount;

if($modCount != "0") {
	$pCount += "1";
}

if ( $pLimit > $pCount ) {
	$pLimit = $pCount;
}

$pStart = $page - (int) ($pLimit/2);
--$page;
if ( $pStart < "1" ) {
	$pStart = "1";
}

if ( $pStart > $pCount ) {
	$pStart = $pCount;
}

$pEnd = $pStart+$pLimit;

if ( $pEnd > $pCount ) {
	$pEnd = $pCount+1;
}
if ( $page > $pEnd ) {
	$page = $pEnd-1;
}
$start = $page * $limit;

$GLOBALS['temp']['imgSort1']	= "";
$GLOBALS['temp']['imgSort2']	= "";
$GLOBALS['temp']['imgSort3']	= "";
$GLOBALS['temp']['imgSort4']	= "";
$GLOBALS['temp']['imgSort5']	= "";
$GLOBALS['temp']['imgSort6']	= "";
$GLOBALS['temp']['imgSort7']	= "";
$GLOBALS['temp']['imgSort8']	= "";
$GLOBALS['temp']['imgSort9']	= "";
$GLOBALS['temp']['imgSort10']	= "";
$GLOBALS['temp']['imgSort11']	= "";
$GLOBALS['temp']['imgSort12']	= "";

$GLOBALS['temp']['imgSort1Mode']	= "";
$GLOBALS['temp']['imgSort2Mode']	= "";
$GLOBALS['temp']['imgSort3Mode']	= "";
$GLOBALS['temp']['imgSort4Mode']	= "";
$GLOBALS['temp']['imgSort5Mode']	= "";
$GLOBALS['temp']['imgSort6Mode']	= "";
$GLOBALS['temp']['imgSort7Mode']	= "";
$GLOBALS['temp']['imgSort8Mode']	= "";
$GLOBALS['temp']['imgSort9Mode']	= "";
$GLOBALS['temp']['imgSort10Mode']	= "";
$GLOBALS['temp']['imgSort11Mode']	= "";
$GLOBALS['temp']['imgSort12Mode']	= "";

$dbOrder = "ORDER BY ";

switch ($sortBy) {
	case 0:
		$dbOrder .= "rv_reservation.rv_reservation_ix";
		$GLOBALS['temp']['imgSort1Mode'] = "_z";
		break;
	case 1:
		$dbOrder .= "rv_reservation.rv_reservation_ix DESC";
		$GLOBALS['temp']['imgSort2Mode'] = "_z";
		break;
	case 2:
		$dbOrder .= "rv_reservation.rv_res_name";
		$GLOBALS['temp']['imgSort3Mode'] = "_z";
		break;
	case 3:
		$dbOrder .= "rv_reservation.rv_res_name DESC";
		$GLOBALS['temp']['imgSort4Mode'] = "_z";
		break;
	case 4:
		$dbOrder .= "rv_reservation.rf_reservation_status_id DESC";
		$GLOBALS['temp']['imgSort5Mode'] = "_z";
		break;
	case 5:
		$dbOrder .= "rv_reservation.rf_reservation_status_id";
		$GLOBALS['temp']['imgSort6Mode'] = "_z";
		break;
	case 6:
		$dbOrder .= "pr_persona.pr_name_last";
		$GLOBALS['temp']['imgSort7Mode'] = "_z";
		break;
	case 7:
		$dbOrder .= "pr_persona.pr_name_last DESC";
		$GLOBALS['temp']['imgSort8Mode'] = "_z";
		break;
	case 8:
		$dbOrder .= "rv_reservation.rv_date_arrive DESC";
		$GLOBALS['temp']['imgSort9Mode'] = "_z";
		break;
	case 9:
		$dbOrder .= "rv_reservation.rv_date_arrive";
		$GLOBALS['temp']['imgSort10Mode'] = "_z";
		break;
	case 10:
		$dbOrder .= "rv_reservation.rv_date_depart DESC";
		$GLOBALS['temp']['imgSort11Mode'] = "_z";
		break;
	case 11:
		$dbOrder .= "rv_reservation.rv_date_depart";
		$GLOBALS['temp']['imgSort12Mode'] = "_z";
		break;
}
$dbLimit = "LIMIT ".$start.", ".$limit;

// Generate the page breaks ---------------------------------------------------
$printString = '<a class="txt"> of ' . $pCount . ' page(s)</a>';
$pString			= '<a class="txtbr">Pages</a> ';

if ( $pStart > "1" ) {
	$pString .= '<a href="#" onclick="ShowFrom(1);" class="txtbr">First</a>, ';
}

for ( $i = $pStart; $i < $pEnd; $i++ ) {
	if ( $i != $pStart ) {
		$pString .= ", ";
	}
	$pString .= "<a class=\"txtbr\"";
	if ( $i != $page + 1 ) {
		$pString .= " href=\"javascript:ShowFrom(" . $i . ");\"";
	}
	$pString .= ">" . $i . "</a>";
}

if ( $pEnd < $pCount ) {
	$pString .= "<a class=\"txtbr\">...</a> <a href=\"#\" onclick=\"javascript:ShowFrom(" . $pCount . ");\" class=\"txtbr\">Last</a>";
}
$pString .= "<a class=\"txtbr\"> of " . $pCount . " page(s)</a>";

$GLOBALS['temp']['hideNext'] = "";
$GLOBALS['temp']['hidePrev'] = "";
$pNext = $page + 2;
$pPrev = $page;
$GLOBALS['temp']['pNext'] = (string) $pNext;
$GLOBALS['temp']['pPrev'] = (string) $pPrev;

if ( $page + 2 > $pCount ) {
	$GLOBALS['temp']['hideNext'] = " style=\"visibility: hidden;\"";
}

if ( $page < "1" ) {
	$GLOBALS['temp']['hidePrev'] = " style=\"visibility: hidden;\"";
}

$sql = "SELECT DISTINCT " . join(", ",$dbFields) . " FROM " . $dbFrom . " " . $dbClause . " " . $dbOrder . " " . $dbLimit;
$result = $GLOBALS['lDB']->get($sql,0);

$imax = mysqli_num_rows($result);
$out = "";
for ( $i = 0; $i < $imax; $i++ ) {
	$resultSet = mysqli_fetch_array($result);
	$res['num']		= $resultSet[0];
	$res['name']	= t_encodeHTMLField($resultSet[1]);

	if ( trim($resultSet['rv_agent_ref']) != "" ) {
		$res['rv_agent_ref'] = $resultSet['rv_agent_ref'];
	} else {
		$res['rv_agent_ref'] = "&nbsp;";
	}

	$agentId	= $resultSet[2];
	$statusId	= $resultSet[3];

	$res['agent'] = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $agentId . "'
	",4);

	if ( trim($res['agent']) == "" || $res['agent'] == "0" ) {
		$res['agent'] = "Direct booking";
	}

	$res['dateArrive'] = chng_date($resultSet['rv_date_arrive'],"-");
	$res['dateDepart'] = chng_date($resultSet['rv_date_depart'],"-");

	$res['status'] = $GLOBALS['lDB']->get("
		SELECT
			rf_reservation_status.rf_reservation_status_desc
		FROM
			rf_reservation_status
		WHERE
			rf_reservation_status.rf_reservation_status_id = '" . $statusId . "'
	",4);

	$provdate		= $resultSet[5];
	$statusId		= $resultSet[4];
	$consultant	= $resultSet[6];

	$res['strong1']		= "";
	$res['strong2']	= "";

	if ( $res['status'] == "Cancelled" ) {
		$res['strong1']		= "<b>";
		$res['strong2']	= "</b>";
	} else {
		if ( $consultant == "0" ) {
			$res['status'] = str_replace("Quotation","Quote",$res['status']);
			$res['status'] = str_replace("Waitlist","Wait",$res['status']);
			$res['status'] = str_replace("Provisional","Prov",$res['status']);
			$res['status'] = str_replace("Confirmed","Confirm",$res['status']);
			$res['status'] = $res['status'] . " (Req)";
		}
	}

	if ( $statusId == "20" ) {
		$res['provClass'] = "";
		$today = date("Y-m-d");
		if ( $today == $provdate ) {
			$res['provClass'] = "colOrange";
		}
		if ( $today > $provdate ) {
			$res['provClass'] = "colRed";
		}
	} else {
		$res['provClass'] = "";
	}

	$res['job'] = "0";
	if ( canEditReservation($res['num']) ) {
		$res['job'] = "2";
	}

	$temphtml = Join("\n",File(__DIR__ . "/../../../public/html/reservation_find_row.htm"));
	$out .= showpage($res,$temphtml);
	array_push($resScrollSet,$res['num']);
}

$GLOBALS['temp']['rows'] = $out;

$srch = urldecode($_SERVER['argv'][1]);

if ( $srch == "" || $srch == "*" ) {
	$srch = urldecode($_SERVER['argv'][2]);
}

$noresult = "
	<div style=\"text-align: left\">
		<p>&nbsp;&nbsp;Your search did not match any records.</p>
		<p>&nbsp;&nbsp;<b>Suggestions:</b><br />
		&nbsp;&nbsp;- Use wildcards to assist in your search<br />
		&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br />
		&nbsp;&nbsp;- Use a different keyword.</p>
	</div>
";

$defout = "
	<tr>
		<td colspan=\"4\" align=\"center\" class=\"txt\">" . $noresult . "</td>
	</tr>";

$GLOBALS['temp']['hidePage'] = "";
if ( $GLOBALS['temp']['rows'] == "" ) {
	$GLOBALS['temp']['rows']			= $defout;
	$GLOBALS['temp']['hidePage']	= "style=\"display: none;\"";
}

if ( $_SERVER['argv'][7] == "1" ) {
	$GLOBALS['temp']['submitval'] = "1";
} else {
	$GLOBALS['temp']['submitval'] = "0";
}

$GLOBALS['temp']['ofnum']			= $printString;
$GLOBALS['temp']['nextprev']	= $pString;
$GLOBALS['temp']['limited']		= (string) $total;
$GLOBALS['temp']['sortby']		= $sortBy;

setRecordScroll($resScrollSet);

/*$GLOBALS['temp']['status']			= "<input type=\"hidden\" name=\"statusIds\" id=\"statusIds\" value=\"" . $status . "\">";
$GLOBALS['temp']['agent']				= "<input type=\"hidden\" name=\"agentIds\" id=\"agentIds\" value=\"" . $agent . "\">";
$GLOBALS['temp']['properties']	= "<input type=\"hidden\" name=\"propertiesIds\" id=\"propertiesIds\" value=\"".$properties."\">";*/

$sortByObj = new tpParseObject();
$sortByObj->setParam("value",$sortBy);

$GLOBALS['tagList']['sortby'] = $sortByObj;
