<?php

/**
 * init.form50.php - Review data transfer report
 * Job: 126
 * Function: 64 (Data transfer)
*/

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/data_transfer.htm");
}

$initialLoad = count($_SERVER['argv']) < 10 ? true : false;
$_SERVER['argv'] = array_pad($_SERVER['argv'],10,"");

global $principal_id;
$pageNum = $_SERVER['argv'][1];
if ($pageNum < "1") {
	$pageNum = "1";
}

$includeSourceW = $_SERVER['argv'][2];
$includeSourceX = $_SERVER['argv'][3];
$resOfficeTrans = $_SERVER['argv'][4];
$source = $_SERVER['argv'][5];
$propServerList = $_SERVER['argv'][6];
$startFromDate = $_SERVER['argv'][7];
$toDate = $_SERVER['argv'][8];
$timezone = !empty($_SERVER['argv'][9]) ? $_SERVER['argv'][9] : date("e");

$GLOBALS['temp']['timezoneName'] = $timezone;
$GLOBALS['temp']['timezoneFilterContainer'] = timezoneFilterContainerHTML();

if ($resOfficeTrans == "") {
	$resOfficeTrans = "1";
}

$sourceAllActiveFilter = useFilter("sourceAllActive",$source,"SELECT rf_db_code AS id, CONCAT(rf_db_description, ' [', rf_db_code, ']') AS namelast FROM rf_database WHERE rf_db_code=","rf_database.rf_db_code",false,"All",0);
$GLOBALS['temp']['sourceAllActiveNames'] = $sourceAllActiveFilter['names'];
if (trim($propServerList) == "") {
	$topProperty = $GLOBALS['lDB']->get("
		SELECT
			pr_link_to
		FROM
			pr_link
		WHERE
			pr_link.rf_link_type_id = 'RS1'
			AND pr_link.pr_link_from = '$GLOBALS[userid]'
	",4);
	$propertyList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id
		FROM
			ac_accomm_type
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.pr_business_id IN ('".join("','",getChildren($topProperty))."')
	",3);
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_database.rf_db_code as id,
			CONCAT(rf_db_description, '[', rf_db_business.rf_db_code, ']') as namelast
		FROM
			rf_database
			INNER JOIN rf_db_business ON rf_database.rf_db_code = rf_db_business.rf_db_code
		WHERE
			rf_db_business.pr_business_id IN ('".join("','",$propertyList)."')
		GROUP BY
			rf_db_business.rf_db_code
	",2);
	$propServerList = "";
	$propServerNames = "All";
	$imax = sizeof($listArray);
	for ($i=0; $i<$imax; $i++) {
		if ($i!=0) $propServerList .= ":";
		$propServerList .= $listArray[$i]['id'];
	}
} else {
	$propServerNames = join(", ",$lDB->get("SELECT CONCAT(rf_db_description, '[', rf_db_code, ']') AS rf_db_description FROM rf_database WHERE rf_db_code IN ('".str_replace(":","','",$propServerList)."')",3));
}
$GLOBALS['tagList']['propertyServerIds'] = setNewValue($propServerList);
$GLOBALS['tagList']['propertyServerFilter'] = $propServerNames;

if (!empty($startFromDate)) {
	$temp = explode("-",$startFromDate);
	$startFromDate = date("Y-m-d",mktime(0,0,0,$temp[1],$temp[2],$temp[0]));
}
if (!empty($toDate)) {
	$temp = explode("-",$toDate);
	$toDate = date("Y-m-d",mktime(0,0,0,$temp[1],$temp[2],$temp[0]));
}
if (empty($startFromDate) && empty($toDate) && $initialLoad) {
	$startFromDate = date("Y-m-d");
	$toDate = date("Y-m-d");
}
$temp = !empty($startFromDate) ? explode("-",$startFromDate) : array("","","");
$GLOBALS['temp']['selectMonth'] = $temp[1] != "" ? (string) (int) $temp[1] : "";
$GLOBALS['temp']['selectDay'] = $temp[2] != "" ? (string) (int) $temp[2] : "";
$GLOBALS['temp']['year'] = $temp[0] != "" ? (string) (int) $temp[0] : "";
$temp = !empty($toDate) ? explode("-",$toDate) : array("", "", "");
$GLOBALS['temp']['selectMonthTo'] = $temp[1] != "" ? (string) (int) $temp[1] : "";
$GLOBALS['temp']['selectDayTo'] = $temp[2] != "" ? (string) (int) $temp[2] : "";
$GLOBALS['temp']['yearTo'] = $temp[0] != "" ? (string) (int) $temp[0] : "";

$trfSrcSql = "";
if ($includeSourceW == "1") {
	$trfSrcSql = " AND tc_trf_source NOT LIKE 'W%'";
}
if ($includeSourceX == "1") {
	$trfSrcSql = " AND tc_trf_source LIKE 'W%'";
}
if ($includeSourceW == "1" && $includeSourceX == "1") {
	$trfSrcSql = "";
}
if ($propServerNames != "All") {
	$propListSQL = " AND ( ";
	$propListSQL .= " tc_transfer_db IN ('".str_replace(":","','",$propServerList)."') ";
	if ($GLOBALS['rf_db_env_type_ind'] > "2") {
		$propListSQL .= " OR tc_transfer_db = '".$dbcode."'";
	}
	$propListSQL .= "$trfSrcSql )";
} else {
	$propListSQL = "";
}

if ($includeSourceW == "1") $GLOBALS['tagList']['includeSourceW'] = setNewAttrib("checked");
if ($includeSourceX == "1") $GLOBALS['tagList']['includeSourceX'] = setNewAttrib("checked");

$resOffSQL = " AND tc_transfer_db NOT LIKE 'R%'";
if ($resOfficeTrans == "1") {
	$resOffSQL = " AND tc_transfer_db LIKE 'R%'";
	$GLOBALS['tagList']['resOfficeTrans'] = setNewAttrib("checked");
}
# Input parameters (for testing purposes)
$startTrfId = 'XX99999999999';

#---------------------------------------------------------------------#
# Start of Data access code                                           #
#---------------------------------------------------------------------#

###############################################################
# Get transfer records
###############################################################

if ($sourceAllActiveFilter['names'] == "All" || $sourceAllActiveFilter['names'] == "") {
	$sourceFilterWhere = "";
} else {
	$sourceFilterWhere = $sourceAllActiveFilter['where'];
}

$filterSQL = "
	WHERE
		1 = 1
		$propListSQL
		$sourceFilterWhere
		$resOffSQL
";
if (!empty($startFromDate)) {
	$filterSQL .= " AND tc_trf_time_start >= '$startFromDate 00:00:00' ";
}
if (!empty($toDate)) {
	$filterSQL .= " AND tc_trf_time_start <= '$toDate 23:59:59' ";
}

$start = 0;
$limit = 15;
$trfSql = "
	SELECT
		tc_transfer.tc_transfer_ix as trfId,
		tc_transfer.tc_trf_time_start as timeStart,
		tc_transfer.tc_trf_time_start_tz as timeStartTZ,
		tc_transfer.tc_trf_time_close as timeClose,
		tc_transfer.tc_trf_time_close_tz as timeCloseTZ,
		tc_transfer.tc_trf_time_extract as timeExtract,
		tc_transfer.tc_trf_time_extract_tz as timeExtractTZ,
		tc_transfer.tc_trf_time_send as timeSend,
		tc_transfer.tc_trf_time_send_tz as timeSendTZ,
		tc_transfer.tc_trf_file_size as filesize,
		pr_persona.pr_name_last as firstname,
		pr_persona.pr_name_first as lastname,
		sc_transfer.sc_trf_message as msg,
		tc_transfer.tc_trf_source as source,
		tc_transfer.sc_transfer_id as msgId,
		tc_transfer.tc_user_id as userId,
		tc_transfer.tc_transfer_db as trfDB
";

$where ="
	FROM
		tc_transfer
		INNER JOIN pr_persona ON tc_transfer.tc_user_id = pr_persona_ix
		LEFT JOIN sc_transfer ON tc_transfer.sc_transfer_id = sc_transfer.sc_transfer_id
		INNER JOIN rf_database ON rf_database.rf_db_code = tc_transfer.tc_trf_source
		".$filterSQL."
	ORDER BY
		tc_transfer.tc_trf_time_start DESC
";

$count = $lDB->get("SELECT COUNT(tc_transfer_id) ".$where,4);
$GLOBALS['temp']['recFound'] = $count;
$pages = $count / $limit;
$intPages = (int) $pages;
if ($pages > $intPages) {
	$intPages++;
}
$pageCount = (string) $intPages;

if ($pageNum > $pageCount) {
	$pageNum = $pageCount;
}

$GLOBALS['temp']['pageNum'] = $pageNum;
$GLOBALS['temp']['pageCount'] = $pageCount;
$rowLimit = $limit * ($pageNum - 1);
$rowLimit = $rowLimit < 0 ? 0 : $rowLimit;


$GLOBALS['temp']['hidePrevButton'] = "button";
$GLOBALS['temp']['hideNextButton'] = "button";
if($pageNum == 1) {
	$GLOBALS['temp']['hidePrevButton'] = "collapse printCollapse";
}
if($pageNum == 0) {
	$GLOBALS['temp']['hidePrevButton'] = "collapse printCollapse";
}
if($pageNum == $pageCount) {
	$GLOBALS['temp']['hideNextButton'] = "collapse printCollapse";
}
$pageList = "";
$totalPages = $pageCount;
$totalList = 8;
$startList = 1;
if($totalPages < $totalList) {
	$startList = 1;
	$totalList = $totalPages;
} else if($pageNum <= ($totalList/2)) {
	$startList = 1;
} else if($pageNum > ($totalList/2) && $pageNum < ($totalPages-($totalList/2))) {
	$startList = $pageNum-($totalList/2)+1;
} else {
	$startList = $totalPages-$totalList+1;
}
if($pageNum > 1 && $totalPages > 1 && $startList > 1) {
	if($pageList != "") {
		$pageList .= ", ";
	}
	$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(1);\">First</a>";
}
for($count=$startList;$count<($totalList+$startList);$count++) {
	if($pageList != "") {
		$pageList .= ", ";
	}
	if($count == $pageNum) {
		$pageList .= "<span class=\"txt\">$count</span>";
	} else {
		$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage($count);\">$count</a>";
	}
}
if($pageNum < $totalPages && ($startList+$totalList-1) < $totalPages) {
	if($pageList != "") {
		$pageList .= ", ";
	}
	$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage($totalPages);\">Last</a>";
}
$GLOBALS['temp']['pageList'] = $pageList;

$trfSql .= $where." LIMIT $rowLimit, $limit";

# Get the transfers record set
$transfers = $GLOBALS['lDB']->get($trfSql,2);
$trfRows = sizeof($transfers);

# Display test results
$HTML = Join("",file(__DIR__ . "/../../../public/html/data_transfer_rows.htm"));
$GLOBALS['temp']['rows'] = "";
for ($i=0; $i<$trfRows; $i++) {
	$trf_enh = array();
	$trf_enh['id'] = $transfers[$i]['trfId'];
	$trf_enh['started'] = "";
	$transfers[$i]['timeSendTZ'] = empty($transfers[$i]['timeSendTZ']) ? $transfers[$i]['timeStartTZ'] : $transfers[$i]['timeSendTZ'];
	$transfers[$i]['timeCloseTZ'] = empty($transfers[$i]['timeCloseTZ']) ? $transfers[$i]['timeStartTZ'] : $transfers[$i]['timeCloseTZ'];
	$transfers[$i]['timeExtractTZ'] = empty($transfers[$i]['timeExtractTZ']) ? $transfers[$i]['timeStartTZ'] : $transfers[$i]['timeExtractTZ'];

	if ($transfers[$i]['timeStart'] != "0000-00-00 00:00:00"){
		$datetime = convertDateTimeZone($transfers[$i]['timeStart'], $transfers[$i]['timeStartTZ'], $timezone);
		$trf_enh['started'] = "<span title=\"Original time zone: ".$transfers[$i]['timeStartTZ'].", displaying ".$timezone."\">".$datetime['time']." ".$datetime['date']."</span>";
	}
	$trf_enh['completed'] = "";
	if ($transfers[$i]['timeClose'] != "0000-00-00 00:00:00"){
		$datetime = convertDateTimeZone($transfers[$i]['timeClose'], $transfers[$i]['timeCloseTZ'], $timezone);
		$trf_enh['completed'] = "<span title=\"Original time zone: ".$transfers[$i]['timeCloseTZ'].", displaying ".$timezone."\">".$datetime['time']." ".$datetime['date']."</span>";
	}

	$trf_enh['timezonepopup'] = $timezone;
	$trf_enh['transmission'] = "";
	if ($transfers[$i]['timeExtract'] != "0000-00-00 00:00:00" && $transfers[$i]['timeSend'] != "0000-00-00 00:00:00"){
		$datetime = convertDateTimeZone($transfers[$i]['timeSend'], $transfers[$i]['timeSendTZ'], $timezone, 1, 'Y-m-d H:i:s');
		$tempe = explode(" ",$datetime['datetime_custom']);
		$tempea = explode("-",$tempe[0]);
		$year = $tempea[0];
		$month = $tempea[1];
		$day = $tempea[2];
		$tempeb = explode(":",$tempe[1]);
		$hour = $tempeb[0];
		$minute = $tempeb[1];
		$second = $tempeb[2];
		$datetime = convertDateTimeZone($transfers[$i]['timeExtract'], $transfers[$i]['timeExtractTZ'], $timezone, 1, 'Y-m-d H:i:s');
		$temps = explode(" ",$datetime['datetime_custom']);
		$tempsa = explode("-",$temps[0]);
		$year -= $tempsa[0];
		$month -= $tempsa[1];
		$day -= $tempsa[2];
		$tempsb = explode(":",$temps[1]);
		$hour -= $tempsb[0];
		$minute -= $tempsb[1];
		$second -= $tempsb[2];
		$trf_enh['transmission'] = date("H:i:s",mktime($hour,$minute,$second,$month+date("M"),$day+date("d"),$year+date("Y")));
	}

	$trf_enh['filesize'] = "";
	if ($transfers[$i]['filesize'] != "0"){
		$trf_enh['filesize'] = $transfers[$i]['filesize'] / 10;
		$trf_enh['filesize'] = (int) $trf_enh['filesize'];
		$trf_enh['filesize'] = $trf_enh['filesize'] / 100;
        $trf_enh['filesize'] = number_format($trf_enh['filesize'], 2);
	}
	if ($trf_enh['filesize'] != "") {
		$trf_enh['filesize'] .= " KB";
	}
	$trf_enh['user'] = "";
	if ($transfers[$i]['lastname'] != "0"){
		$trf_enh['user'] = trim($transfers[$i]['firstname']." ".$transfers[$i]['lastname']);
	}
	$trf_enh['msg'] = "";
	if ($transfers[$i]['msg'] != "" && $transfers[$i]['msg'] != "0"){
		$trf_enh['msg'] = t_encodeOverlib($transfers[$i]['msg']);
		if ($transfers[$i]['msgId'] != "" && $transfers[$i]['msgId'] != "0") {
			$trf_enh['msg'] .= " [".$transfers[$i]['msgId']."]";
		}
	}
	$trf_enh['msgShow'] = " style=\"display:none\"";
	if ($trf_enh['msg'] != "" && $transfers[$i]['msgId'] != "52" && $transfers[$i]['msgId'] != "1033" && $transfers[$i]['msgId'] != "1054" && $transfers[$i]['msgId'] != "1026" && $transfers[$i]['msgId'] != "1045") {
		$trf_enh['msgShow'] = "";
	}
	$trf_enh['source'] = $transfers[$i]['source'];
	$logFile = $principal_id."_".$transfers[$i]['trfId']."_".str_replace(" ","_",str_replace(":","-",$transfers[$i]['timeStart']))."_".$transfers[$i]['source']."_".$transfers[$i]['userId'].".log";
	$logDir = getTransferDirDT37($logFile,TRANSFER_DIR_LOG);
	$logURL = "reservation.php?127+$GLOBALS[userid]+9+".TRANSFER_DIR_LOG."+$logFile";


	$trf_enh['logFile'] = $logURL;
	$trf_enh['hideLog'] = "";
	if (!is_file($logDir.$logFile)) {
		$trf_enh['logFile'] = "";
		$trf_enh['hideLog'] = " style=\"visibility:hidden\"";
	}
	$GLOBALS['temp']['rows'] .= showpage($trf_enh,$HTML);
}
if ($GLOBALS['temp']['rows'] == "") {
	$GLOBALS['temp']['rows'] .= "<tr class=form height=18><td align=center colspan=7>No transfers found.</td></tr>";
}
$GLOBALS['temp']['showLog'] = "false";
if ($GLOBALS['dbcode'][0] != "W") {
	$GLOBALS['temp']['showLog'] = "true";
}
