<?php

/**
 * init.form51.php - Process data transfer
 * Job: 127
 * Function: 64 (Data transfer)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}
$GLOBALS[$form]->FormHTML = " ";

$_SERVER['argv'] = array_pad($_SERVER['argv'],8,"");

global $lDB;

$lDB->isMaster = "1";

$remoteTransferDB = "";
global $remoteTransferDB;
$dbStatus = "1";
if (!isMasterDB("1")) {
	$dbStatus = "0";
}

$direction = $_SERVER['argv'][2];

if(!isset($_POST['transferDirection'])) {
	$_POST['transferDirection'] = "";
}

if ($direction == "3") {
	// Check if the web is currently master, if not, issue error.
	$check = $lDB->get("SELECT rf_sys_db_master_id, rf_sys_db_web_id FROM rf_system",1);

	// Get web ids
	$webList = $lDB->get("SELECT rf_database_id FROM rf_database WHERE rf_db_code LIKE 'W%'",3);
	if(!in_array($check['rf_sys_db_master_id'],$webList)) {
		echo "!DENIED!".$check['rf_sys_db_master_id'];
		die();
	}

	// Set Web as Slave - run 'force_slave'
	$sql = "UPDATE rf_system SET rf_sys_db_master_id = '".$_SERVER['argv'][3]."'";
	if ($lDB->put($sql)) {
		echo "!TRUE!";
	} else {
		echo "!FALSE!,".mysqli_error($lDB->conn);
	}
	die();
}

if ($direction == "4") {
	// Set Web as Master - run 'force_master'
	$sql = "update rf_system set rf_sys_db_master_id = rf_sys_db_web_id";
	if ($lDB->put($sql)) {
		echo "!TRUE!";
	} else {
		echo "!FALSE!,".mysqli_error($lDB->conn);
	}
	die();
}

// In case of data transfer, verify that the remote db status has been sent
if ($direction == "1") {
	$remoteDbStatus = $_SERVER['argv'][5];
	$remoteTransferDB = $_SERVER['argv'][7];
} else {
	$remoteDbStatus = $_SERVER['argv'][4];
	$remoteTransferDB = $_SERVER['argv'][5];
}

if($direction != "9") {
	echo $remoteDbStatus."<br>";
	echo $remoteTransferDB."<br>";
}

if (($direction != "3" && $direction != "4" && $direction != "6" && $direction != "7" && $direction != "8" && $direction != "9") && ($remoteDbStatus != "0" && $remoteDbStatus != "1")) {
	setProgressReport("!FALSE!, require DB status to be sent!");
	die();
}

if (($direction != "3" && $direction != "4" && $direction != "6") && $remoteDbStatus == $dbStatus && $remoteDbStatus == "1" && $remoteTransferDB[0] != "P") {
	$status = "slave";
	if ($dbStatus == "1") {
		$status = "master";
	}
	setProgressReport("!FALSE!, Both databases are set to ".$status."!");
	die();
}

# Set the timeout limit to 30 minutes
@set_time_limit(1800);

global $trDataFolder;
global $transferId;
global $dbcode;
global $webroot;
global $recieveOn;

$webroot = $_SERVER['DOCUMENT_ROOT'];

if ($webroot[(strlen($webroot)-1)] != "/") {
	$webroot .= "/";
}
array_push($GLOBALS['trTables'],"tc_transfer");
array_push($GLOBALS['trTables'],"tc_transfer_table");

if (substr($GLOBALS['DTdir'],-1) != "/") {
	$GLOBALS['DTdir'] .= "/";
}
$trDataFolder = $GLOBALS['DTdir']."trdata_".$dbcode."/";
if ($GLOBALS['isWebServer']) { $trDataFolder = $GLOBALS['DTdir']; }

$recieveOn = false;


# Step 1 - Check for valid user
if ($_SERVER['argv'][1] != "") {
	// This is completed inside ac_logon now
}

global $sysLocked;

$sysLocked = false;
if ($lDB->get("select rf_sys_locked_yn from rf_system",4) == "1") {
	$sysLocked = true;
}

# Step 2 - Check direction
if ($direction == "0") {
	# Step 3 - Verify zipfile
	$zipFile = $_SERVER['argv'][3];
	$temp = explode("_",$zipFile);
	$transferId = $temp[1];
	importTransferWebDT21($zipFile);
} else if($direction == "1") {
	$recieveOn = true;
	$lockSystem = $_SERVER['argv'][6];
	if (!$sysLocked && $lockSystem == "1") {
		$lDB->put("update rf_system set rf_sys_locked_yn = 1");
		$sysLocked = true;
	} else if ($sysLocked && $lockSystem == "0") {
		$lDB->put("update rf_system set rf_sys_locked_yn = 0");
		$sysLocked = false;
	}
	exportRecieveTransferDT24();
} else if ($direction == "5") {
	echo "Export database for offline system...<br>\n";
	$transferId = $_SERVER['argv'][3];
	global $principal_id;
	$exec = "ls -l /var/www/html/db_upgrades/".$principal_id."_".$transferId."_upgrade_*.zip";
	echo "<pre>\n";
	$result = system($exec);
	echo "</pre>\n";

	if (trim($result) != "") {
		$temp = explode("/var/www/html/",$result);
		$file = $temp[1];
		echo "File: [resrequest.com/".$file."]<br>\n";
	} else {
		if($sysLocked) {
			echo "dumping db...<br>\n";
			$file = $principal_id."_".$transferId."_upgrade_".date("Y-m-d_H-i-s").".sql";
			$path = "/var/www/html/db_upgrades/";
			$exec = "mysqldump -u censysad -pcnsadDB --add-drop-table cn_live_".$principal_id." > ".$path.$file;
			system($exec);
			if (is_file($path.$file)) {
				echo "Backup success! (".filesize($path.$file).")<br>\n";
				$zipFile = $path.$file.".zip";
				$zipFileObj = new PclZip($zipFile);
				if (!$zipFileObj->add($path.$file,"","/var/www/html/db_upgrades/")) {
					echo "!FALSE! ERROR PACKAGING!<br>\n";
					unlink($zipFile);
					unlink($path.$file);
					die();
				}
			}
			if (testZipFileDT11($zipFile)) {
				echo "File: [resrequest.com/".str_replace("/var/www/html/","",$zipFile)."]<br>\n";
			} else {
				echo "!FALSE! PACKAGE CORRUPT!<br>\n";
				unlink($zipFile);
				unlink($path.$file);
				die();
			}
			$lDB->put("update rf_system set rf_sys_locked_yn = 0");
			echo "SYSTEM UNLOCKED!<br>\n";
		} else {
			echo "!FALSE! SYSTEM ALREADY UNLOCKED!<br>\n";
		}
	}
} else if ($direction == "6") {
	// Perform remote/web version comparison...
	$remoteVersion = $_SERVER['argv'][3];
	$remoteDB = $_SERVER['argv'][5];
	$webVersion = $_SESSION['systemVersion'];

	$remoteVersionArray = explode(".",$remoteVersion);
	$webVersionArray = explode(".",$webVersion);
	$allowVersion = false;
	if(sizeof($remoteVersionArray) > 1 && sizeof($webVersionArray) > 1) { // release versions in form x.y[.z...]
		if($remoteVersionArray[0] == $webVersionArray[0] && $remoteVersionArray[1] == $webVersionArray[1]) {
			$allowVersion = true;
		}
	} else { // development versions in form xyz
		$allowVersion = $remoteVersion == $webVersion;
	}

	if(!empty($remoteDB)) {
		$rf_db_description = $lDB->get("SELECT rf_db_description FROM rf_database WHERE rf_db_code = '$remoteDB'",4);
		$rf_db_description = preg_replace("/\s+\(.*$/","",$rf_db_description) . " (" . $remoteVersion . ")";
		$tmpFlag = $GLOBALS['flagChngs'];
		$GLOBALS['flagChngs'] = 0;
		$lDB->put("
			UPDATE rf_database SET
				rf_db_description = '".$lDB->escape($rf_db_description)."'
			WHERE rf_database.rf_db_code = '$remoteDB'
		");
		$GLOBALS['flagChngs'] = $tmpFlag;
	}

	if($allowVersion) {
		echo "!TRUE!\n";
		echo "$webVersion\n";
	} else {
		echo "!FALSE! VERSION NUMBERS DIFFER!<br>\n";
		echo "$webVersion\n";
	}
} else if ($direction == "7") {
	global $DTSERVERIP;
	$dtServerName = "DTremoteHost".$GLOBALS['remoteDbCode'];
	$DTSERVERIP = $GLOBALS[$dtServerName];

	$_POST['transferDirection'] = "0";
	// Batch scheduled data transfer
	processTransferDT2();
	endProcessTD(true);
} else if($direction == "8") { // http upload
	storeUploadedFilesDT35();
} else if($direction == "9") { // http download
	$type = $_SERVER['argv'][3];
	$name = $_SERVER['argv'][4];
	downloadFileDT38($type,$name);
}

