<?php

/**
 * init.form52.php - Data transfer popup
 * Job: 128
 * Function: 64 (Data transfer)
 */

$action = isset($_POST['action'])?$_POST['action']:"";

if(!isset($_POST['transferDirection'])) {
	$_POST['transferDirection'] = "";
}

global $system; // to check for demo/training/etc
$GLOBALS['temp']['is_training'] = "";
if ($system == "training") {
	$GLOBALS['temp']['is_training'] = "visibility: hidden;";
}

$autoCheck = $GLOBALS['lDB']->get("SELECT rf_db_trf_auto_yn FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
if($autoCheck == "2") { // Automatic transfer enabled
	// Find the data transfer task
	$taskInfo = $GLOBALS['lDB']->get("
		SELECT
			zs_task.zs_task_ix,
			zs_task.zs_task_suspend_yn,
			zs_task.zs_task_inactive_yn,
			zs_task.zs_task_suspend_reason
		FROM
			zs_task
		WHERE
			zs_task.zs_task_sys_code = '2'
			AND zs_task.zs_task_target_db = '$GLOBALS[dbcode]'
	",1);
	$maxMinutes = $GLOBALS['lDB']->get("SELECT rf_db_trf_max_minutes FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
	$lastSuccessStr = $GLOBALS['lDB']->get("
		SELECT
			tc_transfer.tc_trf_time_close
		FROM
			tc_transfer
			LEFT JOIN sc_transfer ON sc_transfer.sc_transfer_id = tc_transfer.sc_transfer_id
		WHERE
			tc_transfer.tc_transfer_db = '$GLOBALS[dbcode]'
			AND sc_transfer.sc_trf_status = '0'
		ORDER BY
			tc_transfer.tc_trf_time_close DESC
		LIMIT 1
	",4);
	$sinceLast = strtotime("now") - strtotime($lastSuccessStr);
	$sinceDays = floor($sinceLast / 86400);
	$sinceHours = floor( ($sinceLast % 86400) / 3600);
	$sinceMinutes = floor( ( ( $sinceLast % 86400 ) % 3600) / 60 );
	$sinceSeconds = floor( ( ( $sinceLast % 86400 ) % 3600) % 60 );
	$maxMinutesWarn = false;
	if( ($sinceLast / 60) > $maxMinutes ) {
		$maxMinutesWarn = true;
	}

	$taskStatus = "SUSPENDED";
	$taskErrorMessage = $taskInfo['zs_task_suspend_reason'];
	$taskErrorClass = "expand";
	$switchAction = "Enable";
	$switchImage = "/resource/Resrequest/Application/public/img/icon_datatrf_enable_16.gif";
	if($taskInfo['zs_task_suspend_yn'] == "0") {
		$taskStatus = "DISABLED";
		$taskErrorClass = "collapse";
		$switchAction = "Enable";
		$switchImage = "/resource/Resrequest/Application/public/img/icon_datatrf_enable_16.gif";
		if($taskInfo['zs_task_inactive_yn'] == "0") {
			$taskStatus = "ENABLED";
			$switchAction = "Disable";
			$switchImage = "/resource/Resrequest/Application/public/img/icon_datatrf_disable_16.gif";
		}
	}
	$transferErrorClass = "expand";
	$transferErrorMessage = "There has been no transfer in $sinceDays day". ($sinceDays != 1?"s":"") .", $sinceHours hour". ($sinceHours != 1?"s":"")." and $sinceMinutes minute". ($sinceMinutes!=1?"s":""). "!";
	if(!$maxMinutesWarn) {
		$transferErrorClass = "collapse";
	}

	$lastSuccess = "";
	if (isset($lastSuccessStr) && $lastSuccessStr != "") {
		$lastSuccess = explode(" ",$lastSuccessStr);
		$lastSuccess = chng_date($lastSuccess[0],"-") . " at " . $lastSuccess[1];
	}


	// Action code
	if($action == "top_contents") {
		$statusCode = 0; // All is ok
		if($maxMinutesWarn) {
			$statusCode = 1; // Timeout has occured
			if($taskInfo['zs_task_suspend_yn'] != "0") {
				$statusCode = 2; // Timeout has occured and data transfer is not running
			}
		}
		echo $statusCode;
		die();
	}

	if($action == "refresh") {
		$out = array(
			$lastSuccess,
			$transferErrorMessage,
			$transferErrorClass,
			$taskStatus,
			$taskErrorMessage,
			$taskErrorClass,
			$switchAction,
			$switchImage
		);
		foreach($out as $outKey=>$outValue) { $out[$outKey] = rawurlencode($outValue); }

		echo join("|",$out);
		die();
	}
	if($action == "addTransfer") {
		$zs_schedule_id = db_zs_schedule_insert($taskInfo['zs_task_ix'],2,array(ltrim(date("i"),"0")),array(date("G")),array(date("j")),array(date("n")),"");
		db_zs_schedule_set_last_execution($zs_schedule_id,date("Y-m-d H:i:s",time()-600));
		echo "yes";
		die();
	}

	if($action == "toggleTransfer") {
		if($taskInfo['zs_task_suspend_yn'] == "1" || $taskInfo['zs_task_inactive_yn'] == "1") {
			$lDB->put("UPDATE zs_task SET zs_task_suspend_yn = '0', zs_task_inactive_yn = '0' WHERE zs_task_ix = '$taskInfo[zs_task_ix]'");
			echo "enabled";
		} else {
			$lDB->put("UPDATE zs_task SET zs_task_inactive_yn = '1' WHERE zs_task_ix = '$taskInfo[zs_task_ix]'");
			echo "disabled";
		}
		die();
	}

	// Form code
	if(!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/transfer_auto.htm");
	}
	$GLOBALS['temp']['task_error_message'] = $taskErrorMessage;
	$GLOBALS['temp']['task_error_class'] = $taskErrorClass;
	$GLOBALS['temp']['task_status'] = $taskStatus;
	$GLOBALS['temp']['transfer_error_message'] = $transferErrorMessage;
	$GLOBALS['temp']['transfer_error_class'] = $transferErrorClass;
	$GLOBALS['temp']['switch_action'] = $switchAction;
	$GLOBALS['temp']['switch_image'] = $switchImage;



	$GLOBALS['temp']['last_success'] = $lastSuccess;
	if(trim($system) != "live") {
		$GLOBALS['temp']['trainingStyle'] = "display: none;";
	}
} else {
	// Backup the master setting of the database
	$tempMasterData = $GLOBALS['lDB']->isMaster;

	// Always set the database to master so it can run updates for this page
	$GLOBALS['lDB']->isMaster = "1";

	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/transfer_initiate.htm");
	}

	$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");

	# require some function libraries
	require_once "class.zip_extract.php";
	require_once "functions.transfer.offline.php";
	require_once "functions.transfer.common.php";

	# Set the timeout limit to 45 minutes
	@set_time_limit(2700);

	# Set some globals;
	global $trDataFolder;
	global $trDataBuffer;
	global $transferId;
	global $transferName;
	global $TDfolderName;
	global $TDfilePath;
	global $tdSendTime;
	global $trDataPassword;
	global $logFile;
	global $webroot;

	global $DTSERVERIP;

	global $sysLocked;

	$sysLocked = false;
	if ($lDB->get("select rf_sys_locked_yn from rf_system",4) == "1") {
		$sysLocked = true;
	}

	$dtServerName = "DTremoteHost".$GLOBALS['remoteDbCode'];
	$DTSERVERIP = $GLOBALS[$dtServerName];

	$webroot = $_SERVER['DOCUMENT_ROOT'];

	if ($webroot[(strlen($webroot)-1)] != "/") {
		$webroot .= "/";
	}

	$doTransfer = isset($_POST['doTransfer']) && $_POST['doTransfer'] == "true"?true:"none";
	$trdoTransfer = $doTransfer;


	# # # # # # # # # # # # # # # # # # # #
	# Process Control for Offline Server. #
	# # # # # # # # # # # # # # # # # # # #

	if ($_SERVER['argv'][1] != "") {
		$transferId = $_SERVER['argv'][1];

		$sql = "select count(*) from tc_transfer where tc_transfer.tc_transfer_ix = '".$transferId."' and tc_trf_time_close = '0000-00-00 00:00:00'";
		$count = $lDB->get($sql,4);
		if ($count > 0 ){
			# Step 2 - Determine transfer state
			if (determineTransferStateDT4() == "1") {
				recoverTransferInfoDT32();

				$HTML = join("",file(__DIR__ . "/../../../public/html/transfer_details.htm"));
				$HTML = showpage($trDataBuffer,$HTML);
				echo $HTML;
				flush();
				setProgressReport("Undoing transfer..");
				callException(1055);
				abortTransferDT8();
				endProcessTD();
			}
		}
	}

	$GLOBALS['temp']['allowSubmit'] = "";
	# Step 1 - Check for valid password
	if ($doTransfer === true) {
		processTransferDT2();
		endProcessTD();
	} else {
		if($doTransfer == "none" && trim($system) == "live") {
			$trDataBuffer['error_message'] = "";
			displayPasswordScreenDT1();
		} else {
			$GLOBALS['temp']['welcometxt'] = "Unable to perform data transfer!";
			$GLOBALS['temp']['lastdate'] = chng_date(date("Y-m-d"),date("H:i:s"));
			$GLOBALS['temp']['lasttime'] = date("H:i:s");
			$GLOBALS['temp']['error_message'] = "This is a $system system and is therefore not allowed to perform a data transfer. Please log out and log into your live system to perform this operation.";
			$GLOBALS['temp']['allowSubmit'] = "collapse";
			$GLOBALS['temp']['trainingStyle'] = "display: none;";
		}
	}

	// Restore the master setting to the database
	$GLOBALS['lDB']->isMaster = $tempMasterData;
}
