<?php

/**
 * init.form6000.func.php - Audit Trail Report
 * Job: 6000
 * Function: 6000 (Reports Audit: Audit trail)
 */

require_once(__DIR__ . '/db.ad_module_field.php');

class AuditTrailReport extends Report {
    var $Fields;
    var $Joins;
    var $Columns;
    var $Keys;
    var $GroupKeys;
    var $CSVFilters;

    function Config() {
        global $lDB;

        $this->Fields = array();
        $this->Joins = array();
        $this->Columns = array();
        $this->Keys = array();
        $this->GroupKeys = array();
        $this->CSVFilters = array();

        // Set any global Report properties
        $this->FilterWidths['label'] = "150";
        $this->FilterWidths['button'] = "130";

        $this->moduleFieldNames = $GLOBALS['lDB']->get("
			SELECT * FROM ad_module_field ORDER BY ad_module_field_description
		", 2);
        $returnFields = array();
        $returnFields[] = array('name'=>"ad_reservation.ad_res_time", 'table'=>"ad_reservation", 'isCompound'=>true, 'type'=>'string', 'fields'=>array("DATE_FORMAT(ad_reservation.ad_res_time, '%d %b %Y %k:%i:%s') AS ad_res_time"),'key'=>'ad_reservation.ad_res_time AS ad_res_time_key');
        $returnFields[] = array('name'=>"rf_database.rf_db_description", 'type'=>'string', 'fields'=>array("rf_database.rf_db_description AS rf_db_description"),'key'=>'rf_database.rf_db_description AS rf_db_description_key');
        $returnFields[] = array('name'=>"ad_reservation.rv_reservation_id", 'type'=>'string', 'fields'=>array("ad_reservation.rv_reservation_id AS rv_reservation_id"),'key'=>'ad_reservation.rv_reservation_id AS rv_reservation_id_key');
        $returnFields[] = array('name'=>"user.fullname", 'table'=>"user", 'isCompound'=>true, 'type'=>'string', 'fields'=>array("IFNULL(CONCAT(CONCAT(user.pr_name_first, ' '), user.pr_name_last),user.pr_name_last) AS fullname"),'key'=>'user.pr_persona_ix AS fullname_key', 'orderByAlias'=>"fullname");
        $returnFields[] = array('name'=>"rf_audit_module.rf_audit_module_name", 'type'=>'string', 'fields'=>array("rf_audit_module.rf_audit_module_name AS rf_audit_module_name"),'key'=>'rf_audit_module.rf_audit_module_name AS rf_audit_module_name');
        $returnFields[] = array('name'=>"ad_action", 'type'=>'string', 'fields'=>array("CASE ad_res_detail.ad_res_detail_action_ind WHEN '1' THEN 'Add' WHEN '2' THEN 'Edit' WHEN '3' THEN 'Delete' END AS ad_action"),'key'=>'ad_res_detail.ad_res_detail_action_ind AS ad_res_detail_action_ind_key');
        foreach ($this->moduleFieldNames as $moduleFieldName) {
            // 'From' value
            $desc = formatFieldAlias($moduleFieldName['ad_module_field_description'], "description");
            $name = $desc . ".ad_res_detail_value_from_display";
            $type = db_ad_module_field_get_display_type_variable($moduleFieldName['ad_module_field_display_type_ind']);
            $fields = "$name AS " . $desc . "_from_val";
            $function = null;
            $returnField = array();
            $returnField['name'] = $name;
            $returnField['type'] = $type;
            $returnField['fields'] = array($fields);
            $returnField['key'] = $fields . "_key";
            $returnFields[] = $returnField;
            unset($returnField);
            // 'To' value
            $name = $desc . ".ad_res_detail_value_to_display";
            $type = db_ad_module_field_get_display_type_variable($moduleFieldName['ad_module_field_display_type_ind']);
            $fields = "$name AS " . $desc . "_to_val";
            $key = null;
            $function = null;
            $returnField = array();
            $returnField['name'] = $name;
            $returnField['type'] = $type;
            $returnField['fields'] = array($fields);
            $returnField['key'] = $fields . "_key";
            $returnFields[] = $returnField;
        }
        $this->Fields = $returnFields;

        // Add default fields
        $this->FieldsDefault = array(
            array('name'=>"ad_reservation.ad_res_time", 'type'=>'string', 'fields'=>array("DATE_FORMAT(ad_reservation.ad_res_time, '%d %b %Y %k:%i:%s') AS ad_res_time"), 'label'=>"Time", 'width'=>'120'),
            array('name'=>"rf_database.rf_db_description", 'type'=>'string', 'fields'=>array("rf_database.rf_db_description AS rf_db_description"), 'label'=>"Server", 'width'=>'70'),
            array('name'=>"ad_reservation.rv_reservation_id", 'type'=>'string', 'fields'=>array("ad_reservation.rv_reservation_id AS rv_reservation_id"), 'label'=>"Reservation #", 'width'=>'80'),
            array('name'=>"user.fullname", 'type'=>'string', 'fields'=>array("IFNULL(CONCAT(CONCAT(user.pr_name_first, ' '), user.pr_name_last),user.pr_name_last) AS fullname"), 'label'=>"User", 'width'=>'150'),
        );
        // Default joins
        $this->Joins['default'] = array(
            array('table'=>"pr_persona",'alias'=>"user",'type'=>"INNER",'on'=>"user.pr_persona_ix = ad_reservation.pr_user_id",'requires'=>"ad_reservation"),
            array('table'=>"rf_database",'alias'=>"rf_database",'type'=>"INNER",'on'=>"rf_database.rf_database_id = ad_reservation.rf_database_id",'requires'=>"ad_reservation"),
            array('table'=>"ad_res_detail",'alias'=>"ad_res_detail",'type'=>"INNER",'on'=>"ad_res_detail.ad_reservation_id = ad_reservation.ad_reservation_ix",'requires'=>"ad_reservation"),
            array('table'=>"ad_module_field",'alias'=>"ad_module_field",'type'=>"INNER",'on'=>"ad_module_field.ad_module_field_id = ad_res_detail.ad_module_field_id",'requires'=>"ad_res_detail"),
            array('table'=>"rf_audit_module",'alias'=>"rf_audit_module",'type'=>"LEFT",'on'=>"rf_audit_module.rf_audit_module_id = ad_module_field.rf_audit_module_id",'requires'=>"ad_module_field")
        );

        $joinsResAudit = array();
        $joinsResAudit[] = array('table'=>"ad_reservation");
        foreach ($this->moduleFieldNames as $moduleFieldName) {
            $desc = formatFieldAlias($moduleFieldName['ad_module_field_description']);
            $table = "ad_res_detail";
            $alias = $desc;
            $type = "LEFT";
            $on = "$desc.ad_reservation_id = ad_reservation.ad_reservation_ix AND $desc.ad_module_field_id = " . $moduleFieldName["ad_module_field_id"];
            $requires = "ad_reservation";
            $joinsResAudit[] = array('table'=>$table,'alias'=>$alias,'type'=>$type,'on'=>$on,'requires'=>$requires);
        }
        $this->Joins['resaudit'] = $joinsResAudit;

        $defaultWidth = "50";
        $groupings = array();
        $groupings[] = array('name'=>"ad_reservation.ad_res_time",'label'=>"Time",'format'=>"time",'align'=>"r",'width'=>$defaultWidth);
        $groupings[] = array('name'=>"rf_database.rf_db_description",'label'=>"Server",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $groupings[] = array('name'=>"ad_reservation.rv_reservation_id",'label'=>"Reservation #",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $groupings[] = array('name'=>"user.fullname",'label'=>"User",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $groupings[] = array('name'=>"rf_audit_module.rf_audit_module_name",'label'=>"Module",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $groupings[] = array('name'=>"ad_action",'label'=>"Action",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        foreach ($this->moduleFieldNames as $moduleFieldName) {
            if (!in_array($moduleFieldName['ad_module_field_display_type_ind'], array(DB_AD_RES_DETAIL_TYPE_CURRENCY, DB_AD_RES_DETAIL_TYPE_FLOAT, DB_AD_RES_DETAIL_TYPE_INTEGER))) {
                $desc   = formatFieldAlias($moduleFieldName['ad_module_field_description']);
                $label  = formatFieldAlias($moduleFieldName["ad_module_field_description"], "label");
                $format = $moduleFieldName["ad_module_field_display_type_ind"];
                $width  = $defaultWidth;
                $align  = "r";
                $name   = $desc . ".ad_res_detail_value_from_display";
                $groupings[] = array('name'=>$name, 'label'=>$label,'format'=>$format,'width'=>$width,'align'=>$align);
            }
        }
        $displayFields = array();
        $displayFields[] = array('name'=>"ad_reservation.ad_res_time",'label'=>"Time",'format'=>"time",'align'=>"r",'width'=>$defaultWidth);
        $displayFields[] = array('name'=>"rf_database.rf_db_description",'label'=>"Server",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $displayFields[] = array('name'=>"ad_reservation.rv_reservation_id",'label'=>"Reservation #",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $displayFields[] = array('name'=>"user.fullname",'label'=>"User",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $displayFields[] = array('name'=>"rf_audit_module.rf_audit_module_name",'label'=>"Module",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        $displayFields[] = array('name'=>"ad_action",'label'=>"Action",'format'=>"string",'align'=>"r",'width'=>$defaultWidth);
        foreach ($this->moduleFieldNames as $moduleFieldName) {
            $desc       = formatFieldAlias($moduleFieldName['ad_module_field_description']);
            $labelFrom  = formatFieldAlias($moduleFieldName["ad_module_field_description"] . " (Before)", "label");
            $labelTo    = formatFieldAlias($moduleFieldName["ad_module_field_description"] . " (After)", "label");
            $format     = $moduleFieldName["ad_module_field_display_type_ind"];
            $align      = "r";
            $nameFrom   = $desc . ".ad_res_detail_value_from_display";
            $nameTo     = $desc . ".ad_res_detail_value_to_display";
            $width      = $defaultWidth;

            $displayFields[] = array('name'=>$nameFrom, 'label'=>$labelFrom,'format'=>$format,'width'=>$width,'align'=>$align);
            $displayFields[] = array('name'=>$nameTo, 'label'=>$labelTo,'format'=>$format,'width'=>$width,'align'=>$align);
        }

        $fieldList = $GLOBALS['lDB']->get("
			SELECT
				ad_module_field_id as id,
				CONCAT(ad_module_field_description, ' (', rf_audit_module_name, ')') as namelast,
				ad_module_field.ad_module_field_display_type_ind
			FROM
				ad_module_field
				INNER JOIN rf_audit_module ON rf_audit_module.rf_audit_module_id = ad_module_field.rf_audit_module_id
			ORDER BY
				ad_module_field_description ASC
			", 2);

        $fieldVarianceOptions = array();
        $fieldVarianceOptions[""] = "Select a field";
        $fieldChangeOptions = array();
        $fieldChangeOptions[""] = "Select a field";
        foreach ($fieldList as $field) {
            if (in_array($field['ad_module_field_display_type_ind'], array(DB_AD_RES_DETAIL_TYPE_CURRENCY, DB_AD_RES_DETAIL_TYPE_FLOAT, DB_AD_RES_DETAIL_TYPE_INTEGER))) {
                $fieldVarianceOptions[$field['id']] = $field['namelast'];
            }
            $fieldChangeOptions[$field['id']] = $field['namelast'];
        }
        $this->AddParams(array(
            new ReportParamFilterDateRangeRadio("auditCreateDateRange","Audit trail time"),
            new ReportParamFilter("auditTrailUser"),
            new ReportParamFilter("auditTrailModule"),
            new ReportParamFilter("serverAudit"),
            new ReportParamFilter("auditTrailAction"),
            new ReportParamFilterCheckArea("fieldVarianceCheck","Variance",array(
                new ReportParamFilterSelect("fieldVariance", "Field", $fieldVarianceOptions, false, array('width'=>'100%'), true),
                new ReportParamFilterSelect("varianceDirection", "Direction", array("increase"=>"Increase", "decrease"=>"Decrease", "either"=>"Increase or Decrease"),false, array('width'=>'100%'), true),
                new ReportParamFilterSelect("varianceType", "Of", array("more"=>"More than", "less"=>"Less than", "equal"=>"Equal to"),false, array('width'=>'100%'), true),
                new ReportParamFilterText("varianceAmount", "Amount", false, array('placeholderText'=>"E.g. 1234.56")),
            )),
            new ReportParamFilterCheckArea("fieldChangeCheck","Change",array(
                new ReportParamFilterSelect("fieldChange", "Field", $fieldChangeOptions, false, array('width'=>'100%'), true),
                new ReportParamFilterLookup("fieldBefore", "Before", "6000", false, array('action'=>"lookupBefore", 'lookupArgs'=>"document.getElementById('fieldChangeSelect').value", 'placeholderText'=>"E.g. Provisional")),
                new ReportParamFilterLookup("fieldAfter", "After", "6000", false, array('action'=>"lookupAfter", 'lookupArgs'=>"document.getElementById('fieldChangeSelect').value", 'placeholderText'=>"E.g. Confirmed")),
            )),
            new ReportParamSection("reservation","Res filters",array(
                new ReportParamFilterCheckArea("createDateCheck","Reservation create date range",array(
                    new ReportParamFilterDateRange("createDateRange",false)
                )),
                new ReportParamFilter("status"),
                new ReportParamFilter("agent"),
                new ReportParamFilter("createdBy"),
                new ReportParamFilter("consultant"),
            )),
            new ReportParamSection("dataOptions","Data options",array(
                new ReportParamBuilder("display","Fields",$displayFields,false,false,array('availableWidth'=>"175")),
            ),false,array('filterLabelWidth'=>"40")),
        ));
    }

    function Build() {
        $fieldsDefaultNames = array();
        foreach ($this->FieldsDefault as $fieldDefault) {
            $fieldsDefaultNames[] = $fieldDefault['name'];
        }

        $fieldsDisplay = $this->GetParamValue("display");

        $joins = array_merge($this->Joins['default'],$this->Joins['resaudit']);

        $sqlBuilder = new ReportSQLBuilder(
            $fieldsDisplay,
            $this->Fields,
            $joins,
            $fieldsDefaultNames
        );

        $sql = new ReportSQL();
        $sql->setDistinct(true);

        $sql->Merge($sqlBuilder->SQL());

        // ad_reservation level filters
        $sql->AddWhere($this->ConcatParamSQL(array(
            "auditTrailUser",
            "auditTrailModule",
            "serverAudit",
            "auditTrailAction",
            "status",
            "agent",
            "createdBy",
            "consultant"
        )));
        $sql->AddFrom("INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = ad_reservation.rv_reservation_id");
        $auditCreateDateRange = $this->GetParam("auditCreateDateRange");
        $sql->AddWhere($auditCreateDateRange->SQL("
			AND (ad_reservation.ad_res_time >= '!fromDate! 00:00:00'
			AND ad_reservation.ad_res_time <= '!toDate! 23:59:59')
		"));
        unset($auditCreateDateRange);
        if($this->GetParamValue("auditTrailAction") != "" || $fieldsDisplay['ad_action']['active'] == '1') {
            $sql->AddSelect("CASE ad_res_detail.ad_res_detail_action_ind WHEN '1' THEN 'Add' WHEN '2' THEN 'Edit' WHEN '3' THEN 'Delete' END AS ad_action");
            $sql->AddFrom("INNER JOIN ad_res_detail ON ad_res_detail.ad_reservation_id = ad_reservation.ad_reservation_ix");
            $auditAction = $this->GetParam("auditTrailAction");
            $actions = explode(":", $this->GetParamValue("auditTrailAction"));
        }
        if($this->GetParamValue("auditTrailModule") != "") {
            $sql->AddFrom("INNER JOIN ad_res_detail ON ad_res_detail.ad_reservation_id = ad_reservation.ad_reservation_ix");
            $sql->AddFrom("INNER JOIN ad_module_field ON ad_module_field.ad_module_field_id = ad_res_detail.ad_module_field_id");
        }
        if ($this->GetParamValue("fieldVarianceCheck") == "1") {
            $sql->AddFrom("INNER JOIN ad_res_detail ON ad_res_detail.ad_reservation_id = ad_reservation.ad_reservation_ix");
            $field = $this->GetParamValue("fieldVariance");
            $varianceType = "";
            switch($this->GetParamValue("varianceType")) {
                case "more":
                    $varianceType = " > ";
                    break;
                case "less":
                    $varianceType = " < ";
                    break;
                case "equal":
                    $varianceType = " = ";
                    break;
            }
            $varianceDirection = "";
            switch($this->GetParamValue("varianceDirection")) {
                case "increase":
                    $varianceDirection = " AND (ard_variance.ad_res_detail_value_to_display - ard_variance.ad_res_detail_value_from_display) > 0 ";
                    break;
                case "decrease":
                    $varianceDirection = " AND (ard_variance.ad_res_detail_value_to_display - ard_variance.ad_res_detail_value_from_display) < 0 ";
                    break;
                case "either":
                    $varianceDirection = "";
                    break;
            }
            $varianceAmount = (is_numeric($this->GetParamValue("varianceAmount"))) ? $this->GetParamValue("varianceAmount") : 0;
            $varianceOnAggregate = $this->GetParamValue("varianceOnAggregateCheck");
            $sql->AddFrom("
				INNER JOIN ad_res_detail ard_variance ON ard_variance.ad_reservation_id = ad_reservation.ad_reservation_ix AND ard_variance.ad_module_field_id = '$field'
			");
            $sql->AddWhere("
				AND ABS(ard_variance.ad_res_detail_value_to_display - ard_variance.ad_res_detail_value_from_display) $varianceType $varianceAmount $varianceDirection
			");
        }
        if($this->GetParamValue("fieldChangeCheck") == "1") {
            $sql->AddFrom("INNER JOIN ad_res_detail ON ad_res_detail.ad_reservation_id = ad_reservation.ad_reservation_ix");
            $field = $this->GetParamValue("fieldChange");
            $fieldValueBefore = $this->GetParamValue("fieldBefore");
            $fieldValueAfter = $this->GetParamValue("fieldAfter");
            $sql->AddFrom("
				INNER JOIN ad_res_detail ard_change ON ard_change.ad_reservation_id = ad_reservation.ad_reservation_ix AND ard_change.ad_module_field_id = '$field'
			");
            $where = "";
            if (trim($fieldValueBefore) != "") {
                $where .= " ard_change.ad_res_detail_value_from_display = '$fieldValueBefore' ";
            }
            if (trim($fieldValueAfter) != "") {
                if (strlen($where) > 0) {
                    $where .= " AND ";
                }
                $where .= " ard_change.ad_res_detail_value_to_display = '$fieldValueAfter' ";
            }
            if (strlen($where) > 0) {
                $where = "AND ( " . $where . ")";
                $sql->AddWhere("
					$where
				");
            }
        }

        // Reservation filters
        if($this->GetParamValue("createDateCheck") == "1") {
            $reservationCreateDateRange = $this->GetParam("createDateRange");
            $sql->AddWhere($reservationCreateDateRange->SQL("
				AND rv_reservation.rv_date_recorded BETWEEN '!fromDate!' AND '!toDate!'
			"));
            unset($reservationCreateDateRange);
        }

        // Sort columns according to user
        if ($this->GetParamValue("display")) {
            $this->SortColumns($this->GetParamValue("display"), 'order');
        }
        // Setup sorting/display and other options
        $sortDirection = array();
        $sortSequence = array();
        if ($this->GetParamValue("display")) {
            foreach ($this->GetParamValue("display") as $name => $fieldData) {
                $defaultWidth = "100%";
                if(isset($fieldData['active']) && $fieldData['active'] == "1") {
                    $labels = "";
                    $col = array(
                        'format'=>"",
                        'cols'=>array(
                            'label'=>array('value'=>(isset($fieldData['cols']['label']['value']) && !empty($fieldData['cols']['label']['value'])) ? $fieldData['cols']['label']['value'] : $fieldData['label']),
                            'width'=>array('value'=>(isset($fieldData['cols']['width']['value']) && !empty($fieldData['cols']['width']['value'])) ? $fieldData['cols']['width']['value'] : $defaultWidth)
                        ),
                    );
                    $this->AddColumn($name,$labels,$col,$class=false,$format=false);
                    if (isset($fieldData['cols']['sort_order']['value']) && !empty($fieldData['cols']['sort_order']['value'])) {
                        $sortSequence[$fieldData['cols']['sort_order']['value']] = $fieldData['name'];
                    }
                    if (isset($fieldData['cols']['sort_direction']['value']) && !empty($fieldData['cols']['sort_direction']['value'])) {
                        $sortDirection[$fieldData['name']] = $fieldData['cols']['sort_direction']['value'];
                    }
                }
            }
        }

        $order = array();
        if (count($sortSequence) > 0) {
            ksort($sortSequence);
            foreach ($sortSequence as $sequence => $fieldName) {
                $directionValue = $sortDirection[$fieldName];
                $direction = ($directionValue == "a") ? "ASC" : "DESC";
                $orderByField = $this->getOrderByFieldAlias($fieldName);
                $order[] = $orderByField . " " . $direction;
            }
            $sql->AddOrder($order);
        } else {
            $sql->AddOrder(array("ad_reservation.ad_res_time","ad_reservation.pr_user_id"));
        }

        if (count($this->Columns) == 0) {
            // Add default columns
            foreach ($this->FieldsDefault as $fieldData) {
                $labels = "";
                $col = array(
                    'format'=>"",
                    'cols'=>array(
                        'label'=>array('value'=>$fieldData['label']),
                        'width'=>array('value'=>$fieldData['width'])
                    ),
                );
                $this->AddColumn($fieldData['name'],$labels,$col,$class=false,$format=false);
            }
        }

        $data = $sql->Run();

        // Deactivated groupings for now - Need to speak to Dylan about what's needed for it
        $groupings = false;
        $sqlBuilder->Render($data,$groupings);

        $this->Data = $data;

        $this->BuildReference();
        $this->SortData();
    }

    function HTML() {
        $this->Padding = 2;

        if(sizeof($this->Data) > 0) {
            $html = "
				<script type=\"text/javascript\">
					function rowOver(num) {
						var count = 1;
						while(id(\"data_\" + num.toString() + \"_\" + count.toString())) {
							id(\"data_\" + num.toString() + \"_\" + count.toString()).style.backgroundColor = \"#F2F2F2\";
							count++;
						}
					}

					function rowOut(num) {
						var count = 1;
						while(id(\"data_\" + num.toString() + \"_\" + count.toString())) {
							id(\"data_\" + num.toString() + \"_\" + count.toString()).style.backgroundColor = \"\";
							count++;
						}
					}

					function colOver(num) {
						var count = 0;
						while(id(\"column_\" + count.toString() + \"_\" + num.toString())) {
							id(\"column_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"#F2F2F2\";
							count++;
						}

						var count = 1;
						while(id(\"data_\" + count.toString() + \"_\" + num.toString())) {
							id(\"data_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"#F2F2F2\";
							count++;
						}
					}

					function colOut(num) {
						var count = 0;
						while(id(\"column_\" + count.toString() + \"_\" + num.toString())) {
							id(\"column_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"\";
							count++;
						}

						var count = 1;
						while(id(\"data_\" + count.toString() + \"_\" + num.toString())) {
							id(\"data_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"\";
							count++;
						}
					}

					function scrollHeader() {
						id(\"data\").scrollLeft = id(\"header\").scrollLeft;
					}

					function scrollData() {
						id(\"header\").scrollLeft = id(\"data\").scrollLeft;
					}

				</script>

				<div id=\"drillDown\" class=\"colLtt\" style=\"position:absolute; display: none; width:600px; height: 490px; z-index:100\">
				</div>
				<div id=\"header\" class=\"scrollX\" style=\"width: 770px;\" onscroll=\"scrollHeader();\">
					<table align=\"left\" width=\"".($this->TotalColumnWidth())."\" border=\"0\" cellspacing=\"0\" cellpadding=\"".$this->Padding."\" style=\"table-layout: fixed;\">
			";

            $html .= $this->HTMLColumnHeaders();

            $html .= "
					</table>
				</div>
				<div id=\"data\" class=\"scrollXY\" style=\"width:770px; height: 600px;\" onscroll=\"scrollData();\">
					<table align=\"left\" width=\"".($this->TotalColumnWidth())."\" border=\"0\" cellspacing=\"0\" cellpadding=\"".$this->Padding."\" style=\"table-layout: fixed;\">
					";

            foreach($this->Columns as $col) {
                $html .= "<col style=\"width: $col[width]px\" />\n";
            }
            $html .= "<col style=\"width: 20px\" />\n";

            $rowNum = 1;
            foreach($this->Data as $key=>$item) {
                $reservationId = isset($item['ad_reservation.rv_reservation_id']) ? $item['ad_reservation.rv_reservation_id'] : "";

                $html .= "<tr>\n";
                $colNum = 1;
                foreach($this->Columns as $col) {
                    $class = "";
                    if(isset($col['class']) && !empty($col['class'])) {
                        $class = "class=\"". $col['class'] . "\"";
                    }
                    $value = isset($item[$col['field']]) ? $item[$col['field']] : "";
                    if($value === "") { $value = "&nbsp;"; }
                    $onclick = "onclick=\"null;\"";
                    $html .= "<td id=\"data_".$rowNum."_".$colNum."\" onmouseover=\"rowOver(".$rowNum.");\" onmouseout=\"rowOut(".$rowNum.")\" $class align=\"$col[align]\" $onclick style=\"overflow: hidden;\">$value</td>\n";
                    $colNum++;
                }
                $reservationId =
                $html .= "<td class\"outDk\" align=\"center\"> <input type=\"button\" class=\"button bDropDown\" value=\"  \" style=\"width:14; height:18; background-position: center center;\" onclick=\"showMenu(event,'$reservationId');\"> </td>";
                $html .= "</tr>\n";
                $rowNum++;
            }

            if($this->GetParamValue("includeTotalRows") == "1") {
                $html .= "<tr><td class=\"outLtt\" colspan=\"".sizeof($this->Columns)."\">Totals</td></tr>\n";
                foreach($this->Totals as $item) {
                    $html .= "<tr>\n";
                    foreach($this->Columns as $col) {
                        $class = "";
                        if(isset($col['class']) && !empty($col['class'])) {
                            $class = "class=\"". $col['class'] . "\"";
                        }
                        $value = $item[$col['field']];
                        if($value === "") { $value = "&nbsp;"; }
                        $html .= "<td $class align=\"$col[align]\">$value</td>\n";
                    }
                    $html .= "</tr>\n";
                }
            }

            $html .= "
					</table>
				</div>
			";

            $html .= "
				<div>
					<div id=\"menuDiv\" class=\"overlayPopup\" style=\"position: absolute; top: 10px; left: 10px; border: 2px solid #dfdfdf; display: none;\" onclick=\"event.cancelBubble = true;\">
						<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"outLt\">
						<tr>
							<td class=\"colLt\">
								<table width=\"125\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
								<tr>
									<td width=\"110\" class=\"txtb\">Options</td>
									<td width=\"15\" align=\"right\" onclick=\"window.click();\"><img src=\"/resource/Resrequest/Application/public/img/close.gif\" class=\"imgLink\" alt=\"\" /></td>
								</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">
								<tr id=\"menuReservationRow\" class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#F2F2F2';\" onmouseout=\"this.style.backgroundColor='';\" onclick=\"event.cancelBubble = true; window.location = '/reservation.php?2+' + reservationId;\">
									<td width=\"20\"><img src=\"/resource/Resrequest/Application/public/img/icon_reservation_16.gif\"></td>
									<td width=\"4\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
									<td width=\"100%\">View Reservation</td>
								</tr>
								<tr id=\"menuAuditTrailRow\" class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#F2F2F2';\" onmouseout=\"this.style.backgroundColor='';\" onclick=\"openPopup('/reservation.php?700+' + reservationId,700,340); window.click();\">
									<td><img src=\"/resource/Resrequest/Application/public/img/button_audit.gif\"></td>
									<td width=\"4\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
									<td>View Audit Trail</td>
								</tr>
								</table>
							</td>
						</tr>
						</table>
					</div>
				</div>
				";
        } else {
            $html = "
				<table width=\"770\">
				<tr>
					<td width=\"100%\" align=\"center\" class=\"txti\">No data found based on specified filter criteria.</td>
				</tr>
				</table>
			";
        }
        return $html;
    }

    function CSV() {
        $csv = array();
        $csv[] = array("Report",$this->Title);
        $csv = array_merge($csv,$this->CSVFilters());

        $csv[] = array();
        if(sizeof($this->Data) > 0) {
            $csv = array_merge($csv,$this->CSVColumnHeaders());

            foreach($this->Data as $item) {
                $row = array();
                foreach($this->Columns as $col) {
                    $value = $item[$col['field']];
                    $row[] = $value;
                }
                $csv[] = $row;
                if (isset($html)) {
                    $html .= "</tr>\n";
                } else {
                    $html = "</tr>\n";
                }
            }
        } else {
            $csv = array(
                array("No data found based on specified filter criteria.")
            );
        }
        return $csv;
    }

    function CSVColumnHeaders() {
        $this->SpanColumnLabels();
        $max = $this->MaxColumnLabels();

        $csv = array();
        for($count=0;$count<$max;$count++) {
            $row = array();
            foreach($this->Columns as $col) {
                if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
                    $row[] = $col['labels'][$count];
                } else {
                    $row[] = "";
                }
            }
            $csv[] = $row;
        }
        return $csv;;
    }

    function CSVFilters() {
        $csv = array();

        foreach($this->CSVFilters as $filter) {
            $csv = array_merge($csv,$this->CSVFilter($filter));
        }

        return $csv;
    }

    function TotalColumnWidth() {
        $width = 0;
        foreach($this->Columns as $col) {
            $width += $col['width'] + ($this->Padding * 2);
        }
        return $width;
    }

    function HTMLColumnHeaders() {
        $this->SpanColumnLabels();
        $html = "";
        $max = $this->MaxColumnLabels();

        foreach($this->Columns as $col) {
            $html .= "<col style=\"width: $col[width]px\" />\n";
        }
        $html .= "<col style=\"width: 20px\" />\n";

        for($count=1;$count<$max;$count++) {
            $html .= "<tr>\n";
            $colNum = 1;
            foreach($this->Columns as $col) {
                if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
                    $rowspan = "";
                    if($count == (sizeof($col['labels']) - 1) && sizeof($col['labels']) < $max) {
                        $rowspan = "rowspan=\"" .($max - sizeof($col['labels']) + 1). "\"";
                    }

                    $align = $col['align'];
                    $colspan = "";
                    if($col['spans'][$count] > 1) {
                        $colspan = "colspan=\"".$col['spans'][$count]."\"";
                        $align = "center";
                    }
                    $hover = "";
                    if(empty($col['class'])) {
                        $hover = "onmouseover=\"colOver(".$colNum.");\" onmouseout=\"colOut(".$colNum.");\"";
                    }
                    $html .= "<td id=\"column_".$count."_".$colNum."\" $hover class=\"outDk\" $colspan $rowspan align=\"$align\" style=\"overflow: hidden;\">" . (!is_array($col['labels'][$count]) ? $col['labels'][$count] : "Array") . "</td>\n";
                    // If $col['labels'][$count] is an array, it produces a php5 error. In 5.25.0 the column label
                    // is then displayed as "Array", but until this is fixed for php5, we'll show the label as "Array"
                }
                $colNum++;
            }
            $html .= "<td class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>\n";
            $html .= "</tr>\n";
        }
        return $html;
    }

    function SpanColumnLabels() {
        $last = false;
        $lastKey = false;

        foreach($this->Columns as $key=>$col) {
            if($lastKey === false) {
                $lastKey = array_fill(0,sizeof($col['labels']),$key);
                $last = $col['labels'];
                $this->Columns[$key]['spans'] = array_fill(0,sizeof($col['labels']),1);
            } else {
                $check = false;
                $done = false;
                foreach($col['labels'] as $id=>$label) {
                    if($done) { continue; }
                    if(isset($last[$id]) && $last[$id] == $label) {
                        $this->Columns[$lastKey[$id]]['spans'][$id]++;
                        $this->Columns[$key]['spans'][$id] = 0;
                    } else {
                        for($count = $id; $count < sizeof($col['labels']); $count++) {
                            $lastKey[$count] = $key;
                            $last[$count] = $col['labels'][$count];
                            $this->Columns[$key]['spans'][$count] = 1;
                        }
                        $done = true;
                    }
                }
            }
        }
    }

    function MaxColumnLabels() {
        $max = 0;
        foreach($this->Columns as $col) {
            if(sizeof($col['labels']) > $max) {
                $max = sizeof($col['labels']);
            }
        }
        return $max;
    }

    function BuildReference() {
        $this->Reference = array();
        foreach($this->Data as $key=>$data) {
            if(!array_key_exists($key,$this->Reference)) {
                $this->Reference[$key] = array();
            }
        }
    }

    function SortData() {
        $this->Sort = array();
        foreach($this->Columns as $col) {
            if(!empty($col['sort'])) {
                $this->Sort[$col['field']] = array('sort'=>$col['sort'],'direction'=>$col['direction']);
            }
        }
        if(sizeof($this->Sort) > 0) {
            uasort($this->Sort,'compareSort');
            uasort($this->Data,'compareData');
        }
    }

    function SortColumns(&$arr, $col, $dir = SORT_ASC) {
        $sort_col = array();
        foreach ($arr as $key=> $row) {
            $sort_col[$key] = $row[$col];
        }

        array_multisort($sort_col, $dir, $arr);
    }

    function AddColumn($field,$labels,$col,$class=false,$format=false) {
        if(!is_array($labels)) {
            $labels = array($labels);
            $labels[] = $col['cols']['label']['value'];
        }

        if(!empty($col['cols']['header']['value'])) {
            $header = array_shift($labels);
            array_unshift($labels,$header,$col['cols']['header']['value']);
        }

        if(!empty($col['cols']['width']['value'])) {
            $width = $col['cols']['width']['value'];
        } else {
            $width = 100;
        }

        $col['cols']['align']['value'] = isset($col['cols']['align']['value']) ? $col['cols']['align']['value'] : "l";

        switch($col['cols']['align']['value']) {
            case "l":
                $align = "left";
                break;
            case "r":
                $align = "right";
                break;
            case "c":
                $align ="center";
                break;
        }

        if(empty($class)) {
            $class = "";
        }

        if($format === false && isset($col['format'])) {
            $format = $col['format'];
        }

        if(!isset($col['total'])) {
            $col['total'] = "";
        }

        $this->Columns[] = array(
            'field'=>$field,
            'labels'=>$labels,
            'sort'=>(isset($col['cols']['sort_order']['value']) ? $col['cols']['sort_order']['value'] : ""),
            'direction'=>(isset($col['cols']['sort_direction']['value']) ? $col['cols']['sort_direction']['value'] : ""),
            'width'=>$width,
            'align'=>$align,
            'class'=>$class,
            'format'=>$format,
            'total'=>$col['total']
        );
    }

    function getOrderByFieldAlias($fieldName) {
        foreach ($this->Fields as $key => $val) {
            if ($val['name'] === $fieldName) {
                $orderByAlias = isset($val['orderByAlias']) ? $val['orderByAlias'] : $fieldName;
                return $orderByAlias;
            }
        }
        return $fieldName;
    }
}