<?php

require_once(__DIR__ . "/db.bl_block.php");
require_once(__DIR__ . "/db.bl_block_period.php");
require_once(__DIR__ . "/db.bl_block_itinerary.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/functions.reservation.advanced.php");
require_once(__DIR__ . "/functions.php");
require_once(__DIR__ . "/class.template.php");
require_once(__DIR__ . "/db.sc_group.php");
require_once(__DIR__ . "/functions.reservation.block.php");

function validateBlockBooking(array $params) {
	$params['bl_block_ix'] = isset($params['bl_block_ix']) ? $params['bl_block_ix'] : "";
	$params['bl_block_name'] = isset($params['bl_block_name']) ? $params['bl_block_name'] : "";
	$params['bl_block_abbrev'] = isset($params['bl_block_abbrev']) ? $params['bl_block_abbrev'] : "";

	$message = array();
	$duplicateBlockNames = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			bl_block
		WHERE
			bl_block_ix != '". $params['bl_block_ix'] ."'
			AND bl_block_name = '" . $params['bl_block_name'] . "'
	", 4);
	$hasDuplicate = $duplicateBlockNames > 0 ? true : false;
	if ($hasDuplicate) {
		$message[] = "A block template with the name '". $params['bl_block_name'] . "' already exists. Please enter a different name";
	}
	$duplicateBlockAbbrev = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			bl_block
		WHERE
			bl_block_ix != '". $params['bl_block_ix'] ."'
			AND bl_block_abbrev = '" . $params['bl_block_abbrev'] . "'
			AND bl_block_abbrev != ''
			AND bl_block_abbrev IS NOT NULL
	", 4);
	$hasDuplicate = $duplicateBlockAbbrev > 0 ? true : false;
	if ($hasDuplicate) {
		$message[] = "A block template with the abbreviation '". $params['bl_block_abbrev'] . "' already exists. Please enter a different abbreviation";
	}
	$valid = count($message) > 0 ? false : true;

	return array($valid, $message);
}

function updateBlockBooking(array $params) {
	$reload = "false";
	$params['bl_block_ix'] = isset($params['bl_block_ix']) ? $params['bl_block_ix'] : "";
	$params['bl_block_name'] = isset($params['bl_block_name']) ? $params['bl_block_name'] : "";
	$params['bl_block_abbrev'] = isset($params['bl_block_abbrev']) ? $params['bl_block_abbrev'] : "";
	$params['rv_consultant_id'] = isset($params['rv_consultant_id']) ? $params['rv_consultant_id'] : "";
	$params['rv_agent_id'] = isset($params['rv_agent_id']) ? $params['rv_agent_id'] : "";
	$params['rv_agent_contact_persona_id'] = isset($params['rv_agent_contact_persona_id']) ? $params['rv_agent_contact_persona_id'] : "";
	$params['rv_agent_ref'] = isset($params['rv_agent_ref']) ? $params['rv_agent_ref'] : "";
	$params['rt_rate_type_id'] = isset($params['rt_rate_type_id']) ? $params['rt_rate_type_id'] : "";
	$params['bl_block_commission_perc'] = isset($params['bl_block_commission_perc']) ? $params['bl_block_commission_perc'] : "";
	$params['bl_block_note'] = isset($params['bl_block_note']) ? $params['bl_block_note'] : "";
	$params['bl_block_note_internal'] = isset($params['bl_block_note_internal']) ? $params['bl_block_note_internal'] : "";
	$params['blockPeriods'] = isset($params['blockPeriods']) ? unserialize(stripslashes($params['blockPeriods'])) : array();
	$params['blockItineraries'] = isset($params['blockItineraries']) ? unserialize(stripslashes($params['blockItineraries'])) : array();

	$blockPeriodNewIds = array();
	foreach ($params['blockPeriods'] as $period) {
		switch ($period['action']) {
			case 'new':
				$reload = "true";
				$bl_block_period_ix = db_bl_block_period_insert(
					$period['bl_block_id'],
					$period['bl_per_date_start_series_fst'],
					$period['bl_per_date_start_series_lst'],
					$period['bl_per_recurrence_per_ind'],
					$period['bl_per_recurrence_per_1'],
					$period['bl_per_recurrence_per_2'],
					$period['bl_per_recurrence_per_3'],
					$period['bl_per_recurrence_per_4'],
					$period['bl_per_recurrence_per_5'],
					$period['bl_per_expiry_ind'],
					$period['bl_per_expiry_lead_time_days'],
					$period['bl_per_expiry_lead_time_date']);
				$blockPeriodNewIds[$period['bl_block_period_ix']] = $bl_block_period_ix;
				break;
			default:
				break;
		}
	}
	foreach ($params['blockItineraries'] as $itinerary) {
		switch ($itinerary['action']) {
			case 'new':
				$reload = "true";
				$bl_block_period_id = isset($blockPeriodNewIds[$itinerary['bl_block_period_id']]) ? $blockPeriodNewIds[$itinerary['bl_block_period_id']] : $itinerary['bl_block_period_id'];
				db_bl_block_itinerary_insert(
					$bl_block_period_id,
					$itinerary['ac_accomm_type_id'],
					$itinerary['rt_rate_type_id'],
					$itinerary['bl_itinerary_day_start'],
					$itinerary['bl_itinerary_day_end'],
					$itinerary['bl_block_itinerary_rooms'],
					$itinerary['bl_block_itinerary_pax']);
				break;
			case 'update':
				$reload = "true";
				db_bl_block_itinerary_update(
					$itinerary['bl_block_itinerary_ix'],
					$itinerary['ac_accomm_type_id'],
					$itinerary['rt_rate_type_id'],
					$itinerary['bl_itinerary_day_start'],
					$itinerary['bl_itinerary_day_end'],
					$itinerary['bl_block_itinerary_rooms'],
					$itinerary['bl_block_itinerary_pax']);
			default:
				break;
		}
	}
	db_bl_block_update(
		$params['bl_block_ix'],
		$params['bl_block_name'],
		$params['bl_block_abbrev'],
		$params['rv_consultant_id'],
		$params['rv_agent_id'],
		$params['rv_agent_contact_persona_id'],
		$params['rv_agent_ref'],
		$params['rt_rate_type_id'],
		$params['bl_block_commission_perc'],
		$params['bl_block_note'],
		$params['bl_block_note_internal']);
	$ad_modify_date = $GLOBALS['lDB']->get("
		SELECT
			ad_modify_date
		FROM
			bl_block
		WHERE
			bl_block_ix = '".$params['bl_block_ix']."'
	",4);
	return array(formatValue($ad_modify_date, "datetime"),$reload,array_values($blockPeriodNewIds));
}

function getBlockBookingDetails($bl_block_ix) {
	$blockDetails = $GLOBALS['lDB']->get("
		SELECT
			bl_block.bl_block_ix,
			bl_block.bl_block_name,
			bl_block.bl_block_abbrev,
			bl_block.ad_create_date,
			TRIM(CONCAT(create_user.pr_name_first, ' ', create_user.pr_name_last)) AS create_user_name,
			bl_block.ad_modify_date,
			TRIM(CONCAT(modify_user.pr_name_first, ' ', modify_user.pr_name_last)) AS modify_user_name,
			bl_block.rv_consultant_id,
			bl_block.rv_agent_id,
			TRIM(CONCAT(agent.pr_name_first, ' ', agent.pr_name_last)) AS rv_agent_name,
			bl_block.rv_agent_contact_persona_id,
			bl_block.rv_agent_contact_persona_id AS rv_corr_persona_id,
			TRIM(CONCAT(agent_contact.pr_name_first, ' ', agent_contact.pr_name_last)) AS rv_agent_contact_persona_name,
			bl_block.rv_agent_ref,
			bl_block.rt_rate_type_id,
			bl_block.bl_block_commission_perc,
			bl_block.bl_block_note,
			bl_block.bl_block_note_internal
		FROM
			bl_block
			LEFT JOIN pr_persona agent_contact ON agent_contact.pr_persona_ix = bl_block.rv_agent_contact_persona_id
			LEFT JOIN pr_persona agent ON agent.pr_persona_ix = bl_block.rv_agent_id
			LEFT JOIN pr_persona create_user ON create_user.pr_persona_ix = bl_block.ad_create_user_id
			LEFT JOIN pr_persona modify_user ON modify_user.pr_persona_ix = bl_block.ad_modify_user_id
			LEFT JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' AND allocation.rf_reservation_status_id != '97'
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix 
			LEFT JOIN rv_reservation_item allocation_item_expired ON allocation_item_expired.rv_reservation_item_ix = allocation_item.rv_reservation_item_ix AND allocation_item.rv_alloc_expiry_date < CURDATE() 
			LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			bl_block.bl_block_ix = '$bl_block_ix'
	",1);
	if (!empty($blockDetails)) {
		$block_draw_down_reservations = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				rv_reservation.rv_reservation_ix
			FROM
				bl_block
				INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
				INNER JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix
				INNER JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation.rf_reservation_status_id != '15'
				AND rv_reservation.rf_reservation_status_id != '97'
				AND bl_block.bl_block_ix = '$blockDetails[bl_block_ix]'
		", 3);

		$blockDetails["reservation_draw_downs"] = count($block_draw_down_reservations);
		$drawDowns = implode(",",$block_draw_down_reservations);
		$blockDetails['block_draw_down_reservations'] = $drawDowns;

		$series = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				bl_series_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_item_accomm_count > 0 AND allocation_item.bl_series_sequence_number IS NOT NULL
			WHERE
				bl_block_period.bl_block_id = '$blockDetails[bl_block_ix]'
				AND allocation_item.bl_series_id IS NOT NULL",3);
		$blockDetails['block_series_total'] = count($series);

		$expiredSeries = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				bl_series_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
				LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_item_accomm_count > 0 AND allocation_item.bl_series_sequence_number IS NOT NULL
			WHERE
				bl_block_period.bl_block_id = '$blockDetails[bl_block_ix]'
				AND allocation_item.rv_alloc_expiry_date < CURDATE()
				AND allocation_item.bl_series_id IS NOT NULL",3);
		$blockDetails['block_series_expired'] = count($expiredSeries);
	} else {
		$blockDetails["reservation_draw_downs"] = 0;
		$blockDetails['block_series_total'] = 0;
		$blockDetails['block_series_expired'] = 0;
	}

	$blockDetails['sc_grp_res_ovr_overbooking_yn'] = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");

	return $blockDetails;
}

function setBlockBookingDetails($blockDetails, &$target) {
	$fields = array(
		"bl_block_ix"=>array(),
		"bl_block_name"=>array(),
		"bl_block_abbrev"=>array(),
		"ad_create_date"=>array("format"=>"datetime"),
		"create_user_name"=>array(),
		"ad_modify_date"=>array("format"=>"datetime"),
		"modify_user_name"=>array(),
		"rv_consultant_id"=>array(),
		"rv_agent_id"=>array(),
		"rv_agent_name"=>array(),
		"rv_agent_contact_persona_id"=>array(),
		"rv_corr_persona_id"=>array(),
		"rv_agent_contact_persona_name"=>array(),
		"rv_agent_ref"=>array(),
		"rt_rate_type_id"=>array(),
		"bl_block_commission_perc"=>array(),
		"bl_block_note"=>array(),
		"bl_block_note_internal"=>array(),
		"block_series_expired"=>array(),
		"block_series_total"=>array(),
		"block_draw_down_reservations"=>array(),
		"reservation_draw_downs"=>array(),
		"sc_grp_res_ovr_overbooking_yn"=>array()
	);
	foreach ($fields as $name=>$options) {
		if (isset($options["format"])) {
			$target[$name] = isset($blockDetails[$name]) ? formatValue($blockDetails[$name],$options["format"]) : "";
		} else {
			$target[$name] = isset($blockDetails[$name]) ? $blockDetails[$name] : "";
		}
	}
	$target['userName'] = $GLOBALS['username'];
	$target['serverName'] = $GLOBALS['server'];
	$target['now'] = chng_date(date("Y-m-d H:i:s"),"-",5);
	$consultantList = $GLOBALS['lDB']->get("
		SELECT
			sc_user.pr_user_id,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_inactive_yn
		FROM
			sc_group
			INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
			INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
		WHERE
			sc_group.sc_grp_consultant_yn=1
			AND (
				pr_persona.pr_persona_inactive_yn=0
			)
		ORDER BY
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
	",2);

	$target['agentDefaultRate'] = "";
	$rate_description = "";
	$rv_agent_id = (!empty($blockDetails) && isset($blockDetails['rv_agent_id']))?$blockDetails['rv_agent_id']:"";
	list($target['agentDefaultRate'], $rate_description) = getAgentDefaultRate($rv_agent_id);
	$rv_consultant_id = isset($blockDetails['rv_consultant_id']) ? $blockDetails['rv_consultant_id'] : "";
	$consultantOptions = isset($blockDetails['rv_consultant_id']) ? "" : "<option selected value=\"\">Select a consultant</option>";
	foreach($consultantList as $item) {
		$selected = "";
		if($item['pr_user_id'] == $rv_consultant_id) {
			$selected = " selected ";
		}
		$consultantName = trim($item['pr_name_last']);
		$consultantValue = $item['pr_user_id'];
		if(trim($item['pr_name_first']) != "") {
			if($consultantName != "") {
				$consultantName .= ", ";
			}
			$consultantName .= trim($item['pr_name_first']);
		}
		if($item['pr_persona_inactive_yn'] == "1") {
			$consultantName = "* " . $consultantName;
			$consultantValue = "";
		}
		$consultantOptions .= "<option $selected value=\"$consultantValue\">$consultantName</option>";
	}
	$target['selConsultantOptions'] = $consultantOptions;

	$rt_rate_type_ix = isset($blockDetails['rt_rate_type_id']) ? $blockDetails['rt_rate_type_id'] : "";

	if(trim($rt_rate_type_ix) == "" || $rt_rate_type_ix == "0") {
		$rt_rate_type_ix = $GLOBALS['lDB']->get("
			SELECT
				pr_agent_rate.rt_rate_type_id
			FROM
				pr_agent_rate
				INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
			WHERE
				pr_agent_id = '$rv_agent_id'
			ORDER BY
				pr_agent_rate_default_yn DESC,
				rt_rate_type.rt_rate_type_desc ASC
		",4);
		if(trim($rt_rate_type_ix) == "" || $rt_rate_type_ix == "0") {
			$rt_rate_type_ix = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
		}
	}
	$rateInfo = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol
		FROM
			rt_rate_type
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			rt_rate_type.rt_rate_type_ix = '$rt_rate_type_ix'
	",1);

	$target['ddRateItinerary'] = "
		<input style=\"width:130px;\" type=\"text\" disabled id=\"ddRateSelectItineraryLabel\" value=\"$rateInfo[rt_rate_type_desc], $rateInfo[rf_currency_symbol]\">
		<input type=\"hidden\" id=\"ddRateSelectItinerary\" value=\"$rt_rate_type_ix\">";

	$accommArray = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			ac_accomm_type.ac_accomm_capacity
		FROM
			sc_accomm
			INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '$GLOBALS[userid]'
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = 0
			AND ac_accomm_type.pr_business_id IN ('".join("','",$GLOBALS['property_id'])."')
		ORDER BY
			pr_name_last, ac_accomm_type.ac_accomm_desc
	",2);
	$selItineraryAccommodationOptions = "";
	$accommodationAdultLimit = "";
	foreach($accommArray as $accommItem) {
		$selItineraryAccommodationOptions .= "
			<option value=\"".$accommItem['ac_accomm_type_ix']."\" width=\"300px\" ac_accomm_type_ix=\"".$accommItem['ac_accomm_type_ix']."\" ac_accomm_desc=\"".t_encodeOverlib($accommItem['ac_accomm_desc'])."\" propertyName=\"".t_encodeOverlib($accommItem['pr_name_last'])."\">$accommItem[pr_name_last], $accommItem[ac_accomm_desc]</option>
		";
		$accommodationAdultLimit .= "accommodationAdultLimit['$accommItem[ac_accomm_type_ix]'] = $accommItem[ac_accomm_capacity];\n";
	}
	$target['selItineraryAccommodationOptions'] = $selItineraryAccommodationOptions;
	$target['accommodationAdultLimit'] = $accommodationAdultLimit;
}

function getBlockPeriodRows($bl_block_ix) {
	$blockPeriodList = $GLOBALS['lDB']->get("
		SELECT
			bl_block_period.bl_block_period_ix,
			DATE_FORMAT(bl_block_period.bl_per_date_start_series_fst, '%d %b %Y') AS bl_per_date_start_series_fst,
			DATE_FORMAT(bl_block_period.bl_per_date_start_series_lst, '%d %b %Y') AS bl_per_date_start_series_lst,
			bl_block_period.bl_per_recurrence_per_ind,
			bl_block_period.bl_per_recurrence_per_1,
			bl_block_period.bl_per_recurrence_per_2,
			bl_block_period.bl_per_recurrence_per_3,
			bl_block_period.bl_per_recurrence_per_4,
			bl_block_period.bl_per_recurrence_per_5,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			allocation.rv_reservation_ix AS allocation_id,
			bl_block_period.bl_per_expiry_lead_time_date,
			DATE_FORMAT(bl_block_period.bl_per_expiry_lead_time_date, '%d %b %Y') AS bl_per_expiry_lead_time_date_fmt
		FROM
			bl_block_period
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_link_res_item_id IS NULL
			LEFT JOIN rv_reservation_item allocation_item_expired ON allocation_item_expired.rv_reservation_item_ix = allocation_item.rv_reservation_item_ix AND allocation_item.rv_alloc_expiry_date < CURDATE() AND allocation_item_expired.rv_link_res_item_id IS NULL
		WHERE
			bl_block_period.bl_block_id = '$bl_block_ix'
		GROUP BY
			bl_block_period.bl_block_period_ix,
			bl_per_date_start_series_fst,
			bl_per_date_start_series_lst,
			bl_block_period.bl_per_recurrence_per_ind,
			bl_block_period.bl_per_recurrence_per_1,
			bl_block_period.bl_per_recurrence_per_2,
			bl_block_period.bl_per_recurrence_per_3,
			bl_block_period.bl_per_recurrence_per_4,
			bl_block_period.bl_per_recurrence_per_5,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			bl_per_expiry_lead_time_date
		ORDER BY
			bl_block_period.bl_per_date_start_series_fst, bl_block_period.bl_per_date_start_series_lst, bl_block_period.bl_block_period_ix
	",6);

	$GLOBALS['temp']['numberPeriods'] = count($blockPeriodList);
	$tblBlockBookingPeriodRows = "";

	if(!array_key_exists(267,$GLOBALS['jobLevelArray']) || $GLOBALS['jobLevelArray'][267] < 10) {
		$blockPeriodOverbookingHTML = "
				<span id=\"spaPeriodOverbookings!bl_block_period_ix!\" class=\"tooltip\" title=\"Allocation update access required to view overbookings for this period\"><img src=\"/resource/Resrequest/Application/public/img/wait16.gif\" /></span></span>
		";
	} else {
		$blockPeriodOverbookingHTML = "
				<span id=\"spaPeriodOverbookings!bl_block_period_ix!\" class=\"link tooltip\" onclick=\"blockbookingdetails.periodViewOverbookings('tr[bl_block_period_ix=!bl_block_period_ix!]');\" title=\"View overbookings for this period\"><img src=\"/resource/Resrequest/Application/public/img/wait16.gif\" /></span></span>
		";
	}
	$blockPeriodHTML = "
		<tr bl_block_period_ix=\"!bl_block_period_ix!\" recordType=\"period\" allocation_id=\"!allocation_id!\">
			<td class=\"bt bl\"><img name=\"toggleImage\" id=\"img_!bl_block_period_ix!\" src=\"/resource/Resrequest/Application/public/img/property_expanded.gif\" onclick=\"blockbookingdetails.toggle(this);\"></img></td>
			<td class=\"bt\">!bl_per_date_start_series_fst!</td>
			<td class=\"bt\">!bl_per_date_start_series_lst!</td>
			<td class=\"bt\">!recurrence_description!</td>
			<td class=\"bt\">!expiry_description!</td>
			<td class=\"bt numberRow\">
				<span id=\"spaSeries!bl_block_period_ix!\" class=\"link tooltip\" onclick=\"blockbookingdetails.periodViewAllocations('tr[bl_block_period_ix=!bl_block_period_ix!]');\" title=\"View allocations\">!series_expired!/!series_total!</span>
			</td>
			<td class=\"bt numberRow\">
				<span id=\"spaDrawDowns!bl_block_period_ix!\" class=\"link tooltip\" title=\"View reservation draw downs for this block period\">!draw_down_reservations_count!</span>
				<script type=\"text/javascript\" charset=\"utf-8\">
					var dlgreservationlist = new dlgReservationList('#spaDrawDowns!bl_block_period_ix!', 'reservation.php?6014+!draw_down_reservations!', 'Reservation List : Block Period !bl_per_date_start_series_fst! to !bl_per_date_start_series_lst!', 500, 770, null);
					dlgreservationlist.init();
				</script>
			</td>
			<td class=\"bt numberRow\">
				$blockPeriodOverbookingHTML
			</td>
			<td align=\"center\" class=\"bt br\"><input class=\"button bDropDown printCollapse\" type=\"button\" name=\"btnPeriodMenu\" bl_block_period_ix=\"!bl_block_period_ix!\" style=\"width:14px; height:18px; background-position: center center;\" value=\" \"></input></td>
		</tr>
	";
	$blockPeriodItineraryHeaderHTML = "
		<tr id=\"trItineraries_!bl_block_period_ix!\">
			<td class=\"bl\">&nbsp;</td>
			<td style=\"padding:3px 3px 5px 3px;\" colspan=\"7\">
				<div style=\"border: 1px solid #dddddd\">
					<table id=\"tblItineraries_!bl_block_period_ix!\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" class=\"margin-top:3px;\" >
							<col width=\"180\" /> <!-- Property -->
							<col width=\"180\" /> <!-- Accomm -->
							<col width=\"178\" /> <!-- Rate -->
							<col width=\"31\" /> <!-- Start -->
							<col width=\"31\" /> <!-- End -->
							<col width=\"31\" /> <!-- Nights -->
							<col width=\"31\" /> <!-- Rooms -->
							<col width=\"31\" /> <!-- Pax -->
							<col width=\"55\" />
							<thead>
								<tr>
									<th name=\"thItineraryProperty\" style=\"line-height:18px;\" class=\"colLt br bb\">Property</th>
									<th name=\"thItineraryAccomm\" style=\"line-height:18px;\" class=\"colLt br bb\">Accommodation</th>
									<th name=\"thItineraryRate\" style=\"line-height:18px;\" class=\"colLt br bb\">Rate</th>
									<th name=\"thItineraryStart\" style=\"line-height:18px;\" class=\"colLt br bb\"><abbr class=\"tt\" style=\"cursor: help;\" title=\"Start day\">Start</abbr></th>
									<th name=\"thItineraryEnd\" style=\"line-height:18px;\" class=\"colLt br bb\"><abbr class=\"tt\" style=\"cursor: help;\" title=\"End day\">End</abbr></th>
									<th name=\"thItineraryNights\" style=\"line-height:18px;\" class=\"colLt br bb\"><abbr class=\"tt\" style=\"cursor: help;\" title=\"Nights\">Nts</abbr></th>
									<th name=\"thItineraryRooms\" style=\"line-height:18px;\" class=\"colLt br bb\"><abbr class=\"tt\" style=\"cursor: help;\" title=\"Rooms\">Rms</abbr></th>
									<th name=\"thItineraryPax\" style=\"line-height:18px;\" class=\"colLt br bb\"><abbr class=\"tt\" style=\"cursor: help;\" title=\"Number of Pax\">Pax</abbr></th>
									<th name=\"thItineraryOptions\" style=\"line-height:18px;\" class=\"colLt bb\">
										<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"5\" alt=\"\" />
									</th>
								</tr>
							</thead>
							<tbody>";
	$blockPeriodItineraryHTML = "
	<tr bl_block_period_ix=\"!bl_block_period_id!\" bl_block_itinerary_ix=\"!bl_block_itinerary_ix!\" ac_accomm_type_id=\"!ac_accomm_type_id!\" rt_rate_type_id=\"!rt_rate_type_id!\" rt_rate_type_desc=\"!rate_name!\" bl_itinerary_day_start=\"!bl_itinerary_day_start!\" bl_itinerary_day_end=\"!bl_itinerary_day_end!\" bl_itinerary_nights=\"!bl_itinerary_nights!\" bl_block_itinerary_rooms=\"!bl_block_itinerary_rooms!\" bl_block_itinerary_pax=\"!bl_block_itinerary_pax!\" recordType=\"itinerary\">
		<td>!property_name!</td>
		<td>!accommodation_name!</td>
		<td>!rate_name!</td>
		<td class=\"txtc\">!bl_itinerary_day_start!</td>
		<td class=\"txtc\">!bl_itinerary_day_end!</td>
		<td class=\"txtc\">!bl_itinerary_nights!</td>
		<td class=\"txtc\">!bl_block_itinerary_rooms!</td>
		<td class=\"txtc\">!bl_block_itinerary_pax!</td>
		<td class=\"txtc\"><input class=\"button bDropDown printCollapse\" type=\"button\" name=\"btnItineraryMenu\" bl_block_itinerary_ix=\"!bl_block_itinerary_ix!\" style=\"width: 14px; height: 18px; background-position: center center;\"></input></td>
	</tr>
	";
	$periodCounter = 1;
	foreach($blockPeriodList as $period) {
		$series = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				bl_series_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_item_accomm_count > 0 AND allocation_item.bl_series_sequence_number IS NOT NULL
			WHERE
				bl_block_period.bl_block_period_ix = '$period[bl_block_period_ix]'
				AND allocation_item.bl_series_id IS NOT NULL",3);
		$period['series_total'] = count($series);

		$expiredSeries = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				bl_series_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
				LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_item_accomm_count > 0 AND allocation_item.bl_series_sequence_number IS NOT NULL
			WHERE
				bl_block_period.bl_block_period_ix = '$period[bl_block_period_ix]'
				AND allocation_item.rv_alloc_expiry_date < CURDATE()
				AND allocation_item.bl_series_id IS NOT NULL",3);
		$period['series_expired'] = count($expiredSeries);

		$drawDowns = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				draw_down_item.rv_reservation_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
				LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
				LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
			WHERE
				bl_block_period.bl_block_period_ix = '$period[bl_block_period_ix]'
			AND draw_down_item.rv_reservation_id IS NOT NULL",3);
		$period['draw_downs'] = count($drawDowns);
		$period["recurrence_description"] = getRecurrencePeriodDescription(
			$period["bl_per_recurrence_per_ind"],
			$period["bl_per_recurrence_per_1"],
			$period["bl_per_recurrence_per_2"],
			$period["bl_per_recurrence_per_3"],
			$period["bl_per_recurrence_per_4"],
			$period["bl_per_recurrence_per_5"]);
		$period["expiry_description"] = getExpiryDescription(
			$period["bl_per_expiry_ind"],
			$period["bl_per_expiry_lead_time_days"],
			$period["bl_per_expiry_lead_time_date"]
		);
		$draw_down_reservations = array();
		if ($period["draw_downs"] > 0) {
			$draw_down_reservations = $GLOBALS['lDB']->get("
				SELECT DISTINCT
					rv_reservation.rv_reservation_ix
				FROM
					bl_block_period
					INNER JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix
					INNER JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				WHERE
					rv_reservation.rf_reservation_status_id != '15'
					AND rv_reservation.rf_reservation_status_id != '97'
					AND bl_block_period.bl_block_period_ix = '$period[bl_block_period_ix]'
			", 3);
		}
		$period['draw_down_reservations'] = implode(",",$draw_down_reservations);
		$period['draw_down_reservations_count'] = count($draw_down_reservations);
		$tblBlockBookingPeriodRows .= showpage($period,$blockPeriodHTML);
		$blockPeriodItineraries = $GLOBALS['lDB']->get("
			SELECT
				bl_block_itinerary_ix,
				bl_block_period_id,
				property.pr_name_last AS property_name,
				ac_accomm_type.ac_accomm_desc AS accommodation_name,
				bl_block_itinerary.ac_accomm_type_id,
				bl_block_itinerary.rt_rate_type_id,
				CONCAT(rt_rate_type_desc, ',', rf_currency_symbol) AS rate_name,
				bl_block_itinerary.bl_itinerary_day_start,
				bl_block_itinerary.bl_itinerary_day_end,
				bl_block_itinerary_rooms,
				bl_block_itinerary_pax
			FROM
				bl_block_itinerary
				LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = bl_block_itinerary.ac_accomm_type_id
				LEFT JOIN pr_persona property ON property.pr_persona_ix = ac_accomm_type.pr_business_id
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = bl_block_itinerary.rt_rate_type_id
				LEFT JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
			WHERE
				bl_block_itinerary.bl_block_period_id = '$period[bl_block_period_ix]'
			ORDER BY
				bl_block_itinerary.bl_itinerary_day_start,
				bl_block_itinerary.bl_itinerary_day_end

		",6);
		$tblBlockBookingPeriodRows .= showpage($period, $blockPeriodItineraryHeaderHTML);
		foreach ($blockPeriodItineraries as $itinerary) {
			$itinerary['bl_itinerary_nights'] = $itinerary['bl_itinerary_day_start'] == $itinerary['bl_itinerary_day_end'] ? 0 : $itinerary['bl_itinerary_day_end'] - $itinerary['bl_itinerary_day_start'];
			$tblBlockBookingPeriodRows .= showpage($itinerary,$blockPeriodItineraryHTML);
		}
		$tblBlockBookingPeriodRows .= "
					</tbody>
					</table>
				</div>
			</td>
			<td class=\"br\">&nbsp;</td>
		</tr>";
		$periodCounter += 1;
	}
	if($tblBlockBookingPeriodRows == "") {
		$tblBlockBookingPeriodRows = "
			<tr id=\"trNoPeriods\">
				<td colspan=\"8\" align=\"center\"><em>No periods defined</em></td>
			</tr>
		";
	}

	return $tblBlockBookingPeriodRows;
}

function getOverbookings($bl_block_ix) {
	$overbookings = array();
	$blockItems = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_split_yn,
			rv_reservation_item.rt_rate_type_id,
			rv_reservation_item.rv_alloc_expiry_date,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
			rv_reservation_item.rv_reservation_id,
			bl_block_period.bl_block_period_ix
		FROM
			bl_block_period
			INNER JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_period_id = bl_block_period.bl_block_period_ix
			INNER JOIN rv_reservation_item ON rv_reservation_item.bl_block_itinerary_id = bl_block_itinerary.bl_block_itinerary_ix
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id AND rv_reservation.rf_reservation_status_id != '97'
		WHERE
			bl_block_period.bl_block_id = '$bl_block_ix'
	", 6);
	$excludeItems = array();
	foreach ($blockItems as $blockItem) {
		$excludeItems[] = $blockItem['rv_reservation_item_ix'];
	}
	list($hasAvailability, $overbookingdetails) = check_multi_item_availability($blockItems,$excludeItems,true,true);
	//If an allocation item for this block booking has an overbooking
	//situation, for all days between each allocation items' arrival and departure dates
	//check to see if the item has a date with an overbooking for the relevant
	//accommodation type
	if (!$hasAvailability) {
		foreach ($blockItems as $item) {
			if(!array_key_exists($item['bl_block_period_ix'],$overbookings)) {
				$overbookings[$item['bl_block_period_ix']] = array();
			}
			$dateSpan = new DatePeriod(
				 new DateTime($item['rv_item_date_arrive']),
				 new DateInterval('P1D'),
				 new DateTime($item['rv_item_date_depart'])
			);
			foreach ($dateSpan as $date) {
				foreach ($overbookingdetails as $ac_accomm_type_id=>$overbookingdates) {
					foreach ($overbookingdates as $overbookingdate=>$availability) {
						if ($overbookingdate == $date->format("Y-m-d") && $item['ac_accomm_type_id'] == $ac_accomm_type_id) {
							if(!array_key_exists($item['rv_reservation_item_ix'],$overbookings[$item['bl_block_period_ix']])) {
								$overbookings[$item['bl_block_period_ix']][$item['rv_reservation_item_ix']] = array();
							}
							$overbookings[$item['bl_block_period_ix']][$item['rv_reservation_item_ix']][$date->format("Y-m-d")] = $availability;
						}
					}
				}
			}
		}
	}
	return $overbookings;
}

/**
 * getAllocationDates() - get all allocation item date details for a block's allocation header
 * @param string $bl_block_id
 * @param string $allocation_id (rv_reservation_ix)
 * @return $allocationDates
 *
 * $allocationDates format:
 * 		{
 * 			<arrival date> : [
 *				{"allocation_item_id" (optional) : "RS121", "alloc_item_room_max" : 2, arrival_date: <first arrival date>, departure_date: <first departure date>},
 *				{"allocation_item_id" (optional) : "RS122", "alloc_item_room_max" : 3, arrival_date: <second arrival date>, departure_date: <second departure date>},
 *				{"allocation_item_id" (optional) : "RS123", "alloc_item_room_max" : 3, arrival_date: <third arrival date>, departure_date: <third departure date>},
 *				...
 * 			],
 * 			"2014-10-12" : [
 * 				{"allocation_item_id" (optional) : "RS124", "alloc_item_room_max" : 3, arrival_date : "2014-10-12", departure_date "2014-10-15"},
 * 				{"allocation_item_id" (optional) : "RS125", "alloc_item_room_max" : 2, arrival_date : "2014-10-15", departure_date "2014-10-18"},
 * 				...
 * 			]
 * 		}
 */
function getAllocationDates($bl_block_id, $allocation_id) {
	$allocationItems = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rt_rate_type_id,
			rv_reservation_item.ac_accomm_type_id,
			bl_block_period.bl_block_period_ix,
			rv_reservation_item.rv_reservation_id AS allocation_id,
			series.rv_item_date_arrive AS series_arrival_date,
			CASE rv_reservation_item.rv_alloc_expiry_date
				WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
				WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
				ELSE rv_reservation_item.rv_alloc_expiry_date
			END AS rv_alloc_expiry_date,
			rv_reservation.rv_alloc_expiry_days,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.bl_series_sequence_number,
			rv_reservation_item.bl_series_id
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN rv_reservation_item series ON series.rv_reservation_item_ix = rv_reservation_item.bl_series_id
			LEFT JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_itinerary_ix = rv_reservation_item.bl_block_itinerary_id
			LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = bl_block_itinerary.bl_block_period_id
		WHERE
			rv_reservation.rv_reservation_ix = '$allocation_id'
			AND bl_block_period.bl_block_id = '$bl_block_id'
			AND rv_reservation_item.rv_link_res_item_id IS NULL
		ORDER BY
			rv_reservation_item.rv_item_date_arrive ASC,
			rv_reservation_item.rv_item_date_depart
	", 6);
	$blockPeriodItemCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(bl_block_itinerary.bl_block_itinerary_ix) AS blockItineraryCount
		FROM
			rv_reservation
			INNER JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
			INNER JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_period_id = bl_block_period.bl_block_period_ix
		WHERE
			rv_reservation.rv_reservation_ix = '$allocation_id'
			AND bl_block_period.bl_block_id = '$bl_block_id'
	", 4);
	$reservationItems = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rt_rate_type_id,
			rv_reservation_item.ac_accomm_type_id,
			bl_block_period.bl_block_period_ix,
			rv_reservation_item.rv_reservation_id AS allocation_id,
			CASE rv_reservation_item.rv_alloc_expiry_date
				WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
				WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
				ELSE rv_reservation_item.rv_alloc_expiry_date
			END AS rv_alloc_expiry_date,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.bl_series_sequence_number,
			rv_reservation_item.bl_series_id
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
		WHERE
			rv_reservation.rv_reservation_ix = '$allocation_id'
			AND bl_block_period.bl_block_id = '$bl_block_id'
			AND rv_reservation_item.rv_link_res_item_id IS NOT NULL
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart
	", 6);

	$allowExpired = db_sc_group_get_user_setting("sc_grp_res_ovr_alloc_yn") == "1";

	$allocationDates = array();
	$series_id = null;
	$counter = 1;
	foreach ($allocationItems as $item) {
		$addDate = true;
		$item['alloc_item_room_max'] = isset($item['alloc_item_room_max']) ? $item['alloc_item_room_max'] : $item['rv_item_accomm_count'];
		foreach ($reservationItems as $reservationItem) {
			if ($reservationItem['rv_item_date_arrive'] == $item['rv_item_date_arrive']
				&& $reservationItem['ac_accomm_type_id'] == $item['ac_accomm_type_id']) {
				$item['alloc_item_room_max'] = $item['alloc_item_room_max'] + $reservationItem['rv_item_accomm_count'];
				if ($item['alloc_item_room_max'] <= 0) {
					$addDate = false;
				}
			}
		}

		$isExpired = false;
		// Item should only be added if not expired
		if($item['rv_alloc_expiry_date'] != "0000-00-00") {
			if($item['rv_alloc_expiry_date'] < date("Y-m-d")) {
				$isExpired = true;
				if(!$allowExpired) {
					$addDate = false;
				}
			}
		} else {
			$daysToEnd = dateSubtract($item['rv_item_date_depart'],date("Y-m-d"));
			if($item['rv_alloc_expiry_days'] > $daysToEnd) {
				$isExpired = true;
				if(!$allowExpired) {
					$addDate = false;
				}
			}
		}
		$series_id = $series_id == null ? $item['bl_series_id'] : $series_id;
		if ($addDate == true) {
			if(!array_key_exists($item['series_arrival_date'],$allocationDates)) {
				$allocationDates[$item['series_arrival_date']] = array();
			}
			$allocationDates[$item['series_arrival_date']][$item['bl_series_sequence_number']] = array(
				"allocation_item_id"=>$item['rv_reservation_item_ix'],
				"arrival_date"=>$item['rv_item_date_arrive'],
				"departure_date"=>$item['rv_item_date_depart'],
				"alloc_item_room_max"=>$item['alloc_item_room_max'],
				"expired"=>$isExpired
			);
		}
		$series_id = $item['bl_series_id'];
	}
	foreach ($allocationDates as $arrivalDate => $seriesItems) {
		if (count($seriesItems) != $blockPeriodItemCount) {
			unset($allocationDates[$arrivalDate]);
		}
	}
	return $allocationDates;
}

function getAgentDefaultRate($rv_agent_id) {
	$rate_details = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rt_rate_type_ix AS rt_rate_type_id,
			CONCAT(rt_rate_type.rt_rate_type_desc, ', ', rf_currency.rf_currency_symbol) AS rate_description
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			pr_agent_rate.pr_agent_id = '$rv_agent_id'
			AND pr_agent_rate.pr_agent_rate_default_yn = 1
	",1);
	$rt_rate_type_id = "";
	$rate_description = "";
	if (!empty($rate_details)) {
		$rt_rate_type_id = $rate_details['rt_rate_type_id'];
		$rate_description = $rate_details['rate_description'];
	}

	return array($rt_rate_type_id, $rate_description);
}
