<?php

/**
 * init.form6001.php - Block booking details
 * Job: 6001
 * Function: 6001
 */

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");
$job = $_SERVER['argv'][0];
$bl_block_ix = $_SERVER['argv'][1];
$record	= (isset($GLOBALS['record']) ? $GLOBALS['record'] : $bl_block_ix);
$periodExpandList = $_SERVER['argv'][2];

$periodExpandList = array_unique(explode(",", $periodExpandList));
if (empty($_SESSION['whichCalendar'])) {session_set('whichCalendar', 'block_templates');}

// Start Access Control Toolbar Setup
$jobs = array(
	"NEW" => 6002,
	"NEW_PERSIST" => 6003,
	"EDIT" => 6004,
	"EDIT_PERSIST" => 6005,
	"VIEW" => 6001,
	"DELETE" => 6006
);
$jobUrls = array(
	"NEW" => "reservation.php?" . $jobs['NEW'],
	"NEW_PERSIST" => "reservation.php?" . $jobs['NEW_PERSIST'],
	"EDIT" => "reservation.php?" . $jobs['EDIT'],
	"EDIT_PERSIST" => "reservation.php?" . $jobs['EDIT_PERSIST'],
	"VIEW" => "reservation.php?" . $jobs['VIEW'],
	"DELETE" => "reservation.php?" . $jobs['DELETE']
);

$GLOBALS['temp']['actionViewUrl'] = "/".$jobUrls['VIEW'];
$GLOBALS['temp']['actionNewUrl'] = "/".$jobUrls['NEW'];
$GLOBALS['temp']['actionNewPersistUrl'] = "/".$jobUrls['NEW_PERSIST'];
$GLOBALS['temp']['actionOpenUrl'] = "/reservation.php?6007";
$GLOBALS['temp']['actionEditUrl'] = "/".$jobUrls['EDIT'] . (!empty($record) ? "+".$record : "");
$GLOBALS['temp']['actionEditPersistUrl'] = "/".$jobUrls['EDIT_PERSIST'];
$GLOBALS['temp']['actionDeleteUrl'] = "/".$jobUrls['DELETE'];
$GLOBALS['temp']['actionListUrl'] = "/reservation.php?6007";
$GLOBALS['temp']['validationMessage'] = "";

$pgJOBS = array();
$pgJOBS['view'] = "0";
$pgJOBS['add'] = "1";
$pgJOBS['edit'] = "0";
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
$pgJOBS['saveclose'] = "0";

if (checkJob($jobs['VIEW'])) {
	$pgJOBS['view'] = "1";
}

if (checkJob($jobs['EDIT']) && $action == "3") {
	$pgJOBS['edit'] = "1";
}

if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}

if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}

if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($jobs['DELETE'])) {
		$pgJOBS['del'] = "1";
	}
}
$GLOBALS['temp']['pgJobs'] = '
	<input type="hidden" id="pgJobNew" value="' . $pgJOBS['add'] . '" />
	<input type="hidden" id="pgJobEdit" value="' . $pgJOBS['edit'] . '" />
	<input type="hidden" id="pgJobDelete" value="' . $pgJOBS['del'] . '" />
	<input type="hidden" id="pgJobSave" value="' . $pgJOBS['save'] . '" />
	<input type="hidden" id="pgJobSaveclose" value="' . $pgJOBS['saveclose'] . '" />
	<input type="hidden" id="pgJobExit" value="1" />
	<input type="hidden" id="pgJobPrint" value="1" />
';

switch ($job) {
	case ($jobs['VIEW']):
		if (isset($_POST['getOverbookings'])) {
			if ($_POST['getOverbookings'] == "true") {
				$bl_block_ix = isset($_POST['bl_block_ix']) ? $_POST['bl_block_ix'] : "";
				$result = "success";
				$overbookings = getOverbookings($bl_block_ix);
				if ($overbookings === false) {
					$result = "fail";
				}
				echo json_encode(array("result"=>$result, "overbookings"=>$overbookings));
				if(!isset($GLOBALS[$form])) {
					$GLOBALS[$form] = new Form($form,"","");
					die();
				}
			}
		} elseif (isset($_POST['getAllocationDates'])) {
			if ($_POST['getAllocationDates'] == "true") {
				$bl_block_ix = isset($_POST['bl_block_ix']) ? $_POST['bl_block_ix'] : "";
				$allocation_id = isset($_POST['allocation_id']) ? $_POST['allocation_id'] : "";
				$result = "success";
				$allocationDates = getAllocationDates($bl_block_ix,$allocation_id);
				if ($allocationDates === false) {
					$result = "fail";
				}
				echo json_encode(array("result"=>$result, "allocationDates"=>$allocationDates));
				if(!isset($GLOBALS[$form])) {
					$GLOBALS[$form] = new Form($form,"","");
					die();
				}
			}
		} else {
			if(!isset($GLOBALS[$form])) {
				$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_details.htm");
			}
			$GLOBALS['mode'] = "modeView";
			$GLOBALS['temp']['tblBlockBookingPeriodRows'] = getBlockPeriodRows($record);
			$blockBookingDetails = getBlockBookingDetails($record);
			setBlockBookingDetails($blockBookingDetails, $GLOBALS['temp']);
		}
	  break;
	case ($jobs['NEW']):
		if (isset($_POST['getAgentDefaultRate'])) {
			if ($_POST['getAgentDefaultRate'] == "true") {
				$rv_agent_id = isset($_POST['rv_agent_id']) ? $_POST['rv_agent_id'] : "";
				$result = "success";
				list($rt_rate_type_id, $rate_description) = getAgentDefaultRate($rv_agent_id);
				if ($rt_rate_type_id == "") {
					$result = "fail";
				}
				echo json_encode(array("result"=>$result, "rt_rate_type_id"=>$rt_rate_type_id, "rate_description"=>$rate_description));
				if(!isset($GLOBALS[$form])) {
					$GLOBALS[$form] = new Form($form,"","");
					die();
				}
			}
		} else {
			if(!isset($GLOBALS[$form])) {
				$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_details.htm");
			}
			$GLOBALS['mode'] = "modeNew";
			$GLOBALS['temp']['bl_block_ix'] = "";
			$GLOBALS['temp']['tblBlockBookingPeriodRows'] = getBlockPeriodRows($record);
			$blockBookingDetails = getBlockBookingDetails($record);
			setBlockBookingDetails($blockBookingDetails, $GLOBALS['temp']);
		}
		break;
	case ($jobs['NEW_PERSIST']):
		$params = array();
		$params['bl_block_name'] = $_POST['bl_block_name'];
		$params['bl_block_abbrev'] = $_POST['bl_block_abbrev'];
		$params['rv_consultant_id'] = $_POST['rv_consultant_id'];
		$params['rv_agent_id'] = $_POST['rv_agent_id'];
		$params['rv_agent_contact_persona_id'] = $_POST['rv_agent_contact_persona_id'];
		$params['rv_agent_ref'] = $_POST['rv_agent_ref'];
		$params['rt_rate_type_id'] = "";
		$params['bl_block_commission_perc'] = $_POST['bl_block_commission_perc'];
		$params['bl_block_note'] = $_POST['bl_block_note'];
		$params['bl_block_note_internal'] = $_POST['bl_block_note_internal'];

		$result = "success";
		list($valid, $message) = validateBlockBooking($params);
		if ($valid) {
			$bl_block_ix = db_bl_block_insert(
			  $params['bl_block_name'],
			  $params['bl_block_abbrev'],
			  $params['rv_consultant_id'],
			  $params['rv_agent_id'],
			  $params['rv_agent_contact_persona_id'],
			  $params['rv_agent_ref'],
			  $params['rt_rate_type_id'],
			  $params['bl_block_commission_perc'],
			  $params['bl_block_note'],
			  $params['bl_block_note_internal']);
		} else {
			$result = "fail";
		}
		echo json_encode(array("result"=>$result, "bl_block_ix"=>$bl_block_ix));
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"","");
			die();
		}
		break;
	case ($jobs['EDIT']):
		if (isset($_POST['validateBlockBooking'])) {
			if ($_POST['validateBlockBooking'] == "true") {
				$params = array();
				$params['bl_block_ix'] = isset($_POST['bl_block_ix']) ? $_POST['bl_block_ix'] : "";
				$params['bl_block_name'] = isset($_POST['bl_block_name']) ? $_POST['bl_block_name'] : "";
				$params['bl_block_abbrev'] = isset($_POST['bl_block_abbrev']) ? $_POST['bl_block_abbrev'] : "";
				$result = "success";
				list($valid, $message) = validateBlockBooking($params);
				if (!$valid) {
					$result = "fail";
				}
				echo json_encode(array('result'=>$result,'message'=>$message));
				if(!isset($GLOBALS[$form])) {
					$GLOBALS[$form] = new Form($form,"","");
					die();
				}
			}
		} else {
			if(!isset($GLOBALS[$form])) {
				$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_details.htm");
			}
			$GLOBALS['mode'] = "modeEdit";
			$blockBookingDetails = getBlockBookingDetails($record);
			setBlockBookingDetails($blockBookingDetails, $GLOBALS['temp']);
			$GLOBALS['temp']['tblBlockBookingPeriodRows'] = getBlockPeriodRows($record);
		}
		break;
	case ($jobs['EDIT_PERSIST']):
		if ($pmode == 1) {
			$params = array();
			$params['bl_block_ix'] = isset($_POST['bl_block_ix']) ? $_POST['bl_block_ix'] : "";
			$params['bl_block_name'] = isset($_POST['bl_block_name']) ? $_POST['bl_block_name'] : "";
			$params['bl_block_abbrev'] = isset($_POST['bl_block_abbrev']) ? $_POST['bl_block_abbrev'] : "";
			$params['rv_consultant_id'] = isset($_POST['rv_consultant_id']) ? $_POST['rv_consultant_id'] : "";
			$params['rv_agent_id'] = isset($_POST['rv_agent_id']) ? $_POST['rv_agent_id'] : "";
			$params['rv_agent_contact_persona_id'] = isset($_POST['rv_agent_contact_persona_id']) ? $_POST['rv_agent_contact_persona_id'] : "";
			$params['rv_agent_ref'] = isset($_POST['rv_agent_ref']) ? $_POST['rv_agent_ref'] : "";
			$params['rt_rate_type_id'] = isset($_POST['rt_rate_type_id']) ? $_POST['rt_rate_type_id'] : "";
			$params['bl_block_commission_perc'] = isset($_POST['bl_block_commission_perc']) ? $_POST['bl_block_commission_perc'] : "";
			$params['bl_block_note'] = isset($_POST['bl_block_note']) ? $_POST['bl_block_note'] : "";
			$params['bl_block_note_internal'] = isset($_POST['bl_block_note_internal']) ? $_POST['bl_block_note_internal'] : "";
			$params['blockPeriods'] = isset($_POST['blockPeriods']) ? $_POST['blockPeriods'] : "";
			$params['blockItineraries'] = isset($_POST['blockItineraries']) ? $_POST['blockItineraries'] : "";
			if(!isset($GLOBALS[$form])) {
				$GLOBALS[$form] = new Form($form,"","");
			}
			$result = "success";
			$updatePeriodExpandList = array();
			list($valid, $message) = validateBlockBooking($params);
			if ($valid) {
				list($ad_modify_date, $reload, $updatePeriodExpandList) = updateBlockBooking($params);
			} else {
				$result = "fail";
			}

			$periodExpandList = array_merge($periodExpandList, $updatePeriodExpandList);
			$modify_user_name = $GLOBALS['userArray']['pr_name_first'] . ' ' . $GLOBALS['userArray']['pr_name_last'];
			echo json_encode(array("result"=>$result, "ad_modify_date"=>$ad_modify_date, "modify_user_name"=>$modify_user_name, "reload"=>$reload, "periodExpandList"=>$periodExpandList)) . "\n";
		}
		break;
	case ($jobs['DELETE']):
		if ($pmode == 1) {
			if(!isset($GLOBALS[$form])) {
				$GLOBALS[$form] = new Form($form,"","");
			}
			$result = "fail";
			$message = "";
			$reload = false;
			$recordType = isset($_POST['recordType']) ? $_POST['recordType'] : "";
			switch ($recordType) {
				case 'blockBooking':
					$bl_block_id = isset($_POST['bl_block_id']) ? $_POST['bl_block_id'] : "";
					$message = db_bl_block_delete($bl_block_id);
					$result = count($message) > 0 ? "fail" : "success";
					break;
				case 'period':
					$deletePeriods = isset($_POST['deletePeriods']) ? $_POST['deletePeriods'] : "";
					$message = db_bl_block_period_delete($deletePeriods);
					$result = count($message) > 0 ? "fail" : "success";
					break;
				case 'itinerary':
					$deleteItineraries = isset($_POST['deleteItineraries']) ? $_POST['deleteItineraries'] : "";
					$message = db_bl_block_itinerary_delete($deleteItineraries);
					$result = count($message) > 0 && $message != true ? "fail" : "success";
					break;
				default:
					break;
			}
			echo json_encode(array("result"=>$result, "message"=>$message, "reload"=>$reload)) . "\n";
		}
		break;
	default:
		break;
}

// Define scrollset -----------------------------------------------------------
$resScrollSet = isset($_SESSION['resScrollSet'])?$_SESSION['resScrollSet']:array();
if ( !is_array($resScrollSet) ) {
	$resScrollSet = array();
}

// Setup the record scrolling -------------------------------------------------
$rPrev = $record;
$rNext = $record;

if ( !in_array($record, $resScrollSet) && $record != "0" && $record != "" ) {
	array_push($resScrollSet, $record);
}

if ( is_array($resScrollSet) ) {
	for ( $q = 0; $q < sizeof($resScrollSet); $q++ ) {
		$key = isset($resScrollSet[$q]) ? $resScrollSet[$q] : "";

		if ( $key == $record ) {

			if ( $q > "0" ) {
				$rPrev = $resScrollSet[$q-1];
			}

			if ( $q + 1 < sizeof($resScrollSet) ) {
				$rNext = $resScrollSet[$q+1];
			}
		}
	}
}
$recordnext = $rNext;
$recordprev = $rPrev;
if(!isset($naviset_str)) {
	$naviset_str = "";
}
$GLOBALS['temp']['naviset'] = "naviset=".$naviset_str;
$GLOBALS['temp']['mode'] = isset($GLOBALS['mode']) ? $GLOBALS['mode'] : "";
$GLOBALS['temp']['jobid'] = "";
$GLOBALS['temp']['record'] = $record;
$GLOBALS['temp']['recordnext'] = $recordnext;
$GLOBALS['temp']['recordprev'] = $recordprev;
$GLOBALS['temp']['periodExpandList'] = json_encode($periodExpandList);
