<?php

/**
 * init.form6002.php - Find Block bookings
 * Job: 6007
 * Function: 6002 
 */

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_find.htm");
}

$newRelic = new NewRelic();
$newRelic->record_transaction("Block Templates");

$doSearch = count($_SERVER['argv']) == 1 ? false : true;
$argv = $_SERVER['argv'];
$initialPageLoad = count($argv) == 1;
$argv = array_pad($argv,11,"");
$bl_block_ix = $argv[1] != "" ? mb_strtoupper($GLOBALS['lDB']->like(urldecode($argv[1]))) : "%";
$bl_block_name = $argv[2] != "" ? $GLOBALS['lDB']->like(urldecode($argv[2])) : "%";
$rv_agent_ref = $argv[3] != "" ? $GLOBALS['lDB']->like(urldecode($argv[3])) : "%";
$agentIds = $argv[4];
$consultantIds = $argv[5];
$sortBy = $argv[6] != "" ? $argv[6] : "0";
$page = $argv[7] != "" ? $argv[7] : "1";
$bl_block_abbrev = $argv[8] != "" ? $GLOBALS['lDB']->like(urldecode($argv[8])) : "%";
if ($initialPageLoad) {
	$dateFrom = "";
	$dateTo = "";
} else {
	$dateFrom = getDateParameter($argv[9]) !== false ? getDateParameter($argv[9]) : "";
	$dateTo = getDateParameter($argv[10]) !== false ? getDateParameter($argv[10]) : "";
}
$dateFromYear = $dateFrom != "" ? $dateFrom->format("Y") : "";
$dateFromMonth = $dateFrom != "" ? $dateFrom->format("m") : "";
$dateFromDay = $dateFrom != "" ? $dateFrom->format("d") : "";
$dateToYear = $dateTo != "" ? $dateTo->format("Y") : "";
$dateToMonth = $dateTo != "" ? $dateTo->format("m") : "";
$dateToDay = $dateTo != "" ? $dateTo->format("d") : "";

$GLOBALS[$form]->Get($action);
$GLOBALS[$form]->AddField("txtBlockBookingId","txtBlockBookingId",urldecode($argv[1]),"0");
$GLOBALS[$form]->AddField("txtBlockBookingName","txtBlockBookingName",urldecode($argv[2]),"0");
$GLOBALS[$form]->AddField("txtAgentReference","txtAgentReference",urldecode($argv[3]),"0");
$GLOBALS[$form]->AddField("txtBlockBookingAbbreviation","txtBlockBookingAbbreviation",urldecode($argv[8]),"0");

$GLOBALS['tagList']['txtBlockBookingId'] = $GLOBALS['txtBlockBookingId'];
$GLOBALS['tagList']['txtBlockBookingName'] = $GLOBALS['txtBlockBookingName'];
$GLOBALS['tagList']['txtAgentReference'] = $GLOBALS['txtAgentReference'];
$GLOBALS['tagList']['txtBlockBookingAbbreviation'] = $GLOBALS['txtBlockBookingAbbreviation'];
$GLOBALS['temp']['hiddateFromYear'] = $dateFromYear;
$GLOBALS['temp']['hiddateFromMonth'] = $dateFromMonth;
$GLOBALS['temp']['hiddateFromDay'] = $dateFromDay;
$GLOBALS['temp']['hiddateToYear'] = $dateToYear;
$GLOBALS['temp']['hiddateToMonth'] = $dateToMonth;
$GLOBALS['temp']['hiddateToDay'] = $dateToDay;

$blockBookingScrollSet = array();

$fields = array();
$dbTables = array();
$where = "";
$order = "";


$GLOBALS['temp']['pgNum'] = (string) $page;

$GLOBALS['temp']['hideAll'] = "0";
if($argv[1] == "" && $argv[2] == "") {
	$GLOBALS['temp']['hideAll'] = "1";
}

$pLimit = "10";
$limit = "35";

// [START] Filters ------------------------------------------------------------
$agentACL = false;
if($userStatusId < 2) {
   $agentACL = array($calAgentId);
}
$agentFilter = useFilter("agent",$agentIds,"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","bl_block.rv_agent_id",$agentACL,"Direct booking","0");
$consultantFilter = useFilter("consultant",$consultantIds,"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","bl_block.rv_consultant_id",false,"No consultant","0");

if ( $_SESSION['userStatusId'] < 2 ) {
	$GLOBALS['temp']['agentHide'] = "collapse";
	$agentLink = $GLOBALS['lDB']->get("SELECT pr_persona.pr_name_first, pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '".$GLOBALS['pr_agent_link']."'",1);

	if ( $agentLink['pr_name_first'] ) {
		$agentLinkName = $agentLink['pr_name_first']." ".$agentLink['pr_name_last'];
	} else {
		$agentLinkName = $agentLink['pr_name_last'];
	}
	$GLOBALS['temp']['agentNames'] = $agentLinkName;
} else {
	$GLOBALS['temp']['agentHide'] = "expand";
}
// [ END ] Filters ------------------------------------------------------------

$fields = array();
array_push($fields,"bl_block.bl_block_ix AS bl_block_ix");
array_push($fields,"bl_block.bl_block_name");
array_push($fields,"IFNULL(TRIM(CONCAT(agent.pr_name_first, ' ', agent.pr_name_last)), 'Direct booking') AS agent_name");
array_push($fields,"bl_block.rv_agent_id");
array_push($fields,"IFNULL(CONCAT(concat(consultant.pr_name_first, ' '), consultant.pr_name_last),consultant.pr_name_last) AS consultant_name");
array_push($fields,"bl_block.rv_consultant_id");
array_push($fields,"bl_block.rv_agent_ref");
array_push($fields,"bl_block.rt_rate_type_id");
array_push($fields,"agent.pr_persona_ix AS agent_id");
array_push($fields,"bl_block.bl_block_abbrev");
array_push($fields,"MIN(bl_block_period.bl_per_date_start_series_fst) AS start_time");
array_push($fields,"MAX(bl_block_period.bl_per_date_start_series_lst) AS end_time");
$dateFromFilter = $dateFrom != "" ? "AND bl_block_period.bl_per_date_start_series_fst >= '" . $dateFrom->format("Y-m-d") . "'": "";
$dateToFilter = $dateTo != "" ? "AND bl_block_period.bl_per_date_start_series_lst <= '" . $dateTo->format("Y-m-d") . "'" : "";

$where = "
	WHERE
		bl_block.bl_block_name LIKE '" . $bl_block_name . "'
		AND bl_block.bl_block_abbrev LIKE '" . $bl_block_abbrev . "'
		AND bl_block.bl_block_ix LIKE '" . $bl_block_ix . "'
		AND bl_block.rv_agent_ref LIKE '" . $rv_agent_ref . "'
		$agentFilter[where]
		$consultantFilter[where]
		$dateFromFilter
		$dateToFilter
";

$from = "
	bl_block
	LEFT JOIN pr_persona agent ON agent.pr_persona_ix = bl_block.rv_agent_id
	LEFT JOIN pr_persona consultant ON consultant.pr_persona_ix = bl_block.rv_consultant_id
	LEFT JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
	LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
	LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
	LEFT JOIN rv_reservation_item allocation_item_expired ON allocation_item_expired.rv_reservation_item_ix = allocation_item.rv_reservation_item_ix AND allocation_item.rv_alloc_expiry_date < CURDATE()
	LEFT JOIN rv_reservation_item reservation_item ON reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
";

$groupBy = "
	bl_block_ix,
	bl_block.bl_block_name,
	bl_block.bl_block_abbrev,
	agent_name,
	agent_id,
	bl_block.rv_agent_id,
	consultant_name,
	bl_block.rv_consultant_id,
	bl_block.rv_agent_ref
";

$fromCount = " bl_block ";
$agentId = "0";
if ( isAgent($GLOBALS['userid']) ) {
	$agentId = $GLOBALS['userid'];
}

if ( $GLOBALS['pr_agent_link'] != "0" ) {
	$agentId = $GLOBALS['pr_agent_link'];
}

// Continue setting limits
$listsql = "SELECT COUNT(DISTINCT bl_block_ix) FROM " . $from . " " . $where;

$total = $GLOBALS['lDB']->get($listsql,4);
$realCount = (string) $total / $limit;
$modCount = (string) $total % $limit;
$pCount	= (int) $realCount;

if($modCount != "0") {
	$pCount += "1";
}

if ( $pLimit > $pCount ) {
	$pLimit = $pCount;
}

$pStart = $page - (int) ($pLimit/2);
--$page;
if ( $pStart < "1" ) {
	$pStart = "1";
}

if ( $pStart > $pCount ) {
	$pStart = $pCount;
}

$pEnd = $pStart+$pLimit;

if ( $pEnd > $pCount ) {
	$pEnd = $pCount+1;
}
if ( $page > $pEnd ) {
	$page = $pEnd-1;
}
$start = $page * $limit;
$start = ($start < 0) ? 0 : $start;

$GLOBALS['temp']['imgSort1']	= "";
$GLOBALS['temp']['imgSort2']	= "";
$GLOBALS['temp']['imgSort3']	= "";
$GLOBALS['temp']['imgSort4']	= "";
$GLOBALS['temp']['imgSort5']	= "";
$GLOBALS['temp']['imgSort6']	= "";
$GLOBALS['temp']['imgSort7']	= "";
$GLOBALS['temp']['imgSort8']	= "";
$GLOBALS['temp']['imgSort9']	= "";
$GLOBALS['temp']['imgSort10']	= "";
$GLOBALS['temp']['imgSort11']	= "";
$GLOBALS['temp']['imgSort12']	= "";
$GLOBALS['temp']['imgSort13']	= "";
$GLOBALS['temp']['imgSort14']	= "";

$GLOBALS['temp']['imgSort1Mode']	= "";
$GLOBALS['temp']['imgSort2Mode']	= "";
$GLOBALS['temp']['imgSort3Mode']	= "";
$GLOBALS['temp']['imgSort4Mode']	= "";
$GLOBALS['temp']['imgSort5Mode']	= "";
$GLOBALS['temp']['imgSort6Mode']	= "";
$GLOBALS['temp']['imgSort7Mode']	= "";
$GLOBALS['temp']['imgSort8Mode']	= "";
$GLOBALS['temp']['imgSort9Mode']	= "";
$GLOBALS['temp']['imgSort10Mode']	= "";
$GLOBALS['temp']['imgSort11Mode']	= "";
$GLOBALS['temp']['imgSort12Mode']	= "";
$GLOBALS['temp']['imgSort13Mode']	= "";
$GLOBALS['temp']['imgSort14Mode']	= "";
$GLOBALS['temp']['imgSort15Mode']	= "";
$GLOBALS['temp']['imgSort16Mode']	= "";

$order = "";

switch ($sortBy) {
	case 0:
		$order .= "LENGTH(bl_block.bl_block_ix), bl_block.bl_block_ix";
		$GLOBALS['temp']['imgSort1Mode'] = "_z";
		break;
	case 1:
		$order .= "LENGTH(bl_block.bl_block_ix) DESC, bl_block.bl_block_ix DESC";
		$GLOBALS['temp']['imgSort2Mode'] = "_z";
		break;
	case 2:
		$order .= "bl_block.bl_block_name";
		$GLOBALS['temp']['imgSort3Mode'] = "_z";
		break;
	case 3:
		$order .= "bl_block.bl_block_name DESC";
		$GLOBALS['temp']['imgSort4Mode'] = "_z";
		break;
	case 4:
		$order .= "agent_name";
		$GLOBALS['temp']['imgSort5Mode'] = "_z";
		break;
	case 5:
		$order .= "agent_name DESC";
		$GLOBALS['temp']['imgSort6Mode'] = "_z";
		break;
	case 6:
		$order .= "TRIM(CONCAT(consultant.pr_name_first, ' ', consultant.pr_name_last))";
		$GLOBALS['temp']['imgSort7Mode'] = "_z";
		break;
	case 7:
		$order .= "TRIM(CONCAT(consultant.pr_name_first, ' ', consultant.pr_name_last)) DESC";
		$GLOBALS['temp']['imgSort8Mode'] = "_z";
		break;
	case 9:
		$order .= "rt_rate_type.rt_rate_type_desc DESC";
		$GLOBALS['temp']['imgSort10Mode'] = "_z";
		break;
	case 10:
		$order .= "series";
		$GLOBALS['temp']['imgSort11Mode'] = "_z";
		break;
	case 11:
		$order .= "series DESC";
		$GLOBALS['temp']['imgSort12Mode'] = "_z";
		break;
	case 12:
		$order .= "draw_downs";
		$GLOBALS['temp']['imgSort13Mode'] = "_z";
		break;
	case 13:
		$order .= "draw_downs DESC";
		$GLOBALS['temp']['imgSort14Mode'] = "_z";
		break;
	case 14:
		$order .= "bl_block.bl_block_abbrev";
		$GLOBALS['temp']['imgSort15Mode'] = "_z";
		break;
	case 15:
		$order .= "bl_block.bl_block_abbrev DESC";
		$GLOBALS['temp']['imgSort16Mode'] = "_z";
		break;
}
$order = (!empty($order)) ? "ORDER BY " . $order : "";
$limit = "LIMIT ".$start.", ".$limit;

// Generate the page breaks ---------------------------------------------------
$printString = '<a class="txt"> of ' . $pCount . ' page(s)</a>';
$pString = '<a class="txtbr">Pages:</a> ';

if ( $pStart > "1" ) {
	$pString .= '<a href="#" id="lnkFirst" class="txtbr">First</a>, ';
}

for ( $i = $pStart; $i < $pEnd; $i++ ) {
	if ( $i != $pStart ) {
		$pString .= ", ";
	}
	$pString .= "<a class=\"txtbr\"";
	if ( $i != $page + 1 ) {
		$pString .= " href=\"#\" name=\"lnkPager\" page=\"$i\"";
	}
	$pString .= ">" . $i . "</a>";
}

if ( $pEnd < $pCount ) {
	$pString .= "<a class=\"txtbr\">...</a> <a href=\"#\" onclick=\"javascript:ShowFrom(" . $pCount . ");\" class=\"txtbr\">Last</a>";
}
$pString .= "<a class=\"txtbr\"> of " . $pCount . " page(s)</a>";

$GLOBALS['temp']['hideNext'] = "";
$GLOBALS['temp']['hidePrev'] = "";
$pNext = $page + 2;
$pPrev = $page;
$GLOBALS['temp']['pNext'] = (string)$pNext;
$GLOBALS['temp']['pPrev'] = (string)$pPrev;

if ( $page + 2 > $pCount ) {
	$GLOBALS['temp']['hideNext'] = " style=\"visibility: hidden;\"";
}

if ( $page < "1" ) {
	$GLOBALS['temp']['hidePrev'] = " style=\"visibility: hidden;\"";
}

$rows = "";
if ($doSearch) {
	$sql = "SELECT DISTINCT " . join(", ",$fields) . " FROM " . $from . " " . $where . " GROUP BY " . $groupBy . " " . $order . " " . $limit;
	$result = $GLOBALS['lDB']->get($sql,0);

	$imax = mysqli_num_rows($result);
	for ( $i = 0; $i < $imax; $i++ ) {
		$resultSet = mysqli_fetch_array($result);
		$blockBooking['job'] = "6001";
		if (checkJob("6004")) {
			$blockBooking['job'] = "6004";
		}
		$blockBooking['bl_block_ix'] = $resultSet[0];
		$blockBooking['bl_block_name'] = t_encodeHTMLField($resultSet[1]);
		
		$blockBooking['agent_name'] = $resultSet[2];
		if (trim($blockBooking['agent_name']) == "" || $blockBooking['agent_name'] == "0" ) {
			$blockBooking['agent_name'] = "Direct booking";
		}
		if (trim($resultSet['rv_agent_ref']) != "") {
			$blockBooking['rv_agent_ref'] = $resultSet['rv_agent_ref'];
		} else {
			$blockBooking['rv_agent_ref'] = "&nbsp;";
		}
		
		$blockBooking['consultant_name'] = $resultSet[4];
		$series = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				bl_series_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_item_accomm_count > 0 AND allocation_item.bl_series_sequence_number IS NOT NULL
			WHERE
				bl_block_period.bl_block_id = '$resultSet[0]'
				AND allocation_item.bl_series_id IS NOT NULL",3);
		$expiredSeries = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				bl_series_id
			FROM
				bl_block_period
				LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
				LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix AND allocation_item.rv_item_accomm_count > 0 AND allocation_item.bl_series_sequence_number IS NOT NULL
			WHERE
				bl_block_period.bl_block_id = '$resultSet[0]'
				AND allocation_item.rv_alloc_expiry_date < CURDATE()
				AND allocation_item.bl_series_id IS NOT NULL",3);
		$blockBooking['series'] = count($expiredSeries)."/".count($series);
		$blockBooking['agent_id'] = $resultSet[8];
		$draw_down_reservations = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				rv_reservation.rv_reservation_ix
			FROM
				bl_block_period
				INNER JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix
				INNER JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation.rf_reservation_status_id != '25'
				AND rv_reservation.rf_reservation_status_id != '15'
				AND rv_reservation.rf_reservation_status_id != '97'
				AND bl_block_period.bl_block_id = '$resultSet[0]'
		", 3);
		$blockBooking['draw_downs'] = count($draw_down_reservations);
		$blockBooking['draw_down_reservations'] = implode(",",$draw_down_reservations);
		$blockBooking['bl_block_abbrev'] = t_encodeHTMLField($resultSet[9]);
		$blockBooking['start_time'] = t_encodeHTMLField($resultSet[10]);
		$blockBooking['end_time'] = t_encodeHTMLField($resultSet[11]);
		if ($resultSet[10] == "" && $resultSet[11] == "") {
			$blockBooking['date_range'] = "No periods defined";
		} else {
			$blockBooking['date_range'] = t_encodeHTMLField($resultSet[10]) . " to " . t_encodeHTMLField($resultSet[11]);
		}

		$blockBooking['strong1'] = "";
		$blockBooking['strong2'] = "";
		
		$blockBookingFindRowHTML = Join("\n",File(__DIR__ . "/../../../public/html/block_booking_find_row.htm"));
		$rows .= showpage($blockBooking,$blockBookingFindRowHTML);
		array_push($blockBookingScrollSet,$blockBooking['bl_block_ix']);
	}
}

$GLOBALS['temp']['rows'] = $rows;

$srch = urldecode($argv[1]);

if ( $srch == "" || $srch == "*" ) {
	$srch = urldecode($argv[2]);
}

$noresult = "
	<div style=\"text-align: left\">
		<p>&nbsp;&nbsp;Your search did not match any records.</p>
		<p>&nbsp;&nbsp;<b>Suggestions:</b><br />
		&nbsp;&nbsp;- Use wildcards to assist in your search<br />
		&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br />
		&nbsp;&nbsp;- Use a different keyword.</p>
	</div>
";

$defout = "
	<tr>
		<td colspan=\"4\" align=\"center\" class=\"txt\">" . $noresult . "</td>
	</tr>";

$GLOBALS['temp']['hidePage'] = "";
if ( $GLOBALS['temp']['rows'] == "" ) {
	$GLOBALS['temp']['rows'] = $defout;
	$GLOBALS['temp']['hidePage'] = "style=\"display: none;\"";
}

if ( $argv[7] == "1" ) {
	$GLOBALS['temp']['submitval'] = "1";
} else {
	$GLOBALS['temp']['submitval'] = "0";
}

$GLOBALS['temp']['ofnum']			= $printString;
$GLOBALS['temp']['nextprev']	= $pString;
$GLOBALS['temp']['limited']		= (string) $total;
$GLOBALS['temp']['sortby']		= $sortBy;

$newRelic->stop_transaction();

setRecordScroll($blockBookingScrollSet);

$sortByObj = new tpParseObject();
$sortByObj->setParam("value",$sortBy);

$GLOBALS['tagList']['sortby'] = $sortByObj;
