<?php

require_once(__DIR__ . "/db.bl_block_period.php");
require_once(__DIR__ . "/functions.reservation.block.php");
require_once(__DIR__ . '/functions.reservation.itinerary.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . "/class.template.php");
require_once(__DIR__ . "/db.sc_group.php");

function validateBlockBookingPeriod($bl_block_period_ix=false) {
	global $lDB;

	$GLOBALS['temp']['validationMessage'] = "";
	return true;
}

function updateBlockBookingPeriod(array $params) {
	$params['bl_block_period_ix'] = isset($params['bl_block_period_ix']) ? $params['bl_block_period_ix'] : "";
	$params['bl_per_date_start_series_fst'] = isset($params['bl_per_date_start_series_fst']) ? $params['bl_per_date_start_series_fst'] : "";
	$params['bl_per_date_start_series_lst'] = isset($params['bl_per_date_start_series_lst']) ? $params['bl_per_date_start_series_lst'] : "";
	$params['bl_per_recurrence_per_ind'] = isset($params['bl_per_recurrence_per_ind']) ? $params['bl_per_recurrence_per_ind'] : "";
	$params['bl_per_recurrence_per_1'] = isset($params['bl_per_recurrence_per_1']) ? $params['bl_per_recurrence_per_1'] : "";
	$params['bl_per_recurrence_per_2'] = isset($params['bl_per_recurrence_per_2']) ? $params['bl_per_recurrence_per_2'] : "";
	$params['bl_per_recurrence_per_3'] = isset($params['bl_per_recurrence_per_3']) ? $params['bl_per_recurrence_per_3'] : "";
	$params['bl_per_recurrence_per_4'] = isset($params['bl_per_recurrence_per_4']) ? $params['bl_per_recurrence_per_4'] : "";
	$params['bl_per_recurrence_per_5'] = isset($params['bl_per_recurrence_per_5']) ? $params['bl_per_recurrence_per_5'] : "";
	$params['bl_per_expiry_ind'] = isset($params['bl_per_expiry_ind']) ? $params['bl_per_expiry_ind'] : "";
	$params['bl_per_expiry_lead_time_days'] = isset($params['bl_per_expiry_lead_time_days']) ? $params['bl_per_expiry_lead_time_days'] : "";
	$params['bl_per_expiry_lead_time_date'] = isset($params['bl_per_expiry_lead_time_date']) ? $params['bl_per_expiry_lead_time_date'] : "";
	$params['adjustAllocationExpiry'] = isset($params['adjustAllocationExpiry']) ? $params['adjustAllocationExpiry'] : "";

	$blockPeriodDetailsBefore = array();
	if ($params['adjustAllocationExpiry']) {
		$blockPeriodDetailsBefore = $GLOBALS['lDB']->get("
			SELECT
				bl_per_expiry_ind,
				bl_per_expiry_lead_time_days,
				bl_per_expiry_lead_time_date
			FROM
				bl_block_period
			WHERE
				bl_block_period.bl_block_period_ix = '".$params['bl_block_period_ix']."'
		",1);
	}

	db_bl_block_period_update(
		$params['bl_block_period_ix'],
		$params['bl_per_date_start_series_fst'],
		$params['bl_per_date_start_series_lst'],
		$params['bl_per_recurrence_per_ind'],
		$params['bl_per_recurrence_per_1'],
		$params['bl_per_recurrence_per_2'],
		$params['bl_per_recurrence_per_3'],
		$params['bl_per_recurrence_per_4'],
		$params['bl_per_recurrence_per_5'],
		$params['bl_per_expiry_ind'],
		$params['bl_per_expiry_lead_time_days'],
		$params['bl_per_expiry_lead_time_date']
	);

	$blockPeriodDetails = $GLOBALS['lDB']->get("
		SELECT
			bl_block_period.bl_block_period_ix,
			bl_block_period.bl_per_date_start_series_fst,
			bl_block_period.bl_per_date_start_series_lst,
			bl_block_period.bl_per_recurrence_per_ind,
			bl_block_period.bl_per_recurrence_per_1,
			bl_block_period.bl_per_recurrence_per_2,
			bl_block_period.bl_per_recurrence_per_3,
			bl_block_period.bl_per_recurrence_per_4,
			bl_block_period.bl_per_recurrence_per_5,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			IFNULL(CAST((COUNT(allocation_item.rv_reservation_item_ix) - COUNT(draw_down_item.rv_reservation_item_ix)) / MAX(allocation_item.bl_series_sequence_number) AS INT),0) AS series_total,
			IFNULL(CAST((COUNT(allocation_item_expired.rv_reservation_item_ix) - COUNT(draw_down_item.rv_reservation_item_ix)) / MAX(allocation_item.bl_series_sequence_number) AS INT),0) AS series_expired,
			allocation.rv_reservation_ix AS allocation_id,
			bl_block_period.bl_per_expiry_lead_time_date,
			bl_block_period.bl_per_expiry_lead_time_date AS bl_per_expiry_lead_time_date_raw,
			COUNT(draw_down_item.rv_reservation_item_ix) AS draw_downs
		FROM
			bl_block_period
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
			LEFT JOIN rv_reservation_item allocation_item_expired ON allocation_item_expired.rv_reservation_item_ix = allocation_item.rv_reservation_item_ix AND allocation_item.rv_alloc_expiry_date < CURDATE()
			LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			bl_block_period.bl_block_period_ix = '".$params['bl_block_period_ix']."'
		GROUP BY
			bl_block_period.bl_block_period_ix,
			bl_per_date_start_series_fst,
			bl_per_date_start_series_lst,
			bl_block_period.bl_per_recurrence_per_ind,
			bl_block_period.bl_per_recurrence_per_1,
			bl_block_period.bl_per_recurrence_per_2,
			bl_block_period.bl_per_recurrence_per_3,
			bl_block_period.bl_per_recurrence_per_4,
			bl_block_period.bl_per_recurrence_per_5,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			bl_per_expiry_lead_time_date,
			bl_per_expiry_lead_time_date_raw
		ORDER BY
			bl_block_period.bl_per_date_start_series_fst, bl_block_period.bl_per_date_start_series_lst, bl_block_period.bl_block_period_ix
	",1);

	if ($params['adjustAllocationExpiry']) {
		if (
			$blockPeriodDetailsBefore['bl_per_expiry_ind'] != $blockPeriodDetails['bl_per_expiry_ind'] ||
			$blockPeriodDetailsBefore['bl_per_expiry_lead_time_days'] != $blockPeriodDetails['bl_per_expiry_lead_time_days'] ||
			$blockPeriodDetailsBefore['bl_per_expiry_lead_time_date'] != $blockPeriodDetails['bl_per_expiry_lead_time_date']
		) {
			$periodAllocations = $GLOBALS['lDB']->get("
				SELECT DISTINCT
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.bl_series_sequence_number,
					rv_reservation_item.bl_series_id
				FROM
					rv_reservation_item
					LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
					LEFT JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id			
					LEFT JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_itinerary_ix = rv_reservation_item.bl_block_itinerary_id
					LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = bl_block_itinerary.bl_block_period_id
				WHERE
					rv_reservation.bl_block_period_id = '".$params['bl_block_period_ix']."'
					AND rv_reservation_item.bl_series_sequence_number = 1
					AND link_item.rv_reservation_item_ix IS NULL
				ORDER BY
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.rv_item_nights

			",2);
			$allocationIds = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation.rv_reservation_ix
				FROM
					rv_reservation
				WHERE
					rv_reservation.bl_block_period_id = '".$params['bl_block_period_ix']."'
			",3);
			foreach ($allocationIds as $allocationId) {
				$GLOBALS['lDB']->put("
					UPDATE
						rv_reservation
					SET
						rv_alloc_expiry_date = '".$GLOBALS['lDB']->escape($blockPeriodDetails['bl_per_expiry_lead_time_date_raw'])."',
						rv_alloc_expiry_days = '".$GLOBALS['lDB']->escape($blockPeriodDetails['bl_per_expiry_lead_time_days'])."'
					WHERE
						rv_reservation.rv_reservation_ix = '$allocationId'
				");
			}

			foreach ($periodAllocations as $allocation) {
				$allocationExpiryDate = getItemExpiryDate($allocation['rv_item_date_arrive'], $blockPeriodDetails['bl_per_expiry_ind'], $blockPeriodDetails['bl_per_expiry_lead_time_days'], $blockPeriodDetails['bl_per_expiry_lead_time_date']);
				$allocationItemIds = $GLOBALS['lDB']->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix,
						rv_reservation_item.ac_accomm_type_id,
						rv_reservation_item.rv_item_date_arrive,
						rv_reservation_item.rv_item_date_depart
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.bl_series_id = '". $allocation['bl_series_id'] ."'
				",6);
				foreach($allocationItemIds as $allocationItem) {
					$GLOBALS['lDB']->put("
						UPDATE
							rv_reservation_item
						SET
							rv_alloc_expiry_date = '".$GLOBALS['lDB']->escape($allocationExpiryDate)."'
						WHERE
							rv_reservation_item.rv_reservation_item_ix = '$allocationItem[rv_reservation_item_ix]'
					");
					// Clear cache
					$dates = makeDates($allocationItem['rv_item_date_arrive'].":".$allocationItem['rv_item_date_depart'],dateSubtract($allocationItem['rv_item_date_depart'],$allocationItem['rv_item_date_arrive']) + 1);
					$stock = new Stock($allocationItem['ac_accomm_type_id'],$allocationItem['rv_item_date_arrive'],$allocationItem['rv_item_date_depart']);
					$stock->ClearCache(array('agentAllocation','occupancy'), $dates);
				}
			}
		}
	} 
	$blockPeriodSeries = $GLOBALS['lDB']->get("
		SELECT
			IFNULL(CAST((COUNT(allocation_item.rv_reservation_item_ix) - COUNT(draw_down_item.rv_reservation_item_ix)) / MAX(allocation_item.bl_series_sequence_number) AS INT),0) AS series_total,
			IFNULL(CAST((COUNT(allocation_item_expired.rv_reservation_item_ix) - COUNT(draw_down_item.rv_reservation_item_ix)) / MAX(allocation_item.bl_series_sequence_number) AS INT),0) AS series_expired
		FROM
			bl_block_period
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
			LEFT JOIN rv_reservation_item allocation_item_expired ON allocation_item_expired.rv_reservation_item_ix = allocation_item.rv_reservation_item_ix AND allocation_item.rv_alloc_expiry_date < CURDATE()
			LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			bl_block_period.bl_block_period_ix = '".$params['bl_block_period_ix']."'
		GROUP BY
			bl_block_period.bl_block_period_ix,
			bl_per_date_start_series_fst,
			bl_per_date_start_series_lst,
			bl_block_period.bl_per_recurrence_per_ind,
			bl_block_period.bl_per_recurrence_per_1,
			bl_block_period.bl_per_recurrence_per_2,
			bl_block_period.bl_per_recurrence_per_3,
			bl_block_period.bl_per_recurrence_per_4,
			bl_block_period.bl_per_recurrence_per_5,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			bl_per_expiry_lead_time_date
		ORDER BY
			bl_block_period.bl_per_date_start_series_fst, bl_block_period.bl_per_date_start_series_lst, bl_block_period.bl_block_period_ix
	",1);

	$recurrenceDescription = getRecurrencePeriodDescription(
		$blockPeriodDetails["bl_per_recurrence_per_ind"],
		$blockPeriodDetails["bl_per_recurrence_per_1"],
		$blockPeriodDetails["bl_per_recurrence_per_2"],
		$blockPeriodDetails["bl_per_recurrence_per_3"],
		$blockPeriodDetails["bl_per_recurrence_per_4"],
		$blockPeriodDetails["bl_per_recurrence_per_5"]);
	$expiryDescription = getExpiryDescription(
		$blockPeriodDetails["bl_per_expiry_ind"],
		$blockPeriodDetails["bl_per_expiry_lead_time_days"],
		$blockPeriodDetails["bl_per_expiry_lead_time_date"]
	);
	return array(
		"bl_per_date_start_series_fst"=> formatValue($blockPeriodDetails["bl_per_date_start_series_fst"], "date"),
		"bl_per_date_start_series_lst"=> formatValue($blockPeriodDetails["bl_per_date_start_series_lst"], "date"),
		"recurrence"=> $recurrenceDescription,
		"expiry"=> $expiryDescription,
		"series_total"=> $blockPeriodSeries["series_total"],
		"series_expired"=> $blockPeriodSeries["series_expired"]
	);
}

function deleteBlockBookingPeriod($bl_block_period_ix) {
	global $lDB;
}

function getBlockBookingPeriodDetails($bl_block_period_ix) {
	$blockPeriodDetails = $GLOBALS['lDB']->get("
		SELECT
			bl_block_period_ix,
			bl_block_id,
			bl_per_date_start_series_fst,
			bl_per_date_start_series_lst,
			bl_per_recurrence_per_ind,
			bl_per_recurrence_per_1,
			bl_per_recurrence_per_2,
			bl_per_recurrence_per_3,
			bl_per_recurrence_per_4,
			bl_per_recurrence_per_5,
			bl_per_expiry_ind,
			bl_per_expiry_lead_time_days,
			bl_per_expiry_lead_time_date,
			allocation.rv_reservation_ix AS allocation_id
		FROM
			bl_block_period
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' AND allocation.rf_reservation_status_id != '97'
		WHERE
			bl_block_period.bl_block_period_ix = '$bl_block_period_ix'
	",1);
	$sc_grp_res_ovr_overbooking_yn = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");
	$blockPeriodDetails['sc_grp_res_ovr_overbooking_yn'] = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");

	return $blockPeriodDetails;
}

function setBlockBookingPeriodDetails($blockPeriodDetails, &$target) {
	$fields = array(
		"bl_block_period_ix",
		"bl_block_id",
		"bl_per_date_start_series_fst",
		"bl_per_date_start_series_lst",
		"bl_per_recurrence_per_ind",
		"bl_per_recurrence_per_1",
		"bl_per_recurrence_per_2",
		"bl_per_recurrence_per_3",
		"bl_per_recurrence_per_4",
		"bl_per_recurrence_per_5",
		"bl_per_expiry_ind",
		"bl_per_expiry_lead_time_days",
		"bl_per_expiry_lead_time_date",
		"allocation_id",
		"sc_grp_res_ovr_overbooking_yn"
	);
	foreach ($fields as $field) {
		$target[$field] = isset($blockPeriodDetails[$field]) ? $blockPeriodDetails[$field] : "";
	}
	$target['txtIntervalNumberDaysValue'] = "";
	if (!empty($blockPeriodDetails) && array_key_exists('bl_per_recurrence_per_ind',$blockPeriodDetails)) {
		if ($blockPeriodDetails['bl_per_recurrence_per_ind'] == 6) {
			$target['txtIntervalNumberDaysValue'] = $blockPeriodDetails['bl_per_recurrence_per_4'];
		}
	}
	$selMonthDayOptions = array(
		"<option value='1'>01</option>",
		"<option value='2'>02</option>",
		"<option value='3'>03</option>",
		"<option value='4'>04</option>",
		"<option value='5'>05</option>",
		"<option value='6'>06</option>",
		"<option value='7'>07</option>",
		"<option value='8'>08</option>",
		"<option value='9'>09</option>",
		"<option value='10'>10</option>",
		"<option value='11'>11</option>",
		"<option value='12'>12</option>",
		"<option value='13'>13</option>",
		"<option value='14'>14</option>",
		"<option value='15'>15</option>",
		"<option value='16'>16</option>",
		"<option value='17'>17</option>",
		"<option value='18'>18</option>",
		"<option value='19'>19</option>",
		"<option value='20'>20</option>",
		"<option value='21'>21</option>",
		"<option value='22'>22</option>",
		"<option value='23'>23</option>",
		"<option value='24'>24</option>",
		"<option value='25'>25</option>",
		"<option value='26'>26</option>",
		"<option value='27'>27</option>",
		"<option value='28'>28</option>",
		"<option value='29'>29</option>",
		"<option value='30'>30</option>",
		"<option value='31'>31</option>"
	);
	$GLOBALS['temp']['selMonthDayOptions'] = implode("\n", $selMonthDayOptions);
	$selMonthOptions = array(
		"<option value='1'>Jan</option>",
		"<option value='2'>Feb</option>",
		"<option value='3'>Mar</option>",
		"<option value='4'>Apr</option>",
		"<option value='5'>May</option>",
		"<option value='6'>Jun</option>",
		"<option value='7'>Jul</option>",
		"<option value='8'>Aug</option>",
		"<option value='9'>Sep</option>",
		"<option value='10'>Oct</option>",
		"<option value='11'>Nov</option>",
		"<option value='12'>Dec</option>"
	);
	$GLOBALS['temp']['selMonthOptions'] = implode("\n", $selMonthOptions);
	$selWeekdayOptions = array(
		"<option value='1'>Mon</option>",
		"<option value='2'>Tue</option>",
		"<option value='3'>Wed</option>",
		"<option value='4'>Thu</option>",
		"<option value='5'>Fri</option>",
		"<option value='6'>Sat</option>",
		"<option value='7'>Sun</option>"
	);
	$GLOBALS['temp']['selWeekdayOptions'] = implode("\n", $selWeekdayOptions);
	$selOrdinalWeekOfMonthOptions = array(
		"<option value='1'>1st</option>",
		"<option value='2'>2nd</option>",
		"<option value='3'>3rd</option>",
		"<option value='4'>4th</option>",
		"<option value='5'>5th</option>",
	);
	$GLOBALS['temp']['selOrdinalWeekOfMonthOptions'] = implode("\n", $selOrdinalWeekOfMonthOptions);
	$selIntervalMonthOptions = array(
		"<option value='1'>1</option>",
		"<option value='2'>2</option>",
		"<option value='3'>3</option>",
		"<option value='4'>4</option>",
		"<option value='5'>6</option>"
	);
	$GLOBALS['temp']['selIntervalMonthOptions'] = implode("\n", $selIntervalMonthOptions);
	$selIntervalMonthOffsetBeforeAfterOptions = array(
		"<option value='1'>after the start</option>",
		"<option value='2'>before the end</option>"
	);
	$GLOBALS['temp']['selIntervalMonthOffsetBeforeAfterOptions'] = implode("\n", $selIntervalMonthOffsetBeforeAfterOptions);
}

function generateSeries($bl_block_period_ix, $skipOverbookings=true) {
	global $lDB;
	$sc_grp_res_ovr_overbooking_yn = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");
	// should only be able to cause overbookings with the appropriate user privelage
	$skipOverbookings = !$sc_grp_res_ovr_overbooking_yn ? true : $skipOverbookings;
	$message = array();
	$today = date("Y-m-d");

	$blockDetails = $lDB->get("
		SELECT
			bl_block.bl_block_ix,
			bl_block.bl_block_name,
			bl_block.rv_consultant_id,
			bl_block.rv_agent_id,
			bl_block.rv_agent_contact_persona_id,
			bl_block.rv_agent_ref,
			bl_block.rt_rate_type_id,
			bl_block.bl_block_commission_perc,
			bl_block.bl_block_note,
			bl_block.bl_block_note_internal,
			bl_block_period.bl_per_date_start_series_fst,
			bl_block_period.bl_per_date_start_series_lst,
			bl_block_period.bl_per_recurrence_per_ind,
			bl_block_period.bl_per_recurrence_per_1,
			bl_block_period.bl_per_recurrence_per_2,
			bl_block_period.bl_per_recurrence_per_3,
			bl_block_period.bl_per_recurrence_per_4,
			bl_block_period.bl_per_recurrence_per_5,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			bl_block_period.bl_per_expiry_lead_time_date
		FROM
			bl_block
			INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		WHERE
			bl_block_period_ix = '$bl_block_period_ix'
	",1);
	$firstItineraryRateType = $lDB->get("
		SELECT
			bl_block_itinerary.rt_rate_type_id 
		FROM 
			bl_block_itinerary 
			INNER JOIN bl_block_period ON bl_block_period.bl_block_period_ix = bl_block_itinerary.bl_block_period_id
		WHERE 
			bl_block_period.bl_block_period_ix = '$bl_block_period_ix'
		ORDER BY
			bl_block_itinerary.bl_block_itinerary_id ASC
		LIMIT 1
	",4);

	if (!empty($blockDetails)) {
		$maxDayLimit = 0;
		$maxDay = 0;
		$expiryDate = null;
		$bl_per_date_start_series_fst = new DateTime($blockDetails['bl_per_date_start_series_fst']);
		$intervalDateStart = new DateTime($blockDetails['bl_per_date_start_series_fst']);
		$firstOccurrence = getOccurrence(
			$intervalDateStart, 
			$blockDetails['bl_per_recurrence_per_ind'],
			$blockDetails['bl_per_recurrence_per_1'],
			$blockDetails['bl_per_recurrence_per_2'],
			$blockDetails['bl_per_recurrence_per_3'],
			$blockDetails['bl_per_recurrence_per_4'],
			$blockDetails['bl_per_recurrence_per_5'],
			true
		);
		$intervalDateEnd = new DateTime($blockDetails['bl_per_date_start_series_lst']);
		// Create a list of dates that each set of itineraries should start from
		// for the series
		$occurrences = array($firstOccurrence->format("Y-m-d"));
		$occurrenceCounter = 1;
		while ($firstOccurrence <= $intervalDateEnd && $occurrenceCounter < 1000) {
			$nextOccurrence = getOccurrence(
				$firstOccurrence, 
				$blockDetails['bl_per_recurrence_per_ind'],
				$blockDetails['bl_per_recurrence_per_1'],
				$blockDetails['bl_per_recurrence_per_2'],
				$blockDetails['bl_per_recurrence_per_3'],
				$blockDetails['bl_per_recurrence_per_4'],
				$blockDetails['bl_per_recurrence_per_5']
			);
			if ($nextOccurrence <= $intervalDateEnd) {
				$occurrences[] = $nextOccurrence->format("Y-m-d");
			}
			$firstOccurrence = $nextOccurrence;
			$occurrenceCounter += 1;
			if ($occurrenceCounter >= 999) {
				Throw new Exception("The number of possible occurrence dates for this block period exceeds the maximum allowed amount.");
			}
		}
		$periodItineraries = $GLOBALS['lDB']->get("
			SELECT
				bl_block_itinerary.bl_block_itinerary_ix,
				bl_block_itinerary.bl_block_period_id,
				bl_block_itinerary.ac_accomm_type_id,
				bl_block_itinerary.rt_rate_type_id,
				bl_block_itinerary.bl_itinerary_day_start,
				bl_block_itinerary.bl_itinerary_day_end,
				bl_block_itinerary_rooms,
				bl_block_itinerary_pax
			FROM
				bl_block_itinerary
			WHERE
				bl_block_itinerary.bl_block_period_id = '$bl_block_period_ix'
			ORDER BY
				bl_block_itinerary.bl_itinerary_day_start,
				bl_block_itinerary.bl_itinerary_day_end

		",6);

		// Get Unit and Adult Rate Groups based on sys code
		$unitId = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
		$adultId = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 2",4);

		// Check for overbookings - and build a list of itineraries to be created
		// based on whether overbookings are allowed or not
		$itineraries = array();
		$numberOverbookedAllocationBlocks = 0;
		$numberExpiredAllocationItems = 0;
		foreach ($occurrences as $key=>$occurrence) {
			$series_sequence = 0;
			$firstBlockDateArrive = null;
			foreach($periodItineraries as $itinerary) {
				$series_sequence += 1;
				$dayStart = $itinerary['bl_itinerary_day_start'] > 1 ? $itinerary['bl_itinerary_day_start'] - 1 : 0;
				$dateArrive = date('Y-m-d', strtotime('+' . $dayStart . ' day ' . $occurrence));
				$nights = $itinerary['bl_itinerary_day_end'] - $itinerary['bl_itinerary_day_start'];
				$dateDepart = date('Y-m-d', strtotime('+' . $nights . ' day ' . $dateArrive));
				$isAvailable = check_item_availability($dateArrive,$dateDepart,$itinerary['ac_accomm_type_id'],$itinerary['bl_block_itinerary_rooms']);
				if ($isAvailable == true || $skipOverbookings == false) {
					$rateGroups = $unitId . "_" . $itinerary['bl_block_itinerary_rooms'] . "~" . $adultId . "_" . $itinerary['bl_block_itinerary_pax'];
					$itemInfo = join(":",array(
						$itinerary['ac_accomm_type_id'],
						$dateArrive,
						$dateDepart,
						$nights,
						$rateGroups
					));
					$firstBlockDateArrive = (empty($firstBlockDateArrive)) ? $dateArrive : $firstBlockDateArrive;
					$itemExpiryDate = getItemExpiryDate($firstBlockDateArrive, $blockDetails['bl_per_expiry_ind'], $blockDetails['bl_per_expiry_lead_time_days'], $blockDetails['bl_per_expiry_lead_time_date']);
					if($itemExpiryDate < $today) {
						$numberExpiredAllocationItems += 1;
					}
					$itineraries[] = array("dateArrive"=>$dateArrive, "dateDepart"=>$dateDepart, "itemInfo"=>$itemInfo, "bl_block_itinerary_ix"=>$itinerary['bl_block_itinerary_ix'], "series_sequence"=>$series_sequence, "itemExpiryDate"=>$itemExpiryDate);
				} else {
					// remove this occurrence from list
					unset($occurrences[$key]);
					$numberOverbookedAllocationBlocks += 1;
				}
			}
		}

		$numberAllocationItems = 0;
		if (count($itineraries) > 0) {
			$rateType = empty($blockDetails['rt_rate_type_id']) ? $firstItineraryRateType : $blockDetails['rt_rate_type_id'];
			$rv_reservation_ix = db_rv_reservation_insert($rateType,false,$blockDetails['rv_agent_id'],$blockDetails['bl_block_commission_perc']);
			ammendReservation($rv_reservation_ix,"Allocation generated from block '".$blockDetails['bl_block_ix']."', block period '$bl_block_period_ix'");
			$rv_res_name = formatValue($blockDetails['bl_per_date_start_series_fst'], "date") . " to " . formatValue($blockDetails['bl_per_date_start_series_lst'], "date");
			$expiryDays = $blockDetails['bl_per_expiry_ind'] == DB_BL_PER_EXPIRY_LEAD_TIME_DAYS ? $blockDetails['bl_per_expiry_lead_time_days'] : null;
			$expiryDate = $blockDetails['bl_per_expiry_ind'] == DB_BL_PER_EXPIRY_LEAD_TIME_DATE ? $blockDetails['bl_per_expiry_lead_time_date'] : null;

			$GLOBALS['lDB']->put("
				UPDATE
					rv_reservation
				SET
					rv_res_name = '".$lDB->escape($rv_res_name)."',
					rv_agent_ref = '".$lDB->escape($blockDetails['rv_agent_ref'])."',
					rv_consultant_id = '".$lDB->escape($blockDetails['rv_consultant_id'])."',
					rv_corr_persona_id = '".$lDB->escape($blockDetails['rv_agent_contact_persona_id'])."',
					rt_rate_type_id = '".$lDB->escape($rateType)."',
					rv_reservation_type_ind = '5',
					rf_reservation_status_id = '15',
					rv_alloc_expiry_days = '".$lDB->escape($expiryDays)."',
					rv_alloc_expiry_date = '".$lDB->escape($expiryDate)."',
					rv_commission_perc = '".$lDB->escape($blockDetails['bl_block_commission_perc'])."',
					bl_block_period_id = '".$lDB->escape($bl_block_period_ix)."'
				WHERE
					rv_reservation_ix = '$rv_reservation_ix'
			");
			db_rv_note_insert($rv_reservation_ix,false,false,$blockDetails['bl_block_note'],false,$blockDetails['bl_block_note_internal']);

			// Iterate through occurrences between first and last date, create an itinerary for each
			// block itinerary for each date interval defined by the recurrence period
			$today = date("Y-m-d");
			$bl_series_id = null;
			$series_sequence = 0;
			foreach($itineraries as $itinerary) {
				$itemInfo = $itinerary['itemInfo'];
				$items = calCreateItem($rv_reservation_ix,$itemInfo,"",array(),"BLANK","0","0",false,false,false,$itinerary['bl_block_itinerary_ix']);
				$numberAllocationItems += 1;
				calCreateItemAudit($items, $rv_reservation_ix);
				$bl_series_id = (empty($bl_series_id)) ? $items[0] : $bl_series_id;
				if ($series_sequence != $itinerary['series_sequence']) {
					$bl_series_id = $items[0];
					$series_sequence = $itinerary['series_sequence'];
				}
				$GLOBALS['lDB']->put("
					UPDATE 
						rv_reservation_item
					SET
						bl_series_id = '$bl_series_id',
						bl_series_sequence_number = '". $itinerary['series_sequence'] ."',
						rv_alloc_expiry_date = '". $itinerary['itemExpiryDate'] . "'
					WHERE
						rv_reservation_item_ix IN ('" . implode("','", $items) . "')
				");
				$series_sequence += 1;
			}
		}
	}
	$numberExpiredAllocationItems = $numberExpiredAllocationItems / count($periodItineraries);
	$numberAllocationItems = $numberAllocationItems / count($periodItineraries);
	$periodDetails = array($rv_reservation_ix=>array("expired_items"=>$numberExpiredAllocationItems, "total_items"=>$numberAllocationItems));
	return array($message, $periodDetails);
}

/**
 * getItemExpiryDate() - get the appropriate expiry date for a block allocation item
 * @param string $firstBlockDateArrive
 *
 **/
function getItemExpiryDate($firstBlockDateArrive, $bl_per_expiry_ind, $bl_per_expiry_lead_time_days, $bl_per_expiry_lead_time_date) {
	$dateExpire = "";
	switch ($bl_per_expiry_ind) {
		case DB_BL_PER_EXPIRY_LEAD_TIME_DAYS:
			$days = $bl_per_expiry_lead_time_days;
			$dateExpire = date("Y-m-d", strtotime($firstBlockDateArrive . ' -' . $days . ' days'));
			break;
		case DB_BL_PER_EXPIRY_LEAD_TIME_DATE:
			$dateExpire = $bl_per_expiry_lead_time_date;
			break;
		default:
			break;
	}
	return $dateExpire;
}
