<?php

/**
 * init.form6003.php - Block booking period maintenance
 * Job: 6003
 * Function: 6001
 */

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
$job = $_SERVER['argv'][0];
$bl_block_period_ix = $_SERVER['argv'][1];
$record	= (isset($GLOBALS['record']) ? $GLOBALS['record'] : $bl_block_period_ix);

// Start Access Control Toolbar Setup
$jobs = array(
	"NEW" => 6009,
	"NEW_PERSIST" => 6010,
	"EDIT" => 6011,
	"EDIT_PERSIST" => 6012,
	"VIEW" => 6008,
	"DELETE" => 6013
);
$jobUrls = array(
	"NEW" => "reservation.php?" . $jobs['NEW'],
	"NEW_PERSIST" => "reservation.php?" . $jobs['NEW_PERSIST'],
	"EDIT" => "reservation.php?" . $jobs['EDIT'],
	"EDIT_PERSIST" => "reservation.php?" . $jobs['EDIT_PERSIST'],
	"VIEW" => "reservation.php?" . $jobs['VIEW'],
	"DELETE" => "reservation.php?" . $jobs['DELETE']
);

$GLOBALS['temp']['dglActionUrl'] = $jobUrls['NEW'];
$GLOBALS['temp']['dglActionPersistUrl'] = $jobUrls['NEW_PERSIST'];
$GLOBALS['temp']['dlgActionEditUrl'] = $jobUrls['EDIT'] . (!empty($record) ? "+".$record : "");
$GLOBALS['temp']['dlgActionEditPersistUrl'] = $jobUrls['EDIT_PERSIST'];
$GLOBALS['temp']['dlgActionDeleteUrl'] = $jobUrls['EDIT_PERSIST'];
$GLOBALS['temp']['validationMessage'] = "";

$pgJOBS = array();
$pgJOBS['view'] = "0";
$pgJOBS['add'] = "1";
$pgJOBS['edit'] = "0";
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
$pgJOBS['saveclose'] = "0";

if (checkJob($jobs['VIEW'])) {
	$pgJOBS['view'] = "1";
}

if (checkJob($jobs['EDIT']) && $action == "3") {
	$pgJOBS['edit'] = "1";
}

if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}

if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}

if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($jobs['DELETE'])) {
		$pgJOBS['del'] = "1";
	}
}
$GLOBALS['temp']['pgJobs'] = '
	<input type="hidden" id="pgJobNew" value="' . $pgJOBS['add'] . '" />
	<input type="hidden" id="pgJobEdit" value="' . $pgJOBS['edit'] . '" />
	<input type="hidden" id="pgJobDelete" value="' . $pgJOBS['del'] . '" />
	<input type="hidden" id="pgJobSave" value="' . $pgJOBS['save'] . '" />
	<input type="hidden" id="pgJobSaveclose" value="' . $pgJOBS['saveclose'] . '" />
	<input type="hidden" id="pgJobExit" value="1" />
	<input type="hidden" id="pgJobPrint" value="1" />
';

switch ($job) {
	case ($jobs['VIEW']):
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_period_dialog.htm");
		}
		$GLOBALS['block_booking_period_mode'] = "modeView";
		$blockBookingPeriodDetails = getBlockBookingPeriodDetails($record);
		setBlockBookingPeriodDetails($blockBookingPeriodDetails, $GLOBALS['temp']);
	  break;
	case ($jobs['NEW']):
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_period_dialog.htm");
		}
		$GLOBALS['block_booking_period_mode'] = "modeNew";
		$GLOBALS['temp']['bl_block_period_ix'] = "";
		$blockBookingPeriodDetails = getBlockBookingPeriodDetails($record);
		setBlockBookingPeriodDetails($blockBookingPeriodDetails, $GLOBALS['temp']);
		break;
	case ($jobs['NEW_PERSIST']):
		$result = "success";
		$params = array();
		if (validateBlockBookingPeriod($record)) {
			$params['bl_block_id'] = $_POST['bl_block_id'];
			$params['bl_per_date_start_series_fst'] = $_POST['bl_per_date_start_series_fst'];
			$params['bl_per_date_start_series_lst'] = $_POST['bl_per_date_start_series_lst'];
			$params['bl_per_recurrence_period'] = $_POST['bl_per_recurrence_period'];
			$params['bl_period_date_expiry'] = $_POST['bl_period_date_expiry'];
			$params['bl_per_lead_time_ind'] = $_POST['bl_per_lead_time_ind'];
			$params['bl_per_lead_time_amt'] = $_POST['bl_per_lead_time_amt'];
			$bl_block_period_ix = db_bl_block_period_insert(
			  $params['bl_block_name'],
			  $params['bl_per_date_start_series_fst'],
			  $params['bl_per_date_start_series_lst'],
			  $params['bl_per_recurrence_per_ind'],
			  $params['bl_period_date_expiry'],
			  $params['bl_per_lead_time_ind'],
			  $params['bl_per_lead_time_amt']);
		} else {
			$result = "fail";
		}
		echo json_encode(array("result"=>$result, "bl_block_period_ix"=>$bl_block_period_ix));
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"","");
			die();
		}
		break;
	case ($jobs['EDIT']):
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/block_booking_period_dialog.htm");
		}
		$GLOBALS['block_booking_period_mode'] = "modeEdit";
		$GLOBALS['temp']['bl_block_period_ix'] = $record;
		$blockBookingPeriodDetails = getBlockBookingPeriodDetails($record);
		setBlockBookingPeriodDetails($blockBookingPeriodDetails, $GLOBALS['temp']);
		break;
	case ($jobs['EDIT_PERSIST']):
		if ($pmode == 1) {
			if(!isset($GLOBALS[$form])) {
				$GLOBALS[$form] = new Form($form,"","");
			}
			$result = "success";
			$params = array();
			$message = array();
			$reload = false;
			$editAction = isset($_POST['editAction']) ? $_POST['editAction'] : "";
			$periodDetails = array();
			switch ($editAction) {
				case 'generateSeries':
					if (validateBlockBookingPeriod()) {
						set_time_limit(0);
						$periods = unserialize(stripslashes($_POST['generateSeriesPeriods']));
						$skipOverbookings = $_POST['skipOverbookings'];
						foreach ($periods as $period) {
							list($periodMessage, $allocationDetails) = generateSeries($period, $skipOverbookings);
							array_merge($message, $periodMessage);
							$periodDetails[$period] = $allocationDetails;
						}
						if (count($message) > 0) {
							$result = "fail";
						}
					}
					break;
				default:
					if (validateBlockBookingPeriod()) {
						$params['bl_block_period_ix'] = isset($_POST['bl_block_period_ix']) ? $_POST['bl_block_period_ix'] : "";
						$params['bl_per_date_start_series_fst'] = isset($_POST['bl_per_date_start_series_fst']) ? $_POST['bl_per_date_start_series_fst'] : "";
						$params['bl_per_date_start_series_lst'] = isset($_POST['bl_per_date_start_series_lst']) ? $_POST['bl_per_date_start_series_lst'] : "";
						$params['bl_per_recurrence_per_ind'] = isset($_POST['bl_per_recurrence_per_ind']) ? $_POST['bl_per_recurrence_per_ind'] : "";
						$params['bl_per_recurrence_per_1'] = isset($_POST['bl_per_recurrence_per_1']) ? $_POST['bl_per_recurrence_per_1'] : "";
						$params['bl_per_recurrence_per_2'] = isset($_POST['bl_per_recurrence_per_2']) ? $_POST['bl_per_recurrence_per_2'] : "";
						$params['bl_per_recurrence_per_3'] = isset($_POST['bl_per_recurrence_per_3']) ? $_POST['bl_per_recurrence_per_3'] : "";
						$params['bl_per_recurrence_per_4'] = isset($_POST['bl_per_recurrence_per_4']) ? $_POST['bl_per_recurrence_per_4'] : "";
						$params['bl_per_recurrence_per_5'] = isset($_POST['bl_per_recurrence_per_5']) ? $_POST['bl_per_recurrence_per_5'] : "";
						$params['bl_per_expiry_ind'] = isset($_POST['bl_per_expiry_ind']) ? $_POST['bl_per_expiry_ind'] : "";
						$params['bl_per_expiry_lead_time_days'] = isset($_POST['bl_per_expiry_lead_time_days']) ? $_POST['bl_per_expiry_lead_time_days'] : "";
						$params['bl_per_expiry_lead_time_date'] = isset($_POST['bl_per_expiry_lead_time_date']) ? $_POST['bl_per_expiry_lead_time_date'] : "";
						$params['adjustAllocationExpiry'] = isset($_POST['adjustAllocationExpiry']) ? $_POST['adjustAllocationExpiry'] : "";
						$periodDetails = updateBlockBookingPeriod($params);
					} else {
						$result = "fail";
					}
					break;
			}
			echo json_encode(array("result"=>$result, "message"=>$message, "reload"=>$reload, "periodDetails"=>$periodDetails)) . "\n";
		}
		break;
	case ($jobs['DELETE']):
		deleteBlockBookingPeriod($record);
		break;
	default: 
		break;
}

$GLOBALS['temp']['block_booking_period_mode'] = isset($GLOBALS['block_booking_period_mode']) ? $GLOBALS['block_booking_period_mode'] : "";
$GLOBALS['temp']['jobid'] = "";
$GLOBALS['temp']['record'] = $record;
