<?php

require_once(__DIR__ . "/class.template.php");
require_once(__DIR__ . "/class.report.php");

function getReservationList($rv_reservation_ix) {
	$reservationList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix as reservation_id,
			rv_reservation.rv_res_name,
			rv_reservation.rv_agent_id,
			rv_reservation.rf_reservation_status_id,
			pr_persona.pr_name_last,
			rf_reservation_status.rf_reservation_status_desc,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_provision_expiry_date,
			rv_reservation.rv_consultant_id,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation.rv_agent_ref
		FROM
			rv_reservation
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			rv_reservation.rf_reservation_status_id != '15'
			AND rv_reservation.rf_reservation_status_id != '97'
			AND rv_reservation.rv_reservation_ix IN ('" . implode("','", explode(",",$rv_reservation_ix)) . "')
	",0);

	return $reservationList;
}

function setReservationList($reservationList, &$target) {
  $resScrollSet = array();
	$imax = mysqli_num_rows($reservationList);
	$out = "";
	for ( $i = 0; $i < $imax; $i++ ) {
		$resultSet = mysqli_fetch_array($reservationList);
		$res['num']		= $resultSet[0];
    array_push($resScrollSet,$res['num']);
		$res['name']	= t_encodeHTMLField($resultSet[1]);

		if ( trim($resultSet['rv_agent_ref']) != "" ) {
			$res['rv_agent_ref'] = $resultSet['rv_agent_ref'];
		} else {
			$res['rv_agent_ref'] = "&nbsp;";
		}

		$agentId	= $resultSet[2];
		$statusId	= $resultSet[3];

		$res['agent'] = $GLOBALS['lDB']->get("
			SELECT 
                pr_persona.pr_name_last
			FROM
                pr_persona
			WHERE
                pr_persona.pr_persona_ix = '" . $agentId . "'
        ",4);

		if ( trim($res['agent']) == "" || $res['agent'] == "0" ) {
			$res['agent'] = "Direct booking";
		}

		$res['dateArrive'] = chng_date($resultSet['rv_date_arrive'],"-");
		$res['dateDepart'] = chng_date($resultSet['rv_date_depart'],"-");

		$res['status'] = $GLOBALS['lDB']->get("
			SELECT
                rf_reservation_status.rf_reservation_status_desc
			FROM
                rf_reservation_status
			WHERE
                rf_reservation_status.rf_reservation_status_id = '" . $statusId . "'
        ",4);

		$provdate		= $resultSet[5];
		$statusId		= $resultSet[4];
		$consultant	= $resultSet[6];

		$res['strong1']		= "";
		$res['strong2']	= "";

		if ( $res['status'] == "Cancelled" ) {
			$res['strong1']		= "<b>";
			$res['strong2']	= "</b>";
		} else {
			if ( $consultant == "0" ) {
				$res['status'] = str_replace("Quotation","Quote",$res['status']);
				$res['status'] = str_replace("Waitlist","Wait",$res['status']);
				$res['status'] = str_replace("Provisional","Prov",$res['status']);
				$res['status'] = str_replace("Confirmed","Confirm",$res['status']);
				$res['status'] = $res['status'] . " (Req)";
			}
		}

		if ( $statusId == "20" ) {
			$res['provClass'] = "";
			$today = date("Y-m-d");
			if ( $today == $provdate ) {
				$res['provClass'] = "colOrange";
			}
			if ( $today > $provdate ) {
				$res['provClass'] = "colRed";
			}
		} else {
			$res['provClass'] = "";
		}

		$res['job'] = "0";
		if ( canEditReservation($res['num']) ) {
			$res['job'] = "2";
		}

		$temphtml = Join("\n",File(__DIR__ . "/../../../public/html/reservation_find_row.htm"));
        $rv_agent_ref = trim($res['rv_agent_ref']);
        if (strlen($rv_agent_ref) > 11) {
            $res['rv_agent_ref'] = "<span class='tooltip nowrap' title='".$rv_agent_ref."'>".substr($rv_agent_ref, 0, 11)."...</span>";
        } else {
            $res['rv_agent_ref'] = "<span class='nowrap'>".$rv_agent_ref."</span>";
        }
        $rv_res_name = trim($res['name']);
        if (strlen($rv_res_name) > 20) {
            $res['name'] = "<span class='tooltip nowrap' title='".$rv_res_name."'>".substr($rv_res_name, 0, 20)."...</span>";
        } else {
            $res['name'] = "<span class='nowrap'>".$rv_res_name."</span>";
        }
		$out .= showpage($res,$temphtml);
	}
	$GLOBALS['temp']['reservations'] = $out;
	$GLOBALS['temp']['showReservationList'] = $imax > 0 ? "block" : "none";
	$GLOBALS['temp']['showNoReservationsMessage'] = $imax > 0 ? "none" : "block";
  setRecordScroll($resScrollSet);
}

