<?php

require_once(__DIR__ . "/class.template.php");

function getAllocationTimeline($rv_reservation_ix) {
	$allocationTimelineBlocks = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.bl_series_id,
			MIN(rv_reservation_item.rv_item_date_arrive) AS rv_item_date_arrive,
			MAX(rv_reservation_item.rv_item_date_depart) AS rv_item_date_depart,
			rv_reservation_item.rv_alloc_expiry_date
		FROM
			rv_reservation
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona property ON property.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation.rf_reservation_status_id = '15'
			AND rv_reservation.rv_reservation_ix = '" . $rv_reservation_ix . "'
			AND rv_reservation_item.rv_link_res_item_id IS NULL
			AND rv_reservation_item.bl_series_id IS NOT NULL
		GROUP BY
			rv_reservation_item.bl_series_id,
			rv_reservation_item.rv_alloc_expiry_date
	",6);
	$allocationTimelineData = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.bl_series_id,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_alloc_expiry_date,
			property.pr_name_last AS property_name,
			ac_accomm_type.ac_accomm_desc AS accommodation_name
		FROM
			rv_reservation
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona property ON property.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation.rf_reservation_status_id = '15'
			AND rv_reservation.rv_reservation_ix = '" . $rv_reservation_ix . "'
			AND rv_reservation_item.rv_link_res_item_id IS NULL
	",6);

	return array($allocationTimelineBlocks, $allocationTimelineData);
}

function setAllocationTimeline($allocationTimelineData, $allocationTimelineBlocks, &$template) {
	$timelineData = array();
	$timelineOptions = array();
	// Group itineraries that belong together with by bl_series_id
	foreach ($allocationTimelineBlocks as $allocationItem) {
		$item = array();
		$item["id"] = "series_" . $allocationItem["bl_series_id"];
		$item["content"] = "Block: " . $allocationItem["bl_series_id"] . "<br>";
		$item["start"] = $allocationItem["rv_item_date_arrive"];
		$item["end"] = $allocationItem["rv_item_date_depart"];
		$item["type"] = "background";
		$timelineData[] = $item;
	}

	$dateStart = "";
	$dateEnd = "";
	$firstItem = "";
	foreach ($allocationTimelineData as $allocationItem) {
		$firstItem = $firstItem == "" ? $allocationItem["rv_reservation_item_ix"] : $firstItem;
		$item = array();
		$item["id"] = $allocationItem["rv_reservation_item_ix"];
		$item["content"] = $allocationItem["property_name"] . " (" . $allocationItem["accommodation_name"] . ")";
		$item["start"] = $allocationItem["rv_item_date_arrive"];
		$item["end"] = $allocationItem["rv_item_date_depart"];
		if ($allocationItem["rv_alloc_expiry_date"] < date("Y-m-d")) {
			$item["className"] = "red";
			$item["title"] = "This item is expired";
		} else {
			$item["className"] = "";
		}
		$timelineData[] = $item;
		$dateStart = $dateStart == "" ? $allocationItem["rv_item_date_arrive"] : $dateStart;
		if ($dateStart > $allocationItem["rv_item_date_arrive"]) { 
			$dateStart = $allocationItem["rv_item_date_arrive"];
		}
		$dateEnd = $dateEnd == "" ? $allocationItem["rv_item_date_depart"] : $dateEnd;
		if ($dateEnd < $allocationItem["rv_item_date_depart"]) { 
			$dateEnd = $allocationItem["rv_item_date_depart"];
		}
	}
	$timelineOptions["min"] = $dateStart;
	$timelineOptions["max"] = $dateEnd;
	$timelineOptions["height"] = "300";
	$template['timelineData'] = str_replace("\\","", json_encode($timelineData));
	$template['timelineOptions'] = str_replace("\\","", json_encode($timelineOptions));
	$timelineWindowStart = $dateStart;
	$timelineWindowEnd = date("Y-m-d", strtotime($dateStart . ' + 10 days')) < $dateEnd ? date("Y-m-d", strtotime($dateStart . ' + 10 days')) : $dateEnd;
	$template['timelineWindowStart'] = str_replace("\\","", json_encode($timelineWindowStart));
	$template['timelineWindowEnd'] = str_replace("\\","", json_encode($timelineWindowEnd));
	$template['showAllocationTimeline'] = count($allocationTimelineData) > 0 ? "block" : "none";
	$template['showNoAllocationMessage'] = count($allocationTimelineData) > 0 ? "none" : "block";
}


