<?php

require_once(__DIR__ . "/db.sc_group.php");
require_once(__DIR__ . "/init.form6006.func.php");
require_once(__DIR__ . "/functions.reservation.php");
require_once(__DIR__ . "/class.template.php");

function validateReservation($itineraries) {
	global $lDB;

	$GLOBALS['temp']['validationMessage'] = "";
	return true;
}

function getReservationTemplateDetails($accommodationRates, $arrivalDepartureDates=null, $allocationItems=null) {
	$reservationTemplateDetails = $GLOBALS['lDB']->get("
		SELECT 1
	",1);

	$accommodationPeriods = array();
	if ($allocationItems != null) {
		$allocationDates = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_item_ix IN ('" . implode("','", $allocationItems) . "')
		", 6);
		foreach ($allocationDates as $allocationDate) {
			$accommodationPeriods[] = " 
				rt_period_dates.rt_period_from <= '" . $allocationDate['rv_item_date_arrive'] . "' 
				AND rt_period_dates.rt_period_to >= '" . $allocationDate['rv_item_date_depart'] . "'";
		}
	} else {
		foreach ($arrivalDepartureDates as $accommodation=>$arrivalDepartureDate) {
			$arrivalDate = explode(":", $arrivalDepartureDate)[0];
			$departureDate = explode(":", $arrivalDepartureDate)[1];
			$accommodationPeriods[] = " 
				rt_period_dates.rt_period_from <= '$arrivalDate' 
				AND rt_period_dates.rt_period_to >= '$arrivalDate' 
				AND rt_period_dates.rt_period_from <= '$departureDate'
				AND rt_period_dates.rt_period_to >= '$departureDate'";
		}
	}

	// Get rate groups for each itinerary and make list of rate groups that belong
	// to all itineraries and not only a subset
	$rateGroups = null;
	$accommodationRateGroups = array();
	$accommodations = array();
	$accommodationCounter = 0;
	foreach ($accommodationRates as $accommodationRate) {
		$accommodation = array_keys($accommodationRate)[0];
		$rateType = $accommodationRate[$accommodation];
		$accommodations[] = $accommodation;
		$periodSql = isset($accommodationPeriods[$accommodationCounter]) ? "AND " . $accommodationPeriods[$accommodationCounter] : "";
		$accommodationRateGroup = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				rt_rate_group.rt_rate_group_ix,
				rt_rate_group.rt_rate_group_desc,
				rt_rate_group.rt_rate_group_sys_code
			FROM
				rt_period_dates
				INNER JOIN rt_period ON rt_period.rt_period_ix = rt_period_dates.rt_period_id
				INNER JOIN rt_rate ON rt_rate.rt_period_id = rt_period.rt_period_ix
				INNER JOIN rt_rate_grp_amt ON rt_rate_grp_amt.rt_rate_id = rt_rate.rt_rate_ix
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_grp_amt.rt_rate_group_id
			WHERE
				rt_rate.rt_rate_type_id = '$rateType'
				AND rt_rate.ac_accomm_type_id = '$accommodation'
				AND rt_rate_group.rt_rate_group_sys_code != 1 
				$periodSql
		",6);
		if (count($accommodationRateGroup) == 0 || empty($accommodationRateGroup)) {
			$accommodationRateGroup = $GLOBALS['lDB']->get("
				SELECT DISTINCT
					rt_rate_group.rt_rate_group_ix,
					rt_rate_group.rt_rate_group_desc,
					rt_rate_group.rt_rate_group_sys_code
				FROM
					rt_period_dates
					INNER JOIN rt_period ON rt_period.rt_period_ix = rt_period_dates.rt_period_id
					INNER JOIN rt_rate ON rt_rate.rt_period_id = rt_period.rt_period_ix
					INNER JOIN rt_rate_grp_amt ON rt_rate_grp_amt.rt_rate_id = rt_rate.rt_rate_ix
					INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_grp_amt.rt_rate_group_id
				WHERE
					rt_rate_group.rt_rate_group_sys_code IN (2, 3) 
			",6);
		}
		$rateGroups = $rateGroups == null ? $accommodationRateGroup : $rateGroups;
		$diffArray = array_udiff($rateGroups, $accommodationRateGroup, 'udiffCompare');
		if (!empty($diffArray)) {
			foreach ($diffArray as $diffKey=>$diffValue) {
				foreach ($rateGroups as $key=>$rateGroup) {
					if ($rateGroup['rt_rate_group_desc'] == $diffValue['rt_rate_group_desc'] && in_array($rateGroup['rt_rate_group_sys_code'], array("2", "3")) == false) {
						unset($rateGroups[$key]);
					}
				}
			}
		}
		$accommodationRateGroups[] = $accommodationRateGroup;
		$accommodationCounter += 1;
	}
	$unitRateGroupId = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rt_rate_group.rt_rate_group_ix
		FROM
			rt_period_dates
			INNER JOIN rt_period ON rt_period.rt_period_ix = rt_period_dates.rt_period_id
			INNER JOIN rt_rate ON rt_rate.rt_period_id = rt_period.rt_period_ix
			INNER JOIN rt_rate_grp_amt ON rt_rate_grp_amt.rt_rate_id = rt_rate.rt_rate_ix
			INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_grp_amt.rt_rate_group_id
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 1 
	",4);

	$itineraryDetails = array();
	$accommodationCounter = 0;
	foreach ($accommodationRates as $accommodationRate) {
		$accommodation_id = array_keys($accommodationRate)[0];
		$accommodation = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_type.ac_accomm_type_ix,
				pr_persona.pr_name_last AS property_description,
				ac_accomm_type.ac_accomm_desc,
				ac_accomm_type.ac_accomm_capacity
			FROM
				sc_accomm
				INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '$GLOBALS[userid]'
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
				INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				ac_accomm_type.ac_accomm_type_inactive_yn = 0
				AND ac_accomm_type.ac_accomm_type_ix = '" . $accommodation_id . "'
			ORDER BY
				pr_name_last, ac_accomm_type.ac_accomm_desc
		",1);
		$itineraryDetails[] = array(
			'ac_accomm_type_id'=>$accommodation['ac_accomm_type_ix'],
			'property_description'=>$accommodation['property_description'],
			'ac_accomm_desc'=>$accommodation['ac_accomm_desc'],
			'ac_accomm_capacity'=>$accommodation['ac_accomm_capacity'],
			'rate_groups'=>$accommodationRateGroups[$accommodationCounter]
		);
		$accommodationCounter += 1;
	}

	return array($reservationTemplateDetails, $rateGroups, $unitRateGroupId, $itineraryDetails);
}

function setReservationTemplateDetails($reservationTemplateDetails, $rateGroups, $unitRateGroupId, $itineraryDetails, &$target) {
	$allowAllocOverride = db_sc_group_get_user_setting("sc_grp_res_ovr_alloc_yn") == "1";

	$fields = array(
		"bl_block_period_ix"
	);
	foreach ($fields as $field) {
		$target[$field] = isset($blockPeriodDetails[$field]) ? $blockPeriodDetails[$field] : "";
	}
	$target['unitRateGroupId'] = $unitRateGroupId;
	$colSpanTotal = 3;
	$rateGroupLabels = array();
	$rateGroupInputs = array();
	$rateGroupCounter = 1;
	foreach ($rateGroups as $rateGroup) {
		if ($rateGroupCounter == count($rateGroups)) {
			$rateGroupInputsClass = "bl bb br";
		} else {
			$rateGroupInputsClass = "bl bb";
		}
		$rateGroupLabels[] = "<th class='outLt' id='thRateGroup_" . $rateGroup['rt_rate_group_ix'] . "' style='white-space: nowrap;'><label>" . $rateGroup['rt_rate_group_desc'] . "</label></th>";
		$rateGroupInputs[] = "<td class='" . $rateGroupInputsClass . "' style=\"padding: 3px; text-align:center;\"><input type='text' id='txtRateGroup_" . $rateGroup['rt_rate_group_ix'] ."' rt_rate_group_ix='" . $rateGroup['rt_rate_group_ix'] . "' rt_rate_group_sys_code='" . $rateGroup['rt_rate_group_sys_code'] . "' name='txtRateGroup' value='' class='txtsmall validate_integer_optional constraint_integer'></td>";
		$rateGroupCounter += 1;
	}
	$tblRateGroups = "<table id='tblRateGroups' width='100%' class='table'><thead>";
	$tblRateGroups .= "<tr heading_row='true'>" . implode("", $rateGroupLabels) . "</tr>";
	$tblRateGroups .= "</thead><tbody>";
	$tblRateGroups .= "<tr>" . implode("", $rateGroupInputs) . "</tr>";
	$tblRateGroups .= "</tr></tbody></table>";
	if($allowAllocOverride) {
		$GLOBALS['temp']['tblExpiredDates'] = "&nbsp;&nbsp;Include expired dates <input id=\"chkIncludeExpired\" type=\"checkbox\">";
	} else {
		$GLOBALS['temp']['tblExpiredDates'] = "";
	}
	$GLOBALS['temp']['tblRateGroups'] = $tblRateGroups;
	$GLOBALS['temp']['itineraryDetails'] = json_encode($itineraryDetails);
}

/**
 * udiffCompare() - Recursively called to check if multidimensional array values are equal
 */
function udiffCompare($a, $b) {
	$diff = $a['rt_rate_group_desc'] == $b['rt_rate_group_desc'] ? 0 : -1;
    return $diff;
}
