<?php

/**
 * init.form6006.php - Reservation create from template dialog
 * Job: 6016
 * Function: 6004
 */

if (isset($_POST) && isset($_POST['action']) && $_POST['action'] == "fetchBlockAllocations") {
	// When creating a reservation from a Block Template, do an additional lookup to determine the
	// actual allocations used (where the block allocation has been edited and differs from the template)
	$blSeriesId = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.bl_series_id
		FROM
			rv_reservation
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			rv_reservation.bl_block_period_id = '" . $_POST['bl_block_period_ix'] . "'
			AND rv_reservation.rf_reservation_status_id = 15
			AND rv_reservation_item.rv_item_date_arrive = '" . $_POST['arrival'] . "'
	", 4);

	$blockPeriodItinerariesAsAllocated = $GLOBALS['lDB']->get("
		SELECT
			DISTINCT(rv_reservation_item.rv_reservation_item_ix),
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.rt_rate_type_id,
			ac_accomm_type.ac_accomm_desc,
			pr_persona.pr_name_last as property_description,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_accomm_count
		FROM
			rv_reservation_item
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona ON pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation_item.bl_series_id = '" . $blSeriesId . "'
			AND bl_series_sequence_number IS NOT NULL
		ORDER BY
			rv_reservation_item.bl_series_sequence_number
	", 6);

	echo json_encode($blockPeriodItinerariesAsAllocated);
	die;
}


$_SERVER['argv'] = array_pad($_SERVER['argv'],1,"");
$job = (isset($_SERVER['argv'][0]) ? $_SERVER['argv'][0] : "");
$accommodationPairs = (isset($_POST['accommodationRates']) ? $_POST['accommodationRates'] : "");
$allocationItems = (isset($_POST['allocations']) ? $_POST['allocations'] : "");
$arrivalDepartureDates = (isset($_POST['arrivalDepartureDates']) ? $_POST['arrivalDepartureDates'] : "");
$bl_block_period_ix = (isset($_POST['bl_block_period_ix']) ? $_POST['bl_block_period_ix'] : "");
$record	= (isset($GLOBALS['record']) ? $GLOBALS['record'] : "");

$allocationItems = array_unique(explode(",", $allocationItems));
$arrivalDepartureDates = array_unique(explode(",", $arrivalDepartureDates));
$accommodationPairs = explode(",", $accommodationPairs);
$accommodationRates = array();
if (!empty($accommodationPairs)) {
	foreach ($accommodationPairs as $accommodationPair) {
		if (!empty($accommodationPair)) {
			$pairArray = explode(":", $accommodationPair);
			$accommodationRates[] = array($pairArray[0]=>$pairArray[1]);
		}
	}
}

// Start Access Control Toolbar Setup
$jobs = array(
	"NEW" => 6016,
	"NEW_PERSIST" => 6017
);
$jobUrls = array(
	"NEW" => "reservation.php?" . $jobs['NEW'],
	"NEW_PERSIST" => "reservation.php?" . $jobs['NEW_PERSIST']
);

$GLOBALS['temp']['dglActionNewUrl'] = $jobUrls['NEW'];
$GLOBALS['temp']['dglActionNewPersistUrl'] = $jobUrls['NEW_PERSIST'];
$GLOBALS['temp']['validationMessage'] = "";

$pgJOBS = array();
$pgJOBS['view'] = "0";
$pgJOBS['add'] = "1";
$pgJOBS['edit'] = "0";
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
$pgJOBS['saveclose'] = "0";

$GLOBALS['temp']['pgJobs'] = '
	<input type="hidden" id="pgJobNew" value="' . $pgJOBS['add'] . '" />
	<input type="hidden" id="pgJobEdit" value="' . $pgJOBS['edit'] . '" />
	<input type="hidden" id="pgJobDelete" value="' . $pgJOBS['del'] . '" />
	<input type="hidden" id="pgJobSave" value="' . $pgJOBS['save'] . '" />
	<input type="hidden" id="pgJobSaveclose" value="' . $pgJOBS['saveclose'] . '" />
	<input type="hidden" id="pgJobExit" value="1" />
	<input type="hidden" id="pgJobPrint" value="1" />
';

switch ($job) {
	case ($jobs['NEW']):
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_from_template_dialog.htm");
		}
		$GLOBALS['dlg_reservation_from_template_mode'] = "modeNew";
		$GLOBALS['temp']['bl_block_period_ix'] = "";
		list($reservationTemplateDetails, $rateGroups, $unitRateGroupId, $accommodationDetails) = getReservationTemplateDetails($accommodationRates, $arrivalDepartureDates, $allocationItems);
		setReservationTemplateDetails($reservationTemplateDetails, $rateGroups, $unitRateGroupId, $accommodationDetails, $GLOBALS['temp']);
		break;
	case ($jobs['NEW_PERSIST']):
		$result = "success";
		$rv_reservation_ix = false;
		if (validateReservation($_POST['itineraries'])) {
			$itineraries = unserialize(stripslashes($_POST['itineraries']));
			$rt_rate_type_id = $_POST['rt_rate_type_id'];
			$rv_agent_id = $_POST['rv_agent_id'];
			$rv_corr_persona_id = $_POST['rv_corr_persona_id']; 
			$rv_item_split_yn = $_POST['rv_item_split_yn'];
			$itineraries = $_POST['itineraries'];

			$components = "defaultOnly";

			$canCreateReservation = true;
			if (empty($rt_rate_type_id)) { $canCreateReservation = false; }
			if (empty($rv_agent_id)) { $canCreateReservation = false; }
			if (empty($rv_corr_persona_id)) { $canCreateReservation = false; }
			if (empty($itineraries)) { $canCreateReservation = false; }

			if ($canCreateReservation) {
				$rv_reservation_ix = createReservationInProgress(
					$rt_rate_type_id,
					$rv_agent_id,
					$rv_corr_persona_id,
					$rv_item_split_yn,
					$components,
					unserialize(stripslashes($itineraries)),
					$bl_block_period_ix
				);
			}
			if (!$rv_reservation_ix) {
				$result = "fail";
			}
		} else {
			$result = "fail";
		}
		echo json_encode(array("result"=>$result, "rv_reservation_ix"=>$rv_reservation_ix));
		if(!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"","");
			die();
		}
		break;
	default: 
		break;
}

$GLOBALS['temp']['dlg_reservation_from_template_mode'] = isset($GLOBALS['dlg_reservation_from_template_mode']) ? $GLOBALS['dlg_reservation_from_template_mode'] : "";
$GLOBALS['temp']['jobid'] = $job;
$GLOBALS['temp']['record'] = $record;
