<?php

/**
 * init.form6008.php - Clear timed out reservations from cache on daily base. This should normally be run by ResCron
 * Job: 6019
 * Function: 66 (General access)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}
$GLOBALS[$form]->FormHTML = " ";

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
$log = $_SERVER['argv'][1] == 1 ? true : false;
$totalCleared = 0;
$today = date("Y-m-d");
$maxStockdate = $lDB->get("
	SELECT
		rf_date_res_limit
	FROM
		rf_default
",4);

$accomms = $lDB->get("
	SELECT
		ac_accomm_type_ix,
		ac_accomm_desc
	FROM
		ac_accomm_type
	WHERE
		ac_accomm_type_inactive_yn = 0
	ORDER BY
		ac_accomm_sequence
",2);

if(!Stock::EmptyCache()) {
	output("Error clearing stock cache","30");
	die();
}

foreach ($accomms as $accomm) {
	$stock = new Stock($accomm['ac_accomm_type_ix'],$today,$maxStockdate);
	$avail =  $stock->ToAvailability();
	$stock->NotifyCache();
	$totalCleared++;
}
output("Clearing accommodation stock cache daily Done. Cleared ".$totalCleared." accommodations","0",$log);
