<?php

/**
 * init.form6030.func.php - User Access Audit Report
 * Job: 6030
 * Function: 6030 (User Access Audit)
 */

require_once(__DIR__ . '/functions.report.php');

function getHeaders($data) {
	$join = "";
	$where = "";
	$orderby = "";

	if (!empty($data['userGroupIds'])) {
		$where .= "AND sc_group.sc_group_id IN ('" . join("','", explode(':', $data['userGroupIds'])) . "')";
	}
	if (!empty($data['useraccessAuditUserIds'])) {
		$where .= "AND ad_useraccess.pr_user_id IN ('" . join("','", explode(':', $data['useraccessAuditUserIds'])) . "')";
	}
	if (!empty($data['userAccessFunctionIds'])) {
		$userAccessFunctionNames = explode(',', urldecode($data['userAccessFunctionNames']));
		foreach ($userAccessFunctionNames as $key => $name) {
			$userAccessFunctionNames[$key] = trim($name);
		}
		$where .= "AND ad_useraccess.ad_useraccess_form IN ('" . join("','", $userAccessFunctionNames) . "')";
	}
	if (!empty($data['userAccessTypeIds'])) {
		$join .= "LEFT JOIN ad_useraccess_detail ON ad_useraccess_detail.ad_useraccess_id = ad_useraccess.ad_useraccess_ix";
		$where .= "AND ad_useraccess_detail.ad_module_field_id IN ('" . join("','", explode(':', $data['userAccessTypeIds'])) . "')";
	}
	$where .= "AND DATE(ad_useraccess.ad_useraccess_time) <= '" . $data['dateTo'] . "' AND DATE(ad_useraccess.ad_useraccess_time) >= '" . $data['dateFrom'] . "'";

	switch ($data['sortBy']) {
	case 0:
		$orderby = "ad_useraccess.ad_useraccess_time ASC";
		break;
	case 1:
		$orderby = "ad_useraccess.ad_useraccess_time DESC";
		break;
	case 2:
		$orderby = "pr_name ASC";
		break;
	case 3:
		$orderby = "pr_name DESC";
		break;
	case 4:
		$orderby = "useraccess_action ASC";
		break;
	case 5:
		$orderby = "useraccess_action DESC";
		break;
	case 6:
		$orderby = "usergroup ASC";
		break;
	case 7:
		$orderby = "usergroup DESC";
		break;
	case 8:
		$orderby = "useraccess_database ASC";
		break;
	case 9:
		$orderby = "useraccess_database DESC";
		break;
	}

	$auditHeaders = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ad_useraccess.ad_useraccess_ix AS useraccess_id,
			DATE(ad_useraccess.ad_useraccess_time) AS useraccess_date,
			TIME(ad_useraccess.ad_useraccess_time) AS useraccess_time,
			ad_useraccess.ad_useraccess_form AS useraccess_action,
			rf_database.rf_db_code AS useraccess_database,
			IFNULL(sc_group.sc_grp_desc, 'Unknown') AS usergroup,
			TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS pr_name
		FROM
			ad_useraccess
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ad_useraccess.pr_user_id
			LEFT JOIN rf_database ON rf_database.rf_database_id = ad_useraccess.rf_database_id
			LEFT JOIN sc_group ON sc_group.sc_group_id = ad_useraccess.sc_group_id
			" . $join . "
		WHERE
			ad_useraccess.ad_useraccess_form NOT LIKE '%reminder%'
			$where
		ORDER BY
			$orderby
	",2);


	foreach ($auditHeaders as $key => $auditHeader) {
		if ($auditHeader['usergroup'] == "Unknown") {
			$desc = $GLOBALS['lDB']->get("
				SELECT
					ad_useraccess_detail.ad_useraccess_detail_value_from_display AS value_from_display,
					ad_useraccess_detail.ad_useraccess_detail_value_to_display AS value_to_display
				FROM
					ad_useraccess_detail
				WHERE
					ad_useraccess_detail.ad_useraccess_id = '" . $auditHeader['useraccess_id'] . "'
					AND ad_useraccess_detail.ad_module_field_id = 59
			",1);
			if (!empty($desc['value_to_display'])) {
				$auditHeaders[$key]['usergroup'] = $desc['value_to_display'];
			}
			if (!empty($desc['value_from_display'])) {
				$auditHeaders[$key]['usergroup'] = $desc['value_from_display'];
			}
		}
	}

	return $auditHeaders;
}

function getCSV($data) {
	$auditHeaders = getHeaders($data);
	$csv = array();
	array_push($csv, array('"User Access Audit Report"'));
	array_push($csv, array());
	array_push($csv, array('"Date range:"', '"' . $data['dateFrom'] . ' to ' . $data['dateTo'] . '"'));
	array_push($csv, array('"Group Filter:"', '"' . $data['userGroupNames'] . '"'));
	array_push($csv, array('"User Filter:"', '"' . $data['useraccessAuditUserNames'] . '"'));
	array_push($csv, array('"Function Filter:"', '"' . $data['userAccessFunctionNames'] . '"'));
	array_push($csv, array('"Type Filter:"', '"' . $data['userAccessTypeNames'] . '"'));
	
	array_push($csv, array());
	array_push($csv, array('"Date"', '"Time"', '"User"', '"Function"', '"Group"', '"Env"'));
	if(!empty($auditHeaders)) {
		foreach($auditHeaders as $auditHeader) {
			array_push(
				$csv,
				array(
					'"' . $auditHeader['useraccess_date'] . '"',
					'"' . $auditHeader['useraccess_time'] . '"',
					'"' . $auditHeader['pr_name'] . '"',
					'"' . $auditHeader['useraccess_action'] . '"',
					'"' . $auditHeader['usergroup'] . '"',
					'"' . $auditHeader['useraccess_database'] . '"',
				)
			);
		}
	} else {
		array_push($csv, array('"No records Found"'));
	}
	return $csv;
}

function getDetail($data) {
	$auditDetail = $GLOBALS['lDB']->get("
		SELECT
			ad_useraccess_detail.ad_useraccess_detail_value_from AS value_from,
			ad_useraccess_detail.ad_useraccess_detail_value_to AS value_to,
			ad_useraccess_detail.ad_useraccess_detail_value_from_display AS value_from_display,
			ad_useraccess_detail.ad_useraccess_detail_value_to_display AS value_to_display,
			ad_useraccess_detail.ad_useraccess_detail_action_ind AS action,
			IFNULL(ad_module_field.ad_module_field_description, 'Unknown') as module_desc
		FROM
			ad_useraccess_detail
			LEFT JOIN ad_module_field ON ad_module_field.ad_module_field_id = ad_useraccess_detail.ad_module_field_id
		WHERE
			ad_useraccess_detail.ad_useraccess_id = '" . $data['detailId'] . "'
	",2);

	$auditHeader = $GLOBALS['lDB']->get("
		SELECT
			ad_useraccess.ad_useraccess_ix AS useraccess_id,
			DATE(ad_useraccess.ad_useraccess_time) AS useraccess_date,
			TIME(ad_useraccess.ad_useraccess_time) AS useraccess_time,
			ad_useraccess.ad_useraccess_form AS useraccess_action,
			rf_database.rf_db_code AS useraccess_database,
			IFNULL(sc_group.sc_grp_desc, 'Unknown') AS usergroup,
			TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS pr_name
		FROM
			ad_useraccess
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ad_useraccess.pr_user_id
			LEFT JOIN rf_database ON rf_database.rf_database_id = ad_useraccess.rf_database_id
			LEFT JOIN sc_group ON sc_group.sc_group_id = ad_useraccess.sc_group_id
		WHERE
			ad_useraccess.ad_useraccess_ix = '" . $data['detailId'] . "'
	",1);

	if ($auditHeader['usergroup'] == "Unknown") {
		$desc = $GLOBALS['lDB']->get("
			SELECT
				ad_useraccess_detail.ad_useraccess_detail_value_from_display AS value_from_display,
				ad_useraccess_detail.ad_useraccess_detail_value_to_display AS value_to_display
			FROM
				ad_useraccess_detail
			WHERE
				ad_useraccess_detail.ad_useraccess_id = '" . $data['detailId'] . "'
				AND ad_useraccess_detail.ad_module_field_id = 59
		",1);
		if (!empty($desc['value_to_display'])) {
			$auditHeader['usergroup'] = $desc['value_to_display'];
		}
		if (!empty($desc['value_from_display'])) {
			$auditHeader['usergroup'] = $desc['value_from_display'];
		}
	}

	$audit = array(
		"header" => $auditHeader,
		"detail" => $auditDetail
	);

	return $audit;
}