<?php

/**
 * init.form6040.func.php - Misc Audit Report
 * Job: 6040
 * Function: 6040 (Misc Audit)
 */

require_once(__DIR__ . '/functions.report.php');

function getHeaders($data) {
	$join = "";
	$where = "";
	$orderby = "";

	if (!empty($data['miscAuditUserIds'])) {
		$where .= "AND ad_misc.pr_user_id IN ('" . join("','", explode(':', $data['miscAuditUserIds'])) . "')";
	}
	if (!empty($data['miscFunctionIds'])) {
		$miscFunctionNames = explode(',', urldecode($data['miscFunctionNames']));
		foreach ($miscFunctionNames as $key => $name) {
			$miscFunctionNames[$key] = trim($name);
		}
		$where .= "AND ad_misc.ad_misc_form IN ('" . join("','", $miscFunctionNames) . "')";
	}
	if (!empty($data['miscTypeIds'])) {
		$data['miscTypeIds'] = str_replace("%20", " ", $data['miscTypeIds']);
		$join .= "LEFT JOIN ad_misc_detail ON ad_misc_detail.ad_misc_id = ad_misc.ad_misc_ix";
		$where .= "AND REPLACE(ad_misc_detail.ad_misc_detail_field_name, ' ', '') IN ('" . join("','", explode(':', $data['miscTypeIds'])) . "')";
	}
	$where .= "AND DATE(ad_misc.ad_misc_time) <= '" . $data['dateTo'] . "' AND DATE(ad_misc.ad_misc_time) >= '" . $data['dateFrom'] . "'";

	switch ($data['sortBy']) {
	case 0:
		$orderby = "ad_misc.ad_misc_time ASC";
		break;
	case 1:
		$orderby = "ad_misc.ad_misc_time DESC";
		break;
	case 2:
		$orderby = "pr_name ASC";
		break;
	case 3:
		$orderby = "pr_name DESC";
		break;
	case 4:
		$orderby = "misc_action ASC";
		break;
	case 5:
		$orderby = "misc_action DESC";
		break;
	case 8:
		$orderby = "misc_database ASC";
		break;
	case 9:
		$orderby = "misc_database DESC";
		break;
	}

	$auditHeaders = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ad_misc.ad_misc_ix AS misc_id,
			DATE(ad_misc.ad_misc_time) AS misc_date,
			DATE_FORMAT(ad_misc.ad_misc_time, '%d %b %Y') AS misc_date_formatted,
			TIME(ad_misc.ad_misc_time) AS misc_time,
			ad_misc.ad_misc_form AS misc_action,
			ad_misc.ad_misc_db AS misc_database,
			TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS pr_name
		FROM
			ad_misc
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ad_misc.pr_user_id
			" . $join . "
		WHERE
			ad_misc.ad_misc_form NOT LIKE '%reminder%'
			$where
		ORDER BY
			$orderby
	",2);

	return $auditHeaders;
}

function getCSV($data) {
	$auditHeaders = getHeaders($data);
	$csv = array();
	array_push($csv, array('"Misc Audit Report"'));
	array_push($csv, array());
	array_push($csv, array('"Date range:"', '"' . $data['dateFrom'] . ' to ' . $data['dateTo'] . '"'));
	array_push($csv, array('"User Filter:"', '"' . $data['miscAuditUserNames'] . '"'));
	array_push($csv, array('"Function Filter:"', '"' . $data['miscFunctionNames'] . '"'));
	array_push($csv, array('"Type Filter:"', '"' . $data['miscTypeNames'] . '"'));
	
	array_push($csv, array());
	array_push($csv, array('"Date"', '"Time"', '"User"', '"Function"', '"Env"'));
	if(!empty($auditHeaders)) {
		foreach($auditHeaders as $auditHeader) {
			array_push(
				$csv,
				array(
					'"' . $auditHeader['misc_date'] . '"',
					'"' . $auditHeader['misc_time'] . '"',
					'"' . $auditHeader['pr_name'] . '"',
					'"' . $auditHeader['misc_action'] . '"',
					'"' . $auditHeader['misc_database'] . '"',
				)
			);
		}
	} else {
		array_push($csv, array('"No records Found"'));
	}
	return $csv;
}

function getDetail($data) {
	$auditDetail = $GLOBALS['lDB']->get("
		SELECT
			ad_misc_detail_value_from AS value_from,
			ad_misc_detail_value_to AS value_to,
			ad_misc_detail_action_ind AS action,
			ad_misc_detail_field_name as module_desc
		FROM
			ad_misc_detail
		WHERE
			ad_misc_id = '" . $data['detailId'] . "'
	",2);

	$auditHeader = $GLOBALS['lDB']->get("
		SELECT
			ad_misc.ad_misc_ix AS misc_id,
			DATE(ad_misc.ad_misc_time) AS misc_date,
			DATE_FORMAT(ad_misc.ad_misc_time, '%d %b %Y') AS misc_date_formatted,
			TIME(ad_misc.ad_misc_time) AS misc_time,
			ad_misc.ad_misc_form AS misc_action,
			ad_misc.ad_misc_db AS misc_database,
			TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS pr_name
		FROM
			ad_misc
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ad_misc.pr_user_id
		WHERE
			ad_misc.ad_misc_ix = '" . $data['detailId'] . "'
	",1);

	$audit = array(
		"header" => $auditHeader,
		"detail" => $auditDetail
	);

	return $audit;
}