<?php

/**
* init.form6050.php - Fiscalisation
* Job: 6050
* Function: 100 (Financial: GL Account detail - Invoicing Unit List)
*/

if (
	isset($_POST) &&
	isset($_POST['method']) &&
	$_POST['method'] == "ajax" &&
	isset($_POST['action']) &&
	!empty($_POST['action'])
) {
	$function = $_POST['action'];
	echo $function();
	die;
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_fiscalisation.htm");
}

$GLOBALS['temp']['fiscalatorUrl'] = fiscalatorUrl();

function fiscalatorUrl() {
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator();
	return $fiscalator->fiscalatorUrl;
}

function fetchInvoicingUnits() {
	$invoicingUnits = $GLOBALS['lDB']->get(
		"
			SELECT
				pr_business.pr_business_id,
				pr_business.pr_bus_inv_prefix,
				pr_business.pr_bus_billing_yn,
				pr_business.pr_bus_billing_prop_yn,
				pr_business.fiscalator_key,
				TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as invoice_unit_name
			FROM
				pr_business
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
			WHERE
				(
					pr_business.pr_bus_billing_yn = 1
					OR pr_business.pr_bus_billing_prop_yn = 1
				)
				AND pr_business.pr_bus_inactive_yn = 0
			ORDER BY
				pr_business.pr_business_sequence
		",
		6
	);
	return json_encode($invoicingUnits);
}

function addTenantKey() {
	if (
		!isset($_POST['pr_business_id']) || empty($_POST['pr_business_id']) ||
		!isset($_POST['key']) || empty($_POST['key'])
	) {
		return "Error with creating Key";
	}
	$insertResult = $GLOBALS['lDB']->put(
		"
			UPDATE
				pr_business
			SET
				fiscalator_key = '" . $GLOBALS['lDB']->escape($_POST['key']) . "'
			WHERE
				pr_business.pr_business_id = '" . $GLOBALS['lDB']->escape($_POST['pr_business_id']) . "'
		"
	);
	if ($insertResult == 1) {
		return "Key created successfully";
	} else {
		return "Error with adding Key";
	}
}

function fetchMappingItems() {
	$mappingItems = array();
	$mappingItems['currency'] = $GLOBALS['lDB']->get(
		"
			SELECT
				rf_currency_ix as code,
				rf_currency_name as name
			FROM
				rf_currency
			WHERE 
				rf_currency_inactive_yn = '0'
			ORDER BY
				rf_currency_name
		",
		6
	);
	$mappingItems['country'] = $GLOBALS['lDB']->get(
		"
			SELECT
				rf_country_ix as code,
				rf_country_name as name
			FROM
				rf_country
			WHERE 
				rf_country_inactive = '0'
			ORDER BY
				rf_country_name
		",
		6
	);
	$extras = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('EX_', ac_extra_ix) as code,
				CONCAT('Extra: ', ac_ext_desc) as name
			FROM
				ac_extra
			WHERE
				ac_inactive_yn = '0'
			ORDER BY
				ac_ext_desc
		",
		6
	);
	$extraCategories = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('EC_', ac_extra_category_ix) as code,
				CONCAT('Extra Category: ', ac_extra_cat_desc) as name
			FROM
				ac_extra_category
			WHERE
				ac_extra_category_inactive_yn = '0'
			ORDER BY
				ac_extra_cat_desc
		",
		6
	);
	$components = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('CM_', rt_component_ix) as code,
				CONCAT('Component: ', rt_component_desc) as name
			FROM
				rt_component
			WHERE 
				rt_component_inactive_yn = '0'
			ORDER BY
				rt_component_desc
		",
		6
	);
	$mappingItems['commodity'] = array_merge($extras, $extraCategories, $components);

	$mappingItems['taxcommodity'] = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('EC_', ac_extra_category_ix) as code,
				ac_extra_cat_desc as name
			FROM
				ac_extra_category
			WHERE 
				ac_extra_category_inactive_yn = '0'
			ORDER BY
				ac_extra_cat_desc
		",
		6
	);
	$mappingItems['taxrate'] = $GLOBALS['lDB']->get(
		"
			SELECT
				rf_tax_rate_ix as code,
				rf_tax_rate_desc as name
			FROM
				rf_tax_rate
			WHERE
				rf_tax_rate_inactive_yn = '0'
			ORDER BY
				rf_tax_rate_desc
		",
		6
	);
	return $mappingItems;
}

function fiscalise() {
	if (!isset($_POST['fn_invoice_id']) || empty($_POST['fn_invoice_id'])) {
		return "Error with invoice ID";
	}

	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	return json_encode($fiscalator->uploadInvoice(array($_POST['fn_invoice_id'])));
}

function getProductDetails($product_id, $product_name) {
	if (
		!isset($_POST['product_id']) || empty($_POST['product_id']) ||
		!isset($_POST['product_name']) || empty($_POST['product_name'])
	) {
		return "Error with product ID";
	}

	if (substr($_POST['product_name'], 0, 5) == "Extra") {
		$product = $GLOBALS['lDB']->get(
			"
				SELECT
					ac_extra.ac_ext_desc as name,
					rf_currency.rf_currency_symbol as currency
				FROM
					ac_extra
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
				WHERE
					ac_extra.ac_extra_ix = '" . $_POST['product_id'] . "'
			",
			6
		);
	} else {
		$product = $GLOBALS['lDB']->get(
			"
				SELECT
					rt_component_desc as name,
					'UGX' as currency
				FROM
					rt_component
				WHERE
					rt_component.rt_component_ix = '" . $_POST['product_id'] . "'
			",
			6
		);
	}
	return json_encode($product);
}

function saveAccountContactStatutoryKey() {
	if (
		!isset($_POST['pr_business_id']) || empty($_POST['pr_business_id']) ||
		!isset($_POST['contact_tin_statutory_key']) || empty($_POST['contact_tin_statutory_key'])
	) {
		return "Error with statutory key";
	}

	$insertResult = $GLOBALS['lDB']->put(
		"
			UPDATE
				pr_business
			SET
				contact_tin_statutory_key = '" . $GLOBALS['lDB']->escape($_POST['contact_tin_statutory_key']) . "'
			WHERE
				pr_business.pr_business_id = '" . $GLOBALS['lDB']->escape($_POST['pr_business_id']) . "'
		"
	);
	if ($insertResult == 1) {
		return "Key updated successfully";
	} else {
		return "Error with updating Key";
	}
}

function getAccountContactStatutoryKey() {
	if (!isset($_POST['pr_business_id']) || empty($_POST['pr_business_id'])) {
		return "Error with statutory key";
	}
	return $GLOBALS['lDB']->get(
		"
			SELECT
				contact_tin_statutory_key
			FROM
				pr_business
			WHERE
				pr_business.pr_business_id = '" . $GLOBALS['lDB']->escape($_POST['pr_business_id']) . "'
		",
		4
	);
}

function getFiscalInfoByInvoice() {
	if (!isset($_POST['invoiceId']) || empty($_POST['invoiceId'])) {
		return "No invoice ID specified";
	}
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$return = array();
	$status = $fiscalator->getInvoiceStatus($_POST['invoiceId']);
	$data = $fiscalator->getFiscalData($_POST['invoiceId']);

	$statuses = array(
		0 => "Not submitted",
		1 => "Pending processing",
		2 => "Verified",
		3 => "Rejected",
		4 => "Error",
		5 => "Credit note upload pending",
		6 => "Credit note approval pending",
		7 => "Credit note approved",
		8 => "Credit note error",
		9 => "Zero total not fiscalised"
	);

	$return["status"] = $statuses[$status];
	$return["statusCode"] = $status;

	if ($status != 1 && !empty($data)) {
		if (isset($data['responseMessage']) && !empty($data['responseMessage'])) {
			$return['message'] = $data['responseMessage'];
		}
		if (isset($data['fiscalDocFields']) && !empty($data['fiscalDocFields'])) {
			$integratorData = array();
			foreach ($data['fiscalDocFields'] as $key => $value) {
				if (strtolower($key) != "qrcode") {
					$integratorData[] = $key . ": " . $value;
				}
			}
			$return['integratorData'] =  join("<br>", $integratorData);
		}
		
		if (isset($data['additionalData']['errorProductCode']) && !empty($data['additionalData']['errorProductCode'])) {
			$productName = findProductById($data['additionalData']['errorProductCode']);
			if ($productName) {
				$return['message'] .= "<br>(" . $productName . " ?)";
			}
		}
	}

	return json_encode($return);
}

function resubmitInvoiceForFiscalisation() {
	if (!isset($_POST['invoiceId']) || empty($_POST['invoiceId'])) {
		return "No invoice ID specified";
	}
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$fiscalator->uploadInvoice($_POST['invoiceId'], false, true);
	return "Invoice " . $_POST['invoiceId'] . " resubmitted for Fiscalisation. Please reload the status for updates.";
}

function resubmitCreditForFiscalisation() {
	if (!isset($_POST['invoiceId']) || empty($_POST['invoiceId'])) {
		return "No invoice ID specified";
	}
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$fiscalator->resubmitCreditInvoice($_POST['invoiceId']);
	return "Credit " . $_POST['invoiceId'] . " resubmitted for Fiscalisation. Please reload the status for updates.";
}

function queryInvoice() {
	if (!isset($_POST['invoiceId']) || empty($_POST['invoiceId'])) {
		return "No invoice ID specified";
	}
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$query = $fiscalator->queryInvoice($_POST['invoiceId']);
	return json_encode($query);
}

function callQueryCreditInvoiceLink() {
	if (!isset($_POST['invoiceId']) || empty($_POST['invoiceId'])) {
		return "No invoice ID specified";
	}
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$query = $fiscalator->queryInvoiceCreditLink($_POST['invoiceId']);
	return json_encode($query);
}

function queryCreditApproval() {
	if (!isset($_POST['invoiceId']) || empty($_POST['invoiceId'])) {
		return "No invoice ID specified";
	}
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$query = $fiscalator->queryCreditApproval($_POST['invoiceId']);
	return json_encode($query);
}

function findProductById($productId) {
	$extra = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('Extra: ', ac_ext_desc) as name
			FROM
				ac_extra
			WHERE
				ac_extra_ix = '" . $productId . "'
		",
		4
	);
	if (!empty($extra)) {
		return $extra;
	}

	$extraCategory = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('Extra Category: ', ac_extra_cat_desc) as name
			FROM
				ac_extra_category
			WHERE
				ac_extra_category_ix = '" . $productId . "'
		",
		4
	);
	if (!empty($extraCategory)) {
		return $extraCategory;
	}

	$component = $GLOBALS['lDB']->get(
		"
			SELECT
				CONCAT('Component: ', rt_component_desc) as name
			FROM
				rt_component
			WHERE
				rt_component_ix = '" . $productId . "'
		",
		4
	);

	if (!empty($component)) {
		return $component;
	}

	return false;
}

function fetchTaxCommodity($pr_business_id) {
	if (!isset($pr_business_id) || empty($pr_business_id)) {
		return "No invoicing unit ID";
	}
	$result = array();
	$mappedTaxCommodities = $GLOBALS['lDB']->get(
		"
			SELECT
				rf_tax_rate_id,
				fs_commodity_id
			FROM
				fs_tax_commodity
			WHERE
				pr_business_id = '" . $pr_business_id . "'
		",
		2
	);
	foreach ($mappedTaxCommodities as $mappedTaxCommodity) {
		$result[] = array(
			"tenantCode" => $mappedTaxCommodity['rf_tax_rate_id'],
			"providerCode" => $mappedTaxCommodity['fs_commodity_id']
		);
	}
	return $result;
}

function fetchAccountDetails() {
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$result = json_decode(
		$fiscalator->fiscalatorApiCall(
			$fiscalator->getFiscalatorKeyByInvoiceUnit($_POST['pr_business_id']),
			"GET",
			"account"
		),
		true
	);
	$result['mapping']['taxcommodity'] = array(
		"sourceCodes" => array(),
		"tenantCodes" => fetchTaxCommodity($_POST['pr_business_id'])
	);
	return json_encode($result);
}

function fetchMapping() {
	require_once(__DIR__ . '/class.fiscalator.php');
	$fiscalator = new Fiscalator;
	$mappedItems = json_decode(
		$fiscalator->fiscalatorApiCall(
			$fiscalator->getFiscalatorKeyByInvoiceUnit($_POST['pr_business_id']),
			"GET",
			"map"
		),
		true
	);

	$mappedItems['taxcommodity'] = array(
		"sourceCodes" => array(),
		"tenantCodes" => fetchTaxCommodity($_POST['pr_business_id'])
	);

	return json_encode(array(
		"mappedItems" => $mappedItems,
		"mappingItems" => fetchMappingItems()
	));
}

function addMappingTaxcommodity() {
	$GLOBALS['lDB']->put(
		"
		DELETE FROM
			fs_tax_commodity
		WHERE
			pr_business_id = '" . $_POST['pr_business_id'] . "'
			AND rf_tax_rate_id = '" . $_POST['tenantCode'] . "'
		"
	);
	
	$GLOBALS['lDB']->put(
		"
		INSERT INTO fs_tax_commodity (
			fs_tax_commodity_ix,
			fs_tax_commodity_db,
			fs_tax_commodity_id,
			pr_business_id,
			rf_tax_rate_id,
			fs_commodity_id
		) VALUES (
			(SELECT GET_UUID()),
			'" . $GLOBALS['dbcode'] . "',
			'0',
			'" . $_POST['pr_business_id'] . "',
			'" . $_POST['tenantCode'] . "',
			'" . $_POST['providerCode'] . "'
		);
		"
	);
	return "";
}

function deleteMappingTaxcommodity() {
	$GLOBALS['lDB']->put(
		"
		DELETE FROM
			fs_tax_commodity
		WHERE
			pr_business_id = '" . $_POST['pr_business_id'] . "'
			AND rf_tax_rate_id = '" . $_POST['tenantCode'] . "'
		"
	);
	return "";
}

function fetchVatTaxRates() {
	$taxRates = $GLOBALS['lDB']->get(
		"
			SELECT
				rf_tax_rate_ix,
				rf_tax_rate_vat
			FROM
				rf_tax_rate
		",
		2
	);
	$taxRateVatStatuses = array();
	foreach ($taxRates as $taxRate) {
		$taxRateVatStatuses[$taxRate['rf_tax_rate_ix']] = $taxRate['rf_tax_rate_vat'];
	}
	return json_encode($taxRateVatStatuses);
}

function saveVatTaxRate() {
	$taxRates = $GLOBALS['lDB']->put(
		"
			UPDATE
				rf_tax_rate
			SET
				rf_tax_rate_vat = '" . $_POST['vatIndicator'] . "'
			WHERE
				rf_tax_rate_ix = '" . $_POST['taxRateId'] . "'
		"
	);
	return fetchVatTaxRates();
}
