<?php

/**
 * init.form61.php - Reservation Notes Tab
 * Job: 137, 138, 139
 * Function: 52 (Reservation: Tabs)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_notes.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");

$record = (string) $_SERVER['argv'][1];
if($record == "") {
	$record = $GLOBALS['record'];
}
$GLOBALS['temp']['record'] = $record;

$wetu = new Wetu($record, $GLOBALS['lDB']);
$GLOBALS['temp']['wetuDropdownOptions'] = $wetu->GenerateButtontext();

// Details for the Itinerary Summary Popup in functions.reservation.php
getItinSummary($record);

// Verify that the user can edit, or delete for this reservation
$canEditReservation = canEditReservation($record,true,137);
$canDeleteReservation = canDeleteReservation($record);
$shared = $GLOBALS['lDB']->get("SELECT rf_share_notes_yn FROM rf_default",4);

if ($action == "3" && !$canEditReservation && $shared != "1") {
	redirectTo(" ./reservation.php?138+".$_SERVER['argv'][1]."+".$_SERVER['argv'][2]);
	die();
}

// Prevent loss of notes after a save when the master/slave status is changed
if ($action == "3" && $pmode == "1" && !array_key_exists("rv_note_general",$_POST)) {
	redirectTo(" ./reservation.php?137+".$_SERVER['argv'][1]."+".$_SERVER['argv'][2]);
	die();
}

$notes = $lDB->get("
	SELECT
		rv_reservation.rf_country_id,
		rf_country.rf_country_name,
		rv_reservation.rv_note_conf,
		rv_reservation.rv_note_general,
		rv_reservation.rv_note_guests,
		rv_reservation.rv_note_internal,
		rv_reservation.rv_date_recorded,
		rv_reservation.rv_date_changed,
		rv_reservation.rv_res_name
	FROM
		rv_reservation
		LEFT JOIN rf_country ON rf_country.rf_country_ix = rv_reservation.rf_country_id
	WHERE
		rv_reservation.rv_reservation_ix = '$record'
",1);
$GLOBALS['temp']['rv_note_general'] = $notes['rv_note_general'];
$GLOBALS['temp']['rv_note_guests'] = $notes['rv_note_guests'];
if ($_SESSION['userStatusId'] > 1) {
	$GLOBALS['temp']['rv_note_internal'] = $notes['rv_note_internal'];
} else {
	$GLOBALS['temp']['rv_note_internal'] = "";
}
if(!empty($notes['rf_country_name'])) {
	$GLOBALS['temp']['rf_country'] = t_encodeHTMLField($notes['rf_country_name']);
	$GLOBALS['temp']['rf_country_id'] = $notes['rf_country_id'];
} else {
	$GLOBALS['temp']['rf_country'] = "Unknown";
	$GLOBALS['temp']['rf_country_id'] = "";
}
$GLOBALS['temp']['rname'] = $notes['rv_res_name'];
$GLOBALS['temp']['date_create'] = chng_date($notes['rv_date_recorded'],"-");
$GLOBALS['temp']['date_ammend'] = chng_date($notes['rv_date_changed'],"-");

$nflag = $notes['rv_note_general'];
$iflag = $notes['rv_note_internal'];
$gflag = $notes['rv_note_guests'];

$GLOBALS['temp']['nflag'] = "noNotes";
if($_SESSION['userStatusId'] > 1) {
	if(((strlen(trim($nflag)) > 0) || (strlen(trim($iflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "";
	}
} else {
	if(((strlen(trim($nflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "noNotes";
	}
}

$GLOBALS['temp']['eflag'] = "noExtras";
$eflag = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_extra WHERE rv_reservation_id = '$record'",4);
if($eflag > 0) {
	$GLOBALS['temp']['eflag'] = "extras";
}

$GLOBALS['temp']['rtabflag'] = "";
$rtabflag = getReservationRooming($record);
if(sizeof($rtabflag['guests']) > 0 || sizeof($rtabflag['rooms']) > 0){
	$GLOBALS['temp']['rtabflag'] = "signal_cellular_4_bar";
}
$commsql = "SELECT COUNT(*) FROM em_mail INNER JOIN em_mail_log ON em_mail.em_mail_ix = em_mail_log.em_mail_id WHERE em_action = '-1' AND rv_reservation_id LIKE '$record'";
$ctabflag = $GLOBALS['lDB']->get($commsql,4);
$commProvCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ad_reservation WHERE ad_reservation.rv_reservation_id LIKE '$record' AND ad_reservation.ad_res_form = 'Sent Prov Notification'",4);
$GLOBALS['temp']['ctabflag'] = "";
if($ctabflag > 0 || $commProvCheck > 0){
	$GLOBALS['temp']['ctabflag'] = "bEmail";
}

$remSQL = "SELECT COUNT(*) FROM re_reminder WHERE re_reminder_link_to_ind_id = '1' AND re_reminder_link_to_id  = '{$record}'";
$GLOBALS['temp']['retabflag'] = ($GLOBALS['lDB']->get($remSQL,4) > 0 ) ? "show" : "";


$GLOBALS['temp']['jobId'] = "700";
$GLOBALS['temp']['rnum'] = $record;

$roomCheckIn = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '5'
	",4);
$roomCheckOut = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '8'
	",4);

$GLOBALS['temp']['rflag'] = "bRoomNone";
if($roomCheckIn > 0 || $roomCheckOut > 0) {
	$roomCheckTime = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_group.rv_grp_status_time
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
			AND (
				rv_res_item_group.rv_grp_status_ind = '5'
				OR rv_res_item_group.rv_grp_status_ind = '8'
			)
		ORDER BY
			rv_res_item_group.rv_grp_status_time DESC
	",4);
}
if($roomCheckIn > 0) {
	$GLOBALS['temp']['rflag'] = "bRoomIn";
}
if($roomCheckOut > 0) {
	$GLOBALS['temp']['rflag'] = "bRoomOut";
}

$GLOBALS[$form]->Arguments = "139+".$record;

// Start Access Control Toolbar Setup
$newr = 1;
$edit = 137;
$view = 138;
$dele = 30;
$sedit = 139;

// validate access to edit mode based on status and consultant

$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (array_key_exists(137,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][137] > 5 && ($canEditReservation || $shared == "1")) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if ($canDeleteReservation) {
		$pgJOBS['del'] = "1";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
if(isset($GLOBALS['timeError']) && $GLOBALS['timeError']) {
	$GLOBALS['temp']['pgJobs'] .= "
		<script language=\"javascript\">
			openMessage(\"There is a newer set of notes in the database, so your changes have been lost. This may be caused by time differences between different environments.\");
		</script>
	";
}
// End Access Control Toolbar Setup

$GLOBALS['temp']['nationalityButton'] = "";
$GLOBALS['temp']['standardNoteButton'] = "";
$GLOBALS['temp']['disableInput'] = "readonly style=\"color: #848284\"";


$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['roomingDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][215])) {
	$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['roomingDisabled'] = "disabled";
}

$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['financialDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][646])) {
	$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['financialDisabled'] = "disabled";
}

if (
	$canEditReservation && array_key_exists(647,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][647] > 5 &&		// Reservation Billings Edit
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5									// Res tabs
) {
	$GLOBALS['temp']['sumjob'] = "647+".$record;
} else {
	$GLOBALS['temp']['sumjob'] = "646+".$record;
}
if (
	$canEditReservation && array_key_exists(216,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][216] > 5 &&		// Edit rooming tab
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5									// Res tabs
) {
	$GLOBALS['temp']['resRoomJob'] = "/reservation.php?216+".$record;
} else {
	$GLOBALS['temp']['resRoomJob'] = "/reservation.php?215+".$record;
}

if (
	$canEditReservation && array_key_exists(2,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][2] > 5 &&		// Edit reservation form
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5								// Res tabs
) {
	$GLOBALS['temp']['reslinkjob'] = "2";
} else {
	$GLOBALS['temp']['reslinkjob'] = "0";
}

if($canEditReservation && array_key_exists(610,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][610] > 5) {
	$GLOBALS['temp']['resExtraJob'] = "610";
} else {
	$GLOBALS['temp']['resExtraJob'] = "609";
}


switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	break;
case (2) : // Add Record
	break;
case (3) : // Edit Record
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['nationalityButton'] = '
		<span id="nationalitySearch"> <button type="button" class="button printCollapse" style="width: 80px; height: 20px;" onclick="nationality_popup();"> Nationality </button> </span>
	';
	$GLOBALS['temp']['standardNoteButton'] = "
		<input onclick=\"openPopup('reservation.php?199',350,505)\" type=\"button\" class=\"button\" value=\"Add Standard Notes\">
	";
	$GLOBALS['temp']['disableInput'] = "";
	$reservationAuditTrail = new AuditTrail($record,TYPE_RESERVATION);
	$moduleFieldValues = array();
	if($pmode == 1) {
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_note.rv_note_general");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_note.rv_note_guests");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rf_country_id");
		if ($_SESSION['userStatusId'] > 1) {
			// Audit trails
			$rv_note_id = db_rv_note_insert($record,$_POST['rf_country_id'],false,$_POST['rv_note_general'],$_POST['rv_note_guests'],$_POST['rv_note_internal']);
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_note.rv_note_internal");
		} else {
			$rv_note_id = db_rv_note_insert($record,$_POST['rf_country_id'],false,$_POST['rv_note_general'],$_POST['rv_note_guests'],false);
		}
		$latest = db_rv_note_get_by_reservation($record);
		if($rv_note_id != $latest['rv_note_ix']) {
			$GLOBALS['timeError'] = true;
		}
		foreach ($moduleFieldValues as $moduleFieldValue) {
			$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
			$reservationAuditTrail->addDetail(
				$GLOBALS['temp'][$moduleFieldName],
				$_POST[$moduleFieldName],
				Null,
				Null,
				DB_AD_RES_DETAIL_ACTION_EDIT,
				"resnote",
				$moduleFieldValue['ad_module_field_name']
			);
		}
		$reservationAuditTrail->save("Notes");
	}
	break;
case (4) : // Delete Record
	break;
}

if ($_SESSION['userStatusId'] > 1) {
	$GLOBALS['temp']['internalMemoDisplay'] = "";
} else {
	$GLOBALS[$form.'_rv_reservation_rv_note_internal'] = new StdClass;
	$GLOBALS[$form.'_rv_reservation_rv_note_internal']->Value = "You shouldn't ever see this";
	$GLOBALS['temp']['internalMemoDisplay'] = "display:none;";
}


$GLOBALS['temp']['rnum'] = (string) $record;

$user = $lDB->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last
	FROM
		rv_reservation
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.pr_reservation_user_id
	WHERE
		rv_reservation.rv_reservation_ix = '$record'
",1);
$GLOBALS['temp']['user_created'] = trim($user['pr_name_first']." ".$user['pr_name_last']);
if ($GLOBALS['temp']['user_created'] == "") {
	$GLOBALS['temp']['user_created'] = "N/A";
}
//Reservation Status
$resStatus = $GLOBALS['lDB']->get("
	SELECT
		rf_reservation_status.rf_reservation_status_id as resStatusId,
		rf_reservation_status.rf_reservation_status_desc as resStatusDesc
	FROM
		rv_reservation
		INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
	WHERE
		rv_reservation.rv_reservation_ix = '$record'
",1);
$GLOBALS['temp']['statusDesc'] = $resStatus['resStatusDesc'];
$GLOBALS['temp']['statusClass'] = "txt";
if($resStatus['resStatusId'] == "90") {
	$GLOBALS['temp']['statusClass'] = "txtb";
}
if($resStatus['resStatusId'] == "20") {
	$expDate = $lDB->get("SELECT rv_provision_expiry_date FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);

	$today = date("Y-m-d");
	if ($today == $expDate) {
		$GLOBALS['temp']['provBg'] = "#F1C55D";
		$GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
	} elseif ($today > $expDate) {
		$GLOBALS['temp']['provBg'] = "#DB4242";
		$GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
	}
}

