<?php

/*
 * $Id: init.form66.php,v 1.21 2012-10-15 14:05:14 light Exp $
 *
 * $Log: init.form66.php,v $
 * Revision 1.21  2012-10-15 14:05:14  light
 * Bug #6924 - Stock API to differentiate between confirmed & provisional reservations
 *
 * Revision 1.20  2011-12-23 13:45:49  light
 * Bug #7827 - Access control changes for fraud prevention
 *
 * Revision 1.19  2011-05-17 14:08:34  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.18  2011-03-16 15:54:13  light
 * Bug #7526 - Online payments (central code changes)
 *
 * Revision 1.17  2009-08-03 10:02:35  light
 * Bug #6864 - Clone a user access group
 *
 * Revision 1.16  2009-03-17 13:11:48  light
 * Bug #6698 - API
 *
 * Revision 1.15  2008-03-31 09:13:42  light
 * Bug #6213 - Allocations display on Availability Calendar
 *
 * Revision 1.14  2008-03-31 08:56:11  light
 * Bug #6213 - Allocations display on Availability Calendar
 *
 * Revision 1.13  2008-03-31 08:36:47  light
 * Bug #6213 - Allocations display on Availability Calendar
 *
 * Revision 1.12  2007-03-14 12:39:58  gregs
 * Access control errors
 *
 * Revision 1.11  2007-02-07 18:22:26  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.10  2006-11-17 14:31:12  light
 * Code cleanup
 *
 * Revision 1.9  2006-11-08 14:19:31  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.8  2004-04-21 09:29:56  tvdspuy
 * toolbars on user access
 * fixing whitescreen for public page
 *
 * Revision 1.7  2004/04/20 06:56:23  tvdspuy
 * access update
 *
 * Revision 1.6  2004/04/19 14:05:57  tvdspuy
 * bug #2079
 *
 * Revision 1.5  2004/04/19 09:46:12  tvdspuy
 * consultant bug # 1596
 *
 * Revision 1.4  2004/03/27 09:22:36  tvdspuy
 * access control update
 *
 * Revision 1.3  2004/03/27 06:49:16  tvdspuy
 * user access - calendar limits patch
 *
 * Revision 1.2  2004/02/20 08:59:09  light
 * Cleaned up code
 *
 */

/**
 * init.form66.php - Access control main page (detail section)
 * Job: 145
 * Function: 65 (Access control)
 */

require_once(__DIR__ . '/db.sc_env_group.php');

use MaglLegacyApplication\Application\MaglLegacy;

$application = MaglLegacy::getInstance()->getApplication();
$serviceManager = $application->getServiceManager();
$em = $serviceManager->get('EnterpriseEntityManager');


if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/access_groups.htm");
	$fields = array(
		"sc_group_id",
		"sc_grp_code",
		"sc_grp_desc",
		"sc_grp_alloc_ind",
		"sc_grp_consultant_yn",
		"sc_grp_api_yn",
		"sc_grp_def_optionals_yn",
		"sc_grp_archive_yn",
		"sc_grp_force_payment_yn",
		"sc_grp_avail_limit",
		"sc_grp_avail_limit_yn",
		"sc_grp_avail_prov_yn",
		"sc_grp_sys_code",
		"sc_grp_res_status_unalloc_yn",
		"sc_grp_res_status_alloc_yn",
		"sc_grp_cross_invoice_yn",
		"sc_grp_res_void_invoice_yn",
		"sc_grp_res_void_payment_yn",
		"sc_grp_res_ovr_alloc_yn",
		"sc_grp_res_ovr_rate_type_yn",
		"sc_grp_res_ovr_amount_yn",
		"sc_grp_res_ovr_variance_yn",
		"sc_grp_res_ovr_overbooking_yn",
		"sc_grp_res_ovr_specials_yn",
		"sc_grp_res_ovr_total_pax_yn",
		"sc_grp_res_sp_apply_auto_yn",
		"sc_grp_res_sp_apply_man_yn",
		"sc_grp_ovr_minlos_yn",
		"sc_grp_res_wetu_yn",
		"sc_grp_res_lock_yn",
		"sc_grp_res_lock_days",
		"sc_grp_res_lock_ind",
		"sc_grp_res_edit_details_yn",
		"sc_grp_res_edit_itineraries_yn"
	);
	$ident = array("sc_group_id");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"sc_group",$fields,"sc_group_id = '$record'","","",$ident);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");

$record = $_SERVER['argv'][1];

$GLOBALS['autovar'] = "1";

if ( $record != "" ) {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ( $action != "2" ) {
		$record = isset($GLOBALS['passthrurecord'])?$GLOBALS['passthrurecord']:"";
		if ( $_SERVER['argv'][1] == "" ) {
			$_SERVER['argv'][1] = $record;
		}
	}
}

$GLOBALS['temp']['record'] = $record;

if ($record && $action == '4' && $_SERVER['argv'][0] == '149') {
	$sc_env_group_ix = $lDB->get("
		SELECT sc_env_group_ix FROM sc_env_group WHERE sc_group_id = $record
	", 3);
	db_sc_env_group_delete_group($sc_env_group_ix);
}
$cloneGroup = 0;

if($action == 2 && $pmode != "1" && isset($_POST['clone']) && $_POST['clone'] == "1") {
	$functions = $GLOBALS['lDB']->get("
		SELECT
			sc_function_id,
			sc_fun_grp_level
		FROM
			sc_fun_group
		WHERE
			sc_fun_group.sc_group_id = '$_POST[clone_record]'
	",2);
	foreach($functions as $function) {
		$GLOBALS['lDB']->put("
			INSERT INTO sc_fun_group (
				sc_function_id,
				sc_group_id,
				sc_fun_grp_level
			) VALUES (
				'$function[sc_function_id]',
				'$record',
				'$function[sc_fun_grp_level]'
			)
		");
	}
	$accomm = $GLOBALS['lDB']->get("SELECT ac_accomm_type_id FROM sc_accomm WHERE sc_group_id = '$_POST[clone_record]'",3);
	foreach($accomm as $item) {
		$GLOBALS['lDB']->put("
			INSERT INTO sc_accomm (
				ac_accomm_type_id,
				sc_group_id
			) VALUES (
				'$item',
				'$record'
			)
		");
	}
	$cloneGroup = $_POST['clone_record'];
}

$GLOBALS[$form]->Get($action);

$table = $GLOBALS[$form]->TableList[0];

if ( $record != "" || $action == "3" && $action != "1" ) {
	$GLOBALS[$table]->Refresh($record,$action);
}

$hidelist = array();

array_push($hidelist,$form."_sc_group_sc_grp_res_lock_yn");
array_push($hidelist,$form."_sc_group_sc_grp_res_lock_days");
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array("sc_grp_sys_code");

$GLOBALS['temp']['forcePaymentOverlib'] = "";
if(!db_pg_account_exists_by_any()) {
	array_push($disablelist,$form."_sc_group_sc_grp_force_payment_yn");
	$GLOBALS['temp']['forcePaymentOverlib'] = "onmouseout=\"nd();\" onmouseover=\"overlib('Setup at least one payment gateway account for this option to be activated.',WIDTH,375);\"";
}
$GLOBALS[$form]->Disable($disablelist);

$GLOBALS['temp']['sc_grp_sys_code'] = "''";

if ( $record ) {
	$result = $GLOBALS['lDB']->get("
		SELECT
			sc_grp_avail_limit_yn,
			sc_grp_sys_code
		FROM
			sc_group
		WHERE
			sc_group_id = '" . $record . "'
	",1);
	
	$sc_grp_avail_limit_yn	= $result['sc_grp_avail_limit_yn'];
	$sc_grp_sys_code				= $result['sc_grp_sys_code'];
	
	$GLOBALS['temp']['sc_grp_sys_code'] = $sc_grp_sys_code;
}

if ( $pmode == "1" ) {
	if ( $action == "2" || $action == "3" ) {
		$limit_yn = isset($_POST['limit_yn'])?$_POST['limit_yn']:"";
		switch($limit_yn) {
			case "no":
				$GLOBALS[$form.'_sc_group_sc_grp_avail_limit_yn']->SetValue(0);
				break;
			
			case "zero":
				$GLOBALS[$form.'_sc_group_sc_grp_avail_limit_yn']->SetValue(1);
				$GLOBALS[$form.'_sc_group_sc_grp_avail_limit']->SetValue(0);
				break;
			
			case "yes":
				$GLOBALS[$form.'_sc_group_sc_grp_avail_limit_yn']->SetValue(1);
				break;
		}
	}

	
	if(array_key_exists("sc_grp_avail_prov_yn",$_POST) && !empty($_POST['sc_grp_avail_prov_yn'])) {
		$GLOBALS[$form.'_sc_group_sc_grp_avail_prov_yn']->SetValue(1);
	} else {
		$GLOBALS[$form.'_sc_group_sc_grp_avail_prov_yn']->SetValue(0);
	}
}

if ( $action != "2" && $GLOBALS[$form.'_sc_group_sc_grp_avail_limit_yn']->Value == 1 ) {
	if ( $GLOBALS[$form.'_sc_group_sc_grp_avail_limit']->Value != "0" ) {
		$GLOBALS['tagList']['limit_yes'] = setNewAttrib(" checked=\"checked\"");
	} else {
		$GLOBALS['tagList']['limit_zero'] = setNewAttrib(" checked=\"checked\"");
	}

	
} else {
	$GLOBALS['tagList']['limit_no'] = setNewAttrib(" checked=\"checked\"");
}

if($action != "2" && $GLOBALS[$form.'_sc_group_sc_grp_avail_prov_yn']->Value != "0") {
	$GLOBALS['tagList']['sc_grp_avail_prov_yn'] = setNewAttrib(" checked=\"checked\"");
}

$GLOBALS[$form.'_sc_group_sc_grp_code']->TabIndex = 1;
$GLOBALS[$form.'_sc_group_sc_grp_code']->Size = 10;
$GLOBALS[$form.'_sc_group_sc_grp_code']->Class = 1;
$GLOBALS[$form.'_sc_group_sc_grp_code']->StyleType = "txt";

$GLOBALS[$form.'_sc_group_sc_grp_desc']->TabIndex = 2;
$GLOBALS[$form.'_sc_group_sc_grp_desc']->Size = 40;
$GLOBALS[$form.'_sc_group_sc_grp_desc']->Class = 1;
$GLOBALS[$form.'_sc_group_sc_grp_desc']->StyleType = "txt";

$GLOBALS[$form.'_sc_group_sc_grp_alloc_ind']->TabIndex = 3;
$GLOBALS[$form.'_sc_group_sc_grp_alloc_ind']->Select(array("0:|:Use system default","1:|:Yes","2:|:No"));
$GLOBALS[$form.'_sc_group_sc_grp_alloc_ind']->Class = 3;

$GLOBALS[$form.'_sc_group_sc_grp_consultant_yn']->TabIndex = 4;
$GLOBALS[$form.'_sc_group_sc_grp_consultant_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_api_yn']->TabIndex = 4;
$GLOBALS[$form.'_sc_group_sc_grp_api_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_archive_yn']->TabIndex = 4;
$GLOBALS[$form.'_sc_group_sc_grp_archive_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_def_optionals_yn']->TabIndex = 4;
$GLOBALS[$form.'_sc_group_sc_grp_def_optionals_yn']->Class = 9;
if(!$record && $action == "2" && $pmode != "1") { // If this is a new record, enabled by default
	$GLOBALS[$form.'_sc_group_sc_grp_def_optionals_yn']->SetValue(1);
}

$GLOBALS[$form.'_sc_group_sc_grp_force_payment_yn']->TabIndex = 4;
$GLOBALS[$form.'_sc_group_sc_grp_force_payment_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_avail_limit']->TabIndex = 7;
$GLOBALS[$form.'_sc_group_sc_grp_avail_limit']->Size = 5;
$GLOBALS[$form.'_sc_group_sc_grp_avail_limit']->Class = 1;
$GLOBALS[$form.'_sc_group_sc_grp_avail_limit']->StyleType = "txt";

$GLOBALS[$form.'_sc_group_sc_grp_res_status_unalloc_yn']->TabIndex = 18;
$GLOBALS[$form.'_sc_group_sc_grp_res_status_unalloc_yn']->Class = 9;
$GLOBALS[$form.'_sc_group_sc_grp_res_status_unalloc_yn']->OnClick = "resStatusUpdate();";

$GLOBALS[$form.'_sc_group_sc_grp_res_status_alloc_yn']->TabIndex = 19;
$GLOBALS[$form.'_sc_group_sc_grp_res_status_alloc_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_edit_details_yn']->TabIndex = 20;
$GLOBALS[$form.'_sc_group_sc_grp_res_edit_details_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_edit_itineraries_yn']->TabIndex = 20;
$GLOBALS[$form.'_sc_group_sc_grp_res_edit_itineraries_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_cross_invoice_yn']->TabIndex = 20;
$GLOBALS[$form.'_sc_group_sc_grp_cross_invoice_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_void_invoice_yn']->TabIndex = 21;
$GLOBALS[$form.'_sc_group_sc_grp_res_void_invoice_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_void_payment_yn']->TabIndex = 22;
$GLOBALS[$form.'_sc_group_sc_grp_res_void_payment_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_rate_type_yn']->TabIndex = 13;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_rate_type_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_amount_yn']->TabIndex = 14;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_amount_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_variance_yn']->TabIndex = 15;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_variance_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_overbooking_yn']->TabIndex = 16;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_overbooking_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_lock_ind']->TabIndex = 11;
$GLOBALS[$form.'_sc_group_sc_grp_res_lock_ind']->Select(array("1:|:arrival date","2:|:departure date"));
$GLOBALS[$form.'_sc_group_sc_grp_res_lock_ind']->Class = 3;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_specials_yn']->TabIndex = 23;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_specials_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_alloc_yn']->TabIndex = 24;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_alloc_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_total_pax_yn']->TabIndex = 25;
$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_total_pax_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_sp_apply_auto_yn']->TabIndex = 26;
$GLOBALS[$form.'_sc_group_sc_grp_res_sp_apply_auto_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_sp_apply_man_yn']->TabIndex = 27;
$GLOBALS[$form.'_sc_group_sc_grp_res_sp_apply_man_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_res_wetu_yn']->TabIndex = 28;
$GLOBALS[$form.'_sc_group_sc_grp_res_wetu_yn']->Class = 9;

$GLOBALS[$form.'_sc_group_sc_grp_ovr_minlos_yn']->TabIndex = 28;
$GLOBALS[$form.'_sc_group_sc_grp_ovr_minlos_yn']->Class = 9;

$GLOBALS['temp']['cloneClass'] = "collapse printCollapse";

$users = $lDB->get("SELECT COUNT(*) FROM sc_user WHERE sc_user.sc_group_id = '$record'",4);
$GLOBALS['temp']['groupUserCount'] = $users;

switch ($action) {
	
	// List Records --------------------------------------------------------------
	case (0) :
		break;

	// Display Record ------------------------------------------------------------
	case (1) :
		$GLOBALS['mode'] = "display";
		$GLOBALS['temp']['new_record']	= "reservation.php?145";
		$GLOBALS['temp']['edit_view']		= "reservation.php?147+" . $record;
		$GLOBALS['temp']['save_record']	= "#";
		$GLOBALS['temp']['del_record']	= "#";
		break;

	// Add Record ----------------------------------------------------------------
	case (2) :
		$GLOBALS['mode'] = "new";
		$GLOBALS[$form]->Arguments			= "146";
		$GLOBALS['temp']['new_record']	= "reservation.php?145";
		$GLOBALS['temp']['edit_view']		= "#";
		$GLOBALS['temp']['save_record']	= "document.forms[0].submit()";
		$GLOBALS['temp']['del_record']	= "#";
		break;

	// Edit Record ---------------------------------------------------------------
	case (3) :
		$GLOBALS['mode'] = "edit";
		$GLOBALS[$form]->Arguments			= "148+" . $record;
		$GLOBALS['temp']['new_record']	= "reservation.php?145";
		$GLOBALS['temp']['edit_view']		= "reservation.php?144+" . $record;
		$GLOBALS['temp']['save_record']	= "document.forms[0].submit()";
		$GLOBALS['temp']['del_record']	= "reservation.php?149+" . $record;
		$GLOBALS['temp']['cloneClass'] = "button";
		break;

	// Delete Record -------------------------------------------------------------
	case (4) :
		if($users > 0) {
			redirectTo(" reservation.php?147+".$record);
			die();
		} else {
			$GLOBALS['initrecord'] = $record;
			$GLOBALS['delrecord'] = $record;
		}
		break;
}

// [START] Access Control Toolbar Setup ---------------------------------------
$newr		= 145;
$edit		= 147;
$view		= 144;
$dele		= 149;
$sedit	= 148;
$snewr	= 146;
$GLOBALS['temp']['job_new_save'] = $snewr;

$pgJOBS = array();

$pgJOBS['view'] = "0";

if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}

$pgJOBS['add'] = "0";

if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}

$pgJOBS['edit'] = "0";

$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";

if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}

if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}

if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
}

$GLOBALS['tagList']['pgJobNew']			= setNewParam("value",$pgJOBS['add']);
$GLOBALS['tagList']['pgJobEdit']		= setNewParam("value",$pgJOBS['edit']);
$GLOBALS['tagList']['pgJobDelete']	= setNewParam("value",$pgJOBS['del']);
$GLOBALS['tagList']['pgJobSave']		= setNewParam("value",$pgJOBS['save']);

// [ END ] Access Control Toolbar Setup ---------------------------------------

if ($record != "" && isset($_POST['adUseraccessId']) && $_POST['adUseraccessId'] != '') {
	// Update user access audit header with the new group ID after creating new group
	$lDB->put("
		UPDATE
			ad_useraccess
		SET
			sc_group_id = '" . $record . "'
		WHERE
			ad_useraccess.ad_useraccess_ix = '" . $_POST['adUseraccessId'] . "';
	");
}

if($pmode == "1") {
	if($action == "2" || $action == "3") {
		if(!isset($_POST['sc_grp_consultant_yn']) || $_POST['sc_grp_consultant_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_consultant_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_api_yn']) || $_POST['sc_grp_api_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_api_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_archive_yn']) || $_POST['sc_grp_archive_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_archive_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_def_optionals_yn']) || $_POST['sc_grp_def_optionals_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_def_optionals_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_force_payment_yn']) || $_POST['sc_grp_force_payment_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_force_payment_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_status_unalloc_yn']) || $_POST['sc_grp_res_status_unalloc_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_status_unalloc_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_status_alloc_yn']) || $_POST['sc_grp_res_status_alloc_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_status_alloc_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_edit_details_yn']) || $_POST['sc_grp_res_edit_details_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_edit_details_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_edit_itineraries_yn']) || $_POST['sc_grp_res_edit_itineraries_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_edit_itineraries_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_cross_invoice_yn']) || $_POST['sc_grp_cross_invoice_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_cross_invoice_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_void_invoice_yn']) || $_POST['sc_grp_res_void_invoice_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_void_invoice_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_void_payment_yn']) || $_POST['sc_grp_res_void_payment_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_void_payment_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_alloc_yn']) || $_POST['sc_grp_res_ovr_alloc_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_alloc_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_rate_type_yn']) || $_POST['sc_grp_res_ovr_rate_type_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_rate_type_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_amount_yn']) || $_POST['sc_grp_res_ovr_amount_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_amount_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_variance_yn']) || $_POST['sc_grp_res_ovr_variance_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_variance_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_overbooking_yn']) || $_POST['sc_grp_res_ovr_overbooking_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_overbooking_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_specials_yn']) || $_POST['sc_grp_res_ovr_specials_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_specials_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_ovr_total_pax_yn']) || $_POST['sc_grp_res_ovr_total_pax_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_ovr_total_pax_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_sp_apply_auto_yn']) || $_POST['sc_grp_res_sp_apply_auto_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_sp_apply_auto_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_sp_apply_man_yn']) || $_POST['sc_grp_res_sp_apply_man_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_sp_apply_man_yn']->SetValue(0);
		}
		if(!isset($_POST['sc_grp_res_wetu_yn']) || $_POST['sc_grp_res_wetu_yn'] != "on") {
			$GLOBALS[$form.'_sc_group_sc_grp_res_wetu_yn']->SetValue(0);
		}

		// Add/Edit audit trail
		$groupData = $GLOBALS['lDB']->get("
			SELECT
				*
			FROM
				sc_group
			WHERE
				sc_group_id = ".$record."
		",1);

		$userAccessAuditTrail = new AuditTrail($record,TYPE_USERACCESS);
		$scGroupChanges = false;

		foreach ($fields as $field) {
			// Checkbox correction
			if (!isset($_POST[$field]) && ( isset($GLOBALS[$form.'_sc_group_'.$field]) && $GLOBALS[$form.'_sc_group_'.$field]->Class == 9) ) {
				$_POST[$field] = "0";
			}
			if (isset($_POST[$field]) && ( isset($GLOBALS[$form.'_sc_group_'.$field]) && $GLOBALS[$form.'_sc_group_'.$field]->Class == 9) && $_POST[$field] == "on") {
				$_POST[$field] = "1";
			}

			if (isset($_POST[$field]) && $_POST[$field] != $groupData[$field]) {
				$scGroupChanges = true;
				$userAccessAuditTrail->addDetail(
					$groupData[$field],
					$_POST[$field],
					$field,
					$field,
					1,
					"useraccess",
					"sc_group.".$field
				);
			}
		}

		$userAccessAction = "User Access";
		$userAccessAction = $action == "2" ? "User Access (New)" : $userAccessAction;
		$userAccessAction = $action == "3" ? "User Access (Edit)" : $userAccessAction;

		if ($scGroupChanges) {
			$adUseraccessId = $userAccessAuditTrail->save($userAccessAction);
			$_POST['adUseraccessId'] = $adUseraccessId;
		}
		
	}

	if ($action == "4") {
		// Delete audit trail
		$userAccessAuditTrail = new AuditTrail($record,TYPE_USERACCESS);
		$groupData = $GLOBALS['lDB']->get("
			SELECT
				*
			FROM
				sc_group
			WHERE
				sc_group_id = ".$record."
		",1);
		foreach($groupData as $key => $data) {
			$userAccessAuditTrail->addDetail(
				$data,
				'',
				'',
				'',
				2,
				"useraccess",
				"sc_group.".$key
			);
		}
		$adUseraccessId = $userAccessAuditTrail->save("User Access (Delete)");
	}
}

$chartContainerService = $serviceManager->get("Resrequest\Application\Chart\ChartContainer");
$chartBuilder = $serviceManager->get("Resrequest\Application\Chart\ChartBuilder");

// Apply user access settings for dashboards and charts

// Search for chart access settings
if (!empty($record)) {
	if (!empty($_POST['dashboard_chart_updated_settings'])) {
		$chartSettings = json_decode($_POST['dashboard_chart_updated_settings'], true);

		foreach ($chartSettings as $chartId => $setting) {
			if ($setting === true) {
				$chartBuilder->setChartAccessLevel($chartId, $record, 5);
			} else {
				$chartBuilder->setChartAccessLevel($chartId, $record, 0);
			}
		}
		$_POST['dashboard_chart_updated_settings'] = false;
	}

	if (!empty($_POST['dashboard_chart_container_updated_settings'])) {
		$chartContainerSettings = json_decode($_POST['dashboard_chart_container_updated_settings'], true);

		foreach ($chartContainerSettings as $chartContainerId => $setting) {
			if ($setting === true) {
				$chartContainerService->setChartContainerAccessLevel($chartContainerId, $record, 5);
			} else {
				$chartContainerService->setChartContainerAccessLevel($chartContainerId, $record, 0);
			}
			$_POST['dashboard_chart_container_updated_settings'] = false;
		}
	}
}


// Build user access controls for dashboards and charts
$chartContainers = $chartContainerService->getContainerSummaries();
$dashboardUserAccessRows = "";

foreach($chartContainers as $chartContainer) {
	$hidden = $chartContainerService->isChartContainerHidden($chartContainer['id']);

	if ($hidden) {
		continue;
	}

	$disabled = $chartContainerService->isChartContainerDisabled($chartContainer['id']);

	$dashboardDisabled = '';
	if ($disabled) {
		$dashboardDisabled = 'disabled';
	}

	$dashboardAllowed = "";
	if (!empty($record) && $chartContainerService->isChartContainerAllowed($chartContainer['id'], $record)) {
		$dashboardAllowed = "checked=\"\"";
	}

	$dashboardUserAccessRows .= "
		<tr>
			<td align=\"center\">
				<input type=\"checkbox\" id=\"{$chartContainer['id']}\" {$dashboardAllowed} {$dashboardDisabled} class=\"forminput chart-container-checkbox\" onclick=\"toggleDashboardAccess(this);\">
			</td>
			<td colspan=\"6\">
				<label>{$chartContainer['name']}</label>
			</td>
		</tr>
		<tr style=\"height:5px;\"></tr>";

	if (!empty($chartContainer['charts'])) {
		$dashboardUserAccessRows .= "
			<tr>
				<td colspan=\"1\"></td>
				<td colspan=\"6\">
					<span>Charts</span>
				</td>
			</tr>
			<tr style=\"height:5px;\"></tr>";

		foreach ($chartContainer['charts'] as $chart) {
			$chartAllowed = "";

			if (!empty($record) && $chartBuilder->canAccessChart($chart['id'], $record)) {
				$chartAllowed = "checked=\"\"";
			}
			
			$dashboardUserAccessRows .= "
			<tr>
				<td colspan=\"1\"></td>
				<td align=\"center\">
					<input type=\"checkbox\" data-chart-id=\"{$chart['id']}\" data-chart-container-id=\"{$chartContainer['id']}\" {$chartAllowed} class=\"forminput  chart-checkbox\" onclick=\"toggleChartAccess(this);\">
				</td>
				<td colspan=\"6\">
					<label>{$chart['name']}</label>
				</td>
			</tr>";
		}
	}
	$dashboardUserAccessRows .= "<tr style=\"height:20px;\"></tr>";
}

$resvegaAccessLevel = intval($GLOBALS['lDB']->get("SELECT rf_sys_tourism_today_access_ind FROM rf_system" ,3)[0]);

$resvegaAccess = 'NONE';
if ($resvegaAccessLevel === 2) {
	$resvegaAccess = 'PRO';
} else if ($resvegaAccessLevel == 1) {
	$resvegaAccess = 'FREE';
}

$dashboardUserAccessRowsRight = "
<tr>
<td align=\"center\">
</td>
<td colspan=\"6\">
	<span>Tourism.Today</span>
</td>
</tr>
<tr style=\"height:5px;\"></tr>
<tr>
	<td colspan=\"\"></td>
	<td colspan=\"6\">
		<span>Current access: <b>{$resvegaAccess}</b></span>
	</td>
</tr>";

// Build ResVega access controls
$resvegaContainers = \Resrequest\Application\Chart\ChartContainer::RESVEGA_CONTAINERS;

// Group container IDs by version
$containerVersions = [];
foreach ($resvegaContainers as $id => $container) {
	$version = $container['version'];
	if (!isset($containerVersions[$version])) {
		$containerVersions[$version] = [];
	}

	$containerVersions[$version][] = $id;
}

// Genereate UI for each version
foreach ($containerVersions as $version => $ids) {
	$versionUpper = strtoupper($version);
	$dashboardUserAccessRowsRight .= "
	<tr style=\"height:15px;\"></tr>
	<tr>
	<td colspan=\"1\"></td>
	<td colspan=\"6\">
		<span><b>{$versionUpper}</b></span>
	</td>
	</tr>";

	$chartContainers = $chartContainerService->getContainerSummaries($ids);
	foreach($chartContainers as $chartContainer) {
		$disabled = $chartContainerService->isChartContainerDisabled($chartContainer['id']);

		$overlib = "";
		$dashboardDisabled = '';
		if ($disabled) {
			$dashboardDisabled = 'disabled';
			$overlib = "onmouseover=\"overlib('This dashboard is only available on the <b>{$versionUpper}</b> version of Tourism.Today');\" onmouseout=\"nd();\"";
		}

		$dashboardAllowed = "";
		if (!empty($record) && $chartContainerService->isChartContainerAllowed($chartContainer['id'], $record, true)) {
			$dashboardAllowed = "checked=\"\"";
		}

		$dashboardUserAccessRowsRight .= "
		<tr {$overlib}>
			<td colspan=\"1\"></td>
			<td align=\"center\">
				<input type=\"checkbox\" id=\"{$chartContainer['id']}\" {$dashboardAllowed} {$dashboardDisabled} class=\"forminput chart-container-checkbox\" onclick=\"toggleDashboardAccess(this);\">
			</td>
			<td colspan=\"6\">
				<label>{$chartContainer['name']}</label>
			</td>
		</tr>";
	}
}

$GLOBALS['temp']['dashboardUserAccessRowsRight'] = $dashboardUserAccessRowsRight;


$GLOBALS['temp']['dashboardUserAccessRows'] = $dashboardUserAccessRows;

// Environment Access

if ($action == 2 && $record) { // Add record
	if (!$cloneGroup) {
		$envAccess = [];
		// Get checked environment checkboxes from $_POST array for canAccess array
		$envList = array_filter($_POST, function ($key) { 
			return strpos($key, 'rf_database_id-') === 0;
		}, ARRAY_FILTER_USE_KEY);
		// Extract envId and checked value
		foreach ($envList as $key => $value) { 
			$rf_database_id = substr($key, 15);
			$envAccess[$rf_database_id] = $value;
		}
		db_sc_env_group_update($record, $envAccess); // applies a "diff" to update the db with the changes
	}
	else {
		db_sc_env_group_clone_group($cloneGroup, $record);
	}
}

$property     = "";
$environmentList = db_sc_env_group_get_environment_list();
$environmentAccessList = [];
$emptyEnvironmentList = "";
$resCheck  = "";
$resList   = "";
$environmentCounter = 0;
if ($record) {
	$environmentAccessList = db_sc_env_group_get_list($record);
}
// Build HTML
$resCheckCounter = 0;
foreach($environmentList as $key => $field) {
	$hideRow  = "";
	$isOdd    = $environmentCounter % 2;
	$checked  = (in_array($field['rf_database_id'], $environmentAccessList) && count($environmentAccessList) > 0) ? "checked" : "";
	$inactive = ($field['rf_db_inactive_yn']) ? " class = 'txti txtgr'" : "";
	$disabled = ($field['rf_db_inactive_yn']) ? "onclick='return false;'" : "";
	$disabledCheckbox = ($field['rf_db_inactive_yn']) ? "disabled" : "";
	$inactiveTitle = ($field['rf_db_inactive_yn']) ? "title='Inactive'" : "";
	$envType  = ($field['rf_db_env_type_ind'] == ENVIRONMENT_TYPE_RESERVATION) ? "res" : "";
	if ($envType === "res") { // Build Res Office Entry
		$resCheck = (in_array($field['rf_database_id'], $environmentAccessList) && count($environmentAccessList) > 0) ? "checked" : "";
		$resCheckCounter += $resCheck === "checked" ? 1 : 0;
		$resList .= "<span $inactive> " . $field['rf_db_code'] . "</span>,";
		$hideRow  = "style='display:none;'";
		$property = "
			<td>&nbsp;<input type='checkbox' id='rf_database_id-" . $field['rf_database_id'] . "' name='rf_database_id-" . $field['rf_database_id'] . "' $resCheck class='chbEnv resChecked' " . $disabledCheckbox . "></td>
			<td><label for='rf_database_id-" . $field['rf_database_id'] . "' $inactive $inactiveTitle>" . $field['rf_db_description'] . " (" . $field['rf_db_code'] . ")</label></td>
		";
	}
	else { // Build Property Office List
		$property = "
			<td>&nbsp;<input type='checkbox' id='rf_database_id-" . $field['rf_database_id'] . "' name='rf_database_id-" . $field['rf_database_id'] . "' $disabled $checked class='chbEnv' " . $disabledCheckbox . "></td>
			<td><label for='rf_database_id-" . $field['rf_database_id'] . "' $inactive $inactiveTitle>" . $field['rf_db_description'] . " (" . $field['rf_db_code'] . ")</label></td>
		";
		$environmentCounter++;
	}
	if(!$isOdd) { // Combine Res environments on one row and spread property environments evenly in the next rows.
		$emptyEnvironmentList .= "<tr class='' $hideRow>" . $property;
	}
	else {
		$emptyEnvironmentList .= $property . "</tr>";
	}
}
$checkRes = ($resCheckCounter > 0) ? "checked" : "";
$reservationOffice  = "
	<tr>
		<td>&nbsp;<input type='checkbox' id='sc_env_group_resOffice' name='sc_env_group_resOffice' $checkRes class='chbEnv'
				onclick=\"$('.resChecked').prop('checked', $(this).prop('checked'));\">
		</td>
		<td><label for='sc_env_group_resOffice'>Reservation (" . substr($resList, 0, strlen($resList) - 1) . " )</label>
		</td>
	</tr>";

$groupEnvironmentList = $reservationOffice . $emptyEnvironmentList;

$GLOBALS['temp']['groupEnvironmentList'] = $groupEnvironmentList;

// End Environment Access

cacheClear();
