<?php
/*
 * $Id: init.form67.php,v 1.15 2011-05-17 14:08:34 light Exp $
 *
 * $Log: init.form67.php,v $
 * Revision 1.15  2011-05-17 14:08:34  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.14  2011-03-16 15:54:13  light
 * Bug #7526 - Online payments (central code changes)
 *
 * Revision 1.13  2009-03-17 13:11:48  light
 * Bug #6698 - API
 *
 * Revision 1.12  2008-09-30 08:22:59  light
 * Bug #5768 - Function and accomm totals on access ctl mnt screen
 *
 * Revision 1.11  2008-03-31 09:13:42  light
 * Bug #6213 - Allocations display on Availability Calendar
 *
 * Revision 1.10  2008-03-31 08:56:11  light
 * Bug #6213 - Allocations display on Availability Calendar
 *
 * Revision 1.9  2008-03-31 08:36:47  light
 * Bug #6213 - Allocations display on Availability Calendar
 *
 * Revision 1.8  2007-07-07 14:58:18  light
 * Fixed the access control to ignore inactive users
 *
 * Revision 1.7  2006-11-17 14:31:12  light
 * Code cleanup
 *
 * Revision 1.6  2004-11-22 08:42:46  light
 * Copy REL_3_2_3 -> HEAD
 *
 * Revision 1.4.54.1  2004/10/20 11:03:15  light
 * Fixes to access control / etc
 *
 * Revision 1.4  2004/03/27 09:22:36  tvdspuy
 * access control update
 *
 * Revision 1.3  2004/02/20 08:59:09  light
 * Cleaned up code
 *
 */

/**
 * init.form67.php - Access control main page (list section)
 * Job: 144 (Display), 145 (Add), 146 (Save Add), 147 (Edit), 148 (Save Edit), 149 (Delete)
 * Function: 65 (Access control)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/access_groups_list.htm");
}

if (sizeof($GLOBALS[$form]->RecordList) < "1") {
	$RecordStart = "0";

	#---------------------------------------------------------------------#
	# Start of Mike's SQL code (Updated by Dylan)                         #
	# !!! Abandon hope all ye who enter here !!!                          #
	# $group_details will contain an array of rows for display            #
	#---------------------------------------------------------------------#

	$propertyCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			pr_business
		WHERE
			pr_business.pr_bus_property_yn=1
			AND pr_business.pr_bus_inactive_yn=0
	",4);

	$accommCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type_inactive_yn = 0
			AND pr_business.pr_bus_inactive_yn = 0
	",4);


	$rows = "";
	$rowHTML = Join("\n",File(__DIR__ . "/../../../public/html/access_groups_list.htm"));
	if(isMasterDB()) {
		$allowEditRecord = "";
	} else {
		$allowEditRecord = " return false; ";
	}
	$rowHTML = str_replace("!allowEditRecord!",$allowEditRecord,$rowHTML);

	$groupList = $GLOBALS['lDB']->get("
		SELECT
			sc_group_id,
			sc_grp_code,
			sc_grp_desc,
			sc_grp_avail_limit,
			sc_grp_avail_limit_yn,
			sc_grp_consultant_yn,
			sc_grp_api_yn,
			sc_grp_archive_yn,
			sc_grp_force_payment_yn,
			sc_grp_alloc_ind
		FROM
			sc_group
		WHERE
			sc_grp_sys_code < 9
		ORDER BY
			sc_grp_code
	",2);
	foreach($groupList as $item) {
		if($item['sc_grp_consultant_yn'] == 1) {
			$item['sc_grp_consultant_yn'] = "x";
		} else {
			$item['sc_grp_consultant_yn'] = "";
		}

		if($item['sc_grp_api_yn'] == 1) {
			$item['sc_grp_api_yn'] = "x";
		} else {
			$item['sc_grp_api_yn'] = "";
		}

		if($item['sc_grp_archive_yn'] == 1) {
			$item['sc_grp_archive_yn'] = "x";
		} else {
			$item['sc_grp_archive_yn'] = "";
		}
		
		if($item['sc_grp_force_payment_yn'] == 1) {
			$item['sc_grp_force_payment_yn'] = "x";
		} else {
			$item['sc_grp_force_payment_yn'] = "";
		}

		if($item['sc_grp_avail_limit_yn'] == 0) {
			$item['cal_limit'] = "None";
		} else {
			if($item['sc_grp_avail_limit'] == 0) {
				$item['cal_limit'] = "Yes";
			} else {
				$item['cal_limit'] = $item['sc_grp_avail_limit'];
			}
		}

		switch($item['sc_grp_alloc_ind']) {
		case 0:
			$item['sc_grp_alloc_ind'] = "D";
			break;
		case 1:
			$item['sc_grp_alloc_ind'] = "Y";
			break;
		default:
			$item['sc_grp_alloc_ind'] = "N";
			break;			
		}

		$accessAuth = $GLOBALS['lDB']->get("
			SELECT 
				sc_fun_group.sc_fun_grp_level,
				COUNT(sc_fun_group.sc_fun_grp_level) AS sc_fun_grp_level_count,
				sc_fun_group.sc_group_id
			FROM
				sc_fun_group
				INNER JOIN sc_function ON sc_fun_group.sc_function_id = sc_function.sc_function_id
			WHERE
				sc_fun_group.sc_group_id = '$item[sc_group_id]'
				AND sc_fun_group.sc_function_id != '66'
			GROUP BY
				sc_fun_group.sc_fun_grp_level
		",2);
		$item['fun_level_read'] = "0";
		$item['fun_level_update'] = "0";
		$item['fun_level_mgmnt'] = "0";
		foreach($accessAuth as $authItem) {
			switch($authItem['sc_fun_grp_level']) {
			case 5:
				$item['fun_level_read'] = $authItem['sc_fun_grp_level_count'];
				break;
			case 10:
				$item['fun_level_update'] = $authItem['sc_fun_grp_level_count'];
				break;
			case 15:
				$item['fun_level_mgmnt'] = $authItem['sc_fun_grp_level_count'];
				break;
			}
		}
		

		$propertyAuth = $GLOBALS['lDB']->get("
			SELECT
				COUNT(DISTINCT ac_accomm_type.pr_business_id)
			FROM
				sc_accomm
				INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				sc_accomm.sc_group_id = '$item[sc_group_id]'
				AND pr_business.pr_bus_inactive_yn=0
		",4);
		if ($propertyAuth == $propertyCount) {
			$item['prop_count'] = "All";
		} else {
			$item['prop_count'] = $propertyAuth;
		}
		$inactivePropertyAuth = $GLOBALS['lDB']->get("
			SELECT
				COUNT(DISTINCT ac_accomm_type.pr_business_id)
			FROM
				sc_accomm
				INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				sc_accomm.sc_group_id = '$item[sc_group_id]'
				AND pr_business.pr_bus_inactive_yn=1
		",4);
		if($inactivePropertyAuth > 0) {
			$item['prop_count'] = "<span class=\"txtbr txti\" onmouseover=\"overlib('This group has access to one or more inactive properties.',LEFT,WIDTH,290);\" onmouseout=\"nd();\">$item[prop_count]*</span>";
		}

		$accommAuth = $GLOBALS['lDB']->get("
			SELECT
				COUNT(DISTINCT ac_accomm_type.ac_accomm_type_ix)
			FROM
				sc_accomm
				INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				sc_accomm.sc_group_id = '$item[sc_group_id]'
				AND ac_accomm_type_inactive_yn = 0
				AND pr_business.pr_bus_inactive_yn = 0
		",4);
		if($accommAuth == $accommCount) {
			$item['accomm_count'] = "All";
		} else  {
			$item['accomm_count'] = $accommAuth;
		}
		$inactiveAccommAuth = $GLOBALS['lDB']->get("
			SELECT
				COUNT(DISTINCT ac_accomm_type.ac_accomm_type_ix)
			FROM
				sc_accomm
				INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				sc_accomm.sc_group_id = '$item[sc_group_id]'
				AND (
					ac_accomm_type_inactive_yn = 1
					OR pr_business.pr_bus_inactive_yn = 1
				)
		",4);
		if($inactiveAccommAuth > 0) {
			$item['accomm_count'] = "<span class=\"txtbr txti\" onmouseover=\"overlib('This group has access to one or more inactive accommodation types.',LEFT,WIDTH,350);\" onmouseout=\"nd();\">$item[accomm_count]*</span>";			
		}

		$userAuth = $GLOBALS['lDB']->get("
			SELECT
				COUNT(DISTINCT pr_user.pr_user_id)
			FROM
				sc_user
				INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
				INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
			WHERE
				pr_persona.pr_sys_code < 6
				AND sc_user.sc_group_id = '$item[sc_group_id]'
				AND pr_persona.pr_persona_inactive_yn = '0'
				AND pr_user.pr_user_inactive_yn = '0'
			GROUP BY
				pr_persona.pr_sys_code,
				sc_user.sc_group_id
		",4);
		$item['user_count'] = $userAuth;

		$rows .= showpage($item,$rowHTML);
	}
	#---------------------------------------------------------------------#
	# End of Mike's SQL code                                              #
	# $group_details contains array of rows for display                   #
	#---------------------------------------------------------------------#

	# Generate HTML output
	if ($action != "3") {
		$selectjob = "144";
	} else {
		$selectjob = "147";
	}
}
$GLOBALS['temp']['rows'] = $rows;
$GLOBALS['temp']['total_prop'] = $propertyCount;
$GLOBALS['temp']['total_accomm'] = $accommCount;

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);
