<?php
	require_once(__DIR__ . "/functions.property.php");
	require_once(__DIR__ . "/functions.financial.php");
	require_once(__DIR__ . "/functions.reservation.itinerary.php");
	require_once(__DIR__ . "/class.stock.php");
	require_once(__DIR__ . "/class.minlos.php");
	require_once(__DIR__ . "/functions.specials.php");
	require_once(__DIR__ . '/db.pr_bus_image.php');
	require_once(__DIR__ . '/db.ac_accomm_image.php');
	// require_once(__DIR__ . "/functions.reservation.php");
	// require_once(__DIR__ . "/functions.persona.php");
	
	
	function getAccommRates($rate_type_id, $date) {	
		global $calAccommList;

		if(array_key_exists("calAccommList",$_SESSION) && !is_array($calAccommList)) {
			$calAccommList = $_SESSION['calAccommList'];
		}

		$newTotalArray = array(
			$rate_type_id=>array()
		);
		$endDate = date("Y-m-d", strtotime($date . " +1 day"));			
		
		
		$accomm_types = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_type.ac_accomm_capacity
			FROM
				ac_accomm_type
			WHERE
				ac_accomm_type.ac_accomm_type_ix IN ('" . join("','", $calAccommList) . "')

		", 2);
	
		$unitRateGroup =  $GLOBALS['lDB']->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 1
		",4);
		
		$adultRateGroup =  $GLOBALS['lDB']->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 2
		",4);			
		
		
		foreach ($accomm_types as $ac_accomm_type){

			$rateGroups[] = array(
						"rt_rate_group_ix" => $unitRateGroup,
						"name"	=> "Units",
						"qty"	=> 1);
			$rateGroups[] = array(
						"rt_rate_group_ix" => $adultRateGroup,
						"name"	=> "Adults",
						"qty"	=> $ac_accomm_type['ac_accomm_capacity']);		
		
			$rate = new Rate($ac_accomm_type['ac_accomm_type_ix'],$date,$endDate,$rateGroups,$rate_type_id);
			$periods = $rate->ToPeriods();	

			if(!isset($newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']])) {
				$newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']] = array();
			}

			if(!isset($newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']][$rate->Periods[0]['rt_period_ix']])) {
				$newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']][$rate->Periods[0]['rt_period_ix']] = array(
					'unitTotal'=>0,
					'rateCount'=>0
				);
			}

			if (is_numeric($rate->Periods[0]['rv_item_amt_gross'])){
				$newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']][$rate->Periods[0]['rt_period_ix']]['unitTotal'] += $rate->Periods[0]['rv_item_amt_gross'];
			} else {
				$newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']][$rate->Periods[0]['rt_period_ix']]['unitTotal'] = false;
			}
			$newTotalArray[$rate_type_id][$ac_accomm_type['ac_accomm_type_ix']][$rate->Periods[0]['rt_period_ix']]['rateCount']++;
			
		}

		return $newTotalArray;
	}

	function applicableMinLOS($agentId, $rateTypeId="", $periodId="", $accommId="") {
		// Get a list of MinLOS rules that match our rate type and agent
		// If none are found, we won't check each day on the calendar for MinLOS
		
		$rateWhere = !empty($rateTypeId) ? "AND ml_rate_type.rt_rate_type_id = '" . $rateTypeId . "'" : "";
		$periodWhere = !empty($periodId) ? "AND ml_period.rt_period_id = '" . $periodId . "'" : "";
		$accommWhere = !empty($accommId) ? "AND ml_accomm.ac_accomm_type_id = '" . $accommId . "'" : "";

		$applicableMinLosList = $GLOBALS['lDB']->get("
			SELECT
				ml_rule.ml_rule_ix,
				ml_rate_type.rt_rate_type_id,
				ml_agent.pr_agent_id,
				ml_accomm.ac_accomm_type_id,
				ml_period.rt_period_id
			FROM 
				ml_rule
				LEFT JOIN ml_rate_type ON ml_rate_type.ml_rule_id = ml_rule.ml_rule_ix
				LEFT JOIN ml_period ON ml_period.ml_rule_id = ml_rule.ml_rule_ix
				LEFT JOIN ml_agent ON ml_agent.ml_rule_id = ml_rule.ml_rule_ix
				LEFT JOIN ml_accomm ON ml_accomm.ml_rule_id = ml_rule.ml_rule_ix
			WHERE
				(
					ml_agent.pr_agent_id = '" . $agentId . "'
					OR ml_agent.pr_agent_id IS NULL
				)
				" . $rateWhere . "
				" . $periodWhere . "
				" . $accommWhere . "
		", 2);

		if (!empty($applicableMinLosList)) {
			$minLosRatePeriodsInUse = [];
			$minLosRateTypesInUse = [];
			$minLosAccommsInUse = [];
			foreach ($applicableMinLosList as $minLosRule) {
				$minLosRatePeriodsInUse[] = $minLosRule['rt_period_id'];
				$minLosRateTypesInUse[] = $minLosRule['rt_rate_type_id'];
				$minLosAccommsInUse[] = $minLosRule['ac_accomm_type_id'];
			}
		}
		if (!empty($applicableMinLosList)) {
			return [
				'periods' => array_unique($minLosRatePeriodsInUse),
				'ratetypes' => array_unique($minLosRateTypesInUse),
				'accomms' => array_unique($minLosAccommsInUse)
			];
		}
		return false;
	}

	function currentPeriods($startDate, $endDate) {
		return $GLOBALS['lDB']->get("
			SELECT
				rt_period.rt_period_ix
			FROM
				rt_period
				LEFT JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
			WHERE
				(
					rt_period_dates.rt_period_from >= '" . $startDate . "' 
					AND rt_period_dates.rt_period_from <= '" . $endDate . "' 
				) OR (
					rt_period_dates.rt_period_to >= '" . $startDate . "' 
					AND rt_period_dates.rt_period_to <= '" . $endDate . "' 
				) OR (
					rt_period_dates.rt_period_from <= '" . $startDate . "' 
					AND rt_period_dates.rt_period_to >= '" . $endDate . "' 
				)
			ORDER BY 
				rt_period_dates.rt_period_from,
				rt_period_dates.rt_period_to
		", 3);
	}