<?php

/**
 * init.form7.php - Availability Calendar
 * Job: 20
 * Function: 50 (Availability calendar)
 */

session_set(array(
	'takenStep3'=>false,
	'wizResStatusUpdated'=>true,
	'whichCalendar'=>"availability_calendar"
));

clearTimedOutReservations();

// Form 210 - the brand new calendar, reworked for maximum speed, any status combination, and on screen wizard
if (!array_key_exists($form, $GLOBALS)) {
	$GLOBALS[$form] = "";
}

if (!is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/reservation_calendar.htm");
}

$tempMasterData = $GLOBALS['lDB']->isMaster;
$GLOBALS['lDB']->isMaster = "1";

// Set bookingRate session variable via AJAX
if (
	(isset($_SERVER['argv'][1]) && $_SERVER['argv'][1] == "setBookingRate") &&
	(isset($_SERVER['argv'][2]) && $_SERVER['argv'][2] != "") && 
    (isset($_SERVER['argv'][3]) && $_SERVER['argv'][3] != "")
) {
	session_set("bookingRate",$_SERVER['argv'][2]);
    session_set("bookingRateAgent",$_SERVER['argv'][3]);
	die;
}

// Clear bookingRate session variable via AJAX
if (
	(isset($_SERVER['argv'][1]) && $_SERVER['argv'][1] == "clearBookingRate") &&
	(isset($_SESSION['bookingRate']) && $_SESSION['bookingRate'] != "")
) {
	session_set("bookingRate","");
    session_set("bookingRateAgent","");
	die;
}

$thisSession = array_slice($_SERVER['argv'], 1, 11);

$GLOBALS['wizCancelled'] = false;

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
if (sizeof($_SERVER['argv']) < 3 || $_SERVER['argv'][1] == "CANCEL") {
	if ($_SERVER['argv'][1] == "CANCEL") {
		$GLOBALS['wizCancelled'] = true;
        session_set("wizResId","");
	}

	if(isset($_SESSION['calendarParms']) && is_array($_SESSION['calendarParms'])) {
		$thisSession = $_SESSION['calendarParms'];
	} else {
		$thisSession = array();
	}

	$thisSession = array_pad($thisSession,11,"");

	if($_SERVER['argc'] < 2) {
		$_SERVER['argv'][1] = $thisSession[0];
	} elseif(isset($_SESSION['calendarParms']) && is_array($_SESSION['calendarParms'])) {
		$_SESSION['calendarParms'][0] = $_SERVER['argv'][1];
		session_set("calendarParms",$_SESSION['calendarParms']);
	} else {
		session_set("calendarParms",array($_SERVER['argv'][1]));
	}

	$_SERVER['argv'][2] = $thisSession[1];
	$_SERVER['argv'][3] = $thisSession[2];
	$_SERVER['argv'][4] = $thisSession[3];
	$_SERVER['argv'][5] = $thisSession[4];
	$_SERVER['argv'][6] = $thisSession[5];
	$_SERVER['argv'][7] = $thisSession[6];
	$_SERVER['argv'][8] = $thisSession[7];
	$_SERVER['argv'][9] = $thisSession[8];
	$_SERVER['argv'][10] = $thisSession[9];
	$_SERVER['argv'][11] = $thisSession[10];
} else {
    if(isset($_SESSION['calendarParms'][2]) && is_array($_SESSION['calendarParms'])){
        $thisSession[2] = $_SESSION['calendarParms'][2];
    }
    else {
        $thisSession[2] = (isset($thisSession[2])) ? $thisSession[2] : "";
    }

	session_set("calendarParms",$thisSession);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],13,"");

if ($_SERVER['argv'][12] == "1"){
	$GLOBALS['temp']['maxCalPopup'] = true;
} else {
	$GLOBALS['temp']['maxCalPopup'] = false;
}

$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"), "-") . " " . date("H:i:s");
$GLOBALS['temp']['hideRatePopup'] = "";

if ($userStatusId == 0) {
	$GLOBALS['temp']['hideRatePopup'] = " style=\"visibility: hidden;\"";
}

// Hide pax count for external users ------------------------------------------
$GLOBALS['temp']['intPax'] = "";

if ($userStatusId < 2) {
	$GLOBALS['temp']['intPax'] = "visibility: hidden;";
}

$GLOBALS['temp']['hideAddItinerary'] = " style=\"visibility: hidden;\"";
$GLOBALS['temp']['infoPop'] = "/resource/Resrequest/Application/public/html/info/info_avail_read.htm";
$showAddItinerary = false;
$GLOBALS['temp']['canUseWizard'] = "false";
$GLOBALS['CHECKJOBOVERRIDE'] = true;

if (checkjob(20, 2) > 5 && ($lDB->get("select rf_sys_locked_yn from rf_system", 4) != "1")) {
	$showAddItinerary = true;
	$GLOBALS['temp']['hideAddItinerary'] = "";
	$GLOBALS['temp']['canUseWizard'] = "true";
	$GLOBALS['temp']['infoPop'] = "/resource/Resrequest/Application/public/html/info/info_avail_cal.htm";
}

// Phase 1 (Declare and validate variables) : START ---------------------------
// Paramaters for this page ---------------------------------------------------
$calStartDate			= isset($_SESSION['calStartDate'])?$_SESSION['calStartDate']:"";
$calEndDate				= isset($_SESSION['calEndDate'])?$_SESSION['calEndDate']:"";
$calPropList			= isset($_SESSION['calPropList'])?$_SESSION['calPropList']:"";
$calAccommList		= isset($_SESSION['calAccommList'])?$_SESSION['calAccommList']:"";
$calAgentId				= isset($_SESSION['calAgentId'])?$_SESSION['calAgentId']:"";
$canCalWizard			= isset($_SESSION['canCalWizard'])?$_SESSION['canCalWizard']:"";
$blockRateOverLap	= isset($_SESSION['blockRateOverLap'])?$_SESSION['blockRateOverLap']:"";
$calRateList			= isset($_SESSION['calRateList'])?$_SESSION['calRateList']:"";
$wizResId					= isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : null;

global $calStartDate;
global $calEndDate;
global $calAccommList;
global $calAgentId;
global $canCalWizard;
global $userStatusId;
global $blockRateOverLap;
global $calRateList;
global $principal_id;
global $dbcode;
global $domain;
global $client;

validResId($wizResId);

if (isset($_SESSION['calStepNumber']) && $_SESSION['calStepNumber'] == "2") {
	redirectTo(" reservation.php?639");
}

session_set(array(
	'calStepNumber'=>"1",
	'addedExpiry'=>false
));

if (isset ($_POST['year'])) {
	$calStartDate = $_POST['year'] . "-" . $_POST['select_month'] . "-" . $_POST['select_day'];
} else {
	if (array_key_exists(1, $_SERVER['argv'])) {
		$calStartDate = $_SERVER['argv'][1];
	} else {
		$calStartDate = "";
	}
}

$calPropList = array ();

if (array_key_exists(2, $_SERVER['argv']) && $_SERVER['argv'][2] != "") {
	$calPropList = explode(":", $_SERVER['argv'][2]);
}

$calStatusList = array ();

if (array_key_exists(3, $_SERVER['argv'])) {
	$calStatusList = explode(":", $_SERVER['argv'][3]);
}

$wizAgentId = "";
$GLOBALS['temp']['fAgentId'] = "";

if (array_key_exists(4, $_SERVER['argv'])) {
	$wizAgentId = $_SERVER['argv'][4];
	$GLOBALS['temp']['fAgentId'] = $_SERVER['argv'][4];
}

$calRateList = array ();

if (array_key_exists(5, $_SERVER['argv']) && trim($_SERVER['argv'][5]) != "") {
	$calRateList = explode(":", $_SERVER['argv'][5]);
}

if (array_key_exists(6, $_SERVER['argv'])) {
	$GLOBALS['temp']['fContactId'] = $_SERVER['argv'][6];
} else {
	$GLOBALS['temp']['fContactId'] = "";
}

if (array_key_exists(7, $_SERVER['argv'])) {
	$customCommPerc = $_SERVER['argv'][7];
} else {
	$customCommPerc = "";
}
if (array_key_exists(11, $_SERVER['argv'])) {
	$customCommDeduct = $_SERVER['argv'][11];
} else {
	$customCommDeduct = "";
}

global $userid;

$calLimitDisplay = $GLOBALS['limit_yn'];
$calMaxDisplay = $GLOBALS['sc_grp_avail_limit'];

$GLOBALS['temp']['limitOne'] = "false";

if ( $calLimitDisplay != "0" ) {
	/* ---------------------------------------------------------------------------
	 * If someone has ended up with a negative number for sc_grp_avail_limit, we
	 * need to decide whether to set it to 1 (for public) or a safe(ish) default
	 * of 0 for External users.
	 * ------------------------------------------------------------------------ */
	if ( $calMaxDisplay < 0 ) {
		if ( $userStatusId == 0 ) {
			// Public users only get to see whether there is availability or not -----
			$calMaxDisplay = 1;
		} else {
			// Others get to see availability, but no overbookings -------------------
			$calMaxDisplay = 0;
		}
	}

	if ($calMaxDisplay == "1") {
		$GLOBALS['temp']['limitOne'] = "true";
	}
} else {
	// Even if sc_grp_avail_limit_yn is 0, sc_grp_avail_limit is still considered
	// so we need to explicitly override it here
	$calMaxDisplay = 0;
}

(isMasterDB()) ? $canCalWizard = "1" : $canCalWizard = "0";

// Determine the userStatus ---------------------------------------------------
if ($GLOBALS['pr_sys_code'] == "9") {
	$calAgentId = "0";
	$userStatusId = "3";
} else {
	if ($GLOBALS['pr_business_link'] != "0") {
		$calAgentId = "0";
		$userStatusId = "2";
	} else {
		if ($GLOBALS['is_an_agent']) {
			$calAgentId = $GLOBALS['userid'];
			$userStatusId = "1";
		}
		elseif ($GLOBALS['pr_agent_link'] != "0") {
			$calAgentId = $GLOBALS['pr_agent_link'];
			$userStatusId = "1";
		} else {
			$calAgentId = "0";
			$userStatusId = "0";
		}
	}
}

if ($calAgentId == "0" && isset($wizAgentId) && !empty($wizAgentId)) { $calAgentId = $wizAgentId; }

if ($userStatusId == 1 || $GLOBALS['temp']['fContactId'] == "0" || $GLOBALS['temp']['fContactId'] == "") {
	if ($calAgentId != "0" && $calAgentId != "") {
		$GLOBALS['temp']['fAgentId'] = $calAgentId;
	}
}

$GLOBALS['temp']['canSeePastDates'] = "false";

if ($userStatusId > 1) {
	$GLOBALS['temp']['canSeePastDates'] = "true";
}

$userStatusList = array (
	"0" => "Public",
	"1" => "Agent",
	"2" => "Internal",
	"3" => "System"
);
$userStatusName = $userStatusList[$userStatusId];

(checkJob(29, 0) && $userStatusId > 0) ? $calEnableOcc = "1" : $calEnableOcc = "0";

// Allocation dropdown setup : START ------------------------------------------
$GLOBALS['temp']['allocSelectedIndex'] = 0;
$GLOBALS['temp']['allocOverLibContent'] = "<b>Add agent&#8217;s allocations:</b><br />Number of rooms displayed per day = (total number of rooms) - (blocked rooms) - (reservations) - (all active allocations) + (active allocations applicable to the selected agent).";

// Check if any change to the Allocation dropdown -----------------------------
if ($_SERVER['argv'][8]) {
	$GLOBALS['temp']['allocSelectedIndex'] = $_SERVER['argv'][8];

	switch ($_SERVER['argv'][8]) {
		case 0 :
			$GLOBALS['temp']['allocOverLibContent'] = "<b>Add agent&#8217;s allocations:</b><br />Number of rooms displayed per day = (total number of rooms) - (blocked rooms) - (reservations) - (all active allocations) + (active allocations applicable to the selected agent).";
			break;
		case 1 :
			$GLOBALS['temp']['allocOverLibContent'] = "<b>All allocations deducted:</b><br />Number of rooms displayed per day = (total number of rooms) - (blocked rooms) - (reservations) - (all active allocations).";
			break;
		case 2 :
			$GLOBALS['temp']['allocOverLibContent'] = "<b>Show agent&#8217;s allocations only:</b><br />Number of rooms displayed per day = active allocations applicable to selected agent.";
			break;
		case 3 :
			$GLOBALS['temp']['allocOverLibContent'] = "<b>Add all allocations:</b><br />Number of rooms displayed per day = (total number of rooms) - (blocked rooms) - (reservations) + (all active allocations).";
			break;
		case 4 :
			$GLOBALS['temp']['allocOverLibContent'] = "<b>Show all allocations only:</b><br />Number of rooms displayed per day = all active allocations.";
			break;
	}
}

if ($_SERVER['argv'][9] == "true") {
	$GLOBALS['temp']['provDisabled'] = " disabled=\"disabled\"";
} else {
	$GLOBALS['temp']['provDisabled'] = "";
}

if ($_SERVER['argv'][10] == "true") {
	$GLOBALS['temp']['provCheck'] = " checked=\"checked\"";
}

// Decide whether or not to show the allocations dropdown ---------------------
 ($userStatusId > 0) ? $GLOBALS['temp']['allocDis'] = "style=\"display: block;\"" : $GLOBALS['temp']['allocDis'] = "style=\"display: none;\"";

// Figure out what to show in the dropdown options ----------------------------
if ($userStatusId > 1) { // User is Internal, System or Admin ---------------
	$GLOBALS['temp']['allocDropDown'] = "
		<option value=\"0\" selected=\"selected\">Add agent&#8217;s allocations</option>
		<option value=\"3\">Add all allocations</option>
		<option value=\"1\">All allocations deducted</option>
		<option value=\"2\">Show agent&#8217;s allocations only</option>
		<option value=\"4\">Show all allocations only</option>
	";
}
elseif ($userStatusId == 1) { // User is external -------------------------
	$GLOBALS['temp']['allocDropDown'] = "
		<option value=\"0\" selected=\"selected\">Add agent&#8217;s allocations</option>
		<option value=\"5\">Agent&#8217;s allocations deducted</option>
		<option value=\"2\">Show agent&#8217;s allocations only</option>
	";
} else { // User is general public --------------------------------------------
	$GLOBALS['temp']['allocDropDown'] = "<option value=\"0\"></option>";

}
// Allocation dropdown setup : END --------------------------------------------

$calAllowProvs = $GLOBALS['showProv'];

( $wizResId != "" ) ? $wizLoadContents = "1" : $wizLoadContents = "0";

if ($wizAgentId == "") {
	$wizAgentId = "0";
}

$calProvStatusId = "20";
$defaultStatusList = array (
	"15",
	"20",
	"30",
	"25"
);
$defaultPeriod = "21";
$blockRateOverLap = "0";
$blockRateData = $GLOBALS['lDB']->get("SELECT rf_period_split FROM rf_default", 4);

if ($blockRateData == "2") {
	$blockRateOverLap = "1";
}

// Specials access
if (db_sc_group_get_user_setting("sc_grp_res_sp_apply_auto_yn") == "1"){
	$GLOBALS['temp']['displaySpecialsAccess'] = "true";
} else {
	$GLOBALS['temp']['displaySpecialsAccess'] = "false";
}

if (db_sc_group_get_user_setting("sc_grp_res_sp_apply_man_yn") == "1"){
	$GLOBALS['temp']['applySpecialsAccess'] = "true";
} else {
	$GLOBALS['temp']['applySpecialsAccess'] = "false";
}


// Get default proplist : START -----------------------------------------------
$sql = "select pr_business_id from pr_business where pr_bus_inactive_yn = '0' order by pr_business_parent asc limit 1";
$propMaster = $GLOBALS['lDB']->get($sql, 4);

calAcRecurse($propMaster);

global $calAcRecurseResult;

// Get access control Property List -------------------------------------------
$sql = " SELECT DISTINCT
					ac_accomm_type.pr_business_id, pr_persona.pr_name_last
				FROM
					sc_accomm, ac_accomm_type, pr_business, pr_persona
				WHERE
					sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
				AND
					sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				AND
					ac_accomm_type.ac_accomm_type_inactive_yn=0
				AND
					ac_accomm_type.pr_business_id = pr_business.pr_business_id
				AND
					pr_business.pr_bus_inactive_yn= '0'
				AND
					pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id";

$tempPropData = $GLOBALS['lDB']->get($sql, 2);
$acPropList = array ();
$calPropData = array ();

foreach ($tempPropData as $item) {
	array_push($acPropList, $item[0]);
	$calPropData[$item[0]] = $item[1];
}

$defaultPropList = array ();
foreach ($calAcRecurseResult as $k) {
	if (in_array($k, $acPropList)) {
		array_push($defaultPropList, $k);
	}
}
// Get default proplist : END -------------------------------------------------

// Build the sql to find the default rates for this user ----------------------
if ($userStatusId > "1" && $calAgentId == "0") {
	$sql = "SELECT
							rt_rate_type.rt_rate_type_ix,
							rt_rate_type.rt_rate_type_desc,
							rf_currency.rf_currency_symbol
						FROM
							rt_rate_type, rf_currency
						WHERE
							rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
						AND
							rt_rate_type.rt_rate_type_inactive_yn = '0'
						ORDER BY
							rt_rate_type.rt_rate_type_desc";
} else {
	if ($calAgentId != "0" && !$GLOBALS['lDB']->count("pr_agent_rate", "pr_agent_id", $calAgentId, 0)) {
		$sql = "SELECT
										rt_rate_type.rt_rate_type_ix as rt_rate_type_id,
										rt_rate_type.rt_rate_type_desc,
										rf_currency.rf_currency_symbol
									FROM
										rt_rate_type, rf_currency, pr_agent_rate
									WHERE (rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
										AND pr_agent_rate.pr_agent_id = '$calAgentId')
									AND
										rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
									AND
										rt_rate_type_inactive_yn = '0'
									ORDER BY
										pr_agent_rate.pr_agent_rate_default_yn DESC,
										rt_rate_type.rt_rate_type_desc";
	} else {
		$sql = "SELECT
											rt_rate_type.rt_rate_type_ix as rt_rate_type_id,
											rt_rate_type.rt_rate_type_desc,
											rf_currency.rf_currency_symbol
										FROM
											rf_default_rate
										LEFT JOIN rt_rate_type ON
											rt_rate_type.rt_rate_type_ix = rf_default_rate.rf_default_rate_id
										LEFT JOIN rf_currency ON
											rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
										WHERE
											rt_rate_type_inactive_yn = '0'
										ORDER BY
											rt_rate_type.rt_rate_type_desc";
	}
}

$tempRateData = $GLOBALS['lDB']->get($sql, 2);
$GLOBALS['temp']['bookingDetailClass'] = "expand";
if($userStatusId < 1 && sizeof($tempRateData) == 1) {
	$GLOBALS['temp']['bookingDetailClass'] = "collapse";
}
$defaultRateList = array ();
$calRateData = array ();
$ymax = sizeof($tempRateData);

for ($y = 0; $y < $ymax; $y++) {
	$key = $tempRateData[$y][0];
	array_push($defaultRateList, $key);
	$calRateData[$key] = $tempRateData[$y];
}

// Refresh Room Rate fields on calendar via AJAX
if(isset($_POST['action']) && $_POST['action'] == 5) {
	$starttime = microtime(true);
	$endDate = (new \DateTime($_POST['start_date']))->modify('+20 days')->format('Y-m-d');
	$result = [
		'rates' => [],
		'minLos' => []
	];

	$applicableMinLosList = applicableMinLOS($calAgentId, $_POST['rate_type_id']);
	$currentPeriods = currentPeriods($_POST['start_date'], $endDate);
	$ranMinLos = 0;
	$minLosPeriodMatch = false;
	foreach ($currentPeriods as $periodId) {
		if (!empty($applicableMinLosList['periods']) && in_array($periodId, $applicableMinLosList['periods'])) {
			$minLosPeriodMatch = true;
		}
	}

	$newTotalArray = getAccommRates($_POST['rate_type_id'], $_POST['start_date']);
	$rateSymbol = isset($calRateData[$_POST['rate_type_id']]['rf_currency_symbol']) ? $calRateData[$_POST['rate_type_id']]['rf_currency_symbol'] : "";
	foreach($newTotalArray as $newTotal){
		foreach($newTotal as $accomm_type_id=>$periods){
			$rateTotal = false;
			$rateValue = "TBA";
			foreach($periods as $period){
				if (is_numeric($period['unitTotal'])){
					$rateTotal += $period['unitTotal'];
				}
			}
			if (is_numeric($rateTotal)) {
				fixAmtDisplay($rateTotal);
				$rateValue = $rateTotal." ".$rateSymbol;
			}
			$result['rates'][] = $accomm_type_id.":".$rateValue;

			// Restructure MinLoS data
			$minLos = [];

			// If applicable MinLOS rules were found earlier, and our rate periods are also found amongst those rules, do MinLOS
			if (
				$applicableMinLosList &&
				$minLosPeriodMatch &&
				in_array($accomm_type_id, $applicableMinLosList['accomms']) &&
				in_array($_POST['rate_type_id'], $applicableMinLosList['ratetypes'])
			) {
				$ranMinLos++;
				$minLosByDay = (new MinLOS($accomm_type_id, $_POST['start_date'], $endDate, $_POST['rate_type_id'], $calAgentId))->getMinLOSByDay()['days'];
				foreach ($minLosByDay as $date => $tmpMinLos) {
					$selectorDate = (new \DateTime($date))->format('m:d:Y');
					$tmpMinLos['selector'] = $accomm_type_id . ':' . $selectorDate;
					$tmpMinLos['date'] = $date;
					$minLos[] = $tmpMinLos;
				}
			}
			$result['minLos'][] = ['accommodationType' => $accomm_type_id, 'data' => $minLos];
		}
	}
	// Remove error_log comment to show debugging in error.log
	// error_log("Room Rate calculations (AJAX): " . ceil(microtime(true) - $starttime) . " seconds (ran MinLOS on " . $ranMinLos . " accomm" . ($ranMinLos != 1 ? "s" : "") . ")");
	echo(json_encode($result));
	unset($result);
	exit;
}

// Default dates --------------------------------------------------------------
$defaultStartDate = date("Y-m-d");
$defaultStartDateTime = date("Y-m-d H:i:s");
$defaultStartYear = date("Y");
$defaultStartMonth = date("m");
$defaultStartDay = date("d");

// Validate required calendar variables ---------------------------------------
if ($calStartDate == "") {
	$calStartDate = $defaultStartDate;
	$calStartYear = $defaultStartYear;
	$calStartMonth = $defaultStartMonth;
	$calStartDay = $defaultStartDay;
} else {
	$tempStartDate = explode("-", $calStartDate);
	if(sizeof($tempStartDate) == 3) {
		$tempStartDateFmt = date("Y-m-d", mktime(0, 0, 0, $tempStartDate[1], $tempStartDate[2] + 1, $tempStartDate[0]));
	} else {
		$tempStartDateFmt = "0000-00-00";
	}

	if (sizeof($tempStartDate) == "3" && ($tempStartDateFmt >= $defaultStartDate || $userStatusId > 1)) {
		$calStartYear = $tempStartDate[0];

		if (strlen($calStartYear) != "4") {
			$calStartYear = date("Y");
		}

		$calStartMonth = $tempStartDate[1];

		if ($calStartMonth < 1 || $calStartMonth > 12) {
			$calStartMonth = date("m");
		}

		if ($calStartYear > "2037") {
			$calStartYear = "2037";
		}

		$calStartDay = $tempStartDate[2];

		if ($calStartDay < 1 || $calStartDay > 31) {
			$calStartDay = date("d");
		}
	} else {
		$calStartDate = $defaultStartDate;
		$calStartYear = $defaultStartYear;
		$calStartMonth = $defaultStartMonth;
		$calStartDay = $defaultStartDay;
	}
}

if ($calStartYear == "2037" && $calStartMonth = "12") {
	if ($calStartDay > "30") {
		$calStartDay = "30";
	}
}

$calDateLimit = $GLOBALS['lDB']->get("select rf_date_res_limit from rf_default", 4);
$temp = explode("-", $calDateLimit);
$calDateLimit = date("Y-m-d", mktime(0, 0, 0, $temp[1], $temp[2] - $defaultPeriod +1, $temp[0]));
$temp = explode("-", $calDateLimit);

$GLOBALS['temp']['calDateResLimit'] = $calDateLimit;
$GLOBALS['temp']['calDateResLimitNice'] = chng_date($calDateLimit, "-");

if ($calStartYear > $temp[0] || ($calStartYear == $temp[0] && $calStartMonth > $temp[1]) || ($calStartYear == $temp[0] && $calStartMonth == $temp[1] && $calStartDay > $temp[2])) {
	$calStartYear = $temp[0];
	$calStartMonth = $temp[1];
	$calStartDay = $temp[2];
	$calStartDate = $calDateLimit;
}

$redoStartDate = "0";

if (strlen($calStartDay) == "1") {
	$calStartDay = str_pad($calStartDay, 2, "0", STR_PAD_LEFT);
	$redoStartDate = "1";
}

if (strlen($calStartMonth) == "1") {
	$calStartMonth = str_pad($calStartMonth, 2, "0", STR_PAD_LEFT);
	$redoStartDate = "1";
}

$calStartDate = $calStartYear . "-" . $calStartMonth . "-" . $calStartDay;

// Validate the statusList ----------------------------------------------------
if ( !is_array($calStatusList) ) {
	$calStatusList = $defaultStatusList;
} else {
	$allowedStatusList = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id FROM rf_reservation_status",3);
	$tempStatusList = array ();

	$bmax = sizeof($allowedStatusList);
	for ($b = 0; $b < $bmax; $b++) {
		if (in_array($allowedStatusList[$b], $calStatusList)) {
			array_push($tempStatusList, $allowedStatusList[$b]);
		}
	}

	if ( sizeof($tempStatusList) == 0 || $tempStatusList[0] == "0" ) {
		$calStatusList = $defaultStatusList;
	} else {
		$calStatusList = $tempStatusList;
		unset ($tempStatusList);
	}
}

// Validate the propList ------------------------------------------------------
if (!is_array($calPropList)) {
	$calPropList = $defaultPropList;
} else {
	$tempPropList = array ();
	$cmax = sizeof($defaultPropList);

	for ($c = 0; $c < $cmax; $c++) {
		if (in_array($defaultPropList[$c], $calPropList)) {
			array_push($tempPropList, $defaultPropList[$c]);
		}
	}

	if (sizeof($tempPropList) == 0) {
		$calPropList = $defaultPropList;
	} else {
		$calPropList = $tempPropList;
		unset ($tempPropList);
	}
}

// Validate the rateList ------------------------------------------------------
if (!is_array($calRateList)) {
	$calRateList = $defaultRateList;
} else {
	$tempRateList = array ();
	$pmax = sizeof($calRateList);

	for ($p = 0; $p < $pmax; $p++) {
		if (in_array($calRateList[$p], $defaultRateList)) {
			array_push($tempRateList, $calRateList[$p]);
		}
	}

	if (sizeof($tempRateList) == 0) {
		$calRateList = $defaultRateList;
	} else {
		$calRateList = $tempRateList;
		unset ($tempRateList);
	}
}

// Get default rateTypeId -----------------------------------------------------
 ($wizAgentId != "0" && $wizAgentId != "") ? $defRateIdSql = "select rt_rate_type_id from pr_agent where pr_agent_id = '$wizAgentId'" : $defRateIdSql = "select rt_rate_type_id from rf_default";

$defaultRateId = $GLOBALS['lDB']->get($defRateIdSql, 4);

// For now, only have 1 rate --------------------------------------------------
if (sizeof($calRateList) > 1) {
	$calRateList = array (
		$defaultRateId
	);
}

if (sizeof($calRateList) < 1) {
	$calRateList = array (
		"0"
	);
}

// Generate the AccommList and the availability data array to be used for availability calculation
$tempAvailData = array ();
$calAccommList = array ();
$calAccommData = array ();

$sql = "SELECT
				sc_accomm.ac_accomm_type_id
			FROM
      	sc_accomm
			INNER JOIN sc_user ON
      	sc_accomm.sc_group_id = sc_user.sc_group_id
			AND
      sc_user.pr_user_id = '" . $GLOBALS['userid'] . "'";

$accommList = $GLOBALS['lDB']->get($sql, 3);

$dmax = sizeof($calPropList);

for ($d = 0; $d < $dmax; $d++) {
	$propId = $calPropList[$d];
	$sql = "SELECT
							ac_accomm_type_ix,
							ac_accomm_desc,
		    			ac_accomm_name_short
						FROM
		        	ac_accomm_type
		        WHERE
		        	pr_business_id = '$propId'
						AND
		        	ac_accomm_type_inactive_yn=0
						AND
		        	ac_accomm_type_ix IN ('" . join("','", $accommList) . "')
						ORDER BY
		        	ac_accomm_type.pr_business_id,
							ac_accomm_type.ac_accomm_sequence";

	$tempResult = $GLOBALS['lDB']->get($sql, 2);
	$tempAvailData[$propId] = array ();
	$emax = sizeof($tempResult);

	for ($e = 0; $e < $emax; $e++) {
		$key = $tempResult[$e][0];

		if (!array_key_exists('ac_accomm_no_of_units', $tempResult[$e])) {
			$tempResult[$e]['ac_accomm_no_of_units'] = "";
		}

		$tempResult[$e][3] = $tempResult[$e]['ac_accomm_no_of_units'];
		$tempResult[$e]['ac_accomm_no_of_units'] = $lDB->get("SELECT
				COUNT(*)
			FROM
				ac_accomm_room
			WHERE
				ac_accomm_type_id = '" . $key . "'
			AND
				ac_accomm_room_inactive_yn = 0
			", 4);
		$tempAvailData[$propId][$key] = array ();
		$calAccommData[$key] = $tempResult[$e];

		array_push($calAccommList, $tempResult[$e][0]);
	}
}

// Generate the daylist for the calendar --------------------------------------
$calDateList = array ();
$calDateKeyList = array ();

for ($k = 0; $k < $defaultPeriod; $k++) {
	$date = date("Y-m-d", mktime(0, 0, 0, $calStartMonth, $calStartDay + $k, $calStartYear));
	$calDateList[$k] = $date;
	$calDateKeyList[$date] = "0";
}

$endDateId = $defaultPeriod -1;
$calEndDate = $calDateList[$endDateId];

$tempEndDate = explode("-", $calEndDate);
$newEndDate = date("Y-m-d", mktime(0, 0, 0, $tempEndDate[1], $tempEndDate[2] + 1, $tempEndDate[0]));

// Get the right periodId -----------------------------------------------------
$sql = "SELECT
				rt_period.rt_period_ix,
				rt_period_date_from,
				rt_period_date_to,
				rt_period_desc
		 FROM
				rt_period
		 WHERE
				(rt_period.rt_period_date_from >= '$calStartDate' AND rt_period.rt_period_date_from <= '$calEndDate')
		 OR
				(rt_period.rt_period_date_to >= '$calStartDate' AND rt_period.rt_period_date_to <= '$calEndDate')
		 OR
				(rt_period.rt_period_date_from < '$calStartDate' AND rt_period.rt_period_date_to > '$calEndDate')
		 ORDER BY
				rt_period_date_from
		 LIMIT 1";

$tempAcPeriod = $GLOBALS['lDB']->get($sql, 1);
$calAcPeriodId = $tempAcPeriod[0];

// Determine Month(s) and Year(s) ---------------------------------------------
$temp = explode("-", $calEndDate);
$calEndYear = $temp[0];

if (strlen($calEndYear) != "4") {
	$calEndYear = date("Y");
}

$calEndMonth = $temp[1];

if ($calEndMonth < 1 || $calEndMonth > 12) {
	$calEndMonth = date("m");
}

$calEndDay = $temp[2];

if ($calEndDay < 1 || $calEndDay > 31) {
	$calEndDay = date("d");
}

$startMonthName = date("F", mktime(0, 0, 0, $calStartMonth, $calStartDay, $calStartYear));
$startYear = date("Y", mktime(0, 0, 0, $calStartMonth, $calStartDay, $calStartYear));
$stopMonthName = date("F", mktime(0, 0, 0, $calEndMonth, $calEndDay, $calEndYear));
$stopYear = date("Y", mktime(0, 0, 0, $calEndMonth, $calEndDay, $calEndYear));

// Determine Full Weekend Dates -----------------------------------------------
$weekendList = makeDates($calStartDate, $defaultPeriod, "Y-m-d", 1);

// Setup the table heads ------------------------------------------------------
$headDateList = makeDates($calStartDate, $defaultPeriod, "d");
$dayNameList = makeDates($calStartDate, $defaultPeriod, "D");

$wmax = sizeof($headDateList);

for ($w = 0; $w < $wmax; $w++) {
	$date = $headDateList[$w];
	$GLOBALS['temp']["cHD" . $w] = $date;
	$GLOBALS['temp']['day' . $w] = substr($dayNameList[$w],0,1);

	if (in_array($calDateList[$w], $weekendList)) {
		$GLOBALS['temp']["cHC" . $w] = "wkEndNoBorder";
		$GLOBALS['temp']['day' . $w . 'style'] = "wkEndNoBorder";
	} else {
		$GLOBALS['temp']["cHC" . $w] = "wkNoBorder";
		$GLOBALS['temp']['day' . $w . 'style'] = "wkNoBorder";
	}
}

// Get empty rate data for each rate type.  We populate this with Ajax now
$accommRateData = array ();
$agmax = sizeof($defaultRateList);

for ($ag = 0; $ag < $agmax; $ag++) {
	$rateId = $defaultRateList[$ag];
	$accommRateData[$rateId] = array ();
}

$GLOBALS['temp']['canOccCal'] = " style=\"visibility: hidden;\"";

if (checkJob("29")) {
	if ($userStatusId > "0") {
		$GLOBALS['temp']['canOccCal'] = "";
	}
}

$GLOBALS['temp']['isProv'] = "0";

if (array_key_exists('allowProvs', $GLOBALS['temp']) && $GLOBALS['temp']['allowProvs'] == "0" && $_SERVER['argv'][9] != "true") {
	$GLOBALS['temp']['provDisabled'] = "";
}

if ( $calAllowProvs == "0" ) {
	if (!in_array("20", $calStatusList)) {
		array_push($calStatusList, "20");
	}
	$GLOBALS['temp']['provCheck'] = " checked=\"checked\"";
	$GLOBALS['temp']['provDisabled'] 	= " disabled=\"disabled\"";
	$GLOBALS['temp']['showProvCheckbox'] = "visibility: hidden;";
	$GLOBALS['temp']['isProv'] = "1";
} else {
	// Provisionals is passed in arguments, but prov status is not included. Include it.
	if ($_SERVER['argv'][10] == "true" && !in_array("20", $calStatusList)) {
		array_push($calStatusList, "20");
	}

	$GLOBALS['temp']['showProvCheckbox'] = "";
	if (in_array("20", $calStatusList)) {
		$GLOBALS['temp']['provCheck'] = " checked=\"checked\"";
		$GLOBALS['temp']['isProv'] = "1";
	} else {
		$GLOBALS['temp']['isProv'] = "0";
	}
}
// end backwards compatability

// Phase 4 (Prepare result output for display) : START ------------------------
$calAccommNotes = array ();
$calAccommNotesKey = array ();

$aemax = sizeof($calAccommList);
for ($ae = 0; $ae < $aemax; $ae++) {
	$accommId = $calAccommList[$ae];
	$sql = "
				SELECT
					ac_accomm_note
				FROM
					ac_accomm_type
				WHERE
					ac_accomm_type_ix = '$accommId'";

	$accommNote = $GLOBALS['lDB']->get($sql, 4);
	$strpos = strpos($accommNote, ">");

	if ($strpos === false) {
		$strpos = 0;
	}
	$calAccommNotesOriginal[$accommId] = t_encodeOverlib($accommNote);
	$accommNote = t_encodeOverlib(substr($accommNote, 0, $strpos) . "<b>" . $calAccommData[$accommId][1] . "</b> " . substr($accommNote, $strpos));

	$calAccommNotesKey[$accommId] = $accommNote;

	array_push($calAccommNotes, $accommNote);
}

$calPropNotes = array ();
$calPropNotesKey = array ();
$admax = sizeof($calPropList);

for ($ad = 0; $ad < $admax; $ad++) {
	$propid = $calPropList[$ad];

	$sql = "
				SELECT
					pr_bus_memo_cal
				FROM
					pr_business
				WHERE
					pr_business_id = '$propid'";

	$propNote = $GLOBALS['lDB']->get($sql, 4);
	// $propNote = preg_replace("(\r\n|\n|\r)", "<br />", $propNote);
	$strpos = strpos($propNote, ">");

	if ($strpos === false) {
		$strpos = 0;
	}
	$calPropNotesOriginal[$propid] = t_encodeOverlib($propNote);
	$propNote = t_encodeOverlib(substr($propNote, 0, $strpos) . "<b>" . $calPropData[$propid] . "</b> " . substr($propNote, $strpos));

	$calPropNotesKey[$propid] = $propNote;

	array_push($calPropNotes, $propNote);
}

// Show the hand if you have write access -------------------------------------
$hand = "";

if (checkJob($_SERVER['argv'][0], 2) > 5) {
	$hand = " cursor: pointer;";
}

$hasAllocations = false;
if( trim($wizAgentId) != "" && $wizAgentId != "0" ) {
	// True if agent has allocations
	$hasAllocations = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_agent_id = '$wizAgentId'
			AND rv_reservation.rf_reservation_status_id = '15'
	",4) > 0;
}

$availArray = array();
$resItemList = join(":", $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$wizResId'", 3));
$stock = new Stock(false, $calStartDate, $calEndDate, false, false, false, $resItemList);
$starttime = microtime(true);
$ranMinLos = 0;
foreach ($calAccommList as $accommId) {
	$stock->SetAccommTypeId($accommId);

	$propertyId = $GLOBALS['lDB']->get("
				SELECT
					ac_accomm_type.pr_business_id
				FROM
					ac_accomm_type
				INNER JOIN pr_business ON
					pr_business.pr_business_id = ac_accomm_type.pr_business_id
				WHERE
					ac_accomm_type.ac_accomm_type_ix = '" . $accommId . "'
			", 4);

	$propertyName = $GLOBALS['lDB']->get("
				SELECT
					pr_persona.pr_name_last
				FROM
					ac_accomm_type
				INNER JOIN pr_business ON
					pr_business.pr_business_id = ac_accomm_type.pr_business_id
				INNER JOIN pr_persona ON
					pr_persona.pr_persona_ix = pr_business.pr_business_id
				WHERE
					ac_accomm_type.ac_accomm_type_ix = '" . $accommId . "'
			", 4);

	$availArray[$accommId]['propertyId'] = $propertyId;
	$availArray[$accommId]['propertyName'] = $propertyName;
	$availArray[$accommId]['accomm_name'] = $calAccommData[$accommId]['ac_accomm_desc'];

	$accommMax = $stock->ToAccommMax();
	$accommMin = $stock->ToAccommMin();

	if ($accommMax != $accommMin) {
		$availArray[$accommId]['units'] = $accommMin . " - " . $accommMax;
	} else {
		$availArray[$accommId]['units'] = $accommMax;
	}

	// Figure out whether to show Provisionals and Allocations ------------------
	$availArgs = array (
		true,
		true,
		true,
		0
	);

	(in_array("20", $calStatusList)) ? $availArgs[0] = true : $availArgs[0] = false;
	(in_array("15", $calStatusList)) ? $availArgs[1] = true : $availArgs[1] = false;

	$addAgentAllocation = true;
	if($_SERVER['argv'][8] == 5) {
		$addAgentAllocation = false;
	}
	switch ($_SERVER['argv'][8]) {
	case 0:
	case 1:
	case 3:
	case 5:
	default:
		$availArray[$accommId]['availability'] = $stock->ToAvailability($availArgs[0], $availArgs[1], $availArgs[2], $availArgs[3],$addAgentAllocation);
		break;
	case 2:
	case 4:
		$availArray[$accommId]['availability'] = $stock->ToAllocation();
		break;
	}

	// Accommodation Name -------------------------------------------------------
	$availArray[$accommId]['accommName'] = $calAccommData[$accommId]['ac_accomm_desc'];

	// Blocked Rooms ------------------------------------------------------------
	$availArray[$accommId]['block'] = $stock->ToBlock();
	$availArray[$accommId]['roomsForToday'] = $stock->ToAccomm();
	$availArray[$accommId]['provisionals'] = $stock->ToProvisional();
	$availArray[$accommId]['waitlist'] = $stock->ToWaitlist();
	$rateId = isset($rateId) ? $rateId : false;

	$applicableMinLosList = applicableMinLOS(
		$calAgentId,
		isset($rateId) ? $rateId : "",
		$calAcPeriodId,
		$accommId
	);

	if ($applicableMinLosList) {
		$availArray[$accommId]['minlos'] = (new MinLOS($accommId, $calStartDate, $calEndDate, $rateId, $calAgentId))->getMinLOSByDay()['days'];
		$ranMinLos++;
	} else {
		$availArray[$accommId]['minlos'] = [];
	}
	
	// Room Rates ---------------------------------------------------------------
	foreach ($calRateList as $rateId) {
		$temp = getRateDates(array (
			"accommType" => $accommId,
			"rateType" => $rateId,
			"startDate" => $calStartDate,
			"endDate" => $calStartDate
		));

		if (sizeof($temp) > 0) {
			$accommAcPeriodId = $temp[0]['acPeriodId'];
		} else {
			$accommAcPeriodId = "";
		}

		$rateSymbol = isset($calRateData[$rateId]['rf_currency_symbol'])?$calRateData[$rateId]['rf_currency_symbol']:"";
		$rateValue = "<img src=\"/resource/Resrequest/Application/public/img/wait16.gif\">";

		$availArray[$accommId]['rate'] = $rateValue;

		$getRateDates = array ();

		$getRateDates['accommType'] = $accommId;
		$getRateDates['rateType'] = $rateId;
		$getRateDates['startDate'] = $calStartDate;
		$getRateDates['endDate'] = $calEndDate;

		$prdDates = getRateDates($getRateDates);

		$propName = isset($propName) ? $propName : "";
		$accommName = isset($accommName) ? $accommName : "";
	}

	if($hasAllocations) {
		$agentAlloc[$accommId] = $stock->ToAllocationAgent(true, $wizAgentId);
	} else {
		$agentAlloc[$accommId] = array();
	}

	switch ($_SERVER['argv'][8]) {
		// Include selected agent's allocations in availability calculations
		case 0 :
		default :
			$allocDefault = false;
			if ( count($agentAlloc[$accommId]) == 0 ) {
				$allocDefault = true;
				$agentAlloc[$accommId] = $stock->ToAllocation();
			}
			foreach ($agentAlloc[$accommId] as $agentId => $agentData) {
				foreach ($availArray[$accommId]['availability'] as $date => $avail) {
					if ( $agentId == $wizAgentId && $userStatusId > 1 ) {
						if (array_key_exists($date, $agentAlloc[$accommId][$agentId]['total_balance'])) {
							$availArray[$accommId]['availability'][$date] += $agentAlloc[$accommId][$agentId]['total_balance'][$date];
							if ($availArray[$accommId]['availability'][$date] > $availArray[$accommId]['roomsForToday'][$date]) {
								$availArray[$accommId]['availability'][$date] = $availArray[$accommId]['roomsForToday'][$date];
							}
						}
					}
					// Add an allocation section ----------------------------------------
					$availArray[$accommId]['allocation'][$date] = false;
					if ( $allocDefault ) {
						if ( $agentAlloc[$accommId][$date] > 0 && $userStatusId > 0 ) {
							$availArray[$accommId]['allocation'][$date] = true;
						}
					} else {
						if ( isset($agentData['total_balance'][$date]) && $agentData['total_balance'][$date] > 0 && $userStatusId > 0 ) {
							$availArray[$accommId]['allocation'][$date] = true;
						}
					}
				}
			}
			break;
		// ALL allocations should not show in availability
		case 1:
		// Show all allocations only
		case 4:
		// Agent's allocations deducted
		case 5:
			break;
		// Only show selected agent's allocations
		case 2 :
			foreach ($availArray[$accommId]['availability'] as $date => $avail) {
				// Set each day's availability to 0 as we only want to show agent's
				// allocations ----------------------------------------------------------
				$availArray[$accommId]['availability'][$date] = 0;
				foreach ($agentAlloc[$accommId] as $agentId => $agentData) {
					// Match the agent in $agentAlloc to $wizAgentId ----------------------
					if ($agentId == $wizAgentId || $agentId == $calAgentId) {
						if (array_key_exists($date, $agentAlloc[$accommId][$agentId]['total_balance'])) {
							// Set agent's allocation information as the availability for this
							// day ------------------------------------------------------------
							$availArray[$accommId]['availability'][$date] = $agentAlloc[$accommId][$agentId]['total_balance'][$date];
							// Make sure we don't show more rooms than actually exist! --------
							if ($availArray[$accommId]['availability'][$date] > $availArray[$accommId]['roomsForToday'][$date]) {
								$availArray[$accommId]['availability'][$date] = $availArray[$accommId]['roomsForToday'][$date];
							}
						}
					}
				}
			}
			break;
		// Add all agent allocations to availability
		case 3:
			$agentAlloc[$accommId] = $stock->ToAllocation();
			foreach ($availArray[$accommId]['availability'] as $date => $avail) {
				$availArray[$accommId]['availability'][$date] += $agentAlloc[$accommId][$date];
				if ($availArray[$accommId]['availability'][$date] > $availArray[$accommId]['roomsForToday'][$date]) {
					$availArray[$accommId]['availability'][$date] = $availArray[$accommId]['roomsForToday'][$date];
				}
				// Add an allocation section -------------------------------------------
				if ( $agentAlloc[$accommId][$date] > 0 ) {
					$availArray[$accommId]['allocation'][$date] = true;
				} else {
					$availArray[$accommId]['allocation'][$date] = false;
				}
			}
			break;
	}
}

//debug($availArray);
// Remove error_log comment to show debugging in error.log
// error_log("Initial Stock calculations: " . ceil(microtime(true) - $starttime) . " seconds (ran MinLOS on " . $ranMinLos . " accomm" . ($ranMinLos != 1 ? "s" : "") . ")");
// Decide whether to show the allocation indicator
$showAllocationIndicator = false;
$showWaitlistIndicator = false;
if($GLOBALS['userStatusId'] > 1) { // Always show to internal users
	$showAllocationIndicator = true;
	$showWaitlistIndicator = true;
} else {
	$agentCheck = $GLOBALS['lDB']->get("SELECT pr_agent_show_allocs_ind FROM pr_agent WHERE pr_agent_id = '$calAgentId'",4);
	if($agentCheck == "1") { // 0 = system default, 1 = show, 2 = hide
		$showAllocationIndicator = true;
	} elseif($agentCheck == "0") {
		if($GLOBALS['sc_grp_alloc_ind'] == "1") {
			$showAllocationIndicator = true;
		} elseif($GLOBALS['sc_grp_alloc_ind'] == "0") {
			$defaultCheck = $GLOBALS['lDB']->get("SELECT rf_show_allocs_yn FROM rf_default",4);
			if($defaultCheck == "1") {
				$showAllocationIndicator = true;
			}
		}
	}
}




$html = "";
$outputPropertyName = "";
$outputAccommType = "";
$currentPropertyId = "";

foreach ($availArray as $accommId => $v) {
	$html .= "<tr style=\"height: 20px;\" id=\"" . $accommId . "\">";

	if ($userStatusId < 2) {
		$accommClickStyle = "style=\"cursor: default;\"";
		$accommClickFunction = "";
	} else {
		$accommClickStyle = " style=\"cursor: pointer;\"";
		$accommClickFunction = "onclick=\"accommClick('" . $v['propertyId'] . "','');\"";
	}

	if ($calPropNotesKey[$v['propertyId']] != "") {
		$propNote = $calPropNotesKey[$v['propertyId']];
		$propSpanStart = "<span onmouseover=\"overlib('" . $propNote . "',OFFSETX,10,WIDTH,350)\" onmouseout=\"nd()\" " . $accommClickStyle . " " . $accommClickFunction . ">";
		$propSpanStop = "</span>";
	} else {
		$propSpanStart = "";
		$propSpanStop = "";
	}

	if ($outputPropertyName != $v['propertyName']) {
		$currentPropertyId = $v['propertyId'];
		$images = array();

		$principal_id = substr($lDB->name, 8);
		$image_path = $GLOBALS['http'].$GLOBALS['images_dir'].'/'.$principal_id.'/business_structure/'.$currentPropertyId.'/';

		$image_data = get_bus_image_listing_names($currentPropertyId);
		if (!empty($image_data)) {
			foreach($image_data as $image) {
				$images[] = $image_path.$image['pr_bus_image_filename'];
			}
		}

		$html .= "<td colspan=\"23\" class=\"colLt bl bb br txtb\" style=\"padding: 0 2px;\">";
		$html .= "<span style=\"cursor: pointer; cursor: hand; position:relative; top:2px;\"><img src=\"/resource/Resrequest/Application/public/img/info.png\" style=\"height:13px; padding-right:3px;\" onclick=\"showPropertyInfo(event, '".t_encodeOverlib(t_encodeHTMLField($v['propertyName']))."', '".$calPropNotesOriginal[$currentPropertyId]."', '".implode(",", $images)."');\"></span>";
		$html .= $propSpanStart . t_encodeHTMLField($v['propertyName']) . $propSpanStop;
		$html .= "</td>";

		// Property name row collapse. Stupid idea. Commented pending final confirmation
		//$html .= "<td colspan=\"2\" align=\"right\" class=\"colLt bb br\" style=\"padding: 0 1px;\"><input type=\"button\" id=\"btn_" . $v["propertyId"] . "\" onclick=\"showHide('" . $accommId . "',this.id,'Vertical');\" class=\"button bCollapseVertical\" style=\"width: 18px; height: 18px; background-position: 0 0;\" value=\"\" /></td>";

		$html .= "</tr><tr style=\"height: 20px;\">";
		$outputPropertyName = $v['propertyName'];
	}

	// Accommodation Name -------------------------------------------------------
	$accommSpanStart = "";
	$accommSpanStop = "";
	$accommNote = "";
	$images = array();

	if ($calAccommNotesKey[$accommId] != "") {
		$accommNote = $calAccommNotesKey[$accommId];
		$accommSpanStart = "<span onmouseover=\"overlib('" . $accommNote . "',OFFSETX,10,WIDTH,350)\" onmouseout=\"nd()\">";
	}

	$principal_id = substr($lDB->name, 8);
	$image_path = $GLOBALS['http'].$GLOBALS['images_dir'].'/'.$principal_id.'/business_structure/'.$currentPropertyId.'/'.$accommId.'/';

	$image_data = get_accomm_image_listing_names($accommId);
	if (!empty($image_data)) {
		foreach($image_data as $image) {
			$images[] = $image_path.$image['ac_accomm_image_filename'];
		}
	}

	$html .= "<td width=\"163\"class=\"bl br bb\"" . $accommClickStyle . " " . $accommClickFunction . ">";
	$html .= "<span style=\"position:relative; top:2px;\"><img src=\"/resource/Resrequest/Application/public/img/info.png\" style=\"height:13px; padding-right:3px;\" onclick=\"showPropertyInfo(event, '".t_encodeHTMLField($v['accomm_name'])."', '".$calAccommNotesOriginal[$accommId]."', '".implode(",", $images)."');\"></span>";
	$html .= $accommSpanStart . "&nbsp;" . t_encodeHTMLField($v['accomm_name']) . "</span>";
	$html .= "</td>";

	// Rates --------------------------------------------------------------------
	$html .= "<td width=\"65\" id=\"rate" . $accommId . "\" class=\"g1C\">&nbsp;" . $v['rate'] . "</td>";

	// Daily availability -------------------------------------------------------
	$keyNumber = 0;
	foreach ($v['availability'] as $date => $a) {
		$accommBlock = 0;
		$selected = "0";

		// Limit the stock display based on user access -----------------------------
		if ( $calMaxDisplay ) {
			if ( $a > $calMaxDisplay ) {
				$a = $calMaxDisplay;
			}
		}

		// Need to figure out when a user is not allowed to see overbookings --------
		if ( $calLimitDisplay || $calMaxDisplay ) {
			if ( $a < 0 ) {
				$a = 0;
			}
		}

		$display_a = $a;

		if ( $selected == "0" ) {
			$accommRatePeriodId = "0";
			$prDatesMax = sizeof($prdDates);
			for ( $foo = 0; $foo < $prDatesMax; $foo++ ) {
				$start = $prdDates[$foo]['rt_period_date_from'];
				$end = $prdDates[$foo]['rt_period_date_to'];

				if ( $date <= $end && $date >= $start ) {
					$accommRatePeriodId = $prdDates[$foo]['acPeriodId'];

					if ( $date == $start ) {
						$selected = "1";
					}
				}
			}
		}

		if ($v['block'][$date] >= $v['roomsForToday'][$date]) {
			$cellClass = "blockNoBorder";
			$accommBlock = 1;
			if ($a == 0) {
				$display_a = "&nbsp;";
			}
		} else {
			$cellClass = "g1C";
		}

		// Decide what style to apply to the cell ---------------------------------
		if ($a <= 0) {
			if ($cellClass != "blockNoBorder") {
				$cellClass = "overbooking";
			}
		} else {
			if (in_array($date, $weekendList)) {
				if ($cellClass != "block") {
					$cellClass = "wkEndNoBorder";
				}
			}
		}

		if ( $v['provisionals'][$date] > 0 && in_array("20",$calStatusList)) {
			$display_a .= "*";
		}

		// For public users, no actual numbers are shown ----------------------
		// No, this in fact is not the case. Only if users are limited to 1
		// then no info is shown. Bah. Please supply me with a spec next time.
		// Thank you so very much.
		if ( $calMaxDisplay == 1 ) {
			$display_a = "&nbsp;";
		}

		// Organise dates ---------------------------------------------------------
		$thisDate = explode("-", $date);
		$day = date("d", mktime(0, 0, 0, $thisDate[1], $thisDate[2], $thisDate[0]));
		$month = date("m", mktime(0, 0, 0, $thisDate[1], $thisDate[2], $thisDate[0]));
		$year = date("Y", mktime(0, 0, 0, $thisDate[1], $thisDate[2], $thisDate[0]));

		$indicator = 0;
		// Allocation indicator -----------------------------------------------------
		if ($showAllocationIndicator && isset($availArray[$accommId]['allocation']) && $availArray[$accommId]['allocation'][$date]) {
			//$cellClass .= " allocationIndicator";\
			$indicator += 1;
		}

		if($showWaitlistIndicator && $v['waitlist'][$date] > 0) {
			$indicator += 4;
		}
		$cellClass .= " calIndicator" . $indicator;

		if (
			isset($v['minlos'][$date]['minLos']) &&
			$v['minlos'][$date]['minLos'] > 0
		) {
			$cellClass .= ' calIndicator16';
		}

		$html .= "<td width=\"25\" unselectable=\"on\" ab=\"" . $accommBlock . "\" style=\"border-top: none; " . $hand . "\" name=\"" . t_encodeOverlib(str_replace("'", "", $accommId . ":" . str_replace(":", "|", $v['propertyName']) . ":" . str_replace(":", "|", $v['accomm_name']) . ":" . $display_a . ":" . $keyNumber . ":" . $accommRatePeriodId . ":" . $selected)) . "\" id=\"" . t_encodeOverlib(str_replace("'", "", $accommId . ":" . $month . ":" . $day . ":" . $year)) . "\" darkness=\"0\" onmousedown=\"mouseDownFunction(arguments[0]);\" onmouseup=\"cMouseUp(arguments[0]);\" onmouseover=\"mouseOverFunction(arguments[0]);\" class=\"" . $cellClass . "\">" . $display_a . "</td>\n";
		$keyNumber++;
	}
	$html .= "</tr>";
}

$GLOBALS['temp']['rows'] = $html;
// Phase 4 : END --------------------------------------------------------------

// Phase 5 (Echo variables) : START -------------------------------------------
if (array_key_exists(5, $_SERVER['argv'])) {
	$rateId = $_SERVER['argv'][5];
} else {
	$rateId = "";
}

if (!in_array($rateId, $defaultRateList)) {
	$rateId = "";
}
if(trim($rateId) == "" || $rateId == "0") {
	$rateId = $GLOBALS['lDB']->get("
		SELECT
			pr_agent_rate.rt_rate_type_id
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		WHERE
			pr_agent_id = '$calAgentId'
		ORDER BY
			pr_agent_rate_default_yn DESC,
			rt_rate_type.rt_rate_type_desc ASC
	",4);
	if(trim($rateId) == "" || $rateId == "0") {
		if ($userStatusId == "0"){
			$rateId = $GLOBALS['lDB']->get("select rf_default_rate_id from rf_default_rate", 4);
		} else {
			$rateId = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
		}
	}
}

if (isset($_SESSION['bookingRate']) && $_SESSION['bookingRate'] != "" && isset($_SESSION['bookingRateAgent']) && $_SESSION['bookingRateAgent'] == $calAgentId) {
    $rateId = $_SESSION['bookingRate'];
}

$rateInfo = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix = '$rateId'
",1);

$GLOBALS['temp']['rateSelect'] = "
	<input type=\"text\" disabled id=\"rateSelectLabel\" value=\"$rateInfo[rt_rate_type_desc], $rateInfo[rf_currency_symbol]\">
	<input type=\"hidden\" id=\"rateSelect\" value=\"$rateId\">";

$GLOBALS['temp']['calendar_data'] = "var accommnotes = new Array(\"" . join('","', $calAccommNotes) . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var accommIdList = new Array(\"" . join('","', $calAccommList) . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var middledate = \"" . $calStartDay . "-" . $calStartMonth . "-" . $calStartYear . "\";\n";
$GLOBALS['temp']['calendar_data'] .= "var middledateR = \"" . $calStartDate . "\";\n";
$GLOBALS['temp']['calendar_data'] .= "var days = new Array(" . join(",", makeDates($calStartDate, $defaultPeriod, "j")) . ");\n";
$GLOBALS['temp']['calendar_data'] .= "var weekends = new Array(" . join(",", makeDates($calStartDate, $defaultPeriod, "Ymd", 1)) . ");\n";
$GLOBALS['temp']['calendar_data'] .= "var months = new Array(\"" . $calStartMonth . "\",\"" . $calEndMonth . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var years = new Array(\"" . $calStartYear . "\",\"" . $calEndYear . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var propertylist = new Array(";

$acmax = sizeof($defaultPropList);

for ($ac = 0; $ac < $acmax; $ac++) {
	if ($ac != 0) {
		$GLOBALS['temp']['calendar_data'] .= ",";
	}
	$key = $defaultPropList[$ac];
	$GLOBALS['temp']['calendar_data'] .= "\"" . $key . "\",";
	$GLOBALS['temp']['calendar_data'] .= "\"" . t_encodeOverlib($calPropData[$key]) . "\"";
}

$GLOBALS['temp']['calendar_data'] .= ");\n";
$GLOBALS['temp']['calendar_data'] .= "var selectedProperties = '" . join(":", $calPropList) . "';\n";
$GLOBALS['temp']['calendar_data'] .= "var selectedStatuses = '" . join(":", $calStatusList) . "';\n";
$GLOBALS['temp']['calendar_data'] .= "var propertylistInfo = new Array(\"" . join('","', $calPropNotes) . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var securitygroup = '5';\n";

$rateOut = "var rateData = new Array(";
$afmax = sizeof($defaultRateList);

for ($af = 0; $af < $afmax; $af++) {
	if ($af != 0) {
		$rateOut .= ",";
	}

	$key = $defaultRateList[$af];
	$rateOut .= "\"" . $key . "\",";
	$GLOBALS['temp']['calendar_data'] .= "var rate" . $key . " = new Array(\"" . join('","', $accommRateData[$key]) . "\");\n";
	$rateOut .= "rate" . $key;
}
$rateOut .= ");\n";

$GLOBALS['temp']['calendar_data'] .= $rateOut;
$GLOBALS['temp']['calendar_data'] .= "var calRateId = '" . $calRateList[0] . "';\n";

$calNewPeriodStartDay = "0";

if (!isset ($calNewPeriodStart)) {
	$calNewPeriodStart = "";
}

if ($calNewPeriodStart >= $calStartDate) {
	$calNewPeriodStartDay = substr($calNewPeriodStart, 8, 2);
}

if (!isset ($calAcPeriodEndId)) {
	$calAcPeriodEndId = "";
}

$GLOBALS['temp']['calendar_data'] .= "var calNewPeriodStart = '" . $calNewPeriodStartDay . "';\n";
$GLOBALS['temp']['calendar_data'] .= "var calPrdStart = '" . str_replace("-", "/", $calNewPeriodStart) . "';\n";
$GLOBALS['temp']['calendar_data'] .= "var calNewPrdId = '" . $calAcPeriodEndId . "';\n";
$GLOBALS['temp']['calendar_data'] .= "var calPeriodId = '" . $calAcPeriodId . "';\n";

// Screen output variables ----------------------------------------------------
$GLOBALS['temp']['wizResId'] = (string) $wizResId;
$GLOBALS['temp']['wizLoadContents'] = (string) $wizLoadContents;
$GLOBALS['temp']['wizAgentId'] = (string) $wizAgentId;
$GLOBALS['temp']['masterdb'] = (string) $canCalWizard;

$GLOBALS['temp']['userStatusId'] = (string) $userStatusId;
$GLOBALS['temp']['HaveBizLink'] = (string) "0";
$GLOBALS['temp']['HaveAgnLink'] = (string) "0";
$GLOBALS['temp']['IsPublic'] = (string) "0";

if ($userStatusId > 1) {
	$GLOBALS['temp']['HaveBizLink'] = "1";
}

if ($userStatusId == "1") {
	$GLOBALS['temp']['HaveAgnLink'] = "1";
}

if ($userStatusId == "0") {
	$GLOBALS['temp']['IsPublic'] = "1";
}

(in_array("20", $calStatusList)) ? $GLOBALS['temp']['isProv'] = "1" : $GLOBALS['temp']['isProv'] = "0";
(in_array("15", $calStatusList)) ? $GLOBALS['temp']['isAlloc'] = "1" : $GLOBALS['temp']['isAlloc'] = "0";

$GLOBALS['temp']['canOcc'] = (string) $calEnableOcc;
$GLOBALS['temp']['allowProvs'] = (string) $calAllowProvs;
$GLOBALS['temp']['AgentID'] = (string) $calAgentId;
$GLOBALS['temp']['calAcPeriodId'] = (string) $calAcPeriodId;

($GLOBALS['userid'] == $calAgentId) ? $GLOBALS['temp']['isAgent'] = "1" : $GLOBALS['temp']['isAgent'] = (string) "0";

$GLOBALS['temp']['calLimitDisplay'] = (string) $calLimitDisplay;
$GLOBALS['temp']['calMaxDisplay'] = (string) $calMaxDisplay;

$GLOBALS['temp']['calPropList'] = join(", ", $calPropList);
$GLOBALS['temp']['defaultPropList'] = join(", ", $defaultPropList);
$GLOBALS['temp']['calAccommList'] = join(", ", $calAccommList);
$GLOBALS['temp']['calStatusList'] = join(", ", $calStatusList);
$GLOBALS['temp']['calRateList'] = join(", ", $calRateList);

$sql = "
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type,
		rf_currency
	WHERE
		rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
	AND
		rt_rate_type.rt_rate_type_ix = '" . $calRateList[0] . "'";

$rateData = $GLOBALS['lDB']->get($sql, 1);

$GLOBALS['temp']['rateDesc'] = $rateData[0];
$GLOBALS['temp']['resCurr'] = $rateData[1];
$GLOBALS['temp']['calStartDate'] = (string) $calStartDate;
$GLOBALS['temp']['calEndDate'] = (string) $calEndDate;
$GLOBALS['temp']['mnLeft'] = (string) $startMonthName;
$GLOBALS['temp']['yrLeft'] = (string) $startYear;
$GLOBALS['temp']['mnRight'] = (string) $stopMonthName;
$GLOBALS['temp']['yrRight'] = (string) $stopYear;
$GLOBALS['temp']['weekendList'] = join(", ", $weekendList);
$GLOBALS['temp']['blockRateOverLap'] = $blockRateOverLap;
//$GLOBALS['temp']['rows']             	= $calOutputData;

// Set the form start tag containing the submit action ------------------------
$GLOBALS['temp']['formstart'] = "<form id=\"form7\" name=\"form7\" action=\"" . $GLOBALS[$form]->TargetPage . "?20\" method=\"" . $GLOBALS[$form]->Method . "\" enctype=\"" . $GLOBALS[$form]->Enctype . "\" style=\"margin: 0; padding: 0;\">\n";

$prop_tag = Join(":", $calPropList);

// Set the form submit tag and required hidden fields -------------------------
global $mode;

$value = "";
$GLOBALS['temp']['formsubmit'] = "<input type=\"hidden\" name=\"mode\" value=\"" . $mode . "\">" . "<input type=\"hidden\" name=\"jobid\" value=\"\">" . "<input type=\"hidden\" name=\"record\" value=\"" . $value . "\" disabled>" . "<input type=\"hidden\" name=\"middledate\" value=\"" . $calStartDate . "\" disabled>" . "<input type=\"hidden\" name=\"property_select\" value=\"" . $prop_tag . "\" disabled>" . "<input type=\"hidden\" id=\"status\" name=\"status\" value=\"" . join(":", $calStatusList) . "\">" . "</form>\n";

$GLOBALS[$form]->AddField("form7_resAgentId", "rv_agent_id", $GLOBALS['temp']['fAgentId'], 0);
$GLOBALS['form7_resAgentId']->onChange = "return;";
$GLOBALS['form7_resAgentId']->IsHidden = "1";
$GLOBALS[$form]->AddField("form7_resContactId", "rv_corr_persona_id", $GLOBALS['temp']['fContactId'], 0);
$GLOBALS['form7_resContactId']->IsHidden = "1";
// Phase 5 : END --------------------------------------------------------------

// Phase 6 (Show the itinerary) : START ---------------------------------------
$GLOBALS['temp']['hideItinerary'] = " style=\"display: none;\"";
$GLOBALS['temp']['hideClearItineraryButton'] = " style=\"display: none;\"";
$GLOBALS['temp']['hideApplySpecialsButton'] = " display: none;";
$GLOBALS['temp']['hideSpecialsDisplay'] = " display: none;";
$GLOBALS['temp']['appliedSpecialDesc'] = "";
$GLOBALS['temp']['hideNextStepButton'] = " style=\"display: none;\"";

$GLOBALS['temp']['itinTotal'] = "";
$GLOBALS['temp']['itinComm'] = "";
$GLOBALS['temp']['commText'] = "Commission";
$GLOBALS['temp']['itinFinal'] = "";

$GLOBALS['temp']['iRows'] = "";
$GLOBALS['temp']['wizCalIndex'] = "";
$GLOBALS['temp']['wizCalData'] = "";
$GLOBALS['temp']['isItinerary'] = "0";

$GLOBALS['temp']['rv_split_items'] = "";

// Hide the commission amount on the public calendar --------------------------
$GLOBALS['temp']['publicHideAgentComm'] = "";

if ( $userStatusId == 0 ) {
	$GLOBALS['temp']['publicHideAgentComm'] = "style=\"display: none;\"";
}

if ($wizResId != "") {
	if (!$GLOBALS['lDB']->count("rv_reservation_item", "rv_reservation_id", $wizResId, 0)) {
		$list = $GLOBALS['lDB']->get("select rv_reservation_item_ix from rv_reservation_item where rv_reservation_id = '$wizResId' order by rv_item_date_arrive, ac_accomm_type_id", 3);

		$sql = "
							SELECT
								rt_rate_type.rt_rate_type_desc,
								rf_currency.rf_currency_symbol,
								rv_reservation.rv_invoice_currency_id
							FROM
								rv_reservation
							LEFT JOIN rt_rate_type ON
								rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
							LEFT JOIN rf_currency ON
								rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
							WHERE
								rv_reservation_ix = '" . $wizResId . "'";

		$resData = $GLOBALS['lDB']->get($sql, 1);

		$rf_currency_symbol = $resData['rf_currency_symbol'];

		if (!isset($GLOBALS['temp']['rateDesc']) || $GLOBALS['temp']['rateDesc'] == "") {
			$GLOBALS['temp']['rateDesc'] = $resData['rt_rate_type_desc'];
		}

		if (!isset($GLOBALS['temp']['resCurr']) || $GLOBALS['temp']['resCurr'] == "") {
			$GLOBALS['temp']['resCurr'] = $resData['rf_currency_symbol'];
		}

		if (!isset($GLOBALS['temp']['resCurrId']) || $GLOBALS['temp']['resCurrId'] == "") {
			$GLOBALS['temp']['resCurrId'] = $resData['rv_invoice_currency_id'];
		}

		$temphtml = Join("\n", File(__DIR__ . "/../../../public/html/cal_reservation_item_table_rows.htm"));
		$prevars = array ();
		$wizCalData = array ();
		$rv_split_items = array ();
		$xmax = sizeof($list);

		getSpecialIndicationText($wizResId,0);

		$resRate = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
		for ($x = 0; $x < $xmax; $x++) {
			// Input parameters (for testing purposes) ------------------------------
			$rv_reservation_item_id = $list[$x];

			// Obtain reservation item details --------------------------------------
			$itemId = $list[$x];
			$resItem = getItemDetails($rv_reservation_item_id);

			if ($resItem['rv_item_split_yn'] == "1") {
				array_push($rv_split_items, $rv_reservation_item_id);
			}

			$resItem['rt_rate_type_desc_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($resItem['rt_rate_type_desc'])));
			$special = itemSpecialItinLineIndicator($itemId);
			$resItem['rateLabel'] = "Rte".$special;
			$resItem['rate_text_colour'] = "";
			if($resRate != $resItem['rt_rate_type_id']) {
				$resItem['rateLabel'] = "Ovr".$special;
				$resItem['rate_text_colour'] = "#233f92";
			}
			if($resItem['commPerc'] != $resItem['itemCommPerc']) {
				$resItem['rateLabel'] .= " %";
			}


			$resItem['total'] = getDisplayItemTotal($itemId);
			$resItem['arrive1'] = $resItem['rv_item_date_arrive'];
			$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'], "-");
			$resItem['depart'] = chng_date($resItem['rv_item_date_depart'], "-");
			$resItem['rv_reservation_item_id'] = $rv_reservation_item_id;
			$resItem['hideCompButton'] = "";
			$resItem['allowCompButton'] = "true";
			$resItem['hideRoomButton'] = "";
			$resItem['allowRoomButton']=  "true";

			if ($userStatusId < 2) {
				$resItem['hideCompButton'] = " style=\"visibility: hidden;\"";
				$resItem['allowCompButton'] = "false";

                $resItem['hideRoomButton'] = " style=\"visibility: hidden;\"";
                $resItem['allowRoomButton']=  "false";
			}

			$resItem['hideDelButton'] = "";
			$resItem['allowDelButton'] = "true";

			$resItem['total'] = getDisplayItemTotal($rv_reservation_item_id);
			$resItem['showGoTo'] = "style=\"visibility: hidden;\"";

			if ( $resItem['rv_item_date_arrive'] < $calStartDate || $resItem['rv_item_date_depart'] > $newEndDate && $resItem['rv_item_date_arrive'] != $calStartDate ) {
				$resItem['showGoTo'] = "";
			}

			// Generate the JavaScript array : START --------------------------------
			if (in_array($resItem['ac_accomm_type_id'], $calAccommList)) {
				$ignore = "0";
				$period = $resItem['noNights'];
				$startDate = $resItem['rv_item_date_arrive'];

				if ($resItem['rv_item_date_arrive'] < $calStartDate) {
					$startDate = $calStartDate;
					$buffer = dateSubtract($calStartDate, $resItem['rv_item_date_arrive']);

					if ($buffer >= $resItem['noNights']) {
						$ignore = "1";
					} else {
						$period = $resItem['noNights'] - $buffer;
					}
				}

				$row = "";

				if ($ignore == "0") {
					$list2 = makeDates($startDate . ":" . $calEndDate, $period, "m:d:Y");
					$row = "var RI_" . $rv_reservation_item_id . " = new Array(";

					if (isset($list2[0]) && $list2[0] != "") {
						$lmax = sizeof($list2);

						for ($l = 0; $l < $lmax; $l++) {
							$row .= "\"" . $resItem['ac_accomm_type_id'] . ":" . $list2[$l] . "\",";
						}

						$row .= (string) $resItem['rv_item_accomm_count'] . ");\n";
						$wizCalData["RI_".$rv_reservation_item_id] = $row;
					}
				}
			}
			// Generate the JavaScript Array : END ----------------------------------

			if (isset($prevars['pr_name_last']) && $resItem['pr_name_last'] == $prevars['pr_name_last']) {
				if ($resItem['depart'] == $prevars['depart'] && $resItem['arrive'] == $prevars['arrive']) {
					$resItem['pr_name_last'] = "";
				}
			} else {
				$prevars['pr_name_last'] = $resItem['pr_name_last'];
			}

			$procvars = array (
				"depart",
				"arrive"
			);

			$zmax = sizeof($procvars);

			for ($z = 0; $z < $zmax; $z++) {
				$vali = $procvars[$z];

				if (!isset($prevars[$vali]) || $resItem[$vali] != $prevars[$vali]) {
					$prevars[$vali] = $resItem[$vali];
				} else {
					if ($resItem['pr_name_last'] == "") {
						$resItem[$vali] = "";
					}
				}
			}

			// Rooming info
			$roomList = join(":", $GLOBALS['lDB']->get("SELECT ac_accomm_room_id FROM rv_res_item_group WHERE rv_reservation_item_id = '$rv_reservation_item_id'", 3));
			$roomRequest = $GLOBALS['lDB']->get("
										SELECT
											rv_room_requested_yn,
											rv_room_request_reason
										FROM
											rv_res_item_group
										WHERE
											rv_reservation_item_id = '$rv_reservation_item_id'
									", 1);

			$resItem['roomList'] = $roomList;
			$resItem['requestYN'] = $roomRequest['rv_room_requested_yn'];
			$resItem['requestReason'] = str_replace("<br />", "\\n", t_encodeOverlib($roomRequest['rv_room_request_reason']));

			$resItem['rowClass'] = "txt";
			$result = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_item_comp_edit_yn)
				FROM
					rv_res_item_comp
				WHERE
					rv_item_comp_edit_yn = 1
					AND rv_reservation_item_id = '$rv_reservation_item_id'
			",4);
			if($result > 0){
				$resItem['rowClass'] = "txtbr";
			}

			$resItem['pr_name_last'] = t_encodeHTMLField($resItem['pr_name_last']);
			$resItem['ac_accomm_desc'] = t_encodeHTMLField($resItem['ac_accomm_desc']);
			$resItem['invoice_currency'] = t_encodeHTMLField($resItem['invoice_currency']);
			$GLOBALS['temp']['iRows'] .= showpage($resItem, $temphtml);
			$GLOBALS['temp']['isItinerary'] = "1";
		}

		$GLOBALS['temp']['wizCalData'] = "";
		$keys = array_keys($wizCalData);
		$jmax = sizeof($keys);

		for ($j = 0; $j < $jmax; $j++) {
			$itemId = $keys[$j];
			$GLOBALS['temp']['wizCalData'] .= $wizCalData[$itemId];
		}

		$GLOBALS['temp']['wizCalIndex'] = Join(",", $keys);

		if ($GLOBALS['temp']['iRows'] == "") {
			$GLOBALS['temp']['iRows'] = "
										<tr>
											<td colspan=\"14\" class=\"br bl txt\" align=\"center\">No Items found.</td>
										</tr>";
		}

		$showItinerary = false;

		if ($showAddItinerary) {
			if ($GLOBALS['temp']['isItinerary'] == "1") {
				$showItinerary = true;

				$GLOBALS['temp']['hideItinerary'] = "";
				$GLOBALS['temp']['hideClearItineraryButton'] = "";
				$GLOBALS['temp']['hideNextStepButton'] = "";
			}
		}

		// Totals Display
		$data = getResDocTotals($wizResId, "", "", "", 1);
		$GLOBALS['temp']['itinTotal'] = $data['total_gross'];
		$GLOBALS['temp']['itinComm'] = $data['total_comm'];

		if ($GLOBALS['temp']['itinComm'] < 0) {
			$GLOBALS['temp']['commText'] = "Less Commission";
		}
		$GLOBALS['temp']['itinFinal'] = getDisplayResTotals($wizResId);
	}

	if ($GLOBALS['temp']['iRows'] == "") {
		$GLOBALS['temp']['iRows'] = "
							<tr>\n
								<td colspan=\"14\" class=\"br bb txt\" align=\"center\">Create an item to continue your reservation.</td>\n
							</tr>\n
						";
	}

	$sql = "
				SELECT
		    	rt_rate_type.rt_rate_type_desc,
		      rf_currency.rf_currency_symbol,
		      rv_reservation.rt_rate_type_id,
		      rv_reservation.rv_agent_id,
		      rv_reservation.rv_corr_persona_id,
					rv_reservation.rv_commission_perc,
					rv_reservation.rv_commission_deduct_yn
				FROM
		    	rt_rate_type,
					rf_currency,
					rv_reservation
				WHERE
					rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
				AND
					rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
				AND
					rv_reservation.rv_reservation_ix = '$wizResId'";

	$rateData = $GLOBALS['lDB']->get($sql, 1);
	$GLOBALS['temp']['rateDesc'] = $rateData[0];
	$GLOBALS['temp']['resCurr'] = $rateData[1];
	$GLOBALS['temp']['rateId'] = $rateData[2];
	$GLOBALS['temp']['fAgentId'] = $rateData[3];
	$GLOBALS['temp']['fContactId'] = $rateData[4];
	$GLOBALS['form7_resAgentId']->Value = $GLOBALS['temp']['fAgentId'];
	$GLOBALS['form7_resContactId']->Value = $GLOBALS['temp']['fContactId'];

	if (isset($rv_split_items) && is_array($rv_split_items) && sizeof($rv_split_items) > 0) {
		$GLOBALS['temp']['rv_split_items'] = join(":", $rv_split_items);
	}
}

$GLOBALS['temp']['commPerc'] = "0.00";
$GLOBALS['temp']['commPercDisabled'] = "";
$GLOBALS['temp']['commDeductYes'] = "";
$GLOBALS['temp']['commDeductNo'] = "";
$GLOBALS['temp']['commDeductDisabled'] = "disabled";

$GLOBALS[$form]->AddField("form7_resAgentName", "agent_name", "", 0);

$GLOBALS['form7_resAgentName']->StyleType = "txt";
$GLOBALS['form7_resAgentName']->Size = 18;
$GLOBALS['form7_resAgentName']->onChange = "return;";
$GLOBALS['temp']['showAgentSearchButton'] = "style=\"display: none;\"";
$GLOBALS['temp']['agentNoteButton'] = "style=\"display: none;\"";
$GLOBALS['temp']['hideAgentPopup'] = "";

if ($userStatusId > 0) {
	if ($userStatusId > 1) {
		$GLOBALS['temp']['showAgentSearchButton'] = "";
	}

	$GLOBALS['temp']['agentNoteButton'] = "";

	$name = $lDB->get("
				SELECT
					pr_name_last
				FROM
					pr_persona
				WHERE
					pr_persona_ix = '" . $GLOBALS['form7_resAgentId']->Value . "'
				", 4);

	if ($name == "0") {
		$name = "Direct";
		$GLOBALS['temp']['hideAgentPopup'] = " style=\"visibility: hidden;\"";
		// BUG 5486
		$GLOBALS['temp']['commDeductYes'] = "selected=\"selected\"";
		$GLOBALS['temp']['commDeductNo'] = "";
		// BUG 5486

	} else {
		$commInfo = $lDB->get("
							SELECT
								pr_agent.pr_agent_commission_perc,
								pr_agent.pr_agent_comm_deduct_yn
							FROM
								pr_agent
							WHERE
								pr_agent_id = '" . $GLOBALS['form7_resAgentId']->Value . "'
							", 1);

		if ($customCommPerc != "") {
			$GLOBALS['temp']['commPerc'] = $customCommPerc;
			if ($customCommDeduct == 1) {
				$GLOBALS['temp']['commDeductYes'] = "selected";
			} else {
				$GLOBALS['temp']['commDeductNo'] = "selected";
			}
		} else {
			$GLOBALS['temp']['commPerc'] = $commInfo['pr_agent_commission_perc'];
			if ($commInfo['pr_agent_comm_deduct_yn'] == 1) {
				$GLOBALS['temp']['commDeductYes'] = "selected";
			} else {
				$GLOBALS['temp']['commDeductNo'] = "selected";
			}
		}
		$GLOBALS['temp']['commPercDisabled'] = "";

		$GLOBALS['temp']['commDeductDisabled'] = "";
	}

	$GLOBALS['form7_resAgentName']->Value = $name;

} else {
	$GLOBALS['form7_resAgentName']->Value = "Direct";
}

// Only internal users with financial tab update access may edit commission
$allowCommission = ($GLOBALS['userStatusId'] > 1 && isset($GLOBALS['jobLevelArray'][646]) && $GLOBALS['jobLevelArray'][646] > 5);
if(!$allowCommission) {
	$GLOBALS['temp']['commPercDisabled'] = "disabled";
	$GLOBALS['temp']['commDeductDisabled'] = "disabled";
}
$GLOBALS['temp']['allowCommission'] = ($allowCommission ? "1" : "0");

if ($wizResId != "") {
	$agentCount = $lDB->get("
				SELECT
					COUNT(pr_persona_ix)
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$rateData[rv_agent_id]'
				", 4);

	if ($agentCount > 0) {
		$GLOBALS['temp']['commPerc'] = $rateData['rv_commission_perc'];

		// Reset the base agent deduct comm flag setting
		$GLOBALS['temp']['commDeductYes'] = "";
		$GLOBALS['temp']['commDeductNo'] = "";

		if ($rateData['rv_commission_deduct_yn'] == 1) {
			$GLOBALS['temp']['commDeductYes'] = "selected";
		} else {
			$GLOBALS['temp']['commDeductNo'] = "selected";
		}
	} else {
		// Else it is direct
		// BUG #5486
		$GLOBALS['temp']['commDeductDisabled'] = "";
		$GLOBALS['temp']['commDeductYes'] = "selected='selected'";
		$GLOBALS['temp']['commDeductNo'] = "";
		// BUG #5486
	}
}

$GLOBALS['temp']['showComm'] = "";
$GLOBALS['temp']['showAgentContact'] = "";
$GLOBALS['temp']['heightExternal'] = "";

if ($userStatusId < 2) {
	$GLOBALS['temp']['showComm'] = "class=\"collapse\"";
	$GLOBALS['temp']['showAgentContact'] = "class=\"collapse\"";
	$GLOBALS['temp']['heightExternal'] = "height=\"50\"";
}

$GLOBALS['form7_resAgentName']->Width = "138";

$GLOBALS[$form]->AddField("form7_resContactName", "contact_name", "", 0);

$GLOBALS['form7_resContactName']->StyleType = "txt";
$GLOBALS['form7_resContactName']->Width = "138";
$GLOBALS['temp']['showAgentSearchButton'] = "style=\"display: none;\"";
$GLOBALS['temp']['agentNoteButton'] = "style=\"display: none;\"";

if ($userStatusId > 0) {
	if ($userStatusId > 1) {
		$GLOBALS['temp']['showAgentSearchButton'] = "";
		$displayContactId = $GLOBALS['form7_resContactId']->Value;
	} else {
		$displayContactId = $GLOBALS['userid'];
	}

	$GLOBALS['temp']['agentNoteButton'] = "";

	$name = $lDB->get("select pr_name_first, pr_name_last from pr_persona where pr_persona_ix = '" . $displayContactId . "'",1);

	if(!empty($name) && array_key_exists('pr_name_last', $name)) {
		$nuname = trim($name['pr_name_first'] . " " . $name['pr_name_last']);
	} else {
		$nuname = "";
	}

	if ($nuname == "") {
		$nuname = "No Contact";
	}

	$GLOBALS['form7_resContactName']->Value = $nuname;

} else {
	$GLOBALS['form7_resContactName']->Value = "No Contact";
}

if ($GLOBALS['temp']['iRows'] == "") {
	$GLOBALS['temp']['iRows'] = "
				<tr style=\"height: 25px;\">
					<td colspan=\"14\" class=\"bb br txt\" align=\"center\">No itinerary. Click and drag over dates to build an itinerary.</td>
				</tr>";
}

$GLOBALS['temp']['timer'] = "-1";

if ($GLOBALS['temp']['isItinerary'] == "1") {
	$now = date("U");

	$expiry = explode(" ", $lDB->get("
				SELECT
					rv_create_expiry_date
				FROM
					rv_reservation
				WHERE
					rv_reservation_ix = '$wizResId'
				", 4));

	$temp1 = explode("-", $expiry[0]);
	$temp2 = explode(":", $expiry[1]);
	// echo $temp2[0]."<br />".$temp2[1]."<br />".$temp2[2]."<br />".$temp1[1]."<br />".$temp1[2]."<br />".$temp1[0]."<br />";
	$expire = date("U", mktime($temp2[0], $temp2[1], $temp2[2], $temp1[1], $temp1[2], $temp1[0]));
	$timer = $expire - $now;
	// echo $timer."<br />";

	$GLOBALS['temp']['timer'] = $timer;

}

/* ----------------------------------------------------------------------------
echo "wizLoadContents: ".$wizLoadContents."<br>";
echo "wizAgentId: ".$wizAgentId."<br>";
echo "canCalWizard: ".$canCalWizard."<br>";

echo "userStatusId: ".$userStatusId."<br>";

echo "calEnableOcc: ".$calEnableOcc."<br>";
echo "calAllowProvs: ".$calAllowProvs."<br>";
echo "calAgentId: ".$calAgentId."<br>";
echo "calAcPeriodId: ".$calAcPeriodId."<br>";

echo "calLimitDisplay: ".$calLimitDisplay."<br>";
echo "calMaxDisplay: ".$calMaxDisplay."<br>";

echo "calPropList: ".join(", ",$calPropList)."<br>";
echo "defaultPropList: ".join(", ",$defaultPropList)."<br>";
echo "calAccommList: ".join(", ",$calAccommList)."<br>";
echo "calStatusList: ".join(", ",$calStatusList)."<br>";
echo "calRateList: ".join(", ",$calRateList)."<br>";
echo "defaultRateList: ".join(", ",$defaultRateList)."<br>";

echo "calStartDate: ".$calStartDate."<br>";
echo "calEndDate: ".$calEndDate."<br>";

echo "startMonthName: ".$startMonthName."<br>";
echo "startYear: ".$startYear."<br>";
echo "stopMonthName: ".$stopMonthName."<br>";
echo "stopYear: ".$stopYear."<br>";
echo "weekendList: ".join(", ",$weekendList)."<br>";

'RS21829'
---------------------------------------------------------------------------- */

session_set(array(
	'calStartDate'=>$calStartDate,
	'calEndDate'=>$calEndDate,
	'calPropList'=>$calPropList,
	'calAccommList'=>$calAccommList,
	'calAgentId'=>$calAgentId,
	'calRateList'=>$calRateList,
	'canCalWizard'=>$canCalWizard,
	'userStatusId'=>$userStatusId,
	'blockRateOverLap'=>$blockRateOverLap
));

$GLOBALS['lDB']->isMaster = $tempMasterData;

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];
$GLOBALS['temp']['EUServer'] = $GLOBALS['EUServer'];

$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
$GLOBALS['temp']['divMainStyle'] = "";

if ($userStatusId == "0" && $GLOBALS['pr_sys_code'] == "7") {
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/reservation_calendar.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/reservation_calendar.htm")));
	}
	$indexCSS = "";
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/reservation_calendar.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />";
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/reservation_calendar.css\" type=\"text/css\" />";
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-reservation_cal.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/template-reservation_cal.css\" type=\"text/css\" />";
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/shared/global.css\" type=\"text/css\">";
	} else {
		$indexCSS = "<link rel=\"stylesheet\" href=\"styles/reservation_calendar.css\" type=\"text/css\" />";
	}
	$custom = "";
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/custom.css")) {
		$custom = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/custom.css\" type=\"text/css\">";
	}
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/uikit.min.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/uikit.min.css\" type=\"text/css\" />";
		$indexHTML = "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit.min.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit_image_height.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit-icons.min.js"));
		$indexHTML .= "</script>";
		$GLOBALS['temp']['customHTML'] .= $indexHTML;
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-reservation_cal.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/ui-kit/uikit.min.css\" />";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js\"></script>\n";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js\"></script>\n";
	} else {
		$uikitCSS = "";
	}

	$GLOBALS['temp']['customDefaultCSS'] = "
		$uikitCSS
		$indexCSS
		$custom
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Don't include anything extra if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customDefaultCSS'] = "
			<style>
				body {
					background-color: transparent !important;
				}
			</style>
		";
		$GLOBALS['temp']['divMainStyle'] = "min-height: 800px";
	}
} else {
	$GLOBALS['temp']['customDefaultCSS'] = "";
}
