<?php
/*
 * $Id: init.form70.php,v 1.10 2011-05-17 14:08:34 light Exp $
 *
 * $Log: init.form70.php,v $
 * Revision 1.10  2011-05-17 14:08:34  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.9  2007-02-07 18:22:26  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.8  2006-11-17 14:31:12  light
 * Code cleanup
 *
 * Revision 1.7  2006-11-08 14:19:31  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.6  2004-11-22 08:42:46  light
 * Copy REL_3_2_3 -> HEAD
 *
 * Revision 1.4.54.1  2004/10/20 11:03:15  light
 * Fixes to access control / etc
 *
 * Revision 1.4  2004/04/22 15:53:06  light
 * Bug #2133 - Access Control
 *
 * Revision 1.3  2004/04/19 12:31:04  tvdspuy
 * Saveclose change
 *
 * Revision 1.2  2004/02/20 09:41:35  light
 * Cleaned up code
 *
 */

/**
 * init.form70.php - Access control functions popup
 * Job: 160
 * Function: 65 (Access control)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/access_functions.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

if(isMasterDB() && checkJob(148)) {
	$GLOBALS['temp']['allowSave'] = "button";
	$GLOBALS['temp']['buttonCloseName'] = "Cancel";
	$allowEdit = true;
} else {
	$GLOBALS['temp']['allowSave'] = "collapse";
	$GLOBALS['temp']['buttonCloseName'] = "Close";
	$allowEdit = false;
}

#--------------------------------------------
# Get all selection filters/parameters
#--------------------------------------------
$jobid = $_SERVER['argv'][0];
$sc_group_id = $_SERVER['argv'][1];
$functionAccess = $_SERVER['argv'][2];
$closeonsave = $_SERVER['argv'][3];

$GLOBALS['temp']['sc_group_id'] = $sc_group_id;

$functionValues = explode(":",$functionAccess);

$result = $GLOBALS['lDB']->get("SELECT sc_grp_code, sc_grp_desc FROM sc_group WHERE sc_group_id = '$sc_group_id'",1);
$GLOBALS['temp']['sc_grp_code'] = $result['sc_grp_code'];
$GLOBALS['temp']['sc_grp_desc'] = $result['sc_grp_desc'];

###########################
# Get list of all functions
###########################
$functionSql = "
	SELECT
		sc_function_id,
		sc_fun_desc
	FROM
		sc_function
	WHERE
		sc_fun_sys_code < '9'
	ORDER BY
		sc_fun_desc
";

$functions = array();
$functions = $GLOBALS['lDB']->get($functionSql,"2");
$rownum = sizeof($functions);

#######################
#  Set up result array
#######################

$functionArray = array();
##############################################
#  LOOP thru functions to obtain access levels
##############################################

for ($i = 0; $i < $rownum; $i++) {
	$functionArray[$i]['sc_function_id'] = $functions[$i]['sc_function_id'];
	$sc_function_id = $functions[$i]['sc_function_id'];
	$functionArray [$i]['sc_fun_desc'] = $functions[$i]['sc_fun_desc'];

	############################
	#  Get linked access levels
	############################

	$levelSql = "
		SELECT
			sc_fun_grp_level
		FROM
			sc_fun_group
		WHERE
			sc_function_id = '$sc_function_id'
			AND sc_group_id = '$sc_group_id'
	";
	$levelArray = $GLOBALS['lDB']->get($levelSql,"1");
	$level = $levelArray[0];

	$functionArray[$i]['none_checked'] = "";
	$functionArray[$i]['read_checked'] = "";
	$functionArray[$i]['update_checked'] = "";
	$functionArray[$i]['management_checked'] = "";
	switch ($level) {
	case 5:
		$functionArray[$i]['read_checked'] = "checked";
		break;
	case 10:
		$functionArray[$i]['update_checked'] = "checked";
		break;
	case 15:
		$functionArray[$i]['management_checked'] = "checked";
		break;
	default:
		$functionArray[$i]['none_checked'] = "checked";
	}
	$functionArray[$i]['sc_fun_grp_level'] = $level;
}

#---------------------------------------------------------------------#
# End of Mike's SQL code                                              #
# $group_details contains array of rows for display                   #
#---------------------------------------------------------------------#

switch ($jobid) {
case 161:
	$userAccessAuditTrail = new AuditTrail($sc_group_id,TYPE_USERACCESS);
	for($i=0;$i<sizeof($functionValues);$i++) {
		$functionArray [$i]['none_checked'] = "";
		$functionArray [$i]['read_checked'] = "";
		$functionArray [$i]['update_checked'] = "";
		$functionArray [$i]['management_checked'] = "";
		switch ($functionValues[$i]) {
		case "read":
			$level = 5;
			$functionArray [$i]['read_checked'] = "checked";
			$levelText = 'Read';
			break;
		case "update":
			$level = 10;
			$functionArray [$i]['update_checked'] = "checked";
			$levelText = 'Update';
			break;
		case "management":
			$level = 15;
			$functionArray [$i]['management_checked'] = "checked";
			$levelText = 'Management';
			break;
		default:
			$level = 0;
			$functionArray [$i]['none_checked'] = "checked";
			$levelText = 'None';
			break;
		}

		# Check is a record already exists

		$sc_function_id = $functionArray[$i]['sc_function_id'];
		$recordExistsSQL = "SELECT count(*) FROM sc_fun_group WHERE sc_function_id = '$sc_function_id' AND sc_group_id = '$sc_group_id'";
		$Result = $GLOBALS['lDB'] -> get($recordExistsSQL,1);
		$recordExists = $Result[0];

		// Audit trail
		if ($recordExists) {
			$existingLevelText = $GLOBALS['lDB']->get("
				SELECT
					(CASE
						WHEN sc_fun_group.sc_fun_grp_level = 5 THEN 'Read'
						WHEN sc_fun_group.sc_fun_grp_level = 10 THEN 'Update'
						WHEN sc_fun_group.sc_fun_grp_level = 15 THEN 'Management'
						ELSE 'None'
					END)
				FROM
					sc_fun_group
				WHERE
					sc_function_id = '$sc_function_id'
					AND sc_group_id = '$sc_group_id'
			",4);
		} else {
			$existingLevelText = 'None';
		}
		$functionDesc = $GLOBALS['lDB']->get("
			SELECT
				sc_fun_desc
			FROM
				sc_function
			WHERE
				sc_function_id = '$sc_function_id'
		",4);

		if ($existingLevelText != $levelText) {
			$userAccessAuditTrail->addDetail(
				$functionDesc . ": " . $existingLevelText,
				$functionDesc . ": " . $levelText,
				"sc_fun_grp_level",
				"sc_fun_grp_level",
				2,
				"useraccess",
				"sc_fun_group.sc_fun_grp_level"
			);
		}
		// End of Audit trail

		# If a record exists and level = none (0) then delete record
		#    else insert record
		$groupSQL = "";
		if (checkJob(148)) {
			if($recordExists) {
				if($level > 0) {
					$groupSQL = "UPDATE sc_fun_group SET sc_fun_grp_level = $level WHERE sc_function_id = '$sc_function_id' AND sc_group_id = '$sc_group_id'";
					$Result = $GLOBALS['lDB']->put($groupSQL);
				} else {
					$list = $GLOBALS['lDB']->get("select sc_fun_group_id from sc_fun_group where sc_function_id = '$sc_function_id' AND sc_group_id = '$sc_group_id'",3);
					foreach ($list as $fun_group) {
						$groupSQL = "DELETE FROM sc_fun_group WHERE sc_fun_group_id = '$fun_group'";
						$Result = $GLOBALS['lDB']->put($groupSQL);
					}
				}
			} else {
				if($level > 0) {
					$groupSQL = "INSERT INTO sc_fun_group (sc_function_id, sc_group_id, sc_fun_grp_level) VALUES ('$sc_function_id', '$sc_group_id', '$level')";
					$Result = $GLOBALS['lDB']->put($groupSQL);
				} else {
					$list = $GLOBALS['lDB']->get("select sc_fun_group_id from sc_fun_group where sc_function_id = '$sc_function_id' AND sc_group_id = '$sc_group_id'",3);
					foreach ($list as $fun_group) {
						$groupSQL = "DELETE FROM sc_fun_group WHERE sc_fun_group_id = '$fun_group'";
						$Result = $GLOBALS['lDB']->put($groupSQL);
					}
				}
			}
		}
	}
	$adUseraccessId = $userAccessAuditTrail->save("User Access (Function Access)");
	break;
}

if ($closeonsave == "1") {
	$GLOBALS[$form]->FormHTML = "<body ><script>opener.reloadPage(); window.close();</script></body>";
}

# Generate HTML output
$GLOBALS['temp']['rows'] = "";
$rowsout = "";
for($i=0;$i<$rownum;$i++) {
	$row_array = $functionArray[$i];
	$temphtml = Join("",File(__DIR__ . "/../../../public/html/access_functions_row.htm"));
	if($allowEdit) {
		$row_array['rowDisable'] = "";
	} else {
		$row_array['rowDisable'] = "disabled";
	}
	$row = showpage($row_array,$temphtml);
	$rowsout .= $row;
}

$GLOBALS['temp']['rows'] = $rowsout;

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

/* Clear out the cache */
cacheClear();
